<?php 

function loop_query( $args, $filtrar_por_categorias_usuario = true )
{
	ob_start();	
	$args['nopaging']=true;
	$now = new DateTime('NOW');	
	$condicion1=false;
	if(isset($args['post__in']) && !count($args['post__in']))$condicion=true;
	$max_days = intval(get_option('ainia_max_days'));
	$max_posts = intval(get_option('ainia_max_posts'));
	$cuantos = 0;
	$last_plazo = "";
	if(!$filtrar_por_categorias_usuario)
	 remove_filter('pre_get_posts', array("User_Categories", 'filtrar_por_concepto'));
	$the_query = new WP_Query( $args ); 	
	if ( $the_query->have_posts() && !$condicion1 ) {
		while ( $the_query->have_posts() ) {
			$the_query->the_post();
			$day = new DateTime(get_the_date('d-m-Y'));	
			$dif = $day->diff($now);
			$condicion1 = $max_days ? $dif->days<$max_days : true ;
			$condicion2 = $max_posts ? $cuantos<$max_posts : true ;
			$condicion3 = $filtrar_por_categorias_usuario ? is_post_in_user_categories(get_the_ID()) : true;	
			if($condicion3 && $condicion1 && $condicion2)
			{											
					 if($dif->days >= 365 )$plazo="Hace más de un año";
				else if($dif->days >= 60  )$plazo="Hace más de dos meses";
				else if($dif->days >= 31  )$plazo="Hace más de un mes";
				else if($dif->days >= 14  )$plazo="Hace más de dos semanas";
				else if($dif->days >= 7   )$plazo="Hace más de una semana";
				else if($dif->days >= 3   )$plazo="Durante la última semana";
				else if($dif->days == 2   )$plazo="Anteayer";
				else if($dif->days == 1   )$plazo="Ayer";				
				else $plazo="Hoy";							
				if($plazo != $last_plazo){
					echo "<h3 class='date-separator'>".$plazo."</h3>"; 
					$last_plazo = $plazo;
					}
			    get_template_part( 'content', get_post_format() );
				$cuantos+=1;
			}		
		}
	} 
	
	if(!$cuantos) get_template_part( 'all-read', 'index' );
	
	wp_reset_postdata();	
	$buffer = ob_get_contents();
	ob_end_clean();	
	return $buffer;
}

add_shortcode('recomendaciones', 'mostrar_recomendaciones');
function mostrar_recomendaciones( $atts, $content = null  ) 
{		
	$recs = get_object_ids_of_user_relation(get_current_user_id(),"recommended");	
	if($recs)
	     return loop_query( array('post__in'=>$recs) , false );	
	else return get_template_part( 'all-read', 'index' );	
}

add_shortcode('favoritos', 'mostrar_favoritos');
function mostrar_favoritos( $atts, $content = null  ) 
{
	$recs = get_object_ids_of_user_relation(get_current_user_id(),"favorite");
	if($recs)
	     return loop_query( array('post__in'=>$recs) , false );	
	else return get_template_part( 'all-read', 'index' );		
}

add_shortcode('no_leidos', 'no_leidos');
function no_leidos( $atts, $content = null  ) 
{	
	$mi_lectura = get_objects_of_user_relation( get_current_user_id(), "browse") ;
	$recs = array();
	foreach($mi_lectura as $articulo)
	 $recs[]=$articulo->object_id;
	return loop_query( array('post__not_in'=>$recs) );	
}

add_shortcode('mas_leidos', 'mas_leidos');
function mas_leidos( $atts, $content = null  ) 
{	
	$mi_lectura = get_objects_of_user_relation(get_current_user_id(),"browse");	
	$recs = array();	
	foreach($mi_lectura as $articulo)
	 $recs[]=$articulo->object_id;
	
	if($recs)
	     return loop_query( array('post__in'=>$recs) , false );	
	else return get_template_part( 'all-read', 'index' );		
}





