<?php 

// http://shibashake.com/wordpress-theme/custom-post-type-permalinks-part-2 

add_action("init","iniciar_taxonomia_fuente");
function iniciar_taxonomia_fuente()
{
		register_taxonomy('fuente', array('post'), array(
			  'public'      =>true,
			  'labels'      =>array(
				  'name'                        =>__('Source','ainia'),					
				  'menu_name'                   =>__('Sources','ainia'),
				  'singular_name'               =>__('Source','ainia'),								
				  'search_items'                =>__('Search by Source','ainia'),
				  'popular_items'               =>__('Popular Sources','ainia'),
				  'all_items'                   =>__('All Sources','ainia'),
				  'edit_item'                   =>__('Edit Source','ainia'),
				  'update_item'             	=>__('Update Source','ainia'),
				  'add_new_item'                =>__('Add Source','ainia'),
				  'new_item_name'               =>__('New Source Name','ainia'),
				  'separate_items_with_commas'	=>__('Separate sources with commas','ainia'),
				  'add_or_remove_items'     	=>__('Add or remove sources','ainia'),
				  'choose_from_most_used'       =>__('Choose from most used source','ainia'),
			  ),
			  'hierarchical' =>false,
			  'rewrite'     =>array(
				  'with_front'              	=>true,
				  'slug'                    	=>'fuente',
			  ),
			  
		));	
		
		register_taxonomy('proyecto', array('post'), array(
			  'public'      =>true,
			  'labels'      =>array(
				  'name'                        =>__('Project','ainia'),					
				  'menu_name'                   =>__('Projects','ainia'),
				  'singular_name'               =>__('Project','ainia'),								
				  'search_items'                =>__('Search by Project','ainia'),
				  'popular_items'               =>__('Popular Projects','ainia'),
				  'all_items'                   =>__('All Projects','ainia'),
				  'edit_item'                   =>__('Edit Project','ainia'),
				  'update_item'             	=>__('Update Project','ainia'),
				  'add_new_item'                =>__('Add Project','ainia'),
				  'new_item_name'               =>__('New Project Name','ainia'),
				  'separate_items_with_commas'	=>__('Separate Projects with commas','ainia'),
				  'add_or_remove_items'     	=>__('Add or remove Projects','ainia'),
				  'choose_from_most_used'       =>__('Choose from most used Project','ainia'),
			  ),
			  'hierarchical' =>false,
			  'rewrite'     =>array(
				  'with_front'              	=>true,
				  'slug'                    	=>'proyecto',
			  ),
			  
		));	
}

//------------- EDITAR METABOXES DEL TIPO POST PARA AÑADIR LA FUENTE ---------------------------------------------------------------

add_action( 'admin_menu', 'fuente_remove_meta_box',20);  
function fuente_remove_meta_box()
{  
	//remove_meta_box('categorydiv'       );
	//remove_meta_box('commentsdiv'       );	
	//remove_meta_box('submitdiv'         );
	//remove_meta_box('tagsdiv-post_tag'  );
	
	remove_meta_box('slugdiv'          			, 'post', 'normal' );
	remove_meta_box('tagsdiv-fuente'			, 'post', 'normal');  
	remove_meta_box('stl-timeline-event-data'	, 'post', 'advanced');  
	remove_meta_box('authordiv' 				, 'post', 'normal');
	remove_meta_box('commentstatusdiv' 		, 'post', 'normal');
	remove_meta_box('formatdiv'   				, 'post', 'normal');
	remove_meta_box('pageparentdiv'     		, 'post', 'normal');
	remove_meta_box('postcustom'        		, 'post', 'normal');
	remove_meta_box('postexcerpt'       		, 'post', 'normal');	
	remove_meta_box('revisionsdiv'      		, 'post', 'normal');
	remove_meta_box('trackbacksdiv'     		, 'post', 'normal');
}  

add_action('do_meta_boxes','my_post_remove_meta_box',1);  
function my_post_remove_meta_box()
{  
	remove_meta_box('postimagediv', 'post', 'side');
	//remove_post_type_support( 'post', 'post-thumbnail' );
}

add_action( 'add_meta_boxes', 'add_post_fuente_metabox_event' );
function add_post_fuente_metabox_event()
{
	add_meta_box( 'post-fuente-metabox-id', 'Fuente', 'add_post_fuente_metabox', 'post', 'normal', 'high' );
}

function add_post_fuente_metabox( $post )
{
	$fuentes_posts = get_the_terms( $post->ID, 'fuente');
	$id_fuente = count($fuentes_posts) ? $fuentes_posts[0]->term_id : 0;
	
	$interes = get_post_meta( $post->ID, 'interes', true );
	$url_article = get_post_meta( $post->ID, 'url_article', true );
	$fuentes = get_terms("fuente", array('hide_empty'=>false));
	wp_nonce_field( 'my_post_fuente_metabox_nonce', 'my_post_fuente_metabox_nonce' );
	?>
	<p>
		<label for="fuente"><?php _e('Source','ainia');?></label>
		<select name="fuente" id="fuente">
			<option value=""> - no catalogada - </option>
		<?php foreach($fuentes as $fuente){?>
			<option value="<?php echo $fuente->term_id?>" <?php selected( $fuente->term_id, $id_fuente ); ?>><?php echo $fuente->name?></option>
		<?php }?>			
		</select>
	</p>	
	<p>
		<label for="url_article"><?php _e('Original Article URL','ainia');?></label>
		<input type="text" name="url_article" id="url_article" size="100" value="<?php echo $url_article; ?>" />
		<?php if($url_article) echo " <a href='".$url_article."' target='_blank'>".__("View","ainia")."</a>"; ?>
	</p>
	<p>
		<label for="article_interest"><?php _e('Article Interest','ainia');?></label>		
		<select name="article_interest">
			<option value="1" <?php selected( '1', $interes ); ?>>1</option>			
			<option value="2" <?php selected( '2', $interes ); ?>>2</option>			
			<option value="3" <?php selected( '3', $interes ); ?>>3</option>			
			<option value="4" <?php selected( '4', $interes ); ?>>4</option>			
			<option value="5" <?php selected( '5', $interes ); ?>>5</option>			
		</select>
	</p>
	<p>
		<label for="original_date"><?php _e('Original Date','ainia');?></label>		
        : <strong><?php echo get_post_meta($post->ID,'original_date',true);?></strong>
    </p>
	<?php	
}


add_action( 'save_post', 'save_post_fuente_metabox' );
function save_post_fuente_metabox( $post_id )
{
	// Bail if we're doing an auto save
	if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
	
	// if our nonce isn't there, or we can't verify it, bail
	if( !isset( $_POST['my_post_fuente_metabox_nonce'] ) || !wp_verify_nonce( $_POST['my_post_fuente_metabox_nonce'], 'my_post_fuente_metabox_nonce' ) ) return;
		
	// if our current user can't edit this post, bail
	if( !current_user_can( 'edit_post' ) ) return;	
	
	
	if( isset( $_POST['fuente'] ) )
		wp_set_object_terms( $post_id, intval( $_POST['fuente'] ) , 'fuente', false);
		
	if( isset( $_POST['url_article'] ) )
		update_post_meta( $post_id, 'url_article', esc_attr( $_POST['url_article'] ) );
		
	if( isset( $_POST['article_interest'] ) )
		update_post_meta( $post_id, 'interes', esc_attr( $_POST['article_interest'] ) );
	
}


//--------------------- AÑADIR CAMPOS A LA TAXONOMIA -------------------------------------------------------------
add_action('fuente_add_form_fields', 'fuente_metabox_add', 10, 1);
function fuente_metabox_add($tag) { 
?>	
    <div class="form-field">
        <label for="fuente_url"><?php _e('URL','ainia'); ?></label>
        <input name="fuente_url" id="fuente_url" type="text" value="" size="40" aria-required="true" />
    </div>    
<?php }   

function get_fuente_url($term_id)
{
	return get_option('fuente_url_'.$term_id);	
}  

add_action('fuente_edit_form_fields', 'fuente_metabox_edit', 10, 1);    
function fuente_metabox_edit($tag) { 
	$url = get_fuente_url($tag->term_id);
?>
	<table class="form-table">
        <tr class="form-field">
        <th scope="row" valign="top">
            <label for="fuente_url"><?php _e('URL','ainia'); ?></label>
        </th>
        <td>
            <input name="fuente_url" id="fuente_url" type="text" value="<?php echo $url;?>" size="40" aria-required="true" />
			<?php if($url)echo '<br/> &nbsp; <a href="'.$url.'" target="_blank">'.__('View','ainia').'</a>';?>
        </td>
        </tr>				
    </table>
<?php }

add_action('created_fuente', 'save_fuente_metadata', 10, 1);    
add_action('edited_fuente', 'save_fuente_metadata', 10, 1);
function save_fuente_metadata($term_id)
{
	if (!$term_id)return;	    
	if ( isset( $_POST['fuente_url'] ) ) 
		update_option( 'fuente_url_'.$term_id, $_POST['fuente_url'] );		
}

//----------------------------------------------------------...
//AJUSTAR LA FECHA DE LOS POSTS

add_filter( 'wp_insert_post_data', 'filtrar_fecha', '99', 2 );
function filtrar_fecha( $data , $postarr ) 
{ 
  //print_r($postarr);  die(1);
  if($postarr['original_post_status']=="draft" && $postarr['post_status']=="publish"){
	$data['post_date']=$postarr['post_modified'];
	$data['post_date_gmt']=$postarr['post_modified'];
  }
  return $data;
}




add_action( 'save_post', 'filtrar_fecha_3' );
function filtrar_fecha_3( $post_id ) 
{	
	remove_action( 'save_post', 'filtrar_fecha_3' );
	$post = get_post( $post_id );
	$fecha = get_post_meta($post_id,'original_date',true);	
	if($fecha){		
		$new_values = array (
				'ID' => $post_id,
				'post_date' => $fecha,
				'post_date_gmt' => $fecha,
			);
		wp_update_post( $new_values );
		}	  
	add_action( 'save_post', 'filtrar_fecha_3' );
}