<?php /*
Plugin Name: User Categories
Plugin URI: http://wordpress.org/extend/plugins/user-categories-2
Description:  Allows users to assign categories to user with a clean and simplified, filterable category meta box and use shortcodes to display category galleries
Version: 1.5
Author: Eddie Moya
Author URL: http://eddiemoya.com
*/

class User_Categories {
    public static $version = 1.5;
    public static $instances;
    public $taxonomy;
    
    /**
     * While normally run statically, this allows 
     * @param type $taxonomy 
     */
    public function __construct($taxonomy) {
        global $wp_version;
        // Store each instance of this class (for use when localizing scripts)
        $this->taxonomy = $taxonomy;
        self::$instances[] = $this;
        
        add_action('init', array(&$this, 'register_user_categories'));
		add_filter('pre_get_posts', array(__CLASS__, 'filtrar_por_concepto'));
		
		add_action('admin_menu', array(&$this, 'add_user_menu_categories'));
        add_action('wp_enqueue_media', array(__CLASS__, 'enqueue_user_categories_scripts'));
               
		add_action('show_user_profile',	array(&$this, 'user_categories_metabox'));
		add_action('edit_user_profile', array(&$this, 'user_categories_metabox'));
		add_action('personal_options_update',	array(__CLASS__, 'save_profile'));
		add_action('edit_user_profile_update',	array(__CLASS__, 'save_profile'));
	   
    }

    /**
     * Enqueue javascript
     */
    function enqueue_user_categories_scripts() {
        global $wp_version;

        if (is_admin()) {
            
            // Get each instance of this class, and pass each taxonomy in to javascript
            foreach (self::$instances as $instance){
                $tax[] = apply_filters('mc_taxonomy', $instance->taxonomy);
            }
                
            $filename = 'user-categories-script.js';

            wp_register_script('user_categories_metabox_script', plugins_url($filename, __FILE__));
            wp_enqueue_script('user_categories_metabox_script');
            
            wp_localize_script('user_categories_metabox_script', 'taxonomy',  $tax);
        }
    }

    function register_user_categories() {
        $tax_name = apply_filters('mc_taxonomy', $this->taxonomy);        
        register_taxonomy_for_object_type($tax_name, 'user');		
    }
	
	function add_user_menu_categories(){
		add_users_page(
				__("Categories"), 
				__("Categories"), 
				'manage_options', 
				"edit-tags.php?taxonomy=category"
			);	
	}

   
   
    function user_categories_metabox($user) {
        
        require_once(plugin_dir_path(__FILE__) . 'user-walker-category-checklist-class.php');
             
        $taxonomy = "category";
        
        $tax = get_taxonomy($taxonomy);
        ?>
		<div class="user-category" style="margin:20px">
        
        <div id="taxonomy-<?php echo $taxonomy; ?>" class="categorydiv">
		
			<?php if(current_user_can("edit_users")):?>
			<div class="taxonomy-metabox-field-container">
				<label class='category-filter' for="category-filter"><?php echo __('Search').' '.$tax->labels->name; ?>:</label>
				<input id='<?php echo $taxonomy?>-search' name="category-filter" type='text' />
			</div>
			<?php else:?>
				 <h4><?php _e("You has been assigned these categories:","ainia")?></h4>
			<?php endif;?>
            
            <div id="<?php echo $taxonomy; ?>-all" >
                <?php $name = ( $taxonomy == 'category' ) ? 'post_category' : 'tax_input[' . $taxonomy . ']'; ?>
                
                <ul id="<?php echo $taxonomy; ?>checklist" class="list:<?php echo $taxonomy ?> <?php echo $taxonomy; ?>checklist form-no-clear">
                    <?php $custom_walker = new User_Walker_Category_Checklist; 						  
						  if(current_user_can("edit_users")){
							$selected_cats = wp_get_object_terms($user->ID, 'category', array('fields'=>'ids'));											  						  
							wp_terms_checklist(0, array('taxonomy' => $taxonomy, 'selected_cats'=>$selected_cats,'walker' => $custom_walker)) ;
							}
						  else {
							$selected_cats = wp_get_object_terms($user->ID, 'category', array('fields'=>'all'));											  						  							
							foreach($selected_cats as $cat)echo "<li>".$cat->name."</li>";														
							}
						
						?>
                </ul>
            </div>
        </div>		
		</div>
            <?php
    }

    
    public function save_profile($user_id) 
	{
		$taxonomy="category";
		
		if(!current_user_can('edit_users') && current_user_can($taxonomy->cap->assign_terms)) return false;
		
		$term = $_POST["post_category"];		
		for($t=0;$t<count($term);$t++)$term[$t]=esc_attr($term[$t]);				
		wp_set_object_terms($user_id, $term, "category", false);
		clean_object_term_cache($user_id, "category");		
	}
	
    
	function filtrar_por_concepto( $query ) 
	{   
		//Esta funcion la he desactivado porque tiene efectos raros cuando no es la home
		if( !is_admin() ) {
				
			if ( $query->query['post_type'] || !$query->is_home ) {
				//Solo filtra la home
				return $query;
			}        
					
			$user_ID = get_current_user_id();  // get the current user ID
			if ( !is_user_logged_in() || !$user_ID || $user_ID < 1) {
				return $query;
			}       			
		
			$query->set('category__in', get_user_categories($user_ID) );
		
			return $query;
		}
		return $query;
	}
    
}

$mc_category_metabox = new User_Categories('category');

function get_user_categories($user_id=0){
	if(!$user_id)$user_id = get_current_user_id();
	$terms = wp_get_object_terms($user_id, 'category');
	$conceptos = array();
	foreach($terms as $term)$conceptos[]=$term->term_id;
	return $conceptos;
}

function is_post_in_user_categories($post_id,$user_id=0){
	$post_cats = wp_get_post_categories( $post_id );
	$user_cats = get_user_categories($user_id);
	foreach($post_cats as $cat)
	 if(in_array($cat,$user_cats))
	  return true;
	return false;
}
