<?php

/*
*  ACF Message Field Class
*
*  All the logic for this field type
*
*  @class 		acf_field_message
*  @extends		acf_field
*  @package		ACF
*  @subpackage	Fields
*/

if( ! class_exists('acf_field_obs') ) :

class acf_field_obs extends acf_field {
	
	
	/*
	*  __construct
	*
	*  This function will setup the field type data
	*
	*  @type	function
	*  @date	5/03/2014
	*  @since	5.0.0
	*
	*  @param	n/a
	*  @return	n/a
	*/
	
	function __construct() {
		
		// vars
		$this->name = 'obs';
		$this->label = __("Embedded WP Excerpt+Content",'acf-frontend-forms');
		$this->category = 'layout';
		$this->defaults = array(
			'obs'	=> '',
		);
		
		
		// do not delete!
    	parent::__construct();
	}
	
	function render_field_settings( $field ) {
		
		// default_value
		acf_render_field_setting( $field, array(
			'label'			=> __('Div identifiers','acf-frontend-forms'),
			'instructions'	=> __('Please white here WP elements as #postdivrich you want move here.','acf-frontend-forms'),
			'type'			=> 'text',
			'name'			=> 'divs',
		));
		
	}
	/*
	*  render_field()
	*
	*  Create the HTML interface for your field
	*
	*  @param	$field - an array holding all the field's data
	*
	*  @type	action
	*  @since	3.6
	*  @date	23/01/13
	*/
	
	function render_field( $field ) {	
		?>
		   
			<div id="wpobs<?php echo $field['_name']?>"></div>
			<script>
				jQuery( document ).ready(function( $ ) {
				<?php
				    $divs = $field['divs'];
					if(!$divs)$divs="#postdivrich,#postexcerpt";
					foreach(explode(',',$divs) as $div)
					 echo  'jQuery("body").find("'.$div.'").remove().appendTo("#wpobs'.$field['_name'].'");'	
				?>
				});
			</script>
		
		<?php
	}	
}

new acf_field_obs();

endif;

?>