<?php


add_shortcode('entradas_borradas', 'mostrar_entradas_borradas');
function mostrar_entradas_borradas( $atts, $content = null  )
{
	$recs = get_object_ids_of_user_relation(get_current_user_id(),"delete");
	if($recs)

		return loop_query( array('post__in'=>$recs,'post_type'=>array('post')) , false,true );
		else return get_template_part( 'all-read', 'index' );
}

function get_color_sequence(){
	$my_theme=wp_get_theme();
	$name=$my_theme->get( 'Name' ) ;
	$colors =array('#330000','#660000','#990000','#b30000','#e60000','#ff3333','#ff6666','#ff9999','#ffb3b3','#ffcccc');
	
	if (strpos($name, 'incrustado') !== false) {
		$colors=array('#01B8AA', '#374649', '#F2C80F', '#FD625E', '#A66999', '#DFBFBF', '#8AD4EB', '#FE9666', '#5F6B6D', '#AD514A', '#7BB252');
		
	} else {
		$colors=array('#41160b','#6d2512','#832c16','#ae3b1e','#da4925','#e16e51','#e58066','#eda492','#f0b6a8',' #f8dbd3');
	}
	return $colors;
}

function get_positive_color_sequence(){
	$colors=array('#001a00','#003300','#004d00','#008000','#009900','#00cc00','#00e600','#1aff1a','#66ff66',' #99ff99');
	return $colors;	
}
function get_negative_color_sequence(){
	$colors=array('#41160b','#6d2512','#832c16','#ae3b1e','#da4925','#e16e51','#e58066','#eda492','#f0b6a8',' #f8dbd3');
	return $colors;
}

add_shortcode('recomendaciones', 'mostrar_recomendaciones');
function mostrar_recomendaciones( $atts, $content = null  )
{
	$recs = get_object_ids_of_user_relation(get_current_user_id(),"recommended");
	//echo sizeof($recs);
	if($recs)
		return loop_query( array('post__in'=>$recs,'post_type'=>array('post','project')) , false );
		else return get_template_part( 'no_recomendations', null );
}

add_shortcode('favoritos', 'mostrar_favoritos');
function mostrar_favoritos( $atts, $content = null  )
{
	$recs = get_object_ids_of_user_relation(get_current_user_id(),"favorite");
	if($recs)
		return loop_query( array('post__in'=>$recs,'post_type'=>array('post','project')) , false );
		else return get_template_part( 'all-read', 'index' );
}
add_shortcode('borrados', 'mostrar_borrados');
function mostrar_borrados( $atts, $content = null  )
{
	$recs = get_object_ids_of_user_relation(get_current_user_id(),"delete");
	if($recs)
		return loop_query( array('post__in'=>$recs,'post_type'=>array('post','project')) , false );
		else return get_template_part( 'all-read', 'index' );
}

function loop_query( $args, $filtrar_por_categorias_usuario = true,  $mostrar_borrados = false ,$pagina='page')
{

	ob_start();
	$args['nopaging']=false;
	$args['posts_per_page']=1000;
	$args['date_query']   = array(
			'column'  => 'post_date',
			'after'   => '- 180 days'
	);
	$args['no_found_rows']=true;
	$now = new DateTime('NOW');
	$condicion1=false;
	if(isset($args['post__in']) && !count($args['post__in']))$condicion=true;
	//$max_days = intval(get_option('ainia_max_days'));
//$max_posts = intval(get_option('ainia_max_posts'));
	$cuantos = 0;
	$last_plazo = "";
	if(!$filtrar_por_categorias_usuario)
	 remove_filter('pre_get_posts', array("User_Categories", 'filtrar_por_concepto'));
	 $the_query = new WP_Query( $args );
	 //echo $GLOBALS['wp_query']->request;
	// echo $the_query->request;
	// echo $wpdb->last_query;
	 if ( $the_query->have_posts() && !$condicion1 ) {
	 	while ( $the_query->have_posts() ) {
	 		$the_query->the_post();
	 		/*	$day = new DateTime(get_the_date('d-m-Y'));
	 		 $dif = $day->diff($now);
	 		 $condicion1 = $max_days ? $dif->days<$max_days : true ;
	 		 $condicion2 = $max_posts ? $cuantos<$max_posts : true ;
	 		 $condicion3 = $filtrar_por_categorias_usuario ? is_post_in_user_categories(get_the_ID()) : true;
	 		 if($condicion3 && $condicion1 && $condicion2)
	 		 {
	 			if($dif->days >= 365 )$plazo="Hace más de un año";
	 			else if($dif->days >= 60  )$plazo="Hace más de dos meses";
	 			else if($dif->days >= 31  )$plazo="Hace más de un mes";
	 			else if($dif->days >= 14  )$plazo="Hace más de dos semanas";
	 			else if($dif->days >= 7   )$plazo="Hace más de una semana";
	 			else if($dif->days >= 3   )$plazo="Durante la última semana";
	 			else if($dif->days == 2   )$plazo="Anteayer";
	 			else if($dif->days == 1   )$plazo="Ayer";
	 			else $plazo="Hoy";
	 			if($plazo != $last_plazo){
	 			echo "<h3 class='date-separator'>".$plazo."</h3>";
	 			$last_plazo = $plazo;
					}
					get_template_part( 'content', get_post_format() );
					$cuantos+=1;
					}*/
	 		//$post=$the_query->the_post();
	 		$rel = get_user_relation_id( get_current_user_id() , 0, get_the_ID(), 'delete' );

	 		if( !$rel || $mostrar_borrados){
	 			if ($pagina=='seguimiento'){
	 						get_template_part( 'content_seguimiento', null );
	 			}else if ($pagina=='noticias'){
	 				get_template_part( 'noticias_foodalert', null );
	 			}else if ($pagina=='borradas'){
	 				get_template_part( 'content_borrados', null );	 			
	 			}elseif ($pagina=='proyectos'){
	 				get_template_part( 'content_proyectos', null );
	 			}else {
	 			
	 				
	 				get_template_part( 'content', get_post_format() );
	 			}
	 	
	 		}
	 	}

	 }else {
	 	if ($pagina=='proyectos'){
	 		get_template_part( 'no_projects',null);
	 	}else{
	 		get_template_part( 'content', 'none');
	 	}
	 	
	 }

	 if(!$cuantos) get_template_part( 'all-read', 'index' );

	 wp_reset_postdata();
	 $buffer = ob_get_contents();
	 ob_end_clean();
	 return $buffer;
}
add_shortcode('grid_graficos_modulos','grid_graficos_modulos_shortcode');
function grid_graficos_modulos_shortcode()
{
	?>
<b>- Información relativa a los últimos 90 días -</b><br><br>

	<script>
		jQuery(document).ready(function run_module_graphics($)
		{	
			var grafica_entradas_x_modulo = function()
			{
				//$('#graficos_modulos').css('border','1px solid #999');
				//$('#graficos_modulos').css('box-shadow','2px 2px 10px #999');
				
				var chart1 = new Highcharts.Chart({
					chart: {
						renderTo: 'graficos_modulos',
						type: 'pie',
						options3d: {
							enabled: true,
							alpha: 45
						}
					},
					title: {
						text: 'Entradas por Módulo'
					},
					
					plotOptions: {
						pie: {
							innerSize: 100,
							depth: 45
						}
					},
					series: [{
						name: 'Entradas',
						data: [
							<?php		
							//start by fetching the terms for the scope taxonomy
							$terms = get_terms( 'scope', array(
								'orderby'    => 'count',
								'hide_empty' => 0
							) );
							
							$len = sizeof($terms);
							$today = getdate();
							// now run a query for each animal family
							foreach( $terms as $term ) {
							
								$queryArgs = array( 'scope' => $term->slug,
									'posts_per_page'=>-1
									);
								// Define the query
								$query = new WP_Query( $queryArgs );
								// output the post titles in a list
								
								$contador=0;
								// Start the Loop
								while ( $query->have_posts() ) : $query->the_post();
									$contador++;
								endwhile;?>
									
								<?php 
								echo '[\''.$term->slug.'\','.$contador.'],';
								// use reset postdata to restore orginal query
								wp_reset_postdata();
							}
							?>
						]
					}]
				});		
			}
		
			var grafica_entradas_x_tags = function run_module_graphics_4()
			{	
				<?php
					$categories = get_categories();
				?>
				//$('#graficos_modulos_3').css('border','1px solid #999');
			//	$('#graficos_modulos_3').css('box-shadow','2px 2px 10px #999');
				//$('#graficos_modulos_3').css('width','1003px');
				
				var chart3 = new Highcharts.Chart({
					chart: {
						renderTo: 'graficos_modulos_3',
						type: 'bar',
						options3d: {
							enabled: true,
							alpha: 45
						}
					},
					title: {
						text: 'Entradas por Tag'
					},
					 yAxis: {
			            min: 0,
			            title: {
			                text: 'Número de entradas',
			                align: 'high'
			            },
			            labels: {
			                overflow: 'justify'
			            }
			        },
					series: [
			
						<?php
									$first=0;
									$myhashmap = array();
									foreach ( $categories as $category ) {
										
										$args = array(
											'category_name'    => $category->name,
											'post_type'        => 'post',
											'post_status'      => 'publish',
											'suppress_filters' => true,
												'posts_per_page'=>-1,
											'date_query'	   => array('after' => date('Y-m-d', strtotime('-90 days'))) 
										);
										
										$post_by_cat = get_posts($args);	
										$counter = 0;
										foreach($post_by_cat as $p)
										{
											$counter++;
										}
										
										if ($counter>0){

										$texto=str_replace("'","\'",$category->name);
										$myhashmap[$texto] = $counter;

										}
								
									}
									arsort($myhashmap);
									foreach (array_keys($myhashmap) as $key){
										if ($first>0){
											echo',';
										}
										$first=$first+1;
											echo '{name:\''.$key.'\',';										
											echo 'data:['.$myhashmap[$key].']}';
									}
							
									
									
									?>
						

						]
				});						
			}
			var grafica_entradas_x_fuente = function run_module_graphics_4()
			{	
				<?php
					$sources = get_terms("fuente");
				?>
				//$('#graficos_modulos_4').css('border','1px solid #999');
			//	$('#graficos_modulos_4').css('box-shadow','2px 2px 10px #999');
				//$('#graficos_modulos_3').css('width','1003px');
				
				var chart3 = new Highcharts.Chart({
					chart: {
						renderTo: 'graficos_modulos_4',
						type: 'bar',
						options3d: {
							enabled: true,
							alpha: 45
						}
					},
					title: {
						text: 'TOP 10 - Entradas por fuente'
					},
					 yAxis: {
			            min: 0,
			            title: {
			                text: 'Número de entradas',
			                align: 'high'
			            },
			            labels: {
			                overflow: 'justify'
			            }
			        },
					series: [
			
						<?php
									$first=0;
									$myhashmap = array();
									foreach ( $sources as $source ) {
										
										
										$args = array(
											'fuente'		   => $source->slug,
											'post_type'        => 'post',
											'post_status'      => 'publish',
											'suppress_filters' => true,
												'posts_per_page'=>-1,
											'date_query'	   => array('after' => date('Y-m-d', strtotime('-90 days'))) 
										);
										
										
										$query = new WP_Query( $args );	
										$counter = 0;
										while ( $query->have_posts() ) : $query->the_post();
											$counter++;
										endwhile;
										
										if ($counter>0){

										$texto=str_replace("'","\'",$source->name);
										$myhashmap[$texto] = $counter;

										}
									wp_reset_postdata();
									}
									arsort($myhashmap);
									foreach (array_keys($myhashmap) as $key){
										if ($first>0){
											echo',';
										}
										$first=$first+1;
											echo '{name:\''.$key.'\',';										
											echo 'data:['.$myhashmap[$key].']}';
									}
							
									
									
									?>
						

						]
				});						
			}
			
		
			//Ocultamos los divs de gr�ficos
			
			$('#grafico_entradas_x_modulo').css('display','block');
			$('#grafico_dist_tags_x_modulo').css('display','block');
			$('#grafico_evolucion_tags').css('display','block');
			$('#grafico_entradas_tags').css('display','block');
		grafica_entradas_x_tags();
		grafica_entradas_x_fuente();
		
			
			$('#div_pieChart1').click(function()
			{
				$('#grafico_entradas_x_modulo').css('display','block');
				$('#grafico_dist_tags_x_modulo').css('display','none');
				$('#grafico_evolucion_tags').css('display','none');
				$('#grafico_entradas_tags').css('display','none');
				grafica_entradas_x_modulo();
			});
			
			$('#div_columnChart').click(function()
			{
				$('#grafico_entradas_x_modulo').css('display','none');
				$('#grafico_dist_tags_x_modulo').css('display','block');
				$('#grafico_evolucion_tags').css('display','none');
				$('#grafico_entradas_tags').css('display','none');
			});
			
			$('#div_pieChart2').click(function()
			{
				$('#grafico_entradas_x_modulo').css('display','none');
				$('#grafico_dist_tags_x_modulo').css('display','none');
				$('#grafico_evolucion_tags').css('display','none');
				$('#grafico_entradas_tags').css('display','block');
				grafica_entradas_x_tags();
			});
			
			$('#div_pieChart3').click(function()
			{
				$('#grafico_entradas_x_modulo').css('display','none');
				$('#grafico_dist_tags_x_modulo').css('display','none');
				$('#grafico_evolucion_tags').css('display','block');
				$('#grafico_entradas_tags').css('display','none');
				grafica_entradas_x_fuente();
			});
		});
		
		</script>
	<div id="grid_graficos_modulos">		
		


		<div id="grafico_dist_tags_x_modulo">
			
		</div>
		<div id="grafico_entradas_tags">
			
			<div id="graficos_modulos_3">
			
			</div>
		</div>
		<br>
		<br>
		<div id="grafico_evolucion_tags">
			
			<div id="graficos_modulos_4">
			
			</div>
		</div>
	</div>
	<?php
}
add_shortcode('grafico_entradas_x_fuente','grafico_entradas_x_fuente_shortcode');

function grafico_entradas_x_fuente_shortcode(){

	?>
	<div  style="position:relative;">
			<div id="grafico_fuente_semana" >
		<?php
		grafico_entradas_x_fuente__semana();
		?>
		</div>
		<div id="grafico_fuente_mes" style="visibility:hidden;position:absolute;top:0;width:100%;">
			<?php
			grafico_entradas_x_fuente_mes();
		?>
					</div>
					<div id="grafico_fuente_trimestre" style="visibility:hidden;position:absolute;top:0;width:100%;">
				<?php
				grafico_entradas_x_fuente__trimestre();
		?>
					</div>
					</div>
				<?php

}

function grafico_entradas_x_fuente__semana()
{
	menu_periodos_estadisticas_fuente();
	?>
<h3>TOP 10 - Entradas por fuente</h3> (Últimos 7 días)
			<?php
					$sources=get_terms( 'fuente', array( 'hide_empty' => false));
				//	$colors=array('#01B8AA', '#374649', '#F2C80F', '#FD625E', '#A66999', '#DFBFBF', '#8AD4EB', '#FE9666', '#5F6B6D', '#AD514A', '#7BB252');

					$colors= get_color_sequence();
					$color_index=0;
					
					$myhashmap = array();
					foreach ( $sources as $source ) {
					
					
						$args = array(
								'fuente'		   => $source->slug,
								'post_type'        => 'post',
								'post_status'      => 'publish',
								'suppress_filters' => true,
								'posts_per_page'=>-1,
								'date_query'	   => array('after' => date('Y-m-d', strtotime('-7 days')))
						);
					
					
						$query = new WP_Query( $args );
						$counter = 0;
						while ( $query->have_posts() ) : $query->the_post();
						$counter++;
						endwhile;
					
						if ($counter>0){
					
							$texto=str_replace("'","\'",$source->name);
							$myhashmap[$texto] = $counter;
					
						}
						wp_reset_postdata();
					}
					$myhashmap_size = count($myhashmap);
					
					if ($myhashmap_size > 0){
				?>
	<script>
		jQuery(document).ready(function run_module_graphics($)
		{	
			var grafica_entradas_x_fuente = function run_module_graphics_4()
			{	
	
			//	$('#graficos_modulos_4').css('border','1px solid #999');
				//$('#graficos_modulos_4').css('box-shadow','2px 2px 10px #999');
				//$('#graficos_modulos_3').css('width','1003px');
				
				var chart3 = new Highcharts.Chart({
					   legend: {
					        align: 'left',
					        verticalAlign: 'top',
					        layout: 'vertical',
					        x: 0,
					        y: 67
					    },
					    credits: {
					        enabled: false
					    },
					chart: {
						renderTo: 'graficos_modulos_4_semana',
						type: 'bar',
						options3d: {
							enabled: true,
							alpha: 45
						}
					},
					exporting: { enabled: false },
					title: {
						text: null
					},
					 yAxis: {
			            min: 0,
			            title: {
			                text: 'Número de entradas',
			                align: 'high'
			            },
			            labels: {
			                overflow: 'justify'
			            }
			        },
					series: [
			
						<?php
									$first=0;
					
									arsort($myhashmap);
									$max_results=0;
									foreach (array_keys($myhashmap) as $key){
										if($max_results>9){
											break;
										}
										if ($first>0){
											echo',';
										}
										$first=$first+1;
											echo '{name:\''.$key.'\',';										
											echo 'data:['.$myhashmap[$key].'],color: \''.$colors[$color_index].'\'}';
											if($color_index<sizeof($colors)-1){
												$color_index=$color_index+1;
											}else{
												$color_index=0;
											}
											$max_results=$max_results+1;
											
									}
							
									
									
									?>
						

						]
				});	
			
			}
			grafica_entradas_x_fuente();
		});
			</script>
				<?php } else {
					echo '<br><br><i>No hay entradas para el periodo seleccionado.</i>';
				}
					?>
		
			
			<div id="grafico_evolucion_tags">
			
			<div id="graficos_modulos_4_semana">
			
			</div>
		</div>

	<?php
}

function grafico_entradas_x_fuente_mes()
{
	menu_periodos_estadisticas_fuente();
	?>
		<h3>TOP 10 - Entradas por fuente</h3>(últimos 30 días)
			<?php
					$sources=get_terms( 'fuente', array( 'hide_empty' => false));
					$colors= get_color_sequence();
					$color_index=0;
					$myhashmap = array();
					foreach ( $sources as $source ) {
					
					
						$args = array(
								'fuente'		   => $source->slug,
								'post_type'        => 'post',
								'post_status'      => 'publish',
								'suppress_filters' => true,
								'posts_per_page'=>-1,
								'date_query'	   => array('after' => date('Y-m-d', strtotime('-30 days')))
						);
					
					
						$query = new WP_Query( $args );
						$counter = 0;
						while ( $query->have_posts() ) : $query->the_post();
						$counter++;
						endwhile;
					
						if ($counter>0){
					
							$texto=str_replace("'","\'",$source->name);
							$myhashmap[$texto] = $counter;
					
						}
						wp_reset_postdata();
					}
					
					$myhashmap_size = count($myhashmap);
					if ($myhashmap_size > 0){
				?>
	<script>
		jQuery(document).ready(function run_module_graphics($)
		{	
			var grafica_entradas_x_fuente = function run_module_graphics_4()
			{	
	

				var chart3 = new Highcharts.Chart({
					   legend: {
					        align: 'left',
					        verticalAlign: 'top',
					        layout: 'vertical',
					        x: 0,
					        y: 67
					    },
					    credits: {
					        enabled: false
					    },
					chart: {
						renderTo: 'graficos_modulos_4',
						type: 'bar',
						options3d: {
							enabled: true,
							alpha: 45
						}
					},
					exporting: { enabled: false },
					title: {
						text: null
					},
					 yAxis: {
			            min: 0,
			            title: {
			                text: 'Número de entradas',
			                align: 'high'
			            },
			            labels: {
			                overflow: 'justify'
			            }
			        },
					series: [
			
						<?php
									$first=0;
		
									arsort($myhashmap);
									$max_results=0;
									foreach (array_keys($myhashmap) as $key){
										if($max_results>9){
											break;
										}
																	
										if ($first>0){
											echo',';
										}
										$first=$first+1;
											echo '{name:\''.$key.'\',';										
											echo 'data:['.$myhashmap[$key].'],color: \''.$colors[$color_index].'\'}';
											if($color_index<sizeof($colors)-1){
												$color_index=$color_index+1;
											}else{
												$color_index=0;
											}
											
											$max_results=$max_results+1;
									}
							
									
									
									?>
						

						]
				});						
			}
			grafica_entradas_x_fuente();
		});
			</script>
			<?php } else {
					echo '<br><br><i>No hay entradas para el periodo seleccionado.</i>';
				}
					?>
		
			
			<div id="grafico_evolucion_tags">
			
			<div id="graficos_modulos_4">
			
			</div>
		</div>

	<?php
}

function grafico_entradas_x_fuente__trimestre()
{
	menu_periodos_estadisticas_fuente();
	?>
	<h3>TOP 10 - Entradas por fuente</h3>(último trimestre)
	
					<?php
					$sources=get_terms( 'fuente', array( 'hide_empty' => false));
					//$colors=array('#330000','#660000','#990000','#b30000','#e60000','#ff3333','#ff6666','#ff9999','#ffb3b3','#ffcccc');
					//$colors=array('#01B8AA', '#374649', '#F2C80F', '#FD625E', '#A66999', '#DFBFBF', '#8AD4EB', '#FE9666', '#5F6B6D', '#AD514A', '#7BB252');
					$colors= get_color_sequence();
					$color_index=0;
					$myhashmap = array();
					foreach ( $sources as $source ) {
					
					
						$args = array(
								'fuente'		   => $source->slug,
								'post_type'        => 'post',
								'post_status'      => 'publish',
								'suppress_filters' => true,
								'posts_per_page'=>-1,
								'date_query'	   => array('after' => date('Y-m-d', strtotime('-90 days')))
						);
					
					
						$query = new WP_Query( $args );
						$counter = 0;
						while ( $query->have_posts() ) : $query->the_post();
						$counter++;
						endwhile;
					
						if ($counter>0){
					
							$texto=str_replace("'","\'",$source->name);
							$myhashmap[$texto] = $counter;
					
						}
						wp_reset_postdata();
					}
					
					$myhashmap_size = count($myhashmap);
					if ($myhashmap_size > 0){
				?>
	<script>
		jQuery(document).ready(function run_module_graphics($)
		{	
			var grafica_entradas_x_fuente = function run_module_graphics_4()
			{	


				
				var chart3 = new Highcharts.Chart({
					   legend: {
					        align: 'left',
					        verticalAlign: 'top',
					        layout: 'vertical',
					        x: 0,
					        y: 67
					    },
					    credits: {
					        enabled: false
					    },
					chart: {
						renderTo: 'graficos_modulos_4_mes',
						type: 'bar',
						options3d: {
							enabled: true,
							alpha: 45
						}
					},
					exporting: { enabled: false },
					title: {
						text: null
					},
					 yAxis: {
			            min: 0,
			            title: {
			                text: 'Número de entradas',
			                align: 'high'
			            },
			            labels: {
			                overflow: 'justify'
			            }
			        },
					series: [
			
						<?php
									$first=0;
		
									arsort($myhashmap);
									$max_results=0;
									foreach (array_keys($myhashmap) as $key){
										if($max_results>9){
											break;
										}
																	
										if ($first>0){
											echo',';
										}
										$first=$first+1;
											echo '{name:\''.$key.'\',';										
											echo 'data:['.$myhashmap[$key].'],color: \''.$colors[$color_index].'\'}';
											if($color_index<sizeof($colors)-1){
												$color_index=$color_index+1;
											}else{
												$color_index=0;
											}
											$max_results=$max_results+1;
									}
							
									
									
									?>
						

						]
				});						
			}
			grafica_entradas_x_fuente();
		});
			</script>
					<?php } else {
					echo '<br><br><i>No hay entradas para el periodo seleccionado.</i>';
				}
					?>
			
			<div id="grafico_evolucion_tags">
			
			<div id="graficos_modulos_4_mes">
			
			</div>
		</div>

	<?php
}


add_shortcode('grafico_entradas_x_concepto_trimestre','grafico_entradas_x_concepto_trimestre_shortcode');
function grafico_entradas_x_concepto_trimestre (){
	menu_periodos_estadisticas_detalle();

	?>
	<br>
	<h3>TOP 10 - Entradas por concepto</h3>(último trimestre)
				<?php
					$categories = get_categories();
					//$colors=array('#41160b','#6d2512','#832c16','#ae3b1e','#da4925','#e16e51','#e58066','#eda492','#f0b6a8',' #f8dbd3');
					$colors= get_color_sequence();
					$color_index=0;
					$myhashmap = array();
					foreach ( $categories as $category ) {
					
						$args = array(
								'category_name'    => $category->name,
								'post_type'        => 'post',
								'post_status'      => 'publish',
								'suppress_filters' => true,
								'posts_per_page'=>-1,
								'date_query'	   => array('after' => date('Y-m-d', strtotime('-90 days')))
						);
					
						$post_by_cat = get_posts($args);
						$counter = 0;
						foreach($post_by_cat as $p)
						{
							$counter++;
						}
					
						if ($counter>0){
					
							$texto=str_replace("'","\'",$category->name);
							$myhashmap[$texto] = $counter;
					
						}
					
					}
					$myhashmap_size = count($myhashmap);
					if ($myhashmap_size > 0){
				?>
	<script>
		jQuery(document).ready(function run_module_graphics($)
		{
	var grafica_entradas_x_tags = function run_module_graphics_4(){	

	
				var chart3 = new Highcharts.Chart({
					   legend: {
					        align: 'left',
					        verticalAlign: 'top',
					        layout: 'vertical',
					        x: 0,
					        y: 62
					    },
					chart: {
						renderTo: 'graficos_modulos_3_trimestre',
						type: 'bar',
						options3d: {
							enabled: true,
							alpha: 45
						}
					},
					exporting: { enabled: false },
					title: {
						text: null
					},
					 yAxis: {
			            
			            title: {
			                text: 'Número de entradas',
			                align: 'high'
			            },
			            labels: {
				            enabled: false
				            }
			            
			           
			        },
			           credits: {
					        enabled: false
    				},
					series: [
			
						<?php
									$first=0;
					
									arsort($myhashmap);
									$max_results=0;
									foreach (array_keys($myhashmap) as $key){
										if($max_results>9){
											break;
										}									
										if ($first>0){
											echo',';
										}
										$first=$first+1;
											echo '{name:\''.$key.'\',';										
											echo 'data:['.$myhashmap[$key].'],color: \''.$colors[$color_index].'\'}';
											if($color_index<sizeof($colors)-1){
												$color_index=$color_index+1;
											}else{
												$color_index=0;
											}
											$max_results=$max_results+1;
									}
									
									?>
						]
				});						
			}
		grafica_entradas_x_tags();
});
	</script>
			<?php } else {
					echo '<br><br><i>No hay entradas para el periodo seleccionado.</i>';
				}
					?>
	
	<div id="grafico_evolucion_tags">
	
	<div id="graficos_modulos_3_trimestre">
	
	</div>
</div>
<?php
}

add_shortcode('graficos_entradas_x_conceptos','graficos_entradas_x_conceptos_shortcode');
function graficos_entradas_x_conceptos_shortcode()
{
?>
<div  style="position:relative;width:49%;float:left;border-bottom:1px dotted grey;">
		<div id="grafico_semana" >
	<?php
	grafico_entradas_x_concepto_semana_shortcode();
	?>
	</div>
	<div id="grafico_mes" style="visibility:hidden;position:absolute;top:0;width:100%;">
		<?php
	grafico_entradas_x_concepto_mes_shortcode();
	?>
				</div>
				<div id="grafico_trimestre" style="visibility:hidden;position:absolute;top:0;width:100%;">
			<?php
	grafico_entradas_x_concepto_trimestre();
	?>
				</div>
				</div>
			<?php
}
add_shortcode('grafico_entradas_x_concepto_semana','grafico_entradas_x_concepto_semana_shortcode');
function grafico_entradas_x_concepto_semana_shortcode (){
	menu_periodos_estadisticas_detalle();

	?>
	<br>
	<h3>TOP 10 - Entradas por concepto</h3> (Últimos 7 días)
				<?php
					$categories = get_categories();
					//$colors=array('#41160b','#6d2512','#832c16','#ae3b1e','#da4925','#e16e51','#e58066','#eda492','#f0b6a8',' #f8dbd3');
					$colors= get_color_sequence();
					$color_index=0;
					$myhashmap = array();
					foreach ( $categories as $category ) {
					
						$args = array(
								'category_name'    => $category->name,
								'post_type'        => 'post',
								'post_status'      => 'publish',
								'suppress_filters' => true,
								'posts_per_page'=>-1,
								'date_query'	   => array('after' => date('Y-m-d', strtotime('-7 days')))
						);
					
						$post_by_cat = get_posts($args);
						$counter = 0;
						foreach($post_by_cat as $p)
						{
							$counter++;
						}
					
						if ($counter>0){
					
							$texto=str_replace("'","\'",$category->name);
							$myhashmap[$texto] = $counter;
					
						}
					
					}
					$myhashmap_size = count($myhashmap);
					if ($myhashmap_size > 0){
				?>
	<script>
		jQuery(document).ready(function run_module_graphics($)
		{
	var grafica_entradas_x_tags = function run_module_graphics_4(){	

				
				var chart3 = new Highcharts.Chart({
					   legend: {
					        align: 'left',
					        verticalAlign: 'top',
					        layout: 'vertical',
					        x: 0,
					        y: 62
					    },
					chart: {
						renderTo: 'graficos_modulos_sem',
						type: 'bar',
						options3d: {
							enabled: true,
							alpha: 45
						}
					},
					exporting: { enabled: false },
					title: {
						text: null
					},
					 yAxis: {
			            min: 0,
			            title: {
			                text: 'Número de entradas',
			                align: 'high'
			            },
			            labels: {
			                overflow: 'justify'
			            }
			        },
					series: [
			
						<?php
									$first=0;
				
									arsort($myhashmap);
									$max_results=0;
									foreach (array_keys($myhashmap) as $key){
										if($max_results>9){
											break;
										}								
										if ($first>0){
											echo',';
										}
										$first=$first+1;
											echo '{name:\''.$key.'\',';										
											echo 'data:['.$myhashmap[$key].'],color: \''.$colors[$color_index].'\'}';
											if($color_index<sizeof($colors)-1){
												$color_index=$color_index+1;
											}else{
												$color_index=0;
											}
											$max_results=$max_results+1;
									}
									
									?>
						]
				});						
			}
		grafica_entradas_x_tags();
});
	</script>

				<?php } else {
					echo '<br><br><i>No hay entradas para el periodo seleccionado.</i>';
				}
					?>
	<div id="grafico_evolucion_tags">
	
	<div id="graficos_modulos_sem">
	
	</div>
</div>


<?php
}
add_shortcode('grafico_entradas_x_concepto_mes','grafico_entradas_x_concepto_mes_shortcode');
function grafico_entradas_x_concepto_mes_shortcode (){
	menu_periodos_estadisticas_detalle();

	?>
	<br>
	<h3>TOP 10 - Entradas por concepto</h3>(últimos 30 días)
				<?php
					$categories = get_categories();
					$colors= get_color_sequence();
					$color_index=0;
					$myhashmap = array();
					foreach ( $categories as $category ) {
					
						$args = array(
								'category_name'    => $category->name,
								'post_type'        => 'post',
								'post_status'      => 'publish',
								'suppress_filters' => true,
								'posts_per_page'=>-1,
								'date_query'	   => array('after' => date('Y-m-d', strtotime('-30 days')))
						);
					
						$post_by_cat = get_posts($args);
						$counter = 0;
						foreach($post_by_cat as $p)
						{
							$counter++;
						}
					
						if ($counter>0){
					
							$texto=str_replace("'","\'",$category->name);
							$myhashmap[$texto] = $counter;
					
						}
					
					}
					$myhashmap_size = count($myhashmap);
					if ($myhashmap_size > 0){
				?>
	<script>
		jQuery(document).ready(function run_module_graphics($)
		{
	var grafica_entradas_x_tags = function run_module_graphics_4(){	


				var chart3 = new Highcharts.Chart({
					   legend: {
					        align: 'left',
					        verticalAlign: 'top',
					        layout: 'vertical',
					        x: 0,
					        y: 62
					    },
					chart: {
						renderTo: 'graficos_modulos_mes',
						type: 'bar',
						options3d: {
							enabled: true,
							alpha: 45
						}
					},
					exporting: { enabled: false },
					title: {
						text: null
					},
					 yAxis: {
			            min: 0,
			            title: {
			                text: 'Número de entradas',
			                align: 'high'
			            },
			            labels: {
			                overflow: 'justify'
			            }
			        },
					series: [
			
						<?php
									$first=0;
									
									arsort($myhashmap);
									$max_results=0;
									foreach (array_keys($myhashmap) as $key){
										if($max_results>9){
											break;
										}
									if ($first>0){
											echo',';
										}
										$first=$first+1;
											echo '{name:\''.$key.'\',';										
											echo 'data:['.$myhashmap[$key].'],color: \''.$colors[$color_index].'\'}';
											if($color_index<sizeof($colors)-1){
												$color_index=$color_index+1;
											}else{
												$color_index=0;
											}
											$max_results=$max_results+1;
									}
									
									?>
						]
				});						
			}
		grafica_entradas_x_tags();
});
	</script>
			<?php } else {
					echo '<br><br><i>No hay entradas para el periodo seleccionado.</i>';
				}
					?>
	
	<div id="grafico_evolucion_tags">
	
	<div id="graficos_modulos_mes">
	
	</div>
</div>


<?php
}

add_shortcode('top_entradas','top_entradas_shortcode');
function top_entradas_shortcode(){
?>
	
		<?php
		
 									$categories = get_categories();
 									$myhashmap = array();
									foreach ( $categories as $category ) {
										
										$args = array(
											'category_name'    => $category->name,
											'post_type'        => 'post',
											'post_status'      => 'publish',
											'suppress_filters' => true,
												'posts_per_page'=>-1,
											'date_query'	   => array('after' => date('Y-m-d', strtotime('-7 days'))) 
										);
										
										$post_by_cat = get_posts($args);	
										$counter = 0;
										foreach($post_by_cat as $p)
										{
											$counter++;
										}
										
										if ($counter>0){
											$texto=str_replace("'","\'",$category->name);
											$myhashmap[$texto] = $counter;
										}								
									}
									arsort($myhashmap);
									$temp_array=array_keys($myhashmap);
									$Key=$temp_array[0];
									
									return $Key.' <h2 style="display:inline">'.$myhashmap[$Key].'</h2>';

	?>	<?php
}
add_shortcode('estadistica_creciente_seguimiento','estadistica_creciente_seguimiento_shortcode');

function estadistica_creciente_seguimiento_shortcode(){
	$user_id = get_current_user_id();							
	$user_categories =  wp_get_object_terms($user_id, 'category',array('fields'=>'ids'));
	$user_conceptos_seguimiento = wp_get_object_terms($user_id, 'concepto_seguimiento',array('fields'=>'ids'));
	$resultado=menu_periodos_estadisticas();
	$resultado=$resultado.'<div style="position:relative"><div id="est_semana"><h3>Tendencias</h3>Durante la última semana las tendencias más destacada son... <br><u><i>Conceptos búsqueda            </i></u><br>'.estadistica_creciente_usuario($user_categories,7).'<br><u><i>Conceptos seguimiento</i></u><br>'.estadistica_creciente_usuario($user_conceptos_seguimiento,7);
	$resultado=$resultado.'<i><br>(*) Variación del Número de entradas respecto a la semana anterior </i>'.'</div>';
	$resultado=$resultado.'<div style="visibility:hidden;position:absolute;top:0;margin-bottom:5px;" id="est_mes"><h3>Tendencias</h3>Durante el último mes las tendencia más detacadas son...<br><u><i>Conceptos búsqueda            </i></u><br>'.estadistica_creciente_usuario($user_categories,30).'<br><u><i>Conceptos seguimiento</i></u><br>'.estadistica_creciente_usuario($user_conceptos_seguimiento,30);
	$resultado=$resultado.'<i><br>(*) Variación del Número de entradas respecto al mes anterior </i>'.'</div>';
	$resultado=$resultado.'<div style="visibility:hidden;position:absolute;top:0;margin-bottom:5px;" id="est_trimestre"><h3>Tendencias</h3>Durante el último año las tendencias más detacadas son...<br><u><i>Conceptos búsqueda            </i></u><br>'.estadistica_creciente_usuario($user_categories,90).'<br><u><i>Conceptos seguimiento</i></u><br>'.estadistica_creciente_usuario($user_conceptos_seguimiento,90);
	$resultado=$resultado.'<i><br>(*) Variación del Número de entradas respecto al año anterior </i>'.'</div></div>';
	$resultado=$resultado.'<div style="position:relative;height:25px;border:solid black 0px;"><div style="margin-right:5px;position:absolute;right:0px;top:0px;"><a href="'.get_site_url().'?page_id=83"><i>Ver más...</i></a></div></div>';

	//echo 'categories--'.implode(",",$user_categories);
	//query_tendencia (7,$user_categories);
	return $resultado;

}

add_shortcode('estadistica_creciente','estadistica_creciente_shortcode');

function estadistica_creciente_shortcode(){
	$user_id = get_current_user_id();							
	$user_categories =  wp_get_object_terms($user_id, 'category',array('fields'=>'ids'));
	$resultado=menu_periodos_estadisticas();
	$resultado=$resultado.'<div style="position:relative"><div id="est_semana"><h3>Tendencias</h3>Durante la última semana la tendencia más destacada es... <br>'.estadistica_creciente_usuario($user_categories,7);
	$resultado=$resultado.'<i><br>(*) Variación del Número de entradas respecto a la semana anterior </i>'.'</div>';
	$resultado=$resultado.'<div style="visibility:hidden;position:absolute;top:0;margin-bottom:5px;" id="est_mes"><h3>Tendencias</h3>Durante el último mes la tendencia más detacada es...<br>'.estadistica_creciente_usuario($user_categories,30);
	$resultado=$resultado.'<i><br>(*) Variación del Número de entradas respecto al mes anterior </i>'.'</div>';
	$resultado=$resultado.'<div style="visibility:hidden;position:absolute;top:0;margin-bottom:5px;" id="est_trimestre"><h3>Tendencias</h3>Durante el último año la tendencia más detacada es...<br>'.estadistica_creciente_usuario($user_categories,90);
	$resultado=$resultado.'<i><br>(*) Variación del Número de entradas respecto al año anterior </i>'.'</div></div>';
	$resultado=$resultado.'<div style="position:relative;height:25px;border:solid black 0px;"><div style="margin-right:5px;position:absolute;right:0px;top:0px;"><a href="'.get_site_url().'?page_id=83"><i>Ver más...</i></a></div></div>';
	return $resultado;

}
function estadistica_creciente_semana_shortcode(){
	?>
	
		<?php
 									$categories = get_categories();
 									$myhashmap_actual = array();
 									$myhashmap_previo = array();
 									$myhashmap_diferencia = array();
 									$myhashmap_diferencia_ABS = array();
									foreach ( $categories as $category ) {
										
										$args_semana_actual = array(
											'category_name'    => $category->name,
											'post_type'        => 'post',
											'post_status'      => 'publish',
											'suppress_filters' => true,
											'posts_per_page'=>-1,												
											'date_query'	   => array('after' => date('Y-m-d', strtotime('-7 days'))) 
										);
										$args_semana_anterior = array(
												'category_name'    => $category->name,
												'post_type'        => 'post',
												'post_status'      => 'publish',
												'suppress_filters' => true,
												'posts_per_page'=>-1,
												'date_query'	   => array('before' => date('Y-m-d', strtotime('-7 days')),'after' => date('Y-m-d', strtotime('-15 days')))
										);
										
										$post_by_cat_semana_actual = get_posts($args_semana_actual);	
										$post_by_cat_semana_anterior = get_posts($args_semana_anterior);
										$counter_actual = 0;
										$counter_anterior = 0;
										foreach($post_by_cat_semana_actual as $p)
										{
											$counter_actual++;
										}
										foreach($post_by_cat_semana_anterior as $p)
										{	
											echo $p->title;
											$counter_anterior++;
										}
										//if ($counter_actual>0){
											$texto=str_replace("'","\'",$category->name);
											$myhashmap_actual[$texto] = $counter_actual;
									//		echo 'ACTUAL: '.$texto.'-'.$counter_actual.'<br>';
										//}
										//if ($counter_anterior>0){
											$texto=str_replace("'","\'",$category->name);
											$myhashmap_anterior[$texto] = $counter_anterior;
											//echo 'ANTERIOR: '.$texto.'-'.$counter_anterior.'<br>';
										//}
									
									}
									arsort($myhashmap_actual);								
									foreach (array_keys($myhashmap_actual) as $key){
									
										$diferencia=0;
										$valor_actual=0;
										$valor_anterior=0;
										$valor_actual=$myhashmap_actual[$key];
										$valor_anterior=$myhashmap_anterior[$key];
										//echo '----------'.$key.'----------'.'<br>';
										//echo 'VALOR_ACTUAL: '.$valor_actual.'<br>';
										//echo '---VALOR_ANTERIOR: '.$valor_anterior.'<br>';
									
											if($myhashmap_anterior[$key]>0){
											
										
												$diferencia=($valor_actual-$valor_anterior);
												$myhashmap_diferencia_ABS[$key]=$diferencia;
												
											//	echo 'diferencia1:'.$myhashmap_diferencia_ABS[$key];
											
												$diferencia=$diferencia/$valor_anterior;
												
												$myhashmap_diferencia[$key]=$diferencia*100;
												//echo 'diferencia2:'.$myhashmap_diferencia[$key];
											}else{
												if($myhashmap_actual[$key]>0){
													$myhashmap_diferencia[$key]=100;
													$myhashmap_diferencia_ABS[$key]=$valor_actual;
													}else{
														$myhashmap_diferencia[$key]=0;
														$myhashmap_diferencia_ABS[$key]=0;
													}
										
											}
										
								
									}
									arsort($myhashmap_diferencia_ABS);
									$temp_key_max=array_keys($myhashmap_diferencia_ABS);
									$key_max=$temp_key_max[0];
									asort($myhashmap_diferencia_ABS);
									$temp_key_min=array_keys($myhashmap_diferencia_ABS);
									$key_min=$temp_key_min[0];
									
									$_string_max='<div style="margin-right:5px;display:inline;"><i class="fa fa-sort-asc" style="font-size:32px;color:#98DF58;padding:3px;"></i>'.$key_max.' <h2 style="display:inline">+'.$myhashmap_diferencia_ABS[$key_max].'</h2>('.round($myhashmap_diferencia[$key_max],1).'% )</div>';

									$_string_min='<i class="fa fa fa-sort-down" style="font-size:32px;color:#EC6464;padding:3px;margin-left:10px;"></i> '.$key_min.' <h2 style="display:inline">'.$myhashmap_diferencia_ABS[$key_min].'</h2>('.round($myhashmap_diferencia[$key_min],1).'% ) ';
									
								//	$string_tendencia_semana='<h3>Tendencias</h3>(Últimos 7 días)';
									$string_tendencia_semana=$_string_max;
									if($myhashmap_diferencia[$key_min]<0){
										$string_tendencia_semana=$_string_max.' | '.$_string_min;
									}
									return $string_tendencia_semana;

	?><?php
}

function estadistica_creciente_mes_shortcode(){
	?>

		<?php
 									$categories = get_categories();
 									$myhashmap_actual = array();
 									$myhashmap_previo = array();
 									$myhashmap_diferencia = array();
 									$myhashmap_diferencia_ABS = array();
									foreach ( $categories as $category ) {
										
										$args_semana_actual = array(
											'category_name'    => $category->name,
											'post_type'        => 'post',
											'post_status'      => 'publish',
											'suppress_filters' => true,
												'posts_per_page'=>-1,
											'date_query'	   => array('after' => date('Y-m-d', strtotime('-30 days'))) 
										);
										$args_semana_anterior = array(
												'category_name'    => $category->name,
												'post_type'        => 'post',
												'post_status'      => 'publish',
												'suppress_filters' => true,
												'posts_per_page'=>-1,
												'date_query'	   => array('before' => date('Y-m-d', strtotime('-30 days')),'after' => date('Y-m-d', strtotime('-60 days')))
										);
										
										$post_by_cat_semana_actual = get_posts($args_semana_actual);	
										$post_by_cat_semana_anterior = get_posts($args_semana_anterior);
										$counter_actual = 0;
										$counter_anterior = 0;
										foreach($post_by_cat_semana_actual as $p)
										{
											$counter_actual++;
										}
										foreach($post_by_cat_semana_anterior as $p)
										{	
											echo $p->title;
											$counter_anterior++;
										}
										//if ($counter_actual>0){
										$texto=str_replace("'","\'",$category->name);
										$myhashmap_actual[$texto] = $counter_actual;
										//		echo 'ACTUAL: '.$texto.'-'.$counter_actual.'<br>';
										//}
										//if ($counter_anterior>0){
										$texto=str_replace("'","\'",$category->name);
										$myhashmap_anterior[$texto] = $counter_anterior;
										//echo 'ANTERIOR: '.$texto.'-'.$counter_anterior.'<br>';
										//}
											
										}
										arsort($myhashmap_actual);
										foreach (array_keys($myhashmap_actual) as $key){
												
											$diferencia=0;
											$valor_actual=0;
											$valor_anterior=0;
											$valor_actual=$myhashmap_actual[$key];
											$valor_anterior=$myhashmap_anterior[$key];
											//echo '----------'.$key.'----------'.'<br>';
											//echo 'VALOR_ACTUAL: '.$valor_actual.'<br>';
											//echo '---VALOR_ANTERIOR: '.$valor_anterior.'<br>';
												
											if($myhashmap_anterior[$key]>0){
													
										
												$diferencia=($valor_actual-$valor_anterior);
												$myhashmap_diferencia_ABS[$key]=$diferencia;
										
												//	echo 'diferencia1:'.$myhashmap_diferencia_ABS[$key];
													
												$diferencia=$diferencia/$valor_anterior;
										
												$myhashmap_diferencia[$key]=$diferencia*100;
												//echo 'diferencia2:'.$myhashmap_diferencia[$key];
											}else{
												if($myhashmap_actual[$key]>0){
													$myhashmap_diferencia[$key]=100;
													$myhashmap_diferencia_ABS[$key]=$valor_actual;
												}else{
													$myhashmap_diferencia[$key]=0;
													$myhashmap_diferencia_ABS[$key]=0;
												}
										
											}
										
										
										}
										arsort($myhashmap_diferencia_ABS);
										$temp_key_max=array_keys($myhashmap_diferencia_ABS);
										$key_max=$temp_key_max[0];
										asort($myhashmap_diferencia_ABS);
										$temp_key_min=array_keys($myhashmap_diferencia_ABS);
										$key_min=$temp_key_min[0];
											
									
									$_string_max='<div style="margin-right:5px;display:inline;"><i class="fa fa-sort-asc" style="font-size:32px;color:#98DF58;padding:3px;"></i>'.$key_max.' <h2 style="display:inline">+'.$myhashmap_diferencia_ABS[$key_max].'</h2>('.round($myhashmap_diferencia[$key_max],1).'% )</div>';

									$_string_min='<i class="fa fa fa-sort-down" style="font-size:32px;color:#EC6464;padding:3px;margin-left:10px;"></i> '.$key_min.' <h2 style="display:inline">'.$myhashmap_diferencia_ABS[$key_min].'</h2>('.round($myhashmap_diferencia[$key_min],1).'% ) ';
									
									$string_tendencia_semana=$_string_max;
									if($myhashmap_diferencia[$key_min]<0){
										$string_tendencia_semana=$_string_max.' | '.$_string_min;
									}
									return $string_tendencia_semana;

	?><?php
}
function estadistica_creciente_trimestre_shortcode(){
	?>
		
		<?php
 									$categories = get_categories();
 									$myhashmap_actual = array();
 									$myhashmap_previo = array();
 									$myhashmap_diferencia = array();
 									$myhashmap_diferencia_ABS = array();
									foreach ( $categories as $category ) {
										
										$args_semana_actual = array(
											'category_name'    => $category->name,
											'post_type'        => 'post',
											'post_status'      => 'publish',
											'suppress_filters' => true,
												'posts_per_page'=>-1,
											'date_query'	   => array('after' => date('Y-m-d', strtotime('-90 days'))) 
										);
										$args_semana_anterior = array(
												'category_name'    => $category->name,
												'post_type'        => 'post',
												'post_status'      => 'publish',
												'suppress_filters' => true,
												'posts_per_page'=>-1,
												'date_query'	   => array('before' => date('Y-m-d', strtotime('-90 days')),'after' => date('Y-m-d', strtotime('-180 days')))
										);
										
										$post_by_cat_semana_actual = get_posts($args_semana_actual);	
										$post_by_cat_semana_anterior = get_posts($args_semana_anterior);
										$counter_actual = 0;
										$counter_anterior = 0;
										foreach($post_by_cat_semana_actual as $p)
										{
											$counter_actual++;
										}
										foreach($post_by_cat_semana_anterior as $p)
										{	
											echo $p->title;
											$counter_anterior++;
										}
										
										//if ($counter_actual>0){
										$texto=str_replace("'","\'",$category->name);
										$myhashmap_actual[$texto] = $counter_actual;
										//		echo 'ACTUAL: '.$texto.'-'.$counter_actual.'<br>';
										//}
										//if ($counter_anterior>0){
										$texto=str_replace("'","\'",$category->name);
										$myhashmap_anterior[$texto] = $counter_anterior;
										//echo 'ANTERIOR: '.$texto.'-'.$counter_anterior.'<br>';
										//}
											
										}
										arsort($myhashmap_actual);
										foreach (array_keys($myhashmap_actual) as $key){
										
											$diferencia=0;
											$valor_actual=0;
											$valor_anterior=0;
											$valor_actual=$myhashmap_actual[$key];
											$valor_anterior=$myhashmap_anterior[$key];
											//echo '----------'.$key.'----------'.'<br>';
											//echo 'VALOR_ACTUAL: '.$valor_actual.'<br>';
											//echo '---VALOR_ANTERIOR: '.$valor_anterior.'<br>';
										
											if($myhashmap_anterior[$key]>0){
													
										
												$diferencia=($valor_actual-$valor_anterior);
												$myhashmap_diferencia_ABS[$key]=$diferencia;
										
												//	echo 'diferencia1:'.$myhashmap_diferencia_ABS[$key];
													
												$diferencia=$diferencia/$valor_anterior;
										
												$myhashmap_diferencia[$key]=$diferencia*100;
												//echo 'diferencia2:'.$myhashmap_diferencia[$key];
											}else{
												if($myhashmap_actual[$key]>0){
													$myhashmap_diferencia[$key]=100;
													$myhashmap_diferencia_ABS[$key]=$valor_actual;
												}else{
													$myhashmap_diferencia[$key]=0;
													$myhashmap_diferencia_ABS[$key]=0;
												}
										
											}
										
										
										}
										arsort($myhashmap_diferencia_ABS);
										$temp_key_max=array_keys($myhashmap_diferencia_ABS);
										$key_max=$temp_key_max[0];
										asort($myhashmap_diferencia_ABS);
										$temp_key_min=array_keys($myhashmap_diferencia_ABS);
										$key_min=$temp_key_min[0];
											
									
									$_string_max='<div style="margin-right:5px;display:inline;"><i class="fa fa-sort-asc" style="font-size:32px;color:#98DF58;padding:3px;"></i>'.$key_max.' <h2 style="display:inline">+'.$myhashmap_diferencia_ABS[$key_max].'</h2>('.round($myhashmap_diferencia[$key_max],1).'% )</div>';

									$_string_min='<i class="fa fa fa-sort-down" style="font-size:32px;color:#EC6464;padding:3px;margin-left:10px;"></i> '.$key_min.' <h2 style="display:inline">'.$myhashmap_diferencia_ABS[$key_min].'</h2>('.round($myhashmap_diferencia[$key_min],1).'% ) ';
									
									$string_tendencia_semana=$_string_max;
									if($myhashmap_diferencia[$key_min]<0){
										$string_tendencia_semana=$_string_max.' | '.$_string_min;
									}
									
									return $string_tendencia_semana;

	?><?php
}

function menu_periodos_estadisticas(){
	$html='<div id="menu_periodos_estadisticas" style="margin-top:5px;"><a <a style="margin-left:5px;margin-right:5px;" id="myLink_week" href="#" onclick="showLastSevenDays();">Últimos 7 días</a>';
	$html=$html.'|<a style="margin-left:5px;margin-right:5px;" id="myLink_month" href="#" onclick="showLastThirtyDays();">último mes</a>';
	$html=$html.'|<a style="margin-left:5px;margin-right:5px;" id="myLink_tri" href="#" onclick="showLastNinetyDays();">último trimestre</a></div>';
	
	return $html;
	
}
function menu_periodos_estadisticas_commodity(){
	$html='<div id="menu_periodos_estadisticas" style="margin-top:5px;"><a <a style="margin-left:5px;margin-right:5px;" id="myLink_week" href="#" onclick="showLastSevenDaysCommodity();">Últimos 7 días</a>';
	$html=$html.'|<a style="margin-left:5px;margin-right:5px;" id="myLink_month" href="#" onclick="showLastThirtyDaysCommodity();">último mes</a>';
	$html=$html.'|<a style="margin-left:5px;margin-right:5px;" id="myLink_tri" href="#" onclick="showLastNinetyDaysCommodity();">último trimestre</a></div>';
	
	return $html;
	
}
/***************** EVOLUCION CONCEPTOS SEGUIMIENTO*****************/
add_shortcode('evolucion_conceptos_seguimiento','evolucion_conceptos_seguimiento_shortcode');

function evolucion_conceptos_seguimiento_shortcode(){
	//$resultado=menu_periodos_estadisticas_detalle();
	$title='Evolución Entradas por concepto seguimiento';
	$hashmapSemana=evolucion_conc_seguimiento_semana_detalle_shortcode();
	$div_semana='graficos_evolucion_seg_3_semana';
	$subtitle_semana='(Últimos 7 días)';
	
	$hashmapMes=evolucion_conc_seguimiento_mes_detalle_shortcode();
	$div_mes='graficos_evolucion_seg_3_mes';
	$subtitle_mes='(últimos 30 días)';
	
	$hashmapTrimestre=evolucion_conc_seguimiento_trimestre_detalle_shortcode();
	$div_trimestre='graficos_evolucion_seg_3_trimestre';
	$subtitle_trimestre='(último trimestre)';
	?>
	

	<div style="position:relative;width:50%;float:left;border-bottom:1px dotted grey;border-left:1px dotted grey;padding-left: 10px;  "><div id="est_semana_seg_detalle">	<?php grafico_evolucion_conceptos_trimestre($hashmapSemana,$div_semana,$subtitle_semana,$title) ?></div>
	<div style="visibility:hidden;position:absolute;top:0; width:100%;   border: 0px solid red;" id="est_mes_seg_detalle"><?php grafico_evolucion_conceptos_trimestre($hashmapMes,$div_mes,$subtitle_mes,$title) ?></div>
	<div style="visibility:hidden;position:absolute;top:0; width:100%;   border: 0px solid blue;" id="est_trimestre_seg_detalle"><?php grafico_evolucion_conceptos_trimestre($hashmapTrimestre,$div_trimestre,$subtitle_trimestre,$title) ?></div></div>
	
	<?php
	

}


	

/****************DETALLE ESTADISTICAS*******************/
add_shortcode('estadistica_creciente_detalle','estadistica_creciente_detalle_shortcode');

function estadistica_creciente_detalle_shortcode(){
	//$resultado=menu_periodos_estadisticas_detalle();
		$title='Evolución Entradas por concepto';
		$categories = get_categories();
	$hashmapSemana=estadistica_creciente_semana_detalle_shortcode($categories);
	$div_semana='graficos_evolucion_3_semana';
	$subtitle_semana='(Últimos 7 días)';
	
	$hashmapMes=estadistica_creciente_mes_detalle_shortcode($categories);
	$div_mes='graficos_evolucion_3_mes';
	$subtitle_mes='(últimos 30 días)';
	
	$hashmapTrimestre=estadistica_creciente_trimestre_detalle_shortcode($categories);
	$div_trimestre='graficos_evolucion_3_trimestre';
	$subtitle_trimestre='(último trimestre)';
	?>
	

	<div style="position:relative;width:100%;float:left;border-bottom:0px dotted grey;border-left:0px dotted grey;padding-left: 10px;  "><div id="est_semana_detalle">	<?php grafico_evolucion_conceptos_trimestre($hashmapSemana,$div_semana,$subtitle_semana,$title) ?></div>
	<div style="visibility:hidden;position:absolute;top:0; width:100%;   border: 0px solid red;" id="est_mes_detalle"><?php grafico_evolucion_conceptos_trimestre($hashmapMes,$div_mes,$subtitle_mes,$title) ?></div>
	<div style="visibility:hidden;position:absolute;top:0; width:100%;   border: 0px solid blue;" id="est_trimestre_detalle"><?php grafico_evolucion_conceptos_trimestre($hashmapTrimestre,$div_trimestre,$subtitle_trimestre,$title) ?></div></div>
	
	<?php
}
/****************DETALLE ESTADISTICAS*******************/
add_shortcode('estadistica_creciente_detalle_usuario','estadistica_creciente_detalle_usuario_shortcode');

function estadistica_creciente_detalle_usuario_shortcode(){
	//$resultado=menu_periodos_estadisticas_detalle();
		$title='Evolución Entradas por concepto';
		$user_id = get_current_user_id();
	//echo $user_id;
	$categories = wp_get_object_terms($user_id, 'category');
	$hashmapSemana=estadistica_creciente_semana_detalle_shortcode($categories);
	$div_semana='graficos_evolucion_3_semana';
	$subtitle_semana='(Últimos 7 días)';
	
	$hashmapMes=estadistica_creciente_mes_detalle_shortcode($categories);
	$div_mes='graficos_evolucion_3_mes';
	$subtitle_mes='(últimos 30 días)';
	
	$hashmapTrimestre=estadistica_creciente_trimestre_detalle_shortcode($categories);
	$div_trimestre='graficos_evolucion_3_trimestre';
	$subtitle_trimestre='(último trimestre)';
	?>
	

	<div style="position:relative;width:95%;float:left;border-bottom:0px dotted grey;border-left:0px dotted grey;padding-left: 10px;  "><div id="est_semana_detalle">	<?php grafico_evolucion_conceptos_trimestre($hashmapSemana,$div_semana,$subtitle_semana,$title) ?></div>
	<div style="visibility:hidden;position:absolute;top:0; width:95%;   border: 0px solid red;" id="est_mes_detalle"><?php grafico_evolucion_conceptos_trimestre($hashmapMes,$div_mes,$subtitle_mes,$title) ?></div>
	<div style="visibility:hidden;position:absolute;top:0; width:95%;   border: 0px solid blue;" id="est_trimestre_detalle"><?php grafico_evolucion_conceptos_trimestre($hashmapTrimestre,$div_trimestre,$subtitle_trimestre,$title) ?></div></div>
	
	<?php
}

function estadistica_creciente_semana_detalle_shortcode($categories){

 									
 									$myhashmap_actual = array();
 									$myhashmap_anterior = array();
 									$myhashmap_diferencia = array();
 									$myhashmap_diferencia_ABS = array();
 									
 									$myhashmap_anterior_filtrado = array();
 									$myhashmap_actual_filtrado = array();
 									$hmTotal = array();
 									
									foreach ( $categories as $category ) {
										
										
										$args_semana_actual = array(
											'category_name'    => $category->name,
											'post_type'        => 'post',
											'post_status'      => 'publish',
											'suppress_filters' => true,
												'posts_per_page'=>-1,
											'date_query'	   => array('after' => date('Y-m-d', strtotime('-7 days'))) 
										);
										$args_semana_anterior = array(
												'category_name'    => $category->name,
												'post_type'        => 'post',
												'post_status'      => 'publish',
												'suppress_filters' => true,
												'posts_per_page'=>-1,
												'date_query'	   => array('before' => date('Y-m-d', strtotime('-4 days')),'after' => date('Y-m-d', strtotime('-20 days')))
										);
										
										$post_by_cat_semana_actual = get_posts($args_semana_actual);	
										$post_by_cat_semana_anterior = get_posts($args_semana_anterior);
										$counter_actual = 0;
										$counter_anterior = 0;
										foreach($post_by_cat_semana_actual as $p)
										{
											
											$counter_actual++;
										}
										foreach($post_by_cat_semana_anterior as $p)
										{	
											
											//echo $p->title;
											$counter_anterior++;
										}
										if ($counter_actual>0){
											$texto=str_replace("'","\'",$category->name);
											$myhashmap_actual[$texto] = $counter_actual;
											//echo 'ACTUAL: '.$texto.'-'.$counter_actual;
										}
										if ($counter_anterior>0){
											$texto=str_replace("'","\'",$category->name);
											$myhashmap_anterior[$texto] = $counter_anterior;
											//echo 'ANTERIOR: '.$texto.'-'.$counter_anterior;
										}
									
									}
									arsort($myhashmap_actual);	
									$max_results=0;
									foreach (array_keys($myhashmap_actual) as $key){
										//if($max_results>9){
										//	break;
										//}
										$diferencia=0;
										$valor_actual=0;
										$valor_anterior=0;
										$valor_actual=$myhashmap_actual[$key];
										$valor_anterior=$myhashmap_anterior[$key];
										if($myhashmap_anterior[$key]>0){
										
											//echo '----------'.$key.'----------';
											//echo 'VALOR_ACTUAL: '.$valor_actual;
										    //echo '---VALOR_ANTERIOR: '.$valor_anterior;
											$diferencia=($valor_actual-$valor_anterior);
											if ($diferencia >= 0){
												$myhashmap_diferencia_ABS[$key]=$diferencia;											
												$diferencia=$diferencia/$valor_anterior;
												//echo 'diferencia2:'.$diferencia;
												$myhashmap_diferencia[$key]=$diferencia*100;
											}
										
										}else{
											$myhashmap_diferencia[$key]=100;
											$myhashmap_diferencia_ABS[$key]=$valor_actual;
										}
						
									}
									arsort($myhashmap_diferencia_ABS);
									$_string_min='';
									$max_results=0;
								
									foreach (array_keys($myhashmap_diferencia_ABS) as $key){
										//echo '----------'.$key.'----------';
										if($max_results>9){
											break;
										}
										$myhashmap_anterior_filtrado[$key]=$myhashmap_anterior[$key];
										$myhashmap_actual_filtrado[$key]=$myhashmap_actual[$key];
										$max_results=$max_results+1;
										if($myhashmap_diferencia[$key]<0){
									
											$_string_min=$_string_min.'<i class="fa fa fa-sort-down" style="font-size:30px;color:#EC6464;padding:15px;margin-left:10px;"></i> '.$key.' <h2 style="display:inline;margin-left:10px;margin-right:10px;">'.$myhashmap_diferencia_ABS[$key].'</h2>('.$myhashmap_diferencia[$key].'% )<br> ';
												
										}else {
										
											$_string_min=$_string_min.'<i class="fa fa-sort-asc" style="font-size:30px;color:#98DF58;padding:15px;margin-left:10px;"></i> '.$key.' <h2 style="display:inline;margin-left:10px;margin-right:10px;">'.$myhashmap_diferencia_ABS[$key].'</h2>('.$myhashmap_diferencia[$key].'% )<br> ';
												
										}
									}
									
									arsort($myhashmap_actual_filtrado);
								
									$hmTotal['anterior']=$myhashmap_anterior_filtrado;
									$hmTotal['actual']=$myhashmap_actual_filtrado;
									$hmTotal['diferencia']=$myhashmap_diferencia_ABS;
									return $hmTotal;
										
									//return $_string_min;
									//return $myhashmap_diferencia_ABS;

	?><?php
}

function estadistica_creciente_mes_detalle_shortcode($categories){
	?>

		<?php 									
 									$myhashmap_actual = array();
 									$myhashmap_previo = array();
 									$myhashmap_diferencia = array();
 									$myhashmap_diferencia_ABS = array();
 									
 									$myhashmap_anterior_filtrado = array();
 									$myhashmap_actual_filtrado = array();
 									$hmTotal = array();
 									
									foreach ( $categories as $category ) {
										'mes'.$category->name;
										$args_semana_actual = array(
											'category_name'    => $category->name,
											'post_type'        => 'post',
											'post_status'      => 'publish',
											'suppress_filters' => true,
												'posts_per_page'=>-1,
											'date_query'	   => array('after' => date('Y-m-d', strtotime('-30 days'))) 
										);
										$args_semana_anterior = array(
												'category_name'    => $category->name,
												'post_type'        => 'post',
												'post_status'      => 'publish',
												'suppress_filters' => true,
												'posts_per_page'=>-1,
												'date_query'	   => array('before' => date('Y-m-d', strtotime('-30 days')),'after' => date('Y-m-d', strtotime('-60 days')))
										);
										
										$post_by_cat_semana_actual = get_posts($args_semana_actual);
										$post_by_cat_semana_anterior = get_posts($args_semana_anterior);
										$counter_actual = 0;
										$counter_anterior = 0;
										foreach($post_by_cat_semana_actual as $p)
										{
											$counter_actual++;
										}
										foreach($post_by_cat_semana_anterior as $p)
										{
											//echo $p->title;
											$counter_anterior++;
										}
										if ($counter_actual>0){
											$texto=str_replace("'","\'",$category->name);
											$myhashmap_actual[$texto] = $counter_actual;
											//echo 'ACTUAL: '.$texto.'-'.$counter_actual;
										}
										if ($counter_anterior>0){
											$texto=str_replace("'","\'",$category->name);
											$myhashmap_anterior[$texto] = $counter_anterior;
											//echo 'ANTERIOR: '.$texto.'-'.$counter_anterior;
										}
											
										}
										arsort($myhashmap_actual);
										$max_results=0;
										foreach (array_keys($myhashmap_actual) as $key){
											//if($max_results>9){
											//	break;
											//}
											$diferencia=0;
											$valor_actual=0;
											$valor_anterior=0;
											$valor_actual=$myhashmap_actual[$key];
											$valor_anterior=$myhashmap_anterior[$key];
											if($myhashmap_anterior[$key]>0){
										
												//echo '----------'.$key.'----------';
												//echo 'VALOR_ACTUAL: '.$valor_actual;
												//echo '---VALOR_ANTERIOR: '.$valor_anterior;
												$diferencia=($valor_actual-$valor_anterior);
												if ($diferencia >= 0){
													$myhashmap_diferencia_ABS[$key]=$diferencia;
													$diferencia=$diferencia/$valor_anterior;
													//echo 'diferencia2:'.$diferencia;
													$myhashmap_diferencia[$key]=$diferencia*100;
												}
										
											}else{
												$myhashmap_diferencia[$key]=100;
												$myhashmap_diferencia_ABS[$key]=$valor_actual;
											}
											
										}
										arsort($myhashmap_diferencia_ABS);
										$_string_min='';
											
										$max_results=0;
										foreach (array_keys($myhashmap_diferencia_ABS) as $key){
											//echo '----------'.$key.'----------';
											if($max_results>9){
												break;
											}
											$myhashmap_anterior_filtrado[$key]=$myhashmap_anterior[$key];
											$myhashmap_actual_filtrado[$key]=$myhashmap_actual[$key];
											$max_results=$max_results+1;
											if($myhashmap_diferencia[$key]<0){
													
												$_string_min=$_string_min.'<i class="fa fa fa-sort-down" style="font-size:30px;color:#EC6464;padding:15px;margin-left:10px;"></i> '.$key.' <h2 style="display:inline;margin-left:10px;margin-right:10px;">'.$myhashmap_diferencia_ABS[$key].'</h2>('.$myhashmap_diferencia[$key].'% )<br> ';
										
											}else {
										
												$_string_min=$_string_min.'<i class="fa fa-sort-asc" style="font-size:30px;color:#98DF58;padding:15px;margin-left:10px;"></i> '.$key.' <h2 style="display:inline;margin-left:10px;margin-right:10px;">'.$myhashmap_diferencia_ABS[$key].'</h2>('.$myhashmap_diferencia[$key].'% )<br> ';
										
											}
										}
											
										arsort($myhashmap_actual_filtrado);
										
										$hmTotal['anterior']=$myhashmap_anterior_filtrado;
										$hmTotal['actual']=$myhashmap_actual_filtrado;
										$hmTotal['diferencia']=$myhashmap_diferencia_ABS;
										return $hmTotal;

	?><?php
}
function estadistica_creciente_trimestre_detalle_shortcode($categories){
	?>
	
		<?php
 									
 									$myhashmap_actual = array();
 									$myhashmap_previo = array();
 									$myhashmap_diferencia = array();
 									$myhashmap_diferencia_ABS = array();
 									
 									$myhashmap_anterior_filtrado = array();
 									$myhashmap_actual_filtrado = array();
 									$hmTotal = array();
 									
									foreach ( $categories as $category ) {
										
										$args_semana_actual = array(
											'category_name'    => $category->name,
											'post_type'        => 'post',
											'post_status'      => 'publish',
											'suppress_filters' => true,
												'posts_per_page'=>-1,
											'date_query'	   => array('after' => date('Y-m-d', strtotime('-90 days'))) 
										);
										$args_semana_anterior = array(
												'category_name'    => $category->name,
												'post_type'        => 'post',
												'post_status'      => 'publish',
												'suppress_filters' => true,
												'posts_per_page'=>-1,
												'date_query'	   => array('before' => date('Y-m-d', strtotime('-90 days')),'after' => date('Y-m-d', strtotime('-180 days')))
										);
										
										$post_by_cat_semana_actual = get_posts($args_semana_actual);
										$post_by_cat_semana_anterior = get_posts($args_semana_anterior);
										$counter_actual = 0;
										$counter_anterior = 0;
										foreach($post_by_cat_semana_actual as $p)
										{
											$counter_actual++;
										}
										foreach($post_by_cat_semana_anterior as $p)
										{
											//echo $p->title;
											$counter_anterior++;
										}
										if ($counter_actual>0){
											$texto=str_replace("'","\'",$category->name);
											$myhashmap_actual[$texto] = $counter_actual;
											//echo 'ACTUAL: '.$texto.'-'.$counter_actual;
										}
										if ($counter_anterior>0){
											$texto=str_replace("'","\'",$category->name);
											$myhashmap_anterior[$texto] = $counter_anterior;
											//echo 'ANTERIOR: '.$texto.'-'.$counter_anterior;
										}
											
										}
										arsort($myhashmap_actual);
										$max_results=0;
										foreach (array_keys($myhashmap_actual) as $key){
											//if($max_results>9){
											//	break;
											//}
											$diferencia=0;
											$valor_actual=0;
											$valor_anterior=0;
											$valor_actual=$myhashmap_actual[$key];
											$valor_anterior=$myhashmap_anterior[$key];
											if($myhashmap_anterior[$key]>0){
										
											
												$diferencia=($valor_actual-$valor_anterior);
												if ($diferencia >= 0){
													//echo '----------'.$key.'----------';
													//echo 'VALOR_ACTUAL: '.$valor_actual;
													//echo '---VALOR_ANTERIOR: '.$valor_anterior;
													$myhashmap_diferencia_ABS[$key]=$diferencia;
													$diferencia=$diferencia/$valor_anterior;
													//echo 'diferencia2:'.$diferencia;
													$myhashmap_diferencia[$key]=$diferencia*100;
												}
										
											}else{
												$myhashmap_diferencia[$key]=100;
												$myhashmap_diferencia_ABS[$key]=$valor_actual;
											}
											
										}
										arsort($myhashmap_diferencia_ABS);
										$_string_min='';
										$max_results=0;
										
										foreach (array_keys($myhashmap_diferencia_ABS) as $key){
											//echo '----------'.$key.'----------';
											if($max_results>9){
												break;
											}
											//echo '**** '.$key.'----------';
											//echo '******** VALOR_ACTUAL: '.$valor_actual;
											//echo '***VALOR_ANTERIOR: '.$valor_anterior;
											$myhashmap_anterior_filtrado[$key]=$myhashmap_anterior[$key];
											$myhashmap_actual_filtrado[$key]=$myhashmap_actual[$key];
											$max_results=$max_results+1;
											if($myhashmap_diferencia[$key]<0){
													
												$_string_min=$_string_min.'<i class="fa fa fa-sort-down" style="font-size:30px;color:#EC6464;padding:15px;margin-left:10px;"></i> '.$key.' <h2 style="display:inline;margin-left:10px;margin-right:10px;">'.$myhashmap_diferencia_ABS[$key].'</h2>('.$myhashmap_diferencia[$key].'% )<br> ';
										
											}else {
										
												$_string_min=$_string_min.'<i class="fa fa-sort-asc" style="font-size:30px;color:#98DF58;padding:15px;margin-left:10px;"></i> '.$key.' <h2 style="display:inline;margin-left:10px;margin-right:10px;">'.$myhashmap_diferencia_ABS[$key].'</h2>('.$myhashmap_diferencia[$key].'% )<br> ';
										
											}
										}
											
										arsort($myhashmap_actual_filtrado);
										
										$hmTotal['anterior']=$myhashmap_anterior_filtrado;
										$hmTotal['actual']=$myhashmap_actual_filtrado;
										$hmTotal['diferencia']=$myhashmap_diferencia_ABS;
										return $hmTotal;

	?><?php
}

function menu_periodos_estadisticas_detalle(){
	$html='<div id="menu_periodos_estadisticas"><a <a style="margin-right:5px;" id="myLink_week" href="#" onclick="showLastSevenDaysDetail();">Últimos 7 días</a>';
	$html=$html.'|<a style="margin-left:5px;margin-right:5px;" id="myLink_month" href="#" onclick="showLastThirtyDaysDetail();">último mes</a>';
	$html=$html.'|<a style="margin-left:5px;margin-right:5px;" id="myLink_tri" href="#" onclick="showLastNinetyDaysDetail();">último trimestre</a></div>';
	
	echo $html;
	
}

function menu_periodos_estadisticas_fuente(){
	//genera_array_ultimos_doce_meses();
	
	$html='<div id="menu_periodos_estadisticas"><a <a style="margin-right:5px;" id="myLink_week" href="#" onclick="showLastSevenDaysSources();">Últimos 7 días</a>';
	$html=$html.'|<a style="margin-left:5px;margin-right:5px;" id="myLink_month" href="#" onclick="showLastThirtyDaysSources();">último mes</a>';
	$html=$html.'|<a style="margin-left:5px;margin-right:5px;" id="myLink_tri" href="#" onclick="showLastNinetyDaysSources();">último trimestre</a></div>';

	echo $html;

}

function genera_array_ultimos_doce_meses(){
	$previo=0;
	$doce_meses=array('','','','','','','','','','','','');
	$strMes='[';
	$primero=0;
	foreach ($doce_meses as &$mes) {
		$mes=date('M', strtotime("first day of".$previo. "month"));
		if($primero>0){
			$strMes=$strMes.',';
		}
		$strMes=$strMes.'\''.$mes.'\'';
		$previo=$previo-1;
		$primero=$primero+1;
	}
	$strMes=$strMes.']';
	return $strMes;

}
add_shortcode('grafico_evolucion_anual_conceptos','grafico_evolucion_anual_conceptos_shortcode');
function grafico_evolucion_anual_conceptos_shortcode(){
	?>
	<div >
		<br>
		<h3>Evolución anual conceptos</h3>
	
		<script>
			jQuery(document).ready(function run_module_graphics($)
			{
		var grafica_entradas_x_tags = function run_module_graphics_4(){	
					<?php
						$categories = get_categories();
						//$colors=array('#000000','#661400','#991f00','#cc2900','#ff471a','#ff704d','#ff8566','#ff9980','#ffc2b3','#ffd6cc',' #ffebe6',' #f8dbd3');
						$colors= get_color_sequence();
						$color_index=0;
					?>
					
					var chart3 = new Highcharts.Chart({
						   legend: {
						        align: 'left',
						        verticalAlign: 'top',
						        layout: 'vertical',
						        x: 0,
						        y: 62
						    },
						chart: {
							renderTo: 'graficos_modulos_anyo',
							type: 'line',
							options3d: {
								enabled: true,
								alpha: 45
							}
						},
						exporting: { enabled: false },
						title: {
							text: null
						},  xAxis: {
					        categories: <?php echo genera_array_ultimos_doce_meses();?>
					    },
						 yAxis: {
				            min: 0,
				            title: {
				                text: 'Número de entradas',
				   
				            },
				            labels: {
				                overflow: 'justify'
				            }
				        },
						series: [
				
							<?php
										$first=0;
										$myhashmap = array();
						
										foreach ( $categories as $category ) {
									
											$args = array(
												'category_name'    => $category->name,
												'post_type'        => 'post',
												'post_status'      => 'publish',
												'suppress_filters' => true,
													'posts_per_page'=>-1,
												'date_query'	   => array('after' => date('Y-m-d', strtotime('-365 days'))) 
											);
											
											$post_by_cat = get_posts($args);	
											$counter = 0;
											foreach($post_by_cat as $p)
											{
												$counter++;
											}
											
											if ($counter>0){
	
											$texto=str_replace("'","\'",$category->name);
											$myhashmap[$texto] = $counter;
	
											}
									
										}
										arsort($myhashmap);
										$max_results=0;
										foreach (array_keys($myhashmap) as $key){
											if($max_results>9){
												break;
											}
											if($max_results>0){
												echo ',';
											}
								
											echo '{name:\''.$key.'\',data:'. get_evolution_serie_category($key).',color: \''.$colors[$color_index].'\'}';
											if($color_index<sizeof($colors)-1){
												$color_index=$color_index+1;
											}else{
												$color_index=0;
											}
											$max_results=$max_results+1;
											
										}
										
										?>
							]
					});						
				}
			grafica_entradas_x_tags();
	});
		</script>
	
		
		<div id="grafico_evolucion_tags">
		
		<div id="graficos_modulos_anyo">
		
		</div>
	</div>
		</div>
	
	
	<?php
}
function get_evolution_serie_category($category){
	//echo date('Y-m-d', strtotime("last day of 0 month"));
	$previo=-1;
	$entradas_mes=array('','','','','','','','','','','','');
	$strEntradasMes='[';
	foreach ($entradas_mes as &$num_entradas) {
		if($previo<-1){
			//echo ' previo -1)';
			$strEntradasMes=$strEntradasMes.',';
			$args = array(
					'category_name'    => $category,
					'post_type'        => 'post',
					'post_status'      => 'publish',
					'suppress_filters' => true,
					'posts_per_page'=>-1,
					'date_query'	   => array('after' => date('Y-m-d', strtotime("last day of".($previo-1). "month")),
							'before' => date('Y-m-d', strtotime("first day of".($previo+1). "month")))
			);
		}else{
			//echo 'ELSE)';
			$args = array(
					'category_name'    => $category,
					'post_type'        => 'post',
					'post_status'      => 'publish',
					'suppress_filters' => true,
					'posts_per_page'=>-1,
					'date_query'	   => array('after' => date('Y-m-d', strtotime("last day of -1 month")))
			);
		}
		//echo  strtotime("last day of".($previo));
		//echo  strtotime("first day of".($previo+1));
	
		/*echo('------------');
		echo('date_ini: '.date('Y-m-d', strtotime("last day of".($previo). "month")));
		echo('date_end: '.date('Y-m-d', strtotime("first day of".($previo+1). "month")));*/
		$post_by_cat = get_posts($args);
		//echo $post_by_cat->request;
		$counter = 0;
		foreach($post_by_cat as $p)
		{
			$counter++;
		}
		$num_entradas=$counter;
		$strEntradasMes=$strEntradasMes.$counter;
	//	echo '--'.$num_entradas.'---';
		$previo=$previo-1;
	}
	$strEntradasMes=$strEntradasMes.']';
	return $strEntradasMes;
}
 
 
 
 /***************************************/
function grafico_evolucion_conceptos_trimestre($myhashmap,$div,$subtitlePeriod,$title){
	$myhashmap_anterior = $myhashmap['anterior'];
	$myhashmap_actual= $myhashmap['actual'];
	$myhashmap_anterior_size=sizeof($myhashmap_anterior);
	$myhashmap_actual_size=sizeof($myhashmap_actual);
	?>
	<br>
	<h3><?php echo $title ?></h3><?php echo $subtitlePeriod;
	
	if ($myhashmap_anterior_size > 0 && $myhashmap_actual_size>0){?>
	<br>
	<i>Se muestran los incrementos en el número de impactos más relevantes.</i>

	<script>
		jQuery(document).ready(function run_module_graphics($)
		{
	var grafica_entradas_x_tags = function run_module_graphics_4(){	
				<?php
					//$categories = get_categories();
					$colors=  get_color_sequence();
				//	$colors_negative=  get_negative_color_sequence();
					$color_index=0;
					$data_actual='';
					$data_anterior='';
				?>
				//$('#graficos_modulos_3').css('border','1px solid #999');
				//$('#graficos_modulos_3').css('box-shadow','2px 2px 10px #999');
				//$('#graficos_modulos_3').css('width','1003px');
				
				var chart3 = new Highcharts.Chart({
				
					chart: {
						renderTo: '<?php echo $div ?>',
						type: 'column',
						options3d: {
							enabled: true,
							alpha: 45
						}
					},
					exporting: { enabled: false },
					title: {
						text: null
					},
					 yAxis: {
			            min: 0,
			            title: {
			                text: 'Número de entradas'
			          
			            },
			            labels: {
				              overflow: 'justify'
			            }
			        },
			        xAxis:{
				        	categories: [<?php 
					        	$max_results=0;
					        	foreach (array_keys($myhashmap_actual) as $key){
					        		if($max_results>9){
					        			break;
					        		}
					        		if ($first>0){
					        			echo ',';
					        			$data_actual=$data_actual.',';
					        			$data_anterior = $data_anterior.',';
					        		}
					        		
					        		if (array_key_exists (  $key ,$myhashmap_actual)){
					        			$data_actual = $data_actual.$myhashmap_actual[$key];
					        		} else {
					        			$data_actual = $data_actual.'0';
					        		}
					        		
					        		if ($myhashmap_anterior[$key]<>''){
					        			$data_anterior = $data_anterior.$myhashmap_anterior[$key];
					        		} else {
					        			$data_anterior = $data_anterior.'0';
					        		}
					        	
					        
					        		echo '\''.$key.'\'';
					        	
					        		$first=$first+1;
					        		$max_results=$max_results+1;
					        	}
					        	?>


					        	]},
				            plotOptions: {
				                column: {
				                    grouping: false,
				                    shadow: false,
				                    borderWidth: 0,
				                    dataLabels: {
				                        enabled: true,
				                        color: 'gray'
				                    }
				                }
				                
				            },    tooltip: {
				                shared: true
				            },
					series: [{
						name: 'Periodo actual',
						color: <?php echo '\''.$colors[4].'\'';?>,
						data: [	<?php echo $data_actual;?>],
						pointPadding:0.2,
						pointPlacement:-0},
						{
							name: 'Periodo anterior',
							color: <?php echo '\''.$colors[7].'\''; ?>,
							data: 	[<?php echo $data_anterior;?>],
							pointPadding:0.3,
							pointPlacement:0}
				
						]
				});						
			}
		grafica_entradas_x_tags();
});
	</script>
<?php } else {
					echo '<br><br><i>No hay entradas para el periodo seleccionado.</i>';
				}
					?>
	
	<div id="grafico_evolucion_tags">
	
	<div id="<?php echo $div ?>">
	
	</div>
</div>
<?php
}

add_shortcode('nube_conceptos_seguimiento_usuario_shortcode', 'nube_conceptos_seguimiento');
function nube_conceptos_seguimiento( )
{
	$user_id = get_current_user_id();
	$user_risks = get_user_conceptos_seguimiento($user_id);

	//echo implode(",",$user_risks);
	$args = array(
			'smallest'                  => 8,
			'largest'                   => 22,
			'unit'                      => 'pt',
			'number'                    => 30,
			'format'                    => 'flat',
			'separator'                 => "\n",
			'orderby'                   => 'name',
			'order'                     => 'ASC',
			'exclude'                   => null,
			'include'                   => $user_risks,
			'link'                      => 'view',
			'taxonomy'                  => 'concepto_seguimiento',
			'echo'                      => false,
			'child_of'                  => null, // see Note!
			'show_count' => 0
	);
	// echo implode(",",$args);
	//'http://localhost/iwatch4.0/iwatch4.0/wp-admin/edit-tags.php?taxonomy=concepto_seguimiento'
	
	$admin='<br><u><a href="'.get_site_url().'/wp-admin/edit-tags.php?taxonomy=concepto_seguimiento"><i>Administrar...</i></u></a>';
	$admin='<div style="position:relative;height:25px;border:solid black 0px;"><div style="margin-right:5px;position:absolute;right:0px;top:0px;"><a href="'.get_site_url().'/wp-admin/edit-tags.php?taxonomy=concepto_seguimiento"><i>Administrar conceptos seguimiento....</i></a></div></div>';
	
	return wp_tag_cloud( $args ).$admin;
}
add_shortcode('nube_categorias_usuario_shortcode', 'nube_categorias');
function nube_categorias( )
{
	$user_id = get_current_user_id();
	//echo $user_id;
	$user_categories = wp_get_object_terms($user_id, 'category',array('fields'=>'ids'));
		//global $wpdb;
	//echo $wpdb->last_query;
//	echo implode(",",$user_risks);
	$args = array(
			'smallest'                  => 8,
			'largest'                   => 22,
			'unit'                      => 'pt',
			'number'                    => 30,
			'format'                    => 'flat',
			'separator'                 => "\n",
			'orderby'                   => 'name',
			'order'                     => 'ASC',
			'exclude'                   => null,
			'include'                   => $user_categories,
			'link'                      => 'view',
			'taxonomy'                  => 'category',
			'echo'                      => false,
			'child_of'                  => null, // see Note!
	);
	// echo implode(",",$args);
	return wp_tag_cloud( $args ).'<br><p style="padding-bottom:3px;"><i> Ver más categorías: </p>'.desplegable_categorias($user_categories).'</i>';
}
add_shortcode('desplegable_categorias', 'desplegable_categorias');
function desplegable_categorias($user_categories){
	
	$taxonomy='category';
	$id_element2='dd_categorias';
	$option_none='Seleccione una categoría';
	$html='';
	$html= ddl_categorias($taxonomy,$id_element2,$option_none,$user_categories);
	$html=$html.'<script type="text/javascript">
		
		var dropdown2 = document.getElementById("'.$id_element2.'");
		function onDistrChange() {
			if ( dropdown2.options[dropdown2.selectedIndex].value != "'.$option_none.'" ) {
				location.href = "'. esc_url( home_url( '/' ) ).'?'.'cat'.'="+dropdown2.options[dropdown2.selectedIndex].value;
			}
		}
		
		dropdown2.style.width="100%";
		dropdown2.onchange = onDistrChange;
	
	</script>';
	return $html;
}
function ddl_categorias($taxonomy, $id_element,$option_none,$user_categories){

 $args = array(
	'show_option_all'    => '',
	'show_option_none'   => $option_none,
	'option_none_value'  => '-1',
	'orderby'            => 'name',
	'order'              => 'ASC',
	'show_count'         => 0,
	'hide_empty'         => 1,
	'child_of'           => 0,
	'exclude'            => '',
	'include'            => $user_categories,
	'echo'               => 0,
	'selected'           => 0,
	'hierarchical'       => 0,
	'name'               => $id_element,
	'id'                 => $id_element,
	'class'              => 'term_dd',
	'depth'              => 0,
	'tab_index'          => 0,
	'taxonomy'           => $taxonomy,
	'hide_if_empty'      => false,
	'value_field'	     => 'id'); 
 
 
    return wp_dropdown_categories( $args ); 
}

add_shortcode('tabla_alertas', 'tabla_alertas');
function tabla_alertas( $atts, $content = null  ){
	echo menu_periodos_estadisticas_commodity();
	echo '<div id="seguimiento" style="position:relative;border:solid 0px black;height:450px;">';
	tabla_alertas_tipo_alerta('alerta_busqueda','conceptos de búsqueda','bus'  );
	echo '</div><div id="busqueda" style="position:relative">';
	tabla_alertas_tipo_alerta('alerta_seguimiento','conceptos de seguimiento','seg'  );
	echo '</div>';
}
function tabla_alertas_tipo_alerta($tipo_alerta,$titulo_tipo_alerta,$sufix  )
{
	
	//$tipo_alerta='alerta_seguimiento';
	//$titulo_tipo_alerta='conceptos de seguimiento';
	$user_id = get_current_user_id();
	if($sufix=='bus'){
		$titulo='Búsqueda';
		$user_categories =  wp_get_object_terms($user_id, 'category',array('fields'=>'ids'));
	}else{
		
		$titulo='Seguimiento';
		$user_categories =  wp_get_object_terms($user_id, 'concepto_seguimiento',array('fields'=>'ids'));
	}
								
	
	$recssemana = query_tendencia_con_limites_alertas (7,$user_categories,$tipo_alerta);
	$recsmes = query_tendencia_con_limites_alertas (30,$user_categories,$tipo_alerta);
	$recstrimestre = query_tendencia_con_limites_alertas (90,$user_categories,$tipo_alerta);
	$datos_grafico_semana=genera_datos_alertas(90,7,$tipo_alerta);
	$datos_grafico_mes=genera_datos_alertas(180,30,$tipo_alerta);
	$datos_grafico_trimestre=genera_datos_alertas(360,90,$tipo_alerta);
	
//	$resultado=menu_periodos_estadisticas();
	$resultado=$resultado.'<div style="position:relative"><div id="est_semana_'.$sufix.'"><div style="width:49%;float:left;"><br>'.genera_html_tabla($recssemana,$titulo).'</div>';
	$resultado=$resultado.'<div id="grafico"" style="width:49%;float:left;">';
	echo $resultado;
	$resultado='';
	grafica_alertas('div_para_pintar_grafico_1_'.$sufix,$datos_grafico_semana,'Alertas semanales '.$titulo_tipo_alerta.' en el último trimestre');
	$resultado=$resultado.'</div></div>';
	echo $resultado;
	$resultado='';
	$resultado=$resultado.'<div style="visibility:hidden;position:absolute;top:0;margin-bottom:5px;width:100%" id="est_mes_'.$sufix.'"><div style="width:49%;float:left;"><br>'.genera_html_tabla($recsmes,$titulo).'</div>';
	$resultado=$resultado.'<div id="grafico"" style="width:49%;float:left;">';
	echo $resultado;
	$resultado='';
	grafica_alertas('div_para_pintar_grafico_2_'.$sufix,$datos_grafico_mes,'Alertas mensuales '.$titulo_tipo_alerta.' en el último semestre');
	$resultado=$resultado.'</div></div>';
	echo $resultado;
	$resultado='';
	$resultado=$resultado.'<div style="visibility:hidden;position:absolute;top:0;margin-bottom:5px;width:100%" id="est_trimestre_'.$sufix.'"><div style="width:49%;float:left;"><br>'.genera_html_tabla($recstrimestre,$titulo).'</div>';
	$resultado=$resultado.'<div id="grafico"" style="width:49%;float:left;">';
	echo $resultado;
	$resultado='';
	grafica_alertas('div_para_pintar_grafico_3_'.$sufix,$datos_grafico_trimestre,'Alertas trimestrales '.$titulo_tipo_alerta.' en el último año');
	$resultado=$resultado.'</div></div></div>';
	echo $resultado;
	 
	
}
function grafica_alertas($div,$myhashmap,$subtitlePeriod){

	$myhashmap_anterior = $myhashmap['decrementos'];
	$myhashmap_actual= $myhashmap['incrementos'];
	$myhashmap_anterior_size=sizeof($myhashmap_anterior);
	$myhashmap_actual_size=sizeof($myhashmap_actual);
	
	//$html=
	?>
	<br>
	<?php echo $subtitlePeriod;
	
	if ($myhashmap_anterior_size > 0 && $myhashmap_actual_size>0){?>
	<br>
	

	<script>
		jQuery(document).ready(function run_module_graphics($)
		{
	var grafica_entradas_x_tags = function run_module_graphics_4(){	
				<?php

					$colors=  get_color_sequence();
					$color_index=0;
					$data_actual='';
					$data_anterior='';
				?>
						
				var chart3 = new Highcharts.Chart({
				
					chart: {
						renderTo: '<?php echo $div ?>',
						type: 'column',
						options3d: {
							enabled: true,
							alpha: 45
						}
					},
					  credits: {
				        enabled: false
				    },
					exporting: { enabled: false },
					title: {
						text: null
					},
					 yAxis: {
			            min: 0,
			            title: {
			                text: 'Número de alertas'
			          
			            },
			            labels: {
				              overflow: 'justify'
			            }
			        },
			        xAxis:{
				        	categories: [
				        	
				<?php 
					        	$max_results=0;
					        	foreach (array_keys($myhashmap_actual) as $key){
					        		//echo 'valor'.$myhashmap_actual[$key];
					        	
					        		
					        		if ($myhashmap_actual[$key]<>0 ||$myhashmap_anterior[$key]<>0){
					        			if ($first>0){
					        			echo ',';
					        			$data_actual=$data_actual.',';
					        			$data_anterior = $data_anterior.',';
					        		}
						        		if (array_key_exists (  $key ,$myhashmap_actual)){
						        			$data_actual = $data_actual.$myhashmap_actual[$key];
						        		} else {
						        			$data_actual = $data_actual.'0';
						        		}
						        		
						        		if ($myhashmap_anterior[$key]<>''){
						        			$data_anterior = $data_anterior.$myhashmap_anterior[$key];
						        		} else {
						        			$data_anterior = $data_anterior.'0';
						        		}
						        	
						        
						        		echo '\''.$key.'\'';
						        	
						        		$first=$first+1;
					        		}
					       
					        	}
					        	?>


					        	]},
				            plotOptions: {
				                column: {
					        		 stacking: 'normal',
				                    grouping: false,
				                    shadow: false,
				                    borderWidth: 0,
				                    dataLabels: {
				                        enabled: true,
				                        color: 'gray'
				                    }
				                }
				                
				            },    tooltip: {
				                shared: true
				            },
					series: [{
						name: 'Ascensos',
						color: <?php echo '\'#98DF58\''; ?>,
						data: [	<?php echo $data_actual;?>]},
						{
							name: 'Descensos',
							
							color: <?php echo '\'#EC6464\'';?>,
							data: 	[<?php echo $data_anterior;?>]
							}
				
						]
				});						
			}
		grafica_entradas_x_tags();
});
	</script>
<?php } else {
					echo '<br><br><i>No hay entradas para el periodo seleccionado.</i>';
				}
					?>
	
	<div id="grafico_evolucion_tags">
	
	<div id="<?php echo $div ?>" >
	
	</div>
</div>
<?php
}
/**
 * Función que devuelve las alertas activas para un usuario
 * @param string $post_type (admite dos valores: 'alerta_busqueda' y 'alerta_seguimiento' en función del tipo que se quiera recuperar
 * @param unknown_type $user_id
 */
function query_alertas_activas($post_type,$user_id){
	global $wpdb;
	$query='select alertas.post_title as titulo,terms.term_id,terms.name,meta_limite1.meta_value umbral_ascenso,meta_limite2.meta_value umbral_descenso
			 from wp_posts alertas 
			 STRAIGHT_JOIN wp_term_relationships rel_cat_alerta ON alertas.ID = rel_cat_alerta.object_id 
			 STRAIGHT_JOIN wp_term_taxonomy tax on tax.term_taxonomy_id=rel_cat_alerta.term_taxonomy_id 
			 STRAIGHT_JOIN wp_terms terms on terms.term_id=tax.term_id 
			 STRAIGHT_JOIN wp_postmeta meta on meta.post_id=alertas.ID and meta.meta_key=\'activa\' and meta.meta_value>0 
			 STRAIGHT_JOIN wp_postmeta meta_limite1 on meta_limite1.post_id=alertas.ID and meta_limite1.meta_key=\'umbral_ascenso\'
			 STRAIGHT_JOIN wp_postmeta meta_limite2 on meta_limite2.post_id=alertas.ID and meta_limite2.meta_key=\'umbral_descenso\'
			  where post_type=\''.$post_type.'\' and post_status=\'publish\'';
	//echo $query;
	
	//echo '<br>antes de la consulta';
		$results=$wpdb->get_results( $query);
	//	echo 'despues de la consulta';


	return $results;
}
function genera_datos_alertas($periodo,$frecuencia,$tipo_alerta){
	
	$alertas=query_alertas_activas($tipo_alerta,1);
	$hashAlertasIncremento;
	$hashAlertasDecremento;
	$hashDiferencias;
	if (sizeof($alertas)>0){
		foreach ($alertas as $alerta): 
			$conceptos_con_alerta[]=$alerta->term_id;		
			$hashAlertasIncremento[$alerta->name]=0;
			$hashAlertasDecremento[$alerta->name]=0;
		endforeach;
		
		$categorias=implode(",",$conceptos_con_alerta);
		$alerts=false;
		for ($i = 0; $i <= $periodo; $i=$i+$frecuencia) {
			
	   		$fecha_inicio= date('Y-m-d', strtotime('-'.$i.' days'));
			$fecha_fin_actual= date('Y-m-d', strtotime('-'.($i+$frecuencia).' days'));
			$fecha_inicio_anterior= date('Y-m-d', strtotime('-'.($i+2*$frecuencia).' days'));
		
			//echo 'categorias: '.$categorias;
			$resultados = query_tendencia_fechas($fecha_inicio,$fecha_fin_actual,$fecha_fin_actual,$fecha_inicio_anterior,$conceptos_con_alerta);
			if (sizeof($resultados)>0){
					//echo '<br>-----------------------------------------------<br>';
					//echo '<br>'.$fecha_inicio.','.$fecha_fin_actual.','.$fecha_inicio_anterior.'--';
				foreach ($resultados as $resultado): 
					if ($resultado->name_actual){
						$categoria=$resultado->name_actual;
					}
					if ($resultado->name_anterior){
						$categoria=$resultado->name_anterior;
					}
				//	echo '<br>---DIFERENCIA --------'.$resultado->diferencia.'--------------------<br>';
					if($resultado->cuenta_anterior > 0){
						$dif_porcentaje=round (($resultado->diferencia/$resultado->cuenta_anterior) * 100,1);
					
					}else{
						$dif_porcentaje=round (($resultado->diferencia/abs($resultado->diferencia)) * 100,1);
					}
				//	echo '<br>---DIFERENCIA %--------'.$dif_porcentaje.'--------------------<br>';
					if($dif_porcentaje>0 && $dif_porcentaje>$alerta->umbral_ascenso){
				
					//	echo 'MAYOR<br>';
					//	echo 'antes suma '.$categoria.':'.$hashAlertasIncremento[$categoria];
						$hashAlertasIncremento[$categoria]=$hashAlertasIncremento[$categoria]+1;
						$alerts=true;
					//	echo 'despues suma '.$hashAlertasIncremento[$categoria];
					}else if($resultado->diferencia<0 && $dif_porcentaje<$alerta->umbral_descenso){
						//echo 'MENOR<br>';
						//echo 'antes suma '.$categoria.':'.$hashAlertasDecremento[$categoria];
						$hashAlertasDecremento[$categoria]=$hashAlertasDecremento[$categoria]+1;
						$alerts=true;
						//echo 'despues suma '.$hashAlertasDecremento[$categoria];
					}
				
				endforeach;
			}
		}
	}
	/*echo '<br>-------------------------------<br>';
	echo $alerts;
	echo '<br>-------------------------------<br>';
	foreach (array_keys($hashAlertasDecremento) as $key){
		echo $key.'-'.$hashAlertasDecremento[$key].'<br>';
		
	}
	echo '<br>-------------------------------<br>';
	foreach (array_keys($hashAlertasIncremento) as $key){
		echo $key.'-'.$hashAlertasIncremento[$key].'<br>';
		
	}*/
	
	if($alerts){
		$hashDiferencias['incrementos']=$hashAlertasIncremento;
		$hashDiferencias['decrementos']=$hashAlertasDecremento;
	}
	
	return $hashDiferencias;
	
}
/**
  * Función que compara el número de entradas por concepto en dos periodos consecutivos.
 * @param unknown_type $fecha_inicio_actual
 * @param unknown_type $fecha_fin_actual
 * @param unknown_type $fecha_inicio_anterior
 * @param unknown_type $fecha_fin_anterior
 * @param unknown_type $user_categories
 * @return  Array result term_id, term_name and number of entries per term for current period and previous and difference>
 *
 */
function query_tendencia_fechas ($fecha_inicio_actual,$fecha_fin_actual,$fecha_inicio_anterior,$fecha_fin_anterior,$user_categories){
	//echo 'query_tendencia';
	global $wpdb;
	//echo '<br>-----------------------------------------------<br>';
	
	//$user_id = get_current_user_id();
	//$user_categories = wp_get_object_terms($user_id, 'category',array('fields'=>'all'));
	// echo 'categories--'.implode(",",$user_categories);
	
	$query='select * from 
 (select actual.term_id id_actual,anterior.term_id id_anterior,actual.name name_actual,anterior.name name_anterior,COALESCE(actual.cuenta,0) cuenta_actual,COALESCE(anterior.cuenta,0) cuenta_anterior
, (coalesce(actual.cuenta,0)-coalesce(anterior.cuenta,0))as diferencia 
from
 (select cat_usu.name,cat_usu.term_id,count(distinct posts.ID) as cuenta 
	from ( SELECT * from wp_posts p WHERE p.post_date < %s and p.post_date > %s AND p.post_type = \'post\' AND p.post_status = \'publish\' ) posts 
STRAIGHT_JOIN wp_term_relationships rel_cat_usu ON posts.ID = rel_cat_usu.object_id 
STRAIGHT_JOIN wp_term_taxonomy tax_cat_usu ON rel_cat_usu.term_taxonomy_id=tax_cat_usu.term_taxonomy_id 
STRAIGHT_JOIN wp_terms cat_usu ON tax_cat_usu.term_id=cat_usu.term_id and cat_usu.term_id in('.implode(",",$user_categories).') GROUP BY cat_usu.name) 
actual 
LEFT JOIN 
(select cat_usu.name,cat_usu.term_id,count(distinct posts.ID) as cuenta 
	from ( SELECT * from wp_posts p WHERE p.post_date < %s and p.post_date > %s AND p.post_type = \'post\' AND p.post_status = \'publish\' ) posts 
STRAIGHT_JOIN wp_term_relationships rel_cat_usu ON posts.ID = rel_cat_usu.object_id 
STRAIGHT_JOIN wp_term_taxonomy tax_cat_usu ON rel_cat_usu.term_taxonomy_id=tax_cat_usu.term_taxonomy_id 
STRAIGHT_JOIN wp_terms cat_usu ON tax_cat_usu.term_id=cat_usu.term_id and cat_usu.term_id in('.implode(",",$user_categories).') GROUP BY cat_usu.name) 
anterior on anterior.term_id=actual.term_id) TABLA1
UNION
 (select actual.term_id id_actual,anterior.term_id id_anterior,actual.name name_actual,anterior.name name_anterior,COALESCE(actual.cuenta,0) cuenta_actual,COALESCE(anterior.cuenta,0) cuenta_anterior
, (coalesce(actual.cuenta,0)-coalesce(anterior.cuenta,0))as diferencia 
from
 (select cat_usu.name,cat_usu.term_id,count(distinct posts.ID) as cuenta 
	from ( SELECT * from wp_posts p WHERE p.post_date < %s and p.post_date > %s AND p.post_type = \'post\' AND p.post_status = \'publish\' ) posts 
STRAIGHT_JOIN wp_term_relationships rel_cat_usu ON posts.ID = rel_cat_usu.object_id 
STRAIGHT_JOIN wp_term_taxonomy tax_cat_usu ON rel_cat_usu.term_taxonomy_id=tax_cat_usu.term_taxonomy_id 
STRAIGHT_JOIN wp_terms cat_usu ON tax_cat_usu.term_id=cat_usu.term_id and cat_usu.term_id in('.implode(",",$user_categories).') GROUP BY cat_usu.name) 
actual 
RIGHT JOIN 
(select cat_usu.name,cat_usu.term_id,count(distinct posts.ID) as cuenta 
	from ( SELECT * from wp_posts p WHERE p.post_date < %s and p.post_date > %s AND p.post_type = \'post\' AND p.post_status = \'publish\' ) posts 
STRAIGHT_JOIN wp_term_relationships rel_cat_usu ON posts.ID = rel_cat_usu.object_id 
STRAIGHT_JOIN wp_term_taxonomy tax_cat_usu ON rel_cat_usu.term_taxonomy_id=tax_cat_usu.term_taxonomy_id 
STRAIGHT_JOIN wp_terms cat_usu ON tax_cat_usu.term_id=cat_usu.term_id and cat_usu.term_id in('.implode(",",$user_categories).') GROUP BY cat_usu.name) 
anterior on anterior.term_id=actual.term_id) 

 order by diferencia DESC';
	
	
	
	//echo $query;
	try {
		$results=$wpdb->get_results( $wpdb->prepare( $query,$fecha_inicio_actual,$fecha_fin_actual,$fecha_inicio_anterior,$fecha_fin_anterior,$fecha_inicio_actual,$fecha_fin_actual,$fecha_inicio_anterior,$fecha_fin_anterior));
		
		//echo '///'.$wpdb->last_query.'///';
		
	} catch (Exception $e) {
		echo $e;
	}

	return $results;
}

function genera_html_tabla($resultados,$titulo){
	$html_tabla_revs='';
	if($titulo=='Seguimiento'){
		$url='http://213.229.136.106/iwatchCommodity/wp-admin/edit.php?post_type=alerta_seguimiento';
	}else{
				$url='http://213.229.136.106/iwatchCommodity/wp-admin/edit.php?post_type=alerta_busqueda';
	}
	
			$html_tabla_alertas= $html_tabla_alertas.'<table style="border:solid 1px lightgrey ;padding:3 3 3 3;width:90%;">
				<tbody>';
			$html_tabla_alertas= $html_tabla_alertas.'<tr>
			<td style="border-right:solid 0.5px lightgrey;text-align:center;"><b>Alertas Conceptos de '.$titulo.'<br><a href="'.$url.'">Administrar</a></b></td>
			<td style="border-right:solid 0.5px lightgrey;text-align:center;"><b>Entradas Periodo Actual</b></td>
			<td style="border-right:solid 0.5px lightgrey;text-align:center;"><b>Entradas Periodo Anterior</b></td>
			<td style="border-right:solid 0.5px lightgrey;text-align:center;"><b>Concepto de '.$titulo.'</b></td>';
	//echo sizeof($resultados);
			if (sizeof($resultados)>0){
			//$html_tabla_alertas= $html_tabla_alertas;
			
				$alerta_actual=0;
				$alerta_bucle=0;
				//echo $html_tabla_alertas;
				
			foreach ($resultados as $alerta): 
				$producto='';
				$revasa_umbral=false;
				if ($alerta->name_actual){
					$producto=$alerta->name_actual;
				}
				if ($alerta->name_anterior){
					$producto=$alerta->name_anterior;
				}
				if($alerta->cuenta_anterior > 0){
					$dif_porcentaje=round (($alerta->diferencia/$alerta->cuenta_anterior) * 100,1);
					
				}else{
					$dif_porcentaje=round (($alerta->diferencia/abs($alerta->diferencia)) * 100,1);
				}
				if($dif_porcentaje>0 && $dif_porcentaje>$alerta->umbral_ascenso){
					$revasa_umbral=true;
					$dif_porcentaje='+'.$dif_porcentaje;
					$estilo='style="color:#98DF58;font-weight: bold;">';
				}
				if($dif_porcentaje<0 && $dif_porcentaje<$alerta->umbral_descenso){
					$revasa_umbral=true;
					$estilo='style="color:#EC6464;font-weight: bold;">';
				}
				//echo 'producto:'.$producto.' - Diferencia %:'.$dif_porcentaje;
				//echo '$revasa_umbral-'.$revasa_umbral;
					$alerta_bucle=$alerta_bucle+1;
					if($revasa_umbral){
						$html_tabla_alertas= $html_tabla_alertas.'<tr>
							<td style="border-top:solid 0.5px lightgrey;border-right:solid 0.5px lightgrey  ;padding:3 3 3 3;text-align:center;"><span '.$estilo.$dif_porcentaje.'%</span> Número de entradas '.$producto.'</td>
							<td style="border-top:solid 0.5px lightgrey;border-right:solid 0.5px lightgrey   ;padding:3 3 3 3;text-align:center;">'.$alerta->cuenta_actual.'</td>
							<td style="border-top:solid 0.5px lightgrey;border-right:solid 0.5px lightgrey   ;padding:3 3 3 3;text-align:center;">'.$alerta->cuenta_anterior.'</td>
							<td style="border-top:solid 0.5px lightgrey; padding:3 3 3 3;text-align:center;">'.$producto;
							
						$html_tabla_alertas=$html_tabla_alertas.'</td></tr>';
							//echo $html_tabla_alertas;
					}
				
				endforeach; 
	
	}
	else{
					$html_tabla_alertas= $html_tabla_alertas.'<tr>
							<td style="border-top:solid 0.5px lightgrey;border-right:solid 0.5px lightgrey  ;padding:3 3 3 3;text-align:center;"> Número de entradas '.'-'.'</td>
							<td style="border-top:solid 0.5px lightgrey;border-right:solid 0.5px lightgrey   ;padding:3 3 3 3;text-align:center;">'.'-'.'</td>
							<td style="border-top:solid 0.5px lightgrey;border-right:solid 0.5px lightgrey   ;padding:3 3 3 3;text-align:center;">'.'-'.'</td>
							<td style="border-top:solid 0.5px lightgrey; padding:3 3 3 3;text-align:center;">'.'-';
							
						$html_tabla_alertas=$html_tabla_alertas.'</td></tr>';
	}
	$html_tabla_alertas= $html_tabla_alertas.'</tbody>
		</table>';
	return $html_tabla_alertas;
}