<?php

add_filter('show_admin_bar', '__return_false');


//----------- AÑADIR COLUMNAS EN LISTADO USUARIOS -----------------------



add_filter('manage_users_columns', 'ainia_add_user_column');
function ainia_add_user_column($columns) {
	$columns['leidos'] = __('Readed','ainia');
	$columns['accesos'] = __('Logins','ainia');
	$columns['comments'] = __('Comments','ainia');
	$columns['recommend'] = __('Recommendations','ainia');
	
    return $columns;
}


add_action('manage_users_custom_column',  'ainia_manage_user_column', 10, 3);
function ainia_manage_user_column($value, $column_name, $user_id) {
 
	switch($column_name )
	{
	   case 'leidos': return get_count_of_user_relation( $user_id, "browse" );	  
	   case 'accesos' : return get_count_of_user_relation( $user_id, "login" );	  
	   case 'comments' : return get_count_of_user_relation( $user_id, "comment" );	  
	   case 'recommend' : return get_count_of_user_relation( $user_id, "recommend" );	  
	   default:  return $value;
	}
}

add_filter("manage_users_sortable_columns", "wr_event_sortable_columns");   
function wr_event_sortable_columns( $columns ) {
    $columns['posts'] = 'posts';
	$columns['leidos'] = 'leidos';
	$columns['accesos'] = 'accesos';
	$columns['comments'] = 'comments';
	$columns['recommend'] = 'recommend';	
    return $columns;
}



//---- AJUSTES ESTÉTICOS Y USABILIDAD

//Solo el admin ve los widgets del dashboard
add_action('wp_dashboard_setup', 'remove_dashboard_widgets' );
function remove_dashboard_widgets() {
  if(true||!current_user_can('manage_options')){
    global $wp_meta_boxes;  		
    unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_incoming_links']);
    unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_right_now']);
    unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_plugins']);
	unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_recent_comments']);
	unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_quick_press']);
    unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_recent_drafts']);    
    unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_primary']);
    unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_secondary']);
	remove_action( 'welcome_panel', 'wp_welcome_panel' );	
 }
}

//Solo el admin ve la pestaña "medios" y el "dashboard"
add_action( 'admin_menu', 'remove_menu_links' );
function remove_menu_links() {
  if(!current_user_can('manage_options')){
	remove_menu_page('edit.php?post_type=page'); //menú escritorio
    remove_menu_page('upload.php'); //menú media
	remove_menu_page('index.php'); //menú escritorio	
	}
}

//Solo el admin ve la barra de administracion en el front-end
add_action( 'after_setup_theme', 'a3p_disable_admin_bar' );
function a3p_disable_admin_bar() { 
	if( !current_user_can('edit_posts') )
		add_filter('show_admin_bar', '__return_false');		
}

//Quitar la configuracion de colores del perfil de usuario
//add_action('wp_head','hide_personal_options');
//add_action('admin_head','hide_personal_options');
function hide_personal_options(){	
	echo "\n" . '<script type="text/javascript">jQuery(document).ready(function($) { $(\'form#your-profile > h3:first\').hide(); $(\'form#your-profile > table:first\').hide(); $(\'form#your-profile\').show(); });</script>' . "\n";
}
 

//---------- SEGURIDAD ---------------------------------------------------------------------------------
 
//Acceder a backend solo ciertos perfiles
add_action( 'admin_init', 'ainia_redirect_admin' ); 
function ainia_redirect_admin()
{
	
	global $tipos_usuario;
		
	$alloweds = array('manage_options','edit_users','edit_posts'); //admin,editor,autor
	foreach($alloweds as $allowed)
	 if(current_user_can($allowed))
	  return;
	
	wp_redirect( site_url() );
	exit;
	}

//Todo el mundo debe loguearse
add_action( 'template_redirect', 'sitio_privado', 1 );
function sitio_privado() {	
		if( !is_user_logged_in() ) auth_redirect();	
}

//Ocultar los feeds, no deben ser públicos
add_filter( 'the_content_feed' , 'feed_privado' );
add_filter( 'the_excerpt_rss'  , 'feed_privado' );
add_filter( 'comment_text_rss' , 'feed_privado' );
function feed_privado( $content ) {
	return __("This feed is private","ainia");
}

//----------- CAMPOS DE CONTACTO  ------------------------------------------------------------------------------------------------------

add_filter('user_contactmethods','add_better_contactmethods',10,1);
function add_better_contactmethods( $contactmethods ) 
{
  //$contactmethods['direccion1'] = 'Dirección';
  //$contactmethods['direccion2'] = 'Ciudad';
  //$contactmethods['direccion3'] = 'Provincia';
  //$contactmethods['direccion4'] = 'Código Postal';
  //$contactmethods['direccion5'] = 'Pais';
  //$contactmethods['tele_fijo'] = 'Teléfono fijo';
  //$contactmethods['tele_movil'] = 'Teléfono movil';
  //$contactmethods['tele_fax'] = 'Fax';
  //$contactmethods['twitter'] = 'Twitter';
  //$contactmethods['facebook'] = 'Facebook';
  //$contactmethods['linkedin'] = 'Linkedin';  
  //unset($contactmethods['aim']);
  //unset($contactmethods['jabber']);
  //unset($contactmethods['yim']);
  //unset($contactmethods['google_profile']);  
  return $contactmethods;
}


//----------- EDITOR RICO HTML e IMAGENES EN CAMPO BIOGRAFIA -------------------------------------------------------------

add_action('show_user_profile', 'kpl_user_bio_visual_editor');
add_action('edit_user_profile', 'kpl_user_bio_visual_editor');
function kpl_user_bio_visual_editor( $user ) {
	if ( function_exists('wp_editor') && current_user_can('publish_posts') ):
	?>
	<script type="text/javascript">
	(function($){ 
		$('#description').parents('tr').remove();
	})(jQuery);
	</script>
 
	<table class="form-table">
		<tr>
			<th><label for="description"><?php _e('Biographical Info','ainia'); ?></label></th>
			<td>
				<?php 
				$description = get_user_meta( $user->ID, 'description', true);
				wp_editor( $description, 'description' ); 
				?>
				<p class="description"><?php _e('Share a little biographical information to fill out your profile. This may be shown publicly.', 'ainia'); ?></p>
			</td>
		</tr>
	</table>
	<?php
	endif;
}

add_action('admin_init','kpl_user_bio_visual_editor_unfiltered');
function kpl_user_bio_visual_editor_unfiltered() { remove_all_filters('pre_user_description');}

//-------------- AÑADIR ALGUNOS CAMPOS AL PERFIL DE USUARIO -------------------------------------------


//add_action( 'show_user_profile', 'my_show_extra_profile_fields' );
//add_action( 'edit_user_profile', 'my_show_extra_profile_fields' );

function my_show_extra_profile_fields( $user ) 
{ 
    if(!current_user_can('edit_users'))return false;
	$newsletter  = get_the_author_meta( 'newsletter', $user->ID );
	$last_newsletter_date  = get_the_author_meta( 'last_newsletter_date', $user->ID );
 ?>
	<h3><?php _e('Ainia Profile Information','ainia')?></h3>
	<table class="form-table">
		<tr>
			<th><label for="favorites"><?php _e('Day interval for newsletter','ainia')?></label></th>
			<td>
				<select name="newsletter">
					<option value=""><?php _e("Don't send newsletter",'ainia')?></option>
					<option value="1" <?php selected($newsletter,'1');?>  ><?php _e("Every Day",'ainia')?></option>
					<option value="3" <?php selected($newsletter,'3');?>  ><?php _e("Three Days",'ainia')?></option>
					<option value="7" <?php selected($newsletter,'7');?>  ><?php _e("Once a Week",'ainia')?></option>
					<option value="15" <?php selected($newsletter,'15');?>><?php _e("Every Fifteen Days",'ainia')?></option>
					<option value="30" <?php selected($newsletter,'30');?>><?php _e("Once a Month",'ainia')?></option>
				</select>		
				<p class="description"><?php 
					if($last_newsletter_date)
						 echo __("Last email for this user was sent on",'ainia')." <strong>".$last_newsletter_date."</strong>";
					else echo __("This user has not yet received the newsletter",'ainia');
					?>
				</p>
			</td>
		</tr>		
	</table>
  <?php 
}

add_action( 'personal_options_update', 'my_save_extra_profile_fields' );
add_action( 'edit_user_profile_update', 'my_save_extra_profile_fields' );
function my_save_extra_profile_fields( $user_id ) 
{	
	if(!current_user_can( 'edit_user', $user_id ) )return false;
	update_usermeta( $user_id, 'newsletter', $_POST['newsletter'] );	
}



//------------ CAJETIN DEL AUTOR ---------------

function my_author_box() { ?>
	<div class="author-profile vcard">
		<?php echo get_avatar( get_the_author_meta( 'user_email' ), '96' ); ?>

		<h4 class="author-name fn n">Article written by <?php the_author_posts_link(); ?></h4>

		<p class="author-description author-bio">
			<?php the_author_meta( 'description' ); ?>
		</p>

		<?php if ( get_the_author_meta( 'twitter' ) ) { ?>
			<p class="twitter clear">
				<a href="http://twitter.com/<?php the_author_meta( 'twitter' ); ?>" title="Follow <?php the_author_meta( 'display_name' ); ?> on Twitter">Follow <?php the_author_meta( 'display_name' ); ?> on Twitter</a>
			</p>
		<?php } // End check for twitter ?>
	</div><?php
}

