<?php

	//AÑADIR PAGINA AL MENU
	add_action( 'admin_menu', 'add_a3p_options_to_menu'  );	
	add_action( 'admin_menu', 'add_ainia_create_concept_options_to_menu'  );	
	add_action( 'admin_menu', 'add_ainia_manage_concept_options_to_menu'  );	
	//add_action( 'admin_menu', 'add_ainia_create_source_options_to_menu'  );	
	//add_action( 'admin_menu', 'add_ainia_manage_source_options_to_menu'  );	
	function add_a3p_options_to_menu() 
	{	
		global $a3p_options_admin_page;	
		$a3p_options_admin_page=add_submenu_page('tools.php',__('iWatch Settings','ainia'), 'iWatch', 'edit_users', basename(__FILE__), 'show_a3p_options_page');		
		
	}	
	
	add_action( 'current_screen', 'init_a3p_options'  );	
	function init_a3p_options()
	{	
		global $a3p_options_admin_page;	
		
		$screen = get_current_screen(); 		
		if($a3p_options_admin_page != $screen->id)return;	
		
		save_a3p_options_page();
	}

	function show_a3p_options_page() 
	{		
		if ( !current_user_can( 'edit_users' ) ) 
		 wp_die( __( 'You do not have sufficient permissions to access this page.', 'ainia' ) );
		?>
		<div class="wrap">
						
			<h2><?php _e( 'iWatch Settings', 'ainia' ); ?></h2>
			
						
			<?php
			global $a3p_options_page_results_ko;
			if ( isset( $a3p_options_page_results_ko ) )			 
			  foreach($a3p_options_page_results_ko as $result)			 
				echo '<div class="error"><p><strong>' . $result . '</strong></p></div>';
				
			global $a3p_options_page_results_ok;
			if ( isset( $a3p_options_page_results_ok ) )			 
			  foreach($a3p_options_page_results_ok as $result)			 
				echo '<div class="updated"><p><strong>' . $result . '</strong></p></div>';
				
				$timestamp = wp_next_scheduled("ainia_daily_event");
				$dateformat = 'H:i - j/m/Y';
				echo "<p>".__("Actual server time is","ainia")." <strong>". date($dateformat)."</strong></p>";
				echo "<p>".__("Next scheduled import and newsletter action is: ","ainia")." <strong>". date($dateformat,$timestamp)."</strong></p>";
				echo "<hr/>";
			?>
			
				<form method="post" action="" enctype="multipart/form-data">
					<?php wp_nonce_field( 'security-ainia', '_wpnonce-security-ainia' ); ?>				
					
					
					<h3><?php _e('Crawler','ainia');?></h3>
					<table class="form-table">
					<tr valign="top">
						<th scope="row"><?php _e('RSS Feed URL','ainia');?></th>				
						<td><input type="text" size="80" name="ainia_rss_url" value="<?php echo get_option('ainia_rss_url');?>">
							<p class="description"><?php _e('Must be a XML RSS file with AINIA namespace for some elements.','ainia');?></p>				
						</td>
					</tr>					
					<tr valign="top">
						<th scope="row"><?php _e('Updated Categories URL','ainia');?></th>				
						<td><input type="text" size="80" name="ainia_push_url" value="<?php echo get_option('ainia_push_url');?>">
							<p class="description"><?php _e('To inform when user updates some category, calling an URL like that:','ainia');?>
							<br/><strong><?php $url = get_option('ainia_push_url'); 
								echo $url ? $url : 'www.ainia.es/crawler_inform.jsp';?>?cli=<?php echo $_SERVER['HTTP_HOST'];?>&cat=1234&es=Azucar&en=sugar+sucre</strong>
							</p>				
						</td>
					</tr>				
					<tr valign="top">
						<th scope="row"><?php _e('Max. imported posts','ainia');?></th>				
						<td><input type="text" size="4" name="ainia_max_rss" value="<?php echo get_option('ainia_max_rss');?>"> <?php _e('posts','ainia')?>
						<p class="description"><?php _e('0 for no limits','ainia');?></p>
						</td>
					</tr>	
					<tr valign="top">
						<th scope="row"><?php _e('Import posts with status','ainia');?></th>				
						<td><select name="ainia_imported_status">
								<option value="draft" <?php selected(get_option("ainia_imported_status"),"draft");?>><?php _e("draft","ainia");?></option>
								<option value="publish" <?php selected(get_option("ainia_imported_status"),"publish");?>><?php _e("publish","ainia");?></option>
							</select>	
						
						</td>
					</tr>	
					</table>

					<h3><?php _e('Newsletter / Not Readed Listing','ainia');?></h3>
					<table class="form-table">					
					<tr valign="top">
						<th scope="row"><?php _e('Sender email','ainia');?></th>				
						<td><input type="text" name="ainia_newsletter_email" value="<?php echo get_option('ainia_newsletter_email');?>"></td>
					</tr>					
					<tr valign="top">
						<th scope="row"><?php _e('Maximum age of posts','ainia');?></th>				
						<td><input type="text" size="4" name="ainia_max_days" value="<?php echo get_option('ainia_max_days');?>"> <?php _e('days','ainia')?>
						<p class="description"><?php _e('0 for no limits','ainia');?></p>
						</td>
					</tr>	
					<tr valign="top">
						<th scope="row"><?php _e('Maximum number of posts','ainia');?></th>				
						<td><input type="text" size="4" name="ainia_max_posts" value="<?php echo get_option('ainia_max_posts');?>"> <?php _e('posts','ainia')?>
						<p class="description"><?php _e('0 for no limits','ainia');?></p>
						</td>
					</tr>						
					</table>		

					<h3><?php _e('Otros','ainia');?></h3>		
					<table class="form-table">								
					<tr valign="top">
						<th scope="row"><?php _e('Administrator Colors','ainia');?></th>				
						<td><select name="ainia_colors">
							    <?php $colores = get_option('ainia_colors');?>
								<option value="dark" 		<?php selected($colores,"dark");?>><?php _e("Default","ainia");?></option>
								<option value="blue" 		<?php selected($colores,"blue");?>><?php _e("Blue","ainia");?></option>
								<option value="seaweed" 	<?php selected($colores,"seaweed");?>><?php _e("Teal","ainia");?></option>
								<option value="pixel" 		<?php selected($colores,"pixel");?>><?php _e("Brown","ainia");?></option>
								<option value="ectoplasm" 	<?php selected($colores,"ectoplasm");?>><?php _e("Magenta","ainia");?></option>
								<option value="midnight" 	<?php selected($colores,"midnight");?>><?php _e("Gris","ainia");?></option>
							</select>	
						</td>
					</tr>	
					</table>	
								
					<p class="submit">											
						<input type="hidden" name="_wp_http_referer" value="<?php echo $_SERVER['REQUEST_URI'] ?>" />
						<input type="submit" name="save" class="button-primary" value="<?php _e( 'Save Options', 'ainia' ); ?>" />						
						<?php if(current_user_can("manage_options")):?>
						<input type="submit" name="newsletter" class="button-primary" value="<?php _e( 'Send Newsletter Now', 'ainia' ); ?>" />
						<input type="submit" name="import" class="button-primary" value="<?php _e( 'Import RSS Now', 'ainia' ); ?>" />
						<?php endif; ?>
					</p>
				</form><br class="clear:both"/>
		<?php
	}
	
	
	function save_a3p_options_page() 
	{		
		if ( !empty($_POST) && $_POST['_wpnonce-security-ainia']!="") 
		if(check_admin_referer('security-ainia','_wpnonce-security-ainia') )
		{	
			global $a3p_options_page_results_ok,$a3p_options_page_results_ko;
			$a3p_options_page_results_ok = array();
			$a3p_options_page_results_ko = array();
			
			if(!empty($_REQUEST['save']))
			{				
				$field_id = 'ainia_newsletter_email';
				update_option($field_id,$_REQUEST[$field_id]);		
				$field_id = 'ainia_rss_url';
				update_option($field_id,$_REQUEST[$field_id]);		
				$field_id = 'ainia_push_url';
				update_option($field_id,$_REQUEST[$field_id]);		
				$field_id = 'ainia_max_days';
				update_option($field_id,intval($_REQUEST[$field_id]));		
				$field_id = 'ainia_max_posts';
				update_option($field_id,intval($_REQUEST[$field_id]));		
				$field_id = 'ainia_max_rss';
				update_option($field_id,intval($_REQUEST[$field_id]));		
				$field_id = 'ainia_imported_status';
				update_option($field_id,$_REQUEST[$field_id]);		
				$field_id = 'ainia_colors';
				update_option($field_id,$_REQUEST[$field_id]);
				
				$a3p_options_page_results_ok[]=sprintf(__("Options saved",'ainia'),$cuantos);
			}		
			else if(!empty($_REQUEST['newsletter']))
			{
			   $cuantos = ainia_send_newsletter();								   
			   if(is_wp_error( $cuantos )) $a3p_options_page_results_ko[]= "Error: ".$cuantos->get_error_message();
			   else if($cuantos)$a3p_options_page_results_ok[]=sprintf(__("%d mails sent by newsletter",'ainia'),$cuantos);
			   else $a3p_options_page_results_ko[]=__("No mails sent by newsletter",'ainia');
			}
			else if(!empty($_REQUEST['import']))
			{
				$cuantos = ainia_import_crawler();					
				if(is_wp_error( $cuantos )) $a3p_options_page_results_ko[]= "Error: ".$cuantos->get_error_message();
				else if($cuantos)$a3p_options_page_results_ok[]=sprintf(__("%d posts imported from crawler",'ainia'),$cuantos);
				else $a3p_options_page_results_ko[]=__("Nothing imported from crawler",'ainia');
			}
		}
	}
		/*******************************************************************/
		function add_ainia_manage_concept_options_to_menu() 
	{	
		global $ainia_create_concept_options_admin_page;	
		$ainia_create_concept_options_admin_page=add_submenu_page($parent_slug, $page_title, $menu_title, $capability, $menu_slug);
		//$ainia_create_concept_options_admin_page=add_menu_page(__('iWatch Adminitration','ainia'), 'Admin-iWatch', 'edit_users', basename(__FILE__), 'show_ainia_options_page');		
		
	}
	function add_ainia_create_concept_options_to_menu() 
	{	
		global $ainia_create_concept_options_admin_page;	
		$ainia_create_concept_options_admin_page=add_menu_page(__('iWatch Adminitration','ainia'), 'Fuentes y conceptos', 'edit_users', 'create-concept-options','show_ainia_create_concept_page');		
		//											add_menu_page('My Custom Page', 'My Custom Page', 'manage_options', 'my-top-level-slug');
		add_submenu_page( 'create-concept-options', 'Crear concepto', 'Crear concepto','edit_users', 'ainia-create-concept-page','show_ainia_create_concept_page');
		add_submenu_page( 'create-concept-options', 'Gestionar conceptos', 'Gestionar conceptos', 'edit_users','ainia-manage-concept-page', 'show_ainia_manage_concept_page');
		add_submenu_page( 'create-concept-options', 'Crear fuente', 'Crear fuente', 'edit_users','ainia-create-source-page', 'show_ainia_create_source_page');
		add_submenu_page( 'create-concept-options', 'Gestionar fuentes', 'Gestionar fuente', 'edit_users','ainia-manage-source-page', 'show_ainia_manage_source_page');
		add_submenu_page( 'create-concept-options', 'Grupos de conceptos', 'Grupos de conceptos', 'edit_users','ainia-manage-groups', 'show_ainia_manage_groups');
		add_submenu_page( 'create-concept-options', 'Complex Matchers', 'Complex Matchers', 'edit_users','ainia-manage-complex-matchers', 'show_ainia_manage_complex_matchers');
		
		remove_submenu_page( 'create-concept-options', 'create-concept-options' );
	}
	
	function show_ainia_create_concept_page() 
	{		
		if ( !current_user_can( 'edit_users' ) ) 
		 wp_die( __( 'You do not have sufficient permissions to access this page.', 'ainia' ) );
		?>
		<div class="wrap"  width="90%" height="100%">
						
			<h2><?php _e( 'iWatch Settings', 'ainia' ); ?></h2>
			<iframe src="http://213.229.136.106:8080/crawlerUI/#!ConceptView/user=itp&/&password=aXRw" width="100%" height="700" align="center"> </iframe>
			
			
		</div>
			
		
		<?php
	}
		function show_ainia_manage_concept_page() 
	{		
		if ( !current_user_can( 'edit_users' ) ) 
		 wp_die( __( 'You do not have sufficient permissions to access this page.', 'ainia' ) );
		?>
		<div class="wrap"  width="90%" height="100%">
						
			<h2><?php _e( 'iWatch Settings', 'ainia' ); ?></h2>
			<iframe src="http://213.229.136.106:8080/crawlerUI/#!ConceptOfLoginView/user=itp&/&password=aXRw" width="100%" height="700" align="center"> </iframe>
			
			
		</div>
			
		
		<?php
	}
	
	function show_ainia_manage_source_page() 
	{		
		if ( !current_user_can( 'edit_users' ) ) 
		 wp_die( __( 'You do not have sufficient permissions to access this page.', 'ainia' ) );
		?>
		<div class="wrap"  width="90%" height="100%">
						
			<h2><?php _e( 'iWatch Settings', 'ainia' ); ?></h2>
			<iframe src="http://213.229.136.106:8080/crawlerUI/#!SourceListOfLoginView/user=itp&/&password=aXRw" width="100%" height="700" align="center"> </iframe>
			
			
		</div>
			
		
		<?php
	}
	
	function show_ainia_create_source_page() 
	{		
		if ( !current_user_can( 'edit_users' ) ) 
		 wp_die( __( 'You do not have sufficient permissions to access this page.', 'ainia' ) );
		?>
		<div class="wrap"  width="90%" height="100%">
						
			<h2><?php _e( 'iWatch Settings', 'ainia' ); ?></h2>
			<iframe src="http://213.229.136.106:8080/crawlerUI/#!SourceListView/user=itp&/&password=aXRw" width="100%" height="700" align="center"> </iframe>
			
			
		</div>
			
		
		<?php
	}
	
	function show_ainia_manage_groups()
	{
		if ( !current_user_can( 'edit_users' ) )
			wp_die( __( 'You do not have sufficient permissions to access this page.', 'ainia' ) );
			?>
			<div class="wrap"  width="90%" height="100%">
							
				<h2><?php _e( 'iWatch Settings', 'ainia' ); ?></h2>
				<iframe src="http://213.229.136.106:8080/crawlerUI/#!ConceptGroupView/user=itp&/&password=aXRw" width="100%" height="700" align="center"> </iframe>
				
				
			</div>
				
			
			<?php
		}
		
		function show_ainia_manage_complex_matchers()
		{
			if ( !current_user_can( 'edit_users' ) )
				wp_die( __( 'You do not have sufficient permissions to access this page.', 'ainia' ) );
				?>
					<div class="wrap"  width="90%" height="100%">
									
						<h2><?php _e( 'iWatch Settings', 'ainia' ); ?></h2>
						<iframe src="http://213.229.136.106:8080/crawlerUI/#!ComplexMatcherView/user=itp&/&password=aXRw" width="100%" height="700" align="center"> </iframe>
						
						
					</div>
						
					
					<?php
				}

