<?php 

// http://shibashake.com/wordpress-theme/custom-post-type-permalinks-part-2 

add_action("init","iniciar_taxonomia_concepto_seguimiento");
function iniciar_taxonomia_concepto_seguimiento()
{
		register_taxonomy('concepto_seguimiento', array('post'), array(
			  'public'      =>true,
			  'labels'      =>array(
				  'name'                        =>__('concepto_seguimiento','ainia_iwatch'),					
				  'menu_name'                   =>__('Conceptos Seguimiento','ainia_iwatch'),
				  'singular_name'               =>__('Concepto Seguimiento','ainia_iwatch'),								
				  'search_items'                =>__('Buscar por Concepto Seguimiento','ainia_iwatch'),
				  'popular_items'               =>__('Conceptos Seguimiento populares','ainia_iwatch'),
				  'all_items'                   =>__('Todos los Conceptos Seguimiento','ainia_iwatch'),
				  'edit_item'                   =>__('Editar Concepto Seguimiento','ainia_iwatch'),
				  'update_item'             	=>__('Actualizar Concepto Seguimiento','ainia_iwatch'),
				  'add_new_item'                =>__('Añadir Concepto Seguimiento','ainia_iwatch'),
				  'new_item_name'               =>__('Nuevo Concepto Seguimiento','ainia_iwatch'),
				  'separate_items_with_commas'	=>__('Separar Conceptos Seguimiento con comas','ainia_iwatch'),
				  'add_or_remove_items'     	=>__('Añadir o eliminar Conceptos Seguimiento','ainia_iwatch'),
				  'choose_from_most_used'       =>__('Elegir de los conceptos de seguimiento más usados','ainia_iwatch'),
			  ),
			  'hierarchical' =>true,
			  'rewrite'     =>array(
				  'with_front'              	=>true,
				  'slug'                    	=>'concepto-seguimiento',
			  ),
			  
		));		
}

//------------- EDITAR METABOXES DEL TIPO POST PARA AÑADIR El Concepto seguimiento ---------------------------------------------------------------

add_action( 'admin_menu', 'concepto_seguimiento_remove_meta_box',20);  
function concepto_seguimiento_remove_meta_box()
{  
	//remove_meta_box('categorydiv'       );
	//remove_meta_box('commentsdiv'       );	
	//remove_meta_box('submitdiv'         );
	//remove_meta_box('tagsdiv-post_tag'  );
	
	remove_meta_box('slugdiv'          			, 'post', 'normal' );
	remove_meta_box('tagsdiv-concepto-seguimiento'			, 'post', 'normal');  
	remove_meta_box('stl-timeline-event-data'	, 'post', 'advanced');  
	remove_meta_box('authordiv' 				, 'post', 'normal');
	//remove_meta_box('commentstatusdiv' 			, 'post', 'normal');
	remove_meta_box('formatdiv'   				, 'post', 'normal');
	remove_meta_box('pageparentdiv'     		, 'post', 'normal');
	remove_meta_box('postcustom'        		, 'post', 'normal');
	remove_meta_box('postexcerpt'       		, 'post', 'normal');	
	remove_meta_box('revisionsdiv'      		, 'post', 'normal');
	remove_meta_box('trackbacksdiv'     		, 'post', 'normal');
}  

add_action('do_meta_boxes','my_post_remove_meta_box',1);  
function my_post_remove_meta_box()
{  
	remove_meta_box('postimagediv', 'post', 'side');
	//remove_post_type_support( 'post', 'post-thumbnail' );
}

add_action( 'add_meta_boxes', 'add_post_concepto_seguimiento_metabox_event' );
function add_post_concepto_seguimiento_metabox_event()
{
	add_meta_box( 'post-concepto_seguimiento-metabox-id', 'concepto_seguimiento', 'add_post_concepto_seguimiento_metabox', 'post', 'normal', 'high' );
}

function add_post_concepto_seguimiento_metabox( $post )
{
	$conceptos_seguimiento_posts = get_the_terms( $post->ID, 'concepto_seguimiento');
	$id_concepto_seguimiento = count($conceptos_seguimiento_posts) ? $conceptos_seguimiento_posts[0]->term_id : 0;
	
	$interes = get_post_meta( $post->ID, 'interes', true );
	$url_article = get_post_meta( $post->ID, 'url_article', true );
	$conceptos_seguimiento = get_terms("concepto_seguimiento", array('hide_empty'=>false));
	wp_nonce_field( 'my_post_concepto_seguimiento_metabox_nonce', 'my_post_concepto_seguimiento_metabox_nonce' );
	?>
	<p>
		<label for="concepto_seguimiento"><?php _e('concepto_seguimiento','ainia_iwatch');?></label>
		<select name="concepto_seguimiento" id="concepto_seguimiento">
			<option value=""> - sin concepto seguimiento - </option>
		<?php foreach($conceptos_seguimiento as $concepto_seguimiento){?>
			<option value="<?php echo $concepto_seguimiento->term_id?>" <?php selected( $concepto_seguimiento->term_id, $id_concepto_seguimiento ); ?>><?php echo $concepto_seguimiento->name?></option>
		<?php }?>			
		</select>
	</p>	

	<?php	
}


add_action( 'save_post', 'save_post_concepto_seguimiento_metabox' );
function save_post_concepto_seguimiento_metabox( $post_id )
{
	// Bail if we're doing an auto save
	if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
	
	// if our nonce isn't there, or we can't verify it, bail
	if( !isset( $_POST['my_post_concepto_seguimiento_metabox_nonce'] ) || !wp_verify_nonce( $_POST['my_post_riesgo_metabox_nonce'], 'my_post_riesgo_metabox_nonce' ) ) return;
		
	// if our current user can't edit this post, bail
	if( !current_user_can( 'edit_post' ) ) return;	
	
	
	if( isset( $_POST['riesgo'] ) )
		wp_set_object_terms( $post_id, intval( $_POST['concepto_seguimiento'] ) , 'concepto_seguimiento', false);
		
	if( isset( $_POST['url_article'] ) )
		update_post_meta( $post_id, 'url_article', esc_attr( $_POST['url_article'] ) );
		
	if( isset( $_POST['article_interest'] ) )
		update_post_meta( $post_id, 'interes', esc_attr( $_POST['article_interest'] ) );
	
}


//--------------------- AÑADIR CAMPOS A LA TAXONOMIA -------------------------------------------------------------
add_action('concepto_seguimiento_add_form_fields', 'concepto_seguimiento_metabox_add', 10, 1);
function concepto_seguimiento_metabox_add($tag) { 
?>	
    <div class="form-field" id="conc_seg_ing">
        <label for="concepto_seguimiento_eng"><?php _e('Concepto en Inglés','ainia_iwatch'); ?></label>
        <input name="concepto_seguimiento_eng" id="concepto_seguimiento_eng" type="text" value="" size="40" aria-required="true" />
    </div>    
<?php

$taxonomy = 'category';
$user_id=get_current_user_id();
?>
		<h2>Seleccionar conceptos de búsqueda</h2>
		<div class="user-category user-category-<?php echo 'category'; ?>" style="margin:20px">
		        <div id="taxonomy-<?php echo $taxonomy; ?>" class="categorydiv">
		
			<?php if(current_user_can(EDIT_USER_CATEGORIES_CAP)):?>
			<div class="taxonomy-metabox-field-container">
				<label class='category-filter' for="category-filter"><?php echo __('Search').' '.$taxonomy->labels->name; ?>:</label>
				<input id='<?php echo $taxonomy?>-search' name="category-filter" type='text' />
			</div>
			<?php else:?>
				 <h4><?php _e("You has been assigned these categories:","ainia")?></h4>
			<?php endif;?>
            
            <div id="<?php echo $taxonomy; ?>-all" >
                <?php $name = ( $taxonomy == 'category' ) ? 'post_category' : 'tax_input[' . $taxonomy . ']'; ?>
                
                <ul id="<?php echo $taxonomy; ?>checklist" class="list:<?php echo $taxonomy ?> <?php echo $taxonomy; ?>checklist form-no-clear">
                    <?php if(current_user_can(EDIT_USER_CATEGORIES_CAP)){
                    		$user_cats = wp_get_object_terms($user_id, $taxonomy);	                    		
                    		$selected_cats = wp_get_object_terms($tag->ID, $taxonomy,array('fields'=>'ids'));
                    		wp_terms_custom_checklist(0, array($user_cats, 'selected_cats'=>$selected_cats,'categories'=>$user_cats));
							}
						  else {
							$user_cats = wp_get_object_terms($user_id, $taxonomy);	
							$selected_cats = wp_get_object_terms($tag->ID, $taxonomy, array('fields'=>'ids'));
							wp_terms_custom_checklist(0, array($user_cats, 'selected_cats'=>$selected_cats,'categories'=>$user_cats));
							foreach($selected_cats as $cat)echo "<li>".$cat->name."</li>";														
							}
						
						?>
                </ul>
            </div>
        </div>
		
		
		
		
		</div>

		<?php

}   

function get_concepto_seguimiento_eng($term_id)
{
	return get_option('concepto_seguimiento_eng_'.$term_id);	
}  

add_action('concepto_seguimiento_edit_form_fields', 'concepto_seguimiento_metabox_edit', 10, 1);    
function concepto_seguimiento_metabox_edit($tag) { 
	$conc_eng = get_concepto_seguimiento_eng($tag->term_id);
	$taxonomy='category';
?>
<a href=<?php echo get_site_url()?>/wp-admin/edit-tags.php?taxonomy=concepto_seguimiento>← Volver a Lista Conceptos Seguimiento</a>
	<table class="form-table">
        <tr class="form-field">
        <th scope="row" valign="top">
            <label for="concepto_seguimiento_eng"><?php _e('Concepto en Inglés','ainia_iwatch'); ?></label>
        </th>
        <td>
            <input name="concepto_seguimiento_eng" id="concepto_seguimiento_eng" type="text" value="<?php echo $conc_eng;?>" size="40" aria-required="true" />
			
        </td>
        </tr>				
    </table>
<?php 
$taxonomy = 'category';
$user_id=get_current_user_id();
?>
		<h2>Seleccionar conceptos de búsqueda</h2>
		<div class="user-category user-category-<?php echo 'category'; ?>" style="margin:20px">
		        <div id="taxonomy-<?php echo $taxonomy; ?>" class="categorydiv">
		
			<?php if(current_user_can(EDIT_USER_CATEGORIES_CAP)):?>
			<div class="taxonomy-metabox-field-container">
				<label class='category-filter' for="category-filter"><?php echo __('Search').' '.$taxonomy->labels->name; ?>:</label>
				<input id='<?php echo $taxonomy?>-search' name="category-filter" type='text' />
			</div>
			<?php else:?>
				 <h4><?php _e("You has been assigned these categories:","ainia")?></h4>
			<?php endif;?>
            
            <div id="<?php echo $taxonomy; ?>-all" >
                <?php $name = ( $taxonomy == 'category' ) ? 'post_category' : 'tax_input[' . $taxonomy . ']'; ?>
                
                <ul id="<?php echo $taxonomy; ?>checklist" class="list:<?php echo $taxonomy ?> <?php echo $taxonomy; ?>checklist form-no-clear">
                      <?php if(current_user_can(EDIT_USER_CATEGORIES_CAP)){
                     
                    		$user_cats = wp_get_object_terms($user_id, $taxonomy);	                    		
                    		$selected_cats = wp_get_object_terms($tag->term_id, $taxonomy,array('fields'=>'ids'));
                    		wp_terms_custom_checklist(0, array($user_cats, 'selected_cats'=>$selected_cats,'categories'=>$user_cats));
							}
						  else {
							$user_cats = wp_get_object_terms($user_id, $taxonomy);	
							$selected_cats = wp_get_object_terms($tag->term_id, $taxonomy, array('fields'=>'ids'));
							wp_terms_custom_checklist(0, array($user_cats, 'selected_cats'=>$selected_cats,'categories'=>$user_cats));
						  }						
						?>
                </ul>
            </div>
        </div>
		
		
		
		
		</div>

		<?php 	
}

 

add_action('created_concepto_seguimiento', 'save_concepto_seguimiento_metadata', 10, 1);    
add_action('edited_concepto_seguimiento', 'save_concepto_seguimiento_metadata', 10, 1);
function save_concepto_seguimiento_metadata($term_id)
{
	$taxonomy = 'category';
	if (!$term_id)return;	
	//echo 'term_ID'.$term_id;
	if ( isset( $_POST['concepto_seguimiento_eng'] ) ) 
		update_option( 'concepto_seguimiento_eng_'.$term_id, $_POST['concepto_seguimiento_eng'] );	
		//update_option( 'concepto_seguimiento_usuario_'.$term_id, get_current_user_id());
		wp_set_object_terms(get_current_user_id(), $term_id, 'concepto_seguimiento', true);
		
		/*************/
		$terms = ( $taxonomy == 'category' ) ? $_POST['post_category'] : $_POST['tax_input'][$taxonomy];
		for($t=0;$t<count($terms);$t++)$terms[$t]=intval($terms[$t]);
		//update_option( 'concepto_seguimiento_cat_'.$term_id, implode(',', $terms));
		wp_set_object_terms($term_id, $terms, $taxonomy, false);
		clean_object_term_cache($term_id, $taxonomy);
}

function wp_terms_custom_checklist( $post_id = 0, $args = array() ) {
	$defaults = array(
			'descendants_and_self' => 0,
			'selected_cats' => false,
			'popular_cats' => false,
			'walker' => null,
			'taxonomy' => 'category',
			'checked_ontop' => true,
			'echo' => true,
	);

	/**
	 * Filters the taxonomy terms checklist arguments.
	 *
	 * @since 3.4.0
	 *
	 * @see wp_terms_checklist()
	 *
	 * @param array $args    An array of arguments.
	 * @param int   $post_id The post ID.
	 */
	$params = apply_filters( 'wp_terms_checklist_args', $args, $post_id );

	$r = wp_parse_args( $params, $defaults );

	if ( empty( $r['walker'] ) || ! ( $r['walker'] instanceof Walker ) ) {
		$walker = new Walker_Category_Checklist;
	} else {
		$walker = $r['walker'];
	}

	$taxonomy = $r['taxonomy'];
	$descendants_and_self = (int) $r['descendants_and_self'];

	$args = array( 'taxonomy' => $taxonomy );

	$tax = get_taxonomy( $taxonomy );
	$args['disabled'] = ! current_user_can( $tax->cap->assign_terms );

	$args['list_only'] = ! empty( $r['list_only'] );

	if ( is_array( $r['selected_cats'] ) ) {
		$args['selected_cats'] = $r['selected_cats'];
	} elseif ( $post_id ) {
		$args['selected_cats'] = wp_get_object_terms( $post_id, $taxonomy, array_merge( $args, array( 'fields' => 'ids' ) ) );
	} else {
		$args['selected_cats'] = array();
	}
	if ( is_array( $r['popular_cats'] ) ) {
		$args['popular_cats'] = $r['popular_cats'];
	} else {
		$args['popular_cats'] = get_terms( $taxonomy, array(
				'fields' => 'ids',
				'orderby' => 'count',
				'order' => 'DESC',
				'number' => 10,
				'hierarchical' => false
		) );
	}
	if ( $descendants_and_self ) {
		$categories = (array) get_terms( $taxonomy, array(
				'child_of' => $descendants_and_self,
				'hierarchical' => 0,
				'hide_empty' => 0
		) );
		$self = get_term( $descendants_and_self, $taxonomy );
		array_unshift( $categories, $self );
	} else {
		$categories = (array) get_terms( $taxonomy, array( 'get' => 'all' ) );
	}
	
	if($r['categories']){
		$categories=(array)$r['categories'];
	}

	$output = '';

	if ( $r['checked_ontop'] ) {
		// Post process $categories rather than adding an exclude to the get_terms() query to keep the query the same across all posts (for any query cache)
		$checked_categories = array();
		$keys = array_keys( $categories );

		foreach ( $keys as $k ) {
			if ( in_array( $categories[$k]->term_id, $args['selected_cats'] ) ) {
				$checked_categories[] = $categories[$k];
				unset( $categories[$k] );
			}
		}

		// Put checked cats on top
		$output .= call_user_func_array( array( $walker, 'walk' ), array( $checked_categories, 0, $args ) );
	}
	// Then the rest of them
	$output .= call_user_func_array( array( $walker, 'walk' ), array( $categories, 0, $args ) );

	if ( $r['echo'] ) {
		echo $output;
	}

	return $output;
}

/*
SELECT t.*,tt.* FROM wp_terms AS t INNER JOIN wp_term_taxonomy AS tt ON t.term_id = tt.term_id INNER JOIN wp_term_relationships AS tr ON tr.term_taxonomy_id = tt.term_taxonomy_id WHERE tt.taxonomy IN ('concepto_seguimiento') AND tr.object_id IN (79464) and t.term_id in (SELECT t.term_id FROM wp_terms AS t INNER JOIN wp_term_taxonomy AS tt ON t.term_id = tt.term_id INNER JOIN wp_term_relationships AS tr ON tr.term_taxonomy_id = tt.term_taxonomy_id WHERE tt.taxonomy IN ('concepto_seguimiento') AND tr.object_id IN (1) ) ORDER BY t.name ASC
*/
 function get_user_post_conceptos_seguimiento($user_id=0,$post_id=0){
	
 		global $wpdb;
	//echo '$post_title';
	$query_str='SELECT t.*,tt.* FROM wp_terms AS t INNER JOIN wp_term_taxonomy AS tt ON t.term_id = tt.term_id INNER JOIN 
	wp_term_relationships AS tr ON tr.term_taxonomy_id = tt.term_taxonomy_id WHERE tt.taxonomy IN (\'concepto_seguimiento\')
	 AND tr.object_id IN (%d) and t.term_id in 
	 (SELECT t.term_id FROM wp_terms AS t INNER JOIN wp_term_taxonomy AS tt ON t.term_id = tt.term_id INNER JOIN
	  wp_term_relationships AS tr ON tr.term_taxonomy_id = tt.term_taxonomy_id WHERE tt.taxonomy IN (\'concepto_seguimiento\')
	   AND tr.object_id IN (%d) ) ORDER BY t.name ASC
	;';
	$conceptos_seguimiento = $wpdb->get_results($wpdb->prepare( $query_str,$post_id,$user_id));
	//echo $wpdb->last_query.'----';
	//echo sizeof($pageposts);
	return $conceptos_seguimiento;
 	
	
}

/*** Para mostrar columna con conceptos en ingles **///

add_filter('manage_edit-concepto_seguimiento_columns', 'ainia_register_con_seg_columns');
function ainia_register_con_seg_columns($columns){
  $columns['ingles']  = 'Traducción Inglés';
 
  return $columns;
} 
 function add_concepto_seguimiento_column_content($content,$column_name,$term_id){
 //	echo $column_name;
    $content='contenido';
    switch ($column_name) {
        case 'ingles':
            //do your stuff here with $term or $term_id
            $content = get_concepto_seguimiento_eng($term_id);
         // echo $content;
            break;
        default:
            break;
    }
    echo $content;
}
add_filter('manage_concepto_seguimiento_custom_column', 'add_concepto_seguimiento_column_content',10,3);


  
  
 

