/* DUPLICATOR MYSQL SCRIPT CREATED ON : 2019-05-21 09:36:38 */

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_cimy_uef_data` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `USER_ID` bigint(20) NOT NULL,
  `FIELD_ID` bigint(20) NOT NULL,
  `VALUE` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `USER_ID` (`USER_ID`),
  KEY `FIELD_ID` (`FIELD_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=137 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_cimy_uef_fields` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `F_ORDER` bigint(20) NOT NULL,
  `FIELDSET` bigint(20) NOT NULL DEFAULT '0',
  `NAME` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `LABEL` text COLLATE utf8mb4_unicode_520_ci,
  `DESCRIPTION` text COLLATE utf8mb4_unicode_520_ci,
  `TYPE` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `RULES` text COLLATE utf8mb4_unicode_520_ci,
  `VALUE` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`ID`),
  KEY `F_ORDER` (`F_ORDER`),
  KEY `NAME` (`NAME`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_cimy_uef_wp_fields` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `F_ORDER` bigint(20) NOT NULL,
  `NAME` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `LABEL` text COLLATE utf8mb4_unicode_520_ci,
  `DESCRIPTION` text COLLATE utf8mb4_unicode_520_ci,
  `TYPE` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `RULES` text COLLATE utf8mb4_unicode_520_ci,
  `VALUE` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`ID`),
  KEY `F_ORDER` (`F_ORDER`),
  KEY `NAME` (`NAME`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=11723 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_pmxe_exports` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(20) NOT NULL DEFAULT '0',
  `attch_id` bigint(20) NOT NULL DEFAULT '0',
  `options` longtext,
  `scheduled` varchar(64) NOT NULL DEFAULT '',
  `registered_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `friendly_name` varchar(64) NOT NULL DEFAULT '',
  `exported` bigint(20) NOT NULL DEFAULT '0',
  `canceled` tinyint(1) NOT NULL DEFAULT '0',
  `canceled_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `settings_update_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_activity` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `processing` tinyint(1) NOT NULL DEFAULT '0',
  `executing` tinyint(1) NOT NULL DEFAULT '0',
  `triggered` tinyint(1) NOT NULL DEFAULT '0',
  `iteration` bigint(20) NOT NULL DEFAULT '0',
  `export_post_type` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_pmxe_posts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL,
  `export_id` bigint(20) unsigned NOT NULL,
  `iteration` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_pmxe_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `options` longtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=369728 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=222697 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  `term_thumbnail` text,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=1403 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1403 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_user_relations` (
  `relationship_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL DEFAULT '0',
  `user_ip` bigint(20) NOT NULL DEFAULT '0',
  `object_id` bigint(20) NOT NULL,
  `object_type` varchar(32) NOT NULL,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `count` bigint(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`relationship_id`),
  KEY `user_id` (`user_id`),
  KEY `user_ip` (`user_ip`),
  KEY `object` (`object_id`,`object_type`),
  KEY `relationship` (`user_id`,`user_ip`,`object_id`,`object_type`)
) ENGINE=InnoDB AUTO_INCREMENT=80354 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_user_relationsmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_relations_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) NOT NULL,
  `meta_value` longtext,
  `meta_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`meta_id`),
  KEY `relationship` (`user_relations_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=InnoDB AUTO_INCREMENT=78174 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=139874 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=9980 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_campaign` (
  `campaign_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `description` text,
  PRIMARY KEY (`campaign_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_campaign_list` (
  `list_id` int(10) unsigned NOT NULL,
  `campaign_id` int(10) unsigned NOT NULL,
  `filter` text,
  PRIMARY KEY (`list_id`,`campaign_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_custom_field` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` tinytext NOT NULL,
  `type` tinytext NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `settings` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_email` (
  `email_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `campaign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(250) NOT NULL DEFAULT '',
  `body` longtext,
  `created_at` int(10) unsigned DEFAULT NULL,
  `modified_at` int(10) unsigned DEFAULT NULL,
  `sent_at` int(10) unsigned DEFAULT NULL,
  `from_email` varchar(250) DEFAULT NULL,
  `from_name` varchar(250) DEFAULT NULL,
  `replyto_email` varchar(250) DEFAULT NULL,
  `replyto_name` varchar(250) DEFAULT NULL,
  `attachments` text,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `type` tinyint(4) NOT NULL DEFAULT '1',
  `number_sent` int(10) unsigned NOT NULL DEFAULT '0',
  `number_opened` int(10) unsigned NOT NULL DEFAULT '0',
  `number_clicked` int(10) unsigned NOT NULL DEFAULT '0',
  `number_unsub` int(10) unsigned NOT NULL DEFAULT '0',
  `number_bounce` int(10) unsigned NOT NULL DEFAULT '0',
  `number_forward` int(10) unsigned NOT NULL DEFAULT '0',
  `params` text,
  `wj_data` longtext,
  `wj_styles` longtext,
  PRIMARY KEY (`email_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_email_user_stat` (
  `user_id` int(10) unsigned NOT NULL,
  `email_id` int(10) unsigned NOT NULL,
  `sent_at` int(10) unsigned NOT NULL,
  `opened_at` int(10) unsigned DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`email_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_email_user_url` (
  `email_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `url_id` int(10) unsigned NOT NULL,
  `clicked_at` int(10) unsigned DEFAULT NULL,
  `number_clicked` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`email_id`,`url_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_form` (
  `form_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` tinytext CHARACTER SET utf8 COLLATE utf8_bin,
  `data` longtext CHARACTER SET utf8 COLLATE utf8_bin,
  `styles` longtext CHARACTER SET utf8 COLLATE utf8_bin,
  `subscribed` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`form_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_list` (
  `list_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `namekey` varchar(255) DEFAULT NULL,
  `description` text,
  `unsub_mail_id` int(10) unsigned NOT NULL DEFAULT '0',
  `welcome_mail_id` int(10) unsigned NOT NULL DEFAULT '0',
  `is_enabled` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `is_public` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `created_at` int(10) unsigned DEFAULT NULL,
  `ordering` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`list_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_queue` (
  `user_id` int(10) unsigned NOT NULL,
  `email_id` int(10) unsigned NOT NULL,
  `send_at` int(10) unsigned NOT NULL DEFAULT '0',
  `priority` tinyint(4) NOT NULL DEFAULT '0',
  `number_try` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`email_id`),
  KEY `SENT_AT_INDEX` (`send_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_url` (
  `url_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `url` text,
  PRIMARY KEY (`url_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_url_mail` (
  `email_id` int(11) NOT NULL AUTO_INCREMENT,
  `url_id` int(10) unsigned NOT NULL,
  `unique_clicked` int(10) unsigned NOT NULL DEFAULT '0',
  `total_clicked` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`email_id`,`url_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_user` (
  `user_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `wpuser_id` int(10) unsigned NOT NULL DEFAULT '0',
  `email` varchar(255) NOT NULL,
  `firstname` varchar(255) NOT NULL DEFAULT '',
  `lastname` varchar(255) NOT NULL DEFAULT '',
  `ip` varchar(100) NOT NULL,
  `confirmed_ip` varchar(100) NOT NULL DEFAULT '0',
  `confirmed_at` int(10) unsigned DEFAULT NULL,
  `last_opened` int(10) unsigned DEFAULT NULL,
  `last_clicked` int(10) unsigned DEFAULT NULL,
  `keyuser` varchar(255) NOT NULL DEFAULT '',
  `created_at` int(10) unsigned DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `domain` varchar(255) DEFAULT '',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `EMAIL_UNIQUE` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=9966 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_user_field` (
  `field_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `column_name` varchar(250) NOT NULL DEFAULT '',
  `type` tinyint(3) unsigned DEFAULT '0',
  `values` text,
  `default` varchar(250) NOT NULL DEFAULT '',
  `is_required` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `error_message` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`field_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_user_history` (
  `history_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `email_id` int(10) unsigned DEFAULT '0',
  `type` varchar(250) NOT NULL DEFAULT '',
  `details` text,
  `executed_at` int(10) unsigned DEFAULT NULL,
  `executed_by` int(10) unsigned DEFAULT NULL,
  `source` text,
  PRIMARY KEY (`history_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wysija_user_list` (
  `list_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `sub_date` int(10) unsigned DEFAULT '0',
  `unsub_date` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`list_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


/* INSERT TABLE DATA: wp_cimy_uef_data */
INSERT INTO `wp_cimy_uef_data` VALUES("1", "5", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("2", "5", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("3", "1", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("4", "1", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("5", "3", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("6", "3", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("7", "2", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("8", "2", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("9", "7", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("10", "7", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("11", "4", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("12", "4", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("13", "6", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("14", "6", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("15", "1", "3", "");
INSERT INTO `wp_cimy_uef_data` VALUES("16", "1", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("17", "3", "3", "");
INSERT INTO `wp_cimy_uef_data` VALUES("18", "3", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("19", "11", "3", "");
INSERT INTO `wp_cimy_uef_data` VALUES("20", "11", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("21", "11", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("22", "11", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("27", "5", "3", "");
INSERT INTO `wp_cimy_uef_data` VALUES("28", "5", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("29", "2", "3", "");
INSERT INTO `wp_cimy_uef_data` VALUES("30", "2", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("31", "7", "3", "");
INSERT INTO `wp_cimy_uef_data` VALUES("32", "7", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("33", "10", "3", "");
INSERT INTO `wp_cimy_uef_data` VALUES("34", "10", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("35", "10", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("36", "10", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("37", "4", "3", "");
INSERT INTO `wp_cimy_uef_data` VALUES("38", "4", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("39", "6", "3", "");
INSERT INTO `wp_cimy_uef_data` VALUES("40", "6", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("41", "13", "3", "");
INSERT INTO `wp_cimy_uef_data` VALUES("42", "13", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("43", "13", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("44", "13", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("45", "14", "3", "");
INSERT INTO `wp_cimy_uef_data` VALUES("46", "14", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("47", "14", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("48", "14", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("49", "17", "3", "Daniel");
INSERT INTO `wp_cimy_uef_data` VALUES("50", "17", "4", "del Olmo");
INSERT INTO `wp_cimy_uef_data` VALUES("51", "17", "1", "Especialista empresas y ecodiseño");
INSERT INTO `wp_cimy_uef_data` VALUES("52", "17", "2", "Ecoembes");
INSERT INTO `wp_cimy_uef_data` VALUES("53", "20", "3", "");
INSERT INTO `wp_cimy_uef_data` VALUES("54", "20", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("55", "20", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("56", "20", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("57", "19", "3", "");
INSERT INTO `wp_cimy_uef_data` VALUES("58", "19", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("59", "19", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("60", "19", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("61", "9951", "3", "Jorge");
INSERT INTO `wp_cimy_uef_data` VALUES("62", "9951", "4", "Serrano");
INSERT INTO `wp_cimy_uef_data` VALUES("63", "9951", "1", "Gerente de Empresas y Ecodiseño");
INSERT INTO `wp_cimy_uef_data` VALUES("64", "9951", "2", "Ecoembes");
INSERT INTO `wp_cimy_uef_data` VALUES("65", "9963", "3", "Juanjo");
INSERT INTO `wp_cimy_uef_data` VALUES("66", "9963", "4", "Pol");
INSERT INTO `wp_cimy_uef_data` VALUES("67", "9963", "1", "Compras");
INSERT INTO `wp_cimy_uef_data` VALUES("68", "9963", "2", "Natra Oñati");
INSERT INTO `wp_cimy_uef_data` VALUES("69", "3474", "3", "");
INSERT INTO `wp_cimy_uef_data` VALUES("70", "3474", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("71", "3474", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("72", "3474", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("73", "9959", "3", "");
INSERT INTO `wp_cimy_uef_data` VALUES("74", "9959", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("75", "9959", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("76", "9959", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("77", "9964", "3", "");
INSERT INTO `wp_cimy_uef_data` VALUES("78", "9964", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("79", "9964", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("80", "9964", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("81", "9966", "3", "geraldu598218");
INSERT INTO `wp_cimy_uef_data` VALUES("82", "9966", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("83", "9966", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("84", "9966", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("85", "9967", "3", "mervinrusconi6");
INSERT INTO `wp_cimy_uef_data` VALUES("86", "9967", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("87", "9967", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("88", "9967", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("89", "9968", "3", "katherinatunn70");
INSERT INTO `wp_cimy_uef_data` VALUES("90", "9968", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("91", "9968", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("92", "9968", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("93", "9969", "3", "mukantony53");
INSERT INTO `wp_cimy_uef_data` VALUES("94", "9969", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("95", "9969", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("96", "9969", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("97", "9970", "3", "ankebain689");
INSERT INTO `wp_cimy_uef_data` VALUES("98", "9970", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("99", "9970", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("100", "9970", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("101", "9971", "3", "leannaluker4");
INSERT INTO `wp_cimy_uef_data` VALUES("102", "9971", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("103", "9971", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("104", "9971", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("105", "9972", "3", "jamienielson594");
INSERT INTO `wp_cimy_uef_data` VALUES("106", "9972", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("107", "9972", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("108", "9972", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("109", "9973", "3", "marianohelms2");
INSERT INTO `wp_cimy_uef_data` VALUES("110", "9973", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("111", "9973", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("112", "9973", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("113", "9974", "3", "laurischilling");
INSERT INTO `wp_cimy_uef_data` VALUES("114", "9974", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("115", "9974", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("116", "9974", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("117", "9975", "3", "tammie1711");
INSERT INTO `wp_cimy_uef_data` VALUES("118", "9975", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("119", "9975", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("120", "9975", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("121", "9976", "3", "vickynickson");
INSERT INTO `wp_cimy_uef_data` VALUES("122", "9976", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("123", "9976", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("124", "9976", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("125", "9977", "3", "aracelykitchens");
INSERT INTO `wp_cimy_uef_data` VALUES("126", "9977", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("127", "9977", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("128", "9977", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("129", "9978", "3", "monikagadson69");
INSERT INTO `wp_cimy_uef_data` VALUES("130", "9978", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("131", "9978", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("132", "9978", "2", "");
INSERT INTO `wp_cimy_uef_data` VALUES("133", "9979", "3", "saulgoodell");
INSERT INTO `wp_cimy_uef_data` VALUES("134", "9979", "4", "");
INSERT INTO `wp_cimy_uef_data` VALUES("135", "9979", "1", "");
INSERT INTO `wp_cimy_uef_data` VALUES("136", "9979", "2", "");

/* INSERT TABLE DATA: wp_cimy_uef_fields */
INSERT INTO `wp_cimy_uef_fields` VALUES("1", "3", "0", "CARGO", "Cargo", "", "text", "a:12:{s:5:\"email\";b:0;s:11:\"email_admin\";b:0;s:10:\"max_length\";i:400;s:12:\"can_be_empty\";b:1;s:4:\"edit\";s:7:\"ok_edit\";s:16:\"advanced_options\";s:0:\"\";s:11:\"show_in_reg\";b:1;s:15:\"show_in_profile\";b:1;s:11:\"show_in_aeu\";b:1;s:14:\"show_in_search\";b:0;s:12:\"show_in_blog\";b:0;s:10:\"show_level\";s:2:\"-1\";}", "");
INSERT INTO `wp_cimy_uef_fields` VALUES("2", "4", "0", "EMPRESA", "Empresa", "", "text", "a:12:{s:5:\"email\";b:0;s:11:\"email_admin\";b:0;s:10:\"max_length\";i:400;s:12:\"can_be_empty\";b:1;s:4:\"edit\";s:7:\"ok_edit\";s:16:\"advanced_options\";s:0:\"\";s:11:\"show_in_reg\";b:1;s:15:\"show_in_profile\";b:1;s:11:\"show_in_aeu\";b:1;s:14:\"show_in_search\";b:0;s:12:\"show_in_blog\";b:0;s:10:\"show_level\";s:2:\"-1\";}", "");
INSERT INTO `wp_cimy_uef_fields` VALUES("3", "1", "0", "NOMBRE", "Nombre", "", "text", "a:12:{s:5:\"email\";b:0;s:11:\"email_admin\";b:0;s:10:\"max_length\";i:400;s:12:\"can_be_empty\";b:1;s:4:\"edit\";s:7:\"ok_edit\";s:16:\"advanced_options\";s:0:\"\";s:11:\"show_in_reg\";b:1;s:15:\"show_in_profile\";b:1;s:11:\"show_in_aeu\";b:1;s:14:\"show_in_search\";b:0;s:12:\"show_in_blog\";b:0;s:10:\"show_level\";s:2:\"-1\";}", "");
INSERT INTO `wp_cimy_uef_fields` VALUES("4", "2", "0", "APELLIDO", "Apellido", "", "text", "a:12:{s:5:\"email\";b:0;s:11:\"email_admin\";b:0;s:10:\"max_length\";i:400;s:12:\"can_be_empty\";b:1;s:4:\"edit\";s:7:\"ok_edit\";s:16:\"advanced_options\";s:0:\"\";s:11:\"show_in_reg\";b:1;s:15:\"show_in_profile\";b:1;s:11:\"show_in_aeu\";b:1;s:14:\"show_in_search\";b:0;s:12:\"show_in_blog\";b:0;s:10:\"show_level\";s:2:\"-1\";}", "");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("18", "20190506_ainiaiwatch40", "5cd00eb519d5d8804190506103845", "100", "2019-05-06 10:40:24", "ainia", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2019-05-06 10:38:45\";s:7:\"Version\";s:6:\"1.1.34\";s:9:\"VersionWP\";s:5:\"4.7.4\";s:9:\"VersionDB\";s:6:\"5.7.17\";s:10:\"VersionPHP\";s:5:\"7.1.5\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";i:18;s:4:\"Name\";s:22:\"20190506_ainiaiwatch40\";s:4:\"Hash\";s:29:\"5cd00eb519d5d8804190506103845\";s:8:\"NameHash\";s:52:\"20190506_ainiaiwatch40_5cd00eb519d5d8804190506103845\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:71:\"C:/Program Files (x86)/Apache24/htdocs/iwatch/ecoembes/wp-snapshots/tmp\";s:8:\"StoreURL\";s:50:\"http://www.observatoriodelenvase.com/wp-snapshots/\";s:8:\"ScanFile\";s:62:\"20190506_ainiaiwatch40_5cd00eb519d5d8804190506103845_scan.json\";s:7:\"Runtime\";s:12:\"2192.33 sec.\";s:7:\"ExeSize\";s:8:\"394.74KB\";s:7:\"ZipSize\";s:7:\"52.74MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"ainia\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:64:\"20190506_ainiaiwatch40_5cd00eb519d5d8804190506103845_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:54:\"C:/Program Files (x86)/Apache24/htdocs/iwatch/ecoembes\";s:4:\"Size\";i:55301684;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:66:\"20190506_ainiaiwatch40_5cd00eb519d5d8804190506103845_installer.php\";s:4:\"Size\";i:404213;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:167951100;s:4:\"File\";s:65:\"20190506_ainiaiwatch40_5cd00eb519d5d8804190506103845_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:13:\"wp_user_terms\";s:8:\"FilterOn\";i:1;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:137:\"C:/Program Files (x86)/Apache24/htdocs/iwatch/ecoembes/wp-snapshots/tmp/20190506_ainiaiwatch40_5cd00eb519d5d8804190506103845_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `wp_duplicator_packages` VALUES("19", "20190506_ainiaiwatch40", "5ce3c6976bab59571190521093623", "20", "2019-05-21 09:36:38", "ainia", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2019-05-21 09:36:23\";s:7:\"Version\";s:6:\"1.1.34\";s:9:\"VersionWP\";s:5:\"4.7.4\";s:9:\"VersionDB\";s:6:\"5.7.17\";s:10:\"VersionPHP\";s:5:\"7.1.5\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";i:19;s:4:\"Name\";s:22:\"20190506_ainiaiwatch40\";s:4:\"Hash\";s:29:\"5ce3c6976bab59571190521093623\";s:8:\"NameHash\";s:52:\"20190506_ainiaiwatch40_5ce3c6976bab59571190521093623\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:71:\"C:/Program Files (x86)/Apache24/htdocs/iwatch/ecoembes/wp-snapshots/tmp\";s:8:\"StoreURL\";s:50:\"http://www.observatoriodelenvase.com/wp-snapshots/\";s:8:\"ScanFile\";s:62:\"20190506_ainiaiwatch40_5ce3c6976bab59571190521093623_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"ainia\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:64:\"20190506_ainiaiwatch40_5ce3c6976bab59571190521093623_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:54:\"C:/Program Files (x86)/Apache24/htdocs/iwatch/ecoembes\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2019-05-21 09:36:23\";s:7:\"Version\";s:6:\"1.1.34\";s:9:\"VersionWP\";s:5:\"4.7.4\";s:9:\"VersionDB\";s:6:\"5.7.17\";s:10:\"VersionPHP\";s:5:\"7.1.5\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:22:\"20190506_ainiaiwatch40\";s:4:\"Hash\";s:29:\"5ce3c6976bab59571190521093623\";s:8:\"NameHash\";s:52:\"20190506_ainiaiwatch40_5ce3c6976bab59571190521093623\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:71:\"C:/Program Files (x86)/Apache24/htdocs/iwatch/ecoembes/wp-snapshots/tmp\";s:8:\"StoreURL\";s:50:\"http://www.observatoriodelenvase.com/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:66:\"20190506_ainiaiwatch40_5ce3c6976bab59571190521093623_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:52;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:65:\"20190506_ainiaiwatch40_5ce3c6976bab59571190521093623_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:13:\"wp_user_terms\";s:8:\"FilterOn\";i:1;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:9:\"Installer\";r:74;s:8:\"Database\";r:87;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "http://www.observatoriodelenvase.com", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "http://www.observatoriodelenvase.com", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "ainia iWatch 4.0", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "Sistema de Vigilancia Tecnológica de AINIA", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "ralmarcha@ainia.es", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "18", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "j F, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "j F, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:116:{s:4:\"api$\";s:19:\"index.php?json=info\";s:9:\"api/(.+)$\";s:26:\"index.php?json=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:12:\"proyectos/?$\";s:27:\"index.php?post_type=project\";s:42:\"proyectos/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:37:\"proyectos/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:29:\"proyectos/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=project&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:47:\"fuente/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?fuente=$matches[1]&feed=$matches[2]\";s:42:\"fuente/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?fuente=$matches[1]&feed=$matches[2]\";s:23:\"fuente/([^/]+)/embed/?$\";s:39:\"index.php?fuente=$matches[1]&embed=true\";s:35:\"fuente/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?fuente=$matches[1]&paged=$matches[2]\";s:17:\"fuente/([^/]+)/?$\";s:28:\"index.php?fuente=$matches[1]\";s:37:\"proyectos/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"proyectos/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"proyectos/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"proyectos/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"proyectos/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"proyectos/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"proyectos/([^/]+)/embed/?$\";s:40:\"index.php?project=$matches[1]&embed=true\";s:30:\"proyectos/([^/]+)/trackback/?$\";s:34:\"index.php?project=$matches[1]&tb=1\";s:50:\"proyectos/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:45:\"proyectos/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:38:\"proyectos/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&paged=$matches[2]\";s:45:\"proyectos/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&cpage=$matches[2]\";s:34:\"proyectos/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?project=$matches[1]&page=$matches[2]\";s:26:\"proyectos/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"proyectos/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"proyectos/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"proyectos/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"proyectos/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"proyectos/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:19:{i:0;s:31:\"query-monitor/query-monitor.php\";i:1;s:33:\"admin-menu-editor/menu-editor.php\";i:2;s:20:\"ainia_base/index.php\";i:3;s:22:\"ainia_iwatch/index.php\";i:4;s:35:\"autologin-links/autologin-links.php\";i:5;s:43:\"category-thumbnails/category-thumbnails.php\";i:6;s:49:\"cimy-user-extra-fields/cimy_user_extra_fields.php\";i:7;s:63:\"disable-new-user-notifications/cwwp-disable-new-user-emails.php\";i:8;s:25:\"duplicator/duplicator.php\";i:9;s:25:\"easy-filter/ez-filter.php\";i:10;s:35:\"infinite-scroll/infinite-scroll.php\";i:11;s:31:\"json-api-user/json-api-user.php\";i:12;s:21:\"json-api/json-api.php\";i:13;s:26:\"shortcode-widget/index.php\";i:14;s:35:\"taxonomy-widget/taxonomy-widget.php\";i:15;s:33:\"user-switching/user-switching.php\";i:16;s:41:\"wordpress-importer/wordpress-importer.php\";i:17;s:31:\"wp-all-export/wp-all-export.php\";i:18;s:28:\"wysija-newsletters/index.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "1", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:5:{i:0;s:105:\"C:/Program Files (x86)/Apache24/htdocs/iwatch/ecoembes/wp-content/plugins/json-api-user/json-api-user.php\";i:1;s:110:\"C:/Program Files (x86)/Apache24/htdocs/iwatch/ecoembes/wp-content/themes/ainia_bloggr_child_ecoembes/style.css\";i:2;s:101:\"C:/Program Files (x86)/Apache24/htdocs/iwatch/ecoembes/wp-content/themes/ainia_bloggr_child/style.css\";i:3;s:101:\"C:/Program Files (x86)/Apache24/htdocs/iwatch/ecoembes/wp-content/themes/ainia_bloggr_child/style.css\";i:4;s:0:\"\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "bloggr", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "ainia_bloggr_child_ecoembes", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_whitelist", "1", "yes");
INSERT INTO `wp_options` VALUES("43", "blacklist_keys", "", "no");
INSERT INTO `wp_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("48", "db_version", "38590", "yes");
INSERT INTO `wp_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("53", "show_on_front", "posts", "yes");
INSERT INTO `wp_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_text", "a:4:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:23:\"[estadistica_creciente]\";s:6:\"filter\";b:0;}i:3;a:3:{s:5:\"title\";s:13:\"Mis conceptos\";s:4:\"text\";s:35:\"[nube_categorias_usuario_shortcode]\";s:6:\"filter\";b:0;}i:4;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:520:\"<div style=\"width:100%;\">\r\n<div style=\"margin-left: auto;\r\n  margin-right: auto;width:350px;\">\r\n<h1 class=\"entry_title\" style=\"color:#6b9936\">Apúntate al próximo workshop del Observatorio del Envase del Futuro</h1><br>\r\n</div>\r\n</div>\r\n<div style=\"width:100%;\">\r\n<div style=\"margin-left: auto;\r\n  margin-right: auto;width:100px;\">\r\n<a href=\"https://www.thecircularlab.com/participa/convocatorias/ \"  target=\"_blank\"\r\n style=\"color:white;background-color:#6b9936; padding:8px; \" >Suscripciones</a>\r\n</div>\r\n</div>\r\n<br>\";s:6:\"filter\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("81", "uninstall_plugins", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("82", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("83", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "page_on_front", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("91", "initial_db_version", "38590", "yes");
INSERT INTO `wp_options` VALUES("92", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:68:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"wysija_newsletters\";b:1;s:18:\"wysija_subscribers\";b:1;s:13:\"wysija_config\";b:1;s:16:\"wysija_theme_tab\";b:1;s:16:\"wysija_style_tab\";b:1;s:22:\"wysija_stats_dashboard\";b:1;s:22:\"view_cimy_extra_fields\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("93", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("94", "WPLANG", "es_ES", "yes");
INSERT INTO `wp_options` VALUES("95", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("96", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("97", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("98", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("99", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("100", "sidebars_widgets", "a:9:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:11:\"tag_cloud-2\";i:1;s:12:\"categories-2\";}s:9:\"sidebar-1\";a:5:{i:0;s:8:\"search-2\";i:1;s:6:\"text-4\";i:2;s:6:\"text-2\";i:3;s:6:\"text-3\";i:4;s:18:\"shortcode-widget-2\";}s:17:\"sidebar-home-left\";a:0:{}s:18:\"sidebar-home-right\";a:0:{}s:12:\"sidebar-home\";a:0:{}s:8:\"footer-1\";a:0:{}s:8:\"footer-2\";a:0:{}s:8:\"footer-3\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_tag_cloud", "a:2:{i:2;a:2:{s:5:\"title\";s:17:\"NUBE DE CONCEPTOS\";s:8:\"taxonomy\";s:8:\"category\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("105", "cron", "a:129:{i:1555343646;a:1:{s:29:\"infinite_scroll_refresh_cache\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1555359076;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1555402307;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1555402457;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1555415847;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1555419525;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1555421945;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1555425350;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1555487673;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1555488147;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1555493012;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556004457;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556006287;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556008752;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556009365;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556010304;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556011299;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556013325;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556017999;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556028631;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556090138;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556098605;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556099937;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556176169;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556177218;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556178422;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556179390;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556191617;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556197737;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556198717;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556200771;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556262519;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556263342;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556264891;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556275110;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556276439;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556277964;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556278629;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556524747;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556530046;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556547553;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556607964;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556615573;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556620004;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1556624490;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557125151;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557126220;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557129178;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557130240;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557131014;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557138397;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557147813;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557149601;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557150524;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557150551;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557151488;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557151517;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557303071;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557304102;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557307508;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557312906;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557312937;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557315258;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557315276;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557325875;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557328796;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557384541;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557387623;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557389083;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557397526;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557412932;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557472421;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557479348;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557480436;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557740999;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557741040;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557741054;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557746064;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557753736;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557754599;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557760236;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557818703;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557818730;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557824743;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557824894;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557827512;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557829080;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557832925;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557834490;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557841461;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557909097;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557912430;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557916072;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557916102;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557919363;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557927357;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557928244;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557932273;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557989232;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1557991219;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558000000;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558006489;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558076694;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558076728;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558077571;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558077877;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558079113;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558080525;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558084207;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558085049;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558087030;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558090245;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558091408;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558093744;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558340017;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558342224;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558346371;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558346425;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558346959;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558348845;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558348890;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558350405;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558352105;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558352168;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558353192;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558357911;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558359134;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1558359868;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("106", "theme_mods_twentyseventeen", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1488875272;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("120", "can_compress_scripts", "1", "no");
INSERT INTO `wp_options` VALUES("136", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:12:\"tic@ainia.es\";s:7:\"version\";s:5:\"4.7.4\";s:9:\"timestamp\";i:1492758065;}", "no");
INSERT INTO `wp_options` VALUES("145", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("146", "ws_menu_editor", "a:19:{s:22:\"hide_advanced_settings\";b:1;s:16:\"show_extra_icons\";b:0;s:11:\"custom_menu\";a:4:{s:4:\"tree\";a:19:{s:9:\"index.php\";a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:10:\">index.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:2:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:19:\"index.php>index.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:6:\"Inicio\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"index.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:9:\"index.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:19:\"index.php>index.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:9:\"index.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:25:\"index.php>update-core.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:95:\"Actualizaciones <span class=\'update-plugins count-0\'><span class=\'update-count\'>0</span></span>\";s:12:\"access_level\";s:11:\"update_core\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:15:\"update-core.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:9:\"index.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:25:\"index.php>update-core.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:15:\"update-core.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:10:\"Escritorio\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"index.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";s:43:\"menu-top menu-top-first menu-icon-dashboard\";s:8:\"hookname\";s:14:\"menu-dashboard\";s:8:\"icon_url\";s:19:\"dashicons-dashboard\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:10:\">index.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:9:\"index.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:11:\"separator_3\";a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:1;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:12:\">separator_3\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"separator_3\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";s:17:\"wp-menu-separator\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:1;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:12:\">separator_3\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:0:\"\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:8:\"edit.php\";a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:9:\">edit.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:5:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:17:\"edit.php>edit.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:18:\"Todas las entradas\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:8:\"edit.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:8:\"edit.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:17:\"edit.php>edit.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:8:\"edit.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:21:\"edit.php>post-new.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:13:\"Añadir nueva\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:12:\"post-new.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:8:\"edit.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:21:\"edit.php>post-new.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:12:\"post-new.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:40:\"edit.php>edit-tags.php?taxonomy=category\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:11:\"Categorías\";s:12:\"access_level\";s:17:\"manage_categories\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:31:\"edit-tags.php?taxonomy=category\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:2;s:6:\"parent\";s:8:\"edit.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:40:\"edit.php>edit-tags.php?taxonomy=category\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:31:\"edit-tags.php?taxonomy=category\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:40:\"edit.php>edit-tags.php?taxonomy=post_tag\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:9:\"Etiquetas\";s:12:\"access_level\";s:16:\"manage_post_tags\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:31:\"edit-tags.php?taxonomy=post_tag\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:3;s:6:\"parent\";s:8:\"edit.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:40:\"edit.php>edit-tags.php?taxonomy=post_tag\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:31:\"edit-tags.php?taxonomy=post_tag\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:4;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:38:\"edit.php>edit-tags.php?taxonomy=fuente\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:7:\"Sources\";s:12:\"access_level\";s:17:\"manage_categories\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:29:\"edit-tags.php?taxonomy=fuente\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:4;s:6:\"parent\";s:8:\"edit.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:38:\"edit.php>edit-tags.php?taxonomy=fuente\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:29:\"edit-tags.php?taxonomy=fuente\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:8:\"Entradas\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:8:\"edit.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";s:37:\"menu-top menu-icon-post open-if-no-js\";s:8:\"hookname\";s:10:\"menu-posts\";s:8:\"icon_url\";s:20:\"dashicons-admin-post\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:9:\">edit.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:8:\"edit.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:10:\"upload.php\";a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:11:\">upload.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:2:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:21:\"upload.php>upload.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:10:\"Biblioteca\";s:12:\"access_level\";s:12:\"upload_files\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"upload.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:10:\"upload.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:21:\"upload.php>upload.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:10:\"upload.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:24:\"upload.php>media-new.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:13:\"Añadir nuevo\";s:12:\"access_level\";s:12:\"upload_files\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:13:\"media-new.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:10:\"upload.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:24:\"upload.php>media-new.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:13:\"media-new.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:6:\"Medios\";s:12:\"access_level\";s:12:\"upload_files\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"upload.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";s:24:\"menu-top menu-icon-media\";s:8:\"hookname\";s:10:\"menu-media\";s:8:\"icon_url\";s:21:\"dashicons-admin-media\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:11:\">upload.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:10:\"upload.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:23:\"edit.php?post_type=page\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:24:\">edit.php?post_type=page\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:2:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:47:\"edit.php?post_type=page>edit.php?post_type=page\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:18:\"Todas las páginas\";s:12:\"access_level\";s:10:\"edit_pages\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:23:\"edit.php?post_type=page\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:23:\"edit.php?post_type=page\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:47:\"edit.php?post_type=page>edit.php?post_type=page\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:23:\"edit.php?post_type=page\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:51:\"edit.php?post_type=page>post-new.php?post_type=page\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:13:\"Añadir nueva\";s:12:\"access_level\";s:10:\"edit_pages\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:27:\"post-new.php?post_type=page\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:23:\"edit.php?post_type=page\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:51:\"edit.php?post_type=page>post-new.php?post_type=page\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:27:\"post-new.php?post_type=page\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:8:\"Páginas\";s:12:\"access_level\";s:10:\"edit_pages\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:23:\"edit.php?post_type=page\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";s:23:\"menu-top menu-icon-page\";s:8:\"hookname\";s:10:\"menu-pages\";s:8:\"icon_url\";s:20:\"dashicons-admin-page\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:24:\">edit.php?post_type=page\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:23:\"edit.php?post_type=page\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:10:\"edit_pages\";}s:17:\"edit-comments.php\";a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:5;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:18:\">edit-comments.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:1:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:35:\"edit-comments.php>edit-comments.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:21:\"Todos los comentarios\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:17:\"edit-comments.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:17:\"edit-comments.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:35:\"edit-comments.php>edit-comments.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:17:\"edit-comments.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:90:\"Comentarios <span class=\"awaiting-mod count-0\"><span class=\"pending-count\">0</span></span>\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:17:\"edit-comments.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:5;s:6:\"parent\";N;s:9:\"css_class\";s:27:\"menu-top menu-icon-comments\";s:8:\"hookname\";s:13:\"menu-comments\";s:8:\"icon_url\";s:24:\"dashicons-admin-comments\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:18:\">edit-comments.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:17:\"edit-comments.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:26:\"edit.php?post_type=project\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";s:9:\"Proyectos\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:6;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:27:\">edit.php?post_type=project\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:3:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";s:19:\"Todos los proyectos\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:53:\"edit.php?post_type=project>edit.php?post_type=project\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:19:\"Todos los Proyectos\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:26:\"edit.php?post_type=project\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:26:\"edit.php?post_type=project\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:53:\"edit.php?post_type=project>edit.php?post_type=project\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:26:\"edit.php?post_type=project\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";N;}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:57:\"edit.php?post_type=project>post-new.php?post_type=project\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:22:\"Añadir Nuevo Proyecto\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:30:\"post-new.php?post_type=project\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:26:\"edit.php?post_type=project\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:57:\"edit.php?post_type=project>post-new.php?post_type=project\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:30:\"post-new.php?post_type=project\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:80:\"edit.php?post_type=project>edit-tags.php?taxonomy=post_tag&amp;post_type=project\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:9:\"Etiquetas\";s:12:\"access_level\";s:16:\"manage_post_tags\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:53:\"edit-tags.php?taxonomy=post_tag&amp;post_type=project\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:2;s:6:\"parent\";s:26:\"edit.php?post_type=project\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:80:\"edit.php?post_type=project>edit-tags.php?taxonomy=post_tag&amp;post_type=project\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:49:\"edit-tags.php?taxonomy=post_tag&post_type=project\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:9:\"Proyectos\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:26:\"edit.php?post_type=project\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:6;s:6:\"parent\";N;s:9:\"css_class\";s:26:\"menu-top menu-icon-project\";s:8:\"hookname\";s:18:\"menu-posts-project\";s:8:\"icon_url\";s:20:\"dashicons-admin-post\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:27:\">edit.php?post_type=project\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:26:\"edit.php?post_type=project\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";N;}s:16:\"wysija_campaigns\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";s:22:\"Generador de Boletines\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:7;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";s:19:\"dashicons-clipboard\";s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:17:\">wysija_campaigns\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:4:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:33:\"wysija_campaigns>wysija_campaigns\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:9:\"Boletines\";s:10:\"menu_title\";s:9:\"Boletines\";s:12:\"access_level\";s:18:\"wysija_newsletters\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:16:\"wysija_campaigns\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:16:\"wysija_campaigns\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:33:\"wysija_campaigns>wysija_campaigns\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:31:\"admin.php?page=wysija_campaigns\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:35:\"wysija_campaigns>wysija_subscribers\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:12:\"Suscriptores\";s:10:\"menu_title\";s:12:\"Suscriptores\";s:12:\"access_level\";s:18:\"wysija_subscribers\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:18:\"wysija_subscribers\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:16:\"wysija_campaigns\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:35:\"wysija_campaigns>wysija_subscribers\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:33:\"admin.php?page=wysija_subscribers\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:30:\"wysija_campaigns>wysija_config\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:7:\"Ajustes\";s:10:\"menu_title\";s:7:\"Ajustes\";s:12:\"access_level\";s:13:\"wysija_config\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:13:\"wysija_config\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:2;s:6:\"parent\";s:16:\"wysija_campaigns\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:30:\"wysija_campaigns>wysija_config\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:28:\"admin.php?page=wysija_config\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:31:\"wysija_campaigns>wysija_premium\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:16:\"Versión Premium\";s:10:\"menu_title\";s:16:\"Versión Premium\";s:12:\"access_level\";s:13:\"wysija_config\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:14:\"wysija_premium\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:3;s:6:\"parent\";s:16:\"wysija_campaigns\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:31:\"wysija_campaigns>wysija_premium\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:29:\"admin.php?page=wysija_premium\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:8:\"MailPoet\";s:10:\"menu_title\";s:8:\"MailPoet\";s:12:\"access_level\";s:18:\"wysija_newsletters\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:16:\"wysija_campaigns\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:7;s:6:\"parent\";N;s:9:\"css_class\";s:39:\"menu-top toplevel_page_wysija_campaigns\";s:8:\"hookname\";s:30:\"toplevel_page_wysija_campaigns\";s:8:\"icon_url\";s:92:\"http://www.observatoriodelenvase.com/wp-content/plugins/wysija-newsletters/img/menu-icon.png\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:17:\">wysija_campaigns\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:31:\"admin.php?page=wysija_campaigns\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";N;}s:11:\"separator_4\";a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:8;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:1;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:12:\">separator_4\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"separator_4\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:8;s:6:\"parent\";N;s:9:\"css_class\";s:17:\"wp-menu-separator\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:1;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:12:\">separator_4\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:0:\"\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:10:\"themes.php\";a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:9;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:11:\">themes.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:9:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:21:\"themes.php>themes.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:5:\"Temas\";s:12:\"access_level\";s:13:\"switch_themes\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"themes.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:10:\"themes.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:21:\"themes.php>themes.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:10:\"themes.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:24:\"themes.php>customize.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:12:\"Personalizar\";s:12:\"access_level\";s:9:\"customize\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:95:\"customize.php?return=%2Fiwatch%2Fecoembes%2Fwp-admin%2Foptions-general.php%3Fpage%3Dmenu_editor\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:10:\"themes.php\";s:9:\"css_class\";s:20:\"hide-if-no-customize\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:24:\"themes.php>customize.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:95:\"customize.php?return=%2Fiwatch%2Fecoembes%2Fwp-admin%2Foptions-general.php%3Fpage%3Dmenu_editor\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:22:\"themes.php>widgets.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:7:\"Widgets\";s:12:\"access_level\";s:18:\"edit_theme_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"widgets.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:2;s:6:\"parent\";s:10:\"themes.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:22:\"themes.php>widgets.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:11:\"widgets.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:24:\"themes.php>nav-menus.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:6:\"Menús\";s:12:\"access_level\";s:18:\"edit_theme_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:13:\"nav-menus.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:3;s:6:\"parent\";s:10:\"themes.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:24:\"themes.php>nav-menus.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:13:\"nav-menus.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:4;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:69:\"themes.php>customize.php?#038;autofocus%5Bcontrol%5D=background_image\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:5:\"Fondo\";s:12:\"access_level\";s:13:\"switch_themes\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:140:\"customize.php?return=%2Fiwatch%2Fecoembes%2Fwp-admin%2Foptions-general.php%3Fpage%3Dmenu_editor&#038;autofocus%5Bcontrol%5D=background_image\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:4;s:6:\"parent\";s:10:\"themes.php\";s:9:\"css_class\";s:20:\"hide-if-no-customize\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:69:\"themes.php>customize.php?#038;autofocus%5Bcontrol%5D=background_image\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:135:\"customize.php?return=%2Fiwatch%2Fecoembes%2Fwp-admin%2Foptions-general.php%3Fpage%3Dmenu_editor&autofocus%5Bcontrol%5D=background_image\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:5;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:5;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:23:\"themes.php>bloggr-setup\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:18:\"About ModernThemes\";s:10:\"menu_title\";s:18:\"About ModernThemes\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:12:\"bloggr-setup\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:5;s:6:\"parent\";s:10:\"themes.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:23:\"themes.php>bloggr-setup\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:28:\"themes.php?page=bloggr-setup\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:6;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:6;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:32:\"themes.php>tgmpa-install-plugins\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:24:\"Install Required Plugins\";s:10:\"menu_title\";s:15:\"Install Plugins\";s:12:\"access_level\";s:18:\"edit_theme_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:21:\"tgmpa-install-plugins\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:6;s:6:\"parent\";s:10:\"themes.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:32:\"themes.php>tgmpa-install-plugins\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:37:\"themes.php?page=tgmpa-install-plugins\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:7;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:7;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:28:\"themes.php>custom-background\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:5:\"Fondo\";s:10:\"menu_title\";s:5:\"Fondo\";s:12:\"access_level\";s:18:\"edit_theme_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:17:\"custom-background\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:7;s:6:\"parent\";s:10:\"themes.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:28:\"themes.php>custom-background\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:33:\"themes.php?page=custom-background\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:8;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:8;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:27:\"themes.php>theme-editor.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:6:\"Editor\";s:10:\"menu_title\";s:6:\"Editor\";s:12:\"access_level\";s:11:\"edit_themes\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:16:\"theme-editor.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:8;s:6:\"parent\";s:10:\"themes.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:27:\"themes.php>theme-editor.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:16:\"theme-editor.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:10:\"Apariencia\";s:12:\"access_level\";s:13:\"switch_themes\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"themes.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:9;s:6:\"parent\";N;s:9:\"css_class\";s:29:\"menu-top menu-icon-appearance\";s:8:\"hookname\";s:15:\"menu-appearance\";s:8:\"icon_url\";s:26:\"dashicons-admin-appearance\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:11:\">themes.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:10:\"themes.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:11:\"plugins.php\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:10;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:12:\">plugins.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:3:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:23:\"plugins.php>plugins.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:18:\"Plugins instalados\";s:12:\"access_level\";s:16:\"activate_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"plugins.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:11:\"plugins.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:23:\"plugins.php>plugins.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:11:\"plugins.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:30:\"plugins.php>plugin-install.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:13:\"Añadir nuevo\";s:12:\"access_level\";s:15:\"install_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:18:\"plugin-install.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:11:\"plugins.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:30:\"plugins.php>plugin-install.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:18:\"plugin-install.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:29:\"plugins.php>plugin-editor.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:6:\"Editor\";s:12:\"access_level\";s:12:\"edit_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:17:\"plugin-editor.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:2;s:6:\"parent\";s:11:\"plugins.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:29:\"plugins.php>plugin-editor.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:17:\"plugin-editor.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:87:\"Plugins <span class=\'update-plugins count-0\'><span class=\'plugin-count\'>0</span></span>\";s:12:\"access_level\";s:16:\"activate_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"plugins.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:10;s:6:\"parent\";N;s:9:\"css_class\";s:26:\"menu-top menu-icon-plugins\";s:8:\"hookname\";s:12:\"menu-plugins\";s:8:\"icon_url\";s:23:\"dashicons-admin-plugins\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:12:\">plugins.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:11:\"plugins.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:16:\"activate_plugins\";}s:9:\"users.php\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:11;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:10:\">users.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:6:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:19:\"users.php>users.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:18:\"Todos los usuarios\";s:12:\"access_level\";s:10:\"list_users\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"users.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:9:\"users.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:19:\"users.php>users.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:9:\"users.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:22:\"users.php>user-new.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:13:\"Añadir nuevo\";s:12:\"access_level\";s:12:\"create_users\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:12:\"user-new.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:9:\"users.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:22:\"users.php>user-new.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:12:\"user-new.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:21:\"users.php>profile.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:9:\"Tu perfil\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"profile.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:2;s:6:\"parent\";s:9:\"users.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:21:\"users.php>profile.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:11:\"profile.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:41:\"users.php>edit-tags.php?taxonomy=category\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:11:\"Categorías\";s:10:\"menu_title\";s:11:\"Categorías\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:31:\"edit-tags.php?taxonomy=category\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:3;s:6:\"parent\";s:9:\"users.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:41:\"users.php>edit-tags.php?taxonomy=category\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:31:\"edit-tags.php?taxonomy=category\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:4;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:38:\"users.php>edit-tags.php?taxonomy=scope\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:28:\"edit-tags.php?taxonomy=scope\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:4;s:6:\"parent\";s:9:\"users.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:38:\"users.php>edit-tags.php?taxonomy=scope\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:28:\"edit-tags.php?taxonomy=scope\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:5;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";s:19:\"Info complementaria\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:5;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:24:\"users.php>users_extended\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:14:\"Users Extended\";s:10:\"menu_title\";s:14:\"Users Extended\";s:12:\"access_level\";s:10:\"list_users\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:14:\"users_extended\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:5;s:6:\"parent\";s:9:\"users.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:24:\"users.php>users_extended\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:29:\"users.php?page=users_extended\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";N;}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:8:\"Usuarios\";s:12:\"access_level\";s:10:\"list_users\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"users.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:11;s:6:\"parent\";N;s:9:\"css_class\";s:24:\"menu-top menu-icon-users\";s:8:\"hookname\";s:10:\"menu-users\";s:8:\"icon_url\";s:21:\"dashicons-admin-users\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:10:\">users.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:9:\"users.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:10:\"list_users\";}s:9:\"tools.php\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:12;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:10:\">tools.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:3:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:19:\"tools.php>tools.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:24:\"Herramientas disponibles\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"tools.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:9:\"tools.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:19:\"tools.php>tools.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:9:\"tools.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:20:\"tools.php>import.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:8:\"Importar\";s:12:\"access_level\";s:6:\"import\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"import.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:9:\"tools.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:20:\"tools.php>import.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:10:\"import.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:20:\"tools.php>export.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:8:\"Exportar\";s:12:\"access_level\";s:6:\"export\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"export.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:2;s:6:\"parent\";s:9:\"tools.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:20:\"tools.php>export.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:10:\"export.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:12:\"Herramientas\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"tools.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:12;s:6:\"parent\";N;s:9:\"css_class\";s:24:\"menu-top menu-icon-tools\";s:8:\"hookname\";s:10:\"menu-tools\";s:8:\"icon_url\";s:21:\"dashicons-admin-tools\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:10:\">tools.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:9:\"tools.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:10:\"edit_posts\";}s:19:\"options-general.php\";a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:13;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:20:\">options-general.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:11:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:39:\"options-general.php>options-general.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:9:\"Generales\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:19:\"options-general.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:39:\"options-general.php>options-general.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:19:\"options-general.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:39:\"options-general.php>options-writing.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:9:\"Escritura\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:19:\"options-writing.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:39:\"options-general.php>options-writing.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:19:\"options-writing.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:39:\"options-general.php>options-reading.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:7:\"Lectura\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:19:\"options-reading.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:2;s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:39:\"options-general.php>options-reading.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:19:\"options-reading.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:42:\"options-general.php>options-discussion.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:11:\"Comentarios\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:22:\"options-discussion.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:3;s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:42:\"options-general.php>options-discussion.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:22:\"options-discussion.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:4;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:37:\"options-general.php>options-media.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:6:\"Medios\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:17:\"options-media.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:4;s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:37:\"options-general.php>options-media.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:17:\"options-media.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:5;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:5;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:41:\"options-general.php>options-permalink.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:19:\"Enlaces permanentes\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:21:\"options-permalink.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:5;s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:41:\"options-general.php>options-permalink.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:21:\"options-permalink.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:6;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:6;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:37:\"options-general.php>user_extra_fields\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:22:\"Cimy User Extra Fields\";s:10:\"menu_title\";s:22:\"Cimy User Extra Fields\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:17:\"user_extra_fields\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:6;s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:37:\"options-general.php>user_extra_fields\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:42:\"options-general.php?page=user_extra_fields\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:7;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:7;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:43:\"options-general.php>infinite_scroll_options\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:23:\"Infinite Scroll Options\";s:10:\"menu_title\";s:15:\"Infinite Scroll\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:23:\"infinite_scroll_options\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:7;s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:43:\"options-general.php>infinite_scroll_options\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:48:\"options-general.php?page=infinite_scroll_options\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:8;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:8;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:28:\"options-general.php>json-api\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:17:\"JSON API Settings\";s:10:\"menu_title\";s:8:\"JSON API\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:8:\"json-api\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:8;s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:28:\"options-general.php>json-api\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:33:\"options-general.php?page=json-api\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:9;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:9;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:29:\"options-general.php>ez-filter\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:8:\"Settings\";s:10:\"menu_title\";s:11:\"Easy Filter\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"ez-filter\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:9;s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:29:\"options-general.php>ez-filter\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:34:\"options-general.php?page=ez-filter\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:10;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:10;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:31:\"options-general.php>menu_editor\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:11:\"Menu Editor\";s:10:\"menu_title\";s:11:\"Menu Editor\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"menu_editor\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:10;s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:31:\"options-general.php>menu_editor\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:36:\"options-general.php?page=menu_editor\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:7:\"Ajustes\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:19:\"options-general.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:13;s:6:\"parent\";N;s:9:\"css_class\";s:27:\"menu-top menu-icon-settings\";s:8:\"hookname\";s:13:\"menu-settings\";s:8:\"icon_url\";s:24:\"dashicons-admin-settings\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:20:\">options-general.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:19:\"options-general.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:34:\"edit.php?post_type=acf-field-group\";a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:14;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:35:\">edit.php?post_type=acf-field-group\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:5:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:69:\"edit.php?post_type=acf-field-group>edit.php?post_type=acf-field-group\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:13:\"Custom Fields\";s:10:\"menu_title\";s:13:\"Custom Fields\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:34:\"edit.php?post_type=acf-field-group\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:34:\"edit.php?post_type=acf-field-group\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:69:\"edit.php?post_type=acf-field-group>edit.php?post_type=acf-field-group\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:34:\"edit.php?post_type=acf-field-group\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:54:\"edit.php?post_type=acf-field-group>acf-settings-export\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:15:\"Import / Export\";s:10:\"menu_title\";s:13:\"Import/Export\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:19:\"acf-settings-export\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:34:\"edit.php?post_type=acf-field-group\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:54:\"edit.php?post_type=acf-field-group>acf-settings-export\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:59:\"edit.php?post_type=acf-field-group&page=acf-settings-export\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:52:\"edit.php?post_type=acf-field-group>acf-settings-info\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:4:\"Info\";s:10:\"menu_title\";s:4:\"Info\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:17:\"acf-settings-info\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:2;s:6:\"parent\";s:34:\"edit.php?post_type=acf-field-group\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:52:\"edit.php?post_type=acf-field-group>acf-settings-info\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:57:\"edit.php?post_type=acf-field-group&page=acf-settings-info\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:46:\"edit.php?post_type=acf-field-group>acf-upgrade\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:10:\"Actualizar\";s:10:\"menu_title\";s:10:\"Actualizar\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"acf-upgrade\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:3;s:6:\"parent\";s:34:\"edit.php?post_type=acf-field-group\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:46:\"edit.php?post_type=acf-field-group>acf-upgrade\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:51:\"edit.php?post_type=acf-field-group&page=acf-upgrade\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:4;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:55:\"edit.php?post_type=acf-field-group>acf-settings-updates\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:7:\"Updates\";s:10:\"menu_title\";s:7:\"Updates\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:20:\"acf-settings-updates\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:4;s:6:\"parent\";s:34:\"edit.php?post_type=acf-field-group\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:55:\"edit.php?post_type=acf-field-group>acf-settings-updates\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:60:\"edit.php?post_type=acf-field-group&page=acf-settings-updates\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:13:\"Custom Fields\";s:10:\"menu_title\";s:13:\"Custom Fields\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:34:\"edit.php?post_type=acf-field-group\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:14;s:6:\"parent\";N;s:9:\"css_class\";s:71:\"menu-top menu-icon-generic toplevel_page_edit?post_type=acf-field-group\";s:8:\"hookname\";s:44:\"toplevel_page_edit?post_type=acf-field-group\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:35:\">edit.php?post_type=acf-field-group\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:34:\"edit.php?post_type=acf-field-group\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:11:\"separator_5\";a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:15;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:1;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:12:\">separator_5\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"separator_5\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:15;s:6:\"parent\";N;s:9:\"css_class\";s:17:\"wp-menu-separator\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:1;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:12:\">separator_5\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:0:\"\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:22:\"create-concept-options\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:16;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:23:\">create-concept-options\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:7:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:48:\"create-concept-options>ainia-create-concept-page\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:14:\"Crear concepto\";s:10:\"menu_title\";s:14:\"Crear concepto\";s:12:\"access_level\";s:10:\"edit_users\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:25:\"ainia-create-concept-page\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:22:\"create-concept-options\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:48:\"create-concept-options>ainia-create-concept-page\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:40:\"admin.php?page=ainia-create-concept-page\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:48:\"create-concept-options>ainia-manage-concept-page\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:19:\"Gestionar conceptos\";s:10:\"menu_title\";s:19:\"Gestionar conceptos\";s:12:\"access_level\";s:10:\"edit_users\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:25:\"ainia-manage-concept-page\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:22:\"create-concept-options\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:48:\"create-concept-options>ainia-manage-concept-page\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:40:\"admin.php?page=ainia-manage-concept-page\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:47:\"create-concept-options>ainia-create-source-page\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:12:\"Crear fuente\";s:10:\"menu_title\";s:12:\"Crear fuente\";s:12:\"access_level\";s:10:\"edit_users\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:24:\"ainia-create-source-page\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:2;s:6:\"parent\";s:22:\"create-concept-options\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:47:\"create-concept-options>ainia-create-source-page\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:39:\"admin.php?page=ainia-create-source-page\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:47:\"create-concept-options>ainia-manage-source-page\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:17:\"Gestionar fuentes\";s:10:\"menu_title\";s:16:\"Gestionar fuente\";s:12:\"access_level\";s:10:\"edit_users\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:24:\"ainia-manage-source-page\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:3;s:6:\"parent\";s:22:\"create-concept-options\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:47:\"create-concept-options>ainia-manage-source-page\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:39:\"admin.php?page=ainia-manage-source-page\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:4;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:42:\"create-concept-options>ainia-manage-groups\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:19:\"Grupos de conceptos\";s:10:\"menu_title\";s:19:\"Grupos de conceptos\";s:12:\"access_level\";s:10:\"edit_users\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:19:\"ainia-manage-groups\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:4;s:6:\"parent\";s:22:\"create-concept-options\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:42:\"create-concept-options>ainia-manage-groups\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:34:\"admin.php?page=ainia-manage-groups\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:5;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:5;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:52:\"create-concept-options>ainia-create-complex-matchers\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:22:\"Crear Complex Matchers\";s:10:\"menu_title\";s:22:\"Crear Complex Matchers\";s:12:\"access_level\";s:10:\"edit_users\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:29:\"ainia-create-complex-matchers\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:5;s:6:\"parent\";s:22:\"create-concept-options\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:52:\"create-concept-options>ainia-create-complex-matchers\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:44:\"admin.php?page=ainia-create-complex-matchers\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:6;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:6;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:52:\"create-concept-options>ainia-manage-complex-matchers\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:26:\"Gestionar Complex Matchers\";s:10:\"menu_title\";s:26:\"Gestionar Complex Matchers\";s:12:\"access_level\";s:10:\"edit_users\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:29:\"ainia-manage-complex-matchers\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:6;s:6:\"parent\";s:22:\"create-concept-options\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:52:\"create-concept-options>ainia-manage-complex-matchers\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:44:\"admin.php?page=ainia-manage-complex-matchers\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:20:\"iWatch Adminitration\";s:10:\"menu_title\";s:19:\"Fuentes y conceptos\";s:12:\"access_level\";s:10:\"edit_users\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:22:\"create-concept-options\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:16;s:6:\"parent\";N;s:9:\"css_class\";s:63:\"menu-top menu-icon-generic toplevel_page_create-concept-options\";s:8:\"hookname\";s:36:\"toplevel_page_create-concept-options\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:23:\">create-concept-options\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:37:\"admin.php?page=create-concept-options\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:10:\"edit_users\";}s:10:\"duplicator\";a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:17;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:11:\">duplicator\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:6:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:21:\"duplicator>duplicator\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:8:\"Paquetes\";s:10:\"menu_title\";s:8:\"Paquetes\";s:12:\"access_level\";s:6:\"export\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"duplicator\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:10:\"duplicator\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:21:\"duplicator>duplicator\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:25:\"admin.php?page=duplicator\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:27:\"duplicator>duplicator-tools\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:12:\"Herramientas\";s:10:\"menu_title\";s:12:\"Herramientas\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:16:\"duplicator-tools\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:10:\"duplicator\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:27:\"duplicator>duplicator-tools\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:31:\"admin.php?page=duplicator-tools\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:30:\"duplicator>duplicator-settings\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:14:\"Configuración\";s:10:\"menu_title\";s:14:\"Configuración\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:19:\"duplicator-settings\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:2;s:6:\"parent\";s:10:\"duplicator\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:30:\"duplicator>duplicator-settings\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:34:\"admin.php?page=duplicator-settings\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:26:\"duplicator>duplicator-help\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:5:\"Ayuda\";s:10:\"menu_title\";s:5:\"Ayuda\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:15:\"duplicator-help\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:3;s:6:\"parent\";s:10:\"duplicator\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:26:\"duplicator>duplicator-help\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:30:\"admin.php?page=duplicator-help\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:4;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:27:\"duplicator>duplicator-about\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:9:\"Acerca de\";s:10:\"menu_title\";s:9:\"Acerca de\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:16:\"duplicator-about\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:4;s:6:\"parent\";s:10:\"duplicator\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:27:\"duplicator>duplicator-about\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:31:\"admin.php?page=duplicator-about\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:5;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:5;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:27:\"duplicator>duplicator-gopro\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:60:\"<span style=\"color:#f18500\">¡Obtén la versión Pro!</span>\";s:10:\"menu_title\";s:60:\"<span style=\"color:#f18500\">¡Obtén la versión Pro!</span>\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:16:\"duplicator-gopro\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:5;s:6:\"parent\";s:10:\"duplicator\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:27:\"duplicator>duplicator-gopro\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:31:\"admin.php?page=duplicator-gopro\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:17:\"Duplicator Plugin\";s:10:\"menu_title\";s:10:\"Duplicator\";s:12:\"access_level\";s:6:\"export\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"duplicator\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:17;s:6:\"parent\";N;s:9:\"css_class\";s:33:\"menu-top toplevel_page_duplicator\";s:8:\"hookname\";s:24:\"toplevel_page_duplicator\";s:8:\"icon_url\";s:1378:\"data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz48IURPQ1RZUEUgc3ZnIFBVQkxJQyAiLS8vVzNDLy9EVEQgU1ZHIDEuMS8vRU4iICJodHRwOi8vd3d3LnczLm9yZy9HcmFwaGljcy9TVkcvMS4xL0RURC9zdmcxMS5kdGQiPjxzdmcgdmVyc2lvbj0iMS4xIiBpZD0iQXJ0d29yayIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayIgeD0iMHB4IiB5PSIwcHgiIHdpZHRoPSIyMy4yNXB4IiBoZWlnaHQ9IjIyLjM3NXB4IiB2aWV3Qm94PSIwIDAgMjMuMjUgMjIuMzc1IiBlbmFibGUtYmFja2dyb3VuZD0ibmV3IDAgMCAyMy4yNSAyMi4zNzUiIHhtbDpzcGFjZT0icHJlc2VydmUiPjxwYXRoIGZpbGw9IiM5Q0ExQTYiIGQ9Ik0xOC4wMTEsMS4xODhjLTEuOTk1LDAtMy42MTUsMS42MTgtMy42MTUsMy42MTRjMCwwLjA4NSwwLjAwOCwwLjE2NywwLjAxNiwwLjI1TDcuNzMzLDguMTg0QzcuMDg0LDcuNTY1LDYuMjA4LDcuMTgyLDUuMjQsNy4xODJjLTEuOTk2LDAtMy42MTUsMS42MTktMy42MTUsMy42MTRjMCwxLjk5NiwxLjYxOSwzLjYxMywzLjYxNSwzLjYxM2MwLjYyOSwwLDEuMjIyLTAuMTYyLDEuNzM3LTAuNDQ1bDIuODksMi40MzhjLTAuMTI2LDAuMzY4LTAuMTk4LDAuNzYzLTAuMTk4LDEuMTczYzAsMS45OTUsMS42MTgsMy42MTMsMy42MTQsMy42MTNjMS45OTUsMCwzLjYxNS0xLjYxOCwzLjYxNS0zLjYxM2MwLTEuOTk3LTEuNjItMy42MTQtMy42MTUtMy42MTRjLTAuNjMsMC0xLjIyMiwwLjE2Mi0xLjczNywwLjQ0M2wtMi44OS0yLjQzNWMwLjEyNi0wLjM2OCwwLjE5OC0wLjc2MywwLjE5OC0xLjE3M2MwLTAuMDg0LTAuMDA4LTAuMTY2LTAuMDEzLTAuMjVsNi42NzYtMy4xMzNjMC42NDgsMC42MTksMS41MjUsMS4wMDIsMi40OTUsMS4wMDJjMS45OTQsMCwzLjYxMy0xLjYxNywzLjYxMy0zLjYxM0MyMS42MjUsMi44MDYsMjAuMDA2LDEuMTg4LDE4LjAxMSwxLjE4OHoiLz48L3N2Zz4=\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:11:\">duplicator\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:25:\"admin.php?page=duplicator\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:17:\"pmxe-admin-manage\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";s:16:\"Exportar a Excel\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:18;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";s:16:\"dashicons-upload\";s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:18:\">pmxe-admin-manage\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:3:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:35:\"pmxe-admin-manage>pmxe-admin-manage\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:44:\"Manejar Exportaciones &lsaquo; WP All Export\";s:10:\"menu_title\";s:21:\"Manejar Exportaciones\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:17:\"pmxe-admin-manage\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:17:\"pmxe-admin-manage\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:35:\"pmxe-admin-manage>pmxe-admin-manage\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:32:\"admin.php?page=pmxe-admin-manage\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:35:\"pmxe-admin-manage>pmxe-admin-export\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:37:\"Exportar a XML &lsaquo; WP All Export\";s:10:\"menu_title\";s:18:\"Nueva Exportación\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:17:\"pmxe-admin-export\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:17:\"pmxe-admin-manage\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:35:\"pmxe-admin-manage>pmxe-admin-export\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:32:\"admin.php?page=pmxe-admin-export\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:35:\"pmxe-admin-manage>pmxe-admin-manage\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:44:\"Manejar Exportaciones &lsaquo; WP All Export\";s:10:\"menu_title\";s:21:\"Manejar Exportaciones\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:17:\"pmxe-admin-manage\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:2;s:6:\"parent\";s:17:\"pmxe-admin-manage\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:35:\"pmxe-admin-manage>pmxe-admin-manage\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:32:\"admin.php?page=pmxe-admin-manage\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:21:\"Manejar Exportaciones\";s:10:\"menu_title\";s:21:\"Manejar Exportaciones\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:17:\"pmxe-admin-manage\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:18;s:6:\"parent\";N;s:9:\"css_class\";s:58:\"menu-top menu-icon-generic toplevel_page_pmxe-admin-manage\";s:8:\"hookname\";s:31:\"toplevel_page_pmxe-admin-manage\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:18:\">pmxe-admin-manage\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:32:\"admin.php?page=pmxe-admin-manage\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";N;}}s:6:\"format\";a:3:{s:4:\"name\";s:22:\"Admin Menu Editor menu\";s:7:\"version\";s:3:\"7.0\";s:13:\"is_normalized\";b:1;}s:13:\"color_presets\";a:0:{}s:20:\"component_visibility\";a:0:{}}s:18:\"first_install_time\";i:1488874951;s:21:\"display_survey_notice\";b:0;s:17:\"plugin_db_version\";i:140;s:24:\"security_logging_enabled\";b:0;s:17:\"menu_config_scope\";s:6:\"global\";s:13:\"plugin_access\";s:14:\"manage_options\";s:15:\"allowed_user_id\";N;s:28:\"plugins_page_allowed_user_id\";N;s:27:\"show_deprecated_hide_button\";b:1;s:37:\"dashboard_hiding_confirmation_enabled\";b:1;s:21:\"submenu_icons_enabled\";s:9:\"if_custom\";s:16:\"ui_colour_scheme\";s:7:\"classic\";s:13:\"visible_users\";a:0:{}s:23:\"show_plugin_menu_notice\";b:0;s:20:\"unused_item_position\";s:8:\"relative\";s:15:\"error_verbosity\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("147", "wp_extended_users_version", "20121216", "yes");
INSERT INTO `wp_options` VALUES("150", "acf_version", "5.0.9", "yes");
INSERT INTO `wp_options` VALUES("151", "jwbp_version", "0.3.5", "yes");
INSERT INTO `wp_options` VALUES("152", "PMXE_Plugin_Options", "a:11:{s:12:\"info_api_url\";s:26:\"http://www.wpallimport.com\";s:7:\"dismiss\";i:0;s:18:\"dismiss_manage_top\";i:0;s:21:\"dismiss_manage_bottom\";i:0;s:12:\"cron_job_key\";s:12:\"AW1wYTOf6sD5\";s:14:\"max_input_time\";i:-1;s:18:\"max_execution_time\";i:-1;s:6:\"secure\";i:1;s:14:\"zapier_api_key\";s:32:\"19VY1x0N3H6HjFPk64ERObAQbIujC7cB\";s:21:\"zapier_invitation_url\";s:0:\"\";s:30:\"zapier_invitation_url_received\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("154", "widget_shortcode-widget", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:35:\"[grafico_entradas_x_fuente_usuario]\";s:6:\"filter\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("156", "duplicator_version_plugin", "1.1.34", "yes");
INSERT INTO `wp_options` VALUES("157", "widget_wysija", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("158", "wysija_post_type_updated", "1488875181", "yes");
INSERT INTO `wp_options` VALUES("159", "wysija_post_type_created", "1488875181", "yes");
INSERT INTO `wp_options` VALUES("160", "installation_step", "16", "yes");
INSERT INTO `wp_options` VALUES("161", "wysija", "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", "yes");
INSERT INTO `wp_options` VALUES("162", "wysija_reinstall", "0", "no");
INSERT INTO `wp_options` VALUES("163", "wysija_schedules", "a:5:{s:5:\"queue\";a:3:{s:13:\"next_schedule\";i:1555342950;s:13:\"prev_schedule\";b:0;s:7:\"running\";b:0;}s:6:\"bounce\";a:3:{s:13:\"next_schedule\";i:1488961597;s:13:\"prev_schedule\";i:0;s:7:\"running\";b:0;}s:5:\"daily\";a:3:{s:13:\"next_schedule\";i:1555400442;s:13:\"prev_schedule\";b:0;s:7:\"running\";b:0;}s:6:\"weekly\";a:3:{s:13:\"next_schedule\";i:1555491159;s:13:\"prev_schedule\";b:0;s:7:\"running\";b:0;}s:7:\"monthly\";a:3:{s:13:\"next_schedule\";i:1555486837;s:13:\"prev_schedule\";b:0;s:7:\"running\";b:0;}}", "yes");
INSERT INTO `wp_options` VALUES("164", "widget_taxonomy", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("165", "current_theme", "ainia bloggr Child iWatch ecoembes", "yes");
INSERT INTO `wp_options` VALUES("166", "theme_mods_ainia_bloggr_child", "a:5:{i:0;b:0;s:18:\"custom_css_post_id\";i:-1;s:11:\"bloggr_logo\";s:79:\"http://www.observatoriodelenvase.com/wp-content/uploads/2017/12/logo_iwatch.png\";s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:82;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1525692178;s:4:\"data\";a:8:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:11:\"tag_cloud-2\";i:1;s:12:\"categories-2\";}s:9:\"sidebar-1\";a:4:{i:0;s:8:\"search-2\";i:1;s:6:\"text-2\";i:2;s:6:\"text-3\";i:3;s:18:\"shortcode-widget-2\";}s:17:\"sidebar-home-left\";a:0:{}s:18:\"sidebar-home-right\";a:0:{}s:12:\"sidebar-home\";a:0:{}s:8:\"footer-1\";a:0:{}s:8:\"footer-2\";a:0:{}s:8:\"footer-3\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("167", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("168", "widget_category-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("185", "widget_bloggr_contact_info", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("186", "widget_bloggr_video_widget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("203", "wysija_check_pn", "1555339349.9049", "yes");
INSERT INTO `wp_options` VALUES("204", "wysija_last_scheduled_check", "1555339350", "yes");
INSERT INTO `wp_options` VALUES("205", "wysija_last_php_cron_call", "1558431327", "yes");
INSERT INTO `wp_options` VALUES("316", "infinite_scroll", "a:9:{s:7:\"loading\";a:3:{s:7:\"msgText\";s:19:\"<em>Loading...</em>\";s:11:\"finishedMsg\";s:29:\"<em>No additional posts.</em>\";s:3:\"img\";s:91:\"http://www.observatoriodelenvase.com/wp-content/plugins/infinite-scroll/img/ajax-loader.gif\";}s:12:\"nextSelector\";s:15:\".nav-previous a\";s:11:\"navSelector\";s:10:\".nav-links\";s:12:\"itemSelector\";s:18:\"#masonry-container\";s:15:\"contentSelector\";s:8:\"#primary\";s:5:\"debug\";b:0;s:8:\"behavior\";s:0:\"\";s:8:\"callback\";s:0:\"\";s:10:\"db_version\";s:5:\"2.6.1\";}", "yes");
INSERT INTO `wp_options` VALUES("390", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("445", "wysija_queries", "", "no");
INSERT INTO `wp_options` VALUES("446", "wysija_queries_errors", "", "no");
INSERT INTO `wp_options` VALUES("447", "wysija_msg", "", "no");
INSERT INTO `wp_options` VALUES("768", "fuente_url_48", "", "yes");
INSERT INTO `wp_options` VALUES("882", "theme_mods_bloggr", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:82;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1490947889;s:4:\"data\";a:8:{s:19:\"wp_inactive_widgets\";a:1:{i:0;s:12:\"categories-2\";}s:9:\"sidebar-1\";a:4:{i:0;s:6:\"text-2\";i:1;s:11:\"tag_cloud-2\";i:2;s:8:\"search-2\";i:3;s:18:\"shortcode-widget-2\";}s:17:\"sidebar-home-left\";a:0:{}s:18:\"sidebar-home-right\";a:0:{}s:12:\"sidebar-home\";a:0:{}s:8:\"footer-1\";a:0:{}s:8:\"footer-2\";a:0:{}s:8:\"footer-3\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("1243", "fuente_url_219", "http://www.frozenfoodeurope.com/feed/", "yes");
INSERT INTO `wp_options` VALUES("1293", "fuente_url_221", "http://www.revistainforetail.com", "yes");
INSERT INTO `wp_options` VALUES("1477", "fuente_url_237", "http://www.refrigeratedfrozenfood.com/", "yes");
INSERT INTO `wp_options` VALUES("1583", "fuente_url_238", "http://www.g3mm.com", "yes");
INSERT INTO `wp_options` VALUES("1588", "fuente_url_239", "http://www.eurocarne.com", "yes");
INSERT INTO `wp_options` VALUES("2106", "external_theme_updates-bloggr", "O:8:\"stdClass\":3:{s:9:\"lastCheck\";i:1555315886;s:14:\"checkedVersion\";s:5:\"1.4.3\";s:6:\"update\";N;}", "yes");
INSERT INTO `wp_options` VALUES("3536", "ez_filter_options", "a:2:{s:10:\"post_types\";a:1:{i:0;s:4:\"post\";}s:4:\"post\";a:4:{s:6:\"config\";a:4:{i:0;s:5:\"month\";i:1;s:8:\"category\";i:2;s:10:\"date_range\";i:3;s:8:\"taxonomy\";}s:8:\"taxonomy\";s:9:\"selective\";s:18:\"taxonomies-details\";a:1:{i:0;s:6:\"fuente\";}s:5:\"style\";a:1:{s:6:\"fuente\";s:8:\"dropdown\";}}}", "yes");
INSERT INTO `wp_options` VALUES("4214", "theme_mods_ainia_bloggr_child_ecoembes", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:82;}s:18:\"custom_css_post_id\";i:-1;}", "yes");
INSERT INTO `wp_options` VALUES("4396", "cimy_uef_options", "a:23:{s:18:\"extra_fields_title\";s:12:\"Extra Fields\";s:14:\"users_per_page\";i:50;s:17:\"aue_hidden_fields\";a:3:{i:0;s:5:\"posts\";i:1;s:5:\"email\";i:2;s:7:\"website\";}s:16:\"wp_hidden_fields\";a:1:{i:0;s:8:\"username\";}s:14:\"fieldset_title\";s:0:\"\";s:17:\"registration-logo\";s:0:\"\";s:7:\"captcha\";s:4:\"none\";s:13:\"welcome_email\";s:60:\"Nombre de usuario: USERNAME\r\nPassword: PASSWORD\r\nLOGINLINK\r\n\";s:12:\"confirm_form\";b:0;s:13:\"confirm_email\";b:0;s:14:\"password_meter\";b:0;s:19:\"mail_include_fields\";b:1;s:32:\"email_include_plaintext_password\";b:0;s:11:\"redirect_to\";s:0:\"\";s:11:\"file_fields\";a:5:{s:11:\"show_in_reg\";i:0;s:15:\"show_in_profile\";i:0;s:11:\"show_in_aeu\";i:0;s:12:\"show_in_blog\";i:0;s:14:\"show_in_search\";i:0;}s:12:\"image_fields\";a:5:{s:11:\"show_in_reg\";i:0;s:15:\"show_in_profile\";i:0;s:11:\"show_in_aeu\";i:0;s:12:\"show_in_blog\";i:0;s:14:\"show_in_search\";i:0;}s:14:\"tinymce_fields\";a:5:{s:11:\"show_in_reg\";i:0;s:15:\"show_in_profile\";i:0;s:11:\"show_in_aeu\";i:0;s:12:\"show_in_blog\";i:0;s:14:\"show_in_search\";i:0;}s:7:\"version\";s:5:\"2.7.2\";s:11:\"date_fields\";a:5:{s:11:\"show_in_reg\";i:0;s:15:\"show_in_profile\";i:0;s:11:\"show_in_aeu\";i:0;s:12:\"show_in_blog\";i:0;s:14:\"show_in_search\";i:0;}s:20:\"recaptcha_public_key\";s:0:\"\";s:21:\"recaptcha_private_key\";s:0:\"\";s:19:\"recaptcha2_site_key\";s:0:\"\";s:21:\"recaptcha2_secret_key\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("4397", "confirm-user-registration", "a:4:{s:5:\"error\";s:104:\"<strong>AVISO: </strong>Su cuenta debe ser verificada por un adminiostrador antes de que pueda acceder .\";s:4:\"from\";s:31:\"ainia iWatch 4.0 <tic@ainia.es>\";s:7:\"subject\";s:41:\"Confirmación de cuenta: ainia iWatch 4.0\";s:7:\"message\";s:161:\"Su cuenta ha sido aprovada por un administrador! \r\n\r\nPuede acceder desde  http://213.229.136.105/iwatch/chovi/wp-login.php\r\n\r\nEste es un mensaje automático.\r\n\r\n\";}", "yes");
INSERT INTO `wp_options` VALUES("4398", "sb_we_settings", "O:8:\"stdClass\":14:{s:17:\"header_from_email\";s:13:\"[admin_email]\";s:16:\"header_from_name\";s:0:\"\";s:14:\"header_send_as\";s:4:\"html\";s:18:\"set_global_headers\";s:1:\"1\";s:12:\"user_subject\";s:55:\"[[blog_name]]  Información de tu usuario y contraseña\";s:9:\"user_body\";s:264:\"Su usuario no estará activo hasta ser validado por un administrador. Recibirá una notificación cuando esto ocurra, mientras tanto puede crear su contraseña en el enlace adjunto:<br><br>\r\n\r\nUsuario: [user_login]<br />Password: [reset_pass_link]<br />[login_url]\";s:17:\"we_attachment_url\";s:0:\"\";s:17:\"header_additional\";s:0:\"\";s:15:\"header_reply_to\";s:13:\"[admin_email]\";s:13:\"admin_subject\";s:39:\"[[blog_name]] Registro de nuevo usuario\";s:10:\"admin_body\";s:223:\"Se ha registrado un nuevo usuario en [blog_name]<br /><br />Username: [user_login]<br />Email: [user_email]\r\n\r\n<br><br>Debe validar este usuario desde \"Confirmar Registro de usuarios\" para que pueda acceder a la plataforma.\";s:20:\"admin_notify_user_id\";s:1:\"1\";s:25:\"password_reminder_subject\";s:29:\"[[blog_name]] Forgot Password\";s:22:\"password_reminder_body\";s:285:\"Someone requested that the password be reset for the following account.<br /><br />[site_url]<br /><br />Username: [user_login]<br /><br />If this was a mistake, just ignore this email and nothing will happen.<br /><br />To reset your password, visit the following address: [reset_url]\";}", "yes");
INSERT INTO `wp_options` VALUES("4399", "sb_we_v4_migration_complete", "1526643339", "yes");
INSERT INTO `wp_options` VALUES("4692", "json_api_controllers", "core,user", "yes");
INSERT INTO `wp_options` VALUES("4700", "json_api_base", "api", "yes");
INSERT INTO `wp_options` VALUES("6223", "_wpallexport_session_new_", "a:7:{s:14:\"is_user_export\";b:1;s:17:\"is_comment_export\";b:0;s:18:\"is_taxonomy_export\";b:0;s:3:\"cpt\";s:22:\"a:1:{i:0;s:5:\"users\";}\";s:11:\"whereclause\";s:0:\"\";s:10:\"joinclause\";s:6:\"a:0:{}\";s:11:\"exportquery\";N;}", "no");
INSERT INTO `wp_options` VALUES("6224", "_wpallexport_session_expires_new_", "1538121682", "no");
INSERT INTO `wp_options` VALUES("8106", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("8115", "sbp_page_time", "1,25", "yes");
INSERT INTO `wp_options` VALUES("8116", "sbp_page_queries", "6", "yes");
INSERT INTO `wp_options` VALUES("8117", "sbp_settings", "a:19:{s:15:\"use_google_libs\";s:1:\"1\";s:13:\"query_strings\";s:1:\"1\";s:12:\"font_awesome\";s:1:\"1\";s:13:\"remove_emojis\";s:1:\"1\";s:10:\"remove_wsl\";s:1:\"1\";s:15:\"remove_adjacent\";s:1:\"1\";s:8:\"wml_link\";s:1:\"1\";s:12:\"wp_generator\";s:1:\"1\";s:16:\"remove_all_feeds\";s:1:\"1\";s:14:\"disable_xmlrpc\";s:1:\"1\";s:19:\"heartbeat_frequency\";s:2:\"15\";s:20:\"limit_post_revisions\";s:2:\"30\";s:17:\"autosave_interval\";s:1:\"1\";s:11:\"sbp_cdn_url\";s:0:\"\";s:28:\"sbp_cdn_included_directories\";s:22:\"wp-content,wp-includes\";s:18:\"sbp_cdn_exclusions\";s:4:\".php\";s:18:\"sbp_ga_tracking_id\";s:0:\"\";s:21:\"sbp_tracking_position\";s:6:\"header\";s:15:\"sbp_bounce_rate\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("8118", "sbp_integer", "", "yes");
INSERT INTO `wp_options` VALUES("8119", "sbp_css_exceptions", "", "yes");
INSERT INTO `wp_options` VALUES("8120", "sbp_sanitize", "", "yes");
INSERT INTO `wp_options` VALUES("8121", "sbp_js_footer_exceptions1", "", "yes");
INSERT INTO `wp_options` VALUES("8122", "sbp_js_footer_exceptions2", "", "yes");
INSERT INTO `wp_options` VALUES("8123", "sbp_js_footer_exceptions3", "", "yes");
INSERT INTO `wp_options` VALUES("8124", "sbp_js_footer_exceptions4", "", "yes");
INSERT INTO `wp_options` VALUES("8125", "sbp_defer_exceptions1", "", "yes");
INSERT INTO `wp_options` VALUES("8126", "sbp_defer_exceptions2", "", "yes");
INSERT INTO `wp_options` VALUES("8127", "sbp_defer_exceptions3", "", "yes");
INSERT INTO `wp_options` VALUES("8128", "sbp_defer_exceptions4", "", "yes");
INSERT INTO `wp_options` VALUES("8133", "all_theme_scripts_handle", "jquery-migrate<br />jquery-ui-core<br />query-monitor<br />ajax-script<br />ainia_javascript_functions<br />highcharts<br />highcharts-more<br />highcharts-exporting<br />pkg_autologin_show_link_popup_script<br />bloggr-navigation<br />bloggr-skip-link-focus-fix<br />bloggr-push-menu<br />bloggr-scripts<br />bloggr-placeholder<br />bloggr-placeholdertext<br />wp-embed<br />", "yes");
INSERT INTO `wp_options` VALUES("8134", "all_theme_scripts_src", "/wp-includes/js/jquery/jquery-migrate.min.js<br />//ajax.googleapis.com/ajax/libs/jqueryui/1.11.4/jquery-ui.min.js<br />http://www.observatoriodelenvase.com/wp-content/plugins/query-monitor/assets/query-monitor.js<br />http://www.observatoriodelenvase.com/wp-content/plugins/ainia_base/ajax.js<br />http://www.observatoriodelenvase.com/wp-content/plugins/ainia_base/ainia_javascript_functions.js<br />http://code.highcharts.com/highcharts.js<br />http://code.highcharts.com/highcharts-more.js<br />http://code.highcharts.com/modules/exporting.js<br />/wp-content/plugins/autologin-links/autologin-show-link-popup.js<br />http://www.observatoriodelenvase.com/wp-content/themes/bloggr/js/navigation.js<br />http://www.observatoriodelenvase.com/wp-content/themes/bloggr/js/skip-link-focus-fix.js<br />http://www.observatoriodelenvase.com/wp-content/themes/bloggr/js/jPushMenu.js<br />http://www.observatoriodelenvase.com/wp-content/themes/bloggr/js/bloggr.scripts.js<br />http://www.observatoriodelenvase.com/wp-content/themes/bloggr/js/jquery.placeholder.js<br />http://www.observatoriodelenvase.com/wp-content/themes/bloggr/js/placeholdertext.js<br />/wp-includes/js/wp-embed.min.js<br />", "yes");
INSERT INTO `wp_options` VALUES("8135", "all_theme_styles_handle", "jquery-ui-css<br />validate-engine-css<br />query-monitor<br />custom_wp_admin_css<br />pkg_autologin_show_link_popup_stylesheet<br />style<br />bloggr-google-fonts<br />bloggr-style<br />bloggr-rajdhani<br />bloggr-rajdhani-body<br />bloggr-push-menu<br />bloggr-animations<br />font-awesome<br />bloggr-font-awesome<br />", "yes");
INSERT INTO `wp_options` VALUES("11318", "duplicator_settings", "a:10:{s:7:\"version\";s:6:\"1.1.34\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:0;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("11325", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1555315888;s:7:\"checked\";a:6:{s:18:\"ainia_bloggr_child\";s:3:\"0.1\";s:27:\"ainia_bloggr_child_ecoembes\";s:3:\"0.1\";s:6:\"bloggr\";s:5:\"1.4.3\";s:13:\"twentyfifteen\";s:3:\"1.7\";s:15:\"twentyseventeen\";s:3:\"1.1\";s:13:\"twentysixteen\";s:3:\"1.3\";}s:8:\"response\";a:3:{s:13:\"twentyfifteen\";a:4:{s:5:\"theme\";s:13:\"twentyfifteen\";s:11:\"new_version\";s:3:\"2.4\";s:3:\"url\";s:43:\"https://wordpress.org/themes/twentyfifteen/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/theme/twentyfifteen.2.4.zip\";}s:15:\"twentyseventeen\";a:4:{s:5:\"theme\";s:15:\"twentyseventeen\";s:11:\"new_version\";s:3:\"2.1\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentyseventeen/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentyseventeen.2.1.zip\";}s:13:\"twentysixteen\";a:4:{s:5:\"theme\";s:13:\"twentysixteen\";s:11:\"new_version\";s:3:\"1.9\";s:3:\"url\";s:43:\"https://wordpress.org/themes/twentysixteen/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/theme/twentysixteen.1.9.zip\";}}s:12:\"translations\";a:2:{i:0;a:7:{s:4:\"type\";s:5:\"theme\";s:4:\"slug\";s:15:\"twentyseventeen\";s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"1.0\";s:7:\"updated\";s:19:\"2017-06-27 09:03:38\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/theme/twentyseventeen/1.0/es_ES.zip\";s:10:\"autoupdate\";b:1;}i:1;a:7:{s:4:\"type\";s:5:\"theme\";s:4:\"slug\";s:15:\"twentyseventeen\";s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:3:\"1.0\";s:7:\"updated\";s:19:\"2017-06-19 07:06:56\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/theme/twentyseventeen/1.0/es_MX.zip\";s:10:\"autoupdate\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("11328", "_site_transient_timeout_browser_eb9c1268a950e6eddb2708071f6b0d52", "1555569783", "no");
INSERT INTO `wp_options` VALUES("11329", "_site_transient_browser_eb9c1268a950e6eddb2708071f6b0d52", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"73.0.3683.86\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("11345", "_site_transient_timeout_available_translations", "1554998212", "no");
INSERT INTO `wp_options` VALUES("11346", "_site_transient_available_translations", "a:108:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-03-27 04:32:49\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:49:08\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.4/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-22 18:59:07\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-12 20:34:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-09 11:39:31\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.4/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-16 13:06:08\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-04 16:58:43\";s:12:\"english_name\";s:7:\"Bengali\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:23:\"এগিয়ে চল.\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-05 09:44:12\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"མུ་མཐུད།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-04 20:20:28\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-12 09:29:39\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-12 08:46:26\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:49:29\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-05 09:50:06\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:39:59\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/4.7.4/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-28 14:35:15\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/4.7.4/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-03-18 13:57:42\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:40:03\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-11 20:10:39\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:49:34\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-27 00:40:28\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-28 03:10:25\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:53:43\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:54:30\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-04 18:08:49\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-23 23:02:31\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-10 16:26:52\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:41:31\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:54:37\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:54:37\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-28 20:09:49\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-09 09:36:22\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:42:28\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 16:37:11\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-12 06:40:28\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-02-02 15:21:03\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:42:25\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-02-03 21:08:25\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-05 12:10:24\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:40:32\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:40:27\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-21 14:17:42\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:31:\"ચાલુ રાખવું\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4.2/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-29 21:21:10\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-01 10:53:22\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"जारी\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-03-28 13:34:22\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:48:39\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-02 14:01:52\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-13 13:55:54\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-08 04:57:54\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-02 05:13:51\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"続ける\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-05 06:17:00\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:39:13\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-07 02:07:59\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-18 05:09:08\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:48:25\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-03-30 09:46:13\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-03-17 20:40:40\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:54:41\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:43:32\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-12 07:29:35\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"Үргэлжлүүлэх\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-03-24 06:52:11\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-03-05 09:45:10\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.1.20\";s:7:\"updated\";s:19:\"2015-03-26 15:57:42\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.1.20/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:42:31\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:48:31\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-11 15:57:29\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-15 08:29:44\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-02-16 13:24:21\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/4.7.4/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:40:57\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-02 13:47:38\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:7:\"Punjabi\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-23 09:31:28\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.1.20\";s:7:\"updated\";s:19:\"2015-03-29 22:19:48\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1.20/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-15 10:57:32\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-17 15:02:48\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-15 14:53:36\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-20 10:13:53\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-10 13:48:29\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-02-08 17:57:45\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-24 08:35:30\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:41:03\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-03 00:34:10\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:48:43\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-30 02:38:08\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-15 09:03:35\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-05 09:23:39\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-17 03:13:31\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-03-27 07:08:07\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-13 09:55:38\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-10 15:33:37\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-08 04:16:08\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-03-28 12:03:30\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:16:\"香港中文版	\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:54:45\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}}", "no");
INSERT INTO `wp_options` VALUES("11347", "_transient_timeout_plugin_slugs", "1555074111", "no");
INSERT INTO `wp_options` VALUES("11348", "_transient_plugin_slugs", "a:24:{i:0;s:33:\"admin-menu-editor/menu-editor.php\";i:1;s:20:\"ainia_base/index.php\";i:2;s:22:\"ainia_iwatch/index.php\";i:3;s:35:\"autologin-links/autologin-links.php\";i:4;s:23:\"bulkpress/bulkpress.php\";i:5;s:37:\"bulkpress-export/bulkpress-export.php\";i:6;s:43:\"category-thumbnails/category-thumbnails.php\";i:7;s:49:\"cimy-user-extra-fields/cimy_user_extra_fields.php\";i:8;s:55:\"confirm-user-registration/confirm-user-registration.php\";i:9;s:63:\"disable-new-user-notifications/cwwp-disable-new-user-emails.php\";i:10;s:25:\"duplicator/duplicator.php\";i:11;s:25:\"easy-filter/ez-filter.php\";i:12;s:35:\"infinite-scroll/infinite-scroll.php\";i:13;s:21:\"json-api/json-api.php\";i:14;s:31:\"json-api-user/json-api-user.php\";i:15;s:28:\"wysija-newsletters/index.php\";i:16;s:31:\"query-monitor/query-monitor.php\";i:17;s:48:\"welcome-email-editor/sb_welcome_email_editor.php\";i:18;s:26:\"shortcode-widget/index.php\";i:19;s:41:\"speed-booster-pack/speed-booster-pack.php\";i:20;s:35:\"taxonomy-widget/taxonomy-widget.php\";i:21;s:33:\"user-switching/user-switching.php\";i:22;s:41:\"wordpress-importer/wordpress-importer.php\";i:23;s:31:\"wp-all-export/wp-all-export.php\";}", "no");
INSERT INTO `wp_options` VALUES("11349", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1554998518", "no");
INSERT INTO `wp_options` VALUES("11350", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "O:8:\"stdClass\":100:{s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4570;}s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:3385;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2617;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2487;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:1913;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:1724;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1720;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1466;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1431;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1425;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1425;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1360;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:1298;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1291;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1137;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:1101;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1091;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:1054;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:993;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:924;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:852;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:842;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:831;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:777;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:727;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:726;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:721;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:709;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:699;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:697;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:682;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:680;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:664;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:650;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:650;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:649;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:628;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:618;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:616;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:612;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:584;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:569;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:566;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:559;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:559;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:550;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:537;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:534;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:528;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:525;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:521;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:514;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:508;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:500;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:499;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:493;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:475;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:470;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:469;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:466;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:465;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:462;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:454;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:445;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:429;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:427;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:419;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:419;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:415;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:409;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:406;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:396;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:388;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:388;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:388;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:384;}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";i:378;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:378;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:373;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:367;}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";i:361;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:357;}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";i:357;}s:3:\"url\";a:3:{s:4:\"name\";s:3:\"url\";s:4:\"slug\";s:3:\"url\";s:5:\"count\";i:354;}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";i:353;}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";i:346;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:346;}s:4:\"list\";a:3:{s:4:\"name\";s:4:\"list\";s:4:\"slug\";s:4:\"list\";s:5:\"count\";i:344;}s:14:\"contact-form-7\";a:3:{s:4:\"name\";s:14:\"contact form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"count\";i:328;}s:11:\"performance\";a:3:{s:4:\"name\";s:11:\"performance\";s:4:\"slug\";s:11:\"performance\";s:5:\"count\";i:326;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:322;}s:11:\"advertising\";a:3:{s:4:\"name\";s:11:\"advertising\";s:4:\"slug\";s:11:\"advertising\";s:5:\"count\";i:321;}s:16:\"custom-post-type\";a:3:{s:4:\"name\";s:16:\"custom post type\";s:4:\"slug\";s:16:\"custom-post-type\";s:5:\"count\";i:316;}s:6:\"simple\";a:3:{s:4:\"name\";s:6:\"simple\";s:4:\"slug\";s:6:\"simple\";s:5:\"count\";i:315;}s:9:\"gutenberg\";a:3:{s:4:\"name\";s:9:\"gutenberg\";s:4:\"slug\";s:9:\"gutenberg\";s:5:\"count\";i:314;}s:16:\"google-analytics\";a:3:{s:4:\"name\";s:16:\"google analytics\";s:4:\"slug\";s:16:\"google-analytics\";s:5:\"count\";i:314;}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";i:310;}s:6:\"author\";a:3:{s:4:\"name\";s:6:\"author\";s:4:\"slug\";s:6:\"author\";s:5:\"count\";i:308;}s:7:\"adsense\";a:3:{s:4:\"name\";s:7:\"adsense\";s:4:\"slug\";s:7:\"adsense\";s:5:\"count\";i:308;}s:4:\"html\";a:3:{s:4:\"name\";s:4:\"html\";s:4:\"slug\";s:4:\"html\";s:5:\"count\";i:308;}}", "no");
INSERT INTO `wp_options` VALUES("11351", "_site_transient_update_plugins", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1555315885;s:8:\"response\";a:13:{s:33:\"admin-menu-editor/menu-editor.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:31:\"w.org/plugins/admin-menu-editor\";s:4:\"slug\";s:17:\"admin-menu-editor\";s:6:\"plugin\";s:33:\"admin-menu-editor/menu-editor.php\";s:11:\"new_version\";s:5:\"1.8.8\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/admin-menu-editor/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/admin-menu-editor.1.8.8.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:70:\"https://ps.w.org/admin-menu-editor/assets/icon-128x128.png?rev=1418604\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:72:\"https://ps.w.org/admin-menu-editor/assets/banner-772x250.png?rev=1419590\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.1.1\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:35:\"autologin-links/autologin-links.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:29:\"w.org/plugins/autologin-links\";s:4:\"slug\";s:15:\"autologin-links\";s:6:\"plugin\";s:35:\"autologin-links/autologin-links.php\";s:11:\"new_version\";s:6:\"1.10.0\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/autologin-links/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/autologin-links.zip\";s:5:\"icons\";a:1:{s:7:\"default\";s:59:\"https://s.w.org/plugins/geopattern-icon/autologin-links.svg\";}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"4.9.9\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:63:\"disable-new-user-notifications/cwwp-disable-new-user-emails.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:44:\"w.org/plugins/disable-new-user-notifications\";s:4:\"slug\";s:30:\"disable-new-user-notifications\";s:6:\"plugin\";s:63:\"disable-new-user-notifications/cwwp-disable-new-user-emails.php\";s:11:\"new_version\";s:5:\"1.0.3\";s:3:\"url\";s:61:\"https://wordpress.org/plugins/disable-new-user-notifications/\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/plugin/disable-new-user-notifications.1.0.3.zip\";s:5:\"icons\";a:1:{s:7:\"default\";s:74:\"https://s.w.org/plugins/geopattern-icon/disable-new-user-notifications.svg\";}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.1.1\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"1.3.10\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.1.3.10.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=1298463\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=1298463\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=1645055\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.1.1\";s:12:\"requires_php\";s:6:\"5.2.17\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:25:\"easy-filter/ez-filter.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:25:\"w.org/plugins/easy-filter\";s:4:\"slug\";s:11:\"easy-filter\";s:6:\"plugin\";s:25:\"easy-filter/ez-filter.php\";s:11:\"new_version\";s:4:\"1.10\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/easy-filter/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/easy-filter.1.10.zip\";s:5:\"icons\";a:1:{s:7:\"default\";s:62:\"https://s.w.org/plugins/geopattern-icon/easy-filter_213951.svg\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/easy-filter/assets/banner-772x250.jpg?rev=614231\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"4.9.5\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:31:\"json-api-user/json-api-user.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:27:\"w.org/plugins/json-api-user\";s:4:\"slug\";s:13:\"json-api-user\";s:6:\"plugin\";s:31:\"json-api-user/json-api-user.php\";s:11:\"new_version\";s:5:\"3.0.0\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/json-api-user/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/json-api-user.3.0.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/json-api-user/assets/icon-256x256.png?rev=1965790\";s:2:\"1x\";s:66:\"https://ps.w.org/json-api-user/assets/icon-128x128.png?rev=1965790\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/json-api-user/assets/banner-1544x500.png?rev=1965790\";s:2:\"1x\";s:68:\"https://ps.w.org/json-api-user/assets/banner-772x250.png?rev=1965790\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.0.0\";s:12:\"requires_php\";s:3:\"5.3\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:28:\"wysija-newsletters/index.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:32:\"w.org/plugins/wysija-newsletters\";s:4:\"slug\";s:18:\"wysija-newsletters\";s:6:\"plugin\";s:28:\"wysija-newsletters/index.php\";s:11:\"new_version\";s:4:\"2.11\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/wysija-newsletters/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/wysija-newsletters.2.11.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:71:\"https://ps.w.org/wysija-newsletters/assets/icon-256x256.png?rev=1703780\";s:2:\"1x\";s:63:\"https://ps.w.org/wysija-newsletters/assets/icon.svg?rev=1390234\";s:3:\"svg\";s:63:\"https://ps.w.org/wysija-newsletters/assets/icon.svg?rev=1390234\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:74:\"https://ps.w.org/wysija-newsletters/assets/banner-1544x500.png?rev=1703780\";s:2:\"1x\";s:73:\"https://ps.w.org/wysija-newsletters/assets/banner-772x250.jpg?rev=1703780\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"4.9.9\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:31:\"query-monitor/query-monitor.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:27:\"w.org/plugins/query-monitor\";s:4:\"slug\";s:13:\"query-monitor\";s:6:\"plugin\";s:31:\"query-monitor/query-monitor.php\";s:11:\"new_version\";s:5:\"3.3.4\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/query-monitor/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/query-monitor.3.3.4.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:66:\"https://ps.w.org/query-monitor/assets/icon-256x256.png?rev=2056073\";s:2:\"1x\";s:58:\"https://ps.w.org/query-monitor/assets/icon.svg?rev=2056073\";s:3:\"svg\";s:58:\"https://ps.w.org/query-monitor/assets/icon.svg?rev=2056073\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/query-monitor/assets/banner-1544x500.png?rev=1629576\";s:2:\"1x\";s:68:\"https://ps.w.org/query-monitor/assets/banner-772x250.png?rev=1731469\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.1.1\";s:12:\"requires_php\";s:3:\"5.3\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:26:\"shortcode-widget/index.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:30:\"w.org/plugins/shortcode-widget\";s:4:\"slug\";s:16:\"shortcode-widget\";s:6:\"plugin\";s:26:\"shortcode-widget/index.php\";s:11:\"new_version\";s:5:\"1.5.2\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/shortcode-widget/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/plugin/shortcode-widget.1.5.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/shortcode-widget/assets/icon-256x256.png?rev=1718887\";s:2:\"1x\";s:69:\"https://ps.w.org/shortcode-widget/assets/icon-128x128.png?rev=1718887\";}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:3:\"5.1\";s:12:\"requires_php\";s:3:\"5.6\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:41:\"speed-booster-pack/speed-booster-pack.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:32:\"w.org/plugins/speed-booster-pack\";s:4:\"slug\";s:18:\"speed-booster-pack\";s:6:\"plugin\";s:41:\"speed-booster-pack/speed-booster-pack.php\";s:11:\"new_version\";s:5:\"3.7.7\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/speed-booster-pack/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/speed-booster-pack.3.7.7.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:71:\"https://ps.w.org/speed-booster-pack/assets/icon-128x128.jpg?rev=1821064\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:73:\"https://ps.w.org/speed-booster-pack/assets/banner-772x250.jpg?rev=1821064\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.1.1\";s:12:\"requires_php\";s:3:\"5.6\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:33:\"user-switching/user-switching.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:28:\"w.org/plugins/user-switching\";s:4:\"slug\";s:14:\"user-switching\";s:6:\"plugin\";s:33:\"user-switching/user-switching.php\";s:11:\"new_version\";s:5:\"1.5.0\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/user-switching/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/user-switching.1.5.0.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:67:\"https://ps.w.org/user-switching/assets/icon-256x256.png?rev=2031882\";s:2:\"1x\";s:59:\"https://ps.w.org/user-switching/assets/icon.svg?rev=2032062\";s:3:\"svg\";s:59:\"https://ps.w.org/user-switching/assets/icon.svg?rev=2032062\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/user-switching/assets/banner-1544x500.png?rev=1364546\";s:2:\"1x\";s:69:\"https://ps.w.org/user-switching/assets/banner-772x250.png?rev=1216665\";}s:11:\"banners_rtl\";a:1:{s:2:\"2x\";s:74:\"https://ps.w.org/user-switching/assets/banner-1544x500-rtl.png?rev=2032062\";}s:6:\"tested\";s:5:\"5.1.1\";s:12:\"requires_php\";s:3:\"5.3\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:41:\"wordpress-importer/wordpress-importer.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:32:\"w.org/plugins/wordpress-importer\";s:4:\"slug\";s:18:\"wordpress-importer\";s:6:\"plugin\";s:41:\"wordpress-importer/wordpress-importer.php\";s:11:\"new_version\";s:5:\"0.6.4\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/wordpress-importer/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/wordpress-importer.0.6.4.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:71:\"https://ps.w.org/wordpress-importer/assets/icon-256x256.png?rev=1908375\";s:2:\"1x\";s:63:\"https://ps.w.org/wordpress-importer/assets/icon.svg?rev=1908375\";s:3:\"svg\";s:63:\"https://ps.w.org/wordpress-importer/assets/icon.svg?rev=1908375\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:72:\"https://ps.w.org/wordpress-importer/assets/banner-772x250.png?rev=547654\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"4.9.7\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:31:\"wp-all-export/wp-all-export.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:27:\"w.org/plugins/wp-all-export\";s:4:\"slug\";s:13:\"wp-all-export\";s:6:\"plugin\";s:31:\"wp-all-export/wp-all-export.php\";s:11:\"new_version\";s:5:\"1.2.3\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wp-all-export/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/wp-all-export.1.2.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/wp-all-export/assets/icon-256x256.png?rev=1216907\";s:2:\"1x\";s:66:\"https://ps.w.org/wp-all-export/assets/icon-128x128.png?rev=1216907\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:67:\"https://ps.w.org/wp-all-export/assets/banner-772x250.png?rev=835969\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:3:\"5.1\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";O:8:\"stdClass\":0:{}}}s:12:\"translations\";a:2:{i:0;a:7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:18:\"speed-booster-pack\";s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"3.7.6\";s:7:\"updated\";s:19:\"2019-02-21 08:08:41\";s:7:\"package\";s:85:\"https://downloads.wordpress.org/translation/plugin/speed-booster-pack/3.7.6/es_ES.zip\";s:10:\"autoupdate\";b:1;}i:1;a:7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:14:\"user-switching\";s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.0.9\";s:7:\"updated\";s:19:\"2017-05-25 16:26:31\";s:7:\"package\";s:81:\"https://downloads.wordpress.org/translation/plugin/user-switching/1.0.9/es_ES.zip\";s:10:\"autoupdate\";b:1;}}s:9:\"no_update\";a:8:{s:23:\"bulkpress/bulkpress.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:23:\"w.org/plugins/bulkpress\";s:4:\"slug\";s:9:\"bulkpress\";s:6:\"plugin\";s:23:\"bulkpress/bulkpress.php\";s:11:\"new_version\";s:5:\"0.3.5\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/bulkpress/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/bulkpress.0.3.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:62:\"https://ps.w.org/bulkpress/assets/icon-256x256.png?rev=1514709\";s:2:\"1x\";s:62:\"https://ps.w.org/bulkpress/assets/icon-128x128.png?rev=1514709\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:63:\"https://ps.w.org/bulkpress/assets/banner-772x250.jpg?rev=788147\";}s:11:\"banners_rtl\";a:0:{}}s:37:\"bulkpress-export/bulkpress-export.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:30:\"w.org/plugins/bulkpress-export\";s:4:\"slug\";s:16:\"bulkpress-export\";s:6:\"plugin\";s:37:\"bulkpress-export/bulkpress-export.php\";s:11:\"new_version\";s:3:\"0.1\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/bulkpress-export/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/bulkpress-export.0.1.zip\";s:5:\"icons\";a:1:{s:7:\"default\";s:60:\"https://s.w.org/plugins/geopattern-icon/bulkpress-export.svg\";}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}}s:49:\"cimy-user-extra-fields/cimy_user_extra_fields.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:36:\"w.org/plugins/cimy-user-extra-fields\";s:4:\"slug\";s:22:\"cimy-user-extra-fields\";s:6:\"plugin\";s:49:\"cimy-user-extra-fields/cimy_user_extra_fields.php\";s:11:\"new_version\";s:5:\"2.7.2\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/cimy-user-extra-fields/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/cimy-user-extra-fields.2.7.2.zip\";s:5:\"icons\";a:1:{s:7:\"default\";s:73:\"https://s.w.org/plugins/geopattern-icon/cimy-user-extra-fields_dae8f3.svg\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:76:\"https://ps.w.org/cimy-user-extra-fields/assets/banner-772x250.png?rev=751299\";}s:11:\"banners_rtl\";a:0:{}}s:55:\"confirm-user-registration/confirm-user-registration.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:39:\"w.org/plugins/confirm-user-registration\";s:4:\"slug\";s:25:\"confirm-user-registration\";s:6:\"plugin\";s:55:\"confirm-user-registration/confirm-user-registration.php\";s:11:\"new_version\";s:5:\"2.1.5\";s:3:\"url\";s:56:\"https://wordpress.org/plugins/confirm-user-registration/\";s:7:\"package\";s:74:\"https://downloads.wordpress.org/plugin/confirm-user-registration.2.1.5.zip\";s:5:\"icons\";a:1:{s:7:\"default\";s:76:\"https://s.w.org/plugins/geopattern-icon/confirm-user-registration_a0a5a6.svg\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:79:\"https://ps.w.org/confirm-user-registration/assets/banner-772x250.jpg?rev=564142\";}s:11:\"banners_rtl\";a:0:{}}s:35:\"infinite-scroll/infinite-scroll.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:29:\"w.org/plugins/infinite-scroll\";s:4:\"slug\";s:15:\"infinite-scroll\";s:6:\"plugin\";s:35:\"infinite-scroll/infinite-scroll.php\";s:11:\"new_version\";s:5:\"2.6.2\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/infinite-scroll/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/infinite-scroll.2.6.2.zip\";s:5:\"icons\";a:1:{s:7:\"default\";s:59:\"https://s.w.org/plugins/geopattern-icon/infinite-scroll.svg\";}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}}s:21:\"json-api/json-api.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:22:\"w.org/plugins/json-api\";s:4:\"slug\";s:8:\"json-api\";s:6:\"plugin\";s:21:\"json-api/json-api.php\";s:11:\"new_version\";s:5:\"1.1.1\";s:3:\"url\";s:39:\"https://wordpress.org/plugins/json-api/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/json-api.1.1.3.zip\";s:5:\"icons\";a:1:{s:7:\"default\";s:52:\"https://s.w.org/plugins/geopattern-icon/json-api.svg\";}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}}s:48:\"welcome-email-editor/sb_welcome_email_editor.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:34:\"w.org/plugins/welcome-email-editor\";s:4:\"slug\";s:20:\"welcome-email-editor\";s:6:\"plugin\";s:48:\"welcome-email-editor/sb_welcome_email_editor.php\";s:11:\"new_version\";s:5:\"4.9.1\";s:3:\"url\";s:51:\"https://wordpress.org/plugins/welcome-email-editor/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/welcome-email-editor.zip\";s:5:\"icons\";a:1:{s:7:\"default\";s:64:\"https://s.w.org/plugins/geopattern-icon/welcome-email-editor.svg\";}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.0.1\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";a:0:{}}s:35:\"taxonomy-widget/taxonomy-widget.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:29:\"w.org/plugins/taxonomy-widget\";s:4:\"slug\";s:15:\"taxonomy-widget\";s:6:\"plugin\";s:35:\"taxonomy-widget/taxonomy-widget.php\";s:11:\"new_version\";s:5:\"0.6.1\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/taxonomy-widget/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/taxonomy-widget.zip\";s:5:\"icons\";a:1:{s:7:\"default\";s:59:\"https://s.w.org/plugins/geopattern-icon/taxonomy-widget.svg\";}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}}}}", "no");
INSERT INTO `wp_options` VALUES("11415", "_site_transient_timeout_theme_roots", "1555317686", "no");
INSERT INTO `wp_options` VALUES("11416", "_site_transient_theme_roots", "a:6:{s:18:\"ainia_bloggr_child\";s:7:\"/themes\";s:27:\"ainia_bloggr_child_ecoembes\";s:7:\"/themes\";s:6:\"bloggr\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";s:15:\"twentyseventeen\";s:7:\"/themes\";s:13:\"twentysixteen\";s:7:\"/themes\";}", "no");
INSERT INTO `wp_options` VALUES("11428", "_transient_doing_cron", "1558431396.0424399375915527343750", "yes");
INSERT INTO `wp_options` VALUES("11433", "_site_transient_timeout_browser_127868b9556d0b73282ae4585eb3c66a", "1556016404", "no");
INSERT INTO `wp_options` VALUES("11434", "_site_transient_browser_127868b9556d0b73282ae4585eb3c66a", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"73.0.3683.103\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("11435", "_site_transient_timeout_browser_183df7713c418778ae3b1715c697443c", "1556023850", "no");
INSERT INTO `wp_options` VALUES("11436", "_site_transient_browser_183df7713c418778ae3b1715c697443c", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"73.0.3683.103\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("11592", "duplicator_ui_view_state", "a:2:{s:22:\"dup-pack-storage-panel\";s:1:\"1\";s:22:\"dup-pack-archive-panel\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("11593", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2019-05-21 09:36:23\";s:7:\"Version\";s:6:\"1.1.34\";s:9:\"VersionWP\";s:5:\"4.7.4\";s:9:\"VersionDB\";s:6:\"5.7.17\";s:10:\"VersionPHP\";s:5:\"7.1.5\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:22:\"20190506_ainiaiwatch40\";s:4:\"Hash\";s:29:\"5ce3c6976bab59571190521093623\";s:8:\"NameHash\";s:52:\"20190506_ainiaiwatch40_5ce3c6976bab59571190521093623\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:71:\"C:/Program Files (x86)/Apache24/htdocs/iwatch/ecoembes/wp-snapshots/tmp\";s:8:\"StoreURL\";s:50:\"http://www.observatoriodelenvase.com/wp-snapshots/\";s:8:\"ScanFile\";s:62:\"20190506_ainiaiwatch40_5ce3c6976bab59571190521093623_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:54:\"C:/Program Files (x86)/Apache24/htdocs/iwatch/ecoembes\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2019-05-21 09:36:23\";s:7:\"Version\";s:6:\"1.1.34\";s:9:\"VersionWP\";s:5:\"4.7.4\";s:9:\"VersionDB\";s:6:\"5.7.17\";s:10:\"VersionPHP\";s:5:\"7.1.5\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:22:\"20190506_ainiaiwatch40\";s:4:\"Hash\";s:29:\"5ce3c6976bab59571190521093623\";s:8:\"NameHash\";s:52:\"20190506_ainiaiwatch40_5ce3c6976bab59571190521093623\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:71:\"C:/Program Files (x86)/Apache24/htdocs/iwatch/ecoembes/wp-snapshots/tmp\";s:8:\"StoreURL\";s:50:\"http://www.observatoriodelenvase.com/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:52;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:13:\"wp_user_terms\";s:8:\"FilterOn\";i:1;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:52;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:9:\"Installer\";r:74;s:8:\"Database\";r:87;}", "yes");
INSERT INTO `wp_options` VALUES("11690", "_site_transient_timeout_browser_53ad83e7ffe60968becca0ade7b723b5", "1558615656", "no");
INSERT INTO `wp_options` VALUES("11691", "_site_transient_browser_53ad83e7ffe60968becca0ade7b723b5", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"74.0.3729.131\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("11713", "_site_transient_timeout_browser_7633b6fff3875069843b1efa82426ca5", "1558938515", "no");
INSERT INTO `wp_options` VALUES("11714", "_site_transient_browser_7633b6fff3875069843b1efa82426ca5", "a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"66.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:24:\"https://www.firefox.com/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("11717", "_transient_timeout_infinite_scroll_presets", "1558506086", "no");
INSERT INTO `wp_options` VALUES("11718", "_transient_infinite_scroll_presets", "a:28:{s:0:\"\";O:8:\"stdClass\":5:{s:5:\"theme\";N;s:15:\"contentSelector\";N;s:11:\"navSelector\";N;s:12:\"itemSelector\";N;s:12:\"nextSelector\";N;}s:6:\"Avenue\";O:8:\"stdClass\":5:{s:5:\"theme\";s:6:\"Avenue\";s:15:\"contentSelector\";s:14:\"#main .archive\";s:11:\"navSelector\";s:11:\".pagination\";s:12:\"itemSelector\";s:20:\"#main .archive .post\";s:12:\"nextSelector\";s:32:\".pagination .current + .inactive\";}s:6:\"Gaming\";O:8:\"stdClass\":5:{s:5:\"theme\";s:6:\"Gaming\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:10:\"#nav-below\";s:12:\"itemSelector\";s:5:\".post\";s:12:\"nextSelector\";s:18:\"#nav-below a:first\";}s:9:\"atahualpa\";O:8:\"stdClass\":5:{s:5:\"theme\";s:9:\"atahualpa\";s:15:\"contentSelector\";s:9:\"td#middle\";s:11:\"navSelector\";s:21:\"div.navigation-bottom\";s:12:\"itemSelector\";s:18:\"td#middle div.post\";s:12:\"nextSelector\";s:16:\"div.newer a:link\";}s:6:\"befree\";O:8:\"stdClass\":5:{s:5:\"theme\";s:6:\"befree\";s:15:\"contentSelector\";s:14:\"#main.col-left\";s:11:\"navSelector\";s:12:\".nav-entries\";s:12:\"itemSelector\";s:19:\".border-post-second\";s:12:\"nextSelector\";s:14:\".nav-entries a\";}s:8:\"cleanmag\";O:8:\"stdClass\":5:{s:5:\"theme\";s:8:\"cleanmag\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:10:\"#nav-below\";s:12:\"itemSelector\";s:5:\".post\";s:12:\"nextSelector\";s:18:\"#nav-below a:first\";}s:9:\"extranews\";O:8:\"stdClass\":5:{s:5:\"theme\";s:9:\"extranews\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:14:\"div.navigation\";s:12:\"itemSelector\";s:17:\"#content div.post\";s:12:\"nextSelector\";s:22:\"div.navigation a:first\";}s:9:\"glassical\";O:8:\"stdClass\":5:{s:5:\"theme\";s:9:\"glassical\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:12:\"#wp_pagenavi\";s:12:\"itemSelector\";s:5:\".post\";s:12:\"nextSelector\";s:18:\"#wp_pagenavi:first\";}s:5:\"gonzo\";O:8:\"stdClass\":5:{s:5:\"theme\";s:5:\"gonzo\";s:15:\"contentSelector\";s:9:\"#omc-main\";s:11:\"navSelector\";s:11:\".pagination\";s:12:\"itemSelector\";s:9:\"#omc-main\";s:12:\"nextSelector\";s:21:\".pagination .inactive\";}s:10:\"gridlocked\";O:8:\"stdClass\":5:{s:5:\"theme\";s:10:\"gridlocked\";s:15:\"contentSelector\";s:8:\"#primary\";s:11:\"navSelector\";s:17:\"#index-navigation\";s:12:\"itemSelector\";s:16:\"#content .hentry\";s:12:\"nextSelector\";s:35:\"#index-navigation .nav-next a:first\";}s:2:\"h5\";O:8:\"stdClass\":5:{s:5:\"theme\";s:2:\"h5\";s:15:\"contentSelector\";s:9:\"#masonary\";s:11:\"navSelector\";s:12:\".wp-pagenavi\";s:12:\"itemSelector\";s:4:\".box\";s:12:\"nextSelector\";s:27:\".wp-pagenavi .nextpostslink\";}s:5:\"inove\";O:8:\"stdClass\":5:{s:5:\"theme\";s:5:\"inove\";s:15:\"contentSelector\";s:5:\"#main\";s:11:\"navSelector\";s:14:\"#main div.post\";s:12:\"itemSelector\";s:9:\"#pagenavi\";s:12:\"nextSelector\";s:28:\"#pagenavi span.older a:first\";}s:6:\"launch\";O:8:\"stdClass\":5:{s:5:\"theme\";s:6:\"launch\";s:15:\"contentSelector\";s:14:\"#primary.hfeed\";s:11:\"navSelector\";s:14:\"div.navigation\";s:12:\"itemSelector\";s:5:\".post\";s:12:\"nextSelector\";s:11:\".nav-next a\";}s:9:\"litepress\";O:8:\"stdClass\":5:{s:5:\"theme\";s:9:\"litepress\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:11:\".navigation\";s:12:\"itemSelector\";s:12:\".recent-post\";s:12:\"nextSelector\";s:17:\".navigation .next\";}s:8:\"mockfive\";O:8:\"stdClass\":5:{s:5:\"theme\";s:8:\"mockfive\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:14:\"div.navigation\";s:12:\"itemSelector\";s:17:\"#content div.post\";s:12:\"nextSelector\";s:22:\"div.navigation a:first\";}s:9:\"pagelines\";O:8:\"stdClass\":5:{s:5:\"theme\";s:9:\"pagelines\";s:15:\"contentSelector\";s:9:\"#postloop\";s:11:\"navSelector\";s:11:\"#pagination\";s:12:\"itemSelector\";s:27:\"#postloop .copy-pad article\";s:12:\"nextSelector\";s:65:\"#pagination .copy-pad .page-nav-default .previous-entries a:first\";}s:9:\"picolight\";O:8:\"stdClass\":5:{s:5:\"theme\";s:9:\"picolight\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:14:\"div.navigation\";s:12:\"itemSelector\";s:5:\".post\";s:12:\"nextSelector\";s:30:\"div.navigation div.alignleft a\";}s:8:\"platform\";O:8:\"stdClass\":5:{s:5:\"theme\";s:8:\"platform\";s:15:\"contentSelector\";s:18:\"#pagelines_content\";s:11:\"navSelector\";s:36:\"#pagelines_content .page-nav-default\";s:12:\"itemSelector\";s:5:\".post\";s:12:\"nextSelector\";s:38:\"#pagelines_content .page-nav-default a\";}s:6:\"rustik\";O:8:\"stdClass\":5:{s:5:\"theme\";s:6:\"rustik\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:10:\"#nav-below\";s:12:\"itemSelector\";s:5:\".post\";s:12:\"nextSelector\";s:18:\"#nav-below a:first\";}s:19:\"shaken-grid-premium\";O:8:\"stdClass\":5:{s:5:\"theme\";s:19:\"shaken-grid-premium\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:10:\"#nav-below\";s:12:\"itemSelector\";s:5:\".post\";s:12:\"nextSelector\";s:18:\"#nav-below a:first\";}s:5:\"swift\";O:8:\"stdClass\":5:{s:5:\"theme\";s:5:\"swift\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:14:\"div.navigation\";s:12:\"itemSelector\";s:8:\"#content\";s:12:\"nextSelector\";s:22:\"div.navigation a:first\";}s:8:\"thematic\";O:8:\"stdClass\":5:{s:5:\"theme\";s:8:\"thematic\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:12:\"footer.below\";s:12:\"itemSelector\";s:12:\"article.post\";s:12:\"nextSelector\";s:15:\"a.nextpostslink\";}s:12:\"twentyeleven\";O:8:\"stdClass\":5:{s:5:\"theme\";s:12:\"twentyeleven\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:10:\"#nav-below\";s:12:\"itemSelector\";s:21:\"#content article.post\";s:12:\"nextSelector\";s:32:\"#nav-below .nav-previous a:first\";}s:9:\"twentyten\";O:8:\"stdClass\":5:{s:5:\"theme\";s:9:\"twentyten\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:14:\"div.navigation\";s:12:\"itemSelector\";s:18:\"#content  div.post\";s:12:\"nextSelector\";s:22:\"div.navigation a:first\";}s:14:\"twentythirteen\";O:8:\"stdClass\":5:{s:5:\"theme\";s:14:\"twentythirteen\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:10:\"#nav-below\";s:12:\"itemSelector\";s:5:\".post\";s:12:\"nextSelector\";s:18:\"#nav-below a:first\";}s:12:\"twentytwelve\";O:8:\"stdClass\":5:{s:5:\"theme\";s:12:\"twentytwelve\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:12:\"#content nav\";s:12:\"itemSelector\";s:7:\".hentry\";s:12:\"nextSelector\";s:14:\"#content nav a\";}s:13:\"weaver-ii-pro\";O:8:\"stdClass\":5:{s:5:\"theme\";s:13:\"weaver-ii-pro\";s:15:\"contentSelector\";s:8:\"#content\";s:11:\"navSelector\";s:10:\"#nav-below\";s:12:\"itemSelector\";s:21:\"#content article.post\";s:12:\"nextSelector\";s:32:\"#nav-below .nav-previous a:first\";}s:4:\"wiki\";O:8:\"stdClass\":5:{s:5:\"theme\";s:4:\"wiki\";s:15:\"contentSelector\";s:8:\".content\";s:11:\"navSelector\";s:11:\".pagination\";s:12:\"itemSelector\";s:5:\".post\";s:12:\"nextSelector\";s:5:\".next\";}}", "no");
INSERT INTO `wp_options` VALUES("11719", "_transient_is_multi_author", "1", "yes");
INSERT INTO `wp_options` VALUES("11720", "_transient_bloggr_categories", "2", "yes");
INSERT INTO `wp_options` VALUES("11721", "_site_transient_timeout_browser_cd1f678cd3032e73518e5a71fd683dc9", "1559036143", "no");
INSERT INTO `wp_options` VALUES("11722", "_site_transient_browser_cd1f678cd3032e73518e5a71fd683dc9", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"74.0.3729.157\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");

/* INSERT TABLE DATA: wp_pmxe_exports */
INSERT INTO `wp_pmxe_exports` VALUES("1", "0", "0", "a:76:{s:14:\"is_user_export\";b:0;s:17:\"is_comment_export\";b:0;s:18:\"is_taxonomy_export\";b:0;s:3:\"cpt\";a:1:{i:0;s:4:\"post\";}s:11:\"whereclause\";s:0:\"\";s:10:\"joinclause\";a:0:{}s:11:\"exportquery\";O:8:\"WP_Query\":53:{s:5:\"query\";a:5:{s:9:\"post_type\";a:1:{i:0;s:4:\"post\";}s:11:\"post_status\";s:3:\"any\";s:7:\"orderby\";s:2:\"ID\";s:5:\"order\";s:3:\"ASC\";s:14:\"posts_per_page\";i:10;}s:10:\"query_vars\";a:66:{s:9:\"post_type\";a:1:{i:0;s:4:\"post\";}s:11:\"post_status\";s:3:\"any\";s:7:\"orderby\";s:2:\"ID\";s:5:\"order\";s:3:\"ASC\";s:14:\"posts_per_page\";i:10;s:5:\"error\";s:0:\"\";s:1:\"m\";s:0:\"\";s:1:\"p\";i:0;s:11:\"post_parent\";s:0:\"\";s:7:\"subpost\";s:0:\"\";s:10:\"subpost_id\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:13:\"attachment_id\";i:0;s:4:\"name\";s:0:\"\";s:6:\"static\";s:0:\"\";s:8:\"pagename\";s:0:\"\";s:7:\"page_id\";i:0;s:6:\"second\";s:0:\"\";s:6:\"minute\";s:0:\"\";s:4:\"hour\";s:0:\"\";s:3:\"day\";i:0;s:8:\"monthnum\";i:0;s:4:\"year\";i:0;s:1:\"w\";i:0;s:13:\"category_name\";s:0:\"\";s:3:\"tag\";s:0:\"\";s:3:\"cat\";s:0:\"\";s:6:\"tag_id\";s:0:\"\";s:6:\"author\";s:0:\"\";s:11:\"author_name\";s:0:\"\";s:4:\"feed\";s:0:\"\";s:2:\"tb\";s:0:\"\";s:5:\"paged\";i:0;s:8:\"meta_key\";s:0:\"\";s:10:\"meta_value\";s:0:\"\";s:7:\"preview\";s:0:\"\";s:1:\"s\";s:0:\"\";s:8:\"sentence\";s:0:\"\";s:5:\"title\";s:0:\"\";s:6:\"fields\";s:0:\"\";s:10:\"menu_order\";s:0:\"\";s:5:\"embed\";s:0:\"\";s:12:\"category__in\";a:0:{}s:16:\"category__not_in\";a:0:{}s:13:\"category__and\";a:0:{}s:8:\"post__in\";a:0:{}s:12:\"post__not_in\";a:0:{}s:13:\"post_name__in\";a:0:{}s:7:\"tag__in\";a:0:{}s:11:\"tag__not_in\";a:0:{}s:8:\"tag__and\";a:0:{}s:12:\"tag_slug__in\";a:0:{}s:13:\"tag_slug__and\";a:0:{}s:15:\"post_parent__in\";a:0:{}s:19:\"post_parent__not_in\";a:0:{}s:10:\"author__in\";a:0:{}s:14:\"author__not_in\";a:0:{}s:19:\"ignore_sticky_posts\";b:0;s:16:\"suppress_filters\";b:0;s:13:\"cache_results\";b:1;s:22:\"update_post_term_cache\";b:1;s:19:\"lazy_load_term_meta\";b:1;s:22:\"update_post_meta_cache\";b:1;s:8:\"nopaging\";b:0;s:17:\"comments_per_page\";s:2:\"50\";s:13:\"no_found_rows\";b:0;}s:9:\"tax_query\";O:12:\"WP_Tax_Query\":6:{s:7:\"queries\";a:0:{}s:8:\"relation\";s:3:\"AND\";s:16:\"\0*\0table_aliases\";a:0:{}s:13:\"queried_terms\";a:0:{}s:13:\"primary_table\";s:8:\"wp_posts\";s:17:\"primary_id_column\";s:2:\"ID\";}s:10:\"meta_query\";O:13:\"WP_Meta_Query\":9:{s:7:\"queries\";a:0:{}s:8:\"relation\";N;s:10:\"meta_table\";N;s:14:\"meta_id_column\";N;s:13:\"primary_table\";N;s:17:\"primary_id_column\";N;s:16:\"\0*\0table_aliases\";a:0:{}s:10:\"\0*\0clauses\";a:0:{}s:18:\"\0*\0has_or_relation\";b:0;}s:10:\"date_query\";b:0;s:14:\"queried_object\";N;s:17:\"queried_object_id\";N;s:7:\"request\";s:216:\"SELECT SQL_CALC_FOUND_ROWS  wp_posts.ID FROM wp_posts  WHERE 1=1  AND wp_posts.post_type = \'post\' AND ((wp_posts.post_status <> \'trash\' AND wp_posts.post_status <> \'auto-draft\'))  ORDER BY wp_posts.ID ASC LIMIT 0, 10\";s:5:\"posts\";a:10:{i:0;O:7:\"WP_Post\":24:{s:2:\"ID\";i:8;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2017-02-14 02:18:31\";s:13:\"post_date_gmt\";s:19:\"2017-02-14 08:18:31\";s:12:\"post_content\";s:98:\"Bienvenido a WordPress. Esta es tu primera entrada. Edítala o bórrala, ¡y comienza a publicar!.\";s:10:\"post_title\";s:13:\"¡Hola mundo!\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:5:\"draft\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:4:\"open\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:12:\"hola-mundo-2\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2017-03-27 11:18:39\";s:17:\"post_modified_gmt\";s:19:\"2017-03-27 17:18:39\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:40:\"http://localhost/iwatch40/iwatch4.0/?p=1\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:4:\"post\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"0\";s:6:\"filter\";s:3:\"raw\";}i:1;O:7:\"WP_Post\":24:{s:2:\"ID\";i:21;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2017-02-23 03:19:34\";s:13:\"post_date_gmt\";s:19:\"2017-02-23 09:19:34\";s:12:\"post_content\";s:217:\"REsumen de la entrada kdlñfkfpd ñoifdipoei oooooooo dofoipoadifpoif poiop REsumen de la entrada kdlñfkfpd ñoifdipoei oooooooo dofoipoadifpoif poiop lllfkodpifaorperiepoiproivopi p oir poirporipo poripo ipewirildj\";s:10:\"post_title\";s:20:\"Entrada 2 de pruebas\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:5:\"draft\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:4:\"open\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:20:\"entrada-2-de-pruebas\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2017-03-08 05:48:50\";s:17:\"post_modified_gmt\";s:19:\"2017-03-08 11:48:50\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:41:\"http://localhost/iwatch40/iwatch4.0/?p=21\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:4:\"post\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"0\";s:6:\"filter\";s:3:\"raw\";}i:2;O:7:\"WP_Post\":24:{s:2:\"ID\";i:24;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2017-02-23 03:22:30\";s:13:\"post_date_gmt\";s:19:\"2017-02-23 09:22:30\";s:12:\"post_content\";s:358:\"Texto descritivo de pruebas para la entrada 3 lkfdjieu iruioei erare  er tgrttrt hghshs Texto descritivo de pruebas para la entrada 3 lkfdjieu iruioei erare  er tgrttrt hghshs Texto descritivo de pruebas para la entrada 3 lkfdjieu iruioei erare  er tgrttrt hghshs Texto descritivo de pruebas para la entrada 3 lkfdjieu iruioei erare  er tgrttrt hghshs\";s:10:\"post_title\";s:19:\"Entrada 3 de prueba\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:5:\"draft\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:4:\"open\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:19:\"entrada-3-de-prueba\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2017-03-08 05:48:49\";s:17:\"post_modified_gmt\";s:19:\"2017-03-08 11:48:49\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:41:\"http://localhost/iwatch40/iwatch4.0/?p=24\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:4:\"post\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"0\";s:6:\"filter\";s:3:\"raw\";}i:3;O:7:\"WP_Post\":24:{s:2:\"ID\";i:58;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2017-02-27 04:50:39\";s:13:\"post_date_gmt\";s:19:\"2017-02-27 10:50:39\";s:12:\"post_content\";s:453:\"Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede\";s:10:\"post_title\";s:19:\"Entrada 4 de prueba\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:5:\"draft\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:4:\"open\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:19:\"entrada-4-de-prueba\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2017-03-08 05:48:49\";s:17:\"post_modified_gmt\";s:19:\"2017-03-08 11:48:49\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:41:\"http://localhost/iwatch40/iwatch4.0/?p=58\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:4:\"post\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"0\";s:6:\"filter\";s:3:\"raw\";}i:4;O:7:\"WP_Post\":24:{s:2:\"ID\";i:60;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2017-02-27 04:51:31\";s:13:\"post_date_gmt\";s:19:\"2017-02-27 10:51:31\";s:12:\"post_content\";s:453:\"Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede\";s:10:\"post_title\";s:19:\"Entrada de prueba 5\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:5:\"draft\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:4:\"open\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:19:\"entrada-de-prueba-5\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2017-03-08 05:48:49\";s:17:\"post_modified_gmt\";s:19:\"2017-03-08 11:48:49\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:41:\"http://localhost/iwatch40/iwatch4.0/?p=60\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:4:\"post\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"0\";s:6:\"filter\";s:3:\"raw\";}i:5;O:7:\"WP_Post\":24:{s:2:\"ID\";i:62;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2017-02-27 04:51:57\";s:13:\"post_date_gmt\";s:19:\"2017-02-27 10:51:57\";s:12:\"post_content\";s:453:\"Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede\";s:10:\"post_title\";s:19:\"Entrada de prueba 6\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:5:\"draft\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:4:\"open\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:19:\"entrada-de-prueba-6\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2017-03-08 05:48:49\";s:17:\"post_modified_gmt\";s:19:\"2017-03-08 11:48:49\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:41:\"http://localhost/iwatch40/iwatch4.0/?p=62\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:4:\"post\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"0\";s:6:\"filter\";s:3:\"raw\";}i:6;O:7:\"WP_Post\":24:{s:2:\"ID\";i:64;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2017-02-27 04:52:18\";s:13:\"post_date_gmt\";s:19:\"2017-02-27 10:52:18\";s:12:\"post_content\";s:453:\"Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede\";s:10:\"post_title\";s:19:\"Entrada de prueba 7\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:5:\"draft\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:4:\"open\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:19:\"entrada-de-prueba-7\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2017-03-08 05:48:49\";s:17:\"post_modified_gmt\";s:19:\"2017-03-08 11:48:49\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:41:\"http://localhost/iwatch40/iwatch4.0/?p=64\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:4:\"post\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"0\";s:6:\"filter\";s:3:\"raw\";}i:7;O:7:\"WP_Post\":24:{s:2:\"ID\";i:74;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2017-02-02 07:28:09\";s:13:\"post_date_gmt\";s:19:\"2017-02-02 13:28:09\";s:12:\"post_content\";s:240:\"Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu\";s:10:\"post_title\";s:49:\"Donec quam felis, ultricies nec, pellentesque eu.\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:5:\"draft\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:4:\"open\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:46:\"donec-quam-felis-ultricies-nec-pellentesque-eu\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2017-03-27 11:18:51\";s:17:\"post_modified_gmt\";s:19:\"2017-03-27 17:18:51\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:41:\"http://localhost/iwatch40/iwatch4.0/?p=74\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:4:\"post\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"0\";s:6:\"filter\";s:3:\"raw\";}i:8;O:7:\"WP_Post\":24:{s:2:\"ID\";i:77;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2017-03-02 08:12:30\";s:13:\"post_date_gmt\";s:19:\"2017-03-02 14:12:30\";s:12:\"post_content\";s:295:\"Al comprar una bolsa de verduras congeladas es difícil imaginarse el rápido viaje que han hecho estos alimentos hasta llegar al congelador. Como todas las verduras, se cogen de la huerta en su temporada de recolección, es decir, cuando están en su mejor momento de consumo, con todo su sabor\";s:10:\"post_title\";s:68:\"Calendario de verduras: ¿cuál es el mejor momento para recogerlas?\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:7:\"publish\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:4:\"open\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:63:\"calendario-de-verduras-cual-es-el-mejor-momento-para-recogerlas\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2017-03-27 11:17:48\";s:17:\"post_modified_gmt\";s:19:\"2017-03-27 17:17:48\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:41:\"http://localhost/iwatch40/iwatch4.0/?p=77\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:4:\"post\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"0\";s:6:\"filter\";s:3:\"raw\";}i:9;O:7:\"WP_Post\":24:{s:2:\"ID\";i:23598;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2017-03-27 15:43:27\";s:13:\"post_date_gmt\";s:19:\"2017-03-27 15:43:27\";s:12:\"post_content\";s:202:\"Generations Y and Z are still markedly more likely than their seniors to eat at big name fast food chains, though the rate they visit them is in slow decline perhaps due to the rise of hipster hangouts.\";s:10:\"post_title\";s:41:\"Australia s generations of fast food fans\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:7:\"publish\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:6:\"closed\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:41:\"australia-s-generations-of-fast-food-fans\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2017-03-27 15:43:27\";s:17:\"post_modified_gmt\";s:19:\"2017-03-27 15:43:27\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:54:\"http://www.iwatchfood.com:8085/camaravalencia/?p=23598\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:4:\"post\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"0\";s:6:\"filter\";s:3:\"raw\";}}s:10:\"post_count\";i:10;s:12:\"current_post\";i:-1;s:11:\"in_the_loop\";b:0;s:4:\"post\";r:107;s:8:\"comments\";N;s:13:\"comment_count\";i:0;s:15:\"current_comment\";i:-1;s:7:\"comment\";N;s:11:\"found_posts\";s:2:\"51\";s:13:\"max_num_pages\";d:6;s:21:\"max_num_comment_pages\";i:0;s:9:\"is_single\";b:0;s:10:\"is_preview\";b:0;s:7:\"is_page\";b:0;s:10:\"is_archive\";b:0;s:7:\"is_date\";b:0;s:7:\"is_year\";b:0;s:8:\"is_month\";b:0;s:6:\"is_day\";b:0;s:7:\"is_time\";b:0;s:9:\"is_author\";b:0;s:11:\"is_category\";b:0;s:6:\"is_tag\";b:0;s:6:\"is_tax\";b:0;s:9:\"is_search\";b:0;s:7:\"is_feed\";b:0;s:15:\"is_comment_feed\";b:0;s:12:\"is_trackback\";b:0;s:7:\"is_home\";b:0;s:6:\"is_404\";b:0;s:8:\"is_embed\";b:0;s:8:\"is_paged\";b:0;s:8:\"is_admin\";b:1;s:13:\"is_attachment\";b:0;s:11:\"is_singular\";b:0;s:9:\"is_robots\";b:0;s:13:\"is_posts_page\";b:0;s:20:\"is_post_type_archive\";b:0;s:25:\"\0WP_Query\0query_vars_hash\";s:32:\"d8ec62dcc0e5fd4bb0ff1d64ba1196e2\";s:28:\"\0WP_Query\0query_vars_changed\";b:0;s:17:\"thumbnails_cached\";b:0;s:19:\"\0WP_Query\0stopwords\";N;s:23:\"\0WP_Query\0compat_fields\";a:2:{i:0;s:15:\"query_vars_hash\";i:1;s:18:\"query_vars_changed\";}s:24:\"\0WP_Query\0compat_methods\";a:2:{i:0;s:16:\"init_query_flags\";i:1;s:15:\"parse_tax_query\";}}s:11:\"export_type\";s:8:\"specific\";s:21:\"filter_rules_hierarhy\";s:2:\"[]\";s:21:\"product_matching_mode\";s:6:\"strict\";s:17:\"wp_query_selector\";s:8:\"wp_query\";s:18:\"taxonomy_to_export\";s:0:\"\";s:18:\"created_at_version\";s:5:\"1.1.1\";s:18:\"is_loaded_template\";s:0:\"\";s:18:\"order_item_per_row\";i:1;s:29:\"order_item_fill_empty_columns\";i:1;s:8:\"filepath\";s:94:\"\\wpallexport\\exports\\5fe592e0f89da6cbd482a13ebaf503e8\\Entradas-Export-2017-March-28-0648-1.csv\";s:16:\"current_filepath\";s:175:\"C:/Program Files (x86)/Apache24/htdocs/iwatch/ecoembes/wp-content/uploads\\wpallexport\\exports\\5fe592e0f89da6cbd482a13ebaf503e8\\current-Entradas-Export-2017-March-28-0648-1.csv\";s:10:\"bundlepath\";s:92:\"\\wpallexport\\exports\\5fe592e0f89da6cbd482a13ebaf503e8\\Entradas-Export-2017-March-28-0648.zip\";s:8:\"wp_query\";s:0:\"\";s:9:\"export_to\";s:3:\"csv\";s:15:\"export_to_sheet\";s:3:\"csv\";s:9:\"delimiter\";s:1:\",\";s:8:\"encoding\";s:5:\"UTF-8\";s:21:\"is_generate_templates\";i:1;s:18:\"is_generate_import\";i:1;s:9:\"import_id\";i:0;s:13:\"template_name\";s:37:\"Entradas Export - 2017 March 28 06:48\";s:12:\"is_scheduled\";i:0;s:16:\"scheduled_period\";s:0:\"\";s:15:\"scheduled_email\";s:0:\"\";s:8:\"cc_label\";a:4:{i:0;s:2:\"id\";i:1;s:5:\"title\";i:2;s:7:\"content\";i:3;s:0:\"\";}s:7:\"cc_type\";a:4:{i:0;s:2:\"id\";i:1;s:5:\"title\";i:2;s:7:\"content\";i:3;s:0:\"\";}s:8:\"cc_value\";a:4:{i:0;s:2:\"id\";i:1;s:5:\"title\";i:2;s:7:\"content\";i:3;s:0:\"\";}s:7:\"cc_name\";a:4:{i:0;s:2:\"id\";i:1;s:5:\"Title\";i:2;s:7:\"Content\";i:3;s:0:\"\";}s:6:\"cc_php\";a:4:{i:0;s:1:\"0\";i:1;s:1:\"0\";i:2;s:1:\"0\";i:3;s:1:\"0\";}s:7:\"cc_code\";a:4:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";}s:6:\"cc_sql\";a:4:{i:0;s:1:\"0\";i:1;s:1:\"0\";i:2;s:1:\"0\";i:3;s:1:\"0\";}s:10:\"cc_options\";a:4:{i:0;s:1:\"0\";i:1;s:1:\"0\";i:2;s:1:\"0\";i:3;s:1:\"0\";}s:11:\"cc_settings\";a:4:{i:0;s:1:\"0\";i:1;s:1:\"0\";i:2;s:1:\"0\";i:3;s:1:\"0\";}s:13:\"friendly_name\";s:37:\"Entradas Export - 2017 March 28 06:48\";s:6:\"fields\";a:4:{i:0;s:7:\"default\";i:1;s:5:\"other\";i:2;s:2:\"cf\";i:3;s:4:\"cats\";}s:3:\"ids\";a:4:{i:0;s:1:\"1\";i:1;s:1:\"1\";i:2;s:1:\"1\";i:3;s:1:\"1\";}s:5:\"rules\";a:0:{}s:21:\"records_per_iteration\";s:2:\"50\";s:11:\"include_bom\";s:1:\"0\";s:17:\"include_functions\";i:1;s:19:\"split_large_exports\";s:1:\"0\";s:25:\"split_large_exports_count\";s:5:\"10000\";s:16:\"split_files_list\";a:0:{}s:12:\"main_xml_tag\";s:4:\"data\";s:14:\"record_xml_tag\";s:4:\"post\";s:16:\"save_template_as\";s:1:\"0\";s:4:\"name\";s:0:\"\";s:21:\"export_only_new_stuff\";s:1:\"0\";s:24:\"creata_a_new_export_file\";s:1:\"1\";s:15:\"attachment_list\";a:0:{}s:21:\"order_include_poducts\";i:0;s:25:\"order_include_all_poducts\";i:0;s:21:\"order_include_coupons\";i:0;s:25:\"order_include_all_coupons\";i:0;s:23:\"order_include_customers\";i:0;s:27:\"order_include_all_customers\";i:0;s:9:\"migration\";s:0:\"\";s:17:\"xml_template_type\";s:6:\"simple\";s:19:\"custom_xml_template\";s:118:\"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<data>\r\n	<!-- BEGIN LOOP -->\r\n	<post>\r\n\r\n	</post>\r\n	<!-- END LOOP -->\r\n</data>\";s:26:\"custom_xml_template_header\";s:0:\"\";s:24:\"custom_xml_template_loop\";s:0:\"\";s:26:\"custom_xml_template_footer\";s:0:\"\";s:27:\"custom_xml_template_options\";a:0:{}s:22:\"custom_xml_cdata_logic\";s:4:\"auto\";s:17:\"export_variations\";s:1:\"2\";s:23:\"export_variations_title\";s:1:\"1\";s:21:\"show_cdata_in_preview\";s:1:\"0\";s:4:\"file\";s:0:\"\";s:8:\"tpl_data\";a:5:{s:4:\"name\";s:37:\"Entradas Export - 2017 March 28 06:48\";s:18:\"is_keep_linebreaks\";i:1;s:13:\"is_leave_html\";i:0;s:14:\"fix_characters\";i:0;s:7:\"options\";a:46:{s:4:\"type\";s:4:\"post\";s:11:\"wizard_type\";s:3:\"new\";s:8:\"deligate\";s:11:\"wpallexport\";s:11:\"custom_type\";s:4:\"post\";s:6:\"status\";s:5:\"xpath\";s:23:\"is_multiple_page_parent\";s:2:\"no\";s:10:\"unique_key\";s:7:\"{id[1]}\";s:3:\"acf\";a:0:{}s:6:\"fields\";a:0:{}s:23:\"is_multiple_field_value\";a:0:{}s:14:\"multiple_value\";a:0:{}s:16:\"fields_delimiter\";a:0:{}s:15:\"update_all_data\";s:3:\"yes\";s:16:\"is_update_status\";i:1;s:15:\"is_update_title\";i:1;s:16:\"is_update_author\";i:1;s:14:\"is_update_slug\";i:1;s:17:\"is_update_content\";i:1;s:17:\"is_update_excerpt\";i:1;s:15:\"is_update_dates\";i:1;s:20:\"is_update_menu_order\";i:1;s:16:\"is_update_parent\";i:1;s:21:\"is_update_attachments\";i:1;s:13:\"is_update_acf\";i:1;s:16:\"update_acf_logic\";s:11:\"full_update\";s:8:\"acf_list\";s:0:\"\";s:22:\"is_update_product_type\";i:1;s:20:\"is_update_attributes\";i:1;s:23:\"update_attributes_logic\";s:11:\"full_update\";s:15:\"attributes_list\";s:0:\"\";s:16:\"is_update_images\";i:1;s:23:\"is_update_custom_fields\";i:1;s:26:\"update_custom_fields_logic\";s:11:\"full_update\";s:18:\"custom_fields_list\";s:0:\"\";s:20:\"is_update_categories\";i:1;s:23:\"update_categories_logic\";s:11:\"full_update\";s:15:\"taxonomies_list\";s:0:\"\";s:9:\"export_id\";s:1:\"1\";s:14:\"tmp_unique_key\";s:7:\"{id[1]}\";s:17:\"single_product_id\";s:7:\"{id[1]}\";s:5:\"title\";s:10:\"{title[1]}\";s:36:\"single_product_id_first_is_variation\";s:10:\"{title[1]}\";s:7:\"content\";s:12:\"{content[1]}\";s:16:\"required_add_ons\";a:0:{}s:9:\"delimiter\";s:1:\",\";s:12:\"root_element\";s:4:\"node\";}}}", "", "2017-03-28 06:48:10", "Entradas Export - 2017 March 28 06:48", "51", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "2017-03-28 06:48:14", "0", "0", "0", "1", "");

/* INSERT TABLE DATA: wp_pmxe_posts */
INSERT INTO `wp_pmxe_posts` VALUES("1", "8", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("2", "21", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("3", "24", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("4", "58", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("5", "60", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("6", "62", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("7", "64", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("8", "74", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("9", "77", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("10", "23598", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("11", "23602", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("12", "23603", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("13", "23605", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("14", "23613", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("15", "23614", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("16", "43435", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("17", "43680", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("18", "43689", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("19", "43690", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("20", "43691", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("21", "43692", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("22", "43693", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("23", "43694", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("24", "43695", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("25", "43696", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("26", "43697", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("27", "43698", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("28", "43699", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("29", "43700", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("30", "43701", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("31", "43703", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("32", "43704", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("33", "43705", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("34", "43706", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("35", "43707", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("36", "43708", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("37", "43709", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("38", "43710", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("39", "43711", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("40", "43712", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("41", "43713", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("42", "43714", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("43", "43715", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("44", "43716", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("45", "43717", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("46", "43718", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("47", "43719", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("48", "43720", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("49", "43721", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("50", "43722", "1", "0");
INSERT INTO `wp_pmxe_posts` VALUES("51", "43763", "1", "0");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("2", "4", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3", "4", "_edit_lock", "1488876635:1");
INSERT INTO `wp_postmeta` VALUES("63", "95", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("64", "95", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("70", "49", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("71", "49", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("72", "53", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("73", "53", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("74", "55", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("75", "55", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("76", "83", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("77", "83", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("78", "96", "_wp_attached_file", "2017/03/logo-1.png");
INSERT INTO `wp_postmeta` VALUES("79", "96", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:280;s:6:\"height\";i:70;s:4:\"file\";s:18:\"2017/03/logo-1.png\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"logo-1-150x70.png\";s:5:\"width\";i:150;s:6:\"height\";i:70;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:17:\"logo-1-100x70.png\";s:5:\"width\";i:100;s:6:\"height\";i:70;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:17:\"logo-1-200x70.png\";s:5:\"width\";i:200;s:6:\"height\";i:70;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("82", "4", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("83", "2", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("84", "2", "_edit_lock", "1488876644:1");
INSERT INTO `wp_postmeta` VALUES("119", "110", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("120", "110", "_edit_lock", "1508852337:1");
INSERT INTO `wp_postmeta` VALUES("121", "110", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("600", "43743", "_wp_attached_file", "2017/03/maquina.jpg");
INSERT INTO `wp_postmeta` VALUES("601", "43743", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:529;s:4:\"file\";s:19:\"2017/03/maquina.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"maquina-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"maquina-300x176.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:176;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:19:\"maquina-768x451.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:451;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"wysija-newsletters-max\";a:4:{s:4:\"file\";s:19:\"maquina-600x353.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:353;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:19:\"maquina-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:19:\"maquina-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"home-latest\";a:4:{s:4:\"file\";s:19:\"maquina-800x420.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"masonry-image\";a:4:{s:4:\"file\";s:19:\"maquina-600x353.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:353;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("609", "43745", "_wp_attached_file", "http://213.229.136.106/iwatchCommodity/wp-content/uploads/2017/05/curcuma-600x402.jpg");
INSERT INTO `wp_postmeta` VALUES("610", "43745", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:610;s:6:\"height\";i:343;s:4:\"file\";s:87:\"http://213.229.136.106/iwatchCommodity/wp-content/uploads/2017/05/curcuma-600x402.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:87:\"xxxMondelez-rolls-out-SmartLabel-app-to-keep-its-consumers-informed_strict_xxl-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:87:\"Mondelez-rolls-out-SmartLabel-app-to-keep-its-consumers-informed_strict_xxl-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"wysija-newsletters-max\";a:4:{s:4:\"file\";s:87:\"Mondelez-rolls-out-SmartLabel-app-to-keep-its-consumers-informed_strict_xxl-600x337.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:87:\"Mondelez-rolls-out-SmartLabel-app-to-keep-its-consumers-informed_strict_xxl-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:87:\"Mondelez-rolls-out-SmartLabel-app-to-keep-its-consumers-informed_strict_xxl-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"masonry-image\";a:4:{s:4:\"file\";s:87:\"Mondelez-rolls-out-SmartLabel-app-to-keep-its-consumers-informed_strict_xxl-600x337.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("719", "43761", "_wp_attached_file", "2017/03/RipeCraft_900.jpg");
INSERT INTO `wp_postmeta` VALUES("720", "43761", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:550;s:4:\"file\";s:25:\"2017/03/RipeCraft_900.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"RipeCraft_900-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"RipeCraft_900-300x183.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:183;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"RipeCraft_900-768x469.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:469;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"wysija-newsletters-max\";a:4:{s:4:\"file\";s:25:\"RipeCraft_900-600x367.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:367;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:25:\"RipeCraft_900-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:25:\"RipeCraft_900-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"home-latest\";a:4:{s:4:\"file\";s:25:\"RipeCraft_900-800x420.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"masonry-image\";a:4:{s:4:\"file\";s:25:\"RipeCraft_900-600x367.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:367;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("726", "43762", "_wp_attached_file", "2017/03/11200279-18613683.jpg");
INSERT INTO `wp_postmeta` VALUES("727", "43762", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:940;s:4:\"file\";s:29:\"2017/03/11200279-18613683.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:29:\"11200279-18613683-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"11200279-18613683-300x147.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:29:\"11200279-18613683-768x376.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:376;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:30:\"11200279-18613683-1024x501.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:501;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"wysija-newsletters-max\";a:4:{s:4:\"file\";s:29:\"11200279-18613683-600x294.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:294;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:29:\"11200279-18613683-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:29:\"11200279-18613683-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"home-latest\";a:4:{s:4:\"file\";s:29:\"11200279-18613683-800x420.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"masonry-image\";a:4:{s:4:\"file\";s:29:\"11200279-18613683-600x294.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:294;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("753", "43770", "_edit_lock", "1548334317:1");
INSERT INTO `wp_postmeta` VALUES("754", "43770", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("755", "43770", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("756", "43773", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("757", "43773", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("758", "43773", "_menu_item_object_id", "43773");
INSERT INTO `wp_postmeta` VALUES("759", "43773", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("760", "43773", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("761", "43773", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("762", "43773", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("763", "43773", "_menu_item_url", "http://www.observatoriodelenvase.com/");
INSERT INTO `wp_postmeta` VALUES("765", "43774", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("766", "43774", "_menu_item_menu_item_parent", "80969");
INSERT INTO `wp_postmeta` VALUES("767", "43774", "_menu_item_object_id", "43770");
INSERT INTO `wp_postmeta` VALUES("768", "43774", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("769", "43774", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("770", "43774", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("771", "43774", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("772", "43774", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("774", "43775", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("775", "43775", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("776", "43775", "_menu_item_object_id", "53");
INSERT INTO `wp_postmeta` VALUES("777", "43775", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("778", "43775", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("779", "43775", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("780", "43775", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("781", "43775", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("783", "43776", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("784", "43776", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("785", "43776", "_menu_item_object_id", "110");
INSERT INTO `wp_postmeta` VALUES("786", "43776", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("787", "43776", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("788", "43776", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("789", "43776", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("790", "43776", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("792", "43777", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("793", "43777", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("794", "43777", "_menu_item_object_id", "55");
INSERT INTO `wp_postmeta` VALUES("795", "43777", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("796", "43777", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("797", "43777", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("798", "43777", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("799", "43777", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("801", "43778", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("802", "43778", "_menu_item_menu_item_parent", "80969");
INSERT INTO `wp_postmeta` VALUES("803", "43778", "_menu_item_object_id", "83");
INSERT INTO `wp_postmeta` VALUES("804", "43778", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("805", "43778", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("806", "43778", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("807", "43778", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("808", "43778", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("819", "43780", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("820", "43780", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("821", "43780", "_menu_item_object_id", "43780");
INSERT INTO `wp_postmeta` VALUES("822", "43780", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("823", "43780", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("824", "43780", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("825", "43780", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("826", "43780", "_menu_item_url", "http://www.observatoriodelenvase.com/wp-admin/");
INSERT INTO `wp_postmeta` VALUES("944", "53", "_edit_lock", "1490871778:1");
INSERT INTO `wp_postmeta` VALUES("969", "43789", "_wp_attached_file", "2017/03/3de9109c-067a-42a8-a090-e5e5bf002c45.jpg");
INSERT INTO `wp_postmeta` VALUES("970", "43789", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:700;s:6:\"height\";i:300;s:4:\"file\";s:48:\"2017/03/3de9109c-067a-42a8-a090-e5e5bf002c45.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:48:\"3de9109c-067a-42a8-a090-e5e5bf002c45-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:48:\"3de9109c-067a-42a8-a090-e5e5bf002c45-300x129.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:129;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"wysija-newsletters-max\";a:4:{s:4:\"file\";s:48:\"3de9109c-067a-42a8-a090-e5e5bf002c45-600x257.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:257;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:48:\"3de9109c-067a-42a8-a090-e5e5bf002c45-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:48:\"3de9109c-067a-42a8-a090-e5e5bf002c45-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"masonry-image\";a:4:{s:4:\"file\";s:48:\"3de9109c-067a-42a8-a090-e5e5bf002c45-600x257.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:257;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2388", "45087", "_wp_attached_file", "2017/03/iceberg.jpg");
INSERT INTO `wp_postmeta` VALUES("2389", "45087", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:306;s:6:\"height\";i:172;s:4:\"file\";s:19:\"2017/03/iceberg.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"iceberg-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"iceberg-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:19:\"iceberg-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:19:\"iceberg-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2616", "45122", "_wp_attached_file", "2017/03/cooky-strw.jpg");
INSERT INTO `wp_postmeta` VALUES("2617", "45122", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:177;s:6:\"height\";i:284;s:4:\"file\";s:22:\"2017/03/cooky-strw.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"cooky-strw-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:22:\"cooky-strw-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:22:\"cooky-strw-177x120.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2635", "83", "_edit_lock", "1548413799:1");
INSERT INTO `wp_postmeta` VALUES("4300", "45156", "_wp_attached_file", "2017/04/Nairns-snackers-300x111.jpg");
INSERT INTO `wp_postmeta` VALUES("4301", "45156", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:300;s:6:\"height\";i:111;s:4:\"file\";s:35:\"2017/04/Nairns-snackers-300x111.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:35:\"Nairns-snackers-300x111-150x111.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:111;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:35:\"Nairns-snackers-300x111-300x111.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:111;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:35:\"Nairns-snackers-300x111-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:35:\"Nairns-snackers-300x111-200x111.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:111;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4305", "45157", "_wp_attached_file", "2017/03/TheGroovy.png");
INSERT INTO `wp_postmeta` VALUES("4306", "45157", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:303;s:6:\"height\";i:198;s:4:\"file\";s:21:\"2017/03/TheGroovy.png\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"TheGroovy-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"TheGroovy-300x196.png\";s:5:\"width\";i:300;s:6:\"height\";i:196;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:21:\"TheGroovy-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:21:\"TheGroovy-200x120.png\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4310", "45158", "_wp_attached_file", "2016/11/Mc-Coys-chips-salt-vinegar-242x300.jpg");
INSERT INTO `wp_postmeta` VALUES("4311", "45158", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:242;s:6:\"height\";i:300;s:4:\"file\";s:46:\"2016/11/Mc-Coys-chips-salt-vinegar-242x300.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:46:\"Mc-Coys-chips-salt-vinegar-242x300-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:46:\"Mc-Coys-chips-salt-vinegar-242x300-242x300.jpg\";s:5:\"width\";i:242;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:46:\"Mc-Coys-chips-salt-vinegar-242x300-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:46:\"Mc-Coys-chips-salt-vinegar-242x300-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4315", "45159", "_wp_attached_file", "2017/02/Mc-Coys-chips-salt-vinegar-242x300.jpg");
INSERT INTO `wp_postmeta` VALUES("4316", "45159", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:242;s:6:\"height\";i:300;s:4:\"file\";s:46:\"2017/02/Mc-Coys-chips-salt-vinegar-242x300.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:46:\"Mc-Coys-chips-salt-vinegar-242x300-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:46:\"Mc-Coys-chips-salt-vinegar-242x300-242x300.jpg\";s:5:\"width\";i:242;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:46:\"Mc-Coys-chips-salt-vinegar-242x300-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:46:\"Mc-Coys-chips-salt-vinegar-242x300-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4326", "45160", "_wp_attached_file", "2017/02/roha2.jpg");
INSERT INTO `wp_postmeta` VALUES("4327", "45160", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:248;s:6:\"height\";i:166;s:4:\"file\";s:17:\"2017/02/roha2.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"roha2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:17:\"roha2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:17:\"roha2-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4331", "45161", "_wp_attached_file", "2017/03/85599a15-fb35-4b99-b7d0-577bb6d03e7aarticleimage.jpg");
INSERT INTO `wp_postmeta` VALUES("4332", "45161", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:196;s:6:\"height\";i:200;s:4:\"file\";s:60:\"2017/03/85599a15-fb35-4b99-b7d0-577bb6d03e7aarticleimage.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:60:\"85599a15-fb35-4b99-b7d0-577bb6d03e7aarticleimage-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:60:\"85599a15-fb35-4b99-b7d0-577bb6d03e7aarticleimage-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:60:\"85599a15-fb35-4b99-b7d0-577bb6d03e7aarticleimage-196x120.jpg\";s:5:\"width\";i:196;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:24:\"Getty Images/iStockphoto\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:19:\"protein shake woman\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:9:\"522474875\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4336", "45162", "_wp_attached_file", "2017/02/umaicha.jpg");
INSERT INTO `wp_postmeta` VALUES("4337", "45162", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:770;s:6:\"height\";i:420;s:4:\"file\";s:19:\"2017/02/umaicha.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"umaicha-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"umaicha-300x164.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:164;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:19:\"umaicha-768x419.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:419;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"wysija-newsletters-max\";a:4:{s:4:\"file\";s:19:\"umaicha-600x327.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:327;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:19:\"umaicha-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:19:\"umaicha-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"home-latest\";a:4:{s:4:\"file\";s:19:\"umaicha-770x420.jpg\";s:5:\"width\";i:770;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"masonry-image\";a:4:{s:4:\"file\";s:19:\"umaicha-600x327.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:327;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4341", "45163", "_wp_attached_file", "2017/02/Mango-Cheeks-700g-159x300.jpg");
INSERT INTO `wp_postmeta` VALUES("4342", "45163", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:159;s:6:\"height\";i:300;s:4:\"file\";s:37:\"2017/02/Mango-Cheeks-700g-159x300.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"Mango-Cheeks-700g-159x300-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"Mango-Cheeks-700g-159x300-159x300.jpg\";s:5:\"width\";i:159;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:37:\"Mango-Cheeks-700g-159x300-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:37:\"Mango-Cheeks-700g-159x300-159x120.jpg\";s:5:\"width\";i:159;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4348", "45164", "_wp_attached_file", "2017/02/13882095_1227730727247338_4315326092185327716_n.jpg");
INSERT INTO `wp_postmeta` VALUES("4349", "45164", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:610;s:6:\"height\";i:380;s:4:\"file\";s:59:\"2017/02/13882095_1227730727247338_4315326092185327716_n.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:59:\"13882095_1227730727247338_4315326092185327716_n-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:59:\"13882095_1227730727247338_4315326092185327716_n-300x187.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:187;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"wysija-newsletters-max\";a:4:{s:4:\"file\";s:59:\"13882095_1227730727247338_4315326092185327716_n-600x374.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:374;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:59:\"13882095_1227730727247338_4315326092185327716_n-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:59:\"13882095_1227730727247338_4315326092185327716_n-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"masonry-image\";a:4:{s:4:\"file\";s:59:\"13882095_1227730727247338_4315326092185327716_n-600x374.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:374;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4357", "45165", "_wp_attached_file", "2017/02/Mango-Cheeks-700g-159x300-1.jpg");
INSERT INTO `wp_postmeta` VALUES("4358", "45165", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:358;s:6:\"height\";i:317;s:4:\"file\";s:39:\"2017/02/Mango-Cheeks-700g-159x300-1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:39:\"Mango-Cheeks-700g-159x300-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:39:\"Mango-Cheeks-700g-159x300-1-300x266.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:266;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:39:\"Mango-Cheeks-700g-159x300-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:39:\"Mango-Cheeks-700g-159x300-1-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4362", "45166", "_wp_attached_file", "2017/03/velvetta-900.jpg");
INSERT INTO `wp_postmeta` VALUES("4363", "45166", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:550;s:4:\"file\";s:24:\"2017/03/velvetta-900.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"velvetta-900-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"velvetta-900-300x183.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:183;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:24:\"velvetta-900-768x469.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:469;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"wysija-newsletters-max\";a:4:{s:4:\"file\";s:24:\"velvetta-900-600x367.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:367;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:24:\"velvetta-900-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:24:\"velvetta-900-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"home-latest\";a:4:{s:4:\"file\";s:24:\"velvetta-900-800x420.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"masonry-image\";a:4:{s:4:\"file\";s:24:\"velvetta-900-600x367.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:367;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4420", "45168", "_wp_attached_file", "2017/03/Luxardo-Bitter-Bianco2-94x300.jpg");
INSERT INTO `wp_postmeta` VALUES("4421", "45168", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:378;s:6:\"height\";i:300;s:4:\"file\";s:41:\"2017/03/Luxardo-Bitter-Bianco2-94x300.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"Luxardo-Bitter-Bianco2-94x300-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"Luxardo-Bitter-Bianco2-94x300-300x238.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:238;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:41:\"Luxardo-Bitter-Bianco2-94x300-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:41:\"Luxardo-Bitter-Bianco2-94x300-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1450455880\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4427", "45169", "_wp_attached_file", "2017/03/walmart-logo-900.jpg");
INSERT INTO `wp_postmeta` VALUES("4428", "45169", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:550;s:4:\"file\";s:28:\"2017/03/walmart-logo-900.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"walmart-logo-900-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"walmart-logo-900-300x183.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:183;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:28:\"walmart-logo-900-768x469.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:469;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"wysija-newsletters-max\";a:4:{s:4:\"file\";s:28:\"walmart-logo-900-600x367.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:367;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:28:\"walmart-logo-900-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:28:\"walmart-logo-900-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"home-latest\";a:4:{s:4:\"file\";s:28:\"walmart-logo-900-800x420.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"masonry-image\";a:4:{s:4:\"file\";s:28:\"walmart-logo-900-600x367.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:367;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4466", "45177", "_wp_attached_file", "2017/01/minigustos_logo.png");
INSERT INTO `wp_postmeta` VALUES("4467", "45177", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:250;s:6:\"height\";i:126;s:4:\"file\";s:27:\"2017/01/minigustos_logo.png\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"minigustos_logo-150x126.png\";s:5:\"width\";i:150;s:6:\"height\";i:126;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:27:\"minigustos_logo-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:27:\"minigustos_logo-200x120.png\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4468", "45178", "_wp_attached_file", "2017/02/Ozery-Bakery-launches-new-single-serve-pita-bread_strict_xxl.jpg");
INSERT INTO `wp_postmeta` VALUES("4469", "45178", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:610;s:6:\"height\";i:343;s:4:\"file\";s:72:\"2017/02/Ozery-Bakery-launches-new-single-serve-pita-bread_strict_xxl.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:72:\"Ozery-Bakery-launches-new-single-serve-pita-bread_strict_xxl-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:72:\"Ozery-Bakery-launches-new-single-serve-pita-bread_strict_xxl-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"wysija-newsletters-max\";a:4:{s:4:\"file\";s:72:\"Ozery-Bakery-launches-new-single-serve-pita-bread_strict_xxl-600x337.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:72:\"Ozery-Bakery-launches-new-single-serve-pita-bread_strict_xxl-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:72:\"Ozery-Bakery-launches-new-single-serve-pita-bread_strict_xxl-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"masonry-image\";a:4:{s:4:\"file\";s:72:\"Ozery-Bakery-launches-new-single-serve-pita-bread_strict_xxl-600x337.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4545", "45195", "_wp_attached_file", "2017/02/VIta-coco-coconut-water4.jpg");
INSERT INTO `wp_postmeta` VALUES("4546", "45195", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:834;s:6:\"height\";i:700;s:4:\"file\";s:36:\"2017/02/VIta-coco-coconut-water4.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"VIta-coco-coconut-water4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"VIta-coco-coconut-water4-300x252.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:252;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"VIta-coco-coconut-water4-768x645.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:645;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"wysija-newsletters-max\";a:4:{s:4:\"file\";s:36:\"VIta-coco-coconut-water4-600x504.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:504;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:36:\"VIta-coco-coconut-water4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:36:\"VIta-coco-coconut-water4-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"home-latest\";a:4:{s:4:\"file\";s:36:\"VIta-coco-coconut-water4-800x420.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"masonry-image\";a:4:{s:4:\"file\";s:36:\"VIta-coco-coconut-water4-600x504.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:504;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1475270485\";s:9:\"copyright\";s:19:\"Edward Bryant Hamel\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4552", "45196", "_wp_attached_file", "2017/01/Kellogg-s-Pringles-launches-five-new-flavors-under-LOUD-collection_strict_xxl.jpg");
INSERT INTO `wp_postmeta` VALUES("4553", "45196", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:610;s:6:\"height\";i:343;s:4:\"file\";s:89:\"2017/01/Kellogg-s-Pringles-launches-five-new-flavors-under-LOUD-collection_strict_xxl.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:89:\"Kellogg-s-Pringles-launches-five-new-flavors-under-LOUD-collection_strict_xxl-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:89:\"Kellogg-s-Pringles-launches-five-new-flavors-under-LOUD-collection_strict_xxl-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"wysija-newsletters-max\";a:4:{s:4:\"file\";s:89:\"Kellogg-s-Pringles-launches-five-new-flavors-under-LOUD-collection_strict_xxl-600x337.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:89:\"Kellogg-s-Pringles-launches-five-new-flavors-under-LOUD-collection_strict_xxl-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:89:\"Kellogg-s-Pringles-launches-five-new-flavors-under-LOUD-collection_strict_xxl-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"masonry-image\";a:4:{s:4:\"file\";s:89:\"Kellogg-s-Pringles-launches-five-new-flavors-under-LOUD-collection_strict_xxl-600x337.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4601", "45205", "_wp_attached_file", "2016/10/galletas-saladas.jpg");
INSERT INTO `wp_postmeta` VALUES("4602", "45205", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:630;s:6:\"height\";i:332;s:4:\"file\";s:28:\"2016/10/galletas-saladas.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"galletas-saladas-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"galletas-saladas-300x158.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:158;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"wysija-newsletters-max\";a:4:{s:4:\"file\";s:28:\"galletas-saladas-600x316.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:316;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:28:\"galletas-saladas-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:28:\"galletas-saladas-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"masonry-image\";a:4:{s:4:\"file\";s:28:\"galletas-saladas-600x316.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:316;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4610", "45206", "_wp_attached_file", "2016/09/Knorr.svg_.png");
INSERT INTO `wp_postmeta` VALUES("4611", "45206", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1200;s:6:\"height\";i:1437;s:4:\"file\";s:22:\"2016/09/Knorr.svg_.png\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"Knorr.svg_-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"Knorr.svg_-251x300.png\";s:5:\"width\";i:251;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"Knorr.svg_-768x920.png\";s:5:\"width\";i:768;s:6:\"height\";i:920;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"Knorr.svg_-855x1024.png\";s:5:\"width\";i:855;s:6:\"height\";i:1024;s:9:\"mime-type\";s:9:\"image/png\";}s:22:\"wysija-newsletters-max\";a:4:{s:4:\"file\";s:22:\"Knorr.svg_-600x719.png\";s:5:\"width\";i:600;s:6:\"height\";i:719;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:22:\"Knorr.svg_-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:22:\"Knorr.svg_-200x120.png\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"home-latest\";a:4:{s:4:\"file\";s:22:\"Knorr.svg_-800x420.png\";s:5:\"width\";i:800;s:6:\"height\";i:420;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"masonry-image\";a:4:{s:4:\"file\";s:22:\"Knorr.svg_-600x719.png\";s:5:\"width\";i:600;s:6:\"height\";i:719;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4619", "45207", "_wp_attached_file", "2017/02/kitkat-peanut-butter.jpg");
INSERT INTO `wp_postmeta` VALUES("4620", "45207", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:430;s:6:\"height\";i:331;s:4:\"file\";s:32:\"2017/02/kitkat-peanut-butter.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"kitkat-peanut-butter-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"kitkat-peanut-butter-300x231.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:231;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:32:\"kitkat-peanut-butter-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:32:\"kitkat-peanut-butter-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4626", "45208", "_wp_attached_file", "2017/03/306_CKFI_82.jpg");
INSERT INTO `wp_postmeta` VALUES("4627", "45208", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:306;s:6:\"height\";i:204;s:4:\"file\";s:23:\"2017/03/306_CKFI_82.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"306_CKFI_82-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"306_CKFI_82-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:23:\"306_CKFI_82-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:23:\"306_CKFI_82-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4631", "45209", "_wp_attached_file", "2017/03/Grufesa-San-Valentin.jpg");
INSERT INTO `wp_postmeta` VALUES("4632", "45209", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:250;s:6:\"height\";i:154;s:4:\"file\";s:32:\"2017/03/Grufesa-San-Valentin.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"Grufesa-San-Valentin-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:32:\"Grufesa-San-Valentin-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:32:\"Grufesa-San-Valentin-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1481902481\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4656", "45211", "_wp_attached_file", "2017/04/Unilever_Bertolli_Wrap_250g_LemonChilli-300x236.jpg");
INSERT INTO `wp_postmeta` VALUES("4657", "45211", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:300;s:6:\"height\";i:236;s:4:\"file\";s:59:\"2017/04/Unilever_Bertolli_Wrap_250g_LemonChilli-300x236.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:59:\"Unilever_Bertolli_Wrap_250g_LemonChilli-300x236-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:59:\"Unilever_Bertolli_Wrap_250g_LemonChilli-300x236-300x236.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:236;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:59:\"Unilever_Bertolli_Wrap_250g_LemonChilli-300x236-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:59:\"Unilever_Bertolli_Wrap_250g_LemonChilli-300x236-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4669", "45214", "_wp_attached_file", "2017/04/Vegetarian-678x381.jpg");
INSERT INTO `wp_postmeta` VALUES("4670", "45214", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:678;s:6:\"height\";i:381;s:4:\"file\";s:30:\"2017/04/Vegetarian-678x381.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"Vegetarian-678x381-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"Vegetarian-678x381-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"wysija-newsletters-max\";a:4:{s:4:\"file\";s:30:\"Vegetarian-678x381-600x337.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:30:\"Vegetarian-678x381-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:30:\"Vegetarian-678x381-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"masonry-image\";a:4:{s:4:\"file\";s:30:\"Vegetarian-678x381-600x337.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4746", "45231", "_wp_attached_file", "2017/04/vermultimedia.ashx_.jpg");
INSERT INTO `wp_postmeta` VALUES("4747", "45231", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:368;s:6:\"height\";i:264;s:4:\"file\";s:31:\"2017/04/vermultimedia.ashx_.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"vermultimedia.ashx_-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"vermultimedia.ashx_-300x215.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:215;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:31:\"vermultimedia.ashx_-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:31:\"vermultimedia.ashx_-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4821", "45243", "_wp_attached_file", "2015/07/Nestle_RD.jpg");
INSERT INTO `wp_postmeta` VALUES("4822", "45243", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:300;s:6:\"height\";i:180;s:4:\"file\";s:21:\"2015/07/Nestle_RD.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"Nestle_RD-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"Nestle_RD-300x180.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:21:\"Nestle_RD-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:21:\"Nestle_RD-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4828", "45244", "_wp_attached_file", "2016/07/recalled-Watts-Brothers-Farms-frozen-veg.jpg");
INSERT INTO `wp_postmeta` VALUES("4829", "45244", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:406;s:6:\"height\";i:250;s:4:\"file\";s:52:\"2016/07/recalled-Watts-Brothers-Farms-frozen-veg.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:52:\"recalled-Watts-Brothers-Farms-frozen-veg-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:52:\"recalled-Watts-Brothers-Farms-frozen-veg-300x185.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:52:\"recalled-Watts-Brothers-Farms-frozen-veg-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:52:\"recalled-Watts-Brothers-Farms-frozen-veg-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5342", "77339", "_wp_attached_file", "2017/04/martina_klein_hotel_the_hat_06042017_0032-39965.jpg");
INSERT INTO `wp_postmeta` VALUES("5343", "77339", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:333;s:4:\"file\";s:59:\"2017/04/martina_klein_hotel_the_hat_06042017_0032-39965.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:59:\"martina_klein_hotel_the_hat_06042017_0032-39965-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:59:\"martina_klein_hotel_the_hat_06042017_0032-39965-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:59:\"martina_klein_hotel_the_hat_06042017_0032-39965-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:59:\"martina_klein_hotel_the_hat_06042017_0032-39965-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5357", "77342", "_wp_attached_file", "2017/04/Vibe-Coconut-Cacao-160g-216x300.jpg");
INSERT INTO `wp_postmeta` VALUES("5358", "77342", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:216;s:6:\"height\";i:300;s:4:\"file\";s:43:\"2017/04/Vibe-Coconut-Cacao-160g-216x300.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:43:\"Vibe-Coconut-Cacao-160g-216x300-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:43:\"Vibe-Coconut-Cacao-160g-216x300-216x300.jpg\";s:5:\"width\";i:216;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:43:\"Vibe-Coconut-Cacao-160g-216x300-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:43:\"Vibe-Coconut-Cacao-160g-216x300-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:41:\"Butterkist 170g Toffee Popcorn - PB107017\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5366", "77344", "_wp_attached_file", "2017/04/Delicious-Ella-energy-ball-300x196.jpg");
INSERT INTO `wp_postmeta` VALUES("5367", "77344", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:300;s:6:\"height\";i:196;s:4:\"file\";s:46:\"2017/04/Delicious-Ella-energy-ball-300x196.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:46:\"Delicious-Ella-energy-ball-300x196-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:46:\"Delicious-Ella-energy-ball-300x196-300x196.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:196;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:46:\"Delicious-Ella-energy-ball-300x196-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:46:\"Delicious-Ella-energy-ball-300x196-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5389", "77348", "_wp_attached_file", "2017/04/PIP-organic-fruity-water-300x168.png");
INSERT INTO `wp_postmeta` VALUES("5390", "77348", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:300;s:6:\"height\";i:168;s:4:\"file\";s:44:\"2017/04/PIP-organic-fruity-water-300x168.png\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:44:\"PIP-organic-fruity-water-300x168-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:44:\"PIP-organic-fruity-water-300x168-300x168.png\";s:5:\"width\";i:300;s:6:\"height\";i:168;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:44:\"PIP-organic-fruity-water-300x168-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:44:\"PIP-organic-fruity-water-300x168-200x120.png\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5396", "77349", "_wp_attached_file", "2017/04/ISM-2017-Pere-y-Pau-Saguer-CONFIGIRONA.jpg");
INSERT INTO `wp_postmeta` VALUES("5397", "77349", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:630;s:6:\"height\";i:332;s:4:\"file\";s:50:\"2017/04/ISM-2017-Pere-y-Pau-Saguer-CONFIGIRONA.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:50:\"ISM-2017-Pere-y-Pau-Saguer-CONFIGIRONA-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:50:\"ISM-2017-Pere-y-Pau-Saguer-CONFIGIRONA-300x158.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:158;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"wysija-newsletters-max\";a:4:{s:4:\"file\";s:50:\"ISM-2017-Pere-y-Pau-Saguer-CONFIGIRONA-600x316.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:316;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:50:\"ISM-2017-Pere-y-Pau-Saguer-CONFIGIRONA-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:50:\"ISM-2017-Pere-y-Pau-Saguer-CONFIGIRONA-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"masonry-image\";a:4:{s:4:\"file\";s:50:\"ISM-2017-Pere-y-Pau-Saguer-CONFIGIRONA-600x316.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:316;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5403", "77351", "_wp_attached_file", "2017/04/Pillsbury-Churros-feature.jpg");
INSERT INTO `wp_postmeta` VALUES("5404", "77351", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:550;s:4:\"file\";s:37:\"2017/04/Pillsbury-Churros-feature.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"Pillsbury-Churros-feature-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"Pillsbury-Churros-feature-300x183.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:183;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:37:\"Pillsbury-Churros-feature-768x469.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:469;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"wysija-newsletters-max\";a:4:{s:4:\"file\";s:37:\"Pillsbury-Churros-feature-600x367.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:367;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:37:\"Pillsbury-Churros-feature-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:37:\"Pillsbury-Churros-feature-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"home-latest\";a:4:{s:4:\"file\";s:37:\"Pillsbury-Churros-feature-800x420.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"masonry-image\";a:4:{s:4:\"file\";s:37:\"Pillsbury-Churros-feature-600x367.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:367;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5491", "77363", "_wp_attached_file", "2016/12/bonne-maman_manzana-pera-1-37306.jpg");
INSERT INTO `wp_postmeta` VALUES("5492", "77363", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:800;s:6:\"height\";i:533;s:4:\"file\";s:44:\"2016/12/bonne-maman_manzana-pera-1-37306.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:44:\"bonne-maman_manzana-pera-1-37306-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:44:\"bonne-maman_manzana-pera-1-37306-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:44:\"bonne-maman_manzana-pera-1-37306-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"wysija-newsletters-max\";a:4:{s:4:\"file\";s:44:\"bonne-maman_manzana-pera-1-37306-600x400.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:44:\"bonne-maman_manzana-pera-1-37306-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:44:\"bonne-maman_manzana-pera-1-37306-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"home-latest\";a:4:{s:4:\"file\";s:44:\"bonne-maman_manzana-pera-1-37306-800x420.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"masonry-image\";a:4:{s:4:\"file\";s:44:\"bonne-maman_manzana-pera-1-37306-600x400.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5597", "77377", "_wp_attached_file", "2017/04/Teapigs-and-EArl-Grey-lager-300x230.jpg");
INSERT INTO `wp_postmeta` VALUES("5598", "77377", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:300;s:6:\"height\";i:230;s:4:\"file\";s:47:\"2017/04/Teapigs-and-EArl-Grey-lager-300x230.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:47:\"Teapigs-and-EArl-Grey-lager-300x230-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:47:\"Teapigs-and-EArl-Grey-lager-300x230-300x230.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:47:\"Teapigs-and-EArl-Grey-lager-300x230-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:47:\"Teapigs-and-EArl-Grey-lager-300x230-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:12:\"Sarah Groves\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1492688545\";s:9:\"copyright\";s:12:\"Sarah Groves\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5648", "77387", "_wp_attached_file", "2017/04/Velarte-Tv-campana.jpg");
INSERT INTO `wp_postmeta` VALUES("5649", "77387", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:630;s:6:\"height\";i:332;s:4:\"file\";s:30:\"2017/04/Velarte-Tv-campana.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"Velarte-Tv-campana-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"Velarte-Tv-campana-300x158.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:158;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"wysija-newsletters-max\";a:4:{s:4:\"file\";s:30:\"Velarte-Tv-campana-600x316.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:316;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:30:\"Velarte-Tv-campana-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:30:\"Velarte-Tv-campana-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"masonry-image\";a:4:{s:4:\"file\";s:30:\"Velarte-Tv-campana-600x316.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:316;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5661", "77390", "_wp_attached_file", "2017/04/consumidoraplatospreparadoscongelados123rf-40240.jpg");
INSERT INTO `wp_postmeta` VALUES("5662", "77390", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:800;s:6:\"height\";i:533;s:4:\"file\";s:60:\"2017/04/consumidoraplatospreparadoscongelados123rf-40240.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:60:\"consumidoraplatospreparadoscongelados123rf-40240-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:60:\"consumidoraplatospreparadoscongelados123rf-40240-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:60:\"consumidoraplatospreparadoscongelados123rf-40240-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"wysija-newsletters-max\";a:4:{s:4:\"file\";s:60:\"consumidoraplatospreparadoscongelados123rf-40240-600x400.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:60:\"consumidoraplatospreparadoscongelados123rf-40240-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:60:\"consumidoraplatospreparadoscongelados123rf-40240-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"home-latest\";a:4:{s:4:\"file\";s:60:\"consumidoraplatospreparadoscongelados123rf-40240-800x420.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"masonry-image\";a:4:{s:4:\"file\";s:60:\"consumidoraplatospreparadoscongelados123rf-40240-600x400.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5674", "77393", "_wp_attached_file", "2017/04/sopa-de-quinoa-ecologico-con-verduras-carretilla-39015.jpg");
INSERT INTO `wp_postmeta` VALUES("5675", "77393", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:230;s:6:\"height\";i:204;s:4:\"file\";s:66:\"2017/04/sopa-de-quinoa-ecologico-con-verduras-carretilla-39015.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:66:\"sopa-de-quinoa-ecologico-con-verduras-carretilla-39015-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:66:\"sopa-de-quinoa-ecologico-con-verduras-carretilla-39015-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:66:\"sopa-de-quinoa-ecologico-con-verduras-carretilla-39015-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5687", "77396", "_wp_attached_file", "2017/04/tabladillo-39267.jpg");
INSERT INTO `wp_postmeta` VALUES("5688", "77396", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:357;s:4:\"file\";s:28:\"2017/04/tabladillo-39267.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"tabladillo-39267-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"tabladillo-39267-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:28:\"tabladillo-39267-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:28:\"tabladillo-39267-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5698", "77398", "_wp_attached_file", "2017/01/dhul-me-up-_alm_natural-38191.jpg");
INSERT INTO `wp_postmeta` VALUES("5699", "77398", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:230;s:6:\"height\";i:159;s:4:\"file\";s:41:\"2017/01/dhul-me-up-_alm_natural-38191.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"dhul-me-up-_alm_natural-38191-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:41:\"dhul-me-up-_alm_natural-38191-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:41:\"dhul-me-up-_alm_natural-38191-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5731", "77405", "_wp_attached_file", "2017/04/NORPAC-FLAV-R-PAC-frozen-veggies-feature.jpg");
INSERT INTO `wp_postmeta` VALUES("5732", "77405", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:550;s:4:\"file\";s:52:\"2017/04/NORPAC-FLAV-R-PAC-frozen-veggies-feature.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:52:\"NORPAC-FLAV-R-PAC-frozen-veggies-feature-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:52:\"NORPAC-FLAV-R-PAC-frozen-veggies-feature-300x183.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:183;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:52:\"NORPAC-FLAV-R-PAC-frozen-veggies-feature-768x469.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:469;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"wysija-newsletters-max\";a:4:{s:4:\"file\";s:52:\"NORPAC-FLAV-R-PAC-frozen-veggies-feature-600x367.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:367;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:52:\"NORPAC-FLAV-R-PAC-frozen-veggies-feature-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:52:\"NORPAC-FLAV-R-PAC-frozen-veggies-feature-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"home-latest\";a:4:{s:4:\"file\";s:52:\"NORPAC-FLAV-R-PAC-frozen-veggies-feature-800x420.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"masonry-image\";a:4:{s:4:\"file\";s:52:\"NORPAC-FLAV-R-PAC-frozen-veggies-feature-600x367.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:367;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5766", "77412", "_wp_attached_file", "2017/05/vegetables.jpg");
INSERT INTO `wp_postmeta` VALUES("5767", "77412", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:200;s:6:\"height\";i:182;s:4:\"file\";s:22:\"2017/05/vegetables.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"vegetables-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:22:\"vegetables-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:22:\"vegetables-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:24:\"Getty Images/iStockphoto\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:18:\"green healthy food\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:9:\"153779426\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5827", "77422", "_wp_attached_file", "2017/01/foto-spaguetti-n5-sin-gluten-38323.jpg");
INSERT INTO `wp_postmeta` VALUES("5828", "77422", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:230;s:6:\"height\";i:153;s:4:\"file\";s:46:\"2017/01/foto-spaguetti-n5-sin-gluten-38323.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:46:\"foto-spaguetti-n5-sin-gluten-38323-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:46:\"foto-spaguetti-n5-sin-gluten-38323-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:46:\"foto-spaguetti-n5-sin-gluten-38323-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5836", "77424", "_wp_attached_file", "2017/05/YogaOrganics_900.jpg");
INSERT INTO `wp_postmeta` VALUES("5837", "77424", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:550;s:4:\"file\";s:28:\"2017/05/YogaOrganics_900.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"YogaOrganics_900-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"YogaOrganics_900-300x183.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:183;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:28:\"YogaOrganics_900-768x469.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:469;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"wysija-newsletters-max\";a:4:{s:4:\"file\";s:28:\"YogaOrganics_900-600x367.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:367;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:28:\"YogaOrganics_900-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:28:\"YogaOrganics_900-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"home-latest\";a:4:{s:4:\"file\";s:28:\"YogaOrganics_900-800x420.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"masonry-image\";a:4:{s:4:\"file\";s:28:\"YogaOrganics_900-600x367.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:367;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5859", "77429", "_wp_attached_file", "2017/05/FlocchiniSausage_900.jpg");
INSERT INTO `wp_postmeta` VALUES("5860", "77429", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:550;s:4:\"file\";s:32:\"2017/05/FlocchiniSausage_900.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"FlocchiniSausage_900-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"FlocchiniSausage_900-300x183.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:183;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:32:\"FlocchiniSausage_900-768x469.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:469;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"wysija-newsletters-max\";a:4:{s:4:\"file\";s:32:\"FlocchiniSausage_900-600x367.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:367;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:32:\"FlocchiniSausage_900-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:32:\"FlocchiniSausage_900-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"home-latest\";a:4:{s:4:\"file\";s:32:\"FlocchiniSausage_900-800x420.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"masonry-image\";a:4:{s:4:\"file\";s:32:\"FlocchiniSausage_900-600x367.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:367;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5882", "77434", "_wp_attached_file", "2017/05/embutidoscastro255.jpg");
INSERT INTO `wp_postmeta` VALUES("5883", "77434", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:286;s:4:\"file\";s:30:\"2017/05/embutidoscastro255.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"embutidoscastro255-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"embutidoscastro255-300x215.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:215;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:30:\"embutidoscastro255-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:30:\"embutidoscastro255-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1489580861\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5938", "77446", "_wp_attached_file", "2017/05/erredevic253.jpg");
INSERT INTO `wp_postmeta` VALUES("5939", "77446", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:267;s:4:\"file\";s:24:\"2017/05/erredevic253.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"erredevic253-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"erredevic253-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:24:\"erredevic253-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:24:\"erredevic253-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1479317660\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5985", "77456", "_wp_attached_file", "2017/05/lahoguera255.jpg");
INSERT INTO `wp_postmeta` VALUES("5986", "77456", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:380;s:6:\"height\";i:263;s:4:\"file\";s:24:\"2017/05/lahoguera255.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"lahoguera255-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"lahoguera255-300x208.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:208;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:24:\"lahoguera255-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:24:\"lahoguera255-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("6000", "77459", "_wp_attached_file", "2017/04/embutidoscastro255.jpg");
INSERT INTO `wp_postmeta` VALUES("6001", "77459", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:286;s:4:\"file\";s:30:\"2017/04/embutidoscastro255.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"embutidoscastro255-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"embutidoscastro255-300x215.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:215;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"small-thumb\";a:4:{s:4:\"file\";s:30:\"embutidoscastro255-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"small-rect\";a:4:{s:4:\"file\";s:30:\"embutidoscastro255-200x120.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1489580861\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("6083", "77462", "_wp_attached_file", "2017/05/VoortmanBakery_900.jpg");
INSERT INTO `wp_postmeta` VALUES("6084", "77462", "_wp_attachment_metadata", "a:4:{s:5:\"width\";i:900;s:6:\"height\";i:550;s:4:\"file\";s:30:\"2017/05/VoortmanBakery_900.jpg\";s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("6110", "77467", "_wp_attached_file", "2017/05/f0f5dfb4-78f1-41fd-9c3a-fdf9ad189c83articleimage.png");
INSERT INTO `wp_postmeta` VALUES("6111", "77467", "_wp_attachment_metadata", "a:4:{s:5:\"width\";i:200;s:6:\"height\";i:141;s:4:\"file\";s:60:\"2017/05/f0f5dfb4-78f1-41fd-9c3a-fdf9ad189c83articleimage.png\";s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("6151", "77475", "_wp_attached_file", "2017/09/MerlayZyn_900.jpg");
INSERT INTO `wp_postmeta` VALUES("6152", "77475", "_wp_attachment_metadata", "a:4:{s:5:\"width\";i:900;s:6:\"height\";i:550;s:4:\"file\";s:25:\"2017/09/MerlayZyn_900.jpg\";s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("6168", "77479", "_wp_attached_file", "2017/09/novedades_europastry_30_aniversario-42888.jpg");
INSERT INTO `wp_postmeta` VALUES("6169", "77479", "_wp_attachment_metadata", "a:4:{s:5:\"width\";i:800;s:6:\"height\";i:533;s:4:\"file\";s:53:\"2017/09/novedades_europastry_30_aniversario-42888.jpg\";s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("6191", "77484", "_wp_attached_file", "2017/09/senior_tablet_supermercado123rf-28853-41798.jpg");
INSERT INTO `wp_postmeta` VALUES("6192", "77484", "_wp_attachment_metadata", "a:4:{s:5:\"width\";i:800;s:6:\"height\";i:533;s:4:\"file\";s:55:\"2017/09/senior_tablet_supermercado123rf-28853-41798.jpg\";s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("6224", "77491", "_wp_attached_file", "2017/09/Almendra-grano-Marcona.jpg");
INSERT INTO `wp_postmeta` VALUES("6225", "77491", "_wp_attachment_metadata", "a:4:{s:5:\"width\";i:300;s:6:\"height\";i:199;s:4:\"file\";s:34:\"2017/09/Almendra-grano-Marcona.jpg\";s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("6235", "77493", "_wp_attached_file", "2017/04/Ultimos-avances-en-congelación.pdf");
INSERT INTO `wp_postmeta` VALUES("8631", "78729", "_wp_attached_file", "2017/10/GREFUSA-nuevos-chips-maiz-MisterCorn.jpg");
INSERT INTO `wp_postmeta` VALUES("8632", "78729", "_wp_attachment_metadata", "a:4:{s:5:\"width\";i:630;s:6:\"height\";i:332;s:4:\"file\";s:48:\"2017/10/GREFUSA-nuevos-chips-maiz-MisterCorn.jpg\";s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("11179", "79907", "_wp_attached_file", "2018/05/noticia1.gif");
INSERT INTO `wp_postmeta` VALUES("11180", "79907", "_wp_attachment_metadata", "a:4:{s:5:\"width\";i:240;s:6:\"height\";i:180;s:4:\"file\";s:20:\"2018/05/noticia1.gif\";s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("11188", "79909", "_wp_attached_file", "2017/11/lucy-perro-labrador-cancer.jpg");
INSERT INTO `wp_postmeta` VALUES("11189", "79909", "_wp_attachment_metadata", "a:4:{s:5:\"width\";i:380;s:6:\"height\";i:215;s:4:\"file\";s:38:\"2017/11/lucy-perro-labrador-cancer.jpg\";s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("11231", "79939", "_wp_attached_file", "2017/11/cocoa1.jpg");
INSERT INTO `wp_postmeta` VALUES("11232", "79939", "_wp_attachment_metadata", "a:4:{s:5:\"width\";i:200;s:6:\"height\";i:180;s:4:\"file\";s:18:\"2017/11/cocoa1.jpg\";s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("11243", "79941", "_wp_attached_file", "2017/11/sustain.jpg");
INSERT INTO `wp_postmeta` VALUES("11244", "79941", "_wp_attachment_metadata", "a:4:{s:5:\"width\";i:200;s:6:\"height\";i:177;s:4:\"file\";s:19:\"2017/11/sustain.jpg\";s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:24:\"Getty Images/iStockphoto\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:100:\"hand holding a light bulb with energy and fresh green leaves inside on nature background, soft focus\";s:17:\"created_timestamp\";s:10:\"1438713903\";s:9:\"copyright\";s:6:\"ipopba\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:62:\"hand holding light bulb with energy, fresh green leaves inside\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:37:{i:0;s:11:\"Electricity\";i:1;s:4:\"Wire\";i:2;s:7:\"Savings\";i:3;s:11:\"Inspiration\";i:4;s:9:\"Gardening\";i:5;s:7:\"Holding\";i:6;s:7:\"Showing\";i:7;s:10:\"Light Bulb\";i:8;s:10:\"Warming Up\";i:9;s:11:\"Backgrounds\";i:10;s:10:\"One Person\";i:11;s:11:\"Illuminated\";i:12;s:6:\"Energy\";i:13;s:5:\"Power\";i:14;s:8:\"Solution\";i:15;s:6:\"Growth\";i:16;s:10:\"Friendship\";i:17;s:5:\"Order\";i:18;s:6:\"Yellow\";i:19;s:5:\"White\";i:20;s:11:\"Green Color\";i:21;s:5:\"Ideas\";i:22;s:11:\"Environment\";i:23;s:10:\"Technology\";i:24;s:6:\"Nature\";i:25;s:10:\"Soft Focus\";i:26;s:10:\"Human Hand\";i:27;s:6:\"People\";i:28;s:4:\"Leaf\";i:29;s:4:\"Tree\";i:30;s:5:\"Plant\";i:31;s:26:\"Light - Natural Phenomenon\";i:32;s:9:\"Recycling\";i:33;s:13:\"Electric Lamp\";i:34;s:21:\"Sustainable Resources\";i:35;s:6:\"Global\";i:36;s:8:\"Tungsten\";}}}");
INSERT INTO `wp_postmeta` VALUES("13346", "80969", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("13347", "80969", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("13348", "80969", "_menu_item_object_id", "80969");
INSERT INTO `wp_postmeta` VALUES("13349", "80969", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("13350", "80969", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("13351", "80969", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("13352", "80969", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("13353", "80969", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("13354", "80971", "_wp_attached_file", "2017/12/logo_iwatch.png");
INSERT INTO `wp_postmeta` VALUES("13355", "80971", "_wp_attachment_metadata", "a:4:{s:5:\"width\";i:280;s:6:\"height\";i:70;s:4:\"file\";s:23:\"2017/12/logo_iwatch.png\";s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("13366", "80976", "url_article", "http://www.ainia.es/tecnoalimentalia/formacion/economia-circular-tendencias-packaging-sostenible-dialogos-packaging-hispack/");
INSERT INTO `wp_postmeta` VALUES("13367", "80976", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13368", "80977", "url_article", "http://www.ainia.es/publicamos/guiaenvase-packaging-tendencias-tecnologia/");
INSERT INTO `wp_postmeta` VALUES("13369", "80977", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13372", "80979", "url_article", "http://www.ainia.es/sectores-industriales/alimentacion/packaging-activo-inteligente-etiquetado/");
INSERT INTO `wp_postmeta` VALUES("13373", "80979", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13374", "80980", "url_article", "http://www.ainia.es/sectores-industriales/packaging/seguridad-envases-estabilidad-producto/");
INSERT INTO `wp_postmeta` VALUES("13375", "80980", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13376", "80981", "url_article", "http://www.consumer.es/seguridad-alimentaria/sociedad-y-consumo/2017/12/08/225689.php?utm_source=feedburner&utm_medium=feed&utm_campaign=eroski-consumer%2Fseguridad-alimentaria");
INSERT INTO `wp_postmeta` VALUES("13377", "80981", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13378", "80982", "url_article", "http://feeds.ainia.es/~r/ainia-Tecnoalimentalia/~3/3GCRV5zrfI8/");
INSERT INTO `wp_postmeta` VALUES("13379", "80982", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("13380", "80983", "url_article", "http://www.ainia.es/sectores-industriales/packaging/diseno-envases-estetica-funcionalidad/");
INSERT INTO `wp_postmeta` VALUES("13381", "80983", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13382", "80984", "url_article", "http://www.ainia.es/noticias/prensa/envase-valvula-microondable/#respond");
INSERT INTO `wp_postmeta` VALUES("13383", "80984", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13384", "80985", "url_article", "http://www.consumer.es/seguridad-alimentaria/sociedad-y-consumo/2017/11/03/225619.php?utm_source=feedburner&utm_medium=feed&utm_campaign=eroski-consumer%2Fseguridad-alimentaria");
INSERT INTO `wp_postmeta` VALUES("13385", "80985", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13386", "80986", "url_article", "http://feeds.ainia.es/~r/ainia-Tecnoalimentalia/~3/cSlIslaMlFY/");
INSERT INTO `wp_postmeta` VALUES("13387", "80986", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13388", "80987", "url_article", "https://www.kantarworldpanel.com/es/Noticias/Seniors-la-generacion-futura-y-presente");
INSERT INTO `wp_postmeta` VALUES("13389", "80987", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13390", "80988", "url_article", "https://www.industriaalimenticia.com/articles/89261-se-abre-registro-para-expo-pack-mexico-2018");
INSERT INTO `wp_postmeta` VALUES("13391", "80988", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13392", "80989", "url_article", "https://www.industriaalimenticia.com/articles/89037-el-efecto-amazon-como-el-comercio-electronico-cambiara-los-envases-de-alimentos-y-bebidas");
INSERT INTO `wp_postmeta` VALUES("13393", "80989", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13394", "80990", "url_article", "https://www.industriaalimenticia.com/articles/89103-procesado-de-jugos-a-trav%C3%A9s-de-alta-presi%C3%B3n");
INSERT INTO `wp_postmeta` VALUES("13395", "80990", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13396", "80991", "url_article", "https://www.industriaalimenticia.com/articles/89215-el-nuevo-envase-de-crepes-impulsa-las-ventas-de-arandanos");
INSERT INTO `wp_postmeta` VALUES("13397", "80991", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13398", "80992", "url_article", "https://www.kantarworldpanel.com/es/Noticias/hogares-espanoles-ahorran-300-millones-euros-con-promociones-gran-consumo");
INSERT INTO `wp_postmeta` VALUES("13399", "80992", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13400", "80993", "url_article", "https://www.industriaalimenticia.com/articles/88965-seminario-webinar-para-la-industria-de-snacks-panificacion");
INSERT INTO `wp_postmeta` VALUES("13401", "80993", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13402", "80994", "url_article", "https://www.industriaalimenticia.com/articles/86583-expo-pack-mexico-2013");
INSERT INTO `wp_postmeta` VALUES("13403", "80994", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13404", "80995", "url_article", "http://www.ainia.es/sectores-industriales/cosmetica/diseno-envases-seguridad-estetica/");
INSERT INTO `wp_postmeta` VALUES("13405", "80995", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13406", "80996", "url_article", "http://www.ainia.es/sectores-industriales/cosmetica/garantiza-calidad-seguridad-consumidor/");
INSERT INTO `wp_postmeta` VALUES("13407", "80996", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13408", "80997", "url_article", "http://www.ainia.es/tecnoalimentalia/formacion/economia-circular-tendencias-packaging-sostenible-dialogos-packaging-hispack/#respond");
INSERT INTO `wp_postmeta` VALUES("13409", "80997", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13410", "80998", "url_article", "http://www.ainia.es/noticias/prensa/envase-valvula-microondable/");
INSERT INTO `wp_postmeta` VALUES("13411", "80998", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13412", "80999", "url_article", "http://www.revistaaral.com/es/notices/2018/02/los-platos-preparados-siguen-incrementando-su-presencia-en-el-hogar-79288.php");
INSERT INTO `wp_postmeta` VALUES("13413", "80999", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13414", "81000", "url_article", "http://www.ainia.es/author/pedro-zomeno/");
INSERT INTO `wp_postmeta` VALUES("13415", "81000", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13416", "81001", "url_article", "http://www.revistaaral.com/es/notices/2018/02/hispack-2018-crecera-en-expositores-e-internacionalidad-79280.php");
INSERT INTO `wp_postmeta` VALUES("13417", "81001", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13418", "81002", "url_article", "http://www.revistalatahona.com/2018/01/mercado-del-cacao-crecimiento-2017/");
INSERT INTO `wp_postmeta` VALUES("13419", "81002", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13420", "81003", "url_article", "http://www.ainia.es/sectores-industriales/farmacia/garantiza-calidad-seguridad-microbiologica/");
INSERT INTO `wp_postmeta` VALUES("13421", "81003", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13422", "81004", "url_article", "http://panypizza.com/panorama/take-away-crece-panaderia/");
INSERT INTO `wp_postmeta` VALUES("13423", "81004", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13424", "81005", "url_article", "http://vidasana.org/noticias/kimpira-primer-restaurante-espanol-con-certificacion-100-ecologica");
INSERT INTO `wp_postmeta` VALUES("13425", "81005", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13426", "81006", "url_article", "http://vidasana.org/noticias/salud-dinero-y-amor-un-brindis-por-20-anos-de-ecologismo-en-accion");
INSERT INTO `wp_postmeta` VALUES("13427", "81006", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13428", "81007", "url_article", "http://vidasana.org/noticias/el-status-quo-actual-del-mundo-bio-un-sector-en-pleno-crecimiento");
INSERT INTO `wp_postmeta` VALUES("13429", "81007", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13430", "81008", "url_article", "http://vidasana.org/noticias/el-libro-sopas-detox");
INSERT INTO `wp_postmeta` VALUES("13431", "81008", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13432", "81009", "url_article", "http://profesionalhoreca.com/los-horeca-new-business-models-awards-premiaran-las-mejores-innovaciones-en-hip-2018/");
INSERT INTO `wp_postmeta` VALUES("13433", "81009", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13434", "81010", "url_article", "http://vidasana.org/noticias/virginia-ruiprez-la-fertilidad-natural");
INSERT INTO `wp_postmeta` VALUES("13435", "81010", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13436", "81011", "url_article", "http://vidasana.org/noticias/novedades-la-primera-bebida-de-arroz-negro-del-mercado");
INSERT INTO `wp_postmeta` VALUES("13437", "81011", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13438", "81012", "url_article", "http://vidasana.org/noticias/carmena-madrid-se-compromete-a-reducir-la-exposicion-de-su-poblacion-a-los-disruptores-endocrinos");
INSERT INTO `wp_postmeta` VALUES("13439", "81012", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13440", "81013", "url_article", "http://www.ainia.es/sectores-industriales/cosmetica/diseno-higienico-instalaciones-equipos/");
INSERT INTO `wp_postmeta` VALUES("13441", "81013", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13442", "81014", "url_article", "http://vidasana.org/noticias/certificacin-simulacro-de-inspeccion-ecologica-en-aurora-del-camp");
INSERT INTO `wp_postmeta` VALUES("13443", "81014", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13444", "81015", "url_article", "http://vidasana.org/noticias/textil-ecolgico-en-el-hogar-algo-mas-que-toallas-y-albornoces");
INSERT INTO `wp_postmeta` VALUES("13445", "81015", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13446", "81016", "url_article", "http://vidasana.org/noticias/el-libro-naturalmente-atractivos");
INSERT INTO `wp_postmeta` VALUES("13447", "81016", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13448", "81017", "url_article", "http://vidasana.org/noticias/la-entrevista-philip-limbery");
INSERT INTO `wp_postmeta` VALUES("13449", "81017", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13450", "81018", "url_article", "http://vidasana.org/noticias/opinin-quien-habla-claro-sobre-proteccion-solar-y-cosmetica");
INSERT INTO `wp_postmeta` VALUES("13451", "81018", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13452", "81019", "url_article", "http://vidasana.org/noticias/la-cama-azul-un-descanso-garantizado");
INSERT INTO `wp_postmeta` VALUES("13453", "81019", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13454", "81020", "url_article", "http://vidasana.org/noticias/auma-adhy-piedra-de-alumbre-y-mas");
INSERT INTO `wp_postmeta` VALUES("13455", "81020", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13456", "81021", "url_article", "http://vidasana.org/noticias/cosmtica-certificada-que-nadie-te-engane");
INSERT INTO `wp_postmeta` VALUES("13457", "81021", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13458", "81022", "url_article", "http://vidasana.org/noticias/mamaterra-sevilla-el-valor-del-agricultor");
INSERT INTO `wp_postmeta` VALUES("13459", "81022", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13460", "81023", "url_article", "http://vidasana.org/noticias/beautys-eco-jellies-golosinas-bio");
INSERT INTO `wp_postmeta` VALUES("13461", "81023", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13462", "81024", "url_article", "http://vidasana.org/noticias/ringana-una-cosmetica-bio-y-fresca");
INSERT INTO `wp_postmeta` VALUES("13463", "81024", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13464", "81025", "url_article", "http://vidasana.org/noticias/la-rueda-natural-tintes-ecologicos-que-tinen-y-cuidan-el-cabello");
INSERT INTO `wp_postmeta` VALUES("13465", "81025", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13466", "81026", "url_article", "http://vidasana.org/noticias/bubela-artes-una-cerveza-bio-y-artesana-es-la-mejor-opcion");
INSERT INTO `wp_postmeta` VALUES("13467", "81026", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13468", "81027", "url_article", "http://vidasana.org/noticias/cerveza-gabarrera-la-unica-cerveza-ecologica-de-madrid");
INSERT INTO `wp_postmeta` VALUES("13469", "81027", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13470", "81028", "url_article", "http://vidasana.org/noticias/hotel-de-insectos-complices-biologicos-en-la-agricultura");
INSERT INTO `wp_postmeta` VALUES("13471", "81028", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13472", "81029", "url_article", "http://vidasana.org/noticias/ecoconcinciate-un-proyecto-holistico-desde-el-moncayo");
INSERT INTO `wp_postmeta` VALUES("13473", "81029", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13474", "81030", "url_article", "http://vidasana.org/noticias/happy-foods-comida-ecologica-y-sabrosa-desde-una-foodtruck");
INSERT INTO `wp_postmeta` VALUES("13475", "81030", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13476", "81031", "url_article", "http://vidasana.org/noticias/higia-eco-limpieza-limpia");
INSERT INTO `wp_postmeta` VALUES("13477", "81031", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13478", "81032", "url_article", "http://vidasana.org/noticias/cncer-agentes-peligrosos-en-chocolates-de-conocidas-marcas");
INSERT INTO `wp_postmeta` VALUES("13479", "81032", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13480", "81033", "url_article", "http://vidasana.org/noticias/bio-valsan-cosmetica-con-certificacion");
INSERT INTO `wp_postmeta` VALUES("13481", "81033", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13482", "81034", "url_article", "http://vidasana.org/noticias/disruptores-endocrinos-contaminantes-en-el-agua-de-beber");
INSERT INTO `wp_postmeta` VALUES("13483", "81034", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13484", "81035", "url_article", "http://vidasana.org/noticias/biocop-nueva-gama-de-compotas-veganas-y-sin-azucar");
INSERT INTO `wp_postmeta` VALUES("13485", "81035", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13488", "81037", "url_article", "http://www.ainia.es/sectores-industriales/packaging/nuevos-materiales-envasado-innovadores/");
INSERT INTO `wp_postmeta` VALUES("13489", "81037", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13490", "81038", "url_article", "http://www.ainia.es/sectores-industriales/packaging/optimizacion-sistemas-envasado-materiales/");
INSERT INTO `wp_postmeta` VALUES("13491", "81038", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13492", "81039", "url_article", "http://www.ainia.es/sectores-industriales/farmacia/diseno-higienico-equipos-instalaciones/");
INSERT INTO `wp_postmeta` VALUES("13493", "81039", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13498", "80980", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("13499", "80980", "_edit_lock", "1519211865:1");
INSERT INTO `wp_postmeta` VALUES("13503", "81044", "_edit_lock", "1519212006:2");
INSERT INTO `wp_postmeta` VALUES("13504", "81044", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("13506", "81007", "_edit_lock", "1519202029:1");
INSERT INTO `wp_postmeta` VALUES("13507", "80979", "_edit_lock", "1519211948:2");
INSERT INTO `wp_postmeta` VALUES("13508", "81046", "proyecto", "");
INSERT INTO `wp_postmeta` VALUES("13509", "81046", "_proyecto", "field_543674dbefeba");
INSERT INTO `wp_postmeta` VALUES("13510", "80980", "proyecto", "");
INSERT INTO `wp_postmeta` VALUES("13511", "80980", "_proyecto", "field_543674dbefeba");
INSERT INTO `wp_postmeta` VALUES("13512", "80979", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("13515", "81047", "proyecto", "");
INSERT INTO `wp_postmeta` VALUES("13516", "81047", "_proyecto", "field_543674dbefeba");
INSERT INTO `wp_postmeta` VALUES("13517", "80979", "_wp_old_slug", "2018-02-20--ainia-packaging-alegaciones-saludables-");
INSERT INTO `wp_postmeta` VALUES("13518", "80979", "proyecto", "");
INSERT INTO `wp_postmeta` VALUES("13519", "80979", "_proyecto", "field_543674dbefeba");
INSERT INTO `wp_postmeta` VALUES("13530", "81050", "url_article", "http://feeds.ainia.es/~r/ainia-Tecnoalimentalia/~3/L8K5tOQ3PWU/");
INSERT INTO `wp_postmeta` VALUES("13531", "81050", "interes", "0");
INSERT INTO `wp_postmeta` VALUES("13532", "81051", "url_article", "http://www.fao.org/news/story/en/item/1073732/icode/");
INSERT INTO `wp_postmeta` VALUES("13533", "81051", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13534", "81052", "url_article", "http://feeds.ainia.es/~r/ainia-Tecnoalimentalia/~3/8uVDnO251XI/");
INSERT INTO `wp_postmeta` VALUES("13535", "81052", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13536", "81053", "url_article", "http://www.fao.org/news/story/es/item/1098356/icode/");
INSERT INTO `wp_postmeta` VALUES("13537", "81053", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13538", "81054", "url_article", "http://www.fao.org/news/story/en/item/1071870/icode/");
INSERT INTO `wp_postmeta` VALUES("13539", "81054", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13540", "81055", "url_article", "http://www.fao.org/news/story/es/item/1072082/icode/");
INSERT INTO `wp_postmeta` VALUES("13541", "81055", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13542", "81056", "url_article", "http://panypizza.com/panorama/medidas-mas-estrictas-los-materiales-contacto-los-alimentos/");
INSERT INTO `wp_postmeta` VALUES("13543", "81056", "interes", "0");
INSERT INTO `wp_postmeta` VALUES("13544", "81056", "_edit_lock", "1520409288:5");
INSERT INTO `wp_postmeta` VALUES("13549", "81059", "url_article", "http://feeds.ainia.es/~r/ainia-Comunidad_Gestion_del_Conocimiento/~3/GJTwUcwF0QU/la-economia-circular:-sumate-a-la-proxima-revolucion-global");
INSERT INTO `wp_postmeta` VALUES("13550", "81059", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13563", "81064", "url_article", "https://www.kantarworldpanel.com/es/Noticias/La-cesta-de-la-compra-online-crece-un-32-en-espana");
INSERT INTO `wp_postmeta` VALUES("13564", "81064", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13565", "81065", "url_article", "https://www.kantarworldpanel.com/es/Noticias/el-gran-consumo-crece-un-13-en-2017");
INSERT INTO `wp_postmeta` VALUES("13566", "81065", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13567", "81066", "url_article", "https://www.industriaalimenticia.com/articles/89230-coca-cola-anuncia-vision-global-de-reciclaje-para-el-ano-2030");
INSERT INTO `wp_postmeta` VALUES("13568", "81066", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13569", "81067", "url_article", "https://www.kantarworldpanel.com/es/Noticias/Tendencias-en-la-distribucion-2017");
INSERT INTO `wp_postmeta` VALUES("13570", "81067", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13571", "81068", "url_article", "https://www.kantarworldpanel.com/es/Noticias/Mercadona-bate-su-record-en-el-primer-trimestre");
INSERT INTO `wp_postmeta` VALUES("13572", "81068", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13573", "81069", "url_article", "https://www.kantarworldpanel.com/es/Noticias/Cada-hogar-compra-274-referencias-de-Gran-Consumo");
INSERT INTO `wp_postmeta` VALUES("13574", "81069", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13575", "81070", "url_article", "https://www.kantarworldpanel.com/es/Noticias/Mercadona-y-Lidl-empiezan-el-ano-mas-lideres");
INSERT INTO `wp_postmeta` VALUES("13576", "81070", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13579", "81072", "url_article", "https://www.kantarworldpanel.com/es/Noticias/Mercadona-Carrefour-y-Lidl-crecen-en-octubre");
INSERT INTO `wp_postmeta` VALUES("13580", "81072", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13581", "81073", "url_article", "https://www.kantarworldpanel.com/es/Noticias/Las-comidas-principales-impulsan-el-consumo-fuera-del-hogar");
INSERT INTO `wp_postmeta` VALUES("13582", "81073", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13583", "81074", "url_article", "https://www.kantarworldpanel.com/es/Noticias/El-ecommerce-global-en-gran-consumo-crece-un-15-por-ciento");
INSERT INTO `wp_postmeta` VALUES("13584", "81074", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13585", "81075", "url_article", "https://www.kantarworldpanel.com/es/Noticias/Crece-el-consumo-de-bebidas-y-snacks-en-el-trabajo");
INSERT INTO `wp_postmeta` VALUES("13586", "81075", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13587", "81076", "url_article", "https://www.kantarworldpanel.com/es/Noticias/El-Gran-Consumo-se-estabiliza-en-el-segundo-trimestre-cuotas-distribucion-junio");
INSERT INTO `wp_postmeta` VALUES("13588", "81076", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13591", "81078", "url_article", "https://www.kantarworldpanel.com/es/Noticias/Lidl-y-Grupo-DIA-baten-records-de-cuota-en-primavera");
INSERT INTO `wp_postmeta` VALUES("13592", "81078", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13593", "81079", "url_article", "https://www.industriaalimenticia.com/articles/89221-mcdonalds-se-vuelve-verde");
INSERT INTO `wp_postmeta` VALUES("13594", "81079", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13597", "81081", "url_article", "https://www.kantarworldpanel.com/es/Noticias/gran-consumo-cae-primer-trimestre-2016-cuotas-distribucion");
INSERT INTO `wp_postmeta` VALUES("13598", "81081", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13599", "81082", "url_article", "https://www.industriaalimenticia.com/articles/89033-el-futuro-del-empaque-para-america");
INSERT INTO `wp_postmeta` VALUES("13600", "81082", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13601", "81083", "url_article", "https://www.industriaalimenticia.com/articles/89266-la-tecnologia-tetra-pak-tambien-protege-al-planeta");
INSERT INTO `wp_postmeta` VALUES("13602", "81083", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13603", "81084", "url_article", "https://www.industriaalimenticia.com/articles/89012-las-tres-tendencias-emergentes-que-afectan-al-mercado-global-de-pel%C3%ADculas-de-barrera-transparente-en-empaques");
INSERT INTO `wp_postmeta` VALUES("13604", "81084", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13605", "81085", "url_article", "https://www.industriaalimenticia.com/articles/89232-el-empaque-del-guacamole");
INSERT INTO `wp_postmeta` VALUES("13606", "81085", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13607", "81086", "url_article", "https://www.industriaalimenticia.com/articles/89231-los-procesadores-de-confiter%C3%ADa-y-panader%C3%ADas-buscan-m%C3%A1s-en-m%C3%A1quinas-de-rebanado-corte-y-porci%C3%B3n");
INSERT INTO `wp_postmeta` VALUES("13608", "81086", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13609", "81087", "url_article", "https://www.industriaalimenticia.com/articles/89271-le-gustaria-ser-asesorado-por-un-grupo-de-profesionales-en-innovacion-en-envases-plasticos");
INSERT INTO `wp_postmeta` VALUES("13610", "81087", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13611", "81088", "url_article", "https://www.kantarworldpanel.com/es/Noticias/El-Gran-Consumo-vuelve-a-crecer-en-el-primer-semestre");
INSERT INTO `wp_postmeta` VALUES("13612", "81088", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13613", "81089", "url_article", "https://www.kantarworldpanel.com/es/Noticias/Los-hogares-espanoles-pagan-mas-por-los-productos-frescos");
INSERT INTO `wp_postmeta` VALUES("13614", "81089", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13615", "81090", "url_article", "https://www.kantarworldpanel.com/es/Noticias/Buenas-perspectivas-Gran-Consumo-2015");
INSERT INTO `wp_postmeta` VALUES("13616", "81090", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13617", "81091", "url_article", "https://www.industriaalimenticia.com/articles/89212-crown-y-eklo-traen-la-primera-agua-con-sabor-empacado-en-latas-a-brasil");
INSERT INTO `wp_postmeta` VALUES("13618", "81091", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13619", "81092", "url_article", "https://www.kantarworldpanel.com/es/Noticias/Surtido-en-el-sector-del-Gran-Consumo-en-Espaa");
INSERT INTO `wp_postmeta` VALUES("13620", "81092", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13621", "81093", "url_article", "https://www.industriaalimenticia.com/articles/89204-sistema-de-selecci%C3%B3n-y-medici%C3%B3n-de-chips-descubra-una-nueva-tapa-y-m%C3%A1s");
INSERT INTO `wp_postmeta` VALUES("13622", "81093", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13623", "81094", "url_article", "https://www.kantarworldpanel.com/es/Noticias/Rio-revuelto-en-Gran-Consumo");
INSERT INTO `wp_postmeta` VALUES("13624", "81094", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13627", "81096", "url_article", "https://www.kantarworldpanel.com/es/Noticias/387-euros-por-hogar-en-alimentacin-en-Navidad");
INSERT INTO `wp_postmeta` VALUES("13628", "81096", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13629", "81097", "url_article", "https://www.kantarworldpanel.com/es/Noticias/balancecongelados");
INSERT INTO `wp_postmeta` VALUES("13630", "81097", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13631", "81098", "url_article", "https://www.kantarworldpanel.com/es/Noticias/gran-consumo-primer-semestre-2013");
INSERT INTO `wp_postmeta` VALUES("13632", "81098", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13633", "81099", "url_article", "https://www.kantarworldpanel.com/es/Noticias/balance2013");
INSERT INTO `wp_postmeta` VALUES("13634", "81099", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13635", "81100", "url_article", "https://www.kantarworldpanel.com/es/Noticias/La-inflacin-propicia-crecimientos-en-el-arranque-de-ao-para-el-Gran-Consumo");
INSERT INTO `wp_postmeta` VALUES("13636", "81100", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13637", "81101", "url_article", "https://www.kantarworldpanel.com/es/Noticias/comodidad-sabor-retos-productos-mar");
INSERT INTO `wp_postmeta` VALUES("13638", "81101", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13639", "81102", "url_article", "https://www.kantarworldpanel.com/es/Noticias/La-alimentacin-factura-un-1-menos-estas-Navidades-");
INSERT INTO `wp_postmeta` VALUES("13640", "81102", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13641", "81103", "url_article", "https://www.kantarworldpanel.com/es/Noticias/Gastamos-1300-menos-en-Gran-Consumo-que-antes-de-la-crisis-");
INSERT INTO `wp_postmeta` VALUES("13642", "81103", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13643", "81104", "url_article", "https://www.kantarworldpanel.com/es/Noticias/Seniors-Ms-frescos-ms-especialistas-y-menos-MDD");
INSERT INTO `wp_postmeta` VALUES("13644", "81104", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13645", "81105", "url_article", "https://www.kantarworldpanel.com/es/Noticias/El-consumidor-cree-que-su-cesta-se-ha-encarecido-con-el-nuevo-IVA");
INSERT INTO `wp_postmeta` VALUES("13646", "81105", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13647", "81106", "url_article", "https://www.kantarworldpanel.com/es/Noticias/Recuperacion-contenida-Gran-Consumo-primer-semestre");
INSERT INTO `wp_postmeta` VALUES("13648", "81106", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13649", "81107", "url_article", "https://www.kantarworldpanel.com/es/Noticias/La-inflacin-contina-frenando-el-consumo-y-propiciando-el-downtrading");
INSERT INTO `wp_postmeta` VALUES("13650", "81107", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13651", "81108", "url_article", "https://www.kantarworldpanel.com/es/Noticias/El-Gran-Consumo-crece-un-17-en-valor-y-un-11-en-volumen-en-2011-");
INSERT INTO `wp_postmeta` VALUES("13652", "81108", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13653", "81109", "url_article", "https://www.kantarworldpanel.com/es/Noticias/compra-online-531-millones");
INSERT INTO `wp_postmeta` VALUES("13654", "81109", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13655", "81110", "url_article", "https://www.kantarworldpanel.com/es/Noticias/369-euros-alimentacion-Navidad");
INSERT INTO `wp_postmeta` VALUES("13656", "81110", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13657", "81111", "url_article", "https://www.industriaalimenticia.com/articles/89094-equipos-de-formado-llenado-y-sellado");
INSERT INTO `wp_postmeta` VALUES("13658", "81111", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13659", "81112", "url_article", "https://www.kantarworldpanel.com/es/Noticias/La-demanda-de-bienes-cotidianos-se-frenar-en-2012-");
INSERT INTO `wp_postmeta` VALUES("13660", "81112", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13661", "81113", "url_article", "https://www.kantarworldpanel.com/es/Noticias/inflacion-enmascara-crecimiento-Gran-Consumo-");
INSERT INTO `wp_postmeta` VALUES("13662", "81113", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13663", "81114", "url_article", "https://www.kantarworldpanel.com/es/Noticias/Se-estabiliza-la-demanda-de-productos-de-Gran-Consumo-en-el-primer-cuatrimestre");
INSERT INTO `wp_postmeta` VALUES("13664", "81114", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13665", "81115", "url_article", "https://www.kantarworldpanel.com/es/Noticias/Gran-Consumo-cierra-el-primer-semestre-en-positivo");
INSERT INTO `wp_postmeta` VALUES("13666", "81115", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13667", "81116", "url_article", "https://www.kantarworldpanel.com/es/Noticias/Gran-Consumo-cierra-2010-con-las-primeras-caidas");
INSERT INTO `wp_postmeta` VALUES("13668", "81116", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13669", "81117", "url_article", "https://www.kantarworldpanel.com/es/Noticias/Uno-de-cada-cinco-hogares-compra-por-Internet-");
INSERT INTO `wp_postmeta` VALUES("13670", "81117", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13671", "81118", "url_article", "https://www.industriaalimenticia.com/articles/89195-la-directriz-clave-de-alimentos-para-2018");
INSERT INTO `wp_postmeta` VALUES("13672", "81118", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13673", "81119", "url_article", "https://www.industriaalimenticia.com/articles/86082-nueva-enfardadora-meximaq");
INSERT INTO `wp_postmeta` VALUES("13674", "81119", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13675", "81120", "url_article", "https://www.industriaalimenticia.com/articles/89098-espirulina-azul-un-%C3%A9xito-que-no-conoce-l%C3%ADmites-l%C3%ADnea-de-stevia-natural-y-baja-en-calor%C3%ADas-y-m%C3%A1s");
INSERT INTO `wp_postmeta` VALUES("13676", "81120", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13677", "81121", "url_article", "https://www.industriaalimenticia.com/articles/89001-las-%C3%BAltimas-innovaciones-de-equipos-de-proceso");
INSERT INTO `wp_postmeta` VALUES("13678", "81121", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13679", "81122", "url_article", "https://www.industriaalimenticia.com/articles/88940-los-consumidores-anhelan-s%C3%BAper-alimentos-frutos-y-granos");
INSERT INTO `wp_postmeta` VALUES("13680", "81122", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13681", "81123", "url_article", "https://www.industriaalimenticia.com/articles/89000-el-arte-de-la-flexibilidad");
INSERT INTO `wp_postmeta` VALUES("13682", "81123", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13683", "81124", "url_article", "https://www.industriaalimenticia.com/articles/89091-prosweets-cologne-2018-se-posiciona-con-una-gran-diversidad-de-oferta");
INSERT INTO `wp_postmeta` VALUES("13684", "81124", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13689", "81127", "url_article", "https://www.industriaalimenticia.com/articles/85836-los-expertos-tienen-la-palabra");
INSERT INTO `wp_postmeta` VALUES("13690", "81127", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13691", "81128", "url_article", "http://www.revistalatahona.com/2018/02/retraso-cobro-bolsas-plastico-comercios-verano/");
INSERT INTO `wp_postmeta` VALUES("13692", "81128", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13723", "81144", "url_article", "http://vidasana.org/noticias/e-brumecozema-plasticos-organicos-compostables");
INSERT INTO `wp_postmeta` VALUES("13724", "81144", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("13994", "81144", "_edit_lock", "1520420246:5");
INSERT INTO `wp_postmeta` VALUES("13998", "81244", "proyecto", "");
INSERT INTO `wp_postmeta` VALUES("13999", "81244", "_proyecto", "field_543674dbefeba");
INSERT INTO `wp_postmeta` VALUES("14000", "81144", "_edit_last", "5");
INSERT INTO `wp_postmeta` VALUES("14003", "81245", "proyecto", "");
INSERT INTO `wp_postmeta` VALUES("14004", "81245", "_proyecto", "field_543674dbefeba");
INSERT INTO `wp_postmeta` VALUES("14005", "81144", "proyecto", "");
INSERT INTO `wp_postmeta` VALUES("14006", "81144", "_proyecto", "field_543674dbefeba");
INSERT INTO `wp_postmeta` VALUES("14008", "81247", "url_article", "https://www.industriaalimenticia.com/articles/89143-dos-pinos-y-tetra-pak-introducen-al-mercado-envases-con-certificacion-del-fsc");
INSERT INTO `wp_postmeta` VALUES("14009", "81247", "interes", "0");
INSERT INTO `wp_postmeta` VALUES("14010", "81248", "url_article", "https://www.industriaalimenticia.com/articles/89134-andina-pack-2017-posicionada-como-la-feria-lider-del-sector-de-procesamiento-y-empaques-para-la-region-andina-y-centroamerica");
INSERT INTO `wp_postmeta` VALUES("14011", "81248", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14012", "81249", "url_article", "https://www.industriaalimenticia.com/articles/89133-los-empaques-case-ready-ayudan-a-los-minoristas-a-volverse-mas-competitivos");
INSERT INTO `wp_postmeta` VALUES("14013", "81249", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14014", "81250", "url_article", "http://feeds.ainia.es/~r/ainia-Tecnoalimentalia/~3/vUW0p2NFcMk/");
INSERT INTO `wp_postmeta` VALUES("14015", "81250", "interes", "16");
INSERT INTO `wp_postmeta` VALUES("14016", "81251", "url_article", "https://www.industriaalimenticia.com/articles/89116-colombia-empaca-con-insumos-de-brasil");
INSERT INTO `wp_postmeta` VALUES("14017", "81251", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14022", "81254", "url_article", "http://www.ainia.es/tecnoalimentalia/consumidor/tendencias-packaging-cosmeticos/");
INSERT INTO `wp_postmeta` VALUES("14023", "81254", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14024", "81255", "url_article", "http://www.ainia.es/tecnoalimentalia/consumidor/tendencias-packaging-cosmeticos/#respond");
INSERT INTO `wp_postmeta` VALUES("14025", "81255", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14026", "81256", "url_article", "https://www.industriaalimenticia.com/articles/89202-las-ventajas-del-empaque-as%C3%A9ptico");
INSERT INTO `wp_postmeta` VALUES("14027", "81256", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14028", "81257", "url_article", "https://www.industriaalimenticia.com/articles/89254-cargill-lanza-salsa-de-tomate-en-mini-sache");
INSERT INTO `wp_postmeta` VALUES("14029", "81257", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14172", "81255", "_edit_lock", "1520503423:5");
INSERT INTO `wp_postmeta` VALUES("14173", "81254", "_edit_lock", "1520525485:5");
INSERT INTO `wp_postmeta` VALUES("14174", "81255", "_edit_last", "5");
INSERT INTO `wp_postmeta` VALUES("14175", "81254", "_edit_last", "5");
INSERT INTO `wp_postmeta` VALUES("14383", "81250", "_edit_lock", "1520524782:5");
INSERT INTO `wp_postmeta` VALUES("14391", "81396", "proyecto", "");
INSERT INTO `wp_postmeta` VALUES("14392", "81396", "_proyecto", "field_543674dbefeba");
INSERT INTO `wp_postmeta` VALUES("14393", "81254", "proyecto", "");
INSERT INTO `wp_postmeta` VALUES("14394", "81254", "_proyecto", "field_543674dbefeba");
INSERT INTO `wp_postmeta` VALUES("14395", "81397", "url_article", "https://www.alimarket.es/alimentacion/noticia/264269/las-exportaciones-de-vinos-espanoles-ganan-valor");
INSERT INTO `wp_postmeta` VALUES("14396", "81397", "interes", "0");
INSERT INTO `wp_postmeta` VALUES("14397", "81398", "url_article", "http://www.revistaaral.com/es/notices/2018/03/el-mercado-de-carnicos-crecio-un-4-en-2017-79359.php");
INSERT INTO `wp_postmeta` VALUES("14398", "81398", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14399", "81399", "url_article", "https://www.alimarket.es/alimentacion/noticia/264384/alejandro-cabal--tetra-pak----este-ano-veremos-los-primeros-envases-inteligentes-en-espana-");
INSERT INTO `wp_postmeta` VALUES("14400", "81399", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14401", "81400", "url_article", "http://www.ainia.es/tecnoalimentalia/tecnologia/economia-circular-agua/#respond");
INSERT INTO `wp_postmeta` VALUES("14402", "81400", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14403", "81401", "url_article", "http://www.ainia.es/tecnoalimentalia/tecnologia/economia-circular-agua/");
INSERT INTO `wp_postmeta` VALUES("14404", "81401", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14405", "81402", "url_article", "http://www.ainia.es/soluciones-tecnologicas/medioambiente-energia-agua/");
INSERT INTO `wp_postmeta` VALUES("14406", "81402", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14407", "81403", "url_article", "http://panypizza.com/tecnica/normas-debo-cumplir-evitar-reclamaciones-establecimiento/");
INSERT INTO `wp_postmeta` VALUES("14408", "81403", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("14409", "81404", "url_article", "http://profesionalhoreca.com/hostelco-2018-reflejo-del-crecimiento-del-equipamiento-hostelero/");
INSERT INTO `wp_postmeta` VALUES("14410", "81404", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("14411", "81405", "url_article", "http://www.ainia.es/insights/");
INSERT INTO `wp_postmeta` VALUES("14412", "81405", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14413", "81406", "url_article", "http://www.artesblancas.com/se-abre-registro-para-el-evento-mas-grande-de-envasado-y-procesamiento-de-latinoamerica/");
INSERT INTO `wp_postmeta` VALUES("14414", "81406", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14415", "81405", "_edit_lock", "1520839770:5");
INSERT INTO `wp_postmeta` VALUES("14416", "81407", "url_article", "http://btcces.com/la-precariedad-laboral-aumenta-el-numero-de-accidentes-laborales-en-2017/");
INSERT INTO `wp_postmeta` VALUES("14417", "81407", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14418", "81408", "url_article", "http://ide-e.com/wp/release-liner-industry-leadership-mondis-dr-wilhelm-munninger-wins-the-awa-award/");
INSERT INTO `wp_postmeta` VALUES("14419", "81408", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14420", "81409", "url_article", "http://btcces.com/etiquetastrampa-la-ocu-vuelve-a-alertar-de-que-el-etiquetado-de-los-productos-alimenticios-nos-quiere-enganar/");
INSERT INTO `wp_postmeta` VALUES("14421", "81409", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14422", "81410", "url_article", "http://ide-e.com/wp/el-material-para-caras-fusion-de-sappi-ofrece-resultados-excepcionales/");
INSERT INTO `wp_postmeta` VALUES("14423", "81410", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("14424", "81411", "url_article", "http://ide-e.com/wp/kodak-da-un-paso-adelante-con-la-introduccion-de-las-planchas-sin-procesado-sonora-x/");
INSERT INTO `wp_postmeta` VALUES("14425", "81411", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("14426", "81412", "url_article", "http://www.consumer.es/web/es/medio_ambiente/naturaleza/2017/11/30/225680.php?utm_source=feedburner&utm_medium=feed&utm_campaign=eroski-consumer%2Fmedio-ambiente");
INSERT INTO `wp_postmeta` VALUES("14427", "81412", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14428", "81413", "url_article", "http://ide-e.com/wp/las-aceitunas-disfrutan-de-una-larga-vida-gracias-al-envase-longlife/");
INSERT INTO `wp_postmeta` VALUES("14429", "81413", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("14430", "81414", "url_article", "http://www.cnta.es/investigacion/colaboraciones.php");
INSERT INTO `wp_postmeta` VALUES("14431", "81414", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("14432", "81415", "url_article", "http://ide-e.com/wp/la-nueva-directiva-obligara-a-todos-los-envases-agrarios-a-ser-reciclados-antes-de-2-025/");
INSERT INTO `wp_postmeta` VALUES("14433", "81415", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("14434", "81416", "url_article", "http://www.consumer.es/web/es/medio_ambiente/urbano/2017/10/19/225595.php?utm_source=feedburner&utm_medium=feed&utm_campaign=eroski-consumer%2Fmedio-ambiente");
INSERT INTO `wp_postmeta` VALUES("14435", "81416", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14436", "81417", "url_article", "http://www.cnta.es/investigacion/lineas-investigacion.php");
INSERT INTO `wp_postmeta` VALUES("14437", "81417", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14438", "81418", "url_article", "http://www.mapama.gob.es/es/prensa/agenda/agenda-din.aspx?tcm=tcm:7-477659-16");
INSERT INTO `wp_postmeta` VALUES("14439", "81418", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14440", "81419", "url_article", "https://www.macrumors.com/2018/03/12/apple-usb-c-ports-mfi-program/");
INSERT INTO `wp_postmeta` VALUES("14441", "81419", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14442", "81420", "url_article", "http://www.microsiervos.com/archivo/gadgets/notas-post-it-condiciones-extremas.html");
INSERT INTO `wp_postmeta` VALUES("14443", "81420", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14444", "81421", "url_article", "http://www.cnta.es/blog");
INSERT INTO `wp_postmeta` VALUES("14445", "81421", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("14446", "81422", "url_article", "http://ide-e.com/wp/sappi-guard-protege-el-te-de-alta-calidad-de-teegschwendner/");
INSERT INTO `wp_postmeta` VALUES("14447", "81422", "interes", "14");
INSERT INTO `wp_postmeta` VALUES("14448", "81423", "url_article", "http://feeds.ainia.es/~r/ainia-Tecnoalimentalia/~3/8mj4bY3qqRw/");
INSERT INTO `wp_postmeta` VALUES("14449", "81423", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("14450", "81424", "url_article", "http://www.consumer.es/web/es/medio_ambiente/2012/07/13/211305.php?utm_source=feedburner&utm_medium=feed&utm_campaign=eroski-consumer%2Fnoticias");
INSERT INTO `wp_postmeta` VALUES("14451", "81424", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14452", "81425", "url_article", "https://www.macrumors.com/2018/03/12/philips-hue-outdoor-lighting-july/");
INSERT INTO `wp_postmeta` VALUES("14453", "81425", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("14454", "81426", "url_article", "https://www.macrumors.com/2018/03/12/apple-updates-made-for-iphone-ipad-ipod-logos/");
INSERT INTO `wp_postmeta` VALUES("14455", "81426", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14456", "81427", "url_article", "http://www.madrimasd.org/blogs/demadridaeuropa/2017/10/27/132448");
INSERT INTO `wp_postmeta` VALUES("14457", "81427", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14458", "81428", "url_article", "http://www.madrimasd.org/blogs/energiasalternativas/2017/10/26/133666");
INSERT INTO `wp_postmeta` VALUES("14459", "81428", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14460", "81429", "url_article", "http://www.madrimasd.org/blogs/energiasalternativas/2017/10/20/133648");
INSERT INTO `wp_postmeta` VALUES("14461", "81429", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14462", "81430", "url_article", "http://www.itene.com/blog/i/3870/239/tendencias-de-envase-para-evitar-el-desperdicio-alimentario-y-facilitar-la-reduccion-de-residuos");
INSERT INTO `wp_postmeta` VALUES("14463", "81430", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("14464", "81431", "url_article", "http://www.itene.com/eventos/i/11864/58/itene-asistira-a-la-17-edicion-de-hispack-2018");
INSERT INTO `wp_postmeta` VALUES("14465", "81431", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14466", "81432", "url_article", "http://www.itene.com/blog/i/9233/239/mejora-de-resultados-en-e-commerce-con-envase-y-logistica");
INSERT INTO `wp_postmeta` VALUES("14467", "81432", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14468", "81433", "url_article", "http://www.itene.com/blog/i/4006/239/el-consumidor-clave-en-el-lanzamiento-de-nuevos-productos-y-envases-al-mercado");
INSERT INTO `wp_postmeta` VALUES("14469", "81433", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14470", "81434", "url_article", "http://www.itene.com/blog/i/4007/239/tendencias-en-envases-para-cosmetica");
INSERT INTO `wp_postmeta` VALUES("14471", "81434", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("14472", "81435", "url_article", "https://webgate.ec.europa.eu/rasff-window/portal/index.cfm?event=DetailsToXML&NOTIF_REFERENCE=2018.0606");
INSERT INTO `wp_postmeta` VALUES("14473", "81435", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14474", "81436", "url_article", "http://www.itene.com/sala-de-prensa/recursos-multimedia/fotografias/i/690/250/embalaje-ulysses");
INSERT INTO `wp_postmeta` VALUES("14475", "81436", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14476", "81437", "url_article", "http://www.itene.com/sala-de-prensa/recursos-multimedia/fotografias/i/389/250/envase-inteligente");
INSERT INTO `wp_postmeta` VALUES("14477", "81437", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14478", "81438", "url_article", "http://www.itene.com/proyectos-de-difusion-abierta/i/11676/56/biosmart");
INSERT INTO `wp_postmeta` VALUES("14479", "81438", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14480", "81439", "url_article", "http://www.itene.com/sala-de-prensa/recursos-multimedia/videos/i/12028/88/validanano");
INSERT INTO `wp_postmeta` VALUES("14481", "81439", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14482", "81440", "url_article", "http://www.itene.com/sala-de-prensa/notas-de-prensa/i/12056/60/itene-trabaja-en-el-desarrollo-de-nuevos-indicadores-inteligentes-para-monitorizar-productos-envasados");
INSERT INTO `wp_postmeta` VALUES("14483", "81440", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14484", "81441", "url_article", "http://www.itene.com/sala-de-prensa/recursos-multimedia/videos/i/11892/88/chickenpack");
INSERT INTO `wp_postmeta` VALUES("14485", "81441", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14486", "81442", "url_article", "http://www.itene.com/sala-de-prensa/notas-de-prensa/i/12010/60/itene-trabaja-en-un-nuevo-envase-antimicrobiano-para-frutas-y-hortalizas");
INSERT INTO `wp_postmeta` VALUES("14487", "81442", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14488", "81443", "url_article", "http://www.itene.com/sala-de-prensa/recursos-multimedia/videos/i/11882/88/childbiopack");
INSERT INTO `wp_postmeta` VALUES("14489", "81443", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14490", "81444", "url_article", "http://www.itene.com/sala-de-prensa/recursos-multimedia/fotografias/i/385/250/planta-piloto-de-envasado");
INSERT INTO `wp_postmeta` VALUES("14491", "81444", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14492", "81445", "url_article", "http://www.itene.com/sala-de-prensa/recursos-multimedia/videos/i/11805/88/pack4microsuscep");
INSERT INTO `wp_postmeta` VALUES("14493", "81445", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14494", "81446", "url_article", "http://www.itene.com/sala-de-prensa/recursos-multimedia/fotografias/i/384/250/laboratorio-de-caracterizacion-de-materiales");
INSERT INTO `wp_postmeta` VALUES("14495", "81446", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14496", "81447", "url_article", "http://www.itene.com/sala-de-prensa/notas-de-prensa/i/11996/60/vitrans-contribuye-a-reducir-perdidas-de-mercancias-por-una-deficiente-estabilidad-de-las-cargas");
INSERT INTO `wp_postmeta` VALUES("14497", "81447", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14498", "81448", "url_article", "http://www.itene.com/proyectos-de-difusion-abierta/i/11675/56/plasticircle");
INSERT INTO `wp_postmeta` VALUES("14499", "81448", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14500", "81449", "url_article", "http://www.itene.com/blog/i/1822/239/el-envase-farmaceutico");
INSERT INTO `wp_postmeta` VALUES("14501", "81449", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14502", "81450", "url_article", "http://www.itene.com/sala-de-prensa/recursos-multimedia/fotografias/i/383/250/centro-de-simulacion-de-riesgos-transporte");
INSERT INTO `wp_postmeta` VALUES("14503", "81450", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14504", "81451", "url_article", "http://www.itene.com/blog/i/1313/239/innovacion-en-envase-para-aumentar-el-valor-del-sector-del-vino");
INSERT INTO `wp_postmeta` VALUES("14505", "81451", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14506", "81452", "url_article", "http://feeds.weblogssl.com/~r/Vitonica/~3/yFw7NxADslc/desnudalafruta-o-por-que-la-fruta-no-necesita-venderse-en-una-bandeja-envuelta-en-plastico");
INSERT INTO `wp_postmeta` VALUES("14507", "81452", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("14508", "81453", "url_article", "http://www.itene.com/blog/i/1015/239/las-10-claves-que-definen-el-futuro-del-envase");
INSERT INTO `wp_postmeta` VALUES("14509", "81453", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14510", "81454", "url_article", "http://esic.edu/actualidad/valencia-esic-participa-en-el-focus-pyme-y-emprendimiento-comunidad-valenciana/");
INSERT INTO `wp_postmeta` VALUES("14511", "81454", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14512", "81455", "url_article", "http://www.itene.com/sala-de-prensa/notas-de-prensa/i/11916/60/innovador-envase-que-calienta-de-forma-homogenea-platos-preparados-saludables-para-ninos");
INSERT INTO `wp_postmeta` VALUES("14513", "81455", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14514", "81456", "url_article", "http://www.itene.com/proyectos-de-difusion-abierta/i/11672/56/agrimax");
INSERT INTO `wp_postmeta` VALUES("14515", "81456", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14516", "81457", "url_article", "http://www.itene.com/sala-de-prensa/recursos-multimedia/videos/i/11147/88/actienvas");
INSERT INTO `wp_postmeta` VALUES("14517", "81457", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14518", "81458", "url_article", "http://www.itene.com/proyectos-de-difusion-abierta/i/11679/56/pack4microsuscep");
INSERT INTO `wp_postmeta` VALUES("14519", "81458", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14520", "81459", "url_article", "http://www.itene.com/sala-de-prensa/recursos-multimedia/videos/i/7765/88/itene-en-hispack-bta-2015");
INSERT INTO `wp_postmeta` VALUES("14521", "81459", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14522", "81460", "url_article", "http://www.itene.com/proyectos-de-difusion-abierta/i/11677/56/frutapack");
INSERT INTO `wp_postmeta` VALUES("14523", "81460", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14524", "81461", "url_article", "http://www.itene.com/proyectos-de-difusion-abierta/i/11632/56/chickenpack");
INSERT INTO `wp_postmeta` VALUES("14525", "81461", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14526", "81462", "url_article", "http://www.itene.com/blog/i/1047/239/hispack-mas-que-una-feria");
INSERT INTO `wp_postmeta` VALUES("14527", "81462", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("14528", "81463", "url_article", "http://www.itene.com/blog/i/1014/239/el-envase-que-viene");
INSERT INTO `wp_postmeta` VALUES("14529", "81463", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14530", "81464", "url_article", "http://www.itene.com/blog/i/1005/239/mil-millones-de-envases");
INSERT INTO `wp_postmeta` VALUES("14531", "81464", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14532", "81465", "url_article", "http://www.itene.com/sala-de-prensa/notas-de-prensa/i/11891/60/itene-desarrolla-nuevos-avances-para-mejorar-la-conservacion-y-seguridad-del-pollo-fresco-envasado");
INSERT INTO `wp_postmeta` VALUES("14533", "81465", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14534", "81466", "url_article", "http://www.itene.com/sala-de-prensa/notas-de-prensa/i/11879/60/itc-aidimme-e-itene-desarrollan-recubrimientos-funcionales-con-el-proyecto-desink");
INSERT INTO `wp_postmeta` VALUES("14535", "81466", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14536", "81467", "url_article", "http://www.itene.com/proyectos-de-difusion-abierta/i/11623/56/sneakpack");
INSERT INTO `wp_postmeta` VALUES("14537", "81467", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14538", "81468", "url_article", "http://www.itene.com/sala-de-prensa/notas-de-prensa/i/11855/60/itene-desarrolla-un-innovador-envase-microondable-que-utiliza-tinta-en-lugar-de-aluminio");
INSERT INTO `wp_postmeta` VALUES("14539", "81468", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14540", "81469", "url_article", "http://www.itene.com/proyectos-de-difusion-abierta/i/11542/56/sherpack");
INSERT INTO `wp_postmeta` VALUES("14541", "81469", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14542", "81470", "url_article", "http://feedproxy.google.com/~r/elblogdelaindustriaalimentaria/~3/7Yz3b24BS4g/");
INSERT INTO `wp_postmeta` VALUES("14543", "81470", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14544", "81471", "url_article", "https://www.alimarket.es/envase/noticia/262618/gaez-afianza-su-apuesta-por-el-valor-anadido-y-la-impresion-digital");
INSERT INTO `wp_postmeta` VALUES("14545", "81471", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14546", "81472", "url_article", "https://webgate.ec.europa.eu/rasff-window/portal/index.cfm?event=DetailsToXML&NOTIF_REFERENCE=2018.0554");
INSERT INTO `wp_postmeta` VALUES("14547", "81472", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14548", "81473", "url_article", "https://webgate.ec.europa.eu/rasff-window/portal/index.cfm?event=DetailsToXML&NOTIF_REFERENCE=2018.0527");
INSERT INTO `wp_postmeta` VALUES("14549", "81473", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14550", "81474", "url_article", "http://news.mit.edu/2018/study-finds-early-signatures-social-brain-0312");
INSERT INTO `wp_postmeta` VALUES("14551", "81474", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("14552", "81475", "url_article", "http://news.mit.edu/2018/mit-whitehead-institute-identifies-unclogger-for-toxic-proteins-in-type-2-diabetes-0308");
INSERT INTO `wp_postmeta` VALUES("14553", "81475", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("14554", "81476", "url_article", "http://feedproxy.google.com/~r/aimme/~3/l2fxgt7eV1k/ficha.asp");
INSERT INTO `wp_postmeta` VALUES("14555", "81476", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14556", "81477", "url_article", "http://feedproxy.google.com/~r/aimme/~3/8l5VNkdvfI8/ficha.asp");
INSERT INTO `wp_postmeta` VALUES("14557", "81477", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14558", "81478", "url_article", "http://feedproxy.google.com/~r/aimme/~3/VemLsTC65TM/ficha.asp");
INSERT INTO `wp_postmeta` VALUES("14559", "81478", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14560", "81479", "url_article", "http://www.alimentatec.com/azti-presenta-las-claves-del-ecodiseno-de-alimentos-como-elemento-competitivo-e-innovador/");
INSERT INTO `wp_postmeta` VALUES("14561", "81479", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14562", "81480", "url_article", "http://www.alimentatec.com/novedades-en-la-legislacion-alimentaria_enero-2016/");
INSERT INTO `wp_postmeta` VALUES("14563", "81480", "interes", "17");
INSERT INTO `wp_postmeta` VALUES("14564", "81481", "url_article", "http://feedproxy.google.com/~r/aimme/~3/NPllRjkcuG8/ficha.asp");
INSERT INTO `wp_postmeta` VALUES("14565", "81481", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14566", "81482", "url_article", "http://rssfeeds.usatoday.com/~/531995124/0/usatoday-newstopstories~Austin-package-explosions-Police-see-similarities-in-deadly-incidents/");
INSERT INTO `wp_postmeta` VALUES("14567", "81482", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14568", "81483", "url_article", "http://www.foodtrendtrotters.com/2016/04/29/los-7-productos-transformados-de-la-pesca-mas-innovadores-del-mundo-seafood-excelence-global-awards-2016-bruselas/");
INSERT INTO `wp_postmeta` VALUES("14569", "81483", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("14570", "81484", "url_article", "http://www.alimentatec.com/la-innovacion-en-materia-medioambiental-es-basica-para-el-sector-de-los-zumos-y-nectares/");
INSERT INTO `wp_postmeta` VALUES("14571", "81484", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("14572", "81485", "url_article", "http://www.ift.org/Food-Technology/Past-Issues/2018/March/Columns/packaging-for-pet-food.aspx");
INSERT INTO `wp_postmeta` VALUES("14573", "81485", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14574", "81486", "url_article", "http://www.distribucionactualidad.com/conoce-las-5-startups-alimentarias-del-programa-aceleracion-food-evolutions/");
INSERT INTO `wp_postmeta` VALUES("14575", "81486", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("14576", "81487", "url_article", "http://ec.europa.eu/newsroom/mare/item-detail.cfm?item_id=612405");
INSERT INTO `wp_postmeta` VALUES("14577", "81487", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14578", "81488", "url_article", "http://www.culturabiotec.com/2012/05/take-the-flour-back-los-gm-cereal-killers-en-concierto/");
INSERT INTO `wp_postmeta` VALUES("14579", "81488", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("14580", "81489", "url_article", "https://www.alimarket.es/envase/noticia/264643/ulma-packaging-supera-previsiones-y-crece-cerca-de-un-10-");
INSERT INTO `wp_postmeta` VALUES("14581", "81489", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14582", "81490", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2018/02/-integrated-industry-lema-de-la-hannover-messe-2018-44831.php");
INSERT INTO `wp_postmeta` VALUES("14583", "81490", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("14584", "81491", "url_article", "https://boletinagrario.com/d2037,aurora-montes-soldado-es-unica-mujer-maestra-molino-subbetica-cordobesa.html");
INSERT INTO `wp_postmeta` VALUES("14585", "81491", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14586", "81492", "url_article", "https://www.alimarket.es/envase/noticia/264644/smurfit-kappa-redisena-el-packaging-de-agua-de-benassal-y-este-logra-mejora-sus-ventas");
INSERT INTO `wp_postmeta` VALUES("14587", "81492", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14588", "81493", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2018/02/un-mayor-hispack-exhibe-la-fuerza-de-la-industria-del-packaging-y-suma-a-su-oferta-proceso-y-logisti-44816.php");
INSERT INTO `wp_postmeta` VALUES("14589", "81493", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("14590", "81494", "url_article", "http://www.marketingnews.es/gran-consumo/noticia/1113203028005/pescanova-continua-lanzando-novedades.1.html?utm_source=rss&utm_medium=feed&utm_campaign=20180312");
INSERT INTO `wp_postmeta` VALUES("14591", "81494", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14592", "81495", "url_article", "http://www.ainia.es/noticias/");
INSERT INTO `wp_postmeta` VALUES("14593", "81495", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14594", "81496", "url_article", "http://fedit.com/2018/03/la-asamblea-general-de-fedit-aprueba-la-incorporacion-a-la-federacion-de-la-red-de-institutos-tecnologicos-de-la-comunidad-valenciana-redit/");
INSERT INTO `wp_postmeta` VALUES("14595", "81496", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("14596", "81497", "url_article", "http://www.levante-emv.com/empresas-en-valencia/2017/07/19/ecovidrio-lleva-decada-trabajando-codo/1595298.html?utm_medium=rss");
INSERT INTO `wp_postmeta` VALUES("14597", "81497", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14598", "81498", "url_article", "http://fedit.com/2018/02/industria-del-calzado-avanza-el-proyecto-europeo-life-ecotex-para-reciclaje-quimico-de-poliester-proveniente-de-residuos/");
INSERT INTO `wp_postmeta` VALUES("14599", "81498", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("14600", "81499", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2018/01/sarai-iborra-sarai.iborra-teamlewis.comsamsung-anuncia-en-ces-2018-la-plataforma-drvline-y-av-44769.php");
INSERT INTO `wp_postmeta` VALUES("14601", "81499", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14602", "81500", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2017/12/rockwell-automation-anuncia-los-ganadores-de-los-premios-anuales-manufacturing-safety-excellence-awa-44755.php");
INSERT INTO `wp_postmeta` VALUES("14603", "81500", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14604", "81501", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2017/11/por-primera-vez-optoforceestara-en-robomatica-de-la-feria-metalmadrid-2017-44708.php");
INSERT INTO `wp_postmeta` VALUES("14605", "81501", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("14606", "81502", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2017/12/alianza-de-universal-robots-y-sick-para-innovar-en-robotica-colaborativa-44749.php");
INSERT INTO `wp_postmeta` VALUES("14607", "81502", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("14608", "81503", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2017/11/rodillos-libres-de-lubricacion-para-los-extremos-de-las-bandas-transportadoras-44699.php");
INSERT INTO `wp_postmeta` VALUES("14609", "81503", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("14610", "81504", "url_article", "http://www.dieta-saludable.com/a-dieta-despues-de-navidad/");
INSERT INTO `wp_postmeta` VALUES("14611", "81504", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14612", "81505", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2017/11/el-desarrollo-de-la-economia-circular-uno-de-los-grandes-retos-de-la-industria-4.0-44692.php");
INSERT INTO `wp_postmeta` VALUES("14613", "81505", "interes", "15");
INSERT INTO `wp_postmeta` VALUES("14614", "81506", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2017/11/cisco-anuncia-el-primer-asistente-de-voz-para-reuniones-basado-en-inteligencia-artificial-44693.php");
INSERT INTO `wp_postmeta` VALUES("14615", "81506", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14616", "81507", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2017/11/murrelektronik-presenta-en-empack-sus-instalaciones-descentralizadas-para-la-industria-del-packaging-44683.php");
INSERT INTO `wp_postmeta` VALUES("14617", "81507", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("14618", "81508", "url_article", "http://www.dieta-saludable.com/regala-salud/");
INSERT INTO `wp_postmeta` VALUES("14619", "81508", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14620", "81509", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2017/10/salicru-lanza-al-mercado-controlvit-una-nueva-gama-de-variadores-de-frecuencia-44649.php");
INSERT INTO `wp_postmeta` VALUES("14621", "81509", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("14622", "81510", "url_article", "https://blog.sciencedirect.com/posts/articles-in-press-added-to-sciencedirect-journal-alerts");
INSERT INTO `wp_postmeta` VALUES("14623", "81510", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14624", "81511", "url_article", "https://www.nestle.com/media/pressreleases/allpressreleases/full-year-results-2015");
INSERT INTO `wp_postmeta` VALUES("14625", "81511", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("14626", "81512", "url_article", "https://www.nestle.com/media/pressreleases/allpressreleases/nine-month-sales-2016");
INSERT INTO `wp_postmeta` VALUES("14627", "81512", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("14628", "81513", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2017/09/fotocelulas-que-optimizan-la-deteccion-44595.php");
INSERT INTO `wp_postmeta` VALUES("14629", "81513", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14630", "81514", "url_article", "http://www.eleconomista.es/mercados-cotizaciones/noticias/8999707/03/18/El-ruido-corporativo-lleva-a-maximos-a-las-papeleras-espanolas-en-bolsa.html");
INSERT INTO `wp_postmeta` VALUES("14631", "81514", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14632", "81515", "url_article", "https://www.nestle.com/media/pressreleases/allpressreleases/half-year-results-2014");
INSERT INTO `wp_postmeta` VALUES("14633", "81515", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("14634", "81516", "url_article", "https://www.nestle.com/media/pressreleases/allpressreleases/nestle-sells-powerbar");
INSERT INTO `wp_postmeta` VALUES("14635", "81516", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14636", "81517", "url_article", "https://www.nestle.com/media/pressreleases/allpressreleases/q1-sales-2014");
INSERT INTO `wp_postmeta` VALUES("14637", "81517", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("14638", "81518", "url_article", "https://www.nestle.com/media/pressreleases/allpressreleases/half-year-results-2013");
INSERT INTO `wp_postmeta` VALUES("14639", "81518", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("14640", "81519", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2017/07/entrevista-a-alvaro-esteve-vives-director-en-espana-de-las-areas-de-negociode-automatizacion-indust-44571.php");
INSERT INTO `wp_postmeta` VALUES("14641", "81519", "interes", "16");
INSERT INTO `wp_postmeta` VALUES("14642", "81520", "url_article", "http://www.red.es/redes/es/actualidad/magazin-en-red/m%C3%A1s-de-50-empresas-integrar%C3%A1n-el-pabell%C3%B3n-de-espa%C3%B1a-en-el-mobile-world");
INSERT INTO `wp_postmeta` VALUES("14643", "81520", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14644", "81521", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2017/05/maxima-flexibilidad-y-velocidad-en-automatizacion-y-motion-control-44506.php");
INSERT INTO `wp_postmeta` VALUES("14645", "81521", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14646", "81522", "url_article", "http://www.qcom.es/alimentacion/portada/nuevos-embalajes-de-marlene_27753_3_30484_0_1_in.html");
INSERT INTO `wp_postmeta` VALUES("14647", "81522", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14648", "81523", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2017/05/rockwell-automation-anuncia-el-ganador-del-premio-best-future-machine-en-interpack-2017-44482.php");
INSERT INTO `wp_postmeta` VALUES("14649", "81523", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("14650", "81524", "url_article", "http://www.foodingredientsfirst.com/news/Forward-thinking-partnerships-SIG-Combibloc-unveils-ProLeiT-and-DNP-agreements.html");
INSERT INTO `wp_postmeta` VALUES("14651", "81524", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("14652", "81525", "url_article", "http://mundosabor.es/blog/blog-post/2017/08/10/promocion-en-el-envasado.html");
INSERT INTO `wp_postmeta` VALUES("14653", "81525", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14654", "81526", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2017/04/abb-adquirira-b-r-44438.php");
INSERT INTO `wp_postmeta` VALUES("14655", "81526", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14656", "81527", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2017/04/murrelektronik-presenta-en-la-hannover-messe-sus-soluciones-personalizadas-a-la-medida-de-sus-client-44455.php");
INSERT INTO `wp_postmeta` VALUES("14657", "81527", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("14658", "81528", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2017/03/operational-excellence-with-supertrak-44414.php");
INSERT INTO `wp_postmeta` VALUES("14659", "81528", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("14660", "81529", "url_article", "https://www.kantarworldpanel.com/es/Noticias/promociones-gasto-o-inversion-parte-II");
INSERT INTO `wp_postmeta` VALUES("14661", "81529", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14662", "81530", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2017/03/smart-upgrade-for-brownfield-sites-44399.php");
INSERT INTO `wp_postmeta` VALUES("14663", "81530", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("14664", "81531", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2017/03/sensor-ultrasonico-compacto-en-acero-inoxidable-44409.php");
INSERT INTO `wp_postmeta` VALUES("14665", "81531", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("14666", "81532", "url_article", "http://www.ift.org/Newsroom/News-Releases/2017/January/23/Study-Suggests-Color-of-Sweetener-Packet-Impacts-Sweetness-Perception-and-Liking.aspx");
INSERT INTO `wp_postmeta` VALUES("14667", "81532", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14668", "81533", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2017/02/hexagon-manufacturing-intelligence-presenta-pc-dmis-2017-r1-44366.php");
INSERT INTO `wp_postmeta` VALUES("14669", "81533", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("14670", "81534", "url_article", "http://www.ainia.es/documentos/");
INSERT INTO `wp_postmeta` VALUES("14671", "81534", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14672", "81535", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2016/12/estados-unidos-objetivo-de-la-maquinaria-para-packaging-espanola-44268.php");
INSERT INTO `wp_postmeta` VALUES("14673", "81535", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("14674", "81536", "url_article", "https://www.foodnavigator.com/Article/2018/03/07/Eagle-Product-Inspection-to-debut-EPX100-x-ray-inspection-system?utm_source=RSS_Feed&utm_medium=RSS&utm_campaign=RSS");
INSERT INTO `wp_postmeta` VALUES("14675", "81536", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14676", "81537", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2016/11/el-mercado-de-los-plc-debera-mejorar-en-2017-44256.php");
INSERT INTO `wp_postmeta` VALUES("14677", "81537", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14678", "81538", "url_article", "http://www.ift.org/Newsroom/News-Releases/2016/December/20/Study-Finds-Ideal-Method-to-Minimize-Waffle-Loss-in-Industrial-Production.aspx");
INSERT INTO `wp_postmeta` VALUES("14679", "81538", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14680", "81539", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2016/11/fotocelulas-de-acero-inoxidables-44241.php");
INSERT INTO `wp_postmeta` VALUES("14681", "81539", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14682", "81540", "url_article", "https://www.kantarworldpanel.com/es/Noticias/Vuelve-a-crecer-el-consumo-en-el-hogar");
INSERT INTO `wp_postmeta` VALUES("14683", "81540", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14684", "81541", "url_article", "http://www.foodinsight.org/4-reasons-to-fall-in-love-with-yogurt-protein-calcium-probiotics");
INSERT INTO `wp_postmeta` VALUES("14685", "81541", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14686", "81542", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2016/11/ifm-ya-tiene-gama-de-sensores-de-ultrasonidos-44235.php");
INSERT INTO `wp_postmeta` VALUES("14687", "81542", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14688", "81543", "url_article", "http://feedproxy.google.com/~r/greenbuzz/~3/VjjrFqbCsOc/convenience-cost-sustainability-not-necessarily-sponsored");
INSERT INTO `wp_postmeta` VALUES("14689", "81543", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14690", "81544", "url_article", "http://feedproxy.google.com/~r/greenbuzz/~3/e2COkhgsnaU/kenya-circular-economy-modernizes-small-scale-farming");
INSERT INTO `wp_postmeta` VALUES("14691", "81544", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14692", "81545", "url_article", "http://www.red.es/redes/es/node/14866");
INSERT INTO `wp_postmeta` VALUES("14693", "81545", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("14694", "81546", "url_article", "http://www.red.es/redes/es/node/14868");
INSERT INTO `wp_postmeta` VALUES("14695", "81546", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("14696", "81547", "url_article", "http://www.red.es/redes/es/node/14862");
INSERT INTO `wp_postmeta` VALUES("14697", "81547", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("14698", "81548", "url_article", "http://www.red.es/redes/es/node/14864");
INSERT INTO `wp_postmeta` VALUES("14699", "81548", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("14700", "81549", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2016/09/el-packaging-espanol-ante-sus-desfafios-44126.php");
INSERT INTO `wp_postmeta` VALUES("14701", "81549", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14702", "81550", "url_article", "http://www.red.es/redes/es/magazin-red/noticias/invitaci%C3%B3n-para-participar-en-el-pabell%C3%B3n-de-espa%C3%B1a-del-pr%C3%B3ximo-mobile-world");
INSERT INTO `wp_postmeta` VALUES("14703", "81550", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("14704", "81551", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2016/09/cuando-las-ciberamenazas-cuestan-mas-que-dinero-44112.php");
INSERT INTO `wp_postmeta` VALUES("14705", "81551", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("14706", "81552", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2016/09/aslan-ahonda-en-la-seguridad-que-demanda-la-transformacion-digital-44099.php");
INSERT INTO `wp_postmeta` VALUES("14707", "81552", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14708", "81553", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2016/09/nuevo-labview-y-muchas-cosas-mas-44093.php");
INSERT INTO `wp_postmeta` VALUES("14709", "81553", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14710", "81554", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2016/07/serializacion-y-proteccion-contra-la-manipulacion-de-productos-farmaceuticos-44037.php");
INSERT INTO `wp_postmeta` VALUES("14711", "81554", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("14712", "81555", "url_article", "https://www.industriaalimenticia.com/articles/89046-post-holdings-adquirira-a-bob-evans-farms");
INSERT INTO `wp_postmeta` VALUES("14713", "81555", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14714", "81556", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2016/07/todo-bajo-un-solo-controlador-44022.php");
INSERT INTO `wp_postmeta` VALUES("14715", "81556", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14716", "81557", "url_article", "https://www.industriaalimenticia.com/articles/89043-el-envase-inteligente-ayuda-la-industria-alimenticia-a-responder-a-las-preferencias-del-consumidor");
INSERT INTO `wp_postmeta` VALUES("14717", "81557", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14718", "81558", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2016/07/national-instruments-y-hp-colaboran-para-comercializar-soluciones-big-analog-data-43993.php");
INSERT INTO `wp_postmeta` VALUES("14719", "81558", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14720", "81559", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2016/07/envases-barrera-un-25-mas-economicos-y-un-30-mas-sostenibles-44014.php");
INSERT INTO `wp_postmeta` VALUES("14721", "81559", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("14722", "81560", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2016/05/proteccion-contra-envases-de-productos-medicos-manipulados-gracias-a-un-sensor-de-brillo-43821.php");
INSERT INTO `wp_postmeta` VALUES("14723", "81560", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("14724", "81561", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2016/05/las-novedades-de-beckhoff-en-la-biemh-2016-43797.php");
INSERT INTO `wp_postmeta` VALUES("14725", "81561", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14726", "81562", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2016/05/envasado-esteril-con-control-de-peso-100-43818.php");
INSERT INTO `wp_postmeta` VALUES("14727", "81562", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14728", "81563", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2016/05/la-estrategia-de-tesla-43781.php");
INSERT INTO `wp_postmeta` VALUES("14729", "81563", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("14730", "81564", "url_article", "https://www.industriaalimenticia.com/articles/89105-pack-expo-las-vegas-bate-record-en-asistencia");
INSERT INTO `wp_postmeta` VALUES("14731", "81564", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14732", "81565", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2016/04/nueva-edicion-de-la-automation-university-special-de-rockwell-43739.php");
INSERT INTO `wp_postmeta` VALUES("14733", "81565", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14734", "81566", "url_article", "http://www.ift.org/Newsroom/News-Releases/2016/August/24/Foodies.aspx");
INSERT INTO `wp_postmeta` VALUES("14735", "81566", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14736", "81567", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2016/03/buenas-perspectivas-de-los-robots-scara-en-la-industria-alimentariala-firma-de-analisis-technavio-ac-43685.php");
INSERT INTO `wp_postmeta` VALUES("14737", "81567", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14738", "81568", "url_article", "https://www.mckinsey.com/industries/consumer-packaged-goods/our-insights/how-are-consumers-feeling-about-their-finances");
INSERT INTO `wp_postmeta` VALUES("14739", "81568", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14740", "81569", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2016/03/sencillez-en-la-gestion-y-supervision-de-lineas-43674.php");
INSERT INTO `wp_postmeta` VALUES("14741", "81569", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14742", "81570", "url_article", "https://ec.europa.eu/jrc/en/news/are-we-circular-yet-focus-critical-raw-materials-circular-economy");
INSERT INTO `wp_postmeta` VALUES("14743", "81570", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14744", "81571", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2016/03/matelec-industry-ofrecera-una-zona-demo-de-drones-industriales-43633.php");
INSERT INTO `wp_postmeta` VALUES("14745", "81571", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("14746", "81572", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2016/02/rockwell-automation-adquiere-magnemotion-43605.php");
INSERT INTO `wp_postmeta` VALUES("14747", "81572", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14748", "81573", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2016/02/rockwell-automation-presenta-el-premio-best-future-machine-43623.php");
INSERT INTO `wp_postmeta` VALUES("14749", "81573", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("14750", "81574", "url_article", "http://www.envaseysociedad.org/museo-del-envase/");
INSERT INTO `wp_postmeta` VALUES("14751", "81574", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("14752", "81575", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2016/02/el-bioplastico-una-gran-oportunidad-para-europa-43596.php");
INSERT INTO `wp_postmeta` VALUES("14753", "81575", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("14754", "81576", "url_article", "http://profesionalretail.com/fini-golosinas-lanza-las-cajas-monsterbox-con-motivo-de-halloween/");
INSERT INTO `wp_postmeta` VALUES("14755", "81576", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("14756", "81577", "url_article", "http://www.envaseysociedad.org/funciones-envases-agua-mineral/");
INSERT INTO `wp_postmeta` VALUES("14757", "81577", "interes", "14");
INSERT INTO `wp_postmeta` VALUES("14758", "81578", "url_article", "https://ec.europa.eu/jrc/en/news/evidence-based-action-competitive-green-and-trusted-european-car-industry");
INSERT INTO `wp_postmeta` VALUES("14759", "81578", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14760", "81579", "url_article", "http://www.envaseysociedad.org/el-tercer-encuentro-anual-talking-pack-reune-en-madrid-a-administracion-consumidores-y-profesionales-de-la-cadena-de-valor-del-envase/");
INSERT INTO `wp_postmeta` VALUES("14761", "81579", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("14762", "81580", "url_article", "http://www.envaseysociedad.org/este-verano-recuerda-los-envases-te-acompanan/");
INSERT INTO `wp_postmeta` VALUES("14763", "81580", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14764", "81581", "url_article", "http://www.envaseysociedad.org/litteranzas/");
INSERT INTO `wp_postmeta` VALUES("14765", "81581", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14766", "81582", "url_article", "http://www.envaseysociedad.org/conectar-a-las-personas-con-la-naturaleza-dia-mundial-del-medio-ambiente-2017/");
INSERT INTO `wp_postmeta` VALUES("14767", "81582", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("14768", "81583", "url_article", "http://www.envaseysociedad.org/2333-2/");
INSERT INTO `wp_postmeta` VALUES("14769", "81583", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("14770", "81584", "url_article", "http://www.envaseysociedad.org/las-personas-sin-vehiculo-mayores-yo-con-movilidad-reducida-son-los-que-mayores-inconvenientes-ven-al-sddr/");
INSERT INTO `wp_postmeta` VALUES("14771", "81584", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("14772", "81585", "url_article", "http://www.envaseysociedad.org/dia-del-reciclaje-20-anos-gestionando-nuestros-residuos-de-envases/");
INSERT INTO `wp_postmeta` VALUES("14773", "81585", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("14774", "81586", "url_article", "http://www.envaseysociedad.org/isidro-gonzalez-de-vega-secretario-general-de-la-plataforma-envase-y-sociedad/");
INSERT INTO `wp_postmeta` VALUES("14775", "81586", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("14776", "81587", "url_article", "http://www.envaseysociedad.org/el-littering-es-un-problema-educacional/");
INSERT INTO `wp_postmeta` VALUES("14777", "81587", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("14778", "81588", "url_article", "http://www.envaseysociedad.org/envases-de-plastico-seguros-para-el-consumidor/");
INSERT INTO `wp_postmeta` VALUES("14779", "81588", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("14780", "81589", "url_article", "http://www.envaseysociedad.org/insuficiente-informacion-sobre-la-composicion-de-la-basura-abandonada-en-espacios-publicos/");
INSERT INTO `wp_postmeta` VALUES("14781", "81589", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("14782", "81590", "url_article", "http://www.envaseysociedad.org/el-vidrio-ciencia-y-sociedad/");
INSERT INTO `wp_postmeta` VALUES("14783", "81590", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14784", "81591", "url_article", "http://www.envaseysociedad.org/desperdicio-alimentario-problema-social-con-solucion-social/");
INSERT INTO `wp_postmeta` VALUES("14785", "81591", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("14786", "81592", "url_article", "http://www.envaseysociedad.org/la-gestion-de-envases-domesticos-en-la-sociedad-canaria-en-un-nuevo-contexto-de-la-economia-circular/");
INSERT INTO `wp_postmeta` VALUES("14787", "81592", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("14788", "81593", "url_article", "http://www.envaseysociedad.org/concurso-litteranzas/");
INSERT INTO `wp_postmeta` VALUES("14789", "81593", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("14790", "81594", "url_article", "http://www.envaseysociedad.org/talking-pack-2016-educacion-y-sensibilizacion-frente-al-littering/");
INSERT INTO `wp_postmeta` VALUES("14791", "81594", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("14792", "81595", "url_article", "http://www.envaseysociedad.org/la-gestion-de-envases-domesticos-a-debate-en-la-universidad-de-alicante/");
INSERT INTO `wp_postmeta` VALUES("14793", "81595", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("14794", "81596", "url_article", "http://www.envaseysociedad.org/agentes-economios-y-sociales-cuestionan-la-viabilidad-de-un-sddr-obligatorio-en-la-comunidad-valenciana/");
INSERT INTO `wp_postmeta` VALUES("14795", "81596", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("14796", "81597", "url_article", "https://www.packagingnews.co.uk/design/italian-olive-brand-turns-rpc-superfos-new-packs-12-03-2018");
INSERT INTO `wp_postmeta` VALUES("14797", "81597", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14798", "81598", "url_article", "https://www.packagingnews.co.uk/news/events/featured-video-smurfit-kappa-optimised-packaging-spirits-industry-12-03-2018");
INSERT INTO `wp_postmeta` VALUES("14799", "81598", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14800", "81599", "url_article", "https://www.packagingnews.co.uk/luxury/showcase/kite-packaging-extends-range-gift-packaging-12-03-2018");
INSERT INTO `wp_postmeta` VALUES("14801", "81599", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14802", "81600", "url_article", "https://www.dairyreporter.com/Article/2018/03/07/Mueller-reducing-sugar-in-products-and-cutting-plastic-use-through-acquisitions?utm_source=RSS_Feed&utm_medium=RSS&utm_campaign=RSS");
INSERT INTO `wp_postmeta` VALUES("14803", "81600", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14804", "81601", "url_article", "https://www.packagingnews.co.uk/news/markets/food/packaging-community-anuga-foodtec-join-battle-food-waste-12-03-2018");
INSERT INTO `wp_postmeta` VALUES("14805", "81601", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14806", "81602", "url_article", "https://www.packagingnews.co.uk/equipment/hp-expands-product-identification-printing-12-03-2018");
INSERT INTO `wp_postmeta` VALUES("14807", "81602", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14808", "81603", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/12/los-sistemas-de-vision-se-adaptan-a-la-alta-cadencia-43469.php");
INSERT INTO `wp_postmeta` VALUES("14809", "81603", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14810", "81604", "url_article", "https://www.industriaalimenticia.com/articles/89242-expo-pack-mexico-2018-espera-mas-de-23000-asistentes");
INSERT INTO `wp_postmeta` VALUES("14811", "81604", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14812", "81605", "url_article", "http://soups.food-business-review.com/news/hilton-ties-up-with-tesco-central-europe-to-supply-fresh-food-24-08-17-5909044");
INSERT INTO `wp_postmeta` VALUES("14813", "81605", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14814", "81606", "url_article", "https://www.packagingnews.co.uk/top-story/government-rejects-latte-levy-disposable-cups-09-03-2018");
INSERT INTO `wp_postmeta` VALUES("14815", "81606", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14816", "81607", "url_article", "http://packaging.food-business-review.com/news/gortons-seafood-introduces-new-packaging-to-better-demonstrate-product-variety-ease-shopping-experience-5011573");
INSERT INTO `wp_postmeta` VALUES("14817", "81607", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14818", "81608", "url_article", "https://www.packagingnews.co.uk/news/pret-manger-huhtamaki-win-big-fpa-awards-09-03-2018");
INSERT INTO `wp_postmeta` VALUES("14819", "81608", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14820", "81609", "url_article", "http://fruitsandvegetables.food-business-review.com/news/sabert-acquires-mullinix-packages-190716-4953738");
INSERT INTO `wp_postmeta` VALUES("14821", "81609", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14822", "81610", "url_article", "http://saucesandspreads.food-business-review.com/news/tw-garner-food-texas-pete-announces-new-more-convenient-packaging-4998070");
INSERT INTO `wp_postmeta` VALUES("14823", "81610", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14824", "81611", "url_article", "http://packaging.food-business-review.com/news/kroger-recalls-chocolate-brownies-over-packaging-error-091215-4747871");
INSERT INTO `wp_postmeta` VALUES("14825", "81611", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14826", "81612", "url_article", "http://packaging.food-business-review.com/news/new-atkins-revamps-product-packaging-in-move-towards-mainstream-grocery-category-040216-4801825");
INSERT INTO `wp_postmeta` VALUES("14827", "81612", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14828", "81613", "url_article", "http://packaging.food-business-review.com/news/agrolis-selects-rpcs-transparent-polypropylene-pot-for-peanuts-packaging-071215-4746071");
INSERT INTO `wp_postmeta` VALUES("14829", "81613", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14830", "81614", "url_article", "https://www.packagingnews.co.uk/design/new-packs/biles-hendry-creates-new-brand-story-packaging-boutinot-wines-08-03-2018");
INSERT INTO `wp_postmeta` VALUES("14831", "81614", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14832", "81615", "url_article", "https://www.packagingnews.co.uk/news/fresh-packaging-talent-sought-apprenticeship-08-03-2018");
INSERT INTO `wp_postmeta` VALUES("14833", "81615", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("14834", "81616", "url_article", "http://packaging.food-business-review.com/news/velcro-introduces-press-lok-bags-041215-4744957");
INSERT INTO `wp_postmeta` VALUES("14835", "81616", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14836", "81617", "url_article", "http://packaging.food-business-review.com/news/mondelez-invites-fans-to-personalize-packaging-of-oreo-cookies-101115-4715543");
INSERT INTO `wp_postmeta` VALUES("14837", "81617", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14838", "81618", "url_article", "http://packaging.food-business-review.com/news/apeal-delivers-full-transparency-on-the-sustainability-of-tinplate-packaging-251115-4736891");
INSERT INTO `wp_postmeta` VALUES("14839", "81618", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14840", "81619", "url_article", "http://savorysnacks.food-business-review.com/news/gratify-foods-launches-new-snack-packs-201015-4698239");
INSERT INTO `wp_postmeta` VALUES("14841", "81619", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14842", "81620", "url_article", "http://www.food-business-review.com/news/us-launches-database-to-improve-food-composition-transparency-210916-5011350");
INSERT INTO `wp_postmeta` VALUES("14843", "81620", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14844", "81621", "url_article", "https://www.packagingnews.co.uk/equipment/packingfilling-equipment/sig-dnp-create-joint-venture-japan-08-03-2018");
INSERT INTO `wp_postmeta` VALUES("14845", "81621", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14846", "81622", "url_article", "http://packaging.food-business-review.com/news/rpc-superfos-supplies-ringlock-tubs-for-camelait-ice-cream-151015-4694382");
INSERT INTO `wp_postmeta` VALUES("14847", "81622", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14848", "81623", "url_article", "http://packaging.food-business-review.com/news/wyke-farms-launches-new-packaging-and-improved-re-sealable-zip-pack-061015-4686627");
INSERT INTO `wp_postmeta` VALUES("14849", "81623", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14850", "81624", "url_article", "http://iufost.org/2014/09/04/world-food-congress-2/");
INSERT INTO `wp_postmeta` VALUES("14851", "81624", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("14852", "81625", "url_article", "http://packaging.food-business-review.com/news/peacock-engineering-acquires-ll-foods-280715-4632576");
INSERT INTO `wp_postmeta` VALUES("14853", "81625", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14854", "81626", "url_article", "http://saucesandspreads.food-business-review.com/news/beatson-clark-produces-new-bottle-for-barbecue-sauce-packaging-240815-4653927");
INSERT INTO `wp_postmeta` VALUES("14855", "81626", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14856", "81627", "url_article", "http://regulatoryandfoodsafety.food-business-review.com/news/pictsweet-farms-12oz-crunchy-breaded-okra-recalled-due-to-risk-of-glass-contamination-160117-5716927");
INSERT INTO `wp_postmeta` VALUES("14857", "81627", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14858", "81628", "url_article", "http://meatandseafood.food-business-review.com/news/canada-allocates-funds-for-fish-packing-and-processing-plant-in-saskatchewan-310715-4635900");
INSERT INTO `wp_postmeta` VALUES("14859", "81628", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14860", "81629", "url_article", "http://www.megustaprobarcosas.com/blog/2017/11/cosmetica-natural/");
INSERT INTO `wp_postmeta` VALUES("14861", "81629", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("14862", "81630", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/12/maquina-de-marcado-laser-de-tubos-de-aluminio-43432.php");
INSERT INTO `wp_postmeta` VALUES("14863", "81630", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14864", "81631", "url_article", "http://www.megustaprobarcosas.com/blog/2017/11/hedonismo/");
INSERT INTO `wp_postmeta` VALUES("14865", "81631", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14866", "81632", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/12/nueva-gama-de-sensores-inductivos-de-proximidad-con-triple-distancia-de-deteccion-43421.php");
INSERT INTO `wp_postmeta` VALUES("14867", "81632", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("14868", "81633", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/12/mejores-practicas-en-mecanizado-completo-de-piezas-de-plastico-en-prensa-43416.php");
INSERT INTO `wp_postmeta` VALUES("14869", "81633", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("14870", "81634", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/12/yaskawa-presenta-en-empack-sus-propuestas-de-picking-packing-y-paletizado-43420.php");
INSERT INTO `wp_postmeta` VALUES("14871", "81634", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("14872", "81635", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOTR20160415001&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("14873", "81635", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14874", "81636", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOIT20160208002&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("14875", "81636", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14876", "81637", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BORS20180125001&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("14877", "81637", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("14878", "81638", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/11/schunk-confirma-su-apuesta-por-la-industria-4.0-en-metalmadrid-43374.php");
INSERT INTO `wp_postmeta` VALUES("14879", "81638", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("14880", "81639", "url_article", "http://www.poscosecha.com/es/empresas/seminario-tecnico-fongfruit-factores-que-limitan-la-desinfeccion-de-pales-de-fruta-protocolos-de-toma-de-muestras-y-de-identificacion-de-hongos/_id:26251,noticia:79593,seccion:noticias/");
INSERT INTO `wp_postmeta` VALUES("14881", "81639", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14882", "81640", "url_article", "http://www.poscosecha.com/es/noticias/mas-sobre-poscosecha-9-de-marzo-2018/_id:80648/");
INSERT INTO `wp_postmeta` VALUES("14883", "81640", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("14884", "81641", "url_article", "http://iufost.org/2017/05/03/brazil-2012/");
INSERT INTO `wp_postmeta` VALUES("14885", "81641", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("14886", "81642", "url_article", "https://www.industriaalimenticia.com/articles/88977-coexpan-y-emsur-partners-for-packaging-solutions-presentar%C3%A1n-sus-innovaciones-y-productos-en-pack-expo-2017");
INSERT INTO `wp_postmeta` VALUES("14887", "81642", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14888", "81643", "url_article", "https://www.industriaalimenticia.com/articles/88968-tna-presenta-la-empacadora-para-bolsas-flexibles-mas-rapida-del-mundo");
INSERT INTO `wp_postmeta` VALUES("14889", "81643", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14890", "81644", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BRRO20171129001&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("14891", "81644", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14892", "81645", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOBE20170919001&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("14893", "81645", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("14894", "81646", "url_article", "http://iufost.org/2017/04/19/food-101-stories-about-food/");
INSERT INTO `wp_postmeta` VALUES("14895", "81646", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14896", "81647", "url_article", "http://www.poscosecha.com/es/empresas/buenas-practicas-en-higiene-alimentaria/_id:63204,noticia:79590,seccion:noticias/");
INSERT INTO `wp_postmeta` VALUES("14897", "81647", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14898", "81648", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/11/lineas-completas-de-produccion-de-envasado-adaptadas-a-cualquier-tipo-de-producto-43349.php");
INSERT INTO `wp_postmeta` VALUES("14899", "81648", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14900", "81649", "url_article", "http://iufost.org/2017/05/04/canada-2014-2/");
INSERT INTO `wp_postmeta` VALUES("14901", "81649", "interes", "19");
INSERT INTO `wp_postmeta` VALUES("14902", "81650", "url_article", "http://www.poscosecha.com/es/noticias/mas-sobre-poscosecha-2-de-marzo-2018/_id:80642/");
INSERT INTO `wp_postmeta` VALUES("14903", "81650", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("14904", "81651", "url_article", "http://www.poscosecha.com/es/empresas/soluciones-de-envases-agroalimentarios-para-el-consumidor-y-distribuidor-eco-sostenibles-desde-su-concepcion/_id:63349,noticia:79586,seccion:noticias/");
INSERT INTO `wp_postmeta` VALUES("14905", "81651", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("14906", "81652", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOHU20160809002&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("14907", "81652", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14908", "81653", "url_article", "http://www.poscosecha.com/es/noticias/economia-circular-para-una-gestion-mas-eficiente-del-agua-en-las-industrias-agroalimentarias/_id:80638/");
INSERT INTO `wp_postmeta` VALUES("14909", "81653", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("14910", "81654", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOPT20171002001&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("14911", "81654", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14912", "81655", "url_article", "http://www.poscosecha.com/es/empresas/paturpat-apuesta-por-el-pelador-a-vapor-tomra-orbit-para-mantener-los-estandares-de-calidad-de-sus-patatas-cocinadas/_id:62975,noticia:79582,seccion:noticias/");
INSERT INTO `wp_postmeta` VALUES("14913", "81655", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("14914", "81656", "url_article", "http://iufost.org/2017/09/13/lifetime-achievement-and-young-scientist-excellence-awards/");
INSERT INTO `wp_postmeta` VALUES("14915", "81656", "interes", "14");
INSERT INTO `wp_postmeta` VALUES("14916", "81657", "url_article", "https://www.aemps.gob.es/informa/alertas/medicamentosUsoHumano/2018/calidad_6_2018_Lynparza.htm");
INSERT INTO `wp_postmeta` VALUES("14917", "81657", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14918", "81658", "url_article", "http://www.poscosecha.com/es/noticias/las-casas-de-semillas-han-realizado-un-gran-esfuerzo-y-cambio-en-los-ultimos-anos-en-este-apartado-vida-comercial-logrando-tambien-atractivo-y-sabor-en-las-nuevas-variedades/_id:80631/");
INSERT INTO `wp_postmeta` VALUES("14919", "81658", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("14920", "81659", "url_article", "http://www.imfarmacias.es/noticia/14684/visitanos-estaremos-en-infarma-2018");
INSERT INTO `wp_postmeta` VALUES("14921", "81659", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14922", "81660", "url_article", "http://iufost.org/2010/02/08/journals/");
INSERT INTO `wp_postmeta` VALUES("14923", "81660", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("14924", "81661", "url_article", "http://www.poscosecha.com/es/empresas/novedades-de-brimapack-para-2018/_id:61341,noticia:79577,seccion:noticias/");
INSERT INTO `wp_postmeta` VALUES("14925", "81661", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("14926", "81662", "url_article", "http://www.poscosecha.com/es/noticias/mas-sobre-poscosecha-19-de-enero-2018/_id:80624/");
INSERT INTO `wp_postmeta` VALUES("14927", "81662", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("14928", "81663", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOIT20161109003&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("14929", "81663", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14930", "81664", "url_article", "http://www.poscosecha.com/es/empresas/italia-entre-los-primeros-5-principales-recicladores-en-la-union-europea/_id:61408,noticia:79575,seccion:noticias/");
INSERT INTO `wp_postmeta` VALUES("14931", "81664", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("14932", "81665", "url_article", "http://iufost.org/2017/05/15/adhering-bodies-congress-events-calendar/");
INSERT INTO `wp_postmeta` VALUES("14933", "81665", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("14934", "81666", "url_article", "http://www.poscosecha.com/es/empresas/tomra-continua-la-expansion-en-el-sector-global-de-soluciones-de-clasificacion-de-alimentos-con-la-adquisicion-de-bbc-technologies/_id:62975,noticia:79573,seccion:noticias/");
INSERT INTO `wp_postmeta` VALUES("14935", "81666", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("14936", "81667", "url_article", "http://www.poscosecha.com/es/empresas/conservacion-frigorifica-de-naranja-navel-lane-late/_id:53750,noticia:79574,seccion:noticias/");
INSERT INTO `wp_postmeta` VALUES("14937", "81667", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14938", "81668", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOIT20170807002&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("14939", "81668", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14940", "81669", "url_article", "http://iufost.org/2010/01/19/iufost_history/");
INSERT INTO `wp_postmeta` VALUES("14941", "81669", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("14942", "81670", "url_article", "http://www.poscosecha.com/es/empresas/macfrut-una-gran-oportunidad-para-los-buyers-internacionales/_id:35911,noticia:79570,seccion:noticias/");
INSERT INTO `wp_postmeta` VALUES("14943", "81670", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14944", "81671", "url_article", "http://www.poscosecha.com/es/noticias/residuos-de-la-industria-de-la-seda-potencial-material-biodegradable-para-la-fabricacion-de-envases/_id:80613/");
INSERT INTO `wp_postmeta` VALUES("14945", "81671", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("14946", "81672", "url_article", "http://www.poscosecha.com/es/noticias/procesamiento-de-vegetales-para-pulpas-congeladas/_id:80611/");
INSERT INTO `wp_postmeta` VALUES("14947", "81672", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14948", "81673", "url_article", "https://www.dairyreporter.com/Article/2018/03/08/Schur-Flexibles-to-expand-dairy-and-fresh-food-business?utm_source=RSS_Feed&utm_medium=RSS&utm_campaign=RSS");
INSERT INTO `wp_postmeta` VALUES("14949", "81673", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14950", "81674", "url_article", "http://www.poscosecha.com/es/empresas/sanlucar-subraya-en-los-desayunos-del-cluster-la-importancia-de-la-homogeneidad-en-el-packaging-para-cubrir-el-ciclo-de-vida-del-producto/_id:63307,noticia:79566,seccion:noticias/");
INSERT INTO `wp_postmeta` VALUES("14951", "81674", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("14952", "81675", "url_article", "http://iufost.org/2017/05/09/2018-world-food-congress-mumbai-india/");
INSERT INTO `wp_postmeta` VALUES("14953", "81675", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("14954", "81676", "url_article", "http://www.poscosecha.com/es/empresas/tomra-gana-la-medalla-de-plata-en-el-premio-internacional-foodtec/_id:62975,noticia:79565,seccion:noticias/");
INSERT INTO `wp_postmeta` VALUES("14955", "81676", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("14956", "81677", "url_article", "http://iufost.org/2017/05/15/general-assembly-2016/");
INSERT INTO `wp_postmeta` VALUES("14957", "81677", "interes", "34");
INSERT INTO `wp_postmeta` VALUES("14958", "81678", "url_article", "https://www.foodqualitynews.com/Article/2018/03/02/Endocrine-Society-Reserve-judgement-until-final-BPA-report?utm_source=RSS_Feed&utm_medium=RSS&utm_campaign=RSS");
INSERT INTO `wp_postmeta` VALUES("14959", "81678", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14960", "81679", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOSI20171020002&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("14961", "81679", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("14962", "81680", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/10/mas-funcionalidades-de-las-herramientas-fdi-43251.php");
INSERT INTO `wp_postmeta` VALUES("14963", "81680", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14964", "81681", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BRSI20170116001&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("14965", "81681", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("14966", "81682", "url_article", "https://www.aemps.gob.es/informa/alertas/medicamentosUsoHumano/2017/calidad_30_2017_Diclofenaco-sodico.htm");
INSERT INTO `wp_postmeta` VALUES("14967", "81682", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14968", "81683", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/10/pack-expo-de-usa-acoge-la-propuesta-de-empresa-conectada-de-rockwell-43234.php");
INSERT INTO `wp_postmeta` VALUES("14969", "81683", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("14970", "81684", "url_article", "http://journals.sagepub.com/doi/abs/10.1177/1082013217735951?ai=2b4&mi=ehikzz&af=R");
INSERT INTO `wp_postmeta` VALUES("14971", "81684", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14972", "81685", "url_article", "https://www.bakeryandsnacks.com/Article/2018/03/06/Indian-consumer-watchdog-fines-Britannia-for-underweight-biscuits?utm_source=RSS_Feed&utm_medium=RSS&utm_campaign=RSS");
INSERT INTO `wp_postmeta` VALUES("14973", "81685", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14974", "81686", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=RDES20170126001&EnquiryType=FP7");
INSERT INTO `wp_postmeta` VALUES("14975", "81686", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14976", "81687", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/09/aumento-de-la-eficiencia-de-compresores-de-gas-en-la-industria-alimentaria-con-weg-43185.php");
INSERT INTO `wp_postmeta` VALUES("14977", "81687", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("14978", "81688", "url_article", "https://www.foodnavigator-asia.com/Article/2018/03/07/International-challenge-Japan-s-top-five-packaged-food-firms-revealed-and-all-bar-one-is-homegrown?utm_source=RSS_Feed&utm_medium=RSS&utm_campaign=RSS");
INSERT INTO `wp_postmeta` VALUES("14979", "81688", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14980", "81689", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOTR20161116003&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("14981", "81689", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14982", "81690", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOGR20160920001&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("14983", "81690", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14984", "81691", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/08/metalquimia-despliega-la-arquitectura-integrada-de-rockwell-automation-43151.php");
INSERT INTO `wp_postmeta` VALUES("14985", "81691", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("14986", "81692", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOIT20180208001&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("14987", "81692", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("14988", "81693", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOFR20160615001&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("14989", "81693", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14990", "81694", "url_article", "http://journals.sagepub.com/doi/abs/10.1177/1082013217753229?ai=2b4&mi=ehikzz&af=R");
INSERT INTO `wp_postmeta` VALUES("14991", "81694", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14992", "81695", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BRSE20180112001&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("14993", "81695", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("14994", "81696", "url_article", "http://www.infoplc.net/noticias/item/105254-conta-clip-placas-paso-cables-ip66");
INSERT INTO `wp_postmeta` VALUES("14995", "81696", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14996", "81697", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=TOIT20161118001&EnquiryType=BBS");
INSERT INTO `wp_postmeta` VALUES("14997", "81697", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("14998", "81698", "url_article", "http://www.marketing4food.com/digitalizacion-industria-de-alimentos-y-bebidas/");
INSERT INTO `wp_postmeta` VALUES("14999", "81698", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15000", "81699", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/07/nuevo-presidente-para-automation-safety-de-omron-en-eeuu-43110.php");
INSERT INTO `wp_postmeta` VALUES("15001", "81699", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15002", "81700", "url_article", "http://www.marketing4food.com/packaging-tendencias-cara-2018/");
INSERT INTO `wp_postmeta` VALUES("15003", "81700", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15004", "81701", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOIT20180208002&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("15005", "81701", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15006", "81702", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOPL20160719001&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("15007", "81702", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15008", "81703", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOLT20170314001&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("15009", "81703", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15010", "81704", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/06/siemens-en-hispack-2015-43062.php");
INSERT INTO `wp_postmeta` VALUES("15011", "81704", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15012", "81705", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOPT20170706002&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("15013", "81705", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15014", "81706", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOLT20180207001&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("15015", "81706", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15016", "81707", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/06/-el-sector-de-packaging-apuesta-por-las-nuevas-tecnologias-pero-a-un-coste-contenido-43061.php");
INSERT INTO `wp_postmeta` VALUES("15017", "81707", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15018", "81708", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOIT20170105002&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("15019", "81708", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15020", "81709", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=TONL20161115001&EnquiryType=BBS");
INSERT INTO `wp_postmeta` VALUES("15021", "81709", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15022", "81710", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOIT20170104001&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("15023", "81710", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15024", "81711", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BODE20151221001&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("15025", "81711", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15026", "81712", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/05/repsol-construira-una-nueva-unidad-de-polietileno-metaloceno-en-tarragona-42974.php");
INSERT INTO `wp_postmeta` VALUES("15027", "81712", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15028", "81713", "url_article", "http://www.red.es/redes/es/actualidad/magazin-en-red/ya-est%C3%A1-en-marcha-una-nueva-edici%C3%B3n-del-pabell%C3%B3n-de-espa%C3%B1a-en-el-mobile");
INSERT INTO `wp_postmeta` VALUES("15029", "81713", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("15030", "81714", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=TOSK20171211001&EnquiryType=BBS");
INSERT INTO `wp_postmeta` VALUES("15031", "81714", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15032", "81715", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOTR20171031001&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("15033", "81715", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15034", "81716", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/05/prevision-de-crecimiento-minima-para-los-equipos-de-automatizacion-industrial-42955.php");
INSERT INTO `wp_postmeta` VALUES("15035", "81716", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15036", "81717", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOUK20160822002&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("15037", "81717", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15038", "81718", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/05/nuevas-tecnologias-nueva-alimentacion-42917.php");
INSERT INTO `wp_postmeta` VALUES("15039", "81718", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15040", "81719", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/05/vipa-y-yaskawa-juntas-por-primera-vez-en-hispack-2015-42948.php");
INSERT INTO `wp_postmeta` VALUES("15041", "81719", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15042", "81720", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/05/bta-apuesta-por-la-internacionalizacion-y-pasa-a-llamarse-alimentaria-foodtech-42914.php");
INSERT INTO `wp_postmeta` VALUES("15043", "81720", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15044", "81721", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/05/prodec-incorpora-tecnologia-de-rockwell-en-sus-maquinas-de-embalaje-42916.php");
INSERT INTO `wp_postmeta` VALUES("15045", "81721", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15046", "81722", "url_article", "http://www.financialfood.es/default.aspx?where=3&id=1&n=27781");
INSERT INTO `wp_postmeta` VALUES("15047", "81722", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15048", "81723", "url_article", "http://www.financialfood.es/default.aspx?where=2&id=1&n=27780");
INSERT INTO `wp_postmeta` VALUES("15049", "81723", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15050", "81724", "url_article", "http://www.financialfood.es/default.aspx?where=8&id=1&n=27784");
INSERT INTO `wp_postmeta` VALUES("15051", "81724", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15052", "81725", "url_article", "http://www.financialfood.es/default.aspx?where=3&id=1&n=27786");
INSERT INTO `wp_postmeta` VALUES("15053", "81725", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15054", "81726", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/04/pack-smart-de-vmc-en-la-hannover-messe-42879.php");
INSERT INTO `wp_postmeta` VALUES("15055", "81726", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15056", "81727", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BRUK20180130001&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("15057", "81727", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15058", "81728", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/04/la-especificacion-fdi-y-herramientas-ya-estan-disponibles-42885.php");
INSERT INTO `wp_postmeta` VALUES("15059", "81728", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15060", "81729", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/04/hispack-acogera-la-innovacion-en-envases-de-plastico-desarrolladas-por-aimplas-42871.php");
INSERT INTO `wp_postmeta` VALUES("15061", "81729", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("15062", "81730", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOBE20171113001&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("15063", "81730", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15064", "81731", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOAM20160803001&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("15065", "81731", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15066", "81732", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/04/la-propuesta-integral-de-schneider-electric-en-hispack-42870.php");
INSERT INTO `wp_postmeta` VALUES("15067", "81732", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15068", "81733", "url_article", "http://www.red.es/redes/es/actualidad/magazin-en-red/65-empresas-representar%C3%A1n-al-sector-m%C3%B3vil-nacional-en-el-pabell%C3%B3n-de");
INSERT INTO `wp_postmeta` VALUES("15069", "81733", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15070", "81734", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/04/seguridad-para-m2m-en-procesos-logisticos-de-la-industria-del-envase-y-embalaje-42848.php");
INSERT INTO `wp_postmeta` VALUES("15071", "81734", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15072", "81735", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/04/phoenix-contact-presenta-en-hispack-sus-soluciones-de-automatizacion-para-el-sector-del-packaging-42856.php");
INSERT INTO `wp_postmeta` VALUES("15073", "81735", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15074", "81736", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/03/aimplas-cierra-2014-con-una-facturacion-de-8-6-millones-de-euros-42838.php");
INSERT INTO `wp_postmeta` VALUES("15075", "81736", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15076", "81737", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/04/novedades-de-yaskawa-en-hispack-42851.php");
INSERT INTO `wp_postmeta` VALUES("15077", "81737", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15078", "81738", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/03/murrelektronik-presenta-sus-soluciones-para-f-b-y-packaging-en-hispack-42830.php");
INSERT INTO `wp_postmeta` VALUES("15079", "81738", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15080", "81739", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/03/propuestas-avanzadas-para-la-conservacion-alimentaria-42778.php");
INSERT INTO `wp_postmeta` VALUES("15081", "81739", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15082", "81740", "url_article", "http://www.red.es/redes/es/actualidad/magazin-en-red/primer-encuentro-entre-redes-y-el-cabildo-de-el-hierro-para-arrancar-el");
INSERT INTO `wp_postmeta` VALUES("15083", "81740", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15084", "81741", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/03/hispack-crea-cuatro-areas-de-conocimiento-en-torno-al-packaging-42769.php");
INSERT INTO `wp_postmeta` VALUES("15085", "81741", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15086", "81742", "url_article", "https://www.preparedfoods.com/articles/120993-naked-fruit-nut-veggie-bars");
INSERT INTO `wp_postmeta` VALUES("15087", "81742", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15088", "81743", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/02/hispack-y-bta-2015-muy-buenas-perspectivas-para-la-edicion-de-este-ano-42757.php");
INSERT INTO `wp_postmeta` VALUES("15089", "81743", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("15090", "81744", "url_article", "https://blogthinkbig.com/la-petrolera-bp-invierte-en-carga-electrica");
INSERT INTO `wp_postmeta` VALUES("15091", "81744", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15092", "81745", "url_article", "http://www.21food.com/news/detail74623.html");
INSERT INTO `wp_postmeta` VALUES("15093", "81745", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15094", "81746", "url_article", "https://blogthinkbig.com/calorias-de-contenido-e-informacion-de-dietas");
INSERT INTO `wp_postmeta` VALUES("15095", "81746", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15096", "81747", "url_article", "https://www.preparedfoods.com/articles/120967-wasa-gluten-free-crispbread-crackers");
INSERT INTO `wp_postmeta` VALUES("15097", "81747", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15098", "81748", "url_article", "https://www.preparedfoods.com/articles/120998-favorite-products-january-2018");
INSERT INTO `wp_postmeta` VALUES("15099", "81748", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15100", "81749", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/02/impresion-3d-y-bioplasticos-para-el-packaging-que-viene-42727.php");
INSERT INTO `wp_postmeta` VALUES("15101", "81749", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("15102", "81750", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/02/festo-apuesta-por-la-automatizacion-electrica-en-hispack-42715.php");
INSERT INTO `wp_postmeta` VALUES("15103", "81750", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15104", "81751", "url_article", "https://www.preparedfoods.com/articles/120942-rhythm-superfoods-organic-carrot-stick-snacks");
INSERT INTO `wp_postmeta` VALUES("15105", "81751", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15106", "81752", "url_article", "http://www.red.es/redes/es/actualidad/magazin-en-red/redes-y-el-cabildo-de-fuerteventura-firman-el-convenio-para-poner-en");
INSERT INTO `wp_postmeta` VALUES("15107", "81752", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15108", "81753", "url_article", "https://www.foodengineeringmag.com/articles/97373-why-sabra-redesigned-its-hummus-packaging");
INSERT INTO `wp_postmeta` VALUES("15109", "81753", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15110", "81754", "url_article", "https://hursh.ca/2015/01/intercropping-opportunity-2/");
INSERT INTO `wp_postmeta` VALUES("15111", "81754", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15112", "81755", "url_article", "https://www.foodengineeringmag.com/articles/97338-facing-e-commerce-packaging-challenges");
INSERT INTO `wp_postmeta` VALUES("15113", "81755", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15114", "81756", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2015/01/los-economistas-alertan-del-peligro-de-cerrar-en-falso-la-crisis-segun-hispack-42666.php");
INSERT INTO `wp_postmeta` VALUES("15115", "81756", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15116", "81757", "url_article", "https://www.industriaalimenticia.com/articles/89013-pmmi-destaca-las-tendencias-de-envasado-de-carnicos-aves-de-corral-pescados-y-mariscos");
INSERT INTO `wp_postmeta` VALUES("15117", "81757", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15118", "81758", "url_article", "https://www.foodengineeringmag.com/articles/97332-how-smucker-deals-with-fsma-during-product-development");
INSERT INTO `wp_postmeta` VALUES("15119", "81758", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15120", "81759", "url_article", "https://www.foodengineeringmag.com/articles/97341-chocolate-biscuits-recalled-due-to-undeclared-peanuts");
INSERT INTO `wp_postmeta` VALUES("15121", "81759", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15122", "81760", "url_article", "https://www.foodengineeringmag.com/articles/97329-kings-hawaiian-settles-lawsuit-over-sweet-roll-packaging");
INSERT INTO `wp_postmeta` VALUES("15123", "81760", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15124", "81761", "url_article", "https://www.foodengineeringmag.com/articles/97297-dolco-launches-custom-trays-for-meat-and-poultry-processors");
INSERT INTO `wp_postmeta` VALUES("15125", "81761", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15126", "81762", "url_article", "https://www.foodengineeringmag.com/articles/97298-sidel-partners-with-coca-cola-to-create-new-fanta-bottle");
INSERT INTO `wp_postmeta` VALUES("15127", "81762", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15128", "81763", "url_article", "https://www.foodengineeringmag.com/articles/97306-how-retail-changes-are-affecting-packaging");
INSERT INTO `wp_postmeta` VALUES("15129", "81763", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15130", "81764", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2014/12/maxima-velocidad-para-un-sistema-de-vision.-42605.php");
INSERT INTO `wp_postmeta` VALUES("15131", "81764", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15132", "81765", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2014/12/seminario-para-la-certificacion-cmse-de-pilz-42577.php");
INSERT INTO `wp_postmeta` VALUES("15133", "81765", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15134", "81766", "url_article", "https://www.foodengineeringmag.com/articles/97269-consumers-demanding-more-sustainable-packaging");
INSERT INTO `wp_postmeta` VALUES("15135", "81766", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15136", "81767", "url_article", "https://www.foodbev.com/news/aldi-aims-cut-waste-move-away-single-use-plastic-bags/");
INSERT INTO `wp_postmeta` VALUES("15137", "81767", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15138", "81768", "url_article", "https://www.foodengineeringmag.com/articles/97265-maxwell-chases-new-packaging-extends-seafood-shelf-life");
INSERT INTO `wp_postmeta` VALUES("15139", "81768", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15140", "81769", "url_article", "https://www.foodbev.com/news/berlin-packaging-acquires-uk-based-manufacturer-erben/");
INSERT INTO `wp_postmeta` VALUES("15141", "81769", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15142", "81770", "url_article", "https://www.foodengineeringmag.com/articles/97261-mcdonalds-pledges-all-sustainable-packaging-by-2025");
INSERT INTO `wp_postmeta` VALUES("15143", "81770", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15144", "81771", "url_article", "http://www.red.es/redes/es/actualidad/magazin-en-red/c%C3%B3mo-participar-en-el-pabell%C3%B3n-de-espa%C3%B1a-del-pr%C3%B3ximo-mobile-world-congress");
INSERT INTO `wp_postmeta` VALUES("15145", "81771", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15146", "81772", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2014/11/mejor-oferta-e-innovacion-en-el-hispack-mas-internacional-42546.php");
INSERT INTO `wp_postmeta` VALUES("15147", "81772", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("15148", "81773", "url_article", "https://www.foodengineeringmag.com/articles/97191-processor-cuts-packaging-line-downtime");
INSERT INTO `wp_postmeta` VALUES("15149", "81773", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15150", "81774", "url_article", "https://www.foodengineeringmag.com/articles/97244-tree-top-works-with-sonoco-to-launch-clear-pouches");
INSERT INTO `wp_postmeta` VALUES("15151", "81774", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15152", "81775", "url_article", "http://feeds.lexblog.com/~r/foodsafetynews/mRcs/~3/h_3nSEnGzIs/");
INSERT INTO `wp_postmeta` VALUES("15153", "81775", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("15154", "81776", "url_article", "http://feeds.lexblog.com/~r/foodsafetynews/mRcs/~3/BCnCxhOZwGg/");
INSERT INTO `wp_postmeta` VALUES("15155", "81776", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15156", "81777", "url_article", "http://feeds.lexblog.com/~r/foodsafetynews/mRcs/~3/8kdx4MPKtQg/");
INSERT INTO `wp_postmeta` VALUES("15157", "81777", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15158", "81778", "url_article", "http://feeds.lexblog.com/~r/foodsafetynews/mRcs/~3/KVzra8M8wCg/");
INSERT INTO `wp_postmeta` VALUES("15159", "81778", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15160", "81779", "url_article", "http://feeds.lexblog.com/~r/foodsafetynews/mRcs/~3/-fz1mCGDDJY/");
INSERT INTO `wp_postmeta` VALUES("15161", "81779", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("15162", "81780", "url_article", "http://feeds.lexblog.com/~r/foodsafetynews/mRcs/~3/XJxojcaH_4E/");
INSERT INTO `wp_postmeta` VALUES("15163", "81780", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15164", "81781", "url_article", "http://www.red.es/redes/es/actualidad/magazin-en-red/islas-inteligentes-c%C3%B3mo-reducir-los-efectos-negativos-de-la-insularidad");
INSERT INTO `wp_postmeta` VALUES("15165", "81781", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15166", "81782", "url_article", "http://feeds.lexblog.com/~r/foodsafetynews/mRcs/~3/8N0dBA25-aw/");
INSERT INTO `wp_postmeta` VALUES("15167", "81782", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15168", "81783", "url_article", "https://www.foodengineeringmag.com/articles/97190-conitex-sonoco-launches-multi-layer-barrier-bags");
INSERT INTO `wp_postmeta` VALUES("15169", "81783", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15170", "81784", "url_article", "http://www.coca-colacompany.com/stories/ground-zero-for-what-s-new-and-what-s-next-why-coke-s-venturing-emerging-brands-team-keeps-coming-back-to-natural-products-expowest");
INSERT INTO `wp_postmeta` VALUES("15171", "81784", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15172", "81785", "url_article", "https://www.foodengineeringmag.com/articles/97202-diet-coke-launches-4-new-flavors-updated-packaging");
INSERT INTO `wp_postmeta` VALUES("15173", "81785", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15174", "81786", "url_article", "http://www.coca-colacompany.com/stories/zico-stokes-americas-growing-love-affair-with-coconut-water--unv");
INSERT INTO `wp_postmeta` VALUES("15175", "81786", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15176", "81787", "url_article", "http://www.coca-colacompany.com/press-center/press-releases/the-coca-cola-company-announces-letter-of-intent-for-refranchising-canadian-bottling-operations");
INSERT INTO `wp_postmeta` VALUES("15177", "81787", "interes", "15");
INSERT INTO `wp_postmeta` VALUES("15178", "81788", "url_article", "http://www.seimed.eu/vlx/rss/clickHandler.asp?mi=LOCAL&id=TOES20151229002&EnquiryType=BBS");
INSERT INTO `wp_postmeta` VALUES("15179", "81788", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15180", "81789", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2014/10/lectores-de-codigos-de-barras-sumergibles-42434.php");
INSERT INTO `wp_postmeta` VALUES("15181", "81789", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15182", "81790", "url_article", "https://www.foodengineeringmag.com/articles/97148-packaging-trends-mintel-expects-to-see-in-2018");
INSERT INTO `wp_postmeta` VALUES("15183", "81790", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15184", "81791", "url_article", "http://www.coca-colacompany.com/stories/making-strides-in-sustainable-packaging-a-design-feat");
INSERT INTO `wp_postmeta` VALUES("15185", "81791", "interes", "14");
INSERT INTO `wp_postmeta` VALUES("15186", "81792", "url_article", "http://www.coca-colacompany.com/stories/an-inflection-point-coca-cola-ceo-says-company-is-poised-for-disciplined-growth");
INSERT INTO `wp_postmeta` VALUES("15187", "81792", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("15188", "81793", "url_article", "http://www.seimed.eu/vlx/rss/clickHandler.asp?mi=LOCAL&id=TOES20150922001&EnquiryType=BBS");
INSERT INTO `wp_postmeta` VALUES("15189", "81793", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15190", "81794", "url_article", "http://www.red.es/redes/es/actualidad/magazin-en-red/%E2%80%9Ctu-%C3%A9xito-online-con-el-es%E2%80%9D-revela-las-principales-pr%C3%A1cticas-para-triunfar");
INSERT INTO `wp_postmeta` VALUES("15191", "81794", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15192", "81795", "url_article", "http://www.foodprocessing-technology.com/./packaged-food/");
INSERT INTO `wp_postmeta` VALUES("15193", "81795", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15194", "81796", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2014/07/-que-hacemos-ahora-con-los-carteros-42363.php");
INSERT INTO `wp_postmeta` VALUES("15195", "81796", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15196", "81797", "url_article", "http://www.foodprocessing-technology.com/videos/packaged-food");
INSERT INTO `wp_postmeta` VALUES("15197", "81797", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15198", "81798", "url_article", "https://www.foodengineeringmag.com/articles/97106-heatgenies-single-serve-beverages-self-heat");
INSERT INTO `wp_postmeta` VALUES("15199", "81798", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15200", "81799", "url_article", "https://www.foodengineeringmag.com/articles/97056-new-mentos-gum-packs-feature-velcro-brand-closures");
INSERT INTO `wp_postmeta` VALUES("15201", "81799", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15202", "81800", "url_article", "https://www.foodengineeringmag.com/articles/97090-how-mccormick-is-working-toward-more-sustainable-packaging");
INSERT INTO `wp_postmeta` VALUES("15203", "81800", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("15204", "81801", "url_article", "https://www.foodengineeringmag.com/articles/97042-pack-expo-demo-shows-how-drones-will-deliver-packages");
INSERT INTO `wp_postmeta` VALUES("15205", "81801", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15206", "81802", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOIL20180117003&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("15207", "81802", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15208", "81803", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2014/07/amec-reivindica-una-politica-industrial-clara-estable-y-sostenible-42322.php");
INSERT INTO `wp_postmeta` VALUES("15209", "81803", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15210", "81804", "url_article", "https://www.foodengineeringmag.com/articles/96998-clay-packaging-could-help-preserve-produce");
INSERT INTO `wp_postmeta` VALUES("15211", "81804", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15212", "81805", "url_article", "https://www.foodengineeringmag.com/articles/97177-fda-announces-enforcement-discretion-for-specific-fsma-regulations");
INSERT INTO `wp_postmeta` VALUES("15213", "81805", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15214", "81806", "url_article", "http://www.seimed.eu/vlx/rss/clickHandler.asp?mi=LOCAL&id=BOES20140224005&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("15215", "81806", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15216", "81807", "url_article", "https://www.foodengineeringmag.com/articles/96992-us-packaging-industry-market-value-approaching-10-billion");
INSERT INTO `wp_postmeta` VALUES("15217", "81807", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15218", "81808", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOES20170131001&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("15219", "81808", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15220", "81809", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2014/06/seguridad-alimentaria-garantizada-por-una-alta-calidad-del-aire-comprimido-42287.php");
INSERT INTO `wp_postmeta` VALUES("15221", "81809", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15222", "81810", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2014/06/internacionalizacion-y-un-espacio-para-la-maquinaria-de-pasteleria-en-el-bta-barcelona-42276.php");
INSERT INTO `wp_postmeta` VALUES("15223", "81810", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("15224", "81811", "url_article", "http://www.fooddrinkeurope.eu/news/statement/fooddrinkeurope-statement-on-the-eu-strategy-for-plastics");
INSERT INTO `wp_postmeta` VALUES("15225", "81811", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15226", "81812", "url_article", "http://www.seimed.eu/vlx/rss/clickHandler.asp?mi=LOCAL&id=BOES20150304001&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("15227", "81812", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15228", "81813", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOTR20171102001&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("15229", "81813", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15230", "81814", "url_article", "https://www.foodengineeringmag.com/articles/96938-tetrapak-highlights-need-for-ar-digital-packaging");
INSERT INTO `wp_postmeta` VALUES("15231", "81814", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15232", "81815", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2014/06/el-sueno-de-un-fabricante-de-maquinas-eliminar-el-armario-de-control-42248.php");
INSERT INTO `wp_postmeta` VALUES("15233", "81815", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15234", "81816", "url_article", "https://www.foodengineeringmag.com/articles/96937-how-ecommerce-will-change-food-and-beverage-packaging");
INSERT INTO `wp_postmeta` VALUES("15235", "81816", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15236", "81817", "url_article", "http://www.foodprocessing-technology.com/./features/packaged-food");
INSERT INTO `wp_postmeta` VALUES("15237", "81817", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15238", "81818", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2014/05/i-encuentro-sectorial-del-instituto-del-envase-y-embalaje-42229.php");
INSERT INTO `wp_postmeta` VALUES("15239", "81818", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15240", "81819", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2014/05/la-feria-mas-importante-del-mundo-para-el-sector-de-packaging-42232.php");
INSERT INTO `wp_postmeta` VALUES("15241", "81819", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("15242", "81820", "url_article", "http://www.foodprocessing-technology.com/whitepapers/packaged-food");
INSERT INTO `wp_postmeta` VALUES("15243", "81820", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15244", "81821", "url_article", "https://www.foodengineeringmag.com/articles/96841-packaging-technology-helps-processors-meet-challenges");
INSERT INTO `wp_postmeta` VALUES("15245", "81821", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15246", "81822", "url_article", "https://www.industriaalimenticia.com/articles/87628-presentacion-de-tech-stage-en-fruit-logistica-2015");
INSERT INTO `wp_postmeta` VALUES("15247", "81822", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15248", "81823", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2014/05/la-industria-plastica-pide-medidas-para-incrementar-su-competitividad-42212.php");
INSERT INTO `wp_postmeta` VALUES("15249", "81823", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15250", "81824", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2014/04/la-maquinaria-espanola-consolida-su-presencia-en-interpack-37954.php");
INSERT INTO `wp_postmeta` VALUES("15251", "81824", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("15252", "81825", "url_article", "http://www.seimed.eu/vlx/rss/clickHandler.asp?mi=LOCAL&id=TOES20150203003&EnquiryType=BBS");
INSERT INTO `wp_postmeta` VALUES("15253", "81825", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15254", "81826", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2014/04/omron-presentara-en-interpack-su-plataforma-de-control-para-procesos-de-envasado-37941.php");
INSERT INTO `wp_postmeta` VALUES("15255", "81826", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15256", "81827", "url_article", "http://www.foodprocessing-technology.com/projects/packaged-food");
INSERT INTO `wp_postmeta` VALUES("15257", "81827", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15258", "81828", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2014/04/hispack-2015-apuesta-por-la-innovacion-aplicada-a-la-demanda-37943.php");
INSERT INTO `wp_postmeta` VALUES("15259", "81828", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15260", "81829", "url_article", "http://www.seimed.eu/vlx/rss/clickHandler.asp?mi=LOCAL&id=BRES20150122001&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("15261", "81829", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15262", "81830", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2014/04/rockwell-automation-reune-a-300-profesionales-en-el-automation-university-special-37923.php");
INSERT INTO `wp_postmeta` VALUES("15263", "81830", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15264", "81831", "url_article", "https://www.industriaalimenticia.com/articles/87454-control-de-temperatura-y-co-en-empaque");
INSERT INTO `wp_postmeta` VALUES("15265", "81831", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15266", "81832", "url_article", "https://www.fda.gov/Safety/Recalls/ucm600560.htm");
INSERT INTO `wp_postmeta` VALUES("15267", "81832", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15268", "81833", "url_article", "http://www.automaticaeinstrumentacion.com/es/notices/2014/04/machinestruxure-sigue-evolucionando-37922.php");
INSERT INTO `wp_postmeta` VALUES("15269", "81833", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15270", "81834", "url_article", "http://www.foodprocessing-technology.com/./news/packaged-food");
INSERT INTO `wp_postmeta` VALUES("15271", "81834", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15272", "81835", "url_article", "https://www.fda.gov/Safety/Recalls/ucm598166.htm");
INSERT INTO `wp_postmeta` VALUES("15273", "81835", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15274", "81836", "url_article", "https://www.fda.gov/ForConsumers/ConsumerUpdates/ucm208365.htm");
INSERT INTO `wp_postmeta` VALUES("15275", "81836", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15276", "81837", "url_article", "http://www.foodprocessing-technology.com/contractors/quality_control/mettler-toledo/");
INSERT INTO `wp_postmeta` VALUES("15277", "81837", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15278", "81838", "url_article", "https://www.fda.gov/Safety/Recalls/ucm600415.htm");
INSERT INTO `wp_postmeta` VALUES("15279", "81838", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15280", "81839", "url_article", "https://www.fda.gov/Safety/MedWatch/SafetyInformation/SafetyAlertsforHumanMedicalProducts/ucm596590.htm");
INSERT INTO `wp_postmeta` VALUES("15281", "81839", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15282", "81840", "url_article", "https://www.dairyreporter.com/Article/2018/03/12/CCL-Industries-in-talks-to-acquire-Treofan-America?utm_source=RSS_Feed&utm_medium=RSS&utm_campaign=RSS");
INSERT INTO `wp_postmeta` VALUES("15283", "81840", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15284", "81841", "url_article", "https://www.fda.gov/Safety/MedWatch/SafetyInformation/SafetyAlertsforHumanMedicalProducts/ucm594403.htm");
INSERT INTO `wp_postmeta` VALUES("15285", "81841", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15286", "81842", "url_article", "https://www.bakeryandsnacks.com/Article/2018/03/06/Riverside-Natural-Foods-sees-demand-grow-for-small-bags-of-healthy-snacks?utm_source=RSS_Feed&utm_medium=RSS&utm_campaign=RSS");
INSERT INTO `wp_postmeta` VALUES("15287", "81842", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15288", "81843", "url_article", "https://www.bakeryandsnacks.com/Article/2018/03/09/TC-Transcontinental-acquires-Multifilm-Packaging-Corp?utm_source=RSS_Feed&utm_medium=RSS&utm_campaign=RSS");
INSERT INTO `wp_postmeta` VALUES("15289", "81843", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15290", "81844", "url_article", "https://www.foodqualitynews.com/Article/2018/03/01/Colpac-launches-Compostable-Ovenable-Tray?utm_source=RSS_Feed&utm_medium=RSS&utm_campaign=RSS");
INSERT INTO `wp_postmeta` VALUES("15291", "81844", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15292", "81845", "url_article", "https://www.confectionerynews.com/Article/2018/03/12/British-designer-turns-sticky-chewing-gum-waste-into-recycled-products?utm_source=RSS_Feed&utm_medium=RSS&utm_campaign=RSS");
INSERT INTO `wp_postmeta` VALUES("15293", "81845", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15294", "81846", "url_article", "http://www.revistabeautyprof.com/es/notices/2018/03/el-gobierno-aprueba-el-nuevo-rd-para-la-regulacion-de-los-productos-cosmeticos-72577.php");
INSERT INTO `wp_postmeta` VALUES("15295", "81846", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15296", "81847", "url_article", "http://www.mineco.gob.es:80/portal/site/mineco/menuitem.ac30f9268750bd56a0b0240e026041a0/?vgnextoid=727580f6aba81610VgnVCM1000001d04140aRCRD&vgnextchannel=864e154527515310VgnVCM1000001d04140aRCRD");
INSERT INTO `wp_postmeta` VALUES("15297", "81847", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15298", "81848", "url_article", "http://www.revistabeautyprof.com/es/notices/2018/02/hispack-2018-crecera-en-expositores-e-internacionalidad-72565.php");
INSERT INTO `wp_postmeta` VALUES("15299", "81848", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("15300", "81849", "url_article", "http://www.revistabeautyprof.com/es/notices/2018/03/industria-4.0-un-antes-y-un-despues-para-el-sector-cosmetico-72576.php");
INSERT INTO `wp_postmeta` VALUES("15301", "81849", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15302", "81850", "url_article", "http://www.foodprocessing-technology.com/suppliers/packaged-food");
INSERT INTO `wp_postmeta` VALUES("15303", "81850", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15304", "81851", "url_article", "http://www.revistabeautyprof.com/es/notices/2018/02/aspack-reune-a-fabricantes-proveedores-y-clientes-en-el-iii-foro-de-la-cadena-de-valor-del-envase-d-72564.php");
INSERT INTO `wp_postmeta` VALUES("15305", "81851", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15306", "81852", "url_article", "http://www.envapack.com/2018/03/una-cadena-para-empaquetadoras-autolubricada-para-uso-en-industria-de-alimentos/");
INSERT INTO `wp_postmeta` VALUES("15307", "81852", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15308", "81853", "url_article", "http://www.envapack.com/2018/03/alpesa-presenta-en-la-feria-modex-de-atlanta-su-upalet-de-carton/");
INSERT INTO `wp_postmeta` VALUES("15309", "81853", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15310", "81854", "url_article", "http://www.envapack.com/2018/03/la-legislacion-sobre-residuos-de-la-union-europea-reconoce-los-beneficios-de-los-bioplasticos/");
INSERT INTO `wp_postmeta` VALUES("15311", "81854", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("15312", "81855", "url_article", "http://www.envapack.com/2018/03/eu-waste-legislation-recognises-benefits-of-bioplastics/");
INSERT INTO `wp_postmeta` VALUES("15313", "81855", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15314", "81856", "url_article", "http://www.envapack.com/2018/03/nueva-promocion-del-pollo-kfc-en-la-india-una-caja-dron-para-armar/");
INSERT INTO `wp_postmeta` VALUES("15315", "81856", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15316", "81857", "url_article", "https://www.composites-manufacturing.com/web-industries-unveils-new-spoolkit-logistics-solution/");
INSERT INTO `wp_postmeta` VALUES("15317", "81857", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("15318", "81858", "url_article", "http://www.envapack.com/2018/03/sidel-se-asocia-a-coca-cola-para-desarrollar-un-nuevo-diseno-de-botella-de-fanta-en-pet/");
INSERT INTO `wp_postmeta` VALUES("15319", "81858", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15320", "81859", "url_article", "http://www.envapack.com/2018/02/technology-and-design-sacmi-adds-value-to-the-us-market/");
INSERT INTO `wp_postmeta` VALUES("15321", "81859", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15322", "81860", "url_article", "http://www.envapack.com/2018/02/calendario-ferias-y-eventos-2018/");
INSERT INTO `wp_postmeta` VALUES("15323", "81860", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15324", "81861", "url_article", "https://www.preparedfoods.com/articles/120938-sabra-introduces-new-logo-packaging");
INSERT INTO `wp_postmeta` VALUES("15325", "81861", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15326", "81862", "url_article", "http://www.envapack.com/2018/02/tecnologia-y-diseno-sacmi-agrega-valor-al-mercado-estadounidense/");
INSERT INTO `wp_postmeta` VALUES("15327", "81862", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15328", "81863", "url_article", "http://www.envapack.com/2018/02/el-duo-perfecto-greiner-packaging-empaca-la-innovacion-en-detergentes-de-henkel/");
INSERT INTO `wp_postmeta` VALUES("15329", "81863", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("15330", "81864", "url_article", "http://www.envapack.com/2018/03/la-legislacion-sobre-residuos-de-la-union-europea-reconoce-los-beneficios-de-los-bioplasticos/comment-page-1/#comment-18242");
INSERT INTO `wp_postmeta` VALUES("15331", "81864", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15332", "81865", "url_article", "http://www.foodprocessing-technology.com/./comment/packaged-food");
INSERT INTO `wp_postmeta` VALUES("15333", "81865", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15334", "81866", "url_article", "http://www.envapack.com/2018/02/pequenas-maquinas-para-empaque-en-pymes/comment-page-1/#comment-18238");
INSERT INTO `wp_postmeta` VALUES("15335", "81866", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15336", "81867", "url_article", "http://www.envapack.com/diplomado/comment-page-1/#comment-18241");
INSERT INTO `wp_postmeta` VALUES("15337", "81867", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15338", "81868", "url_article", "https://www.composites-manufacturing.com/made-to-endure/");
INSERT INTO `wp_postmeta` VALUES("15339", "81868", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("15340", "81869", "url_article", "http://www.envapack.com/2018/02/pequenas-maquinas-para-empaque-en-pymes/comment-page-1/#comment-18237");
INSERT INTO `wp_postmeta` VALUES("15341", "81869", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15342", "81870", "url_article", "http://www.envapack.com/diplomado/comment-page-1/#comment-18231");
INSERT INTO `wp_postmeta` VALUES("15343", "81870", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15344", "81871", "url_article", "http://www.envapack.com/diplomado/comment-page-1/#comment-18235");
INSERT INTO `wp_postmeta` VALUES("15345", "81871", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15346", "81872", "url_article", "https://www.composites-manufacturing.com/new-electric-vehicle-platform-provides-fast-track-next-generation/");
INSERT INTO `wp_postmeta` VALUES("15347", "81872", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("15348", "81873", "url_article", "https://www.preparedfoods.com/articles/120903-newly-weds-foods-acquires-mullins-food-products");
INSERT INTO `wp_postmeta` VALUES("15349", "81873", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15350", "81874", "url_article", "https://www.composites-manufacturing.com/lightweight-electric-vehicle-engineering-showcased-jec-world/");
INSERT INTO `wp_postmeta` VALUES("15351", "81874", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("15352", "81875", "url_article", "https://www.composites-manufacturing.com/teledyne-cml-composites-brings-new-autoclave-line/");
INSERT INTO `wp_postmeta` VALUES("15353", "81875", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15354", "81876", "url_article", "https://www.fsai.ie/uploadedFiles/Legislation/Legislation_Update/EU_QA_recycled_plastics.pdf");
INSERT INTO `wp_postmeta` VALUES("15355", "81876", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15356", "81877", "url_article", "http://www.packagingtoday.co.uk/news/newslateral-thinking-inspires-cross-category-innovation-in-packaging-says-globaldata-6079912");
INSERT INTO `wp_postmeta` VALUES("15357", "81877", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15358", "81878", "url_article", "https://www.composites-manufacturing.com/moldex-composites-acquires-stake-mct-engineering/");
INSERT INTO `wp_postmeta` VALUES("15359", "81878", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15360", "81879", "url_article", "https://www.packworld.com/article/machinery/labeling/label-printers/afinia-label-digital-color-label-printer");
INSERT INTO `wp_postmeta` VALUES("15361", "81879", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("15362", "81880", "url_article", "http://www.packagingtoday.co.uk/news/newsconsumer-demand-and-legislation-driving-issues-addressed-by-inaugural-industrial-pack-conference-program-6079907");
INSERT INTO `wp_postmeta` VALUES("15363", "81880", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15364", "81881", "url_article", "http://www.packagingtoday.co.uk/news/newsresearch-from-smithers-pira-and-pro-carton-suggests-true-packaging-sustainability-is-at-risk-6078178");
INSERT INTO `wp_postmeta` VALUES("15365", "81881", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15366", "81882", "url_article", "http://www.packagingtoday.co.uk/news/newsdalehead-foods-unveils-ground-breaking-recyclable-packaging-for-the-fresh-market-6078180");
INSERT INTO `wp_postmeta` VALUES("15367", "81882", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15368", "81883", "url_article", "https://www.packworld.com/article/package-type/containers/tin/science-freshness");
INSERT INTO `wp_postmeta` VALUES("15369", "81883", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("15370", "81884", "url_article", "http://www.packagingtoday.co.uk/news/newsi2r-packaging-solutions-boosts-production-with-ongoing-investments-6077738");
INSERT INTO `wp_postmeta` VALUES("15371", "81884", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15372", "81885", "url_article", "http://www.packagingtoday.co.uk/news/newsten-reasons-to-attend-uks-largest-packaging-event-6067368");
INSERT INTO `wp_postmeta` VALUES("15373", "81885", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15374", "81886", "url_article", "http://www.packagingtoday.co.uk/news/newssaica-pack-scoops-four-gold-wins-at-the-starpack-2018-awards-6075291");
INSERT INTO `wp_postmeta` VALUES("15375", "81886", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15376", "81887", "url_article", "http://www.packagingtoday.co.uk/news/newsinnovation-at-the-forefront-of-uks-largest-packaging-show-6064647");
INSERT INTO `wp_postmeta` VALUES("15377", "81887", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15378", "81888", "url_article", "https://www.packworld.com/article/contract-packaging/contract-packaging-news-trends/unlocking-speed-market");
INSERT INTO `wp_postmeta` VALUES("15379", "81888", "interes", "14");
INSERT INTO `wp_postmeta` VALUES("15380", "81889", "url_article", "https://www.fsai.ie/news_centre/allergen_alerts/recall_tesco_choc_cake.html");
INSERT INTO `wp_postmeta` VALUES("15381", "81889", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15382", "81890", "url_article", "https://www.packworld.com/article/package-design/strategy/create-packaging-personality");
INSERT INTO `wp_postmeta` VALUES("15383", "81890", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("15384", "81891", "url_article", "http://www.packagingtoday.co.uk/news/newsnew-research-highlights-personalised-packaging-trends-6051537");
INSERT INTO `wp_postmeta` VALUES("15385", "81891", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15386", "81892", "url_article", "https://www.packworld.com/article/sustainability/recycling/pepsicos-robust-recycling-initiative");
INSERT INTO `wp_postmeta` VALUES("15387", "81892", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("15388", "81893", "url_article", "http://www.packagingtoday.co.uk/news/newsglobal-brands-take-centre-stage-at-uks-largest-packaging-show-6040111");
INSERT INTO `wp_postmeta` VALUES("15389", "81893", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15390", "81894", "url_article", "https://www.packworld.com/article/package-type/cartons-and-boxes/box/paperboard/innovative-design-concepts-case-built-pallet");
INSERT INTO `wp_postmeta` VALUES("15391", "81894", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15392", "81895", "url_article", "http://ceepackaging.com/2017/03/27/tetrosyl-using-new-hdpe-container-for-ad-blue/");
INSERT INTO `wp_postmeta` VALUES("15393", "81895", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15394", "81896", "url_article", "https://www.packworld.com/article/controls/motors/drives/applied-motion-stepper-drive");
INSERT INTO `wp_postmeta` VALUES("15395", "81896", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15396", "81897", "url_article", "http://ceepackaging.com/2017/03/27/ds-smith-chooses-kba-large-format-for-facility-in-erlensee/");
INSERT INTO `wp_postmeta` VALUES("15397", "81897", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15398", "81898", "url_article", "https://www.packworld.com/article/controls/machine-components/wiring-products/icotek-narrow-shield-clamps-confined-spaces");
INSERT INTO `wp_postmeta` VALUES("15399", "81898", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15400", "81899", "url_article", "https://www.packworld.com/article/controls/sensors/banner-engineering-vibration-monitoring-sensor");
INSERT INTO `wp_postmeta` VALUES("15401", "81899", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15402", "81900", "url_article", "http://ceepackaging.com/2017/03/27/mondi-optimises-portfolio/");
INSERT INTO `wp_postmeta` VALUES("15403", "81900", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15404", "81901", "url_article", "https://www.packworld.com/article/machinery/labeling/pallet-labeler/better-inventory-management");
INSERT INTO `wp_postmeta` VALUES("15405", "81901", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15406", "81902", "url_article", "http://ceepackaging.com/2017/03/27/mingustos-use-stand-up-pouch-for-cucumber/");
INSERT INTO `wp_postmeta` VALUES("15407", "81902", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15408", "81903", "url_article", "https://www.packworld.com/article/hpp-seal-launches");
INSERT INTO `wp_postmeta` VALUES("15409", "81903", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15410", "81904", "url_article", "http://ceepackaging.com/2017/03/27/sustainable-alternatives-to-polyvinylidene-chloride-coated-films/");
INSERT INTO `wp_postmeta` VALUES("15411", "81904", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15412", "81905", "url_article", "https://www.packworld.com/article/package-type/containers/lidded-container/non-round/italian-olives-pack-shelf-appeal");
INSERT INTO `wp_postmeta` VALUES("15413", "81905", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("15414", "81906", "url_article", "https://www.fsis.usda.gov/wps/portal/fsis/topics/recalls-and-public-health-alerts/recall-case-archive/archive/2017/recall-130-2017-release");
INSERT INTO `wp_postmeta` VALUES("15415", "81906", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15416", "81907", "url_article", "https://www.packworld.com/article/machinery/labeling/label-printers/afinia-label-adjust-labels-fly");
INSERT INTO `wp_postmeta` VALUES("15417", "81907", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15418", "81908", "url_article", "https://www.packworld.com/article/machinery/conveying-material-handling/handling/key-technology-specialized-vibratory-conveyor");
INSERT INTO `wp_postmeta` VALUES("15419", "81908", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("15420", "81909", "url_article", "https://www.food.gov.uk/enforcement/alerts/2015/14216/j-k-smokery-ltd-recalls-smoked-fish");
INSERT INTO `wp_postmeta` VALUES("15421", "81909", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15422", "81910", "url_article", "https://www.fsai.ie/uploadedImages/News_Centre/Allergens_Alerts/FSAI_-_Food_Allergen_Alerts/Plamil%20Chocolate%20front%20label.jpg");
INSERT INTO `wp_postmeta` VALUES("15423", "81910", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15424", "81911", "url_article", "https://www.packworld.com/article/package-component/films/trutag-technologies-laminate");
INSERT INTO `wp_postmeta` VALUES("15425", "81911", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("15426", "81912", "url_article", "https://www.packworld.com/article/trends-and-issues/pmmi/aip-national-conference-brisbane");
INSERT INTO `wp_postmeta` VALUES("15427", "81912", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("15428", "81913", "url_article", "https://www.packworld.com/article/applications/beverage/beer/clever-pallet-layer-formation");
INSERT INTO `wp_postmeta` VALUES("15429", "81913", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15430", "81914", "url_article", "https://www.fsai.ie/news_centre/allergen_alerts/Lindt_barley.html");
INSERT INTO `wp_postmeta` VALUES("15431", "81914", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15432", "81915", "url_article", "https://www.packworld.com/article/machinery/codingmarking/digital/digital-printing-helps-label-maker-meet-customer-demands");
INSERT INTO `wp_postmeta` VALUES("15433", "81915", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("15434", "81916", "url_article", "https://www.packworld.com/article/controls/machine-components/balluff-io-modules");
INSERT INTO `wp_postmeta` VALUES("15435", "81916", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15436", "81917", "url_article", "https://www.newfoodmagazine.com/news/65286/diabetics-standardise-labelling/");
INSERT INTO `wp_postmeta` VALUES("15437", "81917", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15438", "81918", "url_article", "https://www.packworld.com/article/applications/industrial-products/new-application-ocean-bound-plastic");
INSERT INTO `wp_postmeta` VALUES("15439", "81918", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15440", "81919", "url_article", "https://www.jwtintelligence.com/2018/03/sustainable-supermarkets/");
INSERT INTO `wp_postmeta` VALUES("15441", "81919", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("15442", "81920", "url_article", "https://www.newfoodmagazine.com/news/65283/innovative-solutions-problems-funding/");
INSERT INTO `wp_postmeta` VALUES("15443", "81920", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15444", "81921", "url_article", "https://www.food.gov.uk/enforcement/alerts/2015/14041/asda-recalls-cooked-and-peeled-king-prawns");
INSERT INTO `wp_postmeta` VALUES("15445", "81921", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15446", "81922", "url_article", "https://www.packworld.com/article/packaging-public-policy-problem-solver");
INSERT INTO `wp_postmeta` VALUES("15447", "81922", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("15448", "81923", "url_article", "https://www.fsai.ie/uploadedImages/News_Centre/Allergens_Alerts/FSAI_-_Food_Allergen_Alerts/Lidl%20back%20of%20pack.png");
INSERT INTO `wp_postmeta` VALUES("15449", "81923", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15450", "81924", "url_article", "https://www.packworld.com/when-regulators-turn-you-help");
INSERT INTO `wp_postmeta` VALUES("15451", "81924", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15452", "81925", "url_article", "https://www.packworld.com/article/silver-lining-starting-scratch");
INSERT INTO `wp_postmeta` VALUES("15453", "81925", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("15454", "81926", "url_article", "https://www.packworld.com/article/tomorrows-tech-already-here");
INSERT INTO `wp_postmeta` VALUES("15455", "81926", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15456", "81927", "url_article", "https://www.packworld.com/article/industry-watch-march-2018");
INSERT INTO `wp_postmeta` VALUES("15457", "81927", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("15458", "81928", "url_article", "https://www.packworld.com/article/applications/consumer-products/packaging-storyteller");
INSERT INTO `wp_postmeta` VALUES("15459", "81928", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15460", "81929", "url_article", "https://www.packworld.com/article/ratchet-engagement");
INSERT INTO `wp_postmeta` VALUES("15461", "81929", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15462", "81930", "url_article", "https://www.packworld.com/article/machinery/inspection/fortress-technology-metal-detector-wet-products");
INSERT INTO `wp_postmeta` VALUES("15463", "81930", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("15464", "81931", "url_article", "https://www.packworld.com/article/trends-and-issues/business-intelligence/five-key-business-opportunities-packaging-services");
INSERT INTO `wp_postmeta` VALUES("15465", "81931", "interes", "16");
INSERT INTO `wp_postmeta` VALUES("15466", "81932", "url_article", "https://www.packworld.com/article/club-stores-claim-environmental-responsibility-while-shifting-burden");
INSERT INTO `wp_postmeta` VALUES("15467", "81932", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("15468", "81933", "url_article", "https://www.fsai.ie/uploadedImages/News_Centre/Food_Alerts/Food__Alert_Listings/ADLI%20BACK%20OF%20PACK%20CLEAR%20PIC.png");
INSERT INTO `wp_postmeta` VALUES("15469", "81933", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15470", "81934", "url_article", "https://www.fsai.ie/news_centre/food_alerts/recall_the_cheese_hub.html");
INSERT INTO `wp_postmeta` VALUES("15471", "81934", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15472", "81935", "url_article", "https://www.elconfidencial.com/economia/2018-03-04/plan-sanidad-composicion-alimentos-azucar-sal-grasas_1527411/");
INSERT INTO `wp_postmeta` VALUES("15473", "81935", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15474", "81936", "url_article", "https://www.fsai.ie/uploadedImages/News_Centre/Food_Alerts/Food__Alert_Listings/ADLI%20FRONT%20OF%20PACK%20CLEAR%20PIC.png");
INSERT INTO `wp_postmeta` VALUES("15475", "81936", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15476", "81937", "url_article", "https://www.dairyreporter.com/Article/2018/03/07/Smurfit-Kappa-rejects-International-Paper-buy-out?utm_source=RSS_Feed&utm_medium=RSS&utm_campaign=RSS");
INSERT INTO `wp_postmeta` VALUES("15477", "81937", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15478", "81938", "url_article", "https://www.beveragedaily.com/Article/2018/03/09/Minor-Figures-redesigns-nitro-cold-brew-coffee-cans?utm_source=RSS_Feed&utm_medium=RSS&utm_campaign=RSS");
INSERT INTO `wp_postmeta` VALUES("15479", "81938", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15480", "81939", "url_article", "https://www.beveragedaily.com/Article/2018/03/06/US-beverage-industry-dismayed-over-proposed-10-aluminum-tariff?utm_source=RSS_Feed&utm_medium=RSS&utm_campaign=RSS");
INSERT INTO `wp_postmeta` VALUES("15481", "81939", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15482", "81940", "url_article", "https://www.beveragedaily.com/Article/2018/03/07/Berlin-Packaging-expands-geographical-reach-with-Erben-acquisition?utm_source=RSS_Feed&utm_medium=RSS&utm_campaign=RSS");
INSERT INTO `wp_postmeta` VALUES("15483", "81940", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15484", "81941", "url_article", "https://www.foodengineeringmag.com/articles/97260-us-yogurt-market-sales-approach-9-billion-at-retail");
INSERT INTO `wp_postmeta` VALUES("15485", "81941", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15486", "81942", "url_article", "http://www.mineco.gob.es:80/portal/site/mineco/menuitem.ac30f9268750bd56a0b0240e026041a0/?vgnextoid=91d0c816d95c1410VgnVCM1000001d04140aRCRD&vgnextchannel=864e154527515310VgnVCM1000001d04140aRCRD");
INSERT INTO `wp_postmeta` VALUES("15487", "81942", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15488", "81943", "url_article", "https://www.sweetpress.com/hispack-2018-un-salon-de-interes-para-toda-la-cadena-de-suministro/");
INSERT INTO `wp_postmeta` VALUES("15489", "81943", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("15490", "81944", "url_article", "https://www.sweetpress.com/joven-skater-david-parrilla-protagoniza-la-nueva-campana-cola-cao/");
INSERT INTO `wp_postmeta` VALUES("15491", "81944", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15492", "81945", "url_article", "https://www.sweetpress.com/gonzalo-zubia-red-bull-sabor-salud-los-dos-aspectos-los-mas-se-innova-bebidas/");
INSERT INTO `wp_postmeta` VALUES("15493", "81945", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15494", "81946", "url_article", "https://www.sweetpress.com/los-nuevos-habitos-de-consumo-revitalizan-la-industria-de-bebidas/");
INSERT INTO `wp_postmeta` VALUES("15495", "81946", "interes", "27");
INSERT INTO `wp_postmeta` VALUES("15496", "81947", "url_article", "https://www.cosmeticsdesign.com/Article/2018/03/05/L-Oreal-hair-care-brand-teams-up-with-TerraCycle-to-reduce-plastic-packaging-waste?utm_source=RSS_Feed&utm_medium=RSS&utm_campaign=RSS");
INSERT INTO `wp_postmeta` VALUES("15497", "81947", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15498", "81948", "url_article", "https://www.sweetpress.com/gran-consumo-crece-2017-contexto-marcado-los-habitos-saludables/");
INSERT INTO `wp_postmeta` VALUES("15499", "81948", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15500", "81949", "url_article", "https://www.fsai.ie/news_centre/food_alerts/recall_dunnesstores_chickpeas.html");
INSERT INTO `wp_postmeta` VALUES("15501", "81949", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15502", "81950", "url_article", "http://www.efeagro.com/noticia/dcoop-4/");
INSERT INTO `wp_postmeta` VALUES("15503", "81950", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15504", "81951", "url_article", "https://www.sweetpress.com/kellog-innova-con-super-ingredientes-para-ofrecer-un-estilo-de-vida-mas-sano/");
INSERT INTO `wp_postmeta` VALUES("15505", "81951", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15506", "81952", "url_article", "https://www.sweetpress.com/aperitivos-flaper-premio-bankia-la-mejor-pyme/");
INSERT INTO `wp_postmeta` VALUES("15507", "81952", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15508", "81953", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BORO20180122002&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("15509", "81953", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15510", "81954", "url_article", "https://www.sweetpress.com/facil-consumo-los-formatos-on-the-go-propicia-crecimiento-exponencial/");
INSERT INTO `wp_postmeta` VALUES("15511", "81954", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("15512", "81955", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOPT20160524001&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("15513", "81955", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15514", "81956", "url_article", "https://www.fsai.ie/uploadedImages/News_Centre/Food_Alerts/Food__Alert_Listings/Hero%20Sprouts.png");
INSERT INTO `wp_postmeta` VALUES("15515", "81956", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15516", "81957", "url_article", "https://www.sweetpress.com/crecen-los-zumos-refrigerados-alto-valor-anadido/");
INSERT INTO `wp_postmeta` VALUES("15517", "81957", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15518", "81958", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOUK20180206002&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("15519", "81958", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15520", "81959", "url_article", "https://www.sweetpress.com/el-manisero-pone-las-fallas-en-tu-mano/");
INSERT INTO `wp_postmeta` VALUES("15521", "81959", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15522", "81960", "url_article", "https://www.sweetpress.com/agua-envasada-mercado-mas-dinamico-la-industria-bebidas/");
INSERT INTO `wp_postmeta` VALUES("15523", "81960", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15524", "81961", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOUK20171026001&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("15525", "81961", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15526", "81962", "url_article", "https://www.sweetpress.com/conveniencia-salud-los-drivers-perfilan-mercado-bebidas/");
INSERT INTO `wp_postmeta` VALUES("15527", "81962", "interes", "14");
INSERT INTO `wp_postmeta` VALUES("15528", "81963", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOPL20161209002&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("15529", "81963", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15530", "81964", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=TOIT20160901001&EnquiryType=BBS");
INSERT INTO `wp_postmeta` VALUES("15531", "81964", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15532", "81965", "url_article", "https://www.fsai.ie/news_centre/food_alerts/big_als_glutenandwheatfree_goujons_recall.html");
INSERT INTO `wp_postmeta` VALUES("15533", "81965", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15534", "81966", "url_article", "https://www.sweetpress.com/si-el-equipo-tiene-ambicion-consecuencia-natural-es-exito/");
INSERT INTO `wp_postmeta` VALUES("15535", "81966", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15536", "81967", "url_article", "https://www.sweetpress.com/productos-horneados-se-comercializan-14-paises/");
INSERT INTO `wp_postmeta` VALUES("15537", "81967", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15538", "81968", "url_article", "https://www.sweetpress.com/nestle-resultados-2017/");
INSERT INTO `wp_postmeta` VALUES("15539", "81968", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15540", "81969", "url_article", "https://www.sweetpress.com/nuevas-ligeras-sabor-albahaca-lanzamiento-mas-mediterraneo-frit-ravich/");
INSERT INTO `wp_postmeta` VALUES("15541", "81969", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15542", "81970", "url_article", "https://www.sweetpress.com/mix-legumbres-aperitivo-aquellos-quieren-cuidarse-sin-renunciar-sabor/");
INSERT INTO `wp_postmeta` VALUES("15543", "81970", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15544", "81971", "url_article", "https://www.sweetpress.com/se-venden-los-productos-dekora-innova/");
INSERT INTO `wp_postmeta` VALUES("15545", "81971", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15546", "81972", "url_article", "http://www.efeagro.com/noticia/insectos-alimentacion-animal/");
INSERT INTO `wp_postmeta` VALUES("15547", "81972", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15548", "81973", "url_article", "https://www.sweetpress.com/tna-aboga-mayor-rendimiento-calidad-nuevo-sistema-seleccion-medicion-vibratorio/");
INSERT INTO `wp_postmeta` VALUES("15549", "81973", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15550", "81974", "url_article", "https://www.sweetpress.com/aperitivos-horneados-crecimiento-solido-mercado-expansion/");
INSERT INTO `wp_postmeta` VALUES("15551", "81974", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15552", "81975", "url_article", "http://feeds.weblogssl.com/~r/xataka2/~3/owEnXUNfkwI/la-produccion-del-model-3-ya-le-preocupa-tanto-a-elon-musk-como-su-paranoia-con-el-peligro-de-la-ia");
INSERT INTO `wp_postmeta` VALUES("15553", "81975", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15554", "81976", "url_article", "https://www.sweetpress.com/el-gran-consumo-crece-un-37-en-un-entorno-de-leve-inflacion-caracterizado-por-la-innovacion/");
INSERT INTO `wp_postmeta` VALUES("15555", "81976", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15556", "81977", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOCZ20160704001&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("15557", "81977", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15558", "81978", "url_article", "http://www.seimed.eu/vlx/services/enquire.asp?id=BOFR20160512001&EnquiryType=BCD");
INSERT INTO `wp_postmeta` VALUES("15559", "81978", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15560", "81979", "url_article", "https://www.sweetpress.com/fabricantes-aperitivos-horneados-potencian-factor-natural/");
INSERT INTO `wp_postmeta` VALUES("15561", "81979", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("15562", "81980", "url_article", "http://www.revistadyna.com/Canales/Ficha.aspx?IdMenu=0072bd32-0de8-4bcc-8428-72b40b04ac04&Cod=6d57a791-e47b-4604-8a42-94cbd0e26743");
INSERT INTO `wp_postmeta` VALUES("15563", "81980", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15564", "81981", "url_article", "https://www.sweetpress.com/la-firme-apuesta-empresarial/");
INSERT INTO `wp_postmeta` VALUES("15565", "81981", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("15566", "81982", "url_article", "http://www.aimme.es/informacion/informativo/ficha.asp?id=3421");
INSERT INTO `wp_postmeta` VALUES("15567", "81982", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15568", "81983", "url_article", "http://www.aimme.es/informacion/informativo/ficha.asp?id=3416");
INSERT INTO `wp_postmeta` VALUES("15569", "81983", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15570", "81984", "url_article", "https://www.sweetpress.com/mejor-marketing-tiene-calidad-premium-y-sabor-a-paella/");
INSERT INTO `wp_postmeta` VALUES("15571", "81984", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15572", "81985", "url_article", "http://www.revistadyna.com/Canales/Ficha.aspx?IdMenu=0072bd32-0de8-4bcc-8428-72b40b04ac04&Cod=a8989046-4cc9-42db-bc52-2cde6664b47d");
INSERT INTO `wp_postmeta` VALUES("15573", "81985", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15574", "81986", "url_article", "http://www.foodnewslatam.com/empresas/62-procesos-envases/7677-tetra-pak%C2%AE-es-la-empresa-l%C3%ADder-mundial-en-soluciones-de-procesado-y-envasado-de-alimentos.html");
INSERT INTO `wp_postmeta` VALUES("15575", "81986", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15576", "81987", "url_article", "https://www.sweetpress.com/huesitos-tokke-ya-representan-17-del-segmento-barritas/");
INSERT INTO `wp_postmeta` VALUES("15577", "81987", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15578", "81988", "url_article", "http://www.revistadyna.com/Canales/Ficha.aspx?IdMenu=0072bd32-0de8-4bcc-8428-72b40b04ac04&Cod=a13d9c5c-ebd5-489d-8d1d-7b3b84fe429f");
INSERT INTO `wp_postmeta` VALUES("15579", "81988", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15580", "81989", "url_article", "http://www.revistadyna.com/Articulos/Ficha.aspx?IdMenu=26e5f45a-7fdd-456b-8088-fad6a8390778&Cod=8600");
INSERT INTO `wp_postmeta` VALUES("15581", "81989", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15582", "81990", "url_article", "http://www.redtransfer.org/blog/7o-convocatoria-de-ayudas-para-startups-innovadoras-en-el-ambito-de-la-energia-la-movilidad-avanzada-la-economia-circular-y-los-nuevos-materiales/");
INSERT INTO `wp_postmeta` VALUES("15583", "81990", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15584", "81991", "url_article", "https://www.preparedfoods.com/articles/111152-at-the-mill");
INSERT INTO `wp_postmeta` VALUES("15585", "81991", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15586", "81992", "url_article", "https://www.preparedfoods.com/articles/120910-us-food-market-outlook-5-key-trends");
INSERT INTO `wp_postmeta` VALUES("15587", "81992", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15588", "81993", "url_article", "https://www.preparedfoods.com/articles/120925-organic-clean-label-products-hispanic-consumers");
INSERT INTO `wp_postmeta` VALUES("15589", "81993", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15590", "81994", "url_article", "https://www.oftex.es/exportaciones-vino-espanol/");
INSERT INTO `wp_postmeta` VALUES("15591", "81994", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15592", "81995", "url_article", "https://www.preparedfoods.com/articles/110769-whiteout-");
INSERT INTO `wp_postmeta` VALUES("15593", "81995", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15594", "81996", "url_article", "http://www.agromeat.com/235292/bruselas-pone-en-marcha-este-martes-un-centro-de-expertos-para-combatir-el-fraude-alimentario-en-la-ue");
INSERT INTO `wp_postmeta` VALUES("15595", "81996", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15596", "81997", "url_article", "https://www.elconfidencial.com/tecnologia/2018-03-10/nintendo-labo-switch-carton-como-funciona-precio_1533167/");
INSERT INTO `wp_postmeta` VALUES("15597", "81997", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15598", "81998", "url_article", "http://feedproxy.google.com/~r/B2C_News/~3/oXpcLO9DlBU/chinese-tourist-arrested-kenya-300-zebra-penises-luggage-fake-news-02028571");
INSERT INTO `wp_postmeta` VALUES("15599", "81998", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15600", "81999", "url_article", "https://www.preparedfoods.com/articles/120797-mintel-predicts-five-global-packaging-trends");
INSERT INTO `wp_postmeta` VALUES("15601", "81999", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15602", "82000", "url_article", "http://feedproxy.google.com/~r/B2C_Tech/~3/-HxzyIa2Kv0/blockchain-technology-penetrating-every-entrepreneurial-pursuit-02025088");
INSERT INTO `wp_postmeta` VALUES("15603", "82000", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15604", "82001", "url_article", "http://www.quimicaysociedad.org/2018/03/08/la-industria-busca-acercarse-a-la-sociedad-con-la-economia-circular/");
INSERT INTO `wp_postmeta` VALUES("15605", "82001", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15606", "82002", "url_article", "http://feedproxy.google.com/~r/B2C_Lifestyle/~3/j5Sy3HmIHvM/posh-suv-lincoln-navigator-black-label-02028772");
INSERT INTO `wp_postmeta` VALUES("15607", "82002", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("15608", "82003", "url_article", "http://feedproxy.google.com/~r/B2C_News/~3/wDrHXzPAweA/sustainability-efforts-good-business-02022045");
INSERT INTO `wp_postmeta` VALUES("15609", "82003", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("15610", "82004", "url_article", "http://feedproxy.google.com/~r/B2C_Social/~3/WkVATwBpbP8/95-simple-ways-generate-massive-amounts-website-traffic-02026645");
INSERT INTO `wp_postmeta` VALUES("15611", "82004", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("15612", "82005", "url_article", "http://feedproxy.google.com/~r/B2C_Lifestyle/~3/BIpON8LGe64/american-idol-noah-davis-moves-hollywood-gets-closer-dream-owning-pack-alpacas-02028615");
INSERT INTO `wp_postmeta` VALUES("15613", "82005", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15614", "82006", "url_article", "http://www.salux-project.eu/en/web/work-package-49");
INSERT INTO `wp_postmeta` VALUES("15615", "82006", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15616", "82007", "url_article", "http://feedproxy.google.com/~r/B2C_Social/~3/CcJgsEczzZU/biggest-ecommerce-trends-need-know-02024731");
INSERT INTO `wp_postmeta` VALUES("15617", "82007", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("15618", "82008", "url_article", "http://www.foodanddrinktechnology.com/19889/news/ardagh-creates-aluminium-bottles-for-health-drinks-sector/");
INSERT INTO `wp_postmeta` VALUES("15619", "82008", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("15620", "82009", "url_article", "https://worldwide.espacenet.com/publicationDetails/biblio?CC=TW&NR=M488875U&KC=U&FT=D&DB=worldwide.espacenet.com&locale=es_LP&date=20141101&rss=true");
INSERT INTO `wp_postmeta` VALUES("15621", "82009", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15622", "82010", "url_article", "http://blog.wolfram.com/2018/03/08/roaring-into-2018-with-another-big-release-launching-version-11-3-of-the-wolfram-language-mathematica/");
INSERT INTO `wp_postmeta` VALUES("15623", "82010", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15624", "82011", "url_article", "http://www.postharvest.biz/en/news/the-blueberry-conference-2018-the-largest-in-the-world-analizes-opportunities-and-chalenges/_id:80325/");
INSERT INTO `wp_postmeta` VALUES("15625", "82011", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15626", "82012", "url_article", "http://www.postharvest.biz/en/company/constantly-growing-african-market/_id:16591,noticia:78386,seccion:noticias/");
INSERT INTO `wp_postmeta` VALUES("15627", "82012", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15628", "82013", "url_article", "http://www.postharvest.biz/en/news/effect-of-non-chemical-crop-load-regulation-on-apple-fruit-quality-assessed-by-the-da-meter/_id:80319/");
INSERT INTO `wp_postmeta` VALUES("15629", "82013", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15630", "82014", "url_article", "http://www.postharvest.biz/en/company/news-in-clip2clip-giro-packaging/_id:27614,noticia:78384,seccion:noticias/");
INSERT INTO `wp_postmeta` VALUES("15631", "82014", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15632", "82015", "url_article", "http://www.postharvest.biz/en/company/decco-worldwide-made-a-great-impact-at-fruit-logistica-2018/_id:32468,noticia:78385,seccion:noticias/");
INSERT INTO `wp_postmeta` VALUES("15633", "82015", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15634", "82016", "url_article", "http://www.foodanddrinktechnology.com/19909/news/ccep-announces-10m-brand-refresh-for-diet-coke/");
INSERT INTO `wp_postmeta` VALUES("15635", "82016", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15636", "82017", "url_article", "http://www.foodanddrinktechnology.com/19898/news/ardagh-invests-in-deeside-plant/");
INSERT INTO `wp_postmeta` VALUES("15637", "82017", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15638", "82018", "url_article", "http://blog.wolfram.com/2018/01/18/running-the-numbers-with-the-illinois-marathon-viewer/");
INSERT INTO `wp_postmeta` VALUES("15639", "82018", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15640", "82019", "url_article", "http://www.postharvest.biz/en/news/more-about-postharvest-february-8th-2018/_id:80308/");
INSERT INTO `wp_postmeta` VALUES("15641", "82019", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("15642", "82020", "url_article", "http://www.foodanddrinktechnology.com/19910/news/iceland-unveils-new-ranges-as-part-of-plastics-free-pledge/");
INSERT INTO `wp_postmeta` VALUES("15643", "82020", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15644", "82021", "url_article", "http://www.postharvest.biz/en/company/italy-one-of-top-five-ue-recyclers/_id:61408,noticia:78378,seccion:noticias/");
INSERT INTO `wp_postmeta` VALUES("15645", "82021", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15646", "82022", "url_article", "http://www.foodanddrinktechnology.com/19917/news/easter-eggs-for-grown-ups/");
INSERT INTO `wp_postmeta` VALUES("15647", "82022", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15648", "82023", "url_article", "http://www.postharvest.biz/en/company/exhibitor-deadline-for-asia-fruit-logistica/_id:35874,noticia:78375,seccion:noticias/");
INSERT INTO `wp_postmeta` VALUES("15649", "82023", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15650", "82024", "url_article", "http://www.postharvest.biz/en/company/tomra-continues-expansion-in-global-food-sorting-solutions-sector-with-acquisition-of-bbc-technologies/_id:62802,noticia:78376,seccion:noticias/");
INSERT INTO `wp_postmeta` VALUES("15651", "82024", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("15652", "82025", "url_article", "http://www.anugafoodtec.com/aft/press/press-releases/index.php?aktion=pfach&p1id=kmpresse_afte&format=html&base=&tp=k3content&search=&pmid=kmeigen.kmpresse_0750_2018pm18_e&start=0&anzahl=10&channel=kmeigen&language=e");
INSERT INTO `wp_postmeta` VALUES("15653", "82025", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15654", "82026", "url_article", "http://www.postharvest.biz/en/company/macfrut-an-opportunity-for-foreign-buyers/_id:35911,noticia:78374,seccion:noticias/");
INSERT INTO `wp_postmeta` VALUES("15655", "82026", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15656", "82027", "url_article", "http://www.postharvest.biz/en/company/wyma-vege-polishers-rotary-filter-screen-absorbent-drying-rollers-and-conveyors-are-the-solutions-for-lunekartoffel-potato-processing-line/_id:62767,noticia:78302,seccion:noticias/");
INSERT INTO `wp_postmeta` VALUES("15657", "82027", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15658", "82028", "url_article", "http://www.foodanddrinktechnology.com/19894/back-issues/march-2018/");
INSERT INTO `wp_postmeta` VALUES("15659", "82028", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15660", "82029", "url_article", "http://www.postharvest.biz/en/news/improvements-in-citrus-packing-lines-to-reduce-the-mechanical-damage-to-fruit/_id:80284/");
INSERT INTO `wp_postmeta` VALUES("15661", "82029", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("15662", "82030", "url_article", "http://www.foodincanada.com/food-in-canada/another-super-berry-emerges-salal-berry-139236/");
INSERT INTO `wp_postmeta` VALUES("15663", "82030", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15664", "82031", "url_article", "http://www.postharvest.biz/en/company/high-speed-packing-robot-maximum-accuracy-measuring-system-for-packinghouse-machinery/_id:16591,noticia:78371,seccion:noticias/");
INSERT INTO `wp_postmeta` VALUES("15665", "82031", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15666", "82032", "url_article", "http://www.foodanddrinktechnology.com/19877/news/uks-student-food-innovation-competition-offers-2000-prize/");
INSERT INTO `wp_postmeta` VALUES("15667", "82032", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15668", "82033", "url_article", "http://www.postharvest.biz/en/company/what-is-postharvest/_id:32468,noticia:78368,seccion:noticias/");
INSERT INTO `wp_postmeta` VALUES("15669", "82033", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15670", "82034", "url_article", "http://www.postharvest.biz/en/news/postharvest-application-of-oxalic-acid-delayed-the-ripening-process-of-nijisseiki-pear/_id:80285/");
INSERT INTO `wp_postmeta` VALUES("15671", "82034", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15672", "82035", "url_article", "http://www.postharvest.biz/en/news/more-about-postharvest-december-14th-2017/_id:80278/");
INSERT INTO `wp_postmeta` VALUES("15673", "82035", "interes", "16");
INSERT INTO `wp_postmeta` VALUES("15674", "82036", "url_article", "http://www.postharvest.biz/en/news/more-about-postharvest-december-21th-2017/_id:80281/");
INSERT INTO `wp_postmeta` VALUES("15675", "82036", "interes", "16");
INSERT INTO `wp_postmeta` VALUES("15676", "82037", "url_article", "http://www.postharvest.biz/en/news/different-pre-harvest-spraying-of-calcium-compounds-were-significantly-enhanced-mango-postharvest-quality/_id:80297/");
INSERT INTO `wp_postmeta` VALUES("15677", "82037", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15678", "82038", "url_article", "http://www.postharvest.biz/en/company/the-dot-on-the-apple-bizerbas-ldi-20-applies-labels-to-fruit/_id:25764,noticia:78366,seccion:noticias/");
INSERT INTO `wp_postmeta` VALUES("15679", "82038", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15680", "82039", "url_article", "http://www.postharvest.biz/en/company/giro-magazine-a-summary-of-solutions-in-net-packaging/_id:27614,noticia:78365,seccion:noticias/");
INSERT INTO `wp_postmeta` VALUES("15681", "82039", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("15682", "82040", "url_article", "http://misbotellasdevidrio.es/ventas-de-vino-y-cerveza/");
INSERT INTO `wp_postmeta` VALUES("15683", "82040", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15684", "82041", "url_article", "http://misbotellasdevidrio.es/vidrio-packaging-diseno/");
INSERT INTO `wp_postmeta` VALUES("15685", "82041", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15686", "82042", "url_article", "http://misbotellasdevidrio.es/cervezas-especiales/");
INSERT INTO `wp_postmeta` VALUES("15687", "82042", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15688", "82043", "url_article", "http://misbotellasdevidrio.es/packaging-en-2018/");
INSERT INTO `wp_postmeta` VALUES("15689", "82043", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("15690", "82044", "url_article", "http://www.foodanddrinktechnology.com/19867/news/phe-plans-to-cut-excess-calorie-consumption/");
INSERT INTO `wp_postmeta` VALUES("15691", "82044", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15692", "82045", "url_article", "http://misbotellasdevidrio.es/packaging-con-valor-anadido/");
INSERT INTO `wp_postmeta` VALUES("15693", "82045", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("15694", "82046", "url_article", "http://www.foodincanada.com/foodpress/x-ray-inspection/");
INSERT INTO `wp_postmeta` VALUES("15695", "82046", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15696", "82047", "url_article", "https://www.technion.ac.il/en/2018/02/nanoparticles-deliver-drugs-on-target/");
INSERT INTO `wp_postmeta` VALUES("15697", "82047", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15698", "82048", "url_article", "http://www.foodanddrinktechnology.com/19851/news/plastic-free-aisle-debuts-amsterdam/");
INSERT INTO `wp_postmeta` VALUES("15699", "82048", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15700", "82049", "url_article", "http://www.infocalidad.net/?noticia=iso-publica-la-nueva-version-del-estandar-14024-sobre-ecoetiquetado");
INSERT INTO `wp_postmeta` VALUES("15701", "82049", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15702", "82050", "url_article", "http://www.revistaaral.com/es/notices/2018/03/hero-lanza-una-nueva-generacion-de-confituras-79365.php");
INSERT INTO `wp_postmeta` VALUES("15703", "82050", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15704", "82051", "url_article", "http://www.revistaaral.com/es/notices/2018/03/danone-renueva-su-portfolio-con-el-lanzamiento-de-16-referencias-79349.php");
INSERT INTO `wp_postmeta` VALUES("15705", "82051", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15706", "82052", "url_article", "http://www.revistaaral.com/es/notices/2018/03/galletas-cereales-y-bolleria-se-adaptan-a-los-nuevos-habitos-de-consumo-79356.php");
INSERT INTO `wp_postmeta` VALUES("15707", "82052", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15708", "82053", "url_article", "https://www.beautypackaging.com/contents/view_breaking-news/2018-03-12/new-account-manager-at-sgb-packaging-group/");
INSERT INTO `wp_postmeta` VALUES("15709", "82053", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15710", "82054", "url_article", "http://www.infocalidad.net/?noticia=ecoembes-y-reds-impulsan-el-compromiso-de-la-sociedad-espanola-con-los-ods");
INSERT INTO `wp_postmeta` VALUES("15711", "82054", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15712", "82055", "url_article", "https://www.beautypackaging.com/contents/view_breaking-news/2018-03-08/videos-live-at-luxe-pack-and-makeup-in-la-part-2/");
INSERT INTO `wp_postmeta` VALUES("15713", "82055", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15714", "82056", "url_article", "https://www.beautypackaging.com/contents/view_breaking-news/2018-03-12/virospack-provides-custom-pack-for-galenic-skincare/");
INSERT INTO `wp_postmeta` VALUES("15715", "82056", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15716", "82057", "url_article", "https://www.beautypackaging.com/contents/view_breaking-news/2018-03-08/nacd-packaging-entries-which-will-win/");
INSERT INTO `wp_postmeta` VALUES("15717", "82057", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15718", "82058", "url_article", "https://www.beautypackaging.com/contents/view_breaking-news/2018-03-08/scenes-from-the-largest-cew-beauty-awards-product-demo-ever/");
INSERT INTO `wp_postmeta` VALUES("15719", "82058", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15720", "82059", "url_article", "https://www.beautypackaging.com/contents/view_breaking-news/2018-03-08/trends-in-global-cosmetic-packaging-market-predict-an-upswing/");
INSERT INTO `wp_postmeta` VALUES("15721", "82059", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15722", "82060", "url_article", "https://www.reportlinker.com/news/2014/02/Coca-Cola-Invests-In-Green-Mountain-Coffee-1093");
INSERT INTO `wp_postmeta` VALUES("15723", "82060", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15724", "82061", "url_article", "https://webgate.ec.europa.eu/rasff-window/consumers/?event=notificationDetail&NOTIF_REFERENCE=2018.0216");
INSERT INTO `wp_postmeta` VALUES("15725", "82061", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15726", "82062", "url_article", "https://www.reportlinker.com/news/2013/12/Oracle-Pays-1-5-Billion-For-Enterprise-Software-Maker-Responsys-To-Expand-Into-Online-Marketing-1062");
INSERT INTO `wp_postmeta` VALUES("15727", "82062", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15728", "82063", "url_article", "http://www.scielo.cl/scielo.php?script=sci_arttext&pid=S0718-50732012000100001");
INSERT INTO `wp_postmeta` VALUES("15729", "82063", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("15730", "82064", "url_article", "http://healthycanadians.gc.ca/recall-alert-rappel-avis/hc-sc/2018/66056a-eng.php");
INSERT INTO `wp_postmeta` VALUES("15731", "82064", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15732", "82065", "url_article", "http://healthycanadians.gc.ca/recall-alert-rappel-avis/hc-sc/2018/66158a-eng.php");
INSERT INTO `wp_postmeta` VALUES("15733", "82065", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15734", "82066", "url_article", "http://www.higieneambiental.com/tags/aenor");
INSERT INTO `wp_postmeta` VALUES("15735", "82066", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15736", "82067", "url_article", "http://healthycanadians.gc.ca/recall-alert-rappel-avis/hc-sc/2018/65960a-eng.php");
INSERT INTO `wp_postmeta` VALUES("15737", "82067", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15738", "82068", "url_article", "http://www.higieneambiental.com/tags/rodenticidas");
INSERT INTO `wp_postmeta` VALUES("15739", "82068", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("15740", "82069", "url_article", "https://www.reportlinker.com/news/2013/08/Fruit-and-Vegetable-Industry-Giant-Dole-Food-Goes-Private-983");
INSERT INTO `wp_postmeta` VALUES("15741", "82069", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15742", "82070", "url_article", "http://www.higieneambiental.com/productos-biocidas-y-equipos");
INSERT INTO `wp_postmeta` VALUES("15743", "82070", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15744", "82071", "url_article", "https://www.fsai.ie/news_centre/food_alerts/ikea_marshmallow_candy_recall.html");
INSERT INTO `wp_postmeta` VALUES("15745", "82071", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15746", "82072", "url_article", "https://www.fsai.ie/news_centre/food_alerts/Squidrecall.html");
INSERT INTO `wp_postmeta` VALUES("15747", "82072", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15748", "82073", "url_article", "https://www.fsai.ie/news_centre/food_alerts/VegiDeli_sausages_recall.html");
INSERT INTO `wp_postmeta` VALUES("15749", "82073", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15750", "82074", "url_article", "https://www.fsai.ie/news_centre/food_alerts/bradys_potato_salad_recall.html");
INSERT INTO `wp_postmeta` VALUES("15751", "82074", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15752", "82075", "url_article", "https://www.fsai.ie/news_centre/food_alerts/aldi_ballymorecrust_recall.html");
INSERT INTO `wp_postmeta` VALUES("15753", "82075", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15754", "82076", "url_article", "http://www.foodstandards.gov.au/industry/foodrecalls/recalls/Pages/default.aspx?page=4");
INSERT INTO `wp_postmeta` VALUES("15755", "82076", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15756", "82077", "url_article", "http://www.higieneambiental.com/mwads/click/273/Inicio");
INSERT INTO `wp_postmeta` VALUES("15757", "82077", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15758", "82078", "url_article", "https://www.fsai.ie/news_centre/food_alerts/falcon_labs_recall.html");
INSERT INTO `wp_postmeta` VALUES("15759", "82078", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15760", "82079", "url_article", "https://www.fsai.ie/news_centre/food_alerts/quorn_tikka_masala_recall.html");
INSERT INTO `wp_postmeta` VALUES("15761", "82079", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15762", "82080", "url_article", "https://www.fsai.ie/news_centre/food_alerts/habfoods_meats_recall.html");
INSERT INTO `wp_postmeta` VALUES("15763", "82080", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15764", "82081", "url_article", "http://www.foodstandards.gov.au/industry/foodrecalls/recalls/Pages/default.aspx?page=3");
INSERT INTO `wp_postmeta` VALUES("15765", "82081", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15766", "82082", "url_article", "http://www.foodstandards.gov.au/industry/foodrecalls/recalls/Pages/default.aspx?page=1");
INSERT INTO `wp_postmeta` VALUES("15767", "82082", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15768", "82083", "url_article", "http://www.higieneambiental.com/frontpage?page=6");
INSERT INTO `wp_postmeta` VALUES("15769", "82083", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15770", "82084", "url_article", "http://www.higieneambiental.com/frontpage?page=2");
INSERT INTO `wp_postmeta` VALUES("15771", "82084", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15772", "82085", "url_article", "https://cspinet.org/eating-healthy/foods-avoid");
INSERT INTO `wp_postmeta` VALUES("15773", "82085", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15774", "82086", "url_article", "http://www.higieneambiental.com/tags/desratizacion");
INSERT INTO `wp_postmeta` VALUES("15775", "82086", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15776", "82087", "url_article", "http://www.foodstandards.gov.au/industry/foodrecalls/recalls/Pages/default.aspx");
INSERT INTO `wp_postmeta` VALUES("15777", "82087", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15778", "82088", "url_article", "http://www.higieneambiental.com/tags/chinches");
INSERT INTO `wp_postmeta` VALUES("15779", "82088", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15780", "82089", "url_article", "http://www.foodstandards.gov.au/industry/foodrecalls/recalls/Pages/lanet-Food-Organic-Hemp-Vegan-Protein---Rich-Chocolate-Flavour.aspx");
INSERT INTO `wp_postmeta` VALUES("15781", "82089", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15782", "82090", "url_article", "https://www.reportlinker.com/news/2013/02/Tech-Giant-Oracle-Expands-Into-Networking-Equipment-Market-With-Acme-Packet-Acquisition-878");
INSERT INTO `wp_postmeta` VALUES("15783", "82090", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15784", "82091", "url_article", "http://www.foodstandards.gov.au/industry/foodrecalls/recalls/Pages/Macro-Natural-Sunflower-Kernels-500g.aspx");
INSERT INTO `wp_postmeta` VALUES("15785", "82091", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15786", "82092", "url_article", "http://www.higieneambiental.com/tags/prevenci%C3%B3n-de-riesgos");
INSERT INTO `wp_postmeta` VALUES("15787", "82092", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15788", "82093", "url_article", "https://www.reportlinker.com/news/2012/11/Japanese-Automakers-Aim-To-Win-Back-Customers-In-China-Car-Market-835");
INSERT INTO `wp_postmeta` VALUES("15789", "82093", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15790", "82094", "url_article", "http://www.foodstandards.gov.au/industry/foodrecalls/recalls/Pages/Jasper-+-Myrtle-bean-to-bar-handmade-chocolate-Spice-Rum-Dark-Chocolate-70g.aspx");
INSERT INTO `wp_postmeta` VALUES("15791", "82094", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15792", "82095", "url_article", "https://www.npd.com/wps/portal/npd/us/news/press-releases/2016/catch-em-all-while-charging-your-phone-pokemon-go-fuels-sales-of-portable-power-packs");
INSERT INTO `wp_postmeta` VALUES("15793", "82095", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15794", "82096", "url_article", "https://www.newscientist.com/article/2159464-just-one-cigarette-a-day-can-cause-serious-heart-problems/?utm_campaign=RSS%7CNSNS&utm_source=NSNS&utm_medium=RSS&utm_content=health&campaign_id=RSS%7CNSNS-health");
INSERT INTO `wp_postmeta` VALUES("15795", "82096", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15796", "82097", "url_article", "http://www.foodstandards.gov.au/news/Pages/-Call-for-submissions-on-managing-chemical-migration-from-packaging-into-food.aspx");
INSERT INTO `wp_postmeta` VALUES("15797", "82097", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15798", "82098", "url_article", "https://www.reportlinker.com/news/2012/03/US-Air-Travel-Shrinking-Capacities-Higher-Fares-The-Way-of-The-Future-685");
INSERT INTO `wp_postmeta` VALUES("15799", "82098", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15800", "82099", "url_article", "https://www.npd.com/wps/portal/npd/us/news/press-releases/2016/mayo-is-finally-a-member-of-the-restaurant-table-top-condiment-clique/");
INSERT INTO `wp_postmeta` VALUES("15801", "82099", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15802", "82100", "url_article", "https://www.reportlinker.com/news/2012/03/Apple-World-s-Most-Valuable-Company-Worth-500-Billion-673");
INSERT INTO `wp_postmeta` VALUES("15803", "82100", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15804", "82101", "url_article", "https://www.reportlinker.com/news/2012/03/Verismo-to-Give-Starbucks-an-Edge-in-Single-Cup-Coffee-Market-678");
INSERT INTO `wp_postmeta` VALUES("15805", "82101", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15806", "82102", "url_article", "https://oehha.ca.gov/public-information/fact-sheets");
INSERT INTO `wp_postmeta` VALUES("15807", "82102", "interes", "16");
INSERT INTO `wp_postmeta` VALUES("15808", "82103", "url_article", "http://hse.gov.uk/myth/myth-busting/2017/case410-children-banned-pack-lunches.htm");
INSERT INTO `wp_postmeta` VALUES("15809", "82103", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15810", "82104", "url_article", "https://oehha.ca.gov/about/help");
INSERT INTO `wp_postmeta` VALUES("15811", "82104", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("15812", "82105", "url_article", "https://gastronomiaycia.republica.com/2018/03/12/frutas-y-verduras-feas-la-belleza-y-el-gusto-estan-en-el-interior/");
INSERT INTO `wp_postmeta` VALUES("15813", "82105", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15814", "82105", "url_picture", "https://gastronomiaycia.republica.com/wp-content/uploads/2018/03/zanahorias_imperfectas-680x501.jpg");
INSERT INTO `wp_postmeta` VALUES("15815", "82106", "url_article", "https://www.reportlinker.com/news/2011/12/Verizon-Sets-Sights-On-Streaming-Video-Service-581");
INSERT INTO `wp_postmeta` VALUES("15816", "82106", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15817", "82107", "url_article", "https://gastronomiaycia.republica.com/2018/03/12/caballa-flambeada-caviar-coliflor-y-jalea-de-manzana-de-oscar-velasco/");
INSERT INTO `wp_postmeta` VALUES("15818", "82107", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15819", "82107", "url_picture", "https://gastronomiaycia.republica.com/wp-content/uploads/2018/03/caballa_flambeada_oscar_vel.jpg");
INSERT INTO `wp_postmeta` VALUES("15820", "82108", "url_article", "http://www.bbc.co.uk/news/science-environment-43293221");
INSERT INTO `wp_postmeta` VALUES("15821", "82108", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15822", "82109", "url_article", "https://www.npd.com/wps/portal/npd/us/news/press-releases/2016/nutrition-facts-label-overhaul-plan-comes-at-a-time-when-fewer-us-consumers-are-looking-at-the-label");
INSERT INTO `wp_postmeta` VALUES("15823", "82109", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15824", "82110", "url_article", "http://www.elika.net/es/industria_alimentaria_otros.asp?id=2124#ancla2124");
INSERT INTO `wp_postmeta` VALUES("15825", "82110", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15826", "82111", "url_article", "https://www.reportlinker.com/news/2011/11/Tobacco-Court-Rules-FDA-Can-t-Use-Graphic-Cigarette-Labels-516");
INSERT INTO `wp_postmeta` VALUES("15827", "82111", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15828", "82112", "url_article", "https://www.reportlinker.com/news/2011/10/Sharp-Decline-In-Premium-Air-Travel-Bad-Omen-For-Business-Travel-489");
INSERT INTO `wp_postmeta` VALUES("15829", "82112", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15830", "82113", "url_article", "https://www.reportlinker.com/news/2011/10/FedEx-Forecasts-Huge-Holiday-Season-487");
INSERT INTO `wp_postmeta` VALUES("15831", "82113", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15832", "82114", "url_article", "https://www.theguardian.com/artanddesign/gallery/2018/mar/08/bird-photographer-of-the-year-2018-in-pictures");
INSERT INTO `wp_postmeta` VALUES("15833", "82114", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15834", "82115", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/kerbside_waste_collection_schemes_may_need_optimisation_portugal_504na1_en.pdf");
INSERT INTO `wp_postmeta` VALUES("15835", "82115", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15836", "82116", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/processing_london_local_food_waste_anaerobic_digester_avoids_3pt9_tonnes_ghg_emissions_503na1_en.pdf");
INSERT INTO `wp_postmeta` VALUES("15837", "82116", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15838", "82117", "url_article", "http://www.elika.net/es/industria_alimentaria_etiquetado_trazabilidad.asp?id=1981#ancla1981");
INSERT INTO `wp_postmeta` VALUES("15839", "82117", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15840", "82118", "url_article", "http://www.elika.net/es/industria_alimentaria_higiene.asp?id=1953#ancla1953");
INSERT INTO `wp_postmeta` VALUES("15841", "82118", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15842", "82119", "url_article", "http://www.elika.net/es/industria_alimentaria_etiquetado_trazabilidad.asp?id=1930#ancla1930");
INSERT INTO `wp_postmeta` VALUES("15843", "82119", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15844", "82120", "url_article", "http://rss.sciencedirect.com/action/redirectFile?&zone=main&currentActivity=feed&usageType=outward&url=http%3A%2F%2Fwww.sciencedirect.com%2Fscience%3F_ob%3DGatewayURL%26_origin%3DIRSSSEARCH%26_method%3DcitationSearch%26_piikey%3DS0924224417304843%26_version%3D1%26md5%3D2c2452657646c503b9647772255a24f4");
INSERT INTO `wp_postmeta` VALUES("15845", "82120", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15846", "82121", "url_article", "http://feedproxy.google.com/~r/PersonalCareTruthOrScare/~3/jgSxuLjEF6A/");
INSERT INTO `wp_postmeta` VALUES("15847", "82121", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("15848", "82122", "url_article", "http://feedproxy.google.com/~r/PersonalCareTruthOrScare/~3/6_dEkY5DP3I/");
INSERT INTO `wp_postmeta` VALUES("15849", "82122", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15850", "82123", "url_article", "http://www.elika.net/es/riesgos_biologicos.asp?id=35#ancla1815");
INSERT INTO `wp_postmeta` VALUES("15851", "82123", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15852", "82124", "url_article", "http://www.agenciasinc.es/Noticias/El-fruto-del-mortino-retrasa-la-oxidacion-de-grasas-carnicas");
INSERT INTO `wp_postmeta` VALUES("15853", "82124", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15854", "82125", "url_article", "https://ehp.niehs.nih.gov/ehp2223/?utm_source=rss&utm_medium=rss&utm_campaign=ehp2223");
INSERT INTO `wp_postmeta` VALUES("15855", "82125", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("15856", "82126", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/reducing_railway_noise_vibration_life_cycle_assessments_help_decide_best_measures_493na4_en.pdf");
INSERT INTO `wp_postmeta` VALUES("15857", "82126", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15858", "82127", "url_article", "https://ehp.niehs.nih.gov/ehp2619/?utm_source=rss&utm_medium=rss&utm_campaign=ehp2619");
INSERT INTO `wp_postmeta` VALUES("15859", "82127", "interes", "14");
INSERT INTO `wp_postmeta` VALUES("15860", "82128", "url_article", "http://www.elika.net/es/industria_alimentaria_etiquetado_trazabilidad.asp?id=1755#ancla1755");
INSERT INTO `wp_postmeta` VALUES("15861", "82128", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15862", "82129", "url_article", "http://www.elika.net/es/industria_alimentaria_etiquetado_trazabilidad.asp?id=1748#ancla1748");
INSERT INTO `wp_postmeta` VALUES("15863", "82129", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15864", "82130", "url_article", "http://www.elika.net/es/industria_alimentaria_etiquetado_trazabilidad.asp?id=1727#ancla1727");
INSERT INTO `wp_postmeta` VALUES("15865", "82130", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15866", "82131", "url_article", "http://www.elika.net/es/noticias.asp?id=1904");
INSERT INTO `wp_postmeta` VALUES("15867", "82131", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15868", "82132", "url_article", "https://www.reportlinker.com/news/2011/08/HP-Scraps-TouchPad-Pulls-Out-of-PC-Business-408");
INSERT INTO `wp_postmeta` VALUES("15869", "82132", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15870", "82133", "url_article", "https://ehp.niehs.nih.gov/ehp2534/?utm_source=rss&utm_medium=rss&utm_campaign=ehp2534");
INSERT INTO `wp_postmeta` VALUES("15871", "82133", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("15872", "82134", "url_article", "https://www.reportlinker.com/news/2011/08/China-Unable-to-Release-Economy-Buffer-203");
INSERT INTO `wp_postmeta` VALUES("15873", "82134", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15874", "82135", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/greater_participation_technological_innovation_improve_waste_management_naples_489na2_en.pdf");
INSERT INTO `wp_postmeta` VALUES("15875", "82135", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15876", "82136", "url_article", "http://www.elika.net/es/industria_alimentaria_etiquetado_trazabilidad.asp?id=1689#ancla1689");
INSERT INTO `wp_postmeta` VALUES("15877", "82136", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15878", "82137", "url_article", "https://www.theguardian.com/cities/2018/mar/09/dirt-bikes-street-riders-motocross-freestyle-photo-essay-chino-mous-baltimore-wildout-wheelie-boyz");
INSERT INTO `wp_postmeta` VALUES("15879", "82137", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15880", "82138", "url_article", "https://www.theguardian.com/us-news/2018/mar/12/austin-bombs-texas-attack-link-previous-bombing-victims");
INSERT INTO `wp_postmeta` VALUES("15881", "82138", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15882", "82139", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/new_system_convert_food_waste_fertiliser_greenhouse_95pc_reduction_co2_479na1_en.pdf");
INSERT INTO `wp_postmeta` VALUES("15883", "82139", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15884", "82140", "url_article", "http://www.elika.net/es/industria_alimentaria_etiquetado_trazabilidad.asp?id=1552#ancla1552");
INSERT INTO `wp_postmeta` VALUES("15885", "82140", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15886", "82141", "url_article", "https://www.theguardian.com/business/shortcuts/2018/mar/12/pack-it-in-which-food-company-has-the-most-cynical-packaging");
INSERT INTO `wp_postmeta` VALUES("15887", "82141", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15888", "82141", "url_picture", "https://i.guim.co.uk/img/uploads/2017/10/06/Gavin_Haynes,_L.png?w=300&amp;q=55&amp;auto=format&amp;usm=12&amp;fit=max&amp;s=7929ce2f910bb5330cc342920a8aabae");
INSERT INTO `wp_postmeta` VALUES("15889", "82142", "url_article", "https://www.theguardian.com/uk-news/2018/mar/12/spy-scandal-uk-russia-relations-tumbling-what-next-skripal-salisbury-poisoning");
INSERT INTO `wp_postmeta` VALUES("15890", "82142", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("15891", "82142", "url_picture", "https://i.guim.co.uk/img/media/f6251943f50d44e55c53ee8efb7ec8b1679ee443/25_589_4544_2727/master/4544.jpg?w=300&amp;q=55&amp;auto=format&amp;usm=12&amp;fit=max&amp;s=f4a986f4ba960528f84091f75361ee58");
INSERT INTO `wp_postmeta` VALUES("15892", "82143", "url_article", "https://www.theguardian.com/society/2018/mar/12/nhs-faces-year-round-crisis-over-lack-of-social-care-says-council-chief-lambeth");
INSERT INTO `wp_postmeta` VALUES("15893", "82143", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15894", "82143", "url_picture", "https://i.guim.co.uk/img/media/9677f74284c0cca6d6bfa0a6f0cbf23975c1e5c7/0_173_6144_3686/master/6144.jpg?w=300&amp;q=55&amp;auto=format&amp;usm=12&amp;fit=max&amp;s=ed697235bc64f9d7cfc0386695b1a5b4");
INSERT INTO `wp_postmeta` VALUES("15895", "82144", "url_article", "https://www.theguardian.com/lifeandstyle/2018/mar/12/anna-joness-recipes-for-peanut-noodles-and-double-ginger-soba");
INSERT INTO `wp_postmeta` VALUES("15896", "82144", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15897", "82144", "url_picture", "https://i.guim.co.uk/img/uploads/2018/01/29/Anna_Jones,_L.png?w=300&amp;q=55&amp;auto=format&amp;usm=12&amp;fit=max&amp;s=9a1a69658eea60721d2d4e66c67f4e83");
INSERT INTO `wp_postmeta` VALUES("15898", "82145", "url_article", "https://www.theguardian.com/world/2018/mar/12/syria-ghouta-ceasefire-us-unilateral");
INSERT INTO `wp_postmeta` VALUES("15899", "82145", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15900", "82145", "url_picture", "https://i.guim.co.uk/img/media/fa812409efbd87745e41f70f2429ab8fcffb0fb7/484_507_2134_1280/master/2134.jpg?w=300&amp;q=55&amp;auto=format&amp;usm=12&amp;fit=max&amp;s=94c7f61b139865c14dc27b053666e0a3");
INSERT INTO `wp_postmeta` VALUES("15901", "82146", "url_article", "https://www.fda.gov/Safety/Recalls/ucm600725.htm");
INSERT INTO `wp_postmeta` VALUES("15902", "82146", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15903", "82147", "url_article", "https://www.fda.gov/Safety/Recalls/ucm600681.htm");
INSERT INTO `wp_postmeta` VALUES("15904", "82147", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15905", "82148", "url_article", "https://www.fda.gov/Safety/Recalls/ucm600691.htm");
INSERT INTO `wp_postmeta` VALUES("15906", "82148", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15907", "82149", "url_article", "https://www.fda.gov/Safety/Recalls/ucm600477.htm");
INSERT INTO `wp_postmeta` VALUES("15908", "82149", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15909", "82150", "url_article", "https://www.fda.gov/Safety/Recalls/ucm599724.htm");
INSERT INTO `wp_postmeta` VALUES("15910", "82150", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15911", "82151", "url_article", "https://www.cosmeticsbusiness.com/news/article_page/HCP_Packaging_exhibits_at_Cosmoprof_Bologna/140529");
INSERT INTO `wp_postmeta` VALUES("15912", "82151", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15913", "82152", "url_article", "https://www.fda.gov/Safety/Recalls/ucm599497.htm");
INSERT INTO `wp_postmeta` VALUES("15914", "82152", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15915", "82153", "url_article", "https://www.fda.gov/Safety/Recalls/ucm599502.htm");
INSERT INTO `wp_postmeta` VALUES("15916", "82153", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15917", "82154", "url_article", "https://www.fda.gov/Safety/Recalls/ucm599288.htm");
INSERT INTO `wp_postmeta` VALUES("15918", "82154", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15919", "82155", "url_article", "https://www.fsis.usda.gov/wps/portal/fsis/topics/recalls-and-public-health-alerts/recall-case-archive/archive/2018/recall-019-2018-release");
INSERT INTO `wp_postmeta` VALUES("15920", "82155", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15921", "82156", "url_article", "https://www.fda.gov/Safety/Recalls/ucm599261.htm");
INSERT INTO `wp_postmeta` VALUES("15922", "82156", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15923", "82157", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/citizens_recycle_absence_economic_incentives_malta_473na1_en.pdf");
INSERT INTO `wp_postmeta` VALUES("15924", "82157", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15925", "82158", "url_article", "https://www.fsis.usda.gov/wps/portal/fsis/topics/recalls-and-public-health-alerts/recall-case-archive/archive/2018/recall-018-2018-release");
INSERT INTO `wp_postmeta` VALUES("15926", "82158", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15927", "82159", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/environmental_impacts_ocean_energy_systems_471na2_en.pdf");
INSERT INTO `wp_postmeta` VALUES("15928", "82159", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15929", "82160", "url_article", "https://www.fda.gov/Safety/Recalls/ucm598889.htm");
INSERT INTO `wp_postmeta` VALUES("15930", "82160", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15931", "82161", "url_article", "https://www.fda.gov/Safety/Recalls/ucm598091.htm");
INSERT INTO `wp_postmeta` VALUES("15932", "82161", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15933", "82162", "url_article", "https://www.fda.gov/Safety/Recalls/ucm598158.htm");
INSERT INTO `wp_postmeta` VALUES("15934", "82162", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15935", "82163", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/circular_economy_mobile_phones_improved_waste_collection_longer_lifespans_470na2_en.pdf");
INSERT INTO `wp_postmeta` VALUES("15936", "82163", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15937", "82164", "url_article", "https://www.eurekalert.org/pub_releases/2018-03/indl-rrt030618.php");
INSERT INTO `wp_postmeta` VALUES("15938", "82164", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15939", "82165", "url_article", "http://www.elika.net/es/#ancla=1333");
INSERT INTO `wp_postmeta` VALUES("15940", "82165", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15941", "82166", "url_article", "https://www.fsis.usda.gov/wps/portal/fsis/topics/recalls-and-public-health-alerts/recall-case-archive/archive/2018/recall-014-2018-release");
INSERT INTO `wp_postmeta` VALUES("15942", "82166", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15943", "82167", "url_article", "https://www.fsis.usda.gov/wps/portal/fsis/topics/recalls-and-public-health-alerts/recall-case-archive/archive/2018/recall-011-2018-release");
INSERT INTO `wp_postmeta` VALUES("15944", "82167", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15945", "82168", "url_article", "https://www.fsis.usda.gov/wps/portal/fsis/topics/recalls-and-public-health-alerts/recall-case-archive/archive/2017/recall-107-2017-release");
INSERT INTO `wp_postmeta` VALUES("15946", "82168", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15947", "82169", "url_article", "https://www.fsis.usda.gov/wps/portal/fsis/topics/recalls-and-public-health-alerts/recall-case-archive/archive/2018/recall-009-2018-release");
INSERT INTO `wp_postmeta` VALUES("15948", "82169", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15949", "82170", "url_article", "https://www.fsis.usda.gov/wps/portal/fsis/topics/recalls-and-public-health-alerts/recall-case-archive/archive/2018/recall-004-2018-release");
INSERT INTO `wp_postmeta` VALUES("15950", "82170", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15951", "82171", "url_article", "https://www.food.gov.uk/news-updates/news/food-alerts");
INSERT INTO `wp_postmeta` VALUES("15952", "82171", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15953", "82172", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/waste_management_prioritised_environmental_behaviour_466na3_en.pdf");
INSERT INTO `wp_postmeta` VALUES("15954", "82172", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15955", "82173", "url_article", "https://www.fsis.usda.gov/wps/portal/fsis/topics/recalls-and-public-health-alerts/recall-case-archive/archive/2017/recall-131-2017-release");
INSERT INTO `wp_postmeta` VALUES("15956", "82173", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15957", "82174", "url_article", "https://www.food.gov.uk/news-updates/news/2018/16914/taipec-ltd-recalls-packs-of-yuki-love-mango-flavoured-and-litchi-flavoured-jelly-due-to-potential-choking-hazard");
INSERT INTO `wp_postmeta` VALUES("15958", "82174", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15959", "82175", "url_article", "https://www.food.gov.uk/news-updates/news/2018/16900/gluten-free-foods-ltd-recalls-barkat-organic-gluten-free-porridge-flakes");
INSERT INTO `wp_postmeta` VALUES("15960", "82175", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15961", "82176", "url_article", "https://www.food.gov.uk/news-updates/news/2018/16962/waitrose-recalls-waitrose-new-york-cheesecake-because-it-may-contain-strands-of-plastic");
INSERT INTO `wp_postmeta` VALUES("15962", "82176", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15963", "82177", "url_article", "https://www.fsis.usda.gov/wps/portal/fsis/newsroom/news-releases-statements-and-transcripts/news-release-archives-by-year/archive/2017/nr-081517-01");
INSERT INTO `wp_postmeta` VALUES("15964", "82177", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15965", "82178", "url_article", "https://www.fsis.usda.gov/wps/portal/fsis/topics/recalls-and-public-health-alerts/recall-case-archive/archive/2017/recall-084-2017-release");
INSERT INTO `wp_postmeta` VALUES("15966", "82178", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15967", "82179", "url_article", "https://www.food.gov.uk/news-updates/news/2018/16955/akm-foods-limited-recalls-zaiqa-gogo-pan-masala-mouth-freshener-rhodamine-b");
INSERT INTO `wp_postmeta` VALUES("15968", "82179", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15969", "82180", "url_article", "https://www.food.gov.uk/news-updates/news/2018/16910/young-s-recalls-chip-shop-fish-cakes-because-they-may-contain-pieces-of-plastic-and-metal");
INSERT INTO `wp_postmeta` VALUES("15970", "82180", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("15971", "82181", "url_article", "https://www.food.gov.uk/news-updates/news/2018/16923/booker-recalls-happy-shopper-tomato-ketchup-because-it-may-contain-pieces-of-plastic");
INSERT INTO `wp_postmeta` VALUES("15972", "82181", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15973", "82182", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/enhanced_waste_management_practices_reduce_carbon_emissions_support_lower_landfill_taxes_461na1_en.pdf");
INSERT INTO `wp_postmeta` VALUES("15974", "82182", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15975", "82183", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/perspectives_on_shipbreaking_economic_social_environmental_impacts_alang_sosiya_55si16_en.pdf");
INSERT INTO `wp_postmeta` VALUES("15976", "82183", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15977", "82184", "url_article", "https://www.efe.com/efe/english/world/protesting-farmers-pack-india-s-mumbai-over-failed-government-debt-pledges/50000262-3550196?utm_source=wwwefecom&utm_medium=rss&utm_campaign=rss");
INSERT INTO `wp_postmeta` VALUES("15978", "82184", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15979", "82185", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/environmental_impact_recycling_metals_from_ships_life_cycle_assessment_55si13_en.pdf");
INSERT INTO `wp_postmeta` VALUES("15980", "82185", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("15981", "82186", "url_article", "https://www.npd.com/wps/portal/npd/us/news/press-releases/2015/uv-combo-packs-spark-viewer-interest/");
INSERT INTO `wp_postmeta` VALUES("15982", "82186", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15983", "82187", "url_article", "https://foodsafetytech.com/column/automation-is-happening-dont-miss-the-boat/");
INSERT INTO `wp_postmeta` VALUES("15984", "82187", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("15985", "82188", "url_article", "https://foodsafetytech.com/column/innovation-fundamentals-start-food-safety-foundation/");
INSERT INTO `wp_postmeta` VALUES("15986", "82188", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("15987", "82189", "url_article", "http://www.elika.net/es/#ancla=1222");
INSERT INTO `wp_postmeta` VALUES("15988", "82189", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("15989", "82190", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/new_technique_developed_recycle_indium_from_waste_lcd_screens_457na3_en.pdf");
INSERT INTO `wp_postmeta` VALUES("15990", "82190", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("15991", "82191", "url_article", "https://www.foodsafetymagazine.com/categories/food-types-category/ingredients");
INSERT INTO `wp_postmeta` VALUES("15992", "82191", "interes", "14");
INSERT INTO `wp_postmeta` VALUES("15993", "82192", "url_article", "http://www.foodsafetymagazine.com/news/industry-weighs-in-on-listeria-monocytogenes-and-ag-water-regulations/");
INSERT INTO `wp_postmeta` VALUES("15994", "82192", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("15995", "82193", "url_article", "https://www.foodsafetymagazine.com/categories/contamination-control-category/microbiological");
INSERT INTO `wp_postmeta` VALUES("15996", "82193", "interes", "14");
INSERT INTO `wp_postmeta` VALUES("15997", "82194", "url_article", "https://foodsafetytech.com/column/blockchain-technology-drive-fsvp-compliance/");
INSERT INTO `wp_postmeta` VALUES("15998", "82194", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("15999", "82195", "url_article", "https://www.foodsafetymagazine.com/categories/supply-chain-category/foodservice-retail");
INSERT INTO `wp_postmeta` VALUES("16000", "82195", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("16001", "82196", "url_article", "https://www.foodsafetymagazine.com/news/");
INSERT INTO `wp_postmeta` VALUES("16002", "82196", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("16003", "82197", "url_article", "https://www.foodsafetymagazine.com/categories/supply-chain-category/growers-gaps");
INSERT INTO `wp_postmeta` VALUES("16004", "82197", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("16005", "82198", "url_article", "https://www.foodsafetymagazine.com/news/ready-to-eat-processed-meat-source-of-south-africas-listeria-outbreak/");
INSERT INTO `wp_postmeta` VALUES("16006", "82198", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("16007", "82199", "url_article", "https://www.industriaalimenticia.com/articles/87826-las-tecnologias-de-empaque-mas-sobresalientes-del-2015-que-se-exhibiran-en-expopack-mexico");
INSERT INTO `wp_postmeta` VALUES("16008", "82199", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16009", "82200", "url_article", "https://www.industriaalimenticia.com/articles/89031-paletizadora-robotica-elimina-la-necesidad-de-una-valla-de-seguridad");
INSERT INTO `wp_postmeta` VALUES("16010", "82200", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16011", "82201", "url_article", "https://www.foodsafetymagazine.com/news/chicken-salad-to-blame-for-multistate-salmonella-outbreak/");
INSERT INTO `wp_postmeta` VALUES("16012", "82201", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("16013", "82202", "url_article", "https://foodsafetytech.com/news_article/pilgrims-pride-recalls-101000-pounds-rte-breaded-chicken-patties/");
INSERT INTO `wp_postmeta` VALUES("16014", "82202", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("16015", "82203", "url_article", "https://www.industriaalimenticia.com/articles/86797-una-primicia-de-lo-mejor-de-pack-expo-2013");
INSERT INTO `wp_postmeta` VALUES("16016", "82203", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16017", "82204", "url_article", "https://www.foodsafetymagazine.com/categories/process-control-category/process-control-best-practices");
INSERT INTO `wp_postmeta` VALUES("16018", "82204", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("16019", "82205", "url_article", "https://www.industriaalimenticia.com/articles/88969-bosch-presenta-un-sistema-integral-para-barritas-de-granola");
INSERT INTO `wp_postmeta` VALUES("16020", "82205", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16021", "82206", "url_article", "https://www.industriaalimenticia.com/articles/88925-sealed-air-ofrece-al-mercado-el-equipo-de-envasado-al-vacio-cryovac-vs2x");
INSERT INTO `wp_postmeta` VALUES("16022", "82206", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16023", "82207", "url_article", "https://foodsafetytech.com/news_article/fda-food-recalls-nearly-93-since-2012/");
INSERT INTO `wp_postmeta` VALUES("16024", "82207", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16025", "82208", "url_article", "https://www.industriaalimenticia.com/articles/88841-unica-empacadora-con-carga-lateral");
INSERT INTO `wp_postmeta` VALUES("16026", "82208", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16027", "82209", "url_article", "https://foodsafetytech.com/news_article/biosensor-detects-norovirus-spot-one-hour/");
INSERT INTO `wp_postmeta` VALUES("16028", "82209", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16029", "82210", "url_article", "https://www.foodsafetymagazine.com/signature-series/");
INSERT INTO `wp_postmeta` VALUES("16030", "82210", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("16031", "82211", "url_article", "https://foodsafetytech.com/column/automation-benefits-food-beverage-industry/");
INSERT INTO `wp_postmeta` VALUES("16032", "82211", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("16033", "82212", "url_article", "https://www.industriaalimenticia.com/articles/88807-cierres-faciles-de-abrir-para-una-variedad-de-aplicaciones-de-alimentos-y-bebidas");
INSERT INTO `wp_postmeta` VALUES("16034", "82212", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16035", "82213", "url_article", "https://www.elconfidencial.com/economia/2018-02-24/leche-yogures-cafe-mantequilla-batido-lacteos-consumo_1515491/");
INSERT INTO `wp_postmeta` VALUES("16036", "82213", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("16037", "82214", "url_article", "https://www.foodsafetymagazine.com/magazine-archive1/februarymarch-2018/social-responsibilitye28099s-influence-over-food-safety-and-quality/");
INSERT INTO `wp_postmeta` VALUES("16038", "82214", "interes", "25");
INSERT INTO `wp_postmeta` VALUES("16039", "82215", "url_article", "http://www.tecnalia.com/index.php?option=com_flexicontent&view=items&Itemid=57&cid=204&id=8938&lang=es&utm_source=general&utm_medium=rss&utm_campaign=accesos_rss");
INSERT INTO `wp_postmeta` VALUES("16040", "82215", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16041", "82216", "url_article", "https://www.elconfidencial.com/empresas/2018-02-18/mr-hummus-empresario-griego-15millones-mercadona_1523353/");
INSERT INTO `wp_postmeta` VALUES("16042", "82216", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("16043", "82217", "url_article", "https://www.elconfidencial.com/empresas/2018-02-18/aceituna-trump-aranceles-dcoop_1521282/");
INSERT INTO `wp_postmeta` VALUES("16044", "82217", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16045", "82218", "url_article", "http://innovacionsostenible.azti.es/un-consorcio-europeo-en-el-que-participa-azti-invertira-1-200-millones-de-e-para-desarrollar-los-alimentos-del-futuro/");
INSERT INTO `wp_postmeta` VALUES("16046", "82218", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16047", "82219", "url_article", "https://www.industriaalimenticia.com/articles/88801-las-ultimas-innovaciones-de-equipos-lanzadas-en-interpack-2017");
INSERT INTO `wp_postmeta` VALUES("16048", "82219", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16049", "82220", "url_article", "https://www.foodsafetymagazine.com/categories/testing-and-analysis-category/testing-methods");
INSERT INTO `wp_postmeta` VALUES("16050", "82220", "interes", "14");
INSERT INTO `wp_postmeta` VALUES("16051", "82221", "url_article", "https://www.industriaalimenticia.com/articles/88790-tetra-pak-lanza-dos-nuevos-envases-de-tamano-pequeno-para-disfrutar-en-el-camino");
INSERT INTO `wp_postmeta` VALUES("16052", "82221", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16053", "82222", "url_article", "https://www.foodsafetymagazine.com/enewsletter/study-provides-industry-guidance-in-determining-the-safety-of-oats-and-other-grains/");
INSERT INTO `wp_postmeta` VALUES("16054", "82222", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("16055", "82223", "url_article", "http://innovacionsostenible.azti.es/un-plan-de-produccion-ecoeficiente-disenado-por-azti-permite-al-grupo-consorcio-reducir-un-40-el-consumo-de-agua-en-la-elaboracion-de-conservas-de-pescado/");
INSERT INTO `wp_postmeta` VALUES("16056", "82223", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("16057", "82224", "url_article", "https://www.foodsafetymagazine.com/news/gorny-leaves-pma-for-fda/");
INSERT INTO `wp_postmeta` VALUES("16058", "82224", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("16059", "82225", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/environmental_performance_of_construction%20_and_demolition_waste_management_441na5_en.pdf");
INSERT INTO `wp_postmeta` VALUES("16060", "82225", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16061", "82226", "url_article", "http://profesionalhoreca.com/world-olive-oil-exhibition-2018-la-cita-mundial-del-aceite-de-oliva/");
INSERT INTO `wp_postmeta` VALUES("16062", "82226", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("16063", "82227", "url_article", "http://www.frozenfoodeurope.com/impact-natural-refrigerants-lubricants/");
INSERT INTO `wp_postmeta` VALUES("16064", "82227", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("16065", "82228", "url_article", "http://www.frozenfoodeurope.com/key-technology-specialized-conveyor/");
INSERT INTO `wp_postmeta` VALUES("16066", "82228", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("16067", "82229", "url_article", "http://www.frozenfoodeurope.com/march-6-frozen-food-day/");
INSERT INTO `wp_postmeta` VALUES("16068", "82229", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("16069", "82230", "url_article", "https://www.foodsafetymagazine.com/magazine-archive1/februarymarch-2018/a-new-approach-to-solving-the-problem-of-sprout-safety/");
INSERT INTO `wp_postmeta` VALUES("16070", "82230", "interes", "14");
INSERT INTO `wp_postmeta` VALUES("16071", "82231", "url_article", "http://vidasana.org/noticias/natural-cosmetic-lab-estamos-viviendo-un-despegue-importante");
INSERT INTO `wp_postmeta` VALUES("16072", "82231", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("16073", "82232", "url_article", "https://www.foodsafetymagazine.com/categories/regulatory-category/guidelines");
INSERT INTO `wp_postmeta` VALUES("16074", "82232", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("16075", "82233", "url_article", "http://vidasana.org/noticias/naturavia-ecocosmetica-gallega");
INSERT INTO `wp_postmeta` VALUES("16076", "82233", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16077", "82234", "url_article", "https://www.foodsafetymagazine.com/categories/process-control-category/process-control");
INSERT INTO `wp_postmeta` VALUES("16078", "82234", "interes", "15");
INSERT INTO `wp_postmeta` VALUES("16079", "82235", "url_article", "https://www.npd.com/wps/portal/npd/us/news/press-releases/2015/many-consumers-broadly-define-clean-eating-to-include-processed-and-packaged-foods/");
INSERT INTO `wp_postmeta` VALUES("16080", "82235", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16081", "82236", "url_article", "https://www.foodsafetymagazine.com/enewsletter1");
INSERT INTO `wp_postmeta` VALUES("16082", "82236", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("16083", "82237", "url_article", "https://www.foodsafetymagazine.com/categories/sanitation-category/food-prep-handling");
INSERT INTO `wp_postmeta` VALUES("16084", "82237", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("16085", "82238", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/economic_incentives_for_bringing_ewaste_into_the_circular_economy_435na3_en.pdf");
INSERT INTO `wp_postmeta` VALUES("16086", "82238", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16087", "82239", "url_article", "http://diariodegastronomia.com/vez-mas-vino-australiano-neozelandes/");
INSERT INTO `wp_postmeta` VALUES("16088", "82239", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16089", "82240", "url_article", "http://diariodegastronomia.com/punto-la-world-olive-oil-exhibition-madrid/");
INSERT INTO `wp_postmeta` VALUES("16090", "82240", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16091", "82241", "url_article", "https://www.foodsafetymagazine.com/magazine-archive1/februarymarch-2018/riskhazard-redefining-existing-practices/");
INSERT INTO `wp_postmeta` VALUES("16092", "82241", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("16093", "82242", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/reducing_the_environmental_impact_of_construction_tunnelling_434na5_en.pdf");
INSERT INTO `wp_postmeta` VALUES("16094", "82242", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16095", "82243", "url_article", "http://diariodegastronomia.com/cupcakes-pescado-receta-sin-desperdicio/");
INSERT INTO `wp_postmeta` VALUES("16096", "82243", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("16097", "82244", "url_article", "https://www.foodsafetymagazine.com/categories/food-types-category/natural-organic");
INSERT INTO `wp_postmeta` VALUES("16098", "82244", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("16099", "82245", "url_article", "http://www.foodcanal.com/tips-para-un-diseno-excelente-en-el-packaging-de-alimentos/");
INSERT INTO `wp_postmeta` VALUES("16100", "82245", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("16101", "82246", "url_article", "http://vidasana.org/noticias/alternativa-3-sorteo-de-un-pack-de-productos-ecologicos");
INSERT INTO `wp_postmeta` VALUES("16102", "82246", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16103", "82247", "url_article", "http://www.foodcanal.com/historias-de-instagram-usos-destacados-en-el-marketing-de-alimentacion/");
INSERT INTO `wp_postmeta` VALUES("16104", "82247", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16105", "82248", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/waste_sorting_in_apartments_integrating_the_perspective_of_the_user_433na2_en.pdf");
INSERT INTO `wp_postmeta` VALUES("16106", "82248", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16107", "82249", "url_article", "https://www.elconfidencial.com/deportes/rugby/2018-03-12/rey-felipe-vi-rugby-copa-webb-ellis_1533874/");
INSERT INTO `wp_postmeta` VALUES("16108", "82249", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16109", "82249", "url_picture", "https://www.ecestaticos.com/imagestatic/clipping/eda/35f/eda35fd4df5958a8715baf39aac6ffeb/se-mira-pero-no-se-toca-el-secreto-de-espana-de-rugby.jpg?mtime=1520528662");
INSERT INTO `wp_postmeta` VALUES("16110", "82250", "url_article", "https://www.foodsafetymagazine.com/categories/process-control-category/process-validation");
INSERT INTO `wp_postmeta` VALUES("16111", "82250", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("16112", "82251", "url_article", "https://www.elconfidencial.com/mercados/indice/ibex35/");
INSERT INTO `wp_postmeta` VALUES("16113", "82251", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16114", "82252", "url_article", "https://www.elconfidencial.com/hemeroteca/2018-03-11/2/");
INSERT INTO `wp_postmeta` VALUES("16115", "82252", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16116", "82252", "url_picture", "https://www.ecestaticos.com/file/0be042580f4f0f53813bd70f7984033c/1456834011.svg");
INSERT INTO `wp_postmeta` VALUES("16117", "82253", "url_article", "http://vidasana.org/noticias/mamaterra-madrid-cita-imprescindible-para-las-familias-bio");
INSERT INTO `wp_postmeta` VALUES("16118", "82253", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("16119", "82254", "url_article", "http://diariodegastronomia.com/lo-ultimo-equipamiento-hostelco-2018/");
INSERT INTO `wp_postmeta` VALUES("16120", "82254", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("16121", "82255", "url_article", "https://www.elconfidencial.com/mercados/indice/sp/");
INSERT INTO `wp_postmeta` VALUES("16122", "82255", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16123", "82256", "url_article", "https://www.elconfidencial.com/mercados/indice/nasdaq/");
INSERT INTO `wp_postmeta` VALUES("16124", "82256", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16125", "82257", "url_article", "https://www.elconfidencial.com/mercados/indice/divisas/");
INSERT INTO `wp_postmeta` VALUES("16126", "82257", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16127", "82258", "url_article", "http://hdl.handle.net/10609/74887");
INSERT INTO `wp_postmeta` VALUES("16128", "82258", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("16129", "82259", "url_article", "https://www.elconfidencial.com/mercados/indice/ibex35");
INSERT INTO `wp_postmeta` VALUES("16130", "82259", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16131", "82260", "url_article", "https://www.elconfidencial.com/mercados/indice/dowa/");
INSERT INTO `wp_postmeta` VALUES("16132", "82260", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16133", "82261", "url_article", "https://www.elconfidencial.com/mercados/indice/ind_res/");
INSERT INTO `wp_postmeta` VALUES("16134", "82261", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16135", "82262", "url_article", "https://www.elconfidencial.com/mercados/indice/mercado_continuo/");
INSERT INTO `wp_postmeta` VALUES("16136", "82262", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16137", "82263", "url_article", "https://www.elconfidencial.com/mercados/indice/euribor/");
INSERT INTO `wp_postmeta` VALUES("16138", "82263", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16139", "82264", "url_article", "https://www.elconfidencial.com/mercados/indice/prima-riesgo/");
INSERT INTO `wp_postmeta` VALUES("16140", "82264", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16141", "82265", "url_article", "https://www.elconfidencial.com/mercados/indice/");
INSERT INTO `wp_postmeta` VALUES("16142", "82265", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16143", "82266", "url_article", "https://www.foodsafetymagazine.com/magazine-archive1/februarymarch-2018/control-of-listeria-monocytogenes-on-food-contact-and-noncontact-surfaces-by-antimicrobial-coatings/");
INSERT INTO `wp_postmeta` VALUES("16144", "82266", "interes", "19");
INSERT INTO `wp_postmeta` VALUES("16145", "82267", "url_article", "https://www.elconfidencial.com/rss/");
INSERT INTO `wp_postmeta` VALUES("16146", "82267", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16147", "82268", "url_article", "https://www.elconfidencial.com/mundo/2018-03-12/venezuela-ninos-muertos-desnutricion-interior_1533765/");
INSERT INTO `wp_postmeta` VALUES("16148", "82268", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("16149", "82268", "url_picture", "https://www.ecestaticos.com/imagestatic/clipping/f08/a39/f08a397f286f7ceb02039bfc23984a9d/el-hambre-se-abre-paso-en-venezuela.jpg?mtime=1466094113");
INSERT INTO `wp_postmeta` VALUES("16150", "82269", "url_article", "https://www.elconfidencial.com/mercados/indice/euro_stoxx/");
INSERT INTO `wp_postmeta` VALUES("16151", "82269", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16152", "82270", "url_article", "https://www.elconfidencial.com/mercados/indice/dax/");
INSERT INTO `wp_postmeta` VALUES("16153", "82270", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16154", "82271", "url_article", "http://vidasana.org/noticias/mamaterra-vuelve-a-valencia-el-ecofestival-infantil-mas-esperado");
INSERT INTO `wp_postmeta` VALUES("16155", "82271", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("16156", "82272", "url_article", "http://www.gondoladigital.com/lineal.php?ID_LINEAL=5822");
INSERT INTO `wp_postmeta` VALUES("16157", "82272", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16158", "82273", "url_article", "http://www.gnpd.com/sinatra/recordpage/5507271/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16159", "82273", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16160", "82274", "url_article", "https://www.foodsafetymagazine.com/categories/contamination-control-category/reduction-methods");
INSERT INTO `wp_postmeta` VALUES("16161", "82274", "interes", "14");
INSERT INTO `wp_postmeta` VALUES("16162", "82275", "url_article", "http://www.gnpd.com/sinatra/recordpage/5507275/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16163", "82275", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16164", "82276", "url_article", "http://www.gnpd.com/sinatra/recordpage/5507273/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16165", "82276", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16166", "82277", "url_article", "http://www.gnpd.com/sinatra/recordpage/5507621/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16167", "82277", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16168", "82278", "url_article", "http://www.gnpd.com/sinatra/recordpage/5507311/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16169", "82278", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16170", "82279", "url_article", "http://www.gnpd.com/sinatra/recordpage/5508617/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16171", "82279", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16172", "82280", "url_article", "http://www.gnpd.com/sinatra/recordpage/5508551/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16173", "82280", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16174", "82281", "url_article", "http://www.gnpd.com/sinatra/recordpage/5509167/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16175", "82281", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16176", "82282", "url_article", "http://www.gnpd.com/sinatra/recordpage/5509165/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16177", "82282", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16178", "82283", "url_article", "http://www.gnpd.com/sinatra/recordpage/5509183/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16179", "82283", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16180", "82284", "url_article", "http://www.gnpd.com/sinatra/recordpage/5509169/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16181", "82284", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16182", "82285", "url_article", "http://www.gnpd.com/sinatra/recordpage/5510717/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16183", "82285", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16184", "82286", "url_article", "http://www.gnpd.com/sinatra/recordpage/5509187/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16185", "82286", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16186", "82287", "url_article", "http://www.gnpd.com/sinatra/recordpage/5510731/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16187", "82287", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16188", "82288", "url_article", "http://www.gnpd.com/sinatra/recordpage/5510723/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16189", "82288", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16190", "82289", "url_article", "http://www.gnpd.com/sinatra/recordpage/5510807/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16191", "82289", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16192", "82290", "url_article", "http://www.gnpd.com/sinatra/recordpage/5510737/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16193", "82290", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16194", "82291", "url_article", "http://www.gnpd.com/sinatra/recordpage/5510809/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16195", "82291", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16196", "82292", "url_article", "http://www.gondoladigital.com/noticia.php?ID_NOTICIA=24339");
INSERT INTO `wp_postmeta` VALUES("16197", "82292", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16198", "82293", "url_article", "http://www.gnpd.com/sinatra/recordpage/5510877/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16199", "82293", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16200", "82294", "url_article", "https://www.foodsafetymagazine.com/categories/regulatory-category/international-standards-harmonization");
INSERT INTO `wp_postmeta` VALUES("16201", "82294", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("16202", "82295", "url_article", "http://www.gnpd.com/sinatra/recordpage/5510933/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16203", "82295", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16204", "82296", "url_article", "http://www.gnpd.com/sinatra/recordpage/5510887/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16205", "82296", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16206", "82297", "url_article", "http://www.gnpd.com/sinatra/recordpage/5510953/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16207", "82297", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16208", "82298", "url_article", "http://www.gnpd.com/sinatra/recordpage/5510949/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16209", "82298", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16210", "82299", "url_article", "http://www.gnpd.com/sinatra/recordpage/5510957/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16211", "82299", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16212", "82300", "url_article", "http://www.gnpd.com/sinatra/recordpage/5510955/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16213", "82300", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16214", "82301", "url_article", "http://www.gnpd.com/sinatra/recordpage/5510973/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16215", "82301", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16216", "82302", "url_article", "http://www.gnpd.com/sinatra/recordpage/5510971/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16217", "82302", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16218", "82303", "url_article", "http://www.gnpd.com/sinatra/recordpage/5510981/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16219", "82303", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16220", "82304", "url_article", "http://www.gnpd.com/sinatra/recordpage/5510975/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16221", "82304", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16222", "82305", "url_article", "http://www.gnpd.com/sinatra/recordpage/5510991/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16223", "82305", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16224", "82306", "url_article", "http://www.gnpd.com/sinatra/recordpage/5510985/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16225", "82306", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16226", "82307", "url_article", "http://www.gnpd.com/sinatra/recordpage/5511723/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16227", "82307", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16228", "82308", "url_article", "http://www.gnpd.com/sinatra/recordpage/5511075/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16229", "82308", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16230", "82309", "url_article", "http://www.gnpd.com/sinatra/recordpage/5512977/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16231", "82309", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16232", "82310", "url_article", "http://www.gnpd.com/sinatra/recordpage/5512357/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16233", "82310", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16234", "82311", "url_article", "http://www.gnpd.com/sinatra/recordpage/5513093/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16235", "82311", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16236", "82312", "url_article", "http://www.gnpd.com/sinatra/recordpage/5513043/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16237", "82312", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16238", "82313", "url_article", "http://www.gnpd.com/sinatra/recordpage/5513187/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16239", "82313", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16240", "82314", "url_article", "http://www.gnpd.com/sinatra/recordpage/5513177/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16241", "82314", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16242", "82315", "url_article", "http://www.gnpd.com/sinatra/recordpage/5513479/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16243", "82315", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16244", "82316", "url_article", "http://www.gnpd.com/sinatra/recordpage/5513189/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16245", "82316", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16246", "82317", "url_article", "http://www.gnpd.com/sinatra/recordpage/5513569/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16247", "82317", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16248", "82318", "url_article", "http://www.gnpd.com/sinatra/recordpage/5513559/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16249", "82318", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16250", "82319", "url_article", "http://www.gnpd.com/sinatra/recordpage/5513583/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16251", "82319", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16252", "82320", "url_article", "http://www.gnpd.com/sinatra/recordpage/5513581/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16253", "82320", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16254", "82321", "url_article", "http://www.gnpd.com/sinatra/recordpage/5513653/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16255", "82321", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16256", "82322", "url_article", "http://www.gnpd.com/sinatra/recordpage/5513585/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16257", "82322", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16258", "82323", "url_article", "http://www.gnpd.com/sinatra/recordpage/5514909/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16259", "82323", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16260", "82324", "url_article", "http://www.gnpd.com/sinatra/recordpage/5513665/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16261", "82324", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16262", "82325", "url_article", "http://vidasana.org/noticias/olasagasti-nuevo-lanzamiento-de-escabeche-ecologico");
INSERT INTO `wp_postmeta` VALUES("16263", "82325", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("16264", "82326", "url_article", "http://www.gnpd.com/sinatra/recordpage/5514915/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16265", "82326", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16266", "82327", "url_article", "http://www.gnpd.com/sinatra/recordpage/5503861/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16267", "82327", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16268", "82328", "url_article", "http://www.gnpd.com/sinatra/recordpage/5514949/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16269", "82328", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16270", "82329", "url_article", "http://www.gnpd.com/sinatra/recordpage/5505695/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16271", "82329", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16272", "82330", "url_article", "https://www.foodsafetymagazine.com/categories/facilities-category/gmps");
INSERT INTO `wp_postmeta` VALUES("16273", "82330", "interes", "14");
INSERT INTO `wp_postmeta` VALUES("16274", "82331", "url_article", "http://www.gnpd.com/sinatra/recordpage/5506703/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16275", "82331", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16276", "82332", "url_article", "http://www.gnpd.com/sinatra/recordpage/5505705/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16277", "82332", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16278", "82333", "url_article", "http://www.gnpd.com/sinatra/recordpage/5507053/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16279", "82333", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16280", "82334", "url_article", "http://www.gnpd.com/sinatra/recordpage/5506713/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16281", "82334", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16282", "82335", "url_article", "http://www.gnpd.com/sinatra/recordpage/5507095/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16283", "82335", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16284", "82336", "url_article", "http://www.gnpd.com/sinatra/recordpage/5507093/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16285", "82336", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16286", "82337", "url_article", "http://www.gnpd.com/sinatra/recordpage/5507425/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16287", "82337", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16288", "82338", "url_article", "http://www.gnpd.com/sinatra/recordpage/5507303/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16289", "82338", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16290", "82339", "url_article", "http://www.gnpd.com/sinatra/recordpage/5507625/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16291", "82339", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16292", "82340", "url_article", "http://www.gnpd.com/sinatra/recordpage/5507587/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16293", "82340", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16294", "82341", "url_article", "http://www.gnpd.com/sinatra/recordpage/5508031/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16295", "82341", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16296", "82342", "url_article", "http://www.gnpd.com/sinatra/recordpage/5508029/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16297", "82342", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16298", "82343", "url_article", "http://www.gnpd.com/sinatra/recordpage/5508035/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16299", "82343", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16300", "82344", "url_article", "http://www.gnpd.com/sinatra/recordpage/5508033/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16301", "82344", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16302", "82345", "url_article", "http://www.gnpd.com/sinatra/recordpage/5508039/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16303", "82345", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16304", "82346", "url_article", "http://www.gnpd.com/sinatra/recordpage/5508037/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16305", "82346", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16306", "82347", "url_article", "http://www.gnpd.com/sinatra/recordpage/5508043/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16307", "82347", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16308", "82348", "url_article", "http://www.gnpd.com/sinatra/recordpage/5508041/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16309", "82348", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16310", "82349", "url_article", "http://www.gnpd.com/sinatra/recordpage/5508131/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16311", "82349", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16312", "82350", "url_article", "http://www.gnpd.com/sinatra/recordpage/5508127/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16313", "82350", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16314", "82351", "url_article", "http://www.gnpd.com/sinatra/recordpage/5508189/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16315", "82351", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16316", "82352", "url_article", "http://www.gnpd.com/sinatra/recordpage/5508145/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16317", "82352", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16318", "82353", "url_article", "http://www.gnpd.com/sinatra/recordpage/5508197/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16319", "82353", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16320", "82354", "url_article", "http://www.foodinsight.org/new-year-trends-2017-sustainability-functional-foods-coffee-healthy-protein-pasta-whole-grains");
INSERT INTO `wp_postmeta` VALUES("16321", "82354", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("16322", "82354", "url_picture", "http://www.foodinsight.org/sites/default/files/styles/main_image_for_details/public/What%27s%20on%20the%20menu%20for%202017-_2.jpg?itok=w2Z4c1ct");
INSERT INTO `wp_postmeta` VALUES("16323", "82355", "url_article", "http://www.gnpd.com/sinatra/recordpage/5508723/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16324", "82355", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16325", "82356", "url_article", "http://www.gnpd.com/sinatra/recordpage/5508713/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16326", "82356", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16327", "82357", "url_article", "http://www.gnpd.com/sinatra/recordpage/5508769/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16328", "82357", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16329", "82358", "url_article", "http://www.foodinsight.org/2018-trends");
INSERT INTO `wp_postmeta` VALUES("16330", "82358", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("16331", "82358", "url_picture", "http://foodinsight.org/sites/default/files/styles/main_image_for_details/public/Trends%20optimized.jpg?itok=B5NBcZ-Q");
INSERT INTO `wp_postmeta` VALUES("16332", "82359", "url_article", "http://www.gnpd.com/sinatra/recordpage/5508783/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16333", "82359", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16334", "82360", "url_article", "http://www.gnpd.com/sinatra/recordpage/5508781/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16335", "82360", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16336", "82361", "url_article", "http://www.gnpd.com/sinatra/recordpage/5510827/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16337", "82361", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16338", "82362", "url_article", "http://www.gnpd.com/sinatra/recordpage/5510803/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16339", "82362", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16340", "82363", "url_article", "http://www.foodinsight.org/press-releases/ific-foundation-president-kimberly-reed-gives-keynote-address-midatlantic-women");
INSERT INTO `wp_postmeta` VALUES("16341", "82363", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("16342", "82363", "url_picture", "http://www.foodinsight.org/sites/default/files/styles/large/public/pictures/picture-79-1403036319.png");
INSERT INTO `wp_postmeta` VALUES("16343", "82364", "url_article", "http://www.gnpd.com/sinatra/recordpage/5510843/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16344", "82364", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16345", "82365", "url_article", "http://www.gnpd.com/sinatra/recordpage/5510861/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16346", "82365", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16347", "82366", "url_article", "http://www.gnpd.com/sinatra/recordpage/5510859/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16348", "82366", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16349", "82367", "url_article", "http://www.gnpd.com/sinatra/recordpage/5510863/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16350", "82367", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16351", "82368", "url_article", "http://www.foodinsight.org/foodies-food-and-health-survey-press-release");
INSERT INTO `wp_postmeta` VALUES("16352", "82368", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16353", "82368", "url_picture", "http://www.foodinsight.org/sites/default/files/styles/main_image_for_details/public/you%20might%20be%20a%20foodie%20if_0.jpg?itok=ieZ6ujtV");
INSERT INTO `wp_postmeta` VALUES("16354", "82369", "url_article", "http://www.gnpd.com/sinatra/recordpage/5510967/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16355", "82369", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16356", "82370", "url_article", "http://www.gnpd.com/sinatra/recordpage/5510873/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16357", "82370", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16358", "82371", "url_article", "http://www.gnpd.com/sinatra/recordpage/5511825/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16359", "82371", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16360", "82372", "url_article", "http://www.gnpd.com/sinatra/recordpage/5511763/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16361", "82372", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16362", "82373", "url_article", "http://www.gnpd.com/sinatra/recordpage/5511829/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16363", "82373", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16364", "82374", "url_article", "http://www.gnpd.com/sinatra/recordpage/5511827/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16365", "82374", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16366", "82375", "url_article", "http://www.gnpd.com/sinatra/recordpage/5513175/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16367", "82375", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16368", "82376", "url_article", "https://www.foodsafetymagazine.com/categories/sanitation-category/sanitation-environmental-monitoring");
INSERT INTO `wp_postmeta` VALUES("16369", "82376", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("16370", "82377", "url_article", "http://www.gnpd.com/sinatra/recordpage/5499385/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16371", "82377", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16372", "82378", "url_article", "http://www.gnpd.com/sinatra/recordpage/5499367/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16373", "82378", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16374", "82379", "url_article", "http://www.gnpd.com/sinatra/recordpage/5501309/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16375", "82379", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16376", "82380", "url_article", "http://www.gnpd.com/sinatra/recordpage/5501307/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16377", "82380", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16378", "82381", "url_article", "http://www.gnpd.com/sinatra/recordpage/5502701/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16379", "82381", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16380", "82382", "url_article", "http://www.gnpd.com/sinatra/recordpage/5501333/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16381", "82382", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16382", "82383", "url_article", "http://www.gnpd.com/sinatra/recordpage/5503841/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16383", "82383", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16384", "82384", "url_article", "http://www.gnpd.com/sinatra/recordpage/5503835/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16385", "82384", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16386", "82385", "url_article", "http://www.gnpd.com/sinatra/recordpage/5503887/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16387", "82385", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16388", "82386", "url_article", "http://www.gnpd.com/sinatra/recordpage/5503843/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16389", "82386", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16390", "82387", "url_article", "http://www.gnpd.com/sinatra/recordpage/5505737/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16391", "82387", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16392", "82388", "url_article", "http://vidasana.org/noticias/alemania-ecocosmetica-certificada-por-todas-partes");
INSERT INTO `wp_postmeta` VALUES("16393", "82388", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16394", "82389", "url_article", "http://www.gnpd.com/sinatra/recordpage/5505745/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16395", "82389", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16396", "82390", "url_article", "http://www.gnpd.com/sinatra/recordpage/5505739/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16397", "82390", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16398", "82391", "url_article", "http://www.gnpd.com/sinatra/recordpage/5505747/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16399", "82391", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16400", "82392", "url_article", "https://www.foodsafetymagazine.com/magazine-archive1/");
INSERT INTO `wp_postmeta` VALUES("16401", "82392", "interes", "20");
INSERT INTO `wp_postmeta` VALUES("16402", "82393", "url_article", "http://www.gnpd.com/sinatra/recordpage/5505945/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16403", "82393", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16404", "82394", "url_article", "http://www.gnpd.com/sinatra/recordpage/5505749/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16405", "82394", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16406", "82395", "url_article", "http://www.gnpd.com/sinatra/recordpage/5506061/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16407", "82395", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16408", "82396", "url_article", "http://www.gnpd.com/sinatra/recordpage/5506045/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16409", "82396", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16410", "82397", "url_article", "http://www.gnpd.com/sinatra/recordpage/5507155/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16411", "82397", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16412", "82398", "url_article", "http://www.gnpd.com/sinatra/recordpage/5506179/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16413", "82398", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16414", "82399", "url_article", "http://www.gnpd.com/sinatra/recordpage/5507543/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16415", "82399", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16416", "82400", "url_article", "http://www.gnpd.com/sinatra/recordpage/5507541/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16417", "82400", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16418", "82401", "url_article", "http://www.gnpd.com/sinatra/recordpage/5507549/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16419", "82401", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16420", "82402", "url_article", "http://www.gnpd.com/sinatra/recordpage/5507547/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16421", "82402", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16422", "82403", "url_article", "http://www.gnpd.com/sinatra/recordpage/5507667/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16423", "82403", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16424", "82404", "url_article", "http://www.gnpd.com/sinatra/recordpage/5507551/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16425", "82404", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16426", "82405", "url_article", "http://www.gnpd.com/sinatra/recordpage/5508771/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16427", "82405", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16428", "82406", "url_article", "http://www.gnpd.com/sinatra/recordpage/5508691/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16429", "82406", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16430", "82407", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498189/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16431", "82407", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("16432", "82408", "url_article", "http://www.gnpd.com/sinatra/recordpage/5497507/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16433", "82408", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16434", "82409", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498797/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16435", "82409", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16436", "82410", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498661/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16437", "82410", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16438", "82411", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498809/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16439", "82411", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16440", "82412", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498799/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16441", "82412", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16442", "82413", "url_article", "https://www.foodsafetymagazine.com/categories/regulatory-category/audits-certification-gfsi");
INSERT INTO `wp_postmeta` VALUES("16443", "82413", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("16444", "82414", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498871/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16445", "82414", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16446", "82415", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498879/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16447", "82415", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16448", "82416", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498877/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16449", "82416", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16450", "82417", "url_article", "http://www.gnpd.com/sinatra/recordpage/5499287/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16451", "82417", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16452", "82418", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498881/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16453", "82418", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16454", "82419", "url_article", "http://www.gnpd.com/sinatra/recordpage/5499403/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16455", "82419", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16456", "82420", "url_article", "http://www.gnpd.com/sinatra/recordpage/5499317/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16457", "82420", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16458", "82421", "url_article", "http://www.gnpd.com/sinatra/recordpage/5499637/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16459", "82421", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16460", "82422", "url_article", "http://www.gnpd.com/sinatra/recordpage/5499617/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16461", "82422", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16462", "82423", "url_article", "http://www.gnpd.com/sinatra/recordpage/5499855/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16463", "82423", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16464", "82424", "url_article", "http://www.gnpd.com/sinatra/recordpage/5499797/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16465", "82424", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16466", "82425", "url_article", "http://www.gnpd.com/sinatra/recordpage/5501321/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16467", "82425", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16468", "82426", "url_article", "http://www.gnpd.com/sinatra/recordpage/5501311/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16469", "82426", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16470", "82427", "url_article", "http://www.gnpd.com/sinatra/recordpage/5501325/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16471", "82427", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16472", "82428", "url_article", "http://www.gnpd.com/sinatra/recordpage/5501323/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16473", "82428", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16474", "82429", "url_article", "http://www.gnpd.com/sinatra/recordpage/5501341/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16475", "82429", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16476", "82430", "url_article", "http://www.gnpd.com/sinatra/recordpage/5501327/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16477", "82430", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16478", "82431", "url_article", "http://www.gnpd.com/sinatra/recordpage/5501461/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16479", "82431", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16480", "82432", "url_article", "http://www.gnpd.com/sinatra/recordpage/5501435/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16481", "82432", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16482", "82433", "url_article", "http://www.gnpd.com/sinatra/recordpage/5501909/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16483", "82433", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16484", "82434", "url_article", "http://www.gnpd.com/sinatra/recordpage/5501905/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16485", "82434", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16486", "82435", "url_article", "http://www.gnpd.com/sinatra/recordpage/5502691/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16487", "82435", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16488", "82436", "url_article", "http://www.gnpd.com/sinatra/recordpage/5501911/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16489", "82436", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16490", "82437", "url_article", "http://www.gnpd.com/sinatra/recordpage/5502703/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16491", "82437", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16492", "82438", "url_article", "http://www.gnpd.com/sinatra/recordpage/5502699/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16493", "82438", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16494", "82439", "url_article", "http://www.gnpd.com/sinatra/recordpage/5481295/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16495", "82439", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16496", "82440", "url_article", "http://www.gnpd.com/sinatra/recordpage/5503839/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16497", "82440", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16498", "82441", "url_article", "http://www.gnpd.com/sinatra/recordpage/5492681/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16499", "82441", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16500", "82442", "url_article", "http://www.gnpd.com/sinatra/recordpage/5492663/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16501", "82442", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16502", "82443", "url_article", "http://www.gnpd.com/sinatra/recordpage/5492747/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16503", "82443", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16504", "82444", "url_article", "http://www.gnpd.com/sinatra/recordpage/5492689/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16505", "82444", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16506", "82445", "url_article", "http://www.gnpd.com/sinatra/recordpage/5492755/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16507", "82445", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16508", "82446", "url_article", "https://www.foodsafetymagazine.com/news/fda-testing-fresh-herbs-avocados-for-foodborne-pathogens/");
INSERT INTO `wp_postmeta` VALUES("16509", "82446", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("16510", "82447", "url_article", "http://www.gnpd.com/sinatra/recordpage/5497529/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16511", "82447", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16512", "82448", "url_article", "http://www.gnpd.com/sinatra/recordpage/5496947/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16513", "82448", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16514", "82449", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498003/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16515", "82449", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16516", "82450", "url_article", "http://www.gnpd.com/sinatra/recordpage/5497653/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16517", "82450", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16518", "82451", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498009/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16519", "82451", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16520", "82452", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498007/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16521", "82452", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16522", "82453", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498027/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16523", "82453", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16524", "82454", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498011/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16525", "82454", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16526", "82455", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498137/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16527", "82455", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16528", "82456", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498029/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16529", "82456", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16530", "82457", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498157/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16531", "82457", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16532", "82458", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498143/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16533", "82458", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16534", "82459", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498181/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16535", "82459", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16536", "82460", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498175/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16537", "82460", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16538", "82461", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498203/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16539", "82461", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16540", "82462", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498191/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16541", "82462", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16542", "82463", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498657/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16543", "82463", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16544", "82464", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498571/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16545", "82464", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16546", "82465", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498699/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16547", "82465", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16548", "82466", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498697/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16549", "82466", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16550", "82467", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498965/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16551", "82467", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16552", "82468", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498959/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16553", "82468", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16554", "82469", "url_article", "http://www.gnpd.com/sinatra/recordpage/5499237/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16555", "82469", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16556", "82470", "url_article", "http://www.gnpd.com/sinatra/recordpage/5498971/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16557", "82470", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16558", "82471", "url_article", "http://www.gnpd.com/sinatra/recordpage/5499253/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16559", "82471", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16560", "82472", "url_article", "http://www.gnpd.com/sinatra/recordpage/5499249/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16561", "82472", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16562", "82473", "url_article", "http://www.gnpd.com/sinatra/recordpage/5499259/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16563", "82473", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16564", "82474", "url_article", "http://www.gnpd.com/sinatra/recordpage/5499255/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16565", "82474", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16566", "82475", "url_article", "http://www.gnpd.com/sinatra/recordpage/5499613/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16567", "82475", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16568", "82476", "url_article", "http://www.gnpd.com/sinatra/recordpage/5499285/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16569", "82476", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16570", "82477", "url_article", "http://www.gnpd.com/sinatra/recordpage/5499975/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16571", "82477", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16572", "82478", "url_article", "http://www.gnpd.com/sinatra/recordpage/5499859/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16573", "82478", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16574", "82479", "url_article", "http://www.gnpd.com/sinatra/recordpage/5500093/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16575", "82479", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16576", "82480", "url_article", "http://www.gnpd.com/sinatra/recordpage/5500031/?utm_source=web_feed");
INSERT INTO `wp_postmeta` VALUES("16577", "82480", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16578", "82481", "url_article", "http://vidasana.org/noticias/-alternativa3-sorteo-en-biocultura-sevilla-2017");
INSERT INTO `wp_postmeta` VALUES("16579", "82481", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16580", "82482", "url_article", "https://www.foodsafetymagazine.com/categories/food-types-category/ready-to-eat");
INSERT INTO `wp_postmeta` VALUES("16581", "82482", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("16582", "82483", "url_article", "http://vidasana.org/noticias/bridepalla-3er-premio-ecoemprendedores-biocultura");
INSERT INTO `wp_postmeta` VALUES("16583", "82483", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16584", "82484", "url_article", "http://vidasana.org/noticias/ecovalia-comprar-bio-arma-contra-el-cambio-climatico");
INSERT INTO `wp_postmeta` VALUES("16585", "82484", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("16586", "82485", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/new_biodegradable_management_plans_proposed_and_evaluated_411na1_en.pdf");
INSERT INTO `wp_postmeta` VALUES("16587", "82485", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16588", "82486", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/waste_incinerator_impacts_monitored_via_milk_and_vegetable_quality_411na4_en.pdf");
INSERT INTO `wp_postmeta` VALUES("16589", "82486", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16590", "82487", "url_article", "http://vidasana.org/noticias/el-libro-selvas-de-comida-en-la-ciudad");
INSERT INTO `wp_postmeta` VALUES("16591", "82487", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16592", "82488", "url_article", "https://www.biotechmagazine.es/noticias-biotech/identificador-unico-farmacos/");
INSERT INTO `wp_postmeta` VALUES("16593", "82488", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16594", "82489", "url_article", "http://vidasana.org/noticias/sevilla-centro-neuralgico-de-la-elaboracion-ecologica");
INSERT INTO `wp_postmeta` VALUES("16595", "82489", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16596", "82490", "url_article", "https://www.foodsafetymagazine.com/categories/contamination-control-category/chemical");
INSERT INTO `wp_postmeta` VALUES("16597", "82490", "interes", "14");
INSERT INTO `wp_postmeta` VALUES("16598", "82491", "url_article", "http://www.cadenadesuministro.es/noticias/el-sector-hortofruticola-apuesta-por-soluciones-sostenibles-para-la-cadena-de-suministro/");
INSERT INTO `wp_postmeta` VALUES("16599", "82491", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("16600", "82492", "url_article", "http://www.cadenadesuministro.es/noticias/afco-se-suma-al-pacto-por-una-economia-circular/");
INSERT INTO `wp_postmeta` VALUES("16601", "82492", "interes", "16");
INSERT INTO `wp_postmeta` VALUES("16602", "82493", "url_article", "http://www.cadenadesuministro.es/noticias/ds-smith-tendra-en-madrid-un-nuevo-impact-centre/");
INSERT INTO `wp_postmeta` VALUES("16603", "82493", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("16604", "82494", "url_article", "http://www.cadenadesuministro.es/noticias/lpr-y-euro-pool-cumplen-25-anos/");
INSERT INTO `wp_postmeta` VALUES("16605", "82494", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("16606", "82495", "url_article", "http://www.cadenadesuministro.es/noticias/hispack-2018-potencia-su-oferta-para-el-sector-de-la-intralogistica/");
INSERT INTO `wp_postmeta` VALUES("16607", "82495", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("16608", "82496", "url_article", "http://www.cadenadesuministro.es/noticias/espana-ha-reciclado-el-78-de-los-residuos-de-madera-generados-en-2016/");
INSERT INTO `wp_postmeta` VALUES("16609", "82496", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("16610", "82497", "url_article", "http://www.cadenadesuministro.es/noticias/el-packaging-para-el-sector-logistico-en-los-premios-liderpack-2017/");
INSERT INTO `wp_postmeta` VALUES("16611", "82497", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("16612", "82498", "url_article", "http://www.cadenadesuministro.es/noticias/ya-esta-en-marcha-la-nueva-planta-de-ulma-packaging-en-guipuzcoa/");
INSERT INTO `wp_postmeta` VALUES("16613", "82498", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16614", "82499", "url_article", "http://www.cadenadesuministro.es/noticias/nuevo-film-para-el-retractilado-de-palets/");
INSERT INTO `wp_postmeta` VALUES("16615", "82499", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16616", "82500", "url_article", "http://www.cadenadesuministro.es/category/noticias/manutencion/envases-y-embalajes-manutencion-industria/page/2/");
INSERT INTO `wp_postmeta` VALUES("16617", "82500", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16618", "82501", "url_article", "http://www.cadenadesuministro.es/category/noticias/manutencion/envases-y-embalajes-manutencion-industria/");
INSERT INTO `wp_postmeta` VALUES("16619", "82501", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16620", "82502", "url_article", "http://www.elika.net/es/noticias.asp?id=474");
INSERT INTO `wp_postmeta` VALUES("16621", "82502", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16622", "82503", "url_article", "http://vidasana.org/noticias/biosemillas-el-simbolo-de-la-vida");
INSERT INTO `wp_postmeta` VALUES("16623", "82503", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16624", "82504", "url_article", "http://www.bbc.com/news/world-europe-43366724");
INSERT INTO `wp_postmeta` VALUES("16625", "82504", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16626", "82504", "url_picture", "https://ichef-1.bbci.co.uk/news/320/cpsprodpb/13A7B/production/_100370508_selmayr.jpg");
INSERT INTO `wp_postmeta` VALUES("16627", "82505", "url_article", "http://www.bbc.com/news/world-europe-43210257");
INSERT INTO `wp_postmeta` VALUES("16628", "82505", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16629", "82505", "url_picture", "https://ichef-1.bbci.co.uk/news/1024/branded_news/A148/production/_100288214_russianpoverty-colour-swap-640-nc.png");
INSERT INTO `wp_postmeta` VALUES("16630", "82506", "url_article", "http://www.bbc.com/news/newsbeat-43332200");
INSERT INTO `wp_postmeta` VALUES("16631", "82506", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16632", "82506", "url_picture", "https://ichef-1.bbci.co.uk/news/320/cpsprodpb/BC39/production/_100358184_whatsappimage2018-03-10at12.32.01-1.jpg");
INSERT INTO `wp_postmeta` VALUES("16633", "82507", "url_article", "http://www.bbc.com/news/world-us-canada-43376316");
INSERT INTO `wp_postmeta` VALUES("16634", "82507", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16635", "82507", "url_picture", "https://ichef-1.bbci.co.uk/news/320/cpsprodpb/DF15/production/_100390175_capsa4e44ture.jpg");
INSERT INTO `wp_postmeta` VALUES("16636", "82508", "url_article", "http://www.bbc.com/news/newsbeat-43372064");
INSERT INTO `wp_postmeta` VALUES("16637", "82508", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("16638", "82508", "url_picture", "https://ichef-1.bbci.co.uk/news/320/cpsprodpb/121C2/production/_100387147_1d26af01-9966-4a38-8f60-a9c82101fb0c.jpg");
INSERT INTO `wp_postmeta` VALUES("16639", "82509", "url_article", "http://www.bbc.com/travel/story/20180311-the-most-ambitious-country-in-the-world");
INSERT INTO `wp_postmeta` VALUES("16640", "82509", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16641", "82509", "url_picture", "http://ichef.bbci.co.uk/wwfeatures/live/624_351/images/live/p0/60/jy/p060jy0b.jpg");
INSERT INTO `wp_postmeta` VALUES("16642", "82510", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/flat_screens_should_be_designed_for_quick_dismantling_for_recycling_400na5_en.pdf");
INSERT INTO `wp_postmeta` VALUES("16643", "82510", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("16644", "82511", "url_article", "http://www.bbc.com/news/10628994");
INSERT INTO `wp_postmeta` VALUES("16645", "82511", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16646", "82511", "url_picture", "https://ichef.bbci.co.uk/news/1024/branded_news/C057/production/_98893294_1920x1080-nc.png");
INSERT INTO `wp_postmeta` VALUES("16647", "82512", "url_article", "http://feedproxy.google.com/~r/Gominolasdepetroleo/~3/gt21-v8DIrE/que-nos-depara-2018-en-materia-de.html");
INSERT INTO `wp_postmeta` VALUES("16648", "82512", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("16649", "82513", "url_article", "http://vidasana.org/noticias/natural-skin-beauty-debut-en-biocultura-barcelona");
INSERT INTO `wp_postmeta` VALUES("16650", "82513", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("16651", "82514", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/new_tool_to_aid_evidence_based_decisions_on_eradicating_alien_species_398na2_en.pdf");
INSERT INTO `wp_postmeta` VALUES("16652", "82514", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16653", "82515", "url_article", "https://www.foodsafetymagazine.com/products/");
INSERT INTO `wp_postmeta` VALUES("16654", "82515", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("16655", "82516", "url_article", "https://www.foodsafetymagazine.com/categories/facilities-category/hygienic-equipment-design");
INSERT INTO `wp_postmeta` VALUES("16656", "82516", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("16657", "82517", "url_article", "https://www.foodsafetymagazine.com/enewsletter/a-look-back-at-2017-food-recalls/");
INSERT INTO `wp_postmeta` VALUES("16658", "82517", "interes", "17");
INSERT INTO `wp_postmeta` VALUES("16659", "82518", "url_article", "https://www.foodsafetymagazine.com/categories/process-control-category/packaging");
INSERT INTO `wp_postmeta` VALUES("16660", "82518", "interes", "15");
INSERT INTO `wp_postmeta` VALUES("16661", "82519", "url_article", "http://vidasana.org/noticias/educacin-escuela-waldorf-en-andalucia");
INSERT INTO `wp_postmeta` VALUES("16662", "82519", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16663", "82520", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/eco-design_non-electrical_products_environmental_information_services_sustainable_389na2_en.pdf");
INSERT INTO `wp_postmeta` VALUES("16664", "82520", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16665", "82521", "url_article", "https://www.foodsafetymagazine.com/categories/regulatory-category/inspection");
INSERT INTO `wp_postmeta` VALUES("16666", "82521", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("16667", "82522", "url_article", "http://www.huhtamaki.com/our-products");
INSERT INTO `wp_postmeta` VALUES("16668", "82522", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("16669", "82523", "url_article", "http://www.huhtamaki.com/-/huhtamaki-publishes-2017-results-on-february-14-2018");
INSERT INTO `wp_postmeta` VALUES("16670", "82523", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16671", "82524", "url_article", "http://www.huhtamaki.com/-/huhtamaki-oyj-announces-indicative-tender-offer-results-for-its-outstanding-notes-maturing-in-2020");
INSERT INTO `wp_postmeta` VALUES("16672", "82524", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("16673", "82525", "url_article", "http://www.huhtamaki.com/-/huhtamaki-completed-the-acquisition-of-foodservice-units-in-china");
INSERT INTO `wp_postmeta` VALUES("16674", "82525", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16675", "82526", "url_article", "http://www.huhtamaki.com/careers/working-for-huhtamaki");
INSERT INTO `wp_postmeta` VALUES("16676", "82526", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16677", "82527", "url_article", "http://www.huhtamaki.com/-/huhtamaki-s-annual-accounts-and-directors-report-2017-published");
INSERT INTO `wp_postmeta` VALUES("16678", "82527", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16679", "82528", "url_article", "http://www.huhtamaki.com/responsibility/our-supply-chain");
INSERT INTO `wp_postmeta` VALUES("16680", "82528", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("16681", "82529", "url_article", "http://www.huhtamaki.com/responsibility/packaging-we-make");
INSERT INTO `wp_postmeta` VALUES("16682", "82529", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("16683", "82530", "url_article", "https://www.packagingnews.co.uk/supplier-network/kwikpac-ltd");
INSERT INTO `wp_postmeta` VALUES("16684", "82530", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16685", "82530", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2016/09/Revised-Kwikpac-Logo.jpg");
INSERT INTO `wp_postmeta` VALUES("16686", "82531", "url_article", "http://www.huhtamaki.com/web/foodservice/home");
INSERT INTO `wp_postmeta` VALUES("16687", "82531", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16688", "82532", "url_article", "http://www.huhtamaki.com/responsibility/our-agenda");
INSERT INTO `wp_postmeta` VALUES("16689", "82532", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16690", "82533", "url_article", "https://www.packagingnews.co.uk/foodservice-markets");
INSERT INTO `wp_postmeta` VALUES("16691", "82533", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16692", "82533", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2017/09/CupCycling_BeautifulPapers-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16693", "82534", "url_article", "http://www.huhtamaki.com/-/huhtamaki-to-further-improve-its-competitiveness-in-china");
INSERT INTO `wp_postmeta` VALUES("16694", "82534", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16695", "82535", "url_article", "https://www.packagingnews.co.uk/news/environment/prn-pricewatch/prn-pricewatch-week-ending-12-january-2018-26-02-2018");
INSERT INTO `wp_postmeta` VALUES("16696", "82535", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16697", "82535", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2015/07/PRN-Pricewatch.jpg");
INSERT INTO `wp_postmeta` VALUES("16698", "82536", "url_article", "https://www.packagingnews.co.uk/news/markets/personal-care");
INSERT INTO `wp_postmeta` VALUES("16699", "82536", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("16700", "82536", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/02/HPC-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16701", "82537", "url_article", "https://www.packagingnews.co.uk/supplier-network/videos");
INSERT INTO `wp_postmeta` VALUES("16702", "82537", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16703", "82537", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2017/01/kwikpac-video-3-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16704", "82538", "url_article", "http://www.huhtamaki.com/-/huhtamaki-invests-in-a-new-manufacturing-facility-in-hameenlinna-finland");
INSERT INTO `wp_postmeta` VALUES("16705", "82538", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("16706", "82538", "url_picture", "https://hugin.info/3006/I/2149169/123848.jpg");
INSERT INTO `wp_postmeta` VALUES("16707", "82539", "url_article", "https://www.packagingnews.co.uk/supplier-network/whitepapers");
INSERT INTO `wp_postmeta` VALUES("16708", "82539", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16709", "82539", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2017/01/Layer-pallitise-image-1.jpg");
INSERT INTO `wp_postmeta` VALUES("16710", "82540", "url_article", "https://www.packagingnews.co.uk/equipment/tech-talk");
INSERT INTO `wp_postmeta` VALUES("16711", "82540", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16712", "82540", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2015/04/Paul-Wilkinson-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16713", "82541", "url_article", "https://www.packagingnews.co.uk/news/waste-management/prn-pricewatch-week-ending-19-january-2018-06-03-2018");
INSERT INTO `wp_postmeta` VALUES("16714", "82541", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16715", "82541", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2011/11/PRN-Pricewatch.jpg");
INSERT INTO `wp_postmeta` VALUES("16716", "82542", "url_article", "http://www.huhtamaki.com/-/huhtamaki-s-financial-reporting-in-2018");
INSERT INTO `wp_postmeta` VALUES("16717", "82542", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16718", "82543", "url_article", "https://www.packagingnews.co.uk/features");
INSERT INTO `wp_postmeta` VALUES("16719", "82543", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16720", "82543", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/02/RigidC_Twinings-web-70x70.png");
INSERT INTO `wp_postmeta` VALUES("16721", "82544", "url_article", "http://www.huhtamaki.com/about-us");
INSERT INTO `wp_postmeta` VALUES("16722", "82544", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("16723", "82545", "url_article", "https://www.packagingnews.co.uk/news/markets/food");
INSERT INTO `wp_postmeta` VALUES("16724", "82545", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16725", "82545", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/anuga-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16726", "82546", "url_article", "https://www.packagingnews.co.uk/news/environment/prn-pricewatch/prn-pricewatch-week-ending-5-january-2018-22-02-2018");
INSERT INTO `wp_postmeta` VALUES("16727", "82546", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16728", "82546", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2015/07/PRN-Pricewatch.jpg");
INSERT INTO `wp_postmeta` VALUES("16729", "82547", "url_article", "https://www.packagingnews.co.uk/events-diary");
INSERT INTO `wp_postmeta` VALUES("16730", "82547", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("16731", "82548", "url_article", "https://www.packagingnews.co.uk/news/environment/recycling/page/30");
INSERT INTO `wp_postmeta` VALUES("16732", "82548", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("16733", "82548", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2014/08/Braskems-products1-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16734", "82549", "url_article", "http://www.huhtamaki.com/responsibility/manufacturing-operations");
INSERT INTO `wp_postmeta` VALUES("16735", "82549", "interes", "17");
INSERT INTO `wp_postmeta` VALUES("16736", "82550", "url_article", "http://www.huhtamaki.com/about-us/");
INSERT INTO `wp_postmeta` VALUES("16737", "82550", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("16738", "82551", "url_article", "https://www.packagingnews.co.uk/news/business/results/ds-smith-reports-continued-box-volume-growth-07-03-2018");
INSERT INTO `wp_postmeta` VALUES("16739", "82551", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16740", "82551", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2017/04/ds-smith-rebrand-620x330.jpg");
INSERT INTO `wp_postmeta` VALUES("16741", "82552", "url_article", "https://www.packagingnews.co.uk/news/waste-management/prn-pricewatch-week-ending-22-december-2017-12-02-2018");
INSERT INTO `wp_postmeta` VALUES("16742", "82552", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16743", "82552", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2015/07/PRN-Pricewatch.jpg");
INSERT INTO `wp_postmeta` VALUES("16744", "82553", "url_article", "http://www.huhtamaki.com/about-us/news/-/asset_publisher/Cgpyjwe7wUQR/content/a-day-of-celebration-in-south-china?inheritRedirect=false&redirect=http%3A%2F%2Fwww.huhtamaki.com%2Fabout-us%2Fnews%3Fp_p_id%3D101_INSTANCE_Cgpyjwe7wUQR%26p_p_lifecycle%3D0%26p_p_state%3Dnormal%26p_p_mode%3Dview%26p_p_col_id%3Dcolumn-2%26p_p_col_pos%3D2%26p_p_col_count%3D3");
INSERT INTO `wp_postmeta` VALUES("16745", "82553", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16746", "82554", "url_article", "https://www.packagingnews.co.uk/news/environment/litter");
INSERT INTO `wp_postmeta` VALUES("16747", "82554", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("16748", "82554", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/Panda-Recycling-LR-300x200.png");
INSERT INTO `wp_postmeta` VALUES("16749", "82555", "url_article", "http://www.huhtamaki.com/-/huhtamaki-oyj-s-half-yearly-report-january-1-june-30-2017-net-sales-grew-and-profitability-was-at-a-good-level");
INSERT INTO `wp_postmeta` VALUES("16750", "82555", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("16751", "82556", "url_article", "http://www.huhtamaki.com/-/huhtamaki-expands-to-paper-bag-manufacture-in-poland");
INSERT INTO `wp_postmeta` VALUES("16752", "82556", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16753", "82557", "url_article", "https://www.packagingnews.co.uk/news/communicate-packagings-benefits-says-mpmas-boyd-02-03-2018");
INSERT INTO `wp_postmeta` VALUES("16754", "82557", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("16755", "82557", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/William-Boyd-MPMA-550x330.jpeg");
INSERT INTO `wp_postmeta` VALUES("16756", "82558", "url_article", "http://www.huhtamaki.com/-/proposals-by-huhtamaki-oyj-s-nomination-committee-to-the-annual-general-meeting-of-shareholde-1");
INSERT INTO `wp_postmeta` VALUES("16757", "82558", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16758", "82559", "url_article", "https://www.packagingnews.co.uk/equipment/project-profile");
INSERT INTO `wp_postmeta` VALUES("16759", "82559", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16760", "82559", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/02/Frylight-range-2017-capless-web-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16761", "82560", "url_article", "http://www.huhtamaki.com/");
INSERT INTO `wp_postmeta` VALUES("16762", "82560", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16763", "82561", "url_article", "https://www.packagingnews.co.uk/news/muller-buy-nampak-plastic-bottling-plants-05-03-2018");
INSERT INTO `wp_postmeta` VALUES("16764", "82561", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("16765", "82561", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/05/muller-buy-nampak-plastic-bottling-plants/Muller-Semi-TL-v21-620x330.png");
INSERT INTO `wp_postmeta` VALUES("16766", "82562", "url_article", "https://www.packagingnews.co.uk/");
INSERT INTO `wp_postmeta` VALUES("16767", "82562", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16768", "82562", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/02/RigidC_Twinings-web-70x70.png");
INSERT INTO `wp_postmeta` VALUES("16769", "82563", "url_article", "https://www.packagingnews.co.uk/contactus");
INSERT INTO `wp_postmeta` VALUES("16770", "82563", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16771", "82563", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/contactus/Chadwick-web1.jpg");
INSERT INTO `wp_postmeta` VALUES("16772", "82564", "url_article", "https://www.packagingnews.co.uk/news");
INSERT INTO `wp_postmeta` VALUES("16773", "82564", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16774", "82564", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/Smurfit-Video-still-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16775", "82565", "url_article", "http://www.huhtamaki.com/web/flexible-packaging");
INSERT INTO `wp_postmeta` VALUES("16776", "82565", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16777", "82566", "url_article", "https://www.packagingnews.co.uk/features/market-features");
INSERT INTO `wp_postmeta` VALUES("16778", "82566", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16779", "82566", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/02/Essesentra-packs-web-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16780", "82567", "url_article", "https://www.packagingnews.co.uk/news/materials/glass");
INSERT INTO `wp_postmeta` VALUES("16781", "82567", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16782", "82567", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/02/19/o-gets-gold-sustainable-pack-scheme/O-I-Harlow-plant-web-300x200.png");
INSERT INTO `wp_postmeta` VALUES("16783", "82568", "url_article", "https://www.packagingnews.co.uk/features/news-analysis");
INSERT INTO `wp_postmeta` VALUES("16784", "82568", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16785", "82568", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/02/plastic-waste-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16786", "82569", "url_article", "http://www.huhtamaki.com/-/huhtamaki-oyj-s-results-january-1-december-31-2017-a-year-of-continued-investment");
INSERT INTO `wp_postmeta` VALUES("16787", "82569", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("16788", "82570", "url_article", "https://www.packagingnews.co.uk/news/markets/coffee-and-paper-cups/panda-recycling-set-include-smart-planets-recup-collections-06-03-2018");
INSERT INTO `wp_postmeta` VALUES("16789", "82570", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("16790", "82570", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/Panda-Recycling-LR-550x330.png");
INSERT INTO `wp_postmeta` VALUES("16791", "82571", "url_article", "http://www.huhtamaki.com/about-us/our-history");
INSERT INTO `wp_postmeta` VALUES("16792", "82571", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16793", "82572", "url_article", "http://www.huhtamaki.com/-/huhtamaki-oyj-considers-the-issuance-of-new-notes-and-announces-a-voluntary-tender-offer-for-its-outstanding-notes-maturing-in-2020");
INSERT INTO `wp_postmeta` VALUES("16794", "82572", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("16795", "82573", "url_article", "https://www.packagingnews.co.uk/news/environment/recycling/page/63");
INSERT INTO `wp_postmeta` VALUES("16796", "82573", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("16797", "82574", "url_article", "http://www.huhtamaki.com/careers/people-stories");
INSERT INTO `wp_postmeta` VALUES("16798", "82574", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16799", "82575", "url_article", "https://www.packagingnews.co.uk/top-story/report-claims-plastic-packaging-rates-overestimated-06-03-2018");
INSERT INTO `wp_postmeta` VALUES("16800", "82575", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("16801", "82575", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/02/plastic-waste-550x330.jpg");
INSERT INTO `wp_postmeta` VALUES("16802", "82576", "url_article", "https://www.packagingnews.co.uk/news/machinery-news");
INSERT INTO `wp_postmeta` VALUES("16803", "82576", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16804", "82576", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/HP_SPS_Max_Applications-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16805", "82577", "url_article", "https://www.packagingnews.co.uk/news/markets/industrial");
INSERT INTO `wp_postmeta` VALUES("16806", "82577", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16807", "82577", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2017/12/Stora-Enso-China-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16808", "82578", "url_article", "https://www.packagingnews.co.uk/news/environment/prn-pricewatch/prn-pricewatch-week-ending-29-december-2017-14-02-2018");
INSERT INTO `wp_postmeta` VALUES("16809", "82578", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16810", "82578", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2015/07/PRN-Pricewatch.jpg");
INSERT INTO `wp_postmeta` VALUES("16811", "82579", "url_article", "http://www.huhtamaki.com/-/listing-prospectus-for-huhtamaki-oyj-s-eur-150-million-bond-available");
INSERT INTO `wp_postmeta` VALUES("16812", "82579", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("16813", "82580", "url_article", "https://www.packagingnews.co.uk/equipment");
INSERT INTO `wp_postmeta` VALUES("16814", "82580", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16815", "82580", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/02/Clarks-Image-web-70x70.jpg");
INSERT INTO `wp_postmeta` VALUES("16816", "82581", "url_article", "https://www.packagingnews.co.uk/news/environment/recycling/luxus-service-tests-end-life-plastic-packaging-recyclability-15-02-2018");
INSERT INTO `wp_postmeta` VALUES("16817", "82581", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("16818", "82581", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/02/Luxus-Coloured-yogurt-pots.jpg");
INSERT INTO `wp_postmeta` VALUES("16819", "82582", "url_article", "https://www.packagingnews.co.uk/supplier-network/fortress-technology/whitepapers/metal-detectors-the-natural-choice-for-britains-thriving-food-on-the-go-smes");
INSERT INTO `wp_postmeta` VALUES("16820", "82582", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16821", "82582", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2017/01/fortess-image-3.jpg");
INSERT INTO `wp_postmeta` VALUES("16822", "82583", "url_article", "http://www.huhtamaki.com/-/huhtamaki-oyj-announces-final-tender-offer-results-for-its-outstanding-notes-maturing-in-2020");
INSERT INTO `wp_postmeta` VALUES("16823", "82583", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("16824", "82584", "url_article", "https://www.packagingnews.co.uk/news/events/packaging-innovations-empack-labelprint-2018");
INSERT INTO `wp_postmeta` VALUES("16825", "82584", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("16826", "82584", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/APS-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16827", "82585", "url_article", "http://www.huhtamaki.com/-/huhtamaki-publishes-q3-2017-interim-report-on-october-26-2017");
INSERT INTO `wp_postmeta` VALUES("16828", "82585", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16829", "82586", "url_article", "http://www.huhtamaki.com/-/huhtamaki-oyj-issues-a-eur-150-million-bond");
INSERT INTO `wp_postmeta` VALUES("16830", "82586", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("16831", "82587", "url_article", "https://www.packagingnews.co.uk/news/environment/marine-litter-environment");
INSERT INTO `wp_postmeta` VALUES("16832", "82587", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("16833", "82587", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/Panda-Recycling-LR-300x200.png");
INSERT INTO `wp_postmeta` VALUES("16834", "82588", "url_article", "http://www.huhtamaki.com/-/huhtamaki-oyj-s-interim-report-january-1-september-30-2017-continued-comparable-growth");
INSERT INTO `wp_postmeta` VALUES("16835", "82588", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("16836", "82589", "url_article", "http://www.huhtamaki.com/-/huhtamaki-publishes-2017-half-yearly-report-on-july-21-2017");
INSERT INTO `wp_postmeta` VALUES("16837", "82589", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16838", "82590", "url_article", "https://www.packagingnews.co.uk/termsandconditions");
INSERT INTO `wp_postmeta` VALUES("16839", "82590", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("16840", "82591", "url_article", "http://www.huhtamaki.com/-/proposals-by-huhtamaki-oyj-s-board-of-directors-and-audit-committee-to-the-annual-general-meeting-of-shareholde-3");
INSERT INTO `wp_postmeta` VALUES("16841", "82591", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16842", "82592", "url_article", "https://www.packagingnews.co.uk/news/materials/metal");
INSERT INTO `wp_postmeta` VALUES("16843", "82592", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16844", "82592", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/William-Boyd-MPMA-300x200.jpeg");
INSERT INTO `wp_postmeta` VALUES("16845", "82593", "url_article", "https://www.packagingnews.co.uk/design/new-packs");
INSERT INTO `wp_postmeta` VALUES("16846", "82593", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16847", "82593", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/RPC-Superfos-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16848", "82594", "url_article", "https://www.packagingnews.co.uk/supplier-network/case_studies");
INSERT INTO `wp_postmeta` VALUES("16849", "82594", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16850", "82594", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/01/Yorkshire2DSCF6096-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16851", "82595", "url_article", "https://www.packagingnews.co.uk/news/materials/labelling");
INSERT INTO `wp_postmeta` VALUES("16852", "82595", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16853", "82595", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/02/Denny-Bros-HQ-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16854", "82596", "url_article", "https://www.packagingnews.co.uk/newsletters");
INSERT INTO `wp_postmeta` VALUES("16855", "82596", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16856", "82596", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/02/RigidC_Twinings-web-70x70.png");
INSERT INTO `wp_postmeta` VALUES("16857", "82597", "url_article", "https://www.packagingnews.co.uk/supplier-network/all");
INSERT INTO `wp_postmeta` VALUES("16858", "82597", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16859", "82598", "url_article", "https://www.packagingnews.co.uk/news/environment/prn-pricewatch");
INSERT INTO `wp_postmeta` VALUES("16860", "82598", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16861", "82598", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2011/11/PRN-Pricewatch.jpg");
INSERT INTO `wp_postmeta` VALUES("16862", "82599", "url_article", "https://www.packagingnews.co.uk/news/markets/drinks");
INSERT INTO `wp_postmeta` VALUES("16863", "82599", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16864", "82599", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/coke-coffee-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16865", "82600", "url_article", "https://www.packagingnews.co.uk/news/contractpacker");
INSERT INTO `wp_postmeta` VALUES("16866", "82600", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16867", "82600", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/PCI-2018-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16868", "82601", "url_article", "https://www.packagingnews.co.uk/design/shelf-review");
INSERT INTO `wp_postmeta` VALUES("16869", "82601", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16870", "82601", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2014/03/vini-and-bals-crop-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16871", "82602", "url_article", "https://www.packagingnews.co.uk/news/business/mergers-acquisitions/smurfit-kappa-rejects-unsolicited-acquisition-proposal-international-paper-06-03-2018");
INSERT INTO `wp_postmeta` VALUES("16872", "82602", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16873", "82602", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2017/07/Smurfit-Kappa-SupplySmart-620x330.jpg");
INSERT INTO `wp_postmeta` VALUES("16874", "82603", "url_article", "https://www.packagingnews.co.uk/news/environment");
INSERT INTO `wp_postmeta` VALUES("16875", "82603", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16876", "82603", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/ecolean-at-anuga-foodtec-2018thumbnail-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16877", "82604", "url_article", "https://www.packagingnews.co.uk/equipment/convertingandprinting");
INSERT INTO `wp_postmeta` VALUES("16878", "82604", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16879", "82604", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/BOBST-MASTERFOLD-75_110-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16880", "82605", "url_article", "https://www.packagingnews.co.uk/news/plastics-news");
INSERT INTO `wp_postmeta` VALUES("16881", "82605", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("16882", "82605", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/05/muller-buy-nampak-plastic-bottling-plants/Muller-Semi-TL-v21-300x200.png");
INSERT INTO `wp_postmeta` VALUES("16883", "82606", "url_article", "https://www.packagingnews.co.uk/equipment/packingfilling-equipment");
INSERT INTO `wp_postmeta` VALUES("16884", "82606", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16885", "82606", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/SIG_DNP-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16886", "82607", "url_article", "https://www.packagingnews.co.uk/news/markets/coffee-and-paper-cups/huhtamaki-manufactures-recyclable-tri-cup-tri-star-packaging-13-02-2018");
INSERT INTO `wp_postmeta` VALUES("16887", "82607", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("16888", "82607", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/02/TriStar-cups-550x330.jpg");
INSERT INTO `wp_postmeta` VALUES("16889", "82608", "url_article", "https://www.packagingnews.co.uk/news/materials");
INSERT INTO `wp_postmeta` VALUES("16890", "82608", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16891", "82608", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/SIG_DNP-70x70.jpg");
INSERT INTO `wp_postmeta` VALUES("16892", "82609", "url_article", "https://www.packagingnews.co.uk/news/markets/pharmaceutical-medical");
INSERT INTO `wp_postmeta` VALUES("16893", "82609", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16894", "82609", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/02/k-haler_iF-Award_01-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16895", "82610", "url_article", "https://www.packagingnews.co.uk/news/materials/cartonboard");
INSERT INTO `wp_postmeta` VALUES("16896", "82610", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16897", "82610", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/SIG_DNP-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16898", "82611", "url_article", "https://www.packagingnews.co.uk/news/environment/recycling/page/5");
INSERT INTO `wp_postmeta` VALUES("16899", "82611", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16900", "82611", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2015/07/PRN-Pricewatch.jpg");
INSERT INTO `wp_postmeta` VALUES("16901", "82612", "url_article", "https://www.packagingnews.co.uk/news/business");
INSERT INTO `wp_postmeta` VALUES("16902", "82612", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16903", "82612", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/higher-education-degree-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16904", "82613", "url_article", "https://www.packagingnews.co.uk/news/environment/recycling/page/4");
INSERT INTO `wp_postmeta` VALUES("16905", "82613", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("16906", "82613", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/01/Worlds-largest-t-shirt-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16907", "82614", "url_article", "https://www.packagingnews.co.uk/features/profile");
INSERT INTO `wp_postmeta` VALUES("16908", "82614", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16909", "82614", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/01/Kevin-Vyse-MS-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16910", "82615", "url_article", "https://www.packagingnews.co.uk/news/environment/recycling/page/2");
INSERT INTO `wp_postmeta` VALUES("16911", "82615", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("16912", "82615", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/01/pawsey-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16913", "82616", "url_article", "https://www.packagingnews.co.uk/news/environment/recycling/page/3");
INSERT INTO `wp_postmeta` VALUES("16914", "82616", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16915", "82616", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2017/08/waitrose_131781652645391-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16916", "82617", "url_article", "https://www.packagingnews.co.uk/supplier-network/products");
INSERT INTO `wp_postmeta` VALUES("16917", "82617", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16918", "82617", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/01/Hugo-Beck-flowpack-machine-X-D-2-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16919", "82618", "url_article", "https://www.packagingnews.co.uk/news/environment/courtauld-2");
INSERT INTO `wp_postmeta` VALUES("16920", "82618", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16921", "82618", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2011/11/PRN-Pricewatch.jpg");
INSERT INTO `wp_postmeta` VALUES("16922", "82619", "url_article", "https://www.packagingnews.co.uk/supplier-network/amcor-flexibles-europe-americas-2/whitepapers/unrivalled-moisture-protection-with-a-breakthrough-blister-system");
INSERT INTO `wp_postmeta` VALUES("16923", "82619", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("16924", "82619", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2017/01/Amcor-Dessiflex-whitepaper-260x332px-235x300.jpg");
INSERT INTO `wp_postmeta` VALUES("16925", "82620", "url_article", "https://www.packagingnews.co.uk/supplier-network/photos");
INSERT INTO `wp_postmeta` VALUES("16926", "82620", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16927", "82620", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2015/05/Clifton-graphic-600px-x-400px-Directory-Listing-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16928", "82621", "url_article", "https://www.packagingnews.co.uk/design/case-study");
INSERT INTO `wp_postmeta` VALUES("16929", "82621", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16930", "82621", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2017/08/2L-Fanta-Twist-Production-Wakefield-web-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16931", "82622", "url_article", "https://www.packagingnews.co.uk/news/events/packaging-innovations-empack-labelprint-2018/packaging-innovations-2018-plastics-debate-completes-great-first-day-01-03-2018");
INSERT INTO `wp_postmeta` VALUES("16932", "82622", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("16933", "82622", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/IMG_6917.jpg");
INSERT INTO `wp_postmeta` VALUES("16934", "82623", "url_article", "https://www.packagingnews.co.uk/news/events");
INSERT INTO `wp_postmeta` VALUES("16935", "82623", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16936", "82623", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/Smurfit-Video-still-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16937", "82624", "url_article", "https://www.packagingnews.co.uk/media-centre");
INSERT INTO `wp_postmeta` VALUES("16938", "82624", "interes", "20");
INSERT INTO `wp_postmeta` VALUES("16939", "82624", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2016/11/IMG_2914_350x250.jpg");
INSERT INTO `wp_postmeta` VALUES("16940", "82625", "url_article", "https://www.packagingnews.co.uk/design");
INSERT INTO `wp_postmeta` VALUES("16941", "82625", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16942", "82625", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2017/08/2L-Fanta-Twist-Production-Wakefield-web-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16943", "82626", "url_article", "https://www.packagingnews.co.uk/news/materials/rigid-plastics");
INSERT INTO `wp_postmeta` VALUES("16944", "82626", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16945", "82626", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/02/plastic-waste-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16946", "82627", "url_article", "http://vidasana.org/noticias/ecocosmtica-aprende-a-distinguir-en-biocultura-valencia");
INSERT INTO `wp_postmeta` VALUES("16947", "82627", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16948", "82628", "url_article", "https://www.packagingnews.co.uk/news/waste-management");
INSERT INTO `wp_postmeta` VALUES("16949", "82628", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("16950", "82628", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/APS-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16951", "82629", "url_article", "https://www.packagingnews.co.uk/news/materials/paper");
INSERT INTO `wp_postmeta` VALUES("16952", "82629", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16953", "82629", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/Business-Design-Centre-300x200.png");
INSERT INTO `wp_postmeta` VALUES("16954", "82630", "url_article", "https://www.packagingnews.co.uk/news/environment/recycling/page/20");
INSERT INTO `wp_postmeta` VALUES("16955", "82630", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16956", "82630", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2016/07/Hawkeswood-Metal-Recycling-plant-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16957", "82631", "url_article", "https://www.packagingnews.co.uk/equipment/buyersguide");
INSERT INTO `wp_postmeta` VALUES("16958", "82631", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16959", "82631", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/02/Clarks-Image-web-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16960", "82632", "url_article", "https://www.packagingnews.co.uk/supplier-network/amcor-flexibles-europe-americas-2/whitepapers/can-metal-free-packaging-ever-replace-aluminium-for-sensitive-products");
INSERT INTO `wp_postmeta` VALUES("16961", "82632", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16962", "82632", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2016/10/Amcor-AmLite-whitepaper-cover-image-217x300.jpg");
INSERT INTO `wp_postmeta` VALUES("16963", "82633", "url_article", "https://www.packagingnews.co.uk/news/materials/closures");
INSERT INTO `wp_postmeta` VALUES("16964", "82633", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16965", "82633", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/02/Crown-Capping-Machine-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16966", "82634", "url_article", "https://www.packagingnews.co.uk/digital-editions");
INSERT INTO `wp_postmeta` VALUES("16967", "82634", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16968", "82634", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2012/04/DS-Smith-chief-executive-Miles-Roberts1-70x70.jpg");
INSERT INTO `wp_postmeta` VALUES("16969", "82635", "url_article", "https://www.packagingnews.co.uk/aboutus");
INSERT INTO `wp_postmeta` VALUES("16970", "82635", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("16971", "82636", "url_article", "https://www.packagingnews.co.uk/digital-editions/");
INSERT INTO `wp_postmeta` VALUES("16972", "82636", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16973", "82636", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2012/04/DS-Smith-chief-executive-Miles-Roberts1-70x70.jpg");
INSERT INTO `wp_postmeta` VALUES("16974", "82637", "url_article", "https://www.packagingnews.co.uk/news/retailers");
INSERT INTO `wp_postmeta` VALUES("16975", "82637", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("16976", "82637", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2011/11/PRN-Pricewatch.jpg");
INSERT INTO `wp_postmeta` VALUES("16977", "82638", "url_article", "https://www.packagingnews.co.uk/features/comment/soapbox");
INSERT INTO `wp_postmeta` VALUES("16978", "82638", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("16979", "82638", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/02/15/james-butcher-icelands-move-scrap-plastic-re-invigorate-grocery-packaging-sector/James_Butcher-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16980", "82639", "url_article", "https://www.packagingnews.co.uk/news/markets/coffee-and-paper-cups");
INSERT INTO `wp_postmeta` VALUES("16981", "82639", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("16982", "82639", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/Panda-Recycling-LR-300x200.png");
INSERT INTO `wp_postmeta` VALUES("16983", "82640", "url_article", "https://www.packagingnews.co.uk/news/markets/cosmetics");
INSERT INTO `wp_postmeta` VALUES("16984", "82640", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16985", "82640", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2015/02/Albea-bottanuco-factoryexterior-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16986", "82641", "url_article", "https://www.packagingnews.co.uk/equipment/investment-installations");
INSERT INTO `wp_postmeta` VALUES("16987", "82641", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16988", "82641", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/SIG_DNP-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16989", "82642", "url_article", "https://www.packagingnews.co.uk/news/markets/foodservice");
INSERT INTO `wp_postmeta` VALUES("16990", "82642", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16991", "82642", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2017/03/COFFEE-CUP-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16992", "82643", "url_article", "https://www.packagingnews.co.uk/top-story");
INSERT INTO `wp_postmeta` VALUES("16993", "82643", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("16994", "82643", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2017/03/COFFEE-CUP-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("16995", "82644", "url_article", "https://www.packagingnews.co.uk");
INSERT INTO `wp_postmeta` VALUES("16996", "82644", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("16997", "82644", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/02/RigidC_Twinings-web-70x70.png");
INSERT INTO `wp_postmeta` VALUES("16998", "82645", "url_article", "https://www.packagingnews.co.uk/supplier-network/pacepacker-services/whitepapers/palletising-possibilities-laid-out-layer-versus-robot-2");
INSERT INTO `wp_postmeta` VALUES("16999", "82645", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17000", "82645", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2017/01/Layer-pallitise-image-1.jpg");
INSERT INTO `wp_postmeta` VALUES("17001", "82646", "url_article", "https://www.packagingnews.co.uk/news/environment/");
INSERT INTO `wp_postmeta` VALUES("17002", "82646", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17003", "82646", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/ecolean-at-anuga-foodtec-2018thumbnail-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("17004", "82647", "url_article", "https://www.packagingnews.co.uk/news/materials/corrugated");
INSERT INTO `wp_postmeta` VALUES("17005", "82647", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17006", "82647", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/Business-Design-Centre-300x200.png");
INSERT INTO `wp_postmeta` VALUES("17007", "82648", "url_article", "https://www.packagingnews.co.uk/news/environment/recycling/page/10");
INSERT INTO `wp_postmeta` VALUES("17008", "82648", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("17009", "82648", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2017/07/The-Body-Shop-300x200.png");
INSERT INTO `wp_postmeta` VALUES("17010", "82649", "url_article", "https://www.packagingnews.co.uk/news/markets");
INSERT INTO `wp_postmeta` VALUES("17011", "82649", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17012", "82649", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/Panda-Recycling-LR-70x70.png");
INSERT INTO `wp_postmeta` VALUES("17013", "82650", "url_article", "https://www.packagingnews.co.uk/supplier-network/company-news");
INSERT INTO `wp_postmeta` VALUES("17014", "82650", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("17015", "82650", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/01/Yorkshire4B-nat-278x200.jpg");
INSERT INTO `wp_postmeta` VALUES("17016", "82651", "url_article", "https://www.packagingnews.co.uk/news/materials/flexible-plastics");
INSERT INTO `wp_postmeta` VALUES("17017", "82651", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("17018", "82651", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/BOBST-MASTERFOLD-75_110-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("17019", "82652", "url_article", "https://www.packagingnews.co.uk/news/environment/recycling");
INSERT INTO `wp_postmeta` VALUES("17020", "82652", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17021", "82652", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/Panda-Recycling-LR-300x200.png");
INSERT INTO `wp_postmeta` VALUES("17022", "82653", "url_article", "https://www.packagingnews.co.uk/news/markets/tobacco");
INSERT INTO `wp_postmeta` VALUES("17023", "82653", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17024", "82653", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2015/04/tobaccodisplayban2-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("17025", "82654", "url_article", "https://www.packagingnews.co.uk/supplier-network/fortress-technology/whitepapers/good-vibrations-tuning-into-food-metal-detection-frequencies");
INSERT INTO `wp_postmeta` VALUES("17026", "82654", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17027", "82654", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2017/01/bread-image-3.jpg");
INSERT INTO `wp_postmeta` VALUES("17028", "82655", "url_article", "https://www.packagingnews.co.uk/news/people");
INSERT INTO `wp_postmeta` VALUES("17029", "82655", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17030", "82655", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/03/Smurfit-Video-still-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("17031", "82656", "url_article", "https://www.packagingnews.co.uk/design/design-agencies");
INSERT INTO `wp_postmeta` VALUES("17032", "82656", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17033", "82656", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2018/01/Cambridge-Avon-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("17034", "82657", "url_article", "https://www.foodsafetymagazine.com/events1/");
INSERT INTO `wp_postmeta` VALUES("17035", "82657", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("17036", "82658", "url_article", "https://www.packagingnews.co.uk/news/markets/luxury-packaging");
INSERT INTO `wp_postmeta` VALUES("17037", "82658", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17038", "82658", "url_picture", "https://d3hjf51r9j54j7.cloudfront.net/wp-content/uploads/sites/7/2017/08/Inner-Workings-300x200.jpg");
INSERT INTO `wp_postmeta` VALUES("17039", "82659", "url_article", "http://www.packagingnews.com.au/news/australia-post-to-offer-customised-packaging-service");
INSERT INTO `wp_postmeta` VALUES("17040", "82659", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17041", "82659", "url_picture", "http://www.packagingnews.com.au/news/&#x2f;&#x2f;yaffa-cdn.s3.amazonaws.com&#x2f;yaffadsp&#x2f;images&#x2f;dmImage&#x2f;StandardImage&#x2f;mpos2789_t4a1816_ret2.jpg");
INSERT INTO `wp_postmeta` VALUES("17042", "82660", "url_article", "http://www.packagingnews.com.au/pack-expo");
INSERT INTO `wp_postmeta` VALUES("17043", "82660", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17044", "82661", "url_article", "http://www.packagingnews.com.au/news/ampacet-serves-up-sensory-feast-for-flexibles");
INSERT INTO `wp_postmeta` VALUES("17045", "82661", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("17046", "82661", "url_picture", "http://www.packagingnews.com.au/news/&#x2f;&#x2f;yaffa-cdn.s3.amazonaws.com&#x2f;yaffadsp&#x2f;images&#x2f;dmImage&#x2f;StandardImage&#x2f;290A8052.jpg");
INSERT INTO `wp_postmeta` VALUES("17047", "82662", "url_article", "http://www.packagingnews.com.au/news/netherlands-leads-with-plastic-free-supermarket-aisle");
INSERT INTO `wp_postmeta` VALUES("17048", "82662", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("17049", "82662", "url_picture", "http://www.packagingnews.com.au/news/&#x2f;&#x2f;yaffa-cdn.s3.amazonaws.com&#x2f;yaffadsp&#x2f;images&#x2f;dmImage&#x2f;SourceImage&#x2f;plastic-free-netherlands2.jpg");
INSERT INTO `wp_postmeta` VALUES("17050", "82663", "url_article", "http://www.packagingnews.com.au/directory");
INSERT INTO `wp_postmeta` VALUES("17051", "82663", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17052", "82664", "url_article", "http://www.packagingnews.com.au/pacprint");
INSERT INTO `wp_postmeta` VALUES("17053", "82664", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17054", "82664", "url_picture", "http://yaffa-cdn.s3.amazonaws.com/yaffadsp/images/dspArticle/featureImage/Kurz-at-pacPrint-IMG_9246.jpg");
INSERT INTO `wp_postmeta` VALUES("17055", "82665", "url_article", "http://www.packagingnews.com.au/news/pact-hy-delivers-sales-growth-and-44m-profit");
INSERT INTO `wp_postmeta` VALUES("17056", "82665", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("17057", "82665", "url_picture", "http://www.packagingnews.com.au/news/&#x2f;&#x2f;yaffa-cdn.s3.amazonaws.com&#x2f;yaffadsp&#x2f;images&#x2f;dmImage&#x2f;StandardImage&#x2f;Pact-Group-HERO-_94A00992.jpg");
INSERT INTO `wp_postmeta` VALUES("17058", "82666", "url_article", "http://www.packagingnews.com.au/news/pro-pac-sets-sights-on-market-leadership-in-flexibles");
INSERT INTO `wp_postmeta` VALUES("17059", "82666", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("17060", "82666", "url_picture", "http://www.packagingnews.com.au/news/&#x2f;&#x2f;yaffa-cdn.s3.amazonaws.com&#x2f;yaffadsp&#x2f;images&#x2f;dmImage&#x2f;StandardImage&#x2f;Grant-Harrod.jpg");
INSERT INTO `wp_postmeta` VALUES("17061", "82667", "url_article", "http://www.packagingnews.com.au/events/auspack");
INSERT INTO `wp_postmeta` VALUES("17062", "82667", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17063", "82668", "url_article", "http://www.packagingnews.com.au/news/blackmores-announces-pact-as-supplier-of-the-year");
INSERT INTO `wp_postmeta` VALUES("17064", "82668", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("17065", "82668", "url_picture", "http://www.packagingnews.com.au/news/&#x2f;&#x2f;yaffa-cdn.s3.amazonaws.com&#x2f;yaffadsp&#x2f;images&#x2f;dmImage&#x2f;StandardImage&#x2f;E-Cream-160924_Inpact-Annual-Report-Day-431938_KB2.jpg");
INSERT INTO `wp_postmeta` VALUES("17066", "82669", "url_article", "http://www.packagingnews.com.au/footer/contact-us");
INSERT INTO `wp_postmeta` VALUES("17067", "82669", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17068", "82670", "url_article", "http://www.packagingnews.com.au/news/qld-conference-draws-global-packaging-experts");
INSERT INTO `wp_postmeta` VALUES("17069", "82670", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("17070", "82670", "url_picture", "http://www.packagingnews.com.au/news/&#x2f;&#x2f;yaffa-cdn.s3.amazonaws.com&#x2f;yaffadsp&#x2f;images&#x2f;dmImage&#x2f;StandardImage&#x2f;aip-web2.jpg");
INSERT INTO `wp_postmeta` VALUES("17071", "82671", "url_article", "http://www.packagingnews.com.au/news/nano-structured-holograms-to-help-fight-counterfeits");
INSERT INTO `wp_postmeta` VALUES("17072", "82671", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("17073", "82671", "url_picture", "http://www.packagingnews.com.au/news/&#x2f;&#x2f;yaffa-cdn.s3.amazonaws.com&#x2f;yaffadsp&#x2f;images&#x2f;dmImage&#x2f;SourceImage&#x2f;schur-flexibles-15198123922.jpg");
INSERT INTO `wp_postmeta` VALUES("17074", "82672", "url_article", "http://www.packagingnews.com.au/interpack");
INSERT INTO `wp_postmeta` VALUES("17075", "82672", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17076", "82672", "url_picture", "http://yaffa-cdn.s3.amazonaws.com/yaffadsp/images/dspArticle/featureImage/ip_034.Multivac-MultiFresh-image.jpg");
INSERT INTO `wp_postmeta` VALUES("17077", "82673", "url_article", "http://www.packagingnews.com.au/printing");
INSERT INTO `wp_postmeta` VALUES("17078", "82673", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17079", "82674", "url_article", "http://www.packagingnews.com.au/cosmetics");
INSERT INTO `wp_postmeta` VALUES("17080", "82674", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17081", "82675", "url_article", "http://www.packagingnews.com.au/news/lion-craft-brewery-gets-world-first-can-and-bottle-filler");
INSERT INTO `wp_postmeta` VALUES("17082", "82675", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("17083", "82675", "url_picture", "http://www.packagingnews.com.au/news/&#x2f;&#x2f;yaffa-cdn.s3.amazonaws.com&#x2f;yaffadsp&#x2f;images&#x2f;dmImage&#x2f;StandardImage&#x2f;VIPOLL-VISITRON.jpg");
INSERT INTO `wp_postmeta` VALUES("17084", "82676", "url_article", "http://www.packagingnews.com.au/footer/about-us");
INSERT INTO `wp_postmeta` VALUES("17085", "82676", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("17086", "82677", "url_article", "http://www.packagingnews.com.au/news?page=2");
INSERT INTO `wp_postmeta` VALUES("17087", "82677", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17088", "82677", "url_picture", "http://yaffa-cdn.s3.amazonaws.com/yaffadsp/images/dspArticle/featureImage/HP-Indigo-ElectroInk-Silver-Beer_22.jpg");
INSERT INTO `wp_postmeta` VALUES("17089", "82678", "url_article", "http://www.packagingnews.com.au/footer/terms-and-conditions");
INSERT INTO `wp_postmeta` VALUES("17090", "82678", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("17091", "82679", "url_article", "http://www.packagingnews.com.au/equipment");
INSERT INTO `wp_postmeta` VALUES("17092", "82679", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17093", "82679", "url_picture", "http://yaffa-cdn.s3.amazonaws.com/yaffadsp/images/dspArticle/featureImage/RA_SmartManufacturingStandard2.jpeg");
INSERT INTO `wp_postmeta` VALUES("17094", "82680", "url_article", "http://www.packagingnews.com.au/news/ojifs-smashes-opening-of-new-72m-cardboard-factory");
INSERT INTO `wp_postmeta` VALUES("17095", "82680", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("17096", "82680", "url_picture", "http://www.packagingnews.com.au/news/&#x2f;&#x2f;yaffa-cdn.s3.amazonaws.com&#x2f;yaffadsp&#x2f;images&#x2f;dmImage&#x2f;StandardImage&#x2f;IMG_61642.JPG");
INSERT INTO `wp_postmeta` VALUES("17097", "82681", "url_article", "http://www.packagingnews.com.au/design");
INSERT INTO `wp_postmeta` VALUES("17098", "82681", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17099", "82682", "url_article", "http://www.packagingnews.com.au/news/fears-china-ban-could-cut-australia-s-recycling-rates");
INSERT INTO `wp_postmeta` VALUES("17100", "82682", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("17101", "82682", "url_picture", "http://www.packagingnews.com.au/news/&#x2f;&#x2f;yaffa-cdn.s3.amazonaws.com&#x2f;yaffadsp&#x2f;images&#x2f;dmImage&#x2f;StandardImage&#x2f;recycling-ban2.jpg");
INSERT INTO `wp_postmeta` VALUES("17102", "82683", "url_article", "http://www.packagingnews.com.au/news/industry-doyen-harry-lovell-honoured-with-lifetime-achievement-award");
INSERT INTO `wp_postmeta` VALUES("17103", "82683", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17104", "82683", "url_picture", "http://www.packagingnews.com.au/news/&#x2f;&#x2f;yaffa-cdn.s3.amazonaws.com&#x2f;yaffadsp&#x2f;images&#x2f;dmImage&#x2f;StandardImage&#x2f;HarryLovell2.jpg");
INSERT INTO `wp_postmeta` VALUES("17105", "82684", "url_article", "http://www.packagingnews.com.au/foodpro");
INSERT INTO `wp_postmeta` VALUES("17106", "82684", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17107", "82685", "url_article", "https://www.foodsafetymagazine.com/categories/management-category/training");
INSERT INTO `wp_postmeta` VALUES("17108", "82685", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("17109", "82686", "url_article", "http://www.packagingnews.com.au/events/latest-events");
INSERT INTO `wp_postmeta` VALUES("17110", "82686", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17111", "82687", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/381na1_en.pdf");
INSERT INTO `wp_postmeta` VALUES("17112", "82687", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17113", "82688", "url_article", "https://www.foodsafetymagazine.com/categories/process-control-category/intervention-controls");
INSERT INTO `wp_postmeta` VALUES("17114", "82688", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("17115", "82689", "url_article", "https://www.foodsafetymagazine.com/categories/regulatory-category/fda");
INSERT INTO `wp_postmeta` VALUES("17116", "82689", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("17117", "82690", "url_article", "https://www.foodsafetymagazine.com/categories/regulatory-category/usda");
INSERT INTO `wp_postmeta` VALUES("17118", "82690", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("17119", "82691", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/369na3_en.pdf");
INSERT INTO `wp_postmeta` VALUES("17120", "82691", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17121", "82692", "url_article", "https://www.foodsafetymagazine.com/categories/testing-and-analysis-category/testing-chemical");
INSERT INTO `wp_postmeta` VALUES("17122", "82692", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("17123", "82693", "url_article", "https://www.foodsafetymagazine.com/enewsletter/warning-temporary-prop-65-safe-harbor-for-bpa-exposures-from-canned-and-bottled-foods-and-beverages-has-expired/");
INSERT INTO `wp_postmeta` VALUES("17124", "82693", "interes", "15");
INSERT INTO `wp_postmeta` VALUES("17125", "82694", "url_article", "https://www.foodsafetymagazine.com/categories/supply-chain-category/temperature-control-cold-chain");
INSERT INTO `wp_postmeta` VALUES("17126", "82694", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("17127", "82695", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/363na5_en.pdf");
INSERT INTO `wp_postmeta` VALUES("17128", "82695", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17129", "82696", "url_article", "https://www.foodsafetymagazine.com/categories/sanitation-category/cleaners-sanitizers");
INSERT INTO `wp_postmeta` VALUES("17130", "82696", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("17131", "82697", "url_article", "http://www.plastico.com/temas/En-Colombia,-el-reciclaje-de-PET-botella-a-botella-tiene-futuro+3089010");
INSERT INTO `wp_postmeta` VALUES("17132", "82697", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("17133", "82697", "url_picture", "http://www.plastico.com/documenta/imagenes/3095314/Paola-Giraldo-Jaime-Andres-Giraldo-y-jaime-Giraldo-Lopez-directivos-de-Aproplast-p1.jpg");
INSERT INTO `wp_postmeta` VALUES("17134", "82698", "url_article", "http://www.plastico.com/temas/Cinco-tendencias-de-envases-para-el-2018+124260");
INSERT INTO `wp_postmeta` VALUES("17135", "82698", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("17136", "82698", "url_picture", "http://www.plastico.com/documenta/imagenes/130754/envases-gr.jpg");
INSERT INTO `wp_postmeta` VALUES("17137", "82699", "url_article", "http://www.plastico.com/temas/Bioplastico-mexicano-hecho-con-agave+123214?tema=3691000");
INSERT INTO `wp_postmeta` VALUES("17138", "82699", "interes", "19");
INSERT INTO `wp_postmeta` VALUES("17139", "82699", "url_picture", "http://www.plastico.com/documenta/imagenes/129707/bioplasticos-biodegradables-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("17140", "82700", "url_article", "http://www.plastico.com/temas/Estudiantes-desarrollan-una-alternativa-ecologica-para-empaque+124128?tema=3691000");
INSERT INTO `wp_postmeta` VALUES("17141", "82700", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("17142", "82700", "url_picture", "http://www.plastico.com/documenta/imagenes/130622/Proyecto-Biotecno-biopelicula-a-partir-de-almidon-de-avena-P.jpg");
INSERT INTO `wp_postmeta` VALUES("17143", "82701", "url_article", "http://www.plastico.com/temas/Sukano-prepara-la-proxima-generacion-de-pitillos-bioplasticos+121838?tema=3690000");
INSERT INTO `wp_postmeta` VALUES("17144", "82701", "interes", "21");
INSERT INTO `wp_postmeta` VALUES("17145", "82701", "url_picture", "http://www.plastico.com/documenta/imagenes/128325/Sukano-pitillos-1p.jpg");
INSERT INTO `wp_postmeta` VALUES("17146", "82702", "url_article", "http://www.plastico.com/blogs/Legislacion-europea-sobre-bolsas-plasticas+96843");
INSERT INTO `wp_postmeta` VALUES("17147", "82702", "interes", "16");
INSERT INTO `wp_postmeta` VALUES("17148", "82702", "url_picture", "http://www.plastico.com/documenta/imagenes/101309/Michael-Thielen.jpg");
INSERT INTO `wp_postmeta` VALUES("17149", "82703", "url_article", "http://www.plastico.com/temas/Bioplasticos-y-materiales-renovables?caso=Productos&pagina=1");
INSERT INTO `wp_postmeta` VALUES("17150", "82703", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("17151", "82704", "url_article", "http://www.plastico.com/temas/Rilsan-HT,-termoplastico-flexiblepara-reemplazar-metal-y-caucho+107537?tema=3691000");
INSERT INTO `wp_postmeta` VALUES("17152", "82704", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17153", "82704", "url_picture", "http://www.plastico.com/documenta/imagenes/114015/Termoplastico-flexible-Rilsan-HT-para-reemplazar-metal-y-caucho-de-Arkema-PW.jpg");
INSERT INTO `wp_postmeta` VALUES("17154", "82705", "url_article", "http://www.plastico.com/temas/Eastman-presenta-TREVA,-novedoso-adelanto-en-ingenieria-bioplastica+120112?tema=3691000");
INSERT INTO `wp_postmeta` VALUES("17155", "82705", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("17156", "82705", "url_picture", "http://www.plastico.com/documenta/imagenes/126583/Eastman-presenta-TREVA-novedoso-adelanto-en-ingenieria-bioplastica-P.jpg");
INSERT INTO `wp_postmeta` VALUES("17157", "82706", "url_article", "http://www.plastico.com/asociaciones/AIMPLAS+94960");
INSERT INTO `wp_postmeta` VALUES("17158", "82706", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("17159", "82706", "url_picture", "http://www.plastico.com/documenta/imagenes/101332/AIMPLAS.jpg");
INSERT INTO `wp_postmeta` VALUES("17160", "82707", "url_article", "http://www.plastico.com/temas/Perspectivas-2018-para-la-industria-latinoamericana-del-envase+124058");
INSERT INTO `wp_postmeta` VALUES("17161", "82707", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17162", "82707", "url_picture", "http://www.plastico.com/documenta/imagenes/130552/Perspectivas-2018-para-la-industria-latinoamericana-del-envase-AMP.jpg");
INSERT INTO `wp_postmeta` VALUES("17163", "82708", "url_article", "https://www.foodsafetymagazine.com/news/industry-weighs-in-on-listeria-monocytogenes-and-ag-water-regulations/");
INSERT INTO `wp_postmeta` VALUES("17164", "82708", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("17165", "82709", "url_article", "http://www.plastico.com/temas/Estudiante-crea-blocks-para-construccion-hechos-de-basura-plastica+124156?tema=3691000");
INSERT INTO `wp_postmeta` VALUES("17166", "82709", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("17167", "82709", "url_picture", "http://www.plastico.com/documenta/imagenes/130650/biopelicula-regeneracional-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("17168", "82710", "url_article", "http://www.plastico.com/temas/Anipac-impulsa-norma-para-plasticos-biobasados+124141?tema=3691000");
INSERT INTO `wp_postmeta` VALUES("17169", "82710", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("17170", "82710", "url_picture", "http://www.plastico.com/documenta/imagenes/130635/Anipac-impulsa-norma-para-plasticos-biobasados-P.jpg");
INSERT INTO `wp_postmeta` VALUES("17171", "82711", "url_article", "http://www.plastico.com/temas/Tecnologico-de-Monterrey-desarrolla-biopelicula-con-citricos+123208?tema=3691000");
INSERT INTO `wp_postmeta` VALUES("17172", "82711", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("17173", "82711", "url_picture", "http://www.plastico.com/documenta/imagenes/129701/empaques-biodegradables-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("17174", "82712", "url_article", "http://www.plastico.com/temas/Como-solucionar-problemas-en-piezas-moldeadas-por-inyeccion+100321");
INSERT INTO `wp_postmeta` VALUES("17175", "82712", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("17176", "82712", "url_picture", "http://www.plastico.com/documenta/imagenes/106720/Como-solucionar-problemas-en-piezas-moldeadas-por-inyeccion-PQ.jpg");
INSERT INTO `wp_postmeta` VALUES("17177", "82713", "url_article", "http://www.plastico.com/temas/Nuevos-compuestos-Bio-Flex-Blends-para-pelicula-y-envases+118902?tema=3691000");
INSERT INTO `wp_postmeta` VALUES("17178", "82713", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("17179", "82713", "url_picture", "http://www.plastico.com/documenta/imagenes/125373/Nuevos-compuestos-Bio-Flex-Blends-para-pelicula-y-envases-de-FKuR-P.jpg");
INSERT INTO `wp_postmeta` VALUES("17180", "82714", "url_article", "http://www.plastico.com/");
INSERT INTO `wp_postmeta` VALUES("17181", "82714", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17182", "82714", "url_picture", "http://www.plastico.com/documenta/imagenes/130117/extrusora-para-termoformado-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("17183", "82715", "url_article", "http://www.plastico.com/temas/Mercados,-Empaques");
INSERT INTO `wp_postmeta` VALUES("17184", "82715", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17185", "82716", "url_article", "http://www.plastico.com/temas/Bioplasticos-y-materiales-renovables?caso=Noticias-y-articulos&pagina=1");
INSERT INTO `wp_postmeta` VALUES("17186", "82716", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("17187", "82717", "url_article", "http://www.plastico.com/temas/Botellas-plasticas-compostables,-un-respiro-para-el-planeta+124095?tema=3691000");
INSERT INTO `wp_postmeta` VALUES("17188", "82717", "interes", "18");
INSERT INTO `wp_postmeta` VALUES("17189", "82717", "url_picture", "http://www.plastico.com/documenta/contenido/130589/botella-completamente-compostable-TGBC-Cosalco-Andina-Pack-pq.fw.png");
INSERT INTO `wp_postmeta` VALUES("17190", "82718", "url_article", "http://www.plastico.com/temas/European-Bioplastics-acogio-la-Estrategia-Europea-para-los-Plasticos+123748?tema=3691000");
INSERT INTO `wp_postmeta` VALUES("17191", "82718", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("17192", "82718", "url_picture", "http://www.plastico.com/documenta/imagenes/130242/Estrategia-Europea-de-Plasticos-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("17193", "82719", "url_article", "http://www.plastico.com/temas/Cumbre-Envases-2018");
INSERT INTO `wp_postmeta` VALUES("17194", "82719", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17195", "82720", "url_article", "http://www.plastico.com/temas/Reciclaje-de-PET-para-fabricacion-de-botellas+3034432");
INSERT INTO `wp_postmeta` VALUES("17196", "82720", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("17197", "82720", "url_picture", "http://www.plastico.com/documenta/imagenes/3040262/empresa-alemana-Bad-Bramba-recicla-sus-envases-por-el-proceso-botella-p1.jpg");
INSERT INTO `wp_postmeta` VALUES("17198", "82721", "url_article", "http://www.plastico.com/eventos/NPE-2018+110395");
INSERT INTO `wp_postmeta` VALUES("17199", "82721", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17200", "82721", "url_picture", "http://www.plastico.com:80/documenta/imagenes/116873/NPE2018Logo.jpg");
INSERT INTO `wp_postmeta` VALUES("17201", "82722", "url_article", "http://www.plastico.com/temas/Tecnologias-de-soplado-para-fabricacion-de-envases-con-materias-primas-renovables+122612?tema=3691000");
INSERT INTO `wp_postmeta` VALUES("17202", "82722", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("17203", "82722", "url_picture", "http://www.plastico.com/documenta/imagenes/129100/bekum-plastimagen-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("17204", "82723", "url_article", "https://www.foodsafetymagazine.com/magazine-archive1/junejuly-2005/7-simple-rules-for-effective-and-hygienic-dry-goods-storage");
INSERT INTO `wp_postmeta` VALUES("17205", "82723", "interes", "24");
INSERT INTO `wp_postmeta` VALUES("17206", "82724", "url_article", "https://www.foodsafetymagazine.com/news/various-dog-foods-recalled-for-salmonella-listeria-and-the-presence-of-illegal-drug/");
INSERT INTO `wp_postmeta` VALUES("17207", "82724", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("17208", "82725", "url_article", "https://www.foodsafetymagazine.com/enewsletter/a-closer-look-at-the-food-safety-and-quality-issues-associated-with-high-protein-snack-bars/");
INSERT INTO `wp_postmeta` VALUES("17209", "82725", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("17210", "82726", "url_article", "http://www.parksideflex.com/parkside-employees-celebrate-10-year-anniversary/");
INSERT INTO `wp_postmeta` VALUES("17211", "82726", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("17212", "82727", "url_article", "http://www.parksideflex.com/parkside-speciality-packaging-malaysia-food-drink/");
INSERT INTO `wp_postmeta` VALUES("17213", "82727", "interes", "16");
INSERT INTO `wp_postmeta` VALUES("17214", "82727", "url_picture", "http://www.parksideflex.com/wp-content/uploads/2016/05/Asparagus-Steam-Bag2.jpg");
INSERT INTO `wp_postmeta` VALUES("17215", "82728", "url_article", "http://www.parksideflex.com/parkside-targets-conveinence-sector-usa-reclosable-lidding-films-snack-pots/");
INSERT INTO `wp_postmeta` VALUES("17216", "82728", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("17217", "82728", "url_picture", "http://www.parksideflex.com/wp-content/uploads/2017/06/Handy-Candy-3-.jpg");
INSERT INTO `wp_postmeta` VALUES("17218", "82729", "url_article", "http://www.parksideflex.com/");
INSERT INTO `wp_postmeta` VALUES("17219", "82729", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("17220", "82729", "url_picture", "http://www.parksideflex.com/wp-content/uploads/2015/09/sign-up-sticker.png");
INSERT INTO `wp_postmeta` VALUES("17221", "82730", "url_article", "http://www.parksideflex.com/parkside-launch-new-app-technology-for-pack-connectivity/");
INSERT INTO `wp_postmeta` VALUES("17222", "82730", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("17223", "82731", "url_article", "http://www.parksideflex.com/parkside-launches-new-website-to-support-enhanced-business-strategy/");
INSERT INTO `wp_postmeta` VALUES("17224", "82731", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("17225", "82732", "url_article", "http://www.parksideflex.com/parkside-triumph-innovation-brings-success/");
INSERT INTO `wp_postmeta` VALUES("17226", "82732", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("17227", "82732", "url_picture", "http://www.parksideflex.com/wp-content/uploads/2016/12/Seabrooks-2016-Press.jpg");
INSERT INTO `wp_postmeta` VALUES("17228", "82733", "url_article", "http://www.parksideflex.com");
INSERT INTO `wp_postmeta` VALUES("17229", "82733", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("17230", "82733", "url_picture", "http://www.parksideflex.com/wp-content/uploads/2015/09/sign-up-sticker.png");
INSERT INTO `wp_postmeta` VALUES("17231", "82734", "url_article", "http://www.parksideflex.com/packaging-europe-feature-compostable-bag/");
INSERT INTO `wp_postmeta` VALUES("17232", "82734", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("17233", "82735", "url_article", "http://www.parksideflex.com/our-markets/");
INSERT INTO `wp_postmeta` VALUES("17234", "82735", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17235", "82736", "url_article", "http://www.parksideflex.com/parkside-present-fplma-technical-forum-2017-australia/");
INSERT INTO `wp_postmeta` VALUES("17236", "82736", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("17237", "82736", "url_picture", "http://www.parksideflex.com/wp-content/uploads/2017/10/DI4UfuoUQAE4_Fi.jpg");
INSERT INTO `wp_postmeta` VALUES("17238", "82737", "url_article", "http://www.parksideflex.com/burtons-biscuits-launches-new-cadbury-chocolate-fingers-snack-pack-parkside-innovation/");
INSERT INTO `wp_postmeta` VALUES("17239", "82737", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("17240", "82737", "url_picture", "http://www.parksideflex.com/wp-content/uploads/2016/06/Burtons-1-SM.jpg");
INSERT INTO `wp_postmeta` VALUES("17241", "82738", "url_article", "http://www.parksideflex.com/parkside-sweeps-board-2018-starpack-awards/");
INSERT INTO `wp_postmeta` VALUES("17242", "82738", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("17243", "82738", "url_picture", "http://www.parksideflex.com/wp-content/uploads/2017/06/North-Coast-Seafood-Reclose-Lidding.jpg");
INSERT INTO `wp_postmeta` VALUES("17244", "82739", "url_article", "http://www.parksideflex.com/parkside-extends-support-clean-living-market-compostable-pack-nobo/");
INSERT INTO `wp_postmeta` VALUES("17245", "82739", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("17246", "82739", "url_picture", "http://www.parksideflex.com/wp-content/uploads/2017/12/Nobo-1.jpg");
INSERT INTO `wp_postmeta` VALUES("17247", "82740", "url_article", "http://www.parksideflex.com/sale-terms/");
INSERT INTO `wp_postmeta` VALUES("17248", "82740", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("17249", "82741", "url_article", "http://www.parksideflex.com/parkside-develops-active-packaging-eliminate-bacteria/");
INSERT INTO `wp_postmeta` VALUES("17250", "82741", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("17251", "82741", "url_picture", "http://www.parksideflex.com/wp-content/uploads/2016/07/Raw-chicken-250x174.jpg");
INSERT INTO `wp_postmeta` VALUES("17252", "82742", "url_article", "http://www.parksideflex.com/parkscribe-success-uk-packaging-awards/");
INSERT INTO `wp_postmeta` VALUES("17253", "82742", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17254", "82742", "url_picture", "http://www.parksideflex.com/wp-content/uploads/2016/05/Asparagus-Steam-Bag2.jpg");
INSERT INTO `wp_postmeta` VALUES("17255", "82743", "url_article", "http://www.parksideflex.com/parkside-makes-investment-in-malaysia/");
INSERT INTO `wp_postmeta` VALUES("17256", "82743", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("17257", "82743", "url_picture", "http://www.parksideflex.com/wp-content/uploads/2016/03/JohnTaylor-700x1052.jpg");
INSERT INTO `wp_postmeta` VALUES("17258", "82744", "url_article", "http://www.parksideflex.com/parkside-delivers-ultra-hd-flexo-print-quality-bellissima-dms/");
INSERT INTO `wp_postmeta` VALUES("17259", "82744", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17260", "82744", "url_picture", "http://www.parksideflex.com/wp-content/uploads/2017/09/new-Eyeglass-CMYK.jpg");
INSERT INTO `wp_postmeta` VALUES("17261", "82745", "url_article", "http://www.parksideflex.com/parkside-scoops-two-innovation-awards/");
INSERT INTO `wp_postmeta` VALUES("17262", "82745", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("17263", "82746", "url_article", "http://www.parksideflex.com/media-center/contact-us");
INSERT INTO `wp_postmeta` VALUES("17264", "82746", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17265", "82747", "url_article", "http://www.parksideflex.com/parkside-linpac-collaborate-enhance-shelf-appeal-linpac-vsp-evolve/");
INSERT INTO `wp_postmeta` VALUES("17266", "82747", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("17267", "82747", "url_picture", "http://www.parksideflex.com/wp-content/uploads/2016/11/VSP-Grass-Tray.jpg");
INSERT INTO `wp_postmeta` VALUES("17268", "82748", "url_article", "http://www.parksideflex.com/come-join-parkside-picnic-packaging-innovations-2017/");
INSERT INTO `wp_postmeta` VALUES("17269", "82748", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("17270", "82748", "url_picture", "http://www.parksideflex.com/wp-content/uploads/2017/01/160520-PARK-PACK-INNOV-STAND-CONCEPT-RGB.jpg");
INSERT INTO `wp_postmeta` VALUES("17271", "82749", "url_article", "http://www.parksideflex.com/parkside-makes-two-appointments-as-company-looks-to-challenge-new-markets/");
INSERT INTO `wp_postmeta` VALUES("17272", "82749", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("17273", "82749", "url_picture", "http://www.parksideflex.com/wp-content/uploads/2016/01/Vicki-Rayment-FD-2015-SMall1.jpg");
INSERT INTO `wp_postmeta` VALUES("17274", "82750", "url_article", "http://www.parksideflex.com/parkside-sandwich-wrap-packaging-takes-gold-at-efia-print-awards-2016/");
INSERT INTO `wp_postmeta` VALUES("17275", "82750", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("17276", "82750", "url_picture", "http://www.parksideflex.com/wp-content/uploads/2016/03/Nick-Smith-700x467.jpg");
INSERT INTO `wp_postmeta` VALUES("17277", "82751", "url_article", "http://www.parksideflex.com/parkside-creates-home-compostable-pack/");
INSERT INTO `wp_postmeta` VALUES("17278", "82751", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("17279", "82751", "url_picture", "http://www.parksideflex.com/wp-content/uploads/2017/02/Yumpa-snack-bar1-sml.png");
INSERT INTO `wp_postmeta` VALUES("17280", "82752", "url_article", "http://www.parksideflex.com/parkside-packs-convenience/");
INSERT INTO `wp_postmeta` VALUES("17281", "82752", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("17282", "82752", "url_picture", "http://www.parksideflex.com/wp-content/uploads/2016/11/TPH-LIVE_logo_food1.jpg");
INSERT INTO `wp_postmeta` VALUES("17283", "82753", "url_article", "http://www.parksideflex.com/contact-us/");
INSERT INTO `wp_postmeta` VALUES("17284", "82753", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17285", "82754", "url_article", "http://www.parksideflex.com/parkside-business-growth-extends-international-profile/");
INSERT INTO `wp_postmeta` VALUES("17286", "82754", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("17287", "82754", "url_picture", "http://www.parksideflex.com/wp-content/uploads/2017/08/Parkscribe-laser-technology-image.jpg");
INSERT INTO `wp_postmeta` VALUES("17288", "82755", "url_article", "http://www.parksideflex.com/press-releases/");
INSERT INTO `wp_postmeta` VALUES("17289", "82755", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17290", "82755", "url_picture", "http://www.parksideflex.com/wp-content/uploads/bfi_thumb/North-Coast-Seafood-Reclose-Lidding-na0awikkz6ymdjlp5q7kwkhi8safendhb7v8nqd9qa.jpg");
INSERT INTO `wp_postmeta` VALUES("17291", "82756", "url_article", "http://www.parksideflex.com/parkside-new-appointment/");
INSERT INTO `wp_postmeta` VALUES("17292", "82756", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17293", "82757", "url_article", "http://www.parksideflex.com/parkside-wins-innovation-award-reclosable-crisp-bag/");
INSERT INTO `wp_postmeta` VALUES("17294", "82757", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("17295", "82757", "url_picture", "http://www.parksideflex.com/wp-content/uploads/2017/07/Parkside-Innovation_Awards_2017.jpg");
INSERT INTO `wp_postmeta` VALUES("17296", "82758", "url_article", "http://www.parksideflex.com/converting-today-adhesive-feature/");
INSERT INTO `wp_postmeta` VALUES("17297", "82758", "interes", "17");
INSERT INTO `wp_postmeta` VALUES("17298", "82759", "url_article", "http://www.parksideflex.com/new-parkside-appointment-furthers-focus-retail-consumer-value/");
INSERT INTO `wp_postmeta` VALUES("17299", "82759", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("17300", "82759", "url_picture", "http://www.parksideflex.com/wp-content/uploads/2016/11/PhilODriscoll_press.jpg");
INSERT INTO `wp_postmeta` VALUES("17301", "82760", "url_article", "https://www.foodsafetymagazine.com/categories/management-category/management-international");
INSERT INTO `wp_postmeta` VALUES("17302", "82760", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("17303", "82761", "url_article", "http://www.parksideflex.com/parkside-invests-state-art-new-product-development-laboratory-suite/");
INSERT INTO `wp_postmeta` VALUES("17304", "82761", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17305", "82761", "url_picture", "http://www.parksideflex.com/wp-content/uploads/2015/11/creative-suite-RGB-700x538.jpg");
INSERT INTO `wp_postmeta` VALUES("17306", "82762", "url_article", "https://www.foodsafetymagazine.com/categories/contamination-control-category/contamination-control");
INSERT INTO `wp_postmeta` VALUES("17307", "82762", "interes", "16");
INSERT INTO `wp_postmeta` VALUES("17308", "82763", "url_article", "https://www.foodsafetymagazine.com/magazine-archive1/augustseptember-2012/supplier-management-six-steps-to-selecting-the-right-supplier");
INSERT INTO `wp_postmeta` VALUES("17309", "82763", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("17310", "82764", "url_article", "https://www.foodsafetymagazine.com/categories/food-types-category/beverages");
INSERT INTO `wp_postmeta` VALUES("17311", "82764", "interes", "18");
INSERT INTO `wp_postmeta` VALUES("17312", "82765", "url_article", "https://www.foodsafetymagazine.com/categories/sanitation-category/biofilm-control");
INSERT INTO `wp_postmeta` VALUES("17313", "82765", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("17314", "82766", "url_article", "https://www.foodsafetymagazine.com/categories/food-types-category/produce");
INSERT INTO `wp_postmeta` VALUES("17315", "82766", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("17316", "82767", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/350na4rss_en.pdf");
INSERT INTO `wp_postmeta` VALUES("17317", "82767", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17318", "82768", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/344na6rss_en.pdf");
INSERT INTO `wp_postmeta` VALUES("17319", "82768", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17320", "82769", "url_article", "https://www.foodsafetymagazine.com/categories/process-control-category/processing-technologies");
INSERT INTO `wp_postmeta` VALUES("17321", "82769", "interes", "15");
INSERT INTO `wp_postmeta` VALUES("17322", "82770", "url_article", "http://www.plastico.com/temas/Reciclaje-interno-con-Polystar,-mas-facil,-imposible+122304?tema=3700000");
INSERT INTO `wp_postmeta` VALUES("17323", "82770", "interes", "14");
INSERT INTO `wp_postmeta` VALUES("17324", "82770", "url_picture", "http://www.plastico.com/documenta/imagenes/128791/vHDR-Auto-1.jpg");
INSERT INTO `wp_postmeta` VALUES("17325", "82771", "url_article", "http://www.plastico.com/temas/rPET-PP*STAR,-bolsa-fabricada-100-con-granulos-de-la-molienda-de-botellas-PET+123815?tema=3700000");
INSERT INTO `wp_postmeta` VALUES("17326", "82771", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("17327", "82771", "url_picture", "http://www.plastico.com/documenta/imagenes/130309/rPET-PPSTAR-bolsa-de-plegado-fabricada-con-granulos-de-la-molienda-de-botellas-PET-Starlinger-P.jpg");
INSERT INTO `wp_postmeta` VALUES("17328", "82772", "url_article", "http://www.plastico.com/temas/Anipac-impulsa-norma-para-plasticos-biobasados+124141?tema=3700000");
INSERT INTO `wp_postmeta` VALUES("17329", "82772", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("17330", "82772", "url_picture", "http://www.plastico.com/documenta/imagenes/130635/Anipac-impulsa-norma-para-plasticos-biobasados-P.jpg");
INSERT INTO `wp_postmeta` VALUES("17331", "82773", "url_article", "http://www.plastico.com/blogs/Tendencias-en-la-fabricacion-de-envases-plasticos+120008");
INSERT INTO `wp_postmeta` VALUES("17332", "82773", "interes", "17");
INSERT INTO `wp_postmeta` VALUES("17333", "82773", "url_picture", "http://www.plastico.com/documenta/imagenes/126479/play-revista-junio-julio-2017-TP.jpg");
INSERT INTO `wp_postmeta` VALUES("17334", "82774", "url_article", "http://www.plastico.com/temas/Sukano-prepara-la-proxima-generacion-de-pitillos-bioplasticos+121838?tema=3700000");
INSERT INTO `wp_postmeta` VALUES("17335", "82774", "interes", "21");
INSERT INTO `wp_postmeta` VALUES("17336", "82774", "url_picture", "http://www.plastico.com/documenta/imagenes/128325/Sukano-pitillos-1p.jpg");
INSERT INTO `wp_postmeta` VALUES("17337", "82775", "url_article", "http://www.plastico.com/guia-de-proveedores/empresas/Polystar-Taiwan+513916?showroom=94778");
INSERT INTO `wp_postmeta` VALUES("17338", "82775", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17339", "82775", "url_picture", "http://www.plastico.com:80/documenta/imagenes/101150/logo-polystar-catalogos1.jpg");
INSERT INTO `wp_postmeta` VALUES("17340", "82776", "url_article", "http://www.plastico.com/temas/Filtros-automaticos-para-reciclaje,-de-Fimic,-en-Plastimagen-2017+122759?tema=3700000");
INSERT INTO `wp_postmeta` VALUES("17341", "82776", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("17342", "82776", "url_picture", "http://www.plastico.com/documenta/imagenes/129247/Filtros-automaticos-para-reciclaje-de-Fimic-en-Plastimagen-2017-P-2.jpg");
INSERT INTO `wp_postmeta` VALUES("17343", "82777", "url_article", "http://www.plastico.com/eventos/Expo-Plasticos-2018+121937");
INSERT INTO `wp_postmeta` VALUES("17344", "82777", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17345", "82777", "url_picture", "http://www.plastico.com:80/documenta/imagenes/128424/logo-expoplasticos.jpg");
INSERT INTO `wp_postmeta` VALUES("17346", "82778", "url_article", "http://www.plastico.com/blogs/Las-dos-caras-del-plastico+113006");
INSERT INTO `wp_postmeta` VALUES("17347", "82778", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("17348", "82778", "url_picture", "http://www.plastico.com/documenta/imagenes/101304/Laura-Florez-Sastre.jpg");
INSERT INTO `wp_postmeta` VALUES("17349", "82779", "url_article", "http://www.plastico.com/temas/STARextruder,-procesado-de-PET-postconsumo-procedente-de-hojuelas-de-botellas-para-uso-alimentario+122615?tema=3700000");
INSERT INTO `wp_postmeta` VALUES("17350", "82779", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("17351", "82779", "url_picture", "http://www.plastico.com/documenta/imagenes/129103/extrusoras-plastimagen-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("17352", "82780", "url_article", "http://www.plastico.com/guia-de-proveedores/empresas/Kung-Hsing-Plastic-Machinery-Co,-Ltd+277891?showroom=3086826");
INSERT INTO `wp_postmeta` VALUES("17353", "82780", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("17354", "82780", "url_picture", "http://www.plastico.com:80/documenta/imagenes/3093130/Kung-Hsing-Plastic-Machinery-Co-Logo.jpg");
INSERT INTO `wp_postmeta` VALUES("17355", "82781", "url_article", "http://www.plastico.com/temas/Plastimagen-Mexico-2017,-el-evento-mas-importante-de-la-industria-del-plastico-en-Latinoamerica+121920?tema=3700000");
INSERT INTO `wp_postmeta` VALUES("17356", "82781", "interes", "17");
INSERT INTO `wp_postmeta` VALUES("17357", "82781", "url_picture", "http://www.plastico.com/documenta/imagenes/128407/Platimagen-mexico-1p.jpg");
INSERT INTO `wp_postmeta` VALUES("17358", "82782", "url_article", "http://www.plastico.com/temas/Primera-de-las-dos-lineas-de-reciclado-de-Starlinger-fue-puesta-en-funcionamiento-en-Avangard-Innovative+124492?tema=3700000");
INSERT INTO `wp_postmeta` VALUES("17359", "82782", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("17360", "82782", "url_picture", "http://www.plastico.com/documenta/imagenes/130986/linea-de-reciclado-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("17361", "82783", "url_article", "http://www.plastico.com/temas/Procter-y-Gamble-lanza-una-nueva-botella-fabricada-100-de-plastico-reciclado+123716?tema=3700000");
INSERT INTO `wp_postmeta` VALUES("17362", "82783", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("17363", "82783", "url_picture", "http://www.plastico.com/documenta/imagenes/130210/Fairy-Ocean-Plastic-botellas-plastica-de-Procter-and-Gamble-fabricada-de-plastico-reciclado-del-oceano-P.jpg");
INSERT INTO `wp_postmeta` VALUES("17364", "82784", "url_article", "http://www.plastico.com/temas/European-Bioplastics-acogio-la-Estrategia-Europea-para-los-Plasticos+123748?tema=3700000");
INSERT INTO `wp_postmeta` VALUES("17365", "82784", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("17366", "82784", "url_picture", "http://www.plastico.com/documenta/imagenes/130242/Estrategia-Europea-de-Plasticos-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("17367", "82785", "url_article", "http://www.plastico.com/temas/Asociacion-a-largo-plazo-en-Rusia,-productor-con-63-maquinas-Polystar+123938?tema=3700000");
INSERT INTO `wp_postmeta` VALUES("17368", "82785", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("17369", "82785", "url_picture", "http://www.plastico.com/documenta/imagenes/130432/Tonar-1p.jpg");
INSERT INTO `wp_postmeta` VALUES("17370", "82786", "url_article", "http://www.plastico.com/blogs/Usar-plastico,-una-necesidad-para-preservar-el-planeta+120852");
INSERT INTO `wp_postmeta` VALUES("17371", "82786", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("17372", "82786", "url_picture", "http://www.plastico.com/documenta/imagenes/117928/Juan-Carlos-Oberndorfer.jpg");
INSERT INTO `wp_postmeta` VALUES("17373", "82787", "url_article", "http://www.plastico.com/temas/Estudiante-crea-blocks-para-construccion-hechos-de-basura-plastica+124156?tema=3700000");
INSERT INTO `wp_postmeta` VALUES("17374", "82787", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("17375", "82787", "url_picture", "http://www.plastico.com/documenta/imagenes/130650/biopelicula-regeneracional-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("17376", "82788", "url_article", "http://www.plastico.com/temas/Botellas-plasticas-compostables,-un-respiro-para-el-planeta+124095?tema=3700000");
INSERT INTO `wp_postmeta` VALUES("17377", "82788", "interes", "18");
INSERT INTO `wp_postmeta` VALUES("17378", "82788", "url_picture", "http://www.plastico.com/documenta/contenido/130589/botella-completamente-compostable-TGBC-Cosalco-Andina-Pack-pq.fw.png");
INSERT INTO `wp_postmeta` VALUES("17379", "82789", "url_article", "https://www.npd.com/wps/portal/npd/us/news/press-releases/npd-highlights-the-evolution-of-play/");
INSERT INTO `wp_postmeta` VALUES("17380", "82789", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17381", "82790", "url_article", "http://www.plastico.com/temas/Styropor-MB,-con-balance-de-biomasa,-es-utilizado-por-primera-vez-en-empaques+124018?tema=3700000");
INSERT INTO `wp_postmeta` VALUES("17382", "82790", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("17383", "82790", "url_picture", "http://www.plastico.com/documenta/imagenes/130512/Schaumaplast-fabrica-envases-helado-con-Styropor-MB-de-Basf-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("17384", "82791", "url_article", "https://www.foodsafetymagazine.com/enewsletter/the-future-of-food-safety-for-the-foodservice-industry/");
INSERT INTO `wp_postmeta` VALUES("17385", "82791", "interes", "14");
INSERT INTO `wp_postmeta` VALUES("17386", "82792", "url_article", "https://www.foodsafetymagazine.com/enewsletter/medical-foods-insighte28099s-into-fdae28099s-interpretation-and-enforcement/");
INSERT INTO `wp_postmeta` VALUES("17387", "82792", "interes", "17");
INSERT INTO `wp_postmeta` VALUES("17388", "82793", "url_article", "https://www.packagingstrategies.com/articles/90288-demands-from-cpgs-push-packaging-machinery-growth");
INSERT INTO `wp_postmeta` VALUES("17389", "82793", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17390", "82794", "url_article", "https://www.foodsafetymagazine.com/magazine-archive1/februarymarch-2014/trends-and-solutions-in-combating-global-food-fraud");
INSERT INTO `wp_postmeta` VALUES("17391", "82794", "interes", "17");
INSERT INTO `wp_postmeta` VALUES("17392", "82795", "url_article", "https://www.packagingstrategies.com/articles/90277-poultry-packaging-market-to-grow-through-2022");
INSERT INTO `wp_postmeta` VALUES("17393", "82795", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17394", "82796", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/341na3rss_en.pdf");
INSERT INTO `wp_postmeta` VALUES("17395", "82796", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17396", "82797", "url_article", "https://www.packagingstrategies.com/articles/90275-registration-opens-for-ppc-spring-conference");
INSERT INTO `wp_postmeta` VALUES("17397", "82797", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("17398", "82798", "url_article", "https://www.packagingstrategies.com/articles/90271-enter-the-2018-ameristar-awards-competition");
INSERT INTO `wp_postmeta` VALUES("17399", "82798", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17400", "82799", "url_article", "https://www.npd.com/wps/portal/npd/us/news/press-releases/value-proposition-for-ultraviolet-services-increases-as-awareness-and-satisfaction-among-consumers-grows/");
INSERT INTO `wp_postmeta` VALUES("17401", "82799", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17402", "82800", "url_article", "https://www.packagingstrategies.com/articles/90251-liquid-pouch-packaging-to-reach-10-billion-by-2024");
INSERT INTO `wp_postmeta` VALUES("17403", "82800", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17404", "82801", "url_article", "https://www.arplastsl.com/noticia/El+Packaging+en+las+empresas+modernas+/243");
INSERT INTO `wp_postmeta` VALUES("17405", "82801", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("17406", "82801", "url_picture", "https://www.arplastsl.com/Catalogo/Item/243_Item/NOTICIA.jpg");
INSERT INTO `wp_postmeta` VALUES("17407", "82802", "url_article", "https://www.arplastsl.com/noticia/Clasificando+a+la+innovaci%C3%B3n+en+packaging/231");
INSERT INTO `wp_postmeta` VALUES("17408", "82802", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17409", "82802", "url_picture", "https://www.arplastsl.com/Catalogo/Item/231_Item/NOTICIA%2017-11-2017.jpg");
INSERT INTO `wp_postmeta` VALUES("17410", "82803", "url_article", "https://www.arplastsl.com/productos/Tubos/5/Tapas+Tubos+Ovalados/22");
INSERT INTO `wp_postmeta` VALUES("17411", "82803", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17412", "82804", "url_article", "https://www.arplastsl.com/productos/Blisters/1/Blisters+Jardiner%C3%ADa/84");
INSERT INTO `wp_postmeta` VALUES("17413", "82804", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17414", "82805", "url_article", "https://www.arplastsl.com/productos/Packaging+Sectores/9/Blisters+ortopedia/64");
INSERT INTO `wp_postmeta` VALUES("17415", "82805", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17416", "82806", "url_article", "https://www.arplastsl.com/productos/Expositores+y+Bandejas/4/Bol-Cap+NEW+/14");
INSERT INTO `wp_postmeta` VALUES("17417", "82806", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17418", "82807", "url_article", "https://www.arplastsl.com/productos/Expositores+y+Bandejas/4/Expositores+Cosm%C3%A9tica/18");
INSERT INTO `wp_postmeta` VALUES("17419", "82807", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17420", "82808", "url_article", "https://www.arplastsl.com/productos/Estuches/3/Estuches+Bebidas/13");
INSERT INTO `wp_postmeta` VALUES("17421", "82808", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17422", "82809", "url_article", "https://www.arplastsl.com/productos/Tubos/5/Tubos+ovalados+NEW+/21");
INSERT INTO `wp_postmeta` VALUES("17423", "82809", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17424", "82810", "url_article", "https://www.arplastsl.com/productos/Estuches/3/Estuches+Plegable+-+Tapa+Base+-+Baul/8");
INSERT INTO `wp_postmeta` VALUES("17425", "82810", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17426", "82811", "url_article", "https://www.arplastsl.com/productos/PLV+y+Muestrarios/6/Portanotas/28");
INSERT INTO `wp_postmeta` VALUES("17427", "82811", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17428", "82812", "url_article", "https://www.arplastsl.com/productos/Estuches/3/Estuche+PRISMA%2C+NEW+/6");
INSERT INTO `wp_postmeta` VALUES("17429", "82812", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17430", "82813", "url_article", "https://www.arplastsl.com/noticia/Por+qu%C3%A9+el+embalaje+importa+m%C3%A1s+que+nunca/241");
INSERT INTO `wp_postmeta` VALUES("17431", "82813", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17432", "82813", "url_picture", "https://www.arplastsl.com/Catalogo/Item/241_Item/NOTICIA.jpg");
INSERT INTO `wp_postmeta` VALUES("17433", "82814", "url_article", "https://www.arplastsl.com/productos/Estuches/8/-/0");
INSERT INTO `wp_postmeta` VALUES("17434", "82814", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17435", "82815", "url_article", "https://www.arplastsl.com/productos/Packaging+Sectores/9/Blisters+y+Displays+Bebidas/69");
INSERT INTO `wp_postmeta` VALUES("17436", "82815", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17437", "82816", "url_article", "https://www.arplastsl.com/noticia/Subvenci%C3%B3n+Digitalizaci%C3%B3n+de+Pyme+%28Digitaliza+-+CV%29/238");
INSERT INTO `wp_postmeta` VALUES("17438", "82816", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17439", "82816", "url_picture", "https://www.arplastsl.com/Catalogo/Item/238_Item/Publicidad%20Web%20ARPLAST%20media.jpg");
INSERT INTO `wp_postmeta` VALUES("17440", "82817", "url_article", "https://www.arplastsl.com/productos/Packaging+Sectores/9/Estuches+y+Tubos+Bebidas/68");
INSERT INTO `wp_postmeta` VALUES("17441", "82817", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17442", "82818", "url_article", "https://www.arplastsl.com/productos/PLV+y+Muestrarios/6/Portamenus/30");
INSERT INTO `wp_postmeta` VALUES("17443", "82818", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17444", "82819", "url_article", "https://www.arplastsl.com/productos/Blisters/1/Blister+manivelas/85");
INSERT INTO `wp_postmeta` VALUES("17445", "82819", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17446", "82820", "url_article", "https://www.arplastsl.com/productos/Termoconformados/7/Piezas+plv/38");
INSERT INTO `wp_postmeta` VALUES("17447", "82820", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17448", "82821", "url_article", "https://www.arplastsl.com/productos/Packaging+Sectores/9/Blisters+y+bandejas+bricolaje/54");
INSERT INTO `wp_postmeta` VALUES("17449", "82821", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17450", "82822", "url_article", "https://www.arplastsl.com/noticia/Ideas+para+convertir+el+embalaje+en+una+ventaja+competitiva+/232");
INSERT INTO `wp_postmeta` VALUES("17451", "82822", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17452", "82822", "url_picture", "https://www.arplastsl.com/Catalogo/Item/232_Item/Mini1507115019_coste_embalaje.jpg");
INSERT INTO `wp_postmeta` VALUES("17453", "82823", "url_article", "https://www.arplastsl.com/productos/Impresion+3D/11/-/0");
INSERT INTO `wp_postmeta` VALUES("17454", "82823", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17455", "82824", "url_article", "https://www.arplastsl.com/productos/Estuches/8/Estuches+Plegables+-+Tapa+y+Base/40");
INSERT INTO `wp_postmeta` VALUES("17456", "82824", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17457", "82825", "url_article", "https://www.arplastsl.com/productos/Packaging+Sectores/9/Tarrinas+Standards/70");
INSERT INTO `wp_postmeta` VALUES("17458", "82825", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17459", "82826", "url_article", "https://www.arplastsl.com/productos/Packaging+Sectores/9/-/0");
INSERT INTO `wp_postmeta` VALUES("17460", "82826", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17461", "82827", "url_article", "https://www.arplastsl.com/productos/Blisters/1/Blisters+autocierre/2");
INSERT INTO `wp_postmeta` VALUES("17462", "82827", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17463", "82828", "url_article", "https://www.arplastsl.com/productos/Ofertas+Packaging/13/Blisters/78");
INSERT INTO `wp_postmeta` VALUES("17464", "82828", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17465", "82829", "url_article", "https://www.arplastsl.com/productos/Tubos/5/-/0");
INSERT INTO `wp_postmeta` VALUES("17466", "82829", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17467", "82830", "url_article", "https://www.arplastsl.com/productos/Expositores+y+Bandejas/4/Bandejas+Ampollas+/16");
INSERT INTO `wp_postmeta` VALUES("17468", "82830", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17469", "82831", "url_article", "https://www.arplastsl.com/noticia/FERIA+PACKAGING+INNOVATIONS+2017/229");
INSERT INTO `wp_postmeta` VALUES("17470", "82831", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17471", "82831", "url_picture", "https://www.arplastsl.com/Catalogo/Item/229_Item/FERIA%20(17).jpg");
INSERT INTO `wp_postmeta` VALUES("17472", "82832", "url_article", "https://www.arplastsl.com/productos/Expositores+y+Bandejas/4/Expositores+Autoservicio/20");
INSERT INTO `wp_postmeta` VALUES("17473", "82832", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17474", "82833", "url_article", "https://www.packagingstrategies.com/articles/90242-the-shift-from-traditional-materials-to-flexible-packaging");
INSERT INTO `wp_postmeta` VALUES("17475", "82833", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17476", "82834", "url_article", "https://www.arplastsl.com/productos/PLV+y+Muestrarios/6/Portaprecios/79");
INSERT INTO `wp_postmeta` VALUES("17477", "82834", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17478", "82835", "url_article", "https://www.arplastsl.com/productos/Packaging+Sectores/9/Blisters+y+bandejas+jardiner%C3%ADa/60");
INSERT INTO `wp_postmeta` VALUES("17479", "82835", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17480", "82836", "url_article", "https://www.arplastsl.com/productos/PLV+y+Muestrarios/6/Portafolletos/29");
INSERT INTO `wp_postmeta` VALUES("17481", "82836", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17482", "82837", "url_article", "https://www.arplastsl.com/productos/Expositores+y+Bandejas/4/Expositores++Bol/15");
INSERT INTO `wp_postmeta` VALUES("17483", "82837", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17484", "82838", "url_article", "https://www.arplastsl.com/productos/Estuches/3/Estuches+Bolso+-+Piramide+-+Estrella/11");
INSERT INTO `wp_postmeta` VALUES("17485", "82838", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17486", "82839", "url_article", "https://www.arplastsl.com/productos/Estuches/3/-/0");
INSERT INTO `wp_postmeta` VALUES("17487", "82839", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17488", "82840", "url_article", "https://www.arplastsl.com/productos/Packaging+Sectores/9/Estuches+y+tubos+cosm%C3%A9tica/53");
INSERT INTO `wp_postmeta` VALUES("17489", "82840", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17490", "82841", "url_article", "https://www.arplastsl.com/noticia/Adaptar+el+envase+al+canal+e-commerce%2C+cuesti%C3%B3n+de+innovaci%C3%B3n+y+tecnolog%C3%ADa/233");
INSERT INTO `wp_postmeta` VALUES("17491", "82841", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17492", "82841", "url_picture", "https://www.arplastsl.com/Catalogo/Item/233_Item/noticia.jpeg");
INSERT INTO `wp_postmeta` VALUES("17493", "82842", "url_article", "https://www.arplastsl.com/productos/Blisters++Expositores+y+Bandejas/10/Bandejas+Promocionales/46");
INSERT INTO `wp_postmeta` VALUES("17494", "82842", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17495", "82843", "url_article", "https://www.arplastsl.com/productos/Estuches/8/Tubos+personalizados/43");
INSERT INTO `wp_postmeta` VALUES("17496", "82843", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17497", "82844", "url_article", "https://www.arplastsl.com/productos/Packaging+Sectores/9/Estuches+ortopedia/62");
INSERT INTO `wp_postmeta` VALUES("17498", "82844", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17499", "82845", "url_article", "https://www.arplastsl.com/productos/Blisters++Expositores+y+Bandejas/10/Blisters+autocierre/48");
INSERT INTO `wp_postmeta` VALUES("17500", "82845", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17501", "82846", "url_article", "https://www.arplastsl.com/productos/Impresion+3D/11/Dise%C3%B1o+y+presentaci%C3%B3n+3D/57");
INSERT INTO `wp_postmeta` VALUES("17502", "82846", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17503", "82847", "url_article", "https://www.arplastsl.com/productos/Tubos/5/Tubos+redondos+bordonado+NEW+/25");
INSERT INTO `wp_postmeta` VALUES("17504", "82847", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17505", "82848", "url_article", "https://www.arplastsl.com/productos/PLV+y+Muestrarios/6/Ganchos+adhesivos/32");
INSERT INTO `wp_postmeta` VALUES("17506", "82848", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17507", "82849", "url_article", "https://www.arplastsl.com/productos/Packaging+Sectores/9/Tubos+y+Estuches+Alimentacion/72");
INSERT INTO `wp_postmeta` VALUES("17508", "82849", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17509", "82850", "url_article", "https://www.arplastsl.com/noticia/Packaging+2018%3A+Personalizaci%C3%B3n+y+experiencia/237");
INSERT INTO `wp_postmeta` VALUES("17510", "82850", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("17511", "82850", "url_picture", "https://www.arplastsl.com/Catalogo/Item/237_Item/NOTICIA%2012-1-2018.jpg");
INSERT INTO `wp_postmeta` VALUES("17512", "82851", "url_article", "https://www.arplastsl.com/productos/Packaging+Sectores/9/Bandejas+y+blisters+Alimentacion/71");
INSERT INTO `wp_postmeta` VALUES("17513", "82851", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17514", "82852", "url_article", "https://www.arplastsl.com/productos/Blisters++Expositores+y+Bandejas/10/Expositores+Personalizados/44");
INSERT INTO `wp_postmeta` VALUES("17515", "82852", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17516", "82853", "url_article", "https://www.arplastsl.com/productos/Blisters/1/Pinzas++soldadoras/5");
INSERT INTO `wp_postmeta` VALUES("17517", "82853", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17518", "82854", "url_article", "https://www.arplastsl.com/productos/Termoconformados/7/Termoconformados/37");
INSERT INTO `wp_postmeta` VALUES("17519", "82854", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17520", "82855", "url_article", "https://www.arplastsl.com/productos/Packaging+Sectores/9/Estuches+jardiner%C3%ADa/61");
INSERT INTO `wp_postmeta` VALUES("17521", "82855", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17522", "82856", "url_article", "https://www.arplastsl.com/productos/Estuches/3/Estuches+Coraz%C3%B3n+y+Abanico/10");
INSERT INTO `wp_postmeta` VALUES("17523", "82856", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17524", "82857", "url_article", "https://www.arplastsl.com/productos/Expositores+y+Bandejas/4/Expositores+Bisuter%C3%ADa/19");
INSERT INTO `wp_postmeta` VALUES("17525", "82857", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17526", "82858", "url_article", "https://www.arplastsl.com/productos/Blisters++Expositores+y+Bandejas/10/Expositores+doblados+pmma/47");
INSERT INTO `wp_postmeta` VALUES("17527", "82858", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17528", "82859", "url_article", "https://www.arplastsl.com/productos/Blisters/1/Blisters+corredera/1");
INSERT INTO `wp_postmeta` VALUES("17529", "82859", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17530", "82860", "url_article", "https://www.arplastsl.com/productos/PLV+y+Muestrarios/6/Portamovil/31");
INSERT INTO `wp_postmeta` VALUES("17531", "82860", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17532", "82861", "url_article", "https://www.arplastsl.com/productos/Blisters++Expositores+y+Bandejas/10/Bandejas+industriales+acondicionamiento/45");
INSERT INTO `wp_postmeta` VALUES("17533", "82861", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17534", "82862", "url_article", "https://www.arplastsl.com/productos/Estuches/3/Estuche+Telefonia+NEW+/7");
INSERT INTO `wp_postmeta` VALUES("17535", "82862", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17536", "82863", "url_article", "https://www.arplastsl.com/productos/Estuches/8/Otros+formatos/41");
INSERT INTO `wp_postmeta` VALUES("17537", "82863", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17538", "82864", "url_article", "https://www.arplastsl.com/productos/PLV+y+Muestrarios/6/Muestrarios/34");
INSERT INTO `wp_postmeta` VALUES("17539", "82864", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17540", "82865", "url_article", "https://www.arplastsl.com/productos/Blisters/1/blisters+peucos/3");
INSERT INTO `wp_postmeta` VALUES("17541", "82865", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17542", "82866", "url_article", "https://www.arplastsl.com/productos/Blisters++Expositores+y+Bandejas/10/-/0");
INSERT INTO `wp_postmeta` VALUES("17543", "82866", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17544", "82867", "url_article", "https://www.arplastsl.com/productos/Termoconformados/7/-/0");
INSERT INTO `wp_postmeta` VALUES("17545", "82867", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17546", "82868", "url_article", "https://www.arplastsl.com/productos/PLV+y+Muestrarios/6/Solapa+colgador/33");
INSERT INTO `wp_postmeta` VALUES("17547", "82868", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17548", "82869", "url_article", "https://www.arplastsl.com/productos/Ofertas+Packaging/13/Estuches/74");
INSERT INTO `wp_postmeta` VALUES("17549", "82869", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17550", "82870", "url_article", "https://www.arplastsl.com/noticia/8+tendencias+en+el+envase/239");
INSERT INTO `wp_postmeta` VALUES("17551", "82870", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17552", "82870", "url_picture", "https://www.arplastsl.com/Catalogo/Item/239_Item/noticia.jpg");
INSERT INTO `wp_postmeta` VALUES("17553", "82871", "url_article", "https://www.arplastsl.com/noticia/Influencia+del+packaging+en+el+sector+Alimentario/242");
INSERT INTO `wp_postmeta` VALUES("17554", "82871", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17555", "82871", "url_picture", "https://www.arplastsl.com/Catalogo/Item/242_Item/NOTICIA%2002-02-2018.jpg");
INSERT INTO `wp_postmeta` VALUES("17556", "82872", "url_article", "https://www.arplastsl.com/empresa");
INSERT INTO `wp_postmeta` VALUES("17557", "82872", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("17558", "82873", "url_article", "https://www.arplastsl.com/productos/Blisters/1/-/0");
INSERT INTO `wp_postmeta` VALUES("17559", "82873", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17560", "82874", "url_article", "https://www.packagingstrategies.com/articles/90234-call-for-entries-awards-for-packaging-innovation-competition");
INSERT INTO `wp_postmeta` VALUES("17561", "82874", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17562", "82875", "url_article", "https://www.arplastsl.com/productos/Expositores+y+Bandejas/4/Expositores+Ganchos/17");
INSERT INTO `wp_postmeta` VALUES("17563", "82875", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17564", "82876", "url_article", "https://www.arplastsl.com/productos/Packaging+Sectores/9/Estuches+bricolaje/55");
INSERT INTO `wp_postmeta` VALUES("17565", "82876", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17566", "82877", "url_article", "https://www.arplastsl.com/noticia/El+packaging+debe+ser+capaz+de+trasladar+la+esencia+del+producto/234");
INSERT INTO `wp_postmeta` VALUES("17567", "82877", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("17568", "82877", "url_picture", "https://www.arplastsl.com/Catalogo/Item/234_Item/noticia.jpg");
INSERT INTO `wp_postmeta` VALUES("17569", "82878", "url_article", "https://www.arplastsl.com/productos/Tubos/5/Tubos+Redondos/24");
INSERT INTO `wp_postmeta` VALUES("17570", "82878", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17571", "82879", "url_article", "https://www.arplastsl.com/productos/Packaging+Sectores/9/Bandejas+cosm%C3%A9tica/52");
INSERT INTO `wp_postmeta` VALUES("17572", "82879", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17573", "82880", "url_article", "https://www.arplastsl.com/productos/Tubos/5/Tapas+tubos+rectangulares/27");
INSERT INTO `wp_postmeta` VALUES("17574", "82880", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17575", "82881", "url_article", "https://www.arplastsl.com/productos/Estuches/3/Cajas+Maravillosas/9");
INSERT INTO `wp_postmeta` VALUES("17576", "82881", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17577", "82882", "url_article", "https://www.arplastsl.com/productos/Blisters++Expositores+y+Bandejas/10/Blisters+soldados+-+sellados/49");
INSERT INTO `wp_postmeta` VALUES("17578", "82882", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17579", "82883", "url_article", "https://www.arplastsl.com/productos/Expositores+y+Bandejas/4/-/0");
INSERT INTO `wp_postmeta` VALUES("17580", "82883", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17581", "82884", "url_article", "https://www.arplastsl.com/noticia/El+empaque+en+el+marketing+mix/245");
INSERT INTO `wp_postmeta` VALUES("17582", "82884", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("17583", "82884", "url_picture", "https://www.arplastsl.com/Catalogo/Item/245_Item/noticia.jpg");
INSERT INTO `wp_postmeta` VALUES("17584", "82885", "url_article", "https://www.arplastsl.com/noticia/Diez+claves+para+el+sector+del+packaging+en+Espa%C3%B1a+2018+%28I%29/247");
INSERT INTO `wp_postmeta` VALUES("17585", "82885", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("17586", "82885", "url_picture", "https://www.arplastsl.com/Catalogo/Item/247_Item/noticia.jpg");
INSERT INTO `wp_postmeta` VALUES("17587", "82886", "url_article", "https://www.arplastsl.com/productos/Tubos/5/Tubplast+rectangular+enrollado/26");
INSERT INTO `wp_postmeta` VALUES("17588", "82886", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17589", "82887", "url_article", "https://www.arplastsl.com/productos/Blisters++Expositores+y+Bandejas/10/Blisters+corredera/50");
INSERT INTO `wp_postmeta` VALUES("17590", "82887", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17591", "82888", "url_article", "https://www.arplastsl.com/noticia/Nuevas+tendencias%2C+demandas+y+oportunidades+en+el+Packaging+out-of-home/244");
INSERT INTO `wp_postmeta` VALUES("17592", "82888", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17593", "82888", "url_picture", "https://www.arplastsl.com/Catalogo/Item/244_Item/noticia.jpg");
INSERT INTO `wp_postmeta` VALUES("17594", "82889", "url_article", "https://www.arplastsl.com/noticia/La+importancia+del+envase+en+la+decisi%C3%B3n+de+compra/236");
INSERT INTO `wp_postmeta` VALUES("17595", "82889", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17596", "82889", "url_picture", "https://www.arplastsl.com/Catalogo/Item/236_Item/noticia.jpg");
INSERT INTO `wp_postmeta` VALUES("17597", "82890", "url_article", "https://www.arplastsl.com/noticias-arplast-blog-news");
INSERT INTO `wp_postmeta` VALUES("17598", "82890", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17599", "82891", "url_article", "https://www.arplastsl.com/productos/Tubos/5/Tapas+tubos+redondos/23");
INSERT INTO `wp_postmeta` VALUES("17600", "82891", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17601", "82892", "url_article", "https://www.arplastsl.com/productos/Ofertas+Packaging/13/-/0");
INSERT INTO `wp_postmeta` VALUES("17602", "82892", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17603", "82893", "url_article", "https://www.arplastsl.com/contactar-localizacion");
INSERT INTO `wp_postmeta` VALUES("17604", "82893", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17605", "82894", "url_article", "https://www.arplastsl.com/productos/Packaging+Sectores/9/Tubos+textil/59");
INSERT INTO `wp_postmeta` VALUES("17606", "82894", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17607", "82895", "url_article", "https://www.arplastsl.com/noticia/Las+5+tendencias+que+cambiar%C3%A1n+el+Packaging+en+2018/246");
INSERT INTO `wp_postmeta` VALUES("17608", "82895", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("17609", "82895", "url_picture", "https://www.arplastsl.com/Catalogo/Item/246_Item/noticia.jpg");
INSERT INTO `wp_postmeta` VALUES("17610", "82896", "url_article", "https://www.arplastsl.com/productos/Blisters/1/Blister+Closed+NEW+/4");
INSERT INTO `wp_postmeta` VALUES("17611", "82896", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17612", "82897", "url_article", "https://www.arplastsl.com/productos/PLV+y+Muestrarios/6/-/0");
INSERT INTO `wp_postmeta` VALUES("17613", "82897", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17614", "82898", "url_article", "https://www.arplastsl.com/productos/Packaging+Sectores/9/Packaging+Telefonia/80");
INSERT INTO `wp_postmeta` VALUES("17615", "82898", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17616", "82899", "url_article", "https://www.arplastsl.com/productos/Packaging+Sectores/9/Expositores+ortopedia/63");
INSERT INTO `wp_postmeta` VALUES("17617", "82899", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17618", "82900", "url_article", "https://www.arplastsl.com/productos/PLV+y+Muestrarios/6/Cajetines/35");
INSERT INTO `wp_postmeta` VALUES("17619", "82900", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17620", "82901", "url_article", "https://www.arplastsl.com/productos/Estuches/3/Estuches+forma/12");
INSERT INTO `wp_postmeta` VALUES("17621", "82901", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17622", "82902", "url_article", "https://www.arplastsl.com/productos/Impresion+3D/11/Prototipos+3D/58");
INSERT INTO `wp_postmeta` VALUES("17623", "82902", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17624", "82903", "url_article", "https://www.packagingstrategies.com/articles/90230-pmmi-awards-scholarship-to-rochester-institute-of-technology");
INSERT INTO `wp_postmeta` VALUES("17625", "82903", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17626", "82904", "url_article", "https://www.arplastsl.com/productos/Estuches/8/Estuches+pp/42");
INSERT INTO `wp_postmeta` VALUES("17627", "82904", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17628", "82905", "url_article", "https://www.arplastsl.com/productos/Packaging+Sectores/9/Estuches+textil/56");
INSERT INTO `wp_postmeta` VALUES("17629", "82905", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17630", "82906", "url_article", "https://www.arplastsl.com/productos/Packaging+Sectores/9/Expositores+cosm%C3%A9tica/51");
INSERT INTO `wp_postmeta` VALUES("17631", "82906", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17632", "82907", "url_article", "https://www.arplastsl.com/noticia/%22El+internet+de+las+cosas%22/235");
INSERT INTO `wp_postmeta` VALUES("17633", "82907", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("17634", "82907", "url_picture", "https://www.arplastsl.com/Catalogo/Item/235_Item/noticia.jpg");
INSERT INTO `wp_postmeta` VALUES("17635", "82908", "url_article", "http://www.plastico.com:80/guia-de-proveedores/empresas/Kung-Hsing-Plastic-Machinery-Co,-Ltd+277891?showroom=3086826");
INSERT INTO `wp_postmeta` VALUES("17636", "82908", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("17637", "82908", "url_picture", "http://www.plastico.com:80/documenta/imagenes/3093130/Kung-Hsing-Plastic-Machinery-Co-Logo.jpg");
INSERT INTO `wp_postmeta` VALUES("17638", "82909", "url_article", "http://www.plastico.com:80/guia-de-proveedores/empresas/Agr-International,-Inc+158542?showroom=97083");
INSERT INTO `wp_postmeta` VALUES("17639", "82909", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("17640", "82909", "url_picture", "http://www.plastico.com:80/documenta/imagenes/103474/Agr-Logo.jpg");
INSERT INTO `wp_postmeta` VALUES("17641", "82910", "url_article", "http://www.plastico.com/temas/Cinco-tendencias-de-envases-para-el-2018+124260?tema=3720000");
INSERT INTO `wp_postmeta` VALUES("17642", "82910", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("17643", "82910", "url_picture", "http://www.plastico.com/documenta/imagenes/130754/envases-gr.jpg");
INSERT INTO `wp_postmeta` VALUES("17644", "82911", "url_article", "http://www.plastico.com:80/guia-de-proveedores/empresas/DAK-Resinas-Americas-Mexico-SA-de-CV+270309?showroom=111886");
INSERT INTO `wp_postmeta` VALUES("17645", "82911", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17646", "82911", "url_picture", "http://www.plastico.com:80/documenta/imagenes/118363/DAK-LOGO.jpg");
INSERT INTO `wp_postmeta` VALUES("17647", "82912", "url_article", "http://www.plastico.com:80/guia-de-proveedores/empresas/Polystar-Taiwan+513916?showroom=94778");
INSERT INTO `wp_postmeta` VALUES("17648", "82912", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17649", "82912", "url_picture", "http://www.plastico.com:80/documenta/imagenes/101150/logo-polystar-catalogos1.jpg");
INSERT INTO `wp_postmeta` VALUES("17650", "82913", "url_article", "http://www.plastico.com:80/guia-de-proveedores/empresas/Nexeo-Solutions-Mexico+507467?showroom=96699");
INSERT INTO `wp_postmeta` VALUES("17651", "82913", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17652", "82913", "url_picture", "http://www.plastico.com:80/documenta/imagenes/103086/Nexeo-LOGO.jpg");
INSERT INTO `wp_postmeta` VALUES("17653", "82914", "url_article", "https://foodmag.com.au/plastic-pillow-block-bearings/");
INSERT INTO `wp_postmeta` VALUES("17654", "82914", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17655", "82915", "url_article", "http://www.plastico.com/temas/NPE2018-calienta-motores+124339?tema=3600511");
INSERT INTO `wp_postmeta` VALUES("17656", "82915", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("17657", "82915", "url_picture", "http://www.plastico.com/documenta/imagenes/130833/NPE2018-PQ.jpg");
INSERT INTO `wp_postmeta` VALUES("17658", "82916", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/333na1rss_en.pdf");
INSERT INTO `wp_postmeta` VALUES("17659", "82916", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17660", "82917", "url_article", "http://www.plastico.com:80/guia-de-proveedores/empresas/Zhejiang-Jingcheng-Mold-Machinery-Co,Ltd+516441?showroom=102635");
INSERT INTO `wp_postmeta` VALUES("17661", "82917", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17662", "82917", "url_picture", "http://www.plastico.com:80/documenta/imagenes/109114/logo-jctimes.jpg");
INSERT INTO `wp_postmeta` VALUES("17663", "82918", "url_article", "http://www.plastico.com:80/guia-de-proveedores/empresas/Rocheleau-Tool-y-Die-Co-Inc+10139?showroom=98826");
INSERT INTO `wp_postmeta` VALUES("17664", "82918", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("17665", "82918", "url_picture", "http://www.plastico.com:80/documenta/imagenes/105226/80th-Rocheleau-330.jpg");
INSERT INTO `wp_postmeta` VALUES("17666", "82919", "url_article", "https://www.packagingstrategies.com/articles/90226-interpack-2020-processes-and-packaging-online-exhibitor-registration-open");
INSERT INTO `wp_postmeta` VALUES("17667", "82919", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17668", "82920", "url_article", "http://www.plastico.com:80/guia-de-proveedores/empresas/Macro-Engineering-y-Technology-Inc+8970?showroom=105081");
INSERT INTO `wp_postmeta` VALUES("17669", "82920", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17670", "82920", "url_picture", "http://www.plastico.com:80/documenta/imagenes/111559/LOGO-Macro-200.jpg");
INSERT INTO `wp_postmeta` VALUES("17671", "82921", "url_article", "http://www.plastico.com:80/guia-de-proveedores/empresas/StackTeck-Systems-Limited+130652?showroom=96761");
INSERT INTO `wp_postmeta` VALUES("17672", "82921", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17673", "82921", "url_picture", "http://www.plastico.com/sitio/imagenes-produccion/14/StackTech/Comapania.jpg");
INSERT INTO `wp_postmeta` VALUES("17674", "82922", "url_article", "http://www.plastico.com:80/temas/Equipos-de-extrusion-para-laminas-destinadas-a-termoformado+123623");
INSERT INTO `wp_postmeta` VALUES("17675", "82922", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17676", "82922", "url_picture", "http://www.plastico.com/documenta/imagenes/130117/extrusora-para-termoformado-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("17677", "82923", "url_article", "http://www.plastico.com/inicio/");
INSERT INTO `wp_postmeta` VALUES("17678", "82923", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17679", "82923", "url_picture", "http://www.plastico.com/documenta/imagenes/130117/extrusora-para-termoformado-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("17680", "82924", "url_article", "http://www.plastico.com:80/guia-de-proveedores/empresas/GN-Thermoforming-Equipment+8821?showroom=116780");
INSERT INTO `wp_postmeta` VALUES("17681", "82924", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17682", "82924", "url_picture", "http://www.plastico.com:80/documenta/imagenes/123252/GN-logo.jpg");
INSERT INTO `wp_postmeta` VALUES("17683", "82925", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/331na1rss_en.pdf");
INSERT INTO `wp_postmeta` VALUES("17684", "82925", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("17685", "82926", "url_article", "http://www.plastico.com/inicio/?idioma=en");
INSERT INTO `wp_postmeta` VALUES("17686", "82926", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17687", "82926", "url_picture", "http://www.plastico.com/documenta/imagenes/130117/extrusora-para-termoformado-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("17688", "82927", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/331na1rss_en.pdf");
INSERT INTO `wp_postmeta` VALUES("17689", "82927", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17690", "82928", "url_article", "https://www.packagingstrategies.com/articles/90221-open-scs-group-presents-update-on-enhanced-drug-distribution-security");
INSERT INTO `wp_postmeta` VALUES("17691", "82928", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17692", "82929", "url_article", "https://www.packagingstrategies.com/articles/90213-packaging-experience-summit-showcases-importance-of-digital-print");
INSERT INTO `wp_postmeta` VALUES("17693", "82929", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17694", "82930", "url_article", "https://www.packagingstrategies.com/articles/90216-edelmann-usa-joins-the-paperboard-packaging-council");
INSERT INTO `wp_postmeta` VALUES("17695", "82930", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17696", "82931", "url_article", "https://www.packagingstrategies.com/articles/90205-pittas-officially-takes-pmmi-reins");
INSERT INTO `wp_postmeta` VALUES("17697", "82931", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17698", "82932", "url_article", "https://www.packagingstrategies.com/articles/90200-eleven-companies-commit-to-100-reusable-recyclable-or-compostable-packaging");
INSERT INTO `wp_postmeta` VALUES("17699", "82932", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17700", "82933", "url_article", "https://www.packagingstrategies.com/articles/90188-new-sustainability-vision-for-coca-cola-sees-a-world-without-waste");
INSERT INTO `wp_postmeta` VALUES("17701", "82933", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17702", "82934", "url_article", "https://www.packagingstrategies.com/articles/90183-cal-poly-offers-ms-degree-in-packaging-value-chain");
INSERT INTO `wp_postmeta` VALUES("17703", "82934", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17704", "82935", "url_article", "https://www.packagingstrategies.com/articles/90187-global-packaging-services-market-to-reach-50-billion-in-2023");
INSERT INTO `wp_postmeta` VALUES("17705", "82935", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17706", "82936", "url_article", "https://www.packagingstrategies.com/articles/90163-rigid-box-operator-courses-slated-for-first-quarter-2018");
INSERT INTO `wp_postmeta` VALUES("17707", "82936", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17708", "82937", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/324na3_en.pdf");
INSERT INTO `wp_postmeta` VALUES("17709", "82937", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17710", "82938", "url_article", "https://www.linpacpackaging.com/es/news/film");
INSERT INTO `wp_postmeta` VALUES("17711", "82938", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17712", "82939", "url_article", "https://www.packagingstrategies.com/articles/90157-six-key-trends-driving-the-sales-of-fresh-fruits-vegetables");
INSERT INTO `wp_postmeta` VALUES("17713", "82939", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17714", "82940", "url_article", "https://www.linpacpackaging.com/es/news/201410");
INSERT INTO `wp_postmeta` VALUES("17715", "82940", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17716", "82941", "url_article", "https://www.linpacpackaging.com/es/news/201412");
INSERT INTO `wp_postmeta` VALUES("17717", "82941", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17718", "82942", "url_article", "https://www.linpacpackaging.com/es/news/201712/linpac-kl%C3%B6ckner-pentaplast-nominated-starpack-award");
INSERT INTO `wp_postmeta` VALUES("17719", "82942", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("17720", "82943", "url_article", "https://www.linpacpackaging.com/en/markets/films");
INSERT INTO `wp_postmeta` VALUES("17721", "82943", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17722", "82944", "url_article", "https://www.linpacpackaging.com/en/cookies-policy");
INSERT INTO `wp_postmeta` VALUES("17723", "82944", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17724", "82945", "url_article", "https://www.linpacpackaging.com/es/news/201301");
INSERT INTO `wp_postmeta` VALUES("17725", "82945", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17726", "82946", "url_article", "https://www.linpacpackaging.com/es/conoce-linpac-packaging");
INSERT INTO `wp_postmeta` VALUES("17727", "82946", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17728", "82947", "url_article", "https://www.linpacpackaging.com/es/mercados/reposter%C3%AD");
INSERT INTO `wp_postmeta` VALUES("17729", "82947", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17730", "82948", "url_article", "https://www.linpacpackaging.com/es/proyectos-envasost");
INSERT INTO `wp_postmeta` VALUES("17731", "82948", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17732", "82948", "url_picture", "https://www.linpacpackaging.com/files/images/INNPACTO.png");
INSERT INTO `wp_postmeta` VALUES("17733", "82949", "url_article", "https://www.linpacpackaging.com/es/news/201710/linpac-kl%C3%B6ckner-pentaplast-seeks-bust-eps-myths-launch-black-eps-packs-premium-catering");
INSERT INTO `wp_postmeta` VALUES("17734", "82949", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("17735", "82950", "url_article", "https://www.linpacpackaging.com/es");
INSERT INTO `wp_postmeta` VALUES("17736", "82950", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17737", "82951", "url_article", "https://www.linpacpackaging.com/en/markets/chilled-and-prepared-foods");
INSERT INTO `wp_postmeta` VALUES("17738", "82951", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17739", "82952", "url_article", "https://www.linpacpackaging.com/es/news/201511");
INSERT INTO `wp_postmeta` VALUES("17740", "82952", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17741", "82953", "url_article", "https://www.linpacpackaging.com/es/news/201512");
INSERT INTO `wp_postmeta` VALUES("17742", "82953", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("17743", "82954", "url_article", "https://www.linpacpackaging.com/es/news/201509");
INSERT INTO `wp_postmeta` VALUES("17744", "82954", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17745", "82955", "url_article", "https://www.linpacpackaging.com/es/proyectos-materiales-reciclados-postconsumo-desarrollo-de-la-tecnolog%C3%ADa-para-su-utilizaci%C3%B3n-en");
INSERT INTO `wp_postmeta` VALUES("17746", "82955", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17747", "82955", "url_picture", "https://www.linpacpackaging.com/files/images/gobierno%20ppdo%20asturias.jpg");
INSERT INTO `wp_postmeta` VALUES("17748", "82956", "url_article", "https://www.linpacpackaging.com/es/news/201508");
INSERT INTO `wp_postmeta` VALUES("17749", "82956", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17750", "82957", "url_article", "https://www.linpacpackaging.com/es/news/201507");
INSERT INTO `wp_postmeta` VALUES("17751", "82957", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17752", "82958", "url_article", "https://www.linpacpackaging.com/en/markets/dairy-meat-fish-poultry");
INSERT INTO `wp_postmeta` VALUES("17753", "82958", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17754", "82959", "url_article", "https://www.linpacpackaging.com/es/news/201506");
INSERT INTO `wp_postmeta` VALUES("17755", "82959", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17756", "82960", "url_article", "https://www.linpacpackaging.com/es/news/201503");
INSERT INTO `wp_postmeta` VALUES("17757", "82960", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17758", "82961", "url_article", "https://www.linpacpackaging.com/es/recursos");
INSERT INTO `wp_postmeta` VALUES("17759", "82961", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17760", "82962", "url_article", "https://www.linpacpackaging.com/es/news/201712/linpac-kl%C3%B6ckner-pentaplast-%E2%80%98quick-roast%E2%80%99-joint-pack-recognised-innovation-uk-packaging");
INSERT INTO `wp_postmeta` VALUES("17761", "82962", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("17762", "82963", "url_article", "https://www.linpacpackaging.com/es/blog/all");
INSERT INTO `wp_postmeta` VALUES("17763", "82963", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17764", "82964", "url_article", "https://www.linpacpackaging.com/es/");
INSERT INTO `wp_postmeta` VALUES("17765", "82964", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17766", "82965", "url_article", "https://www.linpacpackaging.com/es/linare-atenci%C3%B3n-al-cliente");
INSERT INTO `wp_postmeta` VALUES("17767", "82965", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17768", "82966", "url_article", "https://www.linpacpackaging.com/es/mercados/fruta-y-verdura");
INSERT INTO `wp_postmeta` VALUES("17769", "82966", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17770", "82967", "url_article", "https://www.linpacpackaging.com/es/news/201401");
INSERT INTO `wp_postmeta` VALUES("17771", "82967", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17772", "82968", "url_article", "https://www.linpacpackaging.com/es/news/bakery");
INSERT INTO `wp_postmeta` VALUES("17773", "82968", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17774", "82969", "url_article", "https://www.linpacpackaging.com/en/markets/fruit-produce");
INSERT INTO `wp_postmeta` VALUES("17775", "82969", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("17776", "82970", "url_article", "https://www.linpacpackaging.com/es/acreditaciones");
INSERT INTO `wp_postmeta` VALUES("17777", "82970", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("17778", "82971", "url_article", "https://www.linpacpackaging.com/es/mercados/alimentos-refrigerados-y-preparados");
INSERT INTO `wp_postmeta` VALUES("17779", "82971", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17780", "82972", "url_article", "https://www.linpacpackaging.com/es/news/201210");
INSERT INTO `wp_postmeta` VALUES("17781", "82972", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17782", "82973", "url_article", "https://www.linpacpackaging.com/es/news/fruit-produce");
INSERT INTO `wp_postmeta` VALUES("17783", "82973", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17784", "82974", "url_article", "https://www.linpacpackaging.com/es/news/201609");
INSERT INTO `wp_postmeta` VALUES("17785", "82974", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("17786", "82975", "url_article", "https://www.linpacpackaging.com/es/news/201608");
INSERT INTO `wp_postmeta` VALUES("17787", "82975", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17788", "82976", "url_article", "https://www.linpacpackaging.com/es/news/201607");
INSERT INTO `wp_postmeta` VALUES("17789", "82976", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17790", "82977", "url_article", "https://www.linpacpackaging.com/es/news/201606");
INSERT INTO `wp_postmeta` VALUES("17791", "82977", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("17792", "82978", "url_article", "https://www.linpacpackaging.com/es/news/201711/kl%C3%B6ckner-pentaplast-introduces-kp-icenter-spain");
INSERT INTO `wp_postmeta` VALUES("17793", "82978", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("17794", "82979", "url_article", "https://www.linpacpackaging.com/es/news/201604");
INSERT INTO `wp_postmeta` VALUES("17795", "82979", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17796", "82980", "url_article", "https://www.linpacpackaging.com/es/news/201206");
INSERT INTO `wp_postmeta` VALUES("17797", "82980", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17798", "82981", "url_article", "https://www.linpacpackaging.com/es/news/201209");
INSERT INTO `wp_postmeta` VALUES("17799", "82981", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17800", "82982", "url_article", "https://www.linpacpackaging.com/es/news/201603");
INSERT INTO `wp_postmeta` VALUES("17801", "82982", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("17802", "82983", "url_article", "https://www.linpacpackaging.com/es/news/201602");
INSERT INTO `wp_postmeta` VALUES("17803", "82983", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17804", "82984", "url_article", "https://www.linpacpackaging.com/es/mercados/l%C3%A1cteos-carne-pescado-y-productos-av%C3%ADcolas");
INSERT INTO `wp_postmeta` VALUES("17805", "82984", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("17806", "82985", "url_article", "https://www.linpacpackaging.com/es/news/catering-fast-food");
INSERT INTO `wp_postmeta` VALUES("17807", "82985", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17808", "82986", "url_article", "https://www.linpacpackaging.com/es/news/201104");
INSERT INTO `wp_postmeta` VALUES("17809", "82986", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17810", "82987", "url_article", "https://www.linpacpackaging.com/es/news/201802/kp-fcp-present-total-pack-solutions-cfia");
INSERT INTO `wp_postmeta` VALUES("17811", "82987", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("17812", "82988", "url_article", "https://www.linpacpackaging.com/es/news/201102");
INSERT INTO `wp_postmeta` VALUES("17813", "82988", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17814", "82989", "url_article", "https://www.linpacpackaging.com/es/news/201101");
INSERT INTO `wp_postmeta` VALUES("17815", "82989", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17816", "82990", "url_article", "https://www.linpacpackaging.com/es/news/201709/black-plastic-packaging-recycling-forum");
INSERT INTO `wp_postmeta` VALUES("17817", "82990", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("17818", "82991", "url_article", "https://www.linpacpackaging.com/es/news/201710");
INSERT INTO `wp_postmeta` VALUES("17819", "82991", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17820", "82992", "url_article", "https://www.linpacpackaging.com/es/news/201310");
INSERT INTO `wp_postmeta` VALUES("17821", "82992", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17822", "82993", "url_article", "https://www.linpacpackaging.com/es/news/201711");
INSERT INTO `wp_postmeta` VALUES("17823", "82993", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17824", "82994", "url_article", "https://www.linpacpackaging.com/en/markets/bakery");
INSERT INTO `wp_postmeta` VALUES("17825", "82994", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17826", "82995", "url_article", "https://www.linpacpackaging.com/es/news/201311");
INSERT INTO `wp_postmeta` VALUES("17827", "82995", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17828", "82996", "url_article", "https://www.linpacpackaging.com/es/news/201706");
INSERT INTO `wp_postmeta` VALUES("17829", "82996", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17830", "82997", "url_article", "https://www.linpacpackaging.com/es/news/201309");
INSERT INTO `wp_postmeta` VALUES("17831", "82997", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17832", "82998", "url_article", "https://www.linpacpackaging.com/en/terms-conditions");
INSERT INTO `wp_postmeta` VALUES("17833", "82998", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17834", "82999", "url_article", "https://www.linpacpackaging.com/es/news/201703");
INSERT INTO `wp_postmeta` VALUES("17835", "82999", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17836", "83000", "url_article", "https://www.linpacpackaging.com/es/news/201701");
INSERT INTO `wp_postmeta` VALUES("17837", "83000", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17838", "83001", "url_article", "https://www.linpacpackaging.com/es/news/201305");
INSERT INTO `wp_postmeta` VALUES("17839", "83001", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17840", "83002", "url_article", "https://www.linpacpackaging.com/es/news/201710/linpac-kl%C3%B6ckner-pentaplast-teams-dunbia-develop-pack-award-winning-%E2%80%98quick-roast%E2%80%99-joint");
INSERT INTO `wp_postmeta` VALUES("17841", "83002", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("17842", "83003", "url_article", "https://www.linpacpackaging.com/es/news/201702");
INSERT INTO `wp_postmeta` VALUES("17843", "83003", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17844", "83004", "url_article", "https://www.linpacpackaging.com/es/mercados");
INSERT INTO `wp_postmeta` VALUES("17845", "83004", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17846", "83005", "url_article", "https://www.linpacpackaging.com/es/news/201706/linpac-makes-significant-investment-new-energy-efficient-cooling-system-uk-headquarters");
INSERT INTO `wp_postmeta` VALUES("17847", "83005", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17848", "83006", "url_article", "https://www.linpacpackaging.com/es/mercados/catering-y-comida-r%C3%A1pida");
INSERT INTO `wp_postmeta` VALUES("17849", "83006", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17850", "83007", "url_article", "https://www.linpacpackaging.com/es/desarrollo-de-bandejas-de-espuma-de-poliestireno%E2%80%A6");
INSERT INTO `wp_postmeta` VALUES("17851", "83007", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17852", "83007", "url_picture", "https://www.linpacpackaging.com/files/images/bandeja%20ficyt.JPG");
INSERT INTO `wp_postmeta` VALUES("17853", "83008", "url_article", "https://www.linpacpackaging.com/en/privacy-policy");
INSERT INTO `wp_postmeta` VALUES("17854", "83008", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17855", "83009", "url_article", "https://www.linpacpackaging.com/es/mercados/film-barrera-y-extensible");
INSERT INTO `wp_postmeta` VALUES("17856", "83009", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17857", "83010", "url_article", "https://www.linpacpackaging.com/es/news/corporate");
INSERT INTO `wp_postmeta` VALUES("17858", "83010", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17859", "83011", "url_article", "https://www.linpacpackaging.com/es/news/dairy-meat-fish-poultry");
INSERT INTO `wp_postmeta` VALUES("17860", "83011", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17861", "83012", "url_article", "https://www.linpacpackaging.com/es/el-medio-ambiente");
INSERT INTO `wp_postmeta` VALUES("17862", "83012", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("17863", "83013", "url_article", "https://www.linpacpackaging.com/es/noticias");
INSERT INTO `wp_postmeta` VALUES("17864", "83013", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17865", "83014", "url_article", "https://www.linpacpackaging.com/es/news/201601");
INSERT INTO `wp_postmeta` VALUES("17866", "83014", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17867", "83015", "url_article", "https://www.linpacpackaging.com/es/news/201205");
INSERT INTO `wp_postmeta` VALUES("17868", "83015", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17869", "83016", "url_article", "https://www.linpacpackaging.com/es/news/201203");
INSERT INTO `wp_postmeta` VALUES("17870", "83016", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17871", "83017", "url_article", "https://www.linpacpackaging.com/es/news/201202");
INSERT INTO `wp_postmeta` VALUES("17872", "83017", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17873", "83018", "url_article", "https://www.linpacpackaging.com/es/oficina-de-prensa");
INSERT INTO `wp_postmeta` VALUES("17874", "83018", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17875", "83019", "url_article", "https://www.linpacpackaging.com/es/news/201201");
INSERT INTO `wp_postmeta` VALUES("17876", "83019", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17877", "83020", "url_article", "https://www.linpacpackaging.com/es/proyectos-zeocide");
INSERT INTO `wp_postmeta` VALUES("17878", "83020", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("17879", "83020", "url_picture", "https://www.linpacpackaging.com/files/images/INNPACTO.png");
INSERT INTO `wp_postmeta` VALUES("17880", "83021", "url_article", "https://www.linpacpackaging.com/es/news/201712");
INSERT INTO `wp_postmeta` VALUES("17881", "83021", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17882", "83022", "url_article", "https://www.linpacpackaging.com/es/noticias?page=1");
INSERT INTO `wp_postmeta` VALUES("17883", "83022", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17884", "83023", "url_article", "http://www.elempaque.com/temas/Universal-Robots-aumenta-eficiencia-en-linea-de-produccion-de-Minit%C3%BCb+121820?tema=4100005");
INSERT INTO `wp_postmeta` VALUES("17885", "83023", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17886", "83023", "url_picture", "http://www.elempaque.com/documenta/imagenes/128307/Boco-Boddecker-p.jpg");
INSERT INTO `wp_postmeta` VALUES("17887", "83024", "url_article", "http://www.elempaque.com/temas/EXPO-PACK-Mexico-2018");
INSERT INTO `wp_postmeta` VALUES("17888", "83024", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17889", "83025", "url_article", "http://www.elempaque.com/eventos/Foro,-Envase-y-embalaje,-industria-integral-40+123659");
INSERT INTO `wp_postmeta` VALUES("17890", "83025", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17891", "83025", "url_picture", "http://www.elempaque.com/documenta/imagenes/130153/Foro-envase-y-embalaje-industria-integral-4.0-AMEE.jpg");
INSERT INTO `wp_postmeta` VALUES("17892", "83026", "url_article", "http://www.elempaque.com/temas/Industria-40?caso=Noticias-y-articulos&pagina=1");
INSERT INTO `wp_postmeta` VALUES("17893", "83026", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17894", "83027", "url_article", "http://www.elempaque.com/copyright");
INSERT INTO `wp_postmeta` VALUES("17895", "83027", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17896", "83028", "url_article", "http://www.elempaque.com/temas/Cuando-usar-las-palabras-envase,-empaque-y-embalaje+4040278");
INSERT INTO `wp_postmeta` VALUES("17897", "83028", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("17898", "83028", "url_picture", "http://www.elempaque.com/documenta/imagenes/4045999/Envase-primario-y-envasesecundario-p1.jpg");
INSERT INTO `wp_postmeta` VALUES("17899", "83029", "url_article", "http://www.elempaque.com/asociaciones/");
INSERT INTO `wp_postmeta` VALUES("17900", "83029", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17901", "83030", "url_article", "http://www.elempaque.com/temas/Impresion");
INSERT INTO `wp_postmeta` VALUES("17902", "83030", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17903", "83031", "url_article", "http://www.elempaque.com/temas/Procesos-de-envasado");
INSERT INTO `wp_postmeta` VALUES("17904", "83031", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17905", "83032", "url_article", "http://www.elempaque.com/temas/El-envase-puede-ser-el-vinculo-decisivo-entre-el-mundo-fisico-y-el-virtual,-Volker-Lange+123955");
INSERT INTO `wp_postmeta` VALUES("17906", "83032", "interes", "14");
INSERT INTO `wp_postmeta` VALUES("17907", "83032", "url_picture", "http://www.elempaque.com/documenta/imagenes/130449/Volker-Lange-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("17908", "83033", "url_article", "http://www.elempaque.com/productos/");
INSERT INTO `wp_postmeta` VALUES("17909", "83033", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17910", "83034", "url_article", "http://www.elempaque.com/temas/Materiales");
INSERT INTO `wp_postmeta` VALUES("17911", "83034", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17912", "83035", "url_article", "http://www.elempaque.com/");
INSERT INTO `wp_postmeta` VALUES("17913", "83035", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17914", "83035", "url_picture", "http://www.elempaque.com/documenta/imagenes/130615/Estudiantes-de-la-UN-desarrollaron-app-que-facilita-el-control-de-inventarios+124074-p.jpg");
INSERT INTO `wp_postmeta` VALUES("17915", "83036", "url_article", "http://www.elempaque.com/guia-de-proveedores/");
INSERT INTO `wp_postmeta` VALUES("17916", "83036", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17917", "83037", "url_article", "http://www.elempaque.com/temas/Siemens-lanza-el-Programa-de-Socios-MindSphere+123900?tema=4100005");
INSERT INTO `wp_postmeta` VALUES("17918", "83037", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17919", "83037", "url_picture", "http://www.elempaque.com/documenta/contenido/130394/Siemens-lanza-Programa-Socios-MindSphere-pq.fw.png");
INSERT INTO `wp_postmeta` VALUES("17920", "83038", "url_article", "http://www.elempaque.com/temas/Mercado,-Cuidado-Personal");
INSERT INTO `wp_postmeta` VALUES("17921", "83038", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17922", "83039", "url_article", "http://www.elempaque.com/temas/Andina-Pack-fue-testigo-de-la-final-de-las-Olimpiadas-Nacionales-de-Mecatronica+122667?tema=4100005");
INSERT INTO `wp_postmeta` VALUES("17923", "83039", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17924", "83039", "url_picture", "http://www.elempaque.com/documenta/imagenes/129155/final-olimpiadas-mecatronica-andina-pack-2017-p.jpg");
INSERT INTO `wp_postmeta` VALUES("17925", "83040", "url_article", "http://www.elempaque.com/temas/Aplicacion-para-smartphones-para-la-seleccion-de-cintas-de-montaje+122869?tema=4100005");
INSERT INTO `wp_postmeta` VALUES("17926", "83040", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("17927", "83040", "url_picture", "http://www.elempaque.com/documenta/contenido/129357/aplicacion-selector-de-espumas-tesa-tape-colombia-Andina-Pack-pq.fw.png");
INSERT INTO `wp_postmeta` VALUES("17928", "83041", "url_article", "http://www.elempaque.com/temas/Tendencias-en-la-produccion-de-envases+123447?tema=4100005");
INSERT INTO `wp_postmeta` VALUES("17929", "83041", "interes", "14");
INSERT INTO `wp_postmeta` VALUES("17930", "83041", "url_picture", "http://www.elempaque.com/documenta/imagenes/129940/tendencias-en-produccion-de-envases-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("17931", "83042", "url_article", "http://www.elempaque.com/temas/Mercado,-Alimentos-y-Bebidas");
INSERT INTO `wp_postmeta` VALUES("17932", "83042", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17933", "83043", "url_article", "http://www.elempaque.com/temas/Sostenibilidad");
INSERT INTO `wp_postmeta` VALUES("17934", "83043", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17935", "83044", "url_article", "http://www.elempaque.com/temas/Cascina-Italia-instala-en-su-linea-de-empaque-el-robot-UR5,-un-huevo-cada-vez+120466?tema=4100005");
INSERT INTO `wp_postmeta` VALUES("17936", "83044", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("17937", "83044", "url_picture", "http://www.elempaque.com/documenta/imagenes/126937/caso-1-pe.jpg");
INSERT INTO `wp_postmeta` VALUES("17938", "83045", "url_article", "http://www.elempaque.com/suscripcion");
INSERT INTO `wp_postmeta` VALUES("17939", "83045", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17940", "83046", "url_article", "http://www.elempaque.com/blogs");
INSERT INTO `wp_postmeta` VALUES("17941", "83046", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17942", "83047", "url_article", "http://www.elempaque.com/temas/Industria-de-envases-plasticos-en-Colombia,-crecimiento-a-traves-de-calidad-y-especializacion+97344");
INSERT INTO `wp_postmeta` VALUES("17943", "83047", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("17944", "83047", "url_picture", "http://www.elempaque.com/documenta/imagenes/103738/97344-0-P-consumidores-plastico-Colombia-panthermedia.jpg");
INSERT INTO `wp_postmeta` VALUES("17945", "83048", "url_article", "http://www.elempaque.com/temas/Empresa-de-productos-lacteos-dice-adios-a-trabajos-manuales-integrando-robots-a-su-linea+121986?tema=4100005");
INSERT INTO `wp_postmeta` VALUES("17946", "83048", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17947", "83048", "url_picture", "http://www.elempaque.com/documenta/imagenes/128473/brazos-ur-p.jpg");
INSERT INTO `wp_postmeta` VALUES("17948", "83049", "url_article", "http://www.elempaque.com/revista-digital/");
INSERT INTO `wp_postmeta` VALUES("17949", "83049", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17950", "83050", "url_article", "http://www.elempaque.com/temas/El-hito-de-KAMPF,-mil-cortadoras-Conslit-instaladas-en-el-mundo+124158");
INSERT INTO `wp_postmeta` VALUES("17951", "83050", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("17952", "83050", "url_picture", "http://www.elempaque.com/documenta/imagenes/130652/Kampf-celebra-instalacion-cortadora-Conslit-numero-mil-pq-1.jpg");
INSERT INTO `wp_postmeta` VALUES("17953", "83051", "url_article", "http://www.elempaque.com/temas/duAro,-robot-colaborativo-de-brazo-doble-sobre-un-solo-eje+121600?tema=4100005");
INSERT INTO `wp_postmeta` VALUES("17954", "83051", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17955", "83051", "url_picture", "http://www.elempaque.com/documenta/contenido/128087/duAro-robot-colaborativo-de-brazo-doble-sobre-un-solo-eje-KAwasaki-pq.fw.png");
INSERT INTO `wp_postmeta` VALUES("17956", "83052", "url_article", "http://www.elempaque.com/blogs/El-momento-de-la-Industria-40+119908");
INSERT INTO `wp_postmeta` VALUES("17957", "83052", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17958", "83052", "url_picture", "http://www.elempaque.com/documenta/imagenes/101675/Lilian-Robayo_300x300.jpg");
INSERT INTO `wp_postmeta` VALUES("17959", "83053", "url_article", "http://www.elempaque.com/temas/Cinemark-innova-con-el-Peelable-IML,-un-envase-sostenible-para-palomitas-de-maiz+124092");
INSERT INTO `wp_postmeta` VALUES("17960", "83053", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("17961", "83053", "url_picture", "http://www.elempaque.com/documenta/imagenes/130586/envases-IML-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("17962", "83054", "url_article", "http://www.elempaque.com/politica-de-tratamiento-de-datos-personales");
INSERT INTO `wp_postmeta` VALUES("17963", "83054", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17964", "83055", "url_article", "http://www.elempaque.com/temas/Conversion");
INSERT INTO `wp_postmeta` VALUES("17965", "83055", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17966", "83056", "url_article", "http://www.elempaque.com/temas/Engel-ofrece-seminario-especializado-en-packaging-en-Colombia+124114");
INSERT INTO `wp_postmeta` VALUES("17967", "83056", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("17968", "83056", "url_picture", "http://www.elempaque.com/documenta/imagenes/130608/Engel-dictara-seminario-de-packaging-en-colombia-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("17969", "83057", "url_article", "http://www.elempaque.com/productos");
INSERT INTO `wp_postmeta` VALUES("17970", "83057", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17971", "83058", "url_article", "http://www.elempaque.com/temas/Diseno");
INSERT INTO `wp_postmeta` VALUES("17972", "83058", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17973", "83059", "url_article", "http://www.elempaque.com/condiciones-del-servicio");
INSERT INTO `wp_postmeta` VALUES("17974", "83059", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17975", "83060", "url_article", "http://www.elempaque.com/catalogos/");
INSERT INTO `wp_postmeta` VALUES("17976", "83060", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17977", "83061", "url_article", "http://www.elempaque.com/temas/Industria-40");
INSERT INTO `wp_postmeta` VALUES("17978", "83061", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17979", "83062", "url_article", "http://www.elempaque.com/temas/Mercado-mundial-de-masterbatches-espera-alcanzar-los-USD-15810-millones-para-2025+124263");
INSERT INTO `wp_postmeta` VALUES("17980", "83062", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("17981", "83062", "url_picture", "http://www.elempaque.com/documenta/imagenes/130757/Mercado-mundial-de-masterbatches-espera-alcanzar-los-15-81-billones-de-dolares-para-2025-P.jpg");
INSERT INTO `wp_postmeta` VALUES("17982", "83063", "url_article", "http://www.elempaque.com/temas/Mercado,-Farmaceuticos");
INSERT INTO `wp_postmeta` VALUES("17983", "83063", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17984", "83064", "url_article", "http://www.elempaque.com/temas/Inteligencia-de-marca");
INSERT INTO `wp_postmeta` VALUES("17985", "83064", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17986", "83065", "url_article", "http://www.elempaque.com/temas/Cumbre-Envases-2018");
INSERT INTO `wp_postmeta` VALUES("17987", "83065", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("17988", "83066", "url_article", "http://www.elempaque.com/temas/Industria");
INSERT INTO `wp_postmeta` VALUES("17989", "83066", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17990", "83067", "url_article", "http://www.elempaque.com/temas/Envases-terminados-y-componentes");
INSERT INTO `wp_postmeta` VALUES("17991", "83067", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17992", "83068", "url_article", "http://www.elempaque.com/temas/GOA-2018");
INSERT INTO `wp_postmeta` VALUES("17993", "83068", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("17994", "83069", "url_article", "http://www.elempaque.com/aviso-de-privacidad");
INSERT INTO `wp_postmeta` VALUES("17995", "83069", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("17996", "83070", "url_article", "http://www.elempaque.com/temas/Actualizaciones-en-sensores-y-actuadores-estan-mejorando-la-productividad-de-los-equipos-de-envasado+120790?tema=4100005");
INSERT INTO `wp_postmeta` VALUES("17997", "83070", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("17998", "83070", "url_picture", "http://www.elempaque.com/documenta/imagenes/127261/One-IO-Link-and-RFID-Integration-for-Change-Parts-Packer%20Pushe-1-grpq.jpg");
INSERT INTO `wp_postmeta` VALUES("17999", "83071", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/302na5rss_en.pdf");
INSERT INTO `wp_postmeta` VALUES("18000", "83071", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18001", "83072", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/303na6rss_en.pdf");
INSERT INTO `wp_postmeta` VALUES("18002", "83072", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18003", "83073", "url_article", "http://www.elempaque.com/temas/BioPack,-envase-biobasado-para-aplicaciones-farmaceuticas+111104?tema=4290000");
INSERT INTO `wp_postmeta` VALUES("18004", "83073", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("18005", "83073", "url_picture", "http://www.elempaque.com/documenta/imagenes/117581/BioPack-empaque-biobasado-para-aplicaciones-farmaceuticas-de-Gerresheimer-P.jpg");
INSERT INTO `wp_postmeta` VALUES("18006", "83074", "url_article", "http://www.elempaque.com/blogs/Los-empaques-de-productos-de-cuidado-del-hogar,-al-borde-de-una-revolucion-del-reciclaje+115236");
INSERT INTO `wp_postmeta` VALUES("18007", "83074", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("18008", "83074", "url_picture", "http://www.elempaque.com/documenta/imagenes/121708/amin-alkhatib-euromonitor-international.jpg");
INSERT INTO `wp_postmeta` VALUES("18009", "83075", "url_article", "http://www.elempaque.com/blogs/Puede-una-campana-de-accion-social-ayudarnos-por-fin-a-reciclar-correctamente+108633");
INSERT INTO `wp_postmeta` VALUES("18010", "83075", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("18011", "83075", "url_picture", "http://www.elempaque.com/documenta/imagenes/115111/108633-G-Puede-una-campana-de-accion-social-ayudarnos-por-fin-a-reciclar-correctamente-2.jpg");
INSERT INTO `wp_postmeta` VALUES("18012", "83076", "url_article", "http://www.elempaque.com/temas/ReFresher-sistema-de-reciclaje-post-consumo-sin-olor+119069?tema=4290000");
INSERT INTO `wp_postmeta` VALUES("18013", "83076", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("18014", "83076", "url_picture", "http://www.elempaque.com/documenta/imagenes/125540/reciclaje-sin-olor-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18015", "83077", "url_article", "http://www.elempaque.com/temas/Smurfit-Kappa,-un-ejemplo-de-economia-circular+108813?tema=4290000");
INSERT INTO `wp_postmeta` VALUES("18016", "83077", "interes", "16");
INSERT INTO `wp_postmeta` VALUES("18017", "83077", "url_picture", "http://www.elempaque.com/documenta/imagenes/115291/carton-reciclado-p1.jpg");
INSERT INTO `wp_postmeta` VALUES("18018", "83078", "url_article", "http://www.elempaque.com/blogs/La-revolucion-de-la-comida,-Ipack-Ima-hace-certera-llamada-a-la-accion+105440");
INSERT INTO `wp_postmeta` VALUES("18019", "83078", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("18020", "83078", "url_picture", "http://www.elempaque.com/documenta/imagenes/101675/Lilian-Robayo_300x300.jpg");
INSERT INTO `wp_postmeta` VALUES("18021", "83079", "url_article", "http://www.elempaque.com/blogs/El-mito-de-la-biodegradabilidad-Parte-3,-por-que-los-bioplasticos-durables,-no-biodegradables,-pueden-ser-la-respuesta+111604");
INSERT INTO `wp_postmeta` VALUES("18022", "83079", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("18023", "83079", "url_picture", "http://www.elempaque.com/documenta/imagenes/101717/Tom-Szaky_300x300.jpg");
INSERT INTO `wp_postmeta` VALUES("18024", "83080", "url_article", "http://www.elempaque.com/asociaciones/IoPP+95234");
INSERT INTO `wp_postmeta` VALUES("18025", "83080", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18026", "83080", "url_picture", "http://www.elempaque.com/documenta/imagenes/101620/Inst.%20of%20Packaging%20Professionals.jpg");
INSERT INTO `wp_postmeta` VALUES("18027", "83081", "url_article", "http://www.elempaque.com/temas/Plantean-impuesto-ambiental-a-la-oferta-y-consumo-de-envases-desechables-PET+124504?tema=4290000");
INSERT INTO `wp_postmeta` VALUES("18028", "83081", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("18029", "83081", "url_picture", "http://www.elempaque.com/documenta/contenido/130998/senador-oscar-roman-rosas-del-PRI-autor-propuesta-impuetso-al-PET-en-Mexico-pq.fw.png");
INSERT INTO `wp_postmeta` VALUES("18030", "83082", "url_article", "http://www.elempaque.com/temas/Biotecno,-nuevo-material-que-permite-aumentar-la-vida-de-los-alimentos-empacados+124475?tema=4290000");
INSERT INTO `wp_postmeta` VALUES("18031", "83082", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("18032", "83082", "url_picture", "http://www.elempaque.com/documenta/imagenes/130969/biopelicula-Biotecno-a-partir-del-almidon-de-avena-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18033", "83083", "url_article", "http://www.elempaque.com/blogs/El-mito-de-la-biodegradabilidad-Parte-2,-los-productos-plasticos-de-consumo-y-los-empaques+111126");
INSERT INTO `wp_postmeta` VALUES("18034", "83083", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("18035", "83083", "url_picture", "http://www.elempaque.com/documenta/imagenes/101717/Tom-Szaky_300x300.jpg");
INSERT INTO `wp_postmeta` VALUES("18036", "83084", "url_article", "http://www.elempaque.com/asociaciones/ABRE+95209");
INSERT INTO `wp_postmeta` VALUES("18037", "83084", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18038", "83084", "url_picture", "http://www.elempaque.com/documenta/imagenes/101594/ABRE.jpg");
INSERT INTO `wp_postmeta` VALUES("18039", "83085", "url_article", "http://www.elempaque.com/temas/Zubiox,-linea-de-empaques-de-barrera-biodegradables-para-la-industria-alimentaria+122466?tema=4290000");
INSERT INTO `wp_postmeta` VALUES("18040", "83085", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("18041", "83085", "url_picture", "http://www.elempaque.com/documenta/imagenes/128953/zubiox-p.jpg");
INSERT INTO `wp_postmeta` VALUES("18042", "83086", "url_article", "http://www.elempaque.com/asociaciones/ULADE+95226");
INSERT INTO `wp_postmeta` VALUES("18043", "83086", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18044", "83086", "url_picture", "http://www.elempaque.com/documenta/imagenes/101612/ULADE.jpg");
INSERT INTO `wp_postmeta` VALUES("18045", "83087", "url_article", "http://www.elempaque.com/temas/El-florecimiento-de-los-biopolimeros-para-envases+124208?tema=4290000");
INSERT INTO `wp_postmeta` VALUES("18046", "83087", "interes", "20");
INSERT INTO `wp_postmeta` VALUES("18047", "83087", "url_picture", "http://www.elempaque.com/documenta/imagenes/130702/El-florecimiento-de-los-biopolimeros-1-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18048", "83088", "url_article", "http://www.elempaque.com/temas/La-Economia-Circular-en-accion,-un-millon-de-dolares-para-nuevos-materiales-para-abordar-causas-de-plastico-oceanico+123919?tema=4290000");
INSERT INTO `wp_postmeta` VALUES("18049", "83088", "interes", "14");
INSERT INTO `wp_postmeta` VALUES("18050", "83088", "url_picture", "http://www.elempaque.com/documenta/imagenes/130413/economia-circular-millon-de-dolares-para-nuevos-materiales-para-reducir-residuos-plasticos-oceano-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18051", "83089", "url_article", "http://www.elempaque.com/temas/Aditivos-para-acelerar-proceso-de-oxodegradacion-en-empaques-plasticos+122553?tema=4290000");
INSERT INTO `wp_postmeta` VALUES("18052", "83089", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("18053", "83089", "url_picture", "http://www.elempaque.com/documenta/imagenes/129041/tecnologia-oxo-degradable-p.jpg");
INSERT INTO `wp_postmeta` VALUES("18054", "83090", "url_article", "http://www.elempaque.com/temas/rPET-PP*STAR,-bolsa-fabricada-100-con-granulos-de-la-molienda-de-botellas-PET+124071?tema=4290000");
INSERT INTO `wp_postmeta` VALUES("18055", "83090", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("18056", "83090", "url_picture", "http://www.elempaque.com/documenta/imagenes/130565/rPET-PPSTAR-bolsa-de-plegado-fabricada-con-granulos-de-la-molienda-de-botellas-PET-Starlinger-P.jpg");
INSERT INTO `wp_postmeta` VALUES("18057", "83091", "url_article", "http://www.elempaque.com/temas/FibreForm,-nuevo-sustrato-reciclable-para-cajas-plegadizas+104937?tema=4290000");
INSERT INTO `wp_postmeta` VALUES("18058", "83091", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("18059", "83091", "url_picture", "http://www.elempaque.com/documenta/imagenes/111415/104937-P-FibreForm-nuevo-sustrato-reciclable-para-cajas-plegadizas.jpg");
INSERT INTO `wp_postmeta` VALUES("18060", "83092", "url_article", "http://www.elempaque.com/blogs/Sostenibilidad-y-envases,-un-duo-dinamico-en-ascenso+121018");
INSERT INTO `wp_postmeta` VALUES("18061", "83092", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("18062", "83092", "url_picture", "http://www.elempaque.com/documenta/imagenes/101675/Lilian-Robayo_300x300.jpg");
INSERT INTO `wp_postmeta` VALUES("18063", "83093", "url_article", "http://www.elempaque.com/temas/Sello-FSC,-un-atributo-clave-de-los-empaques-a-base-de-papel+118915?tema=4290000");
INSERT INTO `wp_postmeta` VALUES("18064", "83093", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("18065", "83093", "url_picture", "http://www.elempaque.com/documenta/imagenes/125386/ciclo-papel.jpg");
INSERT INTO `wp_postmeta` VALUES("18066", "83094", "url_article", "http://www.elempaque.com/asociaciones/AMEE+95211");
INSERT INTO `wp_postmeta` VALUES("18067", "83094", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("18068", "83094", "url_picture", "http://www.elempaque.com/documenta/imagenes/101596/AMEE.jpg");
INSERT INTO `wp_postmeta` VALUES("18069", "83095", "url_article", "http://www.elempaque.com/temas/Escamas-de-pescado-podrian-sustituir-plastico-en-envases+124502?tema=4290000");
INSERT INTO `wp_postmeta` VALUES("18070", "83095", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("18071", "83095", "url_picture", "http://www.elempaque.com/documenta/imagenes/130996/materiales-elaborados-con-escamas-de-pescado-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18072", "83096", "url_article", "http://www.elempaque.com/blogs/Ideas-interesantes-para-disenar-envases-sostenibles+108124");
INSERT INTO `wp_postmeta` VALUES("18073", "83096", "interes", "20");
INSERT INTO `wp_postmeta` VALUES("18074", "83096", "url_picture", "http://www.elempaque.com/documenta/imagenes/114602/108124-Ideasinteresantes-para-disenar-envases-sostenibles.jpg");
INSERT INTO `wp_postmeta` VALUES("18075", "83097", "url_article", "http://www.elempaque.com/asociaciones/IAE+95222");
INSERT INTO `wp_postmeta` VALUES("18076", "83097", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18077", "83097", "url_picture", "http://www.elempaque.com/documenta/imagenes/101607/Instituto%20Argentino%20del%20Envase.jpg");
INSERT INTO `wp_postmeta` VALUES("18078", "83098", "url_article", "http://www.elempaque.com/temas/ecobottle-line,-linea-de-envases-reciclables-para-productos-liquidos-y-secos+105182?tema=4290000");
INSERT INTO `wp_postmeta` VALUES("18079", "83098", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("18080", "83098", "url_picture", "http://www.elempaque.com/documenta/imagenes/111660/105182-P-Purina-Pro-Plan-Renew-empaque-sostenible-para-residuos-de-mascotas.jpg");
INSERT INTO `wp_postmeta` VALUES("18081", "83099", "url_article", "http://www.elempaque.com/temas/Disenamos,-producimos-y-comercializamos-empaques-bajo-el-concepto-de-eco-empaques+115633?tema=4290000");
INSERT INTO `wp_postmeta` VALUES("18082", "83099", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18083", "83099", "url_picture", "http://www.elempaque.com/documenta/imagenes/122105/img-1.jpg");
INSERT INTO `wp_postmeta` VALUES("18084", "83100", "url_article", "http://www.elempaque.com/asociaciones/WPO+95249");
INSERT INTO `wp_postmeta` VALUES("18085", "83100", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("18086", "83100", "url_picture", "http://www.elempaque.com/documenta/imagenes/101635/World%20Packaging%20Organisation.jpg");
INSERT INTO `wp_postmeta` VALUES("18087", "83101", "url_article", "http://www.elempaque.com/temas/AGROPAKempaca-lo-mejor-de-nuestra-tierra+122043?tema=4290000");
INSERT INTO `wp_postmeta` VALUES("18088", "83101", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("18089", "83101", "url_picture", "http://www.elempaque.com/documenta/imagenes/128530/cajas-para-frutas-y-verduras-p.jpg");
INSERT INTO `wp_postmeta` VALUES("18090", "83102", "url_article", "http://www.elempaque.com/temas/Sostenibilidad?caso=Post&pagina=1");
INSERT INTO `wp_postmeta` VALUES("18091", "83102", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("18092", "83103", "url_article", "http://www.elempaque.com/asociaciones/PMMI+95246");
INSERT INTO `wp_postmeta` VALUES("18093", "83103", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("18094", "83103", "url_picture", "http://www.elempaque.com/documenta/imagenes/101632/Packaging%20Machinery%20Manufacturers%20Institute.jpg");
INSERT INTO `wp_postmeta` VALUES("18095", "83104", "url_article", "http://www.elempaque.com/temas/INECO-ofrece-maquinaria-para-la-conversion-de-plasticos-y-procesos-de-envasado+107902?tema=4290000");
INSERT INTO `wp_postmeta` VALUES("18096", "83104", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18097", "83104", "url_picture", "http://www.elempaque.com/documenta/imagenes/114380/maquinas-para-produccion-de-bolsas-p1.jpg");
INSERT INTO `wp_postmeta` VALUES("18098", "83105", "url_article", "http://www.elempaque.com/temas/ProcteryGamble-lanza-botella-fabricada-100-de-plastico-reciclado+124072?tema=4290000");
INSERT INTO `wp_postmeta` VALUES("18099", "83105", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("18100", "83105", "url_picture", "http://www.elempaque.com/documenta/imagenes/130566/Fairy-Ocean-Plastic-botellas-plastica-de-Procter-and-Gamble-fabricada-de-plastico-reciclado-del-oceano-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18101", "83106", "url_article", "http://www.elempaque.com/asociaciones/ITENE+95259");
INSERT INTO `wp_postmeta` VALUES("18102", "83106", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("18103", "83106", "url_picture", "http://www.elempaque.com/documenta/imagenes/101645/ITENE.jpg");
INSERT INTO `wp_postmeta` VALUES("18104", "83107", "url_article", "http://www.elempaque.com/temas/DuraClear-2000,-polietileno-biodegradable-de-baja-densidad-lineal-mejorada+106384?tema=4290000");
INSERT INTO `wp_postmeta` VALUES("18105", "83107", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("18106", "83107", "url_picture", "http://www.elempaque.com/documenta/imagenes/112862/106384-P-DuraClear-2000-polietileno-biodegradable-de-baja-densidad-lineal-mejorada.jpg");
INSERT INTO `wp_postmeta` VALUES("18107", "83108", "url_article", "http://www.elempaque.com/temas/Polimerica,-una-empresa-sostenible+118875?tema=4290000");
INSERT INTO `wp_postmeta` VALUES("18108", "83108", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("18109", "83108", "url_picture", "http://www.elempaque.com/documenta/imagenes/125346/10-p.jpg");
INSERT INTO `wp_postmeta` VALUES("18110", "83109", "url_article", "http://www.elempaque.com/eventos/Modulo-9,-Temas-selectos-de-envase-y-embalaje+123735");
INSERT INTO `wp_postmeta` VALUES("18111", "83109", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("18112", "83109", "url_picture", "http://www.elempaque.com/documenta/imagenes/130229/modulo-9-temas-selectos-de-envase-y-embalaje.jpg");
INSERT INTO `wp_postmeta` VALUES("18113", "83110", "url_article", "http://www.elempaque.com/temas/Sostenibilidad?caso=Noticias-y-articulos&pagina=1");
INSERT INTO `wp_postmeta` VALUES("18114", "83110", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("18115", "83111", "url_article", "http://www.elempaque.com/temas/Sostenibilidad?caso=Productos&pagina=1");
INSERT INTO `wp_postmeta` VALUES("18116", "83111", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("18117", "83112", "url_article", "http://www.elempaque.com/temas/Cinemark-innova-con-el-Peelable-IML,-un-envase-sostenible-para-palomitas-de-maiz+124092?tema=4290000");
INSERT INTO `wp_postmeta` VALUES("18118", "83112", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("18119", "83112", "url_picture", "http://www.elempaque.com/documenta/imagenes/130586/envases-IML-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18120", "83113", "url_article", "http://www.elempaque.com/temas/Sostenibilidad?caso=Informaciones-comerciales&pagina=1");
INSERT INTO `wp_postmeta` VALUES("18121", "83113", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("18122", "83114", "url_article", "http://www.elempaque.com/blogs/Empaques-que-no-dejan-residuos,-utopia-o-realidad+112036");
INSERT INTO `wp_postmeta` VALUES("18123", "83114", "interes", "20");
INSERT INTO `wp_postmeta` VALUES("18124", "83114", "url_picture", "http://www.elempaque.com/documenta/imagenes/118513/Empaques-que-no-dejan-residuos-utopia-o-realidad-G5.jpg");
INSERT INTO `wp_postmeta` VALUES("18125", "83115", "url_article", "http://www.elempaque.com/blogs/El-mito-de-la-biodegradabilidad-Parte-1,-la-campana-por-los-bioplasticos+110561");
INSERT INTO `wp_postmeta` VALUES("18126", "83115", "interes", "14");
INSERT INTO `wp_postmeta` VALUES("18127", "83115", "url_picture", "http://www.elempaque.com/documenta/imagenes/101717/Tom-Szaky_300x300.jpg");
INSERT INTO `wp_postmeta` VALUES("18128", "83116", "url_article", "http://www.elempaque.com/temas/Materiales?caso=Asociaciones&pagina=1");
INSERT INTO `wp_postmeta` VALUES("18129", "83116", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18130", "83117", "url_article", "http://www.elempaque.com/asociaciones/CENEM+95215");
INSERT INTO `wp_postmeta` VALUES("18131", "83117", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18132", "83117", "url_picture", "http://www.elempaque.com/documenta/imagenes/101600/Centro%20de%20Envases%20y%20Embalajes%20de%20Chile.jpg");
INSERT INTO `wp_postmeta` VALUES("18133", "83118", "url_article", "http://www.elempaque.com/temas/Papeles-calidad-premium-para-empaques-de-lujo-y-etiquetas+122161?tema=4240000");
INSERT INTO `wp_postmeta` VALUES("18134", "83118", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("18135", "83118", "url_picture", "http://www.elempaque.com/documenta/imagenes/128648/papeles-premium-neenah-paper-myr-international-Andina-Pack-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18136", "83119", "url_article", "http://www.elempaque.com/temas/Papel-y-carton");
INSERT INTO `wp_postmeta` VALUES("18137", "83119", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("18138", "83120", "url_article", "http://www.elempaque.com/temas/Amcor-se-compromete-a-fabricar-envases-100-reciclables-o-reutilizables-para-2025+124107?tema=4290000");
INSERT INTO `wp_postmeta` VALUES("18139", "83120", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("18140", "83120", "url_picture", "http://www.elempaque.com/documenta/imagenes/130601/Amcor-se-compromete-a-fabricar-envases-reciclables-y-reutilizables-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18141", "83121", "url_article", "http://www.elempaque.com/asociaciones/BPI+95253");
INSERT INTO `wp_postmeta` VALUES("18142", "83121", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("18143", "83121", "url_picture", "http://www.elempaque.com/documenta/imagenes/101639/Sleutel-LOGO_IBE-BVI-jpeg.jpg");
INSERT INTO `wp_postmeta` VALUES("18144", "83122", "url_article", "http://www.elempaque.com/asociaciones/CETEA+95218");
INSERT INTO `wp_postmeta` VALUES("18145", "83122", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18146", "83122", "url_picture", "http://www.elempaque.com/documenta/imagenes/101603/CETEA.jpg");
INSERT INTO `wp_postmeta` VALUES("18147", "83123", "url_article", "http://www.elempaque.com/asociaciones/CPA+95257");
INSERT INTO `wp_postmeta` VALUES("18148", "83123", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18149", "83123", "url_picture", "http://www.elempaque.com/documenta/imagenes/101643/China%20(Taipei)%20Packaging%20Association.jpg");
INSERT INTO `wp_postmeta` VALUES("18150", "83124", "url_article", "http://www.elempaque.com/temas/Novedosa-linea-de-cartulinas-de-bagazo-de-cana-de-azucar-para-cajas-plegadizas-Propal-Poly-PE1S+122145?tema=4240000");
INSERT INTO `wp_postmeta` VALUES("18151", "83124", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("18152", "83124", "url_picture", "http://www.elempaque.com/documenta/imagenes/128632/PROPAL-Poly%20PE1S--nueva-linea-papeles-cartulinas-Propal-Andina-Pack-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18153", "83125", "url_article", "http://www.elempaque.com/temas/NATIVIA-NESS,-primera-pelicula-de-base-biologica-con-apariencia-de-papel+120553?tema=4240000");
INSERT INTO `wp_postmeta` VALUES("18154", "83125", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("18155", "83125", "url_picture", "http://www.elempaque.com/documenta/imagenes/127024/pelicula-biobasada-NATIVIA-NESS-Taghleef-Industries-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18156", "83126", "url_article", "http://www.elempaque.com/temas/Plantean-impuesto-ambiental-a-la-oferta-y-consumo-de-envases-desechables-PET+124504?tema=4240000");
INSERT INTO `wp_postmeta` VALUES("18157", "83126", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("18158", "83126", "url_picture", "http://www.elempaque.com/documenta/contenido/130998/senador-oscar-roman-rosas-del-PRI-autor-propuesta-impuetso-al-PET-en-Mexico-pq.fw.png");
INSERT INTO `wp_postmeta` VALUES("18159", "83127", "url_article", "http://www.elempaque.com/temas/Mercado-mundial-de-masterbatches-espera-alcanzar-los-USD-15810-millones-para-2025+124263?tema=4240000");
INSERT INTO `wp_postmeta` VALUES("18160", "83127", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("18161", "83127", "url_picture", "http://www.elempaque.com/documenta/imagenes/130757/Mercado-mundial-de-masterbatches-espera-alcanzar-los-15-81-billones-de-dolares-para-2025-P.jpg");
INSERT INTO `wp_postmeta` VALUES("18162", "83128", "url_article", "http://www.elempaque.com/blogs/La-innovacion-y-el-nuevo-rol-de-los-envases+118766");
INSERT INTO `wp_postmeta` VALUES("18163", "83128", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("18164", "83128", "url_picture", "http://www.elempaque.com/documenta/imagenes/101675/Lilian-Robayo_300x300.jpg");
INSERT INTO `wp_postmeta` VALUES("18165", "83129", "url_article", "http://www.elempaque.com/eventos/CCE-International-2019+120590");
INSERT INTO `wp_postmeta` VALUES("18166", "83129", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("18167", "83129", "url_picture", "http://www.elempaque.com:80/documenta/imagenes/127061/CCE-International.jpg");
INSERT INTO `wp_postmeta` VALUES("18168", "83130", "url_article", "http://www.elempaque.com/temas/Tintas-termocromaticas-hacen-debut-comercial-con-envase-de-Coca-Cola+124052?tema=4240000");
INSERT INTO `wp_postmeta` VALUES("18169", "83130", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18170", "83130", "url_picture", "http://www.elempaque.com/documenta/imagenes/130546/Tintas-termocromaticas-en-envase-Coca-Cola-pq-3.jpg");
INSERT INTO `wp_postmeta` VALUES("18171", "83131", "url_article", "http://www.elempaque.com/temas/Chroma-Plus,-linea-de-tintas-base-agua-para-impresoras-digitales-Xante+123472?tema=4240000");
INSERT INTO `wp_postmeta` VALUES("18172", "83131", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("18173", "83131", "url_picture", "http://www.elempaque.com/documenta/imagenes/129966/logo-xante.jpg");
INSERT INTO `wp_postmeta` VALUES("18174", "83132", "url_article", "http://www.elempaque.com/temas/Materiales?caso=Informaciones-comerciales&pagina=1");
INSERT INTO `wp_postmeta` VALUES("18175", "83132", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18176", "83133", "url_article", "http://www.elempaque.com/asociaciones/BFSV-IFE+95261");
INSERT INTO `wp_postmeta` VALUES("18177", "83133", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18178", "83133", "url_picture", "http://www.elempaque.com/documenta/imagenes/101647/BFSV.jpg");
INSERT INTO `wp_postmeta` VALUES("18179", "83134", "url_article", "http://www.elempaque.com/asociaciones/ASPACK+95251");
INSERT INTO `wp_postmeta` VALUES("18180", "83134", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("18181", "83134", "url_picture", "http://www.elempaque.com/documenta/imagenes/101637/95251-ASPACK.jpg");
INSERT INTO `wp_postmeta` VALUES("18182", "83135", "url_article", "http://www.elempaque.com/temas/Jowat-Toptherm,-nueva-linea-de-adhesivos-especiales-para-empaques-de-papel+124340?tema=4240000");
INSERT INTO `wp_postmeta` VALUES("18183", "83135", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("18184", "83135", "url_picture", "http://www.elempaque.com/documenta/imagenes/130834/logo-een.jpg");
INSERT INTO `wp_postmeta` VALUES("18185", "83136", "url_article", "http://www.elempaque.com/guia-de-proveedores/empresas/Zubex-Industrial-SA+516251?showroom=110632");
INSERT INTO `wp_postmeta` VALUES("18186", "83136", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18187", "83136", "url_picture", "http://www.elempaque.com:80/documenta/imagenes/117110/Subex-200.jpg");
INSERT INTO `wp_postmeta` VALUES("18188", "83137", "url_article", "http://www.elempaque.com/eventos/Fach-Pack-2018+120615");
INSERT INTO `wp_postmeta` VALUES("18189", "83137", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("18190", "83137", "url_picture", "http://www.elempaque.com:80/documenta/imagenes/127086/Fach-Pack-2018.fw.png");
INSERT INTO `wp_postmeta` VALUES("18191", "83138", "url_article", "http://www.elempaque.com/temas/Segunda-Cumbre-Latinoamericana-de-Innovacion-en-Envases-Plasticos-calienta-sus-motores+121384?tema=4240000");
INSERT INTO `wp_postmeta` VALUES("18192", "83138", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("18193", "83138", "url_picture", "http://www.elempaque.com/documenta/imagenes/127863/cumbre-1-p.jpg");
INSERT INTO `wp_postmeta` VALUES("18194", "83139", "url_article", "http://www.elempaque.com/asociaciones/ACIMGA+99427");
INSERT INTO `wp_postmeta` VALUES("18195", "83139", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("18196", "83139", "url_picture", "http://www.elempaque.com/documenta/imagenes/105824/99427-ACIMGA.jpg");
INSERT INTO `wp_postmeta` VALUES("18197", "83140", "url_article", "http://www.elempaque.com/temas/NPE-2018,-una-inmersion-en-el-mundo-de-los-plasticos+124186?tema=4240000");
INSERT INTO `wp_postmeta` VALUES("18198", "83140", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("18199", "83140", "url_picture", "http://www.elempaque.com/documenta/imagenes/130680/NPE-2018-una-inmersion-ene-el-mundo%20de-los-plasticos-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18200", "83141", "url_article", "http://www.elempaque.com/blogs/Tom-Szaky,-Se-reducirian-los-residuos-si-creamos-impuestos-por-usar-materiales-virgenes+95311");
INSERT INTO `wp_postmeta` VALUES("18201", "83141", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("18202", "83141", "url_picture", "http://www.elempaque.com/documenta/imagenes/101717/Tom-Szaky_300x300.jpg");
INSERT INTO `wp_postmeta` VALUES("18203", "83142", "url_article", "http://www.elempaque.com/temas/AGROPAKempaca-lo-mejor-de-nuestra-tierra+122043?tema=4240000");
INSERT INTO `wp_postmeta` VALUES("18204", "83142", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("18205", "83142", "url_picture", "http://www.elempaque.com/documenta/imagenes/128530/cajas-para-frutas-y-verduras-p.jpg");
INSERT INTO `wp_postmeta` VALUES("18206", "83143", "url_article", "http://www.elempaque.com/temas/El-florecimiento-de-los-biopolimeros-para-envases+124208?tema=4240000");
INSERT INTO `wp_postmeta` VALUES("18207", "83143", "interes", "20");
INSERT INTO `wp_postmeta` VALUES("18208", "83143", "url_picture", "http://www.elempaque.com/documenta/imagenes/130702/El-florecimiento-de-los-biopolimeros-1-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18209", "83144", "url_article", "http://www.elempaque.com/temas/La-Economia-Circular-en-accion,-un-millon-de-dolares-para-nuevos-materiales-para-abordar-causas-de-plastico-oceanico+123919?tema=4240000");
INSERT INTO `wp_postmeta` VALUES("18210", "83144", "interes", "14");
INSERT INTO `wp_postmeta` VALUES("18211", "83144", "url_picture", "http://www.elempaque.com/documenta/imagenes/130413/economia-circular-millon-de-dolares-para-nuevos-materiales-para-reducir-residuos-plasticos-oceano-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18212", "83145", "url_article", "http://www.elempaque.com/temas/ESENTTIA,-aliado-vital-en-el-desarrollo-de-empaques+121493?tema=4240000");
INSERT INTO `wp_postmeta` VALUES("18213", "83145", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("18214", "83145", "url_picture", "http://www.elempaque.com/documenta/imagenes/127980/esenttia.jpg");
INSERT INTO `wp_postmeta` VALUES("18215", "83146", "url_article", "http://www.elempaque.com/temas/Filmtex,-peliculas-calandradas-de-PVC-para-empaques-de-calidad+121968?tema=4240000");
INSERT INTO `wp_postmeta` VALUES("18216", "83146", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18217", "83146", "url_picture", "http://www.elempaque.com/documenta/imagenes/128455/pvc-filmtex-p.jpg");
INSERT INTO `wp_postmeta` VALUES("18218", "83147", "url_article", "http://www.elempaque.com/temas/Aditivos-para-acelerar-proceso-de-oxodegradacion-en-empaques-plasticos+122553?tema=4240000");
INSERT INTO `wp_postmeta` VALUES("18219", "83147", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("18220", "83147", "url_picture", "http://www.elempaque.com/documenta/imagenes/129041/tecnologia-oxo-degradable-p.jpg");
INSERT INTO `wp_postmeta` VALUES("18221", "83148", "url_article", "http://www.elempaque.com/temas/Nuevas-tintas-y-recubrimientos-ecologicos-para-empaques-de-alimentos-INXhrc+120529?tema=4240000");
INSERT INTO `wp_postmeta` VALUES("18222", "83148", "interes", "14");
INSERT INTO `wp_postmeta` VALUES("18223", "83148", "url_picture", "http://www.elempaque.com/documenta/imagenes/127000/tintas-ecologicas-recubrimientos-ecologicos-INXhrc-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18224", "83149", "url_article", "http://www.elempaque.com/asociaciones/DVI+95258");
INSERT INTO `wp_postmeta` VALUES("18225", "83149", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("18226", "83149", "url_picture", "http://www.elempaque.com/documenta/imagenes/101644/DVI.jpg");
INSERT INTO `wp_postmeta` VALUES("18227", "83150", "url_article", "http://www.elempaque.com/eventos/Ipack-Ima-2018+113312");
INSERT INTO `wp_postmeta` VALUES("18228", "83150", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("18229", "83150", "url_picture", "http://www.elempaque.com:80/documenta/imagenes/119785/Ipak-Ima-2018.jpg");
INSERT INTO `wp_postmeta` VALUES("18230", "83151", "url_article", "http://www.elempaque.com/asociaciones/CNE+95255");
INSERT INTO `wp_postmeta` VALUES("18231", "83151", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18232", "83151", "url_picture", "http://www.elempaque.com/documenta/imagenes/101641/Centro%20Nacional%20de%20Embalagem.jpg");
INSERT INTO `wp_postmeta` VALUES("18233", "83152", "url_article", "http://www.elempaque.com/temas/Materiales?caso=Productos&pagina=1");
INSERT INTO `wp_postmeta` VALUES("18234", "83152", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18235", "83153", "url_article", "http://www.elempaque.com/temas/Lideres-de-los-sectores-de-empaque-y-plastico-se-reuniran-en-NPE2018+121178?tema=4240000");
INSERT INTO `wp_postmeta` VALUES("18236", "83153", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("18237", "83153", "url_picture", "http://www.elempaque.com/documenta/imagenes/127657/npe-1-p.jpg");
INSERT INTO `wp_postmeta` VALUES("18238", "83154", "url_article", "http://www.elempaque.com/eventos/Hispack-2018+119685");
INSERT INTO `wp_postmeta` VALUES("18239", "83154", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("18240", "83154", "url_picture", "http://www.elempaque.com:80/documenta/imagenes/126156/Hispack-2018.jpg");
INSERT INTO `wp_postmeta` VALUES("18241", "83155", "url_article", "http://www.elempaque.com/temas/Materiales?caso=Noticias-y-articulos&pagina=1");
INSERT INTO `wp_postmeta` VALUES("18242", "83155", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18243", "83156", "url_article", "http://www.elempaque.com/temas/Escamas-de-pescado-podrian-sustituir-plastico-en-envases+124502?tema=4240000");
INSERT INTO `wp_postmeta` VALUES("18244", "83156", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("18245", "83156", "url_picture", "http://www.elempaque.com/documenta/imagenes/130996/materiales-elaborados-con-escamas-de-pescado-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18246", "83157", "url_article", "http://www.elempaque.com/temas/Jowat-Toptherm,-nueva-linea-de-adhesivos-de-fusion-en-caliente-basados-en-poliolefina+123642?tema=4240000");
INSERT INTO `wp_postmeta` VALUES("18247", "83157", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("18248", "83157", "url_picture", "http://www.elempaque.com/documenta/imagenes/130136/Adhesivos-hot-melt-basado-en-poliolefina-Jowat-Toptherm-Jowat-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18249", "83158", "url_article", "http://www.elempaque.com/asociaciones/ABIEF+95206");
INSERT INTO `wp_postmeta` VALUES("18250", "83158", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("18251", "83158", "url_picture", "http://www.elempaque.com/documenta/imagenes/101591/ABIEF.jpg");
INSERT INTO `wp_postmeta` VALUES("18252", "83159", "url_article", "http://www.elempaque.com/temas/Plastico");
INSERT INTO `wp_postmeta` VALUES("18253", "83159", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("18254", "83160", "url_article", "http://www.elempaque.com/blogs/Aspectos-fundamentales-en-tintas-de-impresion-para-empaques+120398");
INSERT INTO `wp_postmeta` VALUES("18255", "83160", "interes", "16");
INSERT INTO `wp_postmeta` VALUES("18256", "83160", "url_picture", "http://www.elempaque.com/documenta/imagenes/116969/Wilmer-Saavedra.jpg");
INSERT INTO `wp_postmeta` VALUES("18257", "83161", "url_article", "http://www.elempaque.com/blogs/El-packaging-de-Pavlov+100582");
INSERT INTO `wp_postmeta` VALUES("18258", "83161", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("18259", "83161", "url_picture", "http://www.elempaque.com/documenta/imagenes/106983/100582-post-patatas-fritas.jpg");
INSERT INTO `wp_postmeta` VALUES("18260", "83162", "url_article", "http://www.elempaque.com/blogs/Biodegradable-versus-reciclable,-Cual-solucion-de-empaque-es-mejor+95328");
INSERT INTO `wp_postmeta` VALUES("18261", "83162", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("18262", "83162", "url_picture", "http://www.elempaque.com/documenta/imagenes/101717/Tom-Szaky_300x300.jpg");
INSERT INTO `wp_postmeta` VALUES("18263", "83163", "url_article", "http://www.elempaque.com/eventos/Expo-Plast-Peru+122884");
INSERT INTO `wp_postmeta` VALUES("18264", "83163", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("18265", "83163", "url_picture", "http://www.elempaque.com:80/documenta/imagenes/129372/Expo-Plast-Peru-2018.jpg");
INSERT INTO `wp_postmeta` VALUES("18266", "83164", "url_article", "http://www.elempaque.com/temas/KPeel-Flex-Pet,-pelicula-de-recubrimiento-para-la-fabricacion-de-tapas+121054?tema=4240000");
INSERT INTO `wp_postmeta` VALUES("18267", "83164", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18268", "83164", "url_picture", "http://www.elempaque.com/documenta/contenido/127525/pelicula-de-recubrimiento-para-tapas-KM-Packaging-pq.fw.png");
INSERT INTO `wp_postmeta` VALUES("18269", "83165", "url_article", "http://www.elempaque.com/temas/Sistema-integral-para-empacado-de-barritas-de-granola+122851?tema=4110000");
INSERT INTO `wp_postmeta` VALUES("18270", "83165", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("18271", "83165", "url_picture", "http://www.elempaque.com/documenta/imagenes/129339/sistema-empaque-barritas-granola-Bosch-Packaging-2-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18272", "83166", "url_article", "http://www.elempaque.com/temas/Versatil-aplicadora-de-mangas-termocontraibles-para-potes-termoformados-y-preformados+122392?tema=4110000");
INSERT INTO `wp_postmeta` VALUES("18273", "83166", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("18274", "83166", "url_picture", "http://www.elempaque.com/documenta/imagenes/128879/G21-Goglio-maquina-fabricacion-de-empaques-y-valvulas-de-cafe-Verpacken-gr.jpg");
INSERT INTO `wp_postmeta` VALUES("18275", "83167", "url_article", "http://www.elempaque.com/temas/Marcado-y-codificacion");
INSERT INTO `wp_postmeta` VALUES("18276", "83167", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18277", "83168", "url_article", "http://www.elempaque.com/temas/Tecnoembalaje-presento-soluciones-para-empacado-en-el-sector-de-embutidos+123101?tema=4110000");
INSERT INTO `wp_postmeta` VALUES("18278", "83168", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("18279", "83168", "url_picture", "http://www.elempaque.com/documenta/imagenes/129589/Tecnoembalaje-Kompo-North-America-equipos-procesamiento-y-empaque-de-embutidos-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18280", "83169", "url_article", "http://www.elempaque.com/temas/Procesos-de-envasado?caso=Productos&pagina=1");
INSERT INTO `wp_postmeta` VALUES("18281", "83169", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18282", "83170", "url_article", "http://www.elempaque.com/eventos/Expo-Pack-Mexico-2018+121837");
INSERT INTO `wp_postmeta` VALUES("18283", "83170", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("18284", "83170", "url_picture", "http://www.elempaque.com:80/documenta/imagenes/128324/Expo-Pack-2018.jpg");
INSERT INTO `wp_postmeta` VALUES("18285", "83171", "url_article", "http://www.elempaque.com/temas/Robots-para-paletizado-con-movimientos-de-alta-precision+122157?tema=4110000");
INSERT INTO `wp_postmeta` VALUES("18286", "83171", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("18287", "83171", "url_picture", "http://www.elempaque.com/documenta/imagenes/128644/Robots-Paletizado-CAVINGENIEROS-Kuka-Andina-Pack-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18288", "83172", "url_article", "http://www.elempaque.com/temas/Procesos-de-envasado?caso=Informaciones-comerciales&pagina=1");
INSERT INTO `wp_postmeta` VALUES("18289", "83172", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18290", "83173", "url_article", "http://www.elempaque.com/temas/Sellador-de-vacio-tipo-boquilla-para-bolsas,-LMV-6010TG+123721?tema=4110000");
INSERT INTO `wp_postmeta` VALUES("18291", "83173", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("18292", "83173", "url_picture", "http://www.elempaque.com/documenta/imagenes/130215/sellador-vacio.jpg");
INSERT INTO `wp_postmeta` VALUES("18293", "83174", "url_article", "http://www.elempaque.com/guia-de-proveedores/empresas/Mitsubishi-Electric+515608?showroom=96181");
INSERT INTO `wp_postmeta` VALUES("18294", "83174", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("18295", "83174", "url_picture", "http://www.elempaque.com:80/documenta/imagenes/102561/Mitsubishi-Electric-logo.jpg");
INSERT INTO `wp_postmeta` VALUES("18296", "83175", "url_article", "http://www.elempaque.com/temas/Robot-de-precision-manipula-piezas-diminutas-en-linea-de-ensamble-y-empaque-de-audifonos+123789?tema=4110000");
INSERT INTO `wp_postmeta` VALUES("18297", "83175", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18298", "83175", "url_picture", "http://www.elempaque.com/documenta/imagenes/130283/ur3-one-hand.jpg");
INSERT INTO `wp_postmeta` VALUES("18299", "83176", "url_article", "http://www.elempaque.com/temas/Etiquetado");
INSERT INTO `wp_postmeta` VALUES("18300", "83176", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18301", "83177", "url_article", "http://www.elempaque.com/temas/Procesos-de-envasado?caso=Eventos-de-la-industria&pagina=1");
INSERT INTO `wp_postmeta` VALUES("18302", "83177", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18303", "83178", "url_article", "http://www.elempaque.com/temas/Tendencias-en-la-produccion-de-envases+123447?tema=4110000");
INSERT INTO `wp_postmeta` VALUES("18304", "83178", "interes", "14");
INSERT INTO `wp_postmeta` VALUES("18305", "83178", "url_picture", "http://www.elempaque.com/documenta/imagenes/129940/tendencias-en-produccion-de-envases-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18306", "83179", "url_article", "http://www.elempaque.com/blogs/Un-evento-unico-en-innovacion-en-envases-plasticos+116666");
INSERT INTO `wp_postmeta` VALUES("18307", "83179", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("18308", "83179", "url_picture", "http://www.elempaque.com/documenta/imagenes/101675/Lilian-Robayo_300x300.jpg");
INSERT INTO `wp_postmeta` VALUES("18309", "83180", "url_article", "http://www.elempaque.com/temas/Yamato,-lider-mundial-en-equipos-de-pesaje+123722?tema=4110000");
INSERT INTO `wp_postmeta` VALUES("18310", "83180", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18311", "83180", "url_picture", "http://www.elempaque.com/documenta/imagenes/130216/alphaadv1-p.jpg");
INSERT INTO `wp_postmeta` VALUES("18312", "83181", "url_article", "http://www.elempaque.com/eventos/Modulo-7,-Sistemas-de-Cierre+123731");
INSERT INTO `wp_postmeta` VALUES("18313", "83181", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18314", "83181", "url_picture", "http://www.elempaque.com:80/documenta/imagenes/130225/modulo-7-sistemas-de-cierre.jpg");
INSERT INTO `wp_postmeta` VALUES("18315", "83182", "url_article", "http://www.elempaque.com/temas/Finalizo-adquisicion-de-Pro-Mach-por-parte-de-Leonard-Green-y-Partners+123745?tema=4110000");
INSERT INTO `wp_postmeta` VALUES("18316", "83182", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18317", "83182", "url_picture", "http://www.elempaque.com/documenta/imagenes/130239/Leonard-Green-and-Prartners-adquiere-ProMach-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18318", "83183", "url_article", "http://www.elempaque.com/temas/Bombas-de-vacio-de-paletas-rotativas-con-sistema-de-eficiencia-energetica-R5+122903?tema=4110000");
INSERT INTO `wp_postmeta` VALUES("18319", "83183", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("18320", "83183", "url_picture", "http://www.elempaque.com/documenta/imagenes/129391/Bombas-de-vacio-R5-con-sistema-de-eficiencia-energetica--Busch-Vacuum-Mexico-Andina-Pack-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18321", "83184", "url_article", "http://www.elempaque.com/temas/Lineas-de-alta-velocidad-para-empaque-y-embotellado,-de-ACMI+123100?tema=4110000");
INSERT INTO `wp_postmeta` VALUES("18322", "83184", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18323", "83184", "url_picture", "http://www.elempaque.com/documenta/imagenes/129588/Lineas-de-empaque-y-embotellado-de-ACMI-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18324", "83185", "url_article", "http://www.elempaque.com/eventos/Fispal-Tecnologia-2018+120585");
INSERT INTO `wp_postmeta` VALUES("18325", "83185", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("18326", "83185", "url_picture", "http://www.elempaque.com:80/documenta/imagenes/127056/Fispal-Tecnologia.jpg");
INSERT INTO `wp_postmeta` VALUES("18327", "83186", "url_article", "http://www.elempaque.com/temas/Su-marca-tiene-el-ADN-de-la-innovacion-Esta-es-una-oportunidad-que-no-se-puede-perder+124069?tema=4110000");
INSERT INTO `wp_postmeta` VALUES("18328", "83186", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("18329", "83186", "url_picture", "http://www.elempaque.com/documenta/imagenes/130563/muestra-comercial-cumbre-1.jpg");
INSERT INTO `wp_postmeta` VALUES("18330", "83187", "url_article", "http://www.elempaque.com/eventos/Fispal-2018+123813");
INSERT INTO `wp_postmeta` VALUES("18331", "83187", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("18332", "83187", "url_picture", "http://www.elempaque.com:80/documenta/imagenes/130307/Fispal-2018.fw.png");
INSERT INTO `wp_postmeta` VALUES("18333", "83188", "url_article", "http://www.elempaque.com/temas/Procesos-de-envasado?caso=Catalogos-de-productos&pagina=1");
INSERT INTO `wp_postmeta` VALUES("18334", "83188", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18335", "83189", "url_article", "http://www.elempaque.com/temas/Enfajadora-semiautomatica-BP800-con-estructura-monobloque+122159?tema=4110000");
INSERT INTO `wp_postmeta` VALUES("18336", "83189", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18337", "83189", "url_picture", "http://www.elempaque.com/documenta/imagenes/128646/enfajadora-semiautomatica-BP800-Pagoma-Andina-Pack-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18338", "83190", "url_article", "http://www.elempaque.com/temas/Empacadora-automatica-de-bandejas-Waldyssa-Piu-75,-para-hipermercados+122164?tema=4110000");
INSERT INTO `wp_postmeta` VALUES("18339", "83190", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18340", "83190", "url_picture", "http://www.elempaque.com/documenta/contenido/128651/empacadora-bandejas-waldyssa-piu-75-teixpac-tecnoembalaje-andina-pack-pq.fw.png");
INSERT INTO `wp_postmeta` VALUES("18341", "83191", "url_article", "http://www.elempaque.com/eventos/Interphex-2018+120597");
INSERT INTO `wp_postmeta` VALUES("18342", "83191", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18343", "83191", "url_picture", "http://www.elempaque.com:80/documenta/imagenes/127068/interphex.jpg");
INSERT INTO `wp_postmeta` VALUES("18344", "83192", "url_article", "http://www.elempaque.com/temas/Detectores-de-metales-sin-obsolescencia+105195?tema=4110000");
INSERT INTO `wp_postmeta` VALUES("18345", "83192", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("18346", "83192", "url_picture", "http://www.elempaque.com/documenta/imagenes/111673/Fortress-BBK-p.jpg");
INSERT INTO `wp_postmeta` VALUES("18347", "83193", "url_article", "http://www.elempaque.com/temas/Innovadora-tecnologia-para-envasar-platos-prelistos-y-refrigerados+124080?tema=4110000");
INSERT INTO `wp_postmeta` VALUES("18348", "83193", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("18349", "83193", "url_picture", "http://www.elempaque.com/documenta/imagenes/130574/Micvac-Innovadora-tecnologia-para-envasar-platos-pre-listos-y-refrigerados-p1.jpg");
INSERT INTO `wp_postmeta` VALUES("18350", "83194", "url_article", "http://www.elempaque.com/temas/Procesos-de-envasado?caso=Asociaciones&pagina=1");
INSERT INTO `wp_postmeta` VALUES("18351", "83194", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18352", "83195", "url_article", "http://ec.europa.eu/environment/integration/research/newsalert/pdf/283na6_en.pdf");
INSERT INTO `wp_postmeta` VALUES("18353", "83195", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18354", "83196", "url_article", "http://www.elempaque.com/guia-de-proveedores/empresas/Yamato-Corporation+509905?showroom=102810");
INSERT INTO `wp_postmeta` VALUES("18355", "83196", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18356", "83196", "url_picture", "http://www.elempaque.com:80/documenta/imagenes/109290/showroom-Yamato.jpg");
INSERT INTO `wp_postmeta` VALUES("18357", "83197", "url_article", "http://www.elempaque.com/temas/Formadollenadosellado");
INSERT INTO `wp_postmeta` VALUES("18358", "83197", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18359", "83198", "url_article", "http://www.elempaque.com/guia-de-proveedores/empresas/Zhongshan-Multiweigh-Packaging-Machinery-Co,-Ltd+349869?showroom=105021");
INSERT INTO `wp_postmeta` VALUES("18360", "83198", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18361", "83198", "url_picture", "http://www.elempaque.com:80/documenta/imagenes/111499/logo-zhongshan-200x200.jpg");
INSERT INTO `wp_postmeta` VALUES("18362", "83199", "url_article", "http://www.elempaque.com/eventos/Sistemas-de-embalaje-y-trasporte-de-mercancias+123660");
INSERT INTO `wp_postmeta` VALUES("18363", "83199", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("18364", "83199", "url_picture", "http://www.elempaque.com/documenta/imagenes/130154/Sistemas-de-embalaje-y-transporte-de-mercancias-4.jpg");
INSERT INTO `wp_postmeta` VALUES("18365", "83200", "url_article", "http://www.elempaque.com/temas/Twisterbox,-novedoso-equipo-para-acumulacion-y-organizacion-automatica-de-embalajes+122162?tema=4110000");
INSERT INTO `wp_postmeta` VALUES("18366", "83200", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18367", "83200", "url_picture", "http://www.elempaque.com/documenta/contenido/128649/Twisterbox-acumulador-organizador-de-embalajes-Verpacken-ACMI-pq.fw.png");
INSERT INTO `wp_postmeta` VALUES("18368", "83201", "url_article", "http://www.elempaque.com/eventos/Modulo-8,-Embalaje-de-productos,-almacenamiento-y-distribucion+123733");
INSERT INTO `wp_postmeta` VALUES("18369", "83201", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18370", "83201", "url_picture", "http://www.elempaque.com/documenta/imagenes/130227/modulo-8-embalaje-de-productos-almacenamiento-y-distribucion.jpg");
INSERT INTO `wp_postmeta` VALUES("18371", "83202", "url_article", "http://www.elempaque.com/temas/Conozca-cuales-son-las-tendencias-clave-en-empaque-para-Latinoamerica,-en-2018+123609?tema=4110000");
INSERT INTO `wp_postmeta` VALUES("18372", "83202", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("18373", "83202", "url_picture", "http://www.elempaque.com/documenta/imagenes/130103/tendencias-clave-en-empaque-para-Latinoamerica-en-2018-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18374", "83203", "url_article", "http://www.elempaque.com/blogs/La-cuarta-revolucion-industrial-y-la-manufactura-de-los-envases+114128");
INSERT INTO `wp_postmeta` VALUES("18375", "83203", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("18376", "83203", "url_picture", "http://www.elempaque.com/documenta/imagenes/101675/Lilian-Robayo_300x300.jpg");
INSERT INTO `wp_postmeta` VALUES("18377", "83204", "url_article", "http://www.elempaque.com/temas/Trojan-2,-impresion-inkjet-de-alta-calidad-para-etiquetas+122144?tema=4110000");
INSERT INTO `wp_postmeta` VALUES("18378", "83204", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("18379", "83204", "url_picture", "http://www.elempaque.com/documenta/imagenes/128631/Impresora-ink-jet-Trojan-2-Trojanlabel-DAETWYLER-Andina-Pack-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18380", "83205", "url_article", "http://www.elempaque.com/temas/Maquinas-automaticas-para-aplicacion-de-mangas-ASL-1000-y-ASL-2000+123700?tema=4110000");
INSERT INTO `wp_postmeta` VALUES("18381", "83205", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("18382", "83205", "url_picture", "http://www.elempaque.com/documenta/imagenes/130194/aplicador-de-manga-contraible1.jpg");
INSERT INTO `wp_postmeta` VALUES("18383", "83206", "url_article", "http://www.elempaque.com/temas/Procesos-de-envasado?caso=Noticias-y-articulos&pagina=1");
INSERT INTO `wp_postmeta` VALUES("18384", "83206", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18385", "83207", "url_article", "http://www.elempaque.com/eventos/Anuga-FoodTec-2018+124081");
INSERT INTO `wp_postmeta` VALUES("18386", "83207", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("18387", "83207", "url_picture", "http://www.elempaque.com:80/documenta/imagenes/130575/Anuga-Food-Tech.jpg");
INSERT INTO `wp_postmeta` VALUES("18388", "83208", "url_article", "http://www.elempaque.com/blogs/La-fabrica-del-futuro-se-esta-construyendo-hoy+115617");
INSERT INTO `wp_postmeta` VALUES("18389", "83208", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("18390", "83208", "url_picture", "http://www.elempaque.com/documenta/imagenes/101675/Lilian-Robayo_300x300.jpg");
INSERT INTO `wp_postmeta` VALUES("18391", "83209", "url_article", "https://www.rpc-group.com/media/product-news/2018/new-pump-provides-large-dose-of-convenience");
INSERT INTO `wp_postmeta` VALUES("18392", "83209", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("18393", "83209", "url_picture", "https://www.rpc-group.com/~/media/Images/R/RPC-Group/content-images/news-images/2018/bramlage-xl5-main.jpg?h=380&la=en&w=670");
INSERT INTO `wp_postmeta` VALUES("18394", "83210", "url_article", "https://www.rpc-group.com/corporate");
INSERT INTO `wp_postmeta` VALUES("18395", "83210", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("18396", "83210", "url_picture", "https://rpc-group.production.investis.com/~/media/Images/R/RPC-Group/logo/rpc-logo-share.jpg");
INSERT INTO `wp_postmeta` VALUES("18397", "83211", "url_article", "https://www.rpc-group.com/media/product-news/2018/tubes-convey-feeling-of-relaxation");
INSERT INTO `wp_postmeta` VALUES("18398", "83211", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("18399", "83211", "url_picture", "https://www.rpc-group.com/~/media/Images/R/RPC-Group/content-images/news-images/2018/mh-tube-main.jpg?h=380&la=en&w=670");
INSERT INTO `wp_postmeta` VALUES("18400", "83212", "url_article", "https://www.rpc-group.com/");
INSERT INTO `wp_postmeta` VALUES("18401", "83212", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("18402", "83212", "url_picture", "https://rpc-group.production.investis.com/~/media/Images/R/RPC-Group/logo/rpc-logo-share.jpg");
INSERT INTO `wp_postmeta` VALUES("18403", "83213", "url_article", "https://www.rpc-group.com/media/product-news/2018");
INSERT INTO `wp_postmeta` VALUES("18404", "83213", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("18405", "83213", "url_picture", "https://rpc-group.production.investis.com/~/media/Images/R/RPC-Group/logo/rpc-logo-share.jpg");
INSERT INTO `wp_postmeta` VALUES("18406", "83214", "url_article", "https://www.rpc-group.com/media/product-news/2017");
INSERT INTO `wp_postmeta` VALUES("18407", "83214", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("18408", "83214", "url_picture", "https://rpc-group.production.investis.com/~/media/Images/R/RPC-Group/logo/rpc-logo-share.jpg");
INSERT INTO `wp_postmeta` VALUES("18409", "83215", "url_article", "https://www.rpc-group.com/sustainability/product-design-development-and-innovation");
INSERT INTO `wp_postmeta` VALUES("18410", "83215", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("18411", "83215", "url_picture", "https://www.rpc-group.com/~/media/Images/R/RPC-Group/content-images/product-design-and-innovation/fridge-inside.png?h=237&la=en&w=237");
INSERT INTO `wp_postmeta` VALUES("18412", "83216", "url_article", "https://www.rpc-group.com/media/product-news/");
INSERT INTO `wp_postmeta` VALUES("18413", "83216", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("18414", "83216", "url_picture", "https://rpc-group.production.investis.com/~/media/Images/R/RPC-Group/logo/rpc-logo-share.jpg");
INSERT INTO `wp_postmeta` VALUES("18415", "83217", "url_article", "https://www.rpc-group.com/media/product-news/2018/tubes-are-the-perfect-match-for-paint-testers");
INSERT INTO `wp_postmeta` VALUES("18416", "83217", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("18417", "83217", "url_picture", "https://www.rpc-group.com/~/media/Images/R/RPC-Group/content-images/news-images/2018/mh-crown-main.jpg?h=380&la=en&w=670");
INSERT INTO `wp_postmeta` VALUES("18418", "83218", "url_article", "https://www.rpc-group.com/media/product-news/2018/olives-enjoy-a-longlife");
INSERT INTO `wp_postmeta` VALUES("18419", "83218", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("18420", "83218", "url_picture", "https://www.rpc-group.com/~/media/Images/R/RPC-Group/content-images/news-images/2018/superfos-madama-oliva-main.jpg?h=380&la=en&w=670");
INSERT INTO `wp_postmeta` VALUES("18421", "83219", "url_article", "https://www.rpc-group.com/media/product-news/2015");
INSERT INTO `wp_postmeta` VALUES("18422", "83219", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18423", "83219", "url_picture", "https://rpc-group.production.investis.com/~/media/Images/R/RPC-Group/logo/rpc-logo-share.jpg");
INSERT INTO `wp_postmeta` VALUES("18424", "83220", "url_article", "https://www.rpc-group.com/media/product-news");
INSERT INTO `wp_postmeta` VALUES("18425", "83220", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("18426", "83220", "url_picture", "https://rpc-group.production.investis.com/~/media/Images/R/RPC-Group/logo/rpc-logo-share.jpg");
INSERT INTO `wp_postmeta` VALUES("18427", "83221", "url_article", "https://www.rpc-group.com/media/product-news/2016");
INSERT INTO `wp_postmeta` VALUES("18428", "83221", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("18429", "83221", "url_picture", "https://www.rpc-group.com/~/media/Images/R/RPC-Group/content-images/news-images/2016/promens-protect-preview.jpg?h=196&la=en&w=296");
INSERT INTO `wp_postmeta` VALUES("18430", "83222", "url_article", "https://www.rpc-group.com/sustainability/our-position-statements-and-information-sheets");
INSERT INTO `wp_postmeta` VALUES("18431", "83222", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("18432", "83222", "url_picture", "https://www.rpc-group.com/~/media/Images/R/RPC-Group/banners/sub-banners/our-position-page-banner.jpg?h=320&la=en&w=770");
INSERT INTO `wp_postmeta` VALUES("18433", "83223", "url_article", "https://www.rpc-group.com/about-us/our-divisions");
INSERT INTO `wp_postmeta` VALUES("18434", "83223", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("18435", "83223", "url_picture", "https://rpc-group.production.investis.com/~/media/Images/R/RPC-Group/logo/rpc-logo-share.jpg");
INSERT INTO `wp_postmeta` VALUES("18436", "83224", "url_article", "https://www.rpc-group.com/media/product-news/2018/pails-aid-upward-growth-of-vines");
INSERT INTO `wp_postmeta` VALUES("18437", "83224", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("18438", "83224", "url_picture", "https://www.rpc-group.com/~/media/Images/R/RPC-Group/content-images/news-images/2018/supercube-pail-main.jpg?h=380&la=en&w=670");
INSERT INTO `wp_postmeta` VALUES("18439", "83225", "url_article", "https://www.rpc-group.com/about-us/our-locations");
INSERT INTO `wp_postmeta` VALUES("18440", "83225", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("18441", "83225", "url_picture", "https://rpc-group.production.investis.com/~/media/Images/R/RPC-Group/logo/rpc-logo-share.jpg");
INSERT INTO `wp_postmeta` VALUES("18442", "83226", "url_article", "https://www.rpc-group.com/media/product-news/2018/new-design-helps-cut-plenty-of-ice");
INSERT INTO `wp_postmeta` VALUES("18443", "83226", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("18444", "83226", "url_picture", "https://www.rpc-group.com/~/media/Images/R/RPC-Group/content-images/news-images/2018/promens-demon-ice-main.jpg?h=380&la=en&w=670");
INSERT INTO `wp_postmeta` VALUES("18445", "83227", "url_article", "https://www.rpc-group.com/about-us");
INSERT INTO `wp_postmeta` VALUES("18446", "83227", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("18447", "83227", "url_picture", "https://www.rpc-group.com/~/media/Images/R/RPC-Group/banners/sub-banners/products-about-us-group-img.jpg?h=320&la=en&w=770");
INSERT INTO `wp_postmeta` VALUES("18448", "83228", "url_article", "https://www.rpc-group.com/media/product-news/2018/bpi-protec-launches-sustainable-stand-up-pouch-solution");
INSERT INTO `wp_postmeta` VALUES("18449", "83228", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("18450", "83228", "url_picture", "https://www.rpc-group.com/~/media/Images/R/RPC-Group/content-images/news-images/2018/bpi-x-enviropouch-main.jpg?h=380&la=en&w=670");
INSERT INTO `wp_postmeta` VALUES("18451", "83229", "url_article", "https://waste-management-world.com/about");
INSERT INTO `wp_postmeta` VALUES("18452", "83229", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18453", "83229", "url_picture", "https://waste-management-world.com/img/pgs/about/iswa-20151023.png");
INSERT INTO `wp_postmeta` VALUES("18454", "83230", "url_article", "https://waste-management-world.com/subscribe");
INSERT INTO `wp_postmeta` VALUES("18455", "83230", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18456", "83231", "url_article", "https://waste-management-world.com/a/association-of-plastic-recyclers-recognises-industry-innovators");
INSERT INTO `wp_postmeta` VALUES("18457", "83231", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("18458", "83231", "url_picture", "https://cdn.waste-management-world.com/1744/670-0-1.85/2/max-ai-aqc-bulk-handling-systems-recycling-ci-waste-green-recycling/max-ai-aqc-green-recycling-first-in-uk.jpg");
INSERT INTO `wp_postmeta` VALUES("18459", "83232", "url_article", "https://waste-management-world.com/tag/ifat");
INSERT INTO `wp_postmeta` VALUES("18460", "83232", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("18461", "83232", "url_picture", "https://cdn.waste-management-world.com/407/1000-0-1.85/3/doppstadt-splitterx2/doppstadt-splitterx2-beladung.jpg");
INSERT INTO `wp_postmeta` VALUES("18462", "83233", "url_article", "https://waste-management-world.com/a/veolia-parters-with-knauf-insulation-on-60-000-tpa-glass-recycling-plant");
INSERT INTO `wp_postmeta` VALUES("18463", "83233", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("18464", "83233", "url_picture", "https://cdn.waste-management-world.com/1845/670-0-1.85/3/veolia-knauf-insulation-recycling-st-helens-circular-economy/img-3225a.jpg");
INSERT INTO `wp_postmeta` VALUES("18465", "83234", "url_article", "https://waste-management-world.com/epaper/collection-handling");
INSERT INTO `wp_postmeta` VALUES("18466", "83234", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18467", "83235", "url_article", "https://waste-management-world.com/a/recycling-technologies-announces-a-1-million-equity-investment-from-interchem");
INSERT INTO `wp_postmeta` VALUES("18468", "83235", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("18469", "83235", "url_picture", "https://cdn.waste-management-world.com/377/670-0-1.85/2/grant-thorton-llc-waste-industry-ma/one-pound-sxc1240669.jpg");
INSERT INTO `wp_postmeta` VALUES("18470", "83236", "url_article", "https://waste-management-world.com/a/major-cities-ramp-up-for-global-recycling-day");
INSERT INTO `wp_postmeta` VALUES("18471", "83236", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("18472", "83236", "url_picture", "https://cdn.waste-management-world.com/1708/670-0-1.85/6/ciwm-colin-church-budget-waste-recycling/parliament-london-by-night-735085-1920.jpg");
INSERT INTO `wp_postmeta` VALUES("18473", "83237", "url_article", "https://waste-management-world.com/a/new-liebherr-telehandlers-extends-with-waste-recycling-options");
INSERT INTO `wp_postmeta` VALUES("18474", "83237", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("18475", "83237", "url_picture", "https://cdn.waste-management-world.com/1854/670-0-1.85/4/liebherr-telehandler-waste-recycling-scorpion/lieberah.png");
INSERT INTO `wp_postmeta` VALUES("18476", "83238", "url_article", "https://waste-management-world.com/epaper/26");
INSERT INTO `wp_postmeta` VALUES("18477", "83238", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18478", "83238", "url_picture", "https://img.yumpu.com/59821594/1/1600x2128/january-february-2018.jpg");
INSERT INTO `wp_postmeta` VALUES("18479", "83239", "url_article", "https://waste-management-world.com/a/dell-partners-with-nikki-reed-to-recycle-gold-from-e-waste-into-jewellery");
INSERT INTO `wp_postmeta` VALUES("18480", "83239", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("18481", "83239", "url_picture", "https://cdn.waste-management-world.com/1830/670-0-1.85/4/bayouwithlove-dell-recycling-gold-nikki-reed-ewaste-jewellery/open-opal-ring-3.jpg");
INSERT INTO `wp_postmeta` VALUES("18482", "83240", "url_article", "https://waste-management-world.com/a/jcb-punching-above-its-weight-in-waste");
INSERT INTO `wp_postmeta` VALUES("18483", "83240", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("18484", "83240", "url_picture", "https://cdn.waste-management-world.com/1853/670-0-1.85/4/jcb-waste-recycling-escor-js175w-hydradig/jcb2.png");
INSERT INTO `wp_postmeta` VALUES("18485", "83241", "url_article", "https://waste-management-world.com/a/veolia-and-salvation-army-team-up-on-baby-item-reuse-scheme");
INSERT INTO `wp_postmeta` VALUES("18486", "83241", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("18487", "83241", "url_picture", "https://cdn.waste-management-world.com/1829/670-0-1.85/3/veolia-salvation-army-reuse-waste-baby-items/veolia-reuse-baby-items-press-image.jpg");
INSERT INTO `wp_postmeta` VALUES("18488", "83242", "url_article", "https://waste-management-world.com/auth/sign-in");
INSERT INTO `wp_postmeta` VALUES("18489", "83242", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18490", "83243", "url_article", "https://waste-management-world.com/a/new-single-shaft-shredder-for-hard-plastic-recycling-from-vecoplan");
INSERT INTO `wp_postmeta` VALUES("18491", "83243", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("18492", "83243", "url_picture", "https://cdn.waste-management-world.com/1835/670-0-1.85/3/vecolplan-recycling-plastics-shredding/18-02-22-vecoplan-pi-vhd-1600-photo-1.jpg");
INSERT INTO `wp_postmeta` VALUES("18493", "83244", "url_article", "https://waste-management-world.com/a/marine-plastic-waste-pollution-could-be-cut-by");
INSERT INTO `wp_postmeta` VALUES("18494", "83244", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("18495", "83244", "url_picture", "https://cdn.waste-management-world.com/1826/670-0-1.85/4/-/brunel-img-3421-1024.jpeg");
INSERT INTO `wp_postmeta` VALUES("18496", "83245", "url_article", "https://waste-management-world.com/opinion");
INSERT INTO `wp_postmeta` VALUES("18497", "83245", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("18498", "83246", "url_article", "https://waste-management-world.com/");
INSERT INTO `wp_postmeta` VALUES("18499", "83246", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("18500", "83246", "url_picture", "https://cdn.waste-management-world.com/703/80-0-1.33/3/texas-recycling-burns-mcdonnell/texas-flag-sxc-1255158.jpg");
INSERT INTO `wp_postmeta` VALUES("18501", "83247", "url_article", "https://waste-management-world.com");
INSERT INTO `wp_postmeta` VALUES("18502", "83247", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("18503", "83247", "url_picture", "https://cdn.waste-management-world.com/703/80-0-1.33/3/texas-recycling-burns-mcdonnell/texas-flag-sxc-1255158.jpg");
INSERT INTO `wp_postmeta` VALUES("18504", "83248", "url_article", "https://waste-management-world.com/sign-up?newsletter=1");
INSERT INTO `wp_postmeta` VALUES("18505", "83248", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18506", "83249", "url_article", "https://waste-management-world.com/a/something-extra-waste-collection-handling-product-news");
INSERT INTO `wp_postmeta` VALUES("18507", "83249", "interes", "11");
INSERT INTO `wp_postmeta` VALUES("18508", "83249", "url_picture", "https://cdn.waste-management-world.com/1848/670-0-1.85/3/-/volvo-lng.png");
INSERT INTO `wp_postmeta` VALUES("18509", "83250", "url_article", "https://waste-management-world.com/epaper");
INSERT INTO `wp_postmeta` VALUES("18510", "83250", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18511", "83251", "url_article", "https://waste-management-world.com/sign-up");
INSERT INTO `wp_postmeta` VALUES("18512", "83251", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18513", "83252", "url_article", "http://www.elempaque.com/temas/La-generacion-2018-del-Diplomado-de-Envase-y-Embalaje-te-espera+122477?tema=4200000");
INSERT INTO `wp_postmeta` VALUES("18514", "83252", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("18515", "83252", "url_picture", "http://www.elempaque.com/documenta/imagenes/128965/amee-p.jpg");
INSERT INTO `wp_postmeta` VALUES("18516", "83253", "url_article", "http://www.elempaque.com/temas/Envases-terminados-y-componentes?caso=Noticias-y-articulos&pagina=1");
INSERT INTO `wp_postmeta` VALUES("18517", "83253", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18518", "83254", "url_article", "http://www.elempaque.com/temas/Flexibles");
INSERT INTO `wp_postmeta` VALUES("18519", "83254", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18520", "83255", "url_article", "http://www.elempaque.com/temas/El-empaque-retortable-que-buscas,-lo-tenemos+121366?tema=4200000");
INSERT INTO `wp_postmeta` VALUES("18521", "83255", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("18522", "83255", "url_picture", "http://www.elempaque.com/documenta/imagenes/127845/bolsa-1-gns-p.jpg");
INSERT INTO `wp_postmeta` VALUES("18523", "83256", "url_article", "http://www.elempaque.com/temas/Su-marca-tiene-el-ADN-de-la-innovacion-Esta-es-una-oportunidad-que-no-se-puede-perder+124069?tema=4200000");
INSERT INTO `wp_postmeta` VALUES("18524", "83256", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("18525", "83256", "url_picture", "http://www.elempaque.com/documenta/imagenes/130563/muestra-comercial-cumbre-1.jpg");
INSERT INTO `wp_postmeta` VALUES("18526", "83257", "url_article", "http://www.elempaque.com/temas/Envases-terminados-y-componentes?caso=Eventos-de-la-industria&pagina=1");
INSERT INTO `wp_postmeta` VALUES("18527", "83257", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18528", "83258", "url_article", "http://www.elempaque.com/temas/Zubiox,-linea-de-empaques-de-barrera-biodegradables-para-la-industria-alimentaria+122466?tema=4200000");
INSERT INTO `wp_postmeta` VALUES("18529", "83258", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("18530", "83258", "url_picture", "http://www.elempaque.com/documenta/imagenes/128953/zubiox-p.jpg");
INSERT INTO `wp_postmeta` VALUES("18531", "83259", "url_article", "http://www.elempaque.com/temas/Envases-terminados-y-componentes?caso=Informaciones-comerciales&pagina=1");
INSERT INTO `wp_postmeta` VALUES("18532", "83259", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18533", "83260", "url_article", "http://www.elempaque.com/temas/Quiere-conocer-como-la-industria-40-esta-transformando-la-forma-de-disenar-y-producir-envases-plasticos+123593?tema=4200000");
INSERT INTO `wp_postmeta` VALUES("18534", "83260", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("18535", "83260", "url_picture", "http://www.elempaque.com/documenta/imagenes/130087/industria.jpg");
INSERT INTO `wp_postmeta` VALUES("18536", "83261", "url_article", "http://www.elempaque.com/blogs/Tapas-plasticas-de-rosca-mantienen-controlado-el-precio,-mientras-que-las-abatibles-y-push-pull-agregan-valor+118480");
INSERT INTO `wp_postmeta` VALUES("18537", "83261", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("18538", "83261", "url_picture", "http://www.elempaque.com/documenta/imagenes/124951/silvia-de-almeida-blog-euromonitor-international.jpg");
INSERT INTO `wp_postmeta` VALUES("18539", "83262", "url_article", "http://www.elempaque.com/blogs/Continua-el-auge-de-las-bolsas-parables+123861");
INSERT INTO `wp_postmeta` VALUES("18540", "83262", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("18541", "83262", "url_picture", "http://www.elempaque.com/documenta/imagenes/101675/Lilian-Robayo_300x300.jpg");
INSERT INTO `wp_postmeta` VALUES("18542", "83263", "url_article", "http://www.elempaque.com/temas/Eliminador-de-oxigeno-y-neutralizador-de-humedad-PharmaKeep+123188?tema=4200000");
INSERT INTO `wp_postmeta` VALUES("18543", "83263", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("18544", "83263", "url_picture", "http://www.elempaque.com/documenta/imagenes/129681/Eliminador-de-oxigeno-y-humedad-PharmaKeeep-Clariant-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18545", "83264", "url_article", "http://www.elempaque.com/temas/Conozca-las-cifras-del-evento-que-piensa-en-innovacion-en-envases-plasticos+122497?tema=4200000");
INSERT INTO `wp_postmeta` VALUES("18546", "83264", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("18547", "83264", "url_picture", "http://www.elempaque.com/documenta/imagenes/128985/INFOGRAFIA-CUMBRE-p.jpg");
INSERT INTO `wp_postmeta` VALUES("18548", "83265", "url_article", "http://www.elempaque.com/eventos/Modulo-5,-Envases-de-vidrio+123662");
INSERT INTO `wp_postmeta` VALUES("18549", "83265", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18550", "83265", "url_picture", "http://www.elempaque.com:80/documenta/imagenes/130156/Modulo-5-envases-de-vidrio-AMEE.jpg");
INSERT INTO `wp_postmeta` VALUES("18551", "83266", "url_article", "http://www.elempaque.com/temas/Polimerica,-proveedor-integral-de-envases-y-tapas-plasticas+121959?tema=4200000");
INSERT INTO `wp_postmeta` VALUES("18552", "83266", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("18553", "83266", "url_picture", "http://www.elempaque.com/documenta/imagenes/128446/comercial-p.jpg");
INSERT INTO `wp_postmeta` VALUES("18554", "83267", "url_article", "http://www.elempaque.com/temas/Digimarc,-la-nueva-etiqueta-con-codigo-de-barras-invisible+121058?tema=4200000");
INSERT INTO `wp_postmeta` VALUES("18555", "83267", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("18556", "83267", "url_picture", "http://www.elempaque.com/documenta/imagenes/127529/Inland-digimarc-etiqueta-con-codigo-de-barras-invisible-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18557", "83268", "url_article", "http://www.elempaque.com/blogs/Los-cierres-multifuncionales-ayudan-a-los-detergentes-liquidos-a-competir-con-las-tabletas+120892");
INSERT INTO `wp_postmeta` VALUES("18558", "83268", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("18559", "83268", "url_picture", "http://www.elempaque.com/documenta/imagenes/127363/silvia-de-almeida-blog-euromonitor-international.jpg");
INSERT INTO `wp_postmeta` VALUES("18560", "83269", "url_article", "http://www.elempaque.com/temas/Nueva-serie-de-botellas-y-preformas-PET,-con-claridad-extrema+117766?tema=4200000");
INSERT INTO `wp_postmeta` VALUES("18561", "83269", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("18562", "83269", "url_picture", "http://www.elempaque.com/documenta/imagenes/124237/dairy-aseptic-criystal-clear-amcor-2-p.jpg");
INSERT INTO `wp_postmeta` VALUES("18563", "83270", "url_article", "http://www.elempaque.com/eventos/Segunda-Cumbre-Latinoamericana-de-Innovacion-en-Envases-Plasticos-2018+120130");
INSERT INTO `wp_postmeta` VALUES("18564", "83270", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("18565", "83270", "url_picture", "http://www.elempaque.com/documenta/imagenes/126601/segunda-cumbre-latinoamericana-de-envases-plasticos-2018.fw.png");
INSERT INTO `wp_postmeta` VALUES("18566", "83271", "url_article", "http://www.elempaque.com/temas/Envases-terminados-y-componentes?caso=Productos&pagina=1");
INSERT INTO `wp_postmeta` VALUES("18567", "83271", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18568", "83272", "url_article", "http://www.elempaque.com/blogs/Frescura-y-funcionalidad-impulsan-uso-de-pouches-para-soluciones-de-comidas+117640");
INSERT INTO `wp_postmeta` VALUES("18569", "83272", "interes", "12");
INSERT INTO `wp_postmeta` VALUES("18570", "83272", "url_picture", "http://www.elempaque.com/documenta/imagenes/124111/Karine-Dussimon-Euromonitor-International.jpg");
INSERT INTO `wp_postmeta` VALUES("18571", "83273", "url_article", "http://www.elempaque.com/temas/Envases-terminados-y-componentes?caso=Asociaciones&pagina=1");
INSERT INTO `wp_postmeta` VALUES("18572", "83273", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18573", "83274", "url_article", "http://www.elempaque.com/temas/Sabe-como-sus-consumidores-lo-pueden-ayudar-a-innovar-en-sus-envases-plasticos+123510?tema=4200000");
INSERT INTO `wp_postmeta` VALUES("18574", "83274", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("18575", "83274", "url_picture", "http://www.elempaque.com/documenta/imagenes/130004/Consumidores-p.jpg");
INSERT INTO `wp_postmeta` VALUES("18576", "83275", "url_article", "http://www.elempaque.com/temas/Caja-de-regalo-SkinCare-20-de-Mets%C3%A4-Board-gana-multiples-premios+123867?tema=4200000");
INSERT INTO `wp_postmeta` VALUES("18577", "83275", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("18578", "83275", "url_picture", "http://www.elempaque.com/documenta/imagenes/130361/skincareall-2-premio-metsa-board-caja-de-regalo-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18579", "83276", "url_article", "http://www.elempaque.com/blogs/En-2017,-D%C3%BCsseldorf-sera-capital-mundial-del-envase+117537");
INSERT INTO `wp_postmeta` VALUES("18580", "83276", "interes", "9");
INSERT INTO `wp_postmeta` VALUES("18581", "83276", "url_picture", "http://www.elempaque.com/documenta/imagenes/101675/Lilian-Robayo_300x300.jpg");
INSERT INTO `wp_postmeta` VALUES("18582", "83277", "url_article", "http://www.elempaque.com/temas/rPET-PP*STAR,-bolsa-fabricada-100-con-granulos-de-la-molienda-de-botellas-PET+124071?tema=4200000");
INSERT INTO `wp_postmeta` VALUES("18583", "83277", "interes", "13");
INSERT INTO `wp_postmeta` VALUES("18584", "83277", "url_picture", "http://www.elempaque.com/documenta/imagenes/130565/rPET-PPSTAR-bolsa-de-plegado-fabricada-con-granulos-de-la-molienda-de-botellas-PET-Starlinger-P.jpg");
INSERT INTO `wp_postmeta` VALUES("18585", "83278", "url_article", "http://www.elempaque.com/temas/Crecimiento-del-segmento-de-bolsas-parables-superaria-los-4500-millones-de-dolares-en-2021+123869?tema=4200000");
INSERT INTO `wp_postmeta` VALUES("18586", "83278", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("18587", "83278", "url_picture", "http://www.elempaque.com/documenta/imagenes/130363/Crece-segmento-de-bolsas-parables-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18588", "83279", "url_article", "http://www.elempaque.com/blogs/Como-medir-y-controlar-la-tension-de-un-sustrato-en-un-proceso-de-conversion-de-laminados-para-envases-flexibles+118389");
INSERT INTO `wp_postmeta` VALUES("18589", "83279", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("18590", "83279", "url_picture", "http://www.elempaque.com/documenta/imagenes/124860/control-tension-laminacion-envases-flexibles-2-Wilmer-Saavedra.png");
INSERT INTO `wp_postmeta` VALUES("18591", "83280", "url_article", "http://www.elempaque.com/temas/Tintas-termocromaticas-hacen-debut-comercial-con-envase-de-Coca-Cola+124052?tema=4200000");
INSERT INTO `wp_postmeta` VALUES("18592", "83280", "interes", "2");
INSERT INTO `wp_postmeta` VALUES("18593", "83280", "url_picture", "http://www.elempaque.com/documenta/imagenes/130546/Tintas-termocromaticas-en-envase-Coca-Cola-pq-3.jpg");
INSERT INTO `wp_postmeta` VALUES("18594", "83281", "url_article", "http://www.elempaque.com/temas/Label-Summit-Latin-America-2018,-una-invitacion-impostergable+124153?tema=4200000");
INSERT INTO `wp_postmeta` VALUES("18595", "83281", "interes", "8");
INSERT INTO `wp_postmeta` VALUES("18596", "83281", "url_picture", "http://www.elempaque.com/documenta/imagenes/130647/Label-Sumit-Latin-America-2018-pq1.jpg");
INSERT INTO `wp_postmeta` VALUES("18597", "83282", "url_article", "http://www.elempaque.com/temas/Innovadora-tecnologia-para-envasar-platos-prelistos-y-refrigerados+124080?tema=4200000");
INSERT INTO `wp_postmeta` VALUES("18598", "83282", "interes", "5");
INSERT INTO `wp_postmeta` VALUES("18599", "83282", "url_picture", "http://www.elempaque.com/documenta/imagenes/130574/Micvac-Innovadora-tecnologia-para-envasar-platos-pre-listos-y-refrigerados-p1.jpg");
INSERT INTO `wp_postmeta` VALUES("18600", "83283", "url_article", "http://www.elempaque.com/eventos/Modulo-4,-Envases-de-plastico+123661");
INSERT INTO `wp_postmeta` VALUES("18601", "83283", "interes", "3");
INSERT INTO `wp_postmeta` VALUES("18602", "83283", "url_picture", "http://www.elempaque.com:80/documenta/imagenes/130155/Modulo-3-envases-de-plastico-AMEE.jpg");
INSERT INTO `wp_postmeta` VALUES("18603", "83284", "url_article", "http://www.elempaque.com/blogs/Envasado-en-vidrio,-positiva-perspectiva-mundial-en-mercados-de-alimentos-y-bebidas+122057");
INSERT INTO `wp_postmeta` VALUES("18604", "83284", "interes", "14");
INSERT INTO `wp_postmeta` VALUES("18605", "83284", "url_picture", "http://www.elempaque.com/documenta/imagenes/128544/Karine-Dussimon-post.jpg");
INSERT INTO `wp_postmeta` VALUES("18606", "83285", "url_article", "http://www.elempaque.com/blogs/Envases-mas-lujosos-para-la-pasta-dental,-una-tendencia-mundial+121739");
INSERT INTO `wp_postmeta` VALUES("18607", "83285", "interes", "7");
INSERT INTO `wp_postmeta` VALUES("18608", "83285", "url_picture", "http://www.elempaque.com/documenta/imagenes/128226/mylan-nguyen-euromonitor-international-1-p.jpg");
INSERT INTO `wp_postmeta` VALUES("18609", "83286", "url_article", "http://www.elempaque.com/guia-de-proveedores/empresas/GNS-Empaque-Confiable+5594714?showroom=120566");
INSERT INTO `wp_postmeta` VALUES("18610", "83286", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18611", "83286", "url_picture", "http://www.elempaque.com:80/documenta/imagenes/127037/logo-gns.jpg");
INSERT INTO `wp_postmeta` VALUES("18612", "83287", "url_article", "http://www.elempaque.com/temas/Latas-plasticas-para-alimentos-con-alta-barrera-al-oxigeno+122391?tema=4200000");
INSERT INTO `wp_postmeta` VALUES("18613", "83287", "interes", "4");
INSERT INTO `wp_postmeta` VALUES("18614", "83287", "url_picture", "http://www.elempaque.com/documenta/imagenes/128878/Latas-Plasticas-Silgan-Plastic-Food-Containers-Andina-Pack-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18615", "83288", "url_article", "http://www.elempaque.com/temas/ProcteryGamble-lanza-botella-fabricada-100-de-plastico-reciclado+124072?tema=4200000");
INSERT INTO `wp_postmeta` VALUES("18616", "83288", "interes", "10");
INSERT INTO `wp_postmeta` VALUES("18617", "83288", "url_picture", "http://www.elempaque.com/documenta/imagenes/130566/Fairy-Ocean-Plastic-botellas-plastica-de-Procter-and-Gamble-fabricada-de-plastico-reciclado-del-oceano-pq.jpg");
INSERT INTO `wp_postmeta` VALUES("18618", "83289", "url_article", "http://www.elempaque.com/temas/Rigidos");
INSERT INTO `wp_postmeta` VALUES("18619", "83289", "interes", "1");
INSERT INTO `wp_postmeta` VALUES("18620", "83290", "url_article", "http://www.elempaque.com/eventos/Pack-Peru-Expo-2018+122887");
INSERT INTO `wp_postmeta` VALUES("18621", "83290", "interes", "6");
INSERT INTO `wp_postmeta` VALUES("18622", "83290", "url_picture", "http://www.elempaque.com:80/documenta/imagenes/129375/Pack-Expo-Peru.jpg");
INSERT INTO `wp_postmeta` VALUES("18623", "83291", "url_article", "http://www.elempaque.com/blogs/Demanda-de-asequibilidad-