/**
 * jQuery for Media Categories plugin
 * 
 * @author Eddie Moya
 * @since 1.5
 * 
 */

jQuery(document).ready(function($){


    $.each(taxonomy, function(index, tax){

        var input_class = '.compat-field-'+tax;
        var metabox_class = input_class+'_metabox';

        $.extend($.expr[":"], {
            "icontains": function(elem, i, match, array) {
                return (elem.textContent || elem.innerText || "").toLowerCase().indexOf((match[3] || "").toLowerCase()) >= 0;
            }
        });
        /**
        * The following javascript is borrowed (with few modifications) from Jason Corradino's 
        * 'Searchable Categories' plugin. It allows the category metabox to be filtered 
        * as the user types. To do this with your category meta boxes on pages and posts, 
        * download his plugin.
        * 
        * http://wordpress.org/extend/plugins/searchable-categories/
        */

        $('#' + tax + '-search').live('keyup', function() {
            var val = $('.user-category #' + tax + '-search').val(); 
            var lis = $(".user-category #"+ tax +"checklist li");

            if(val.length > 0){
                lis.hide();
            } else {
                lis.show();
            }
            // find li labels's containing term, then back to parent li
            var containingLabels = $(".user-category #"+ tax +"checklist label:icontains('" + val + "')");

            containingLabels.closest('li').find('li').andSelf().show();
            containingLabels.parents('.user-category #'+ tax +'checklist li').show();
        });
    });
})
