<?php 


/*
function taxonomy_graph($term_slug)
{
	echo stl_simile_timeline($term_slug);
    $current_year = date('Y');
    $week = date('W');    
    $countposts = get_posts("year=$current_year&w=$week&category=$term");    
}

function grafica($c){
	if(WPSimileTimelineLoader::loadPlugin()){
		$wpstl = WPSimileTimeline::singleton();
		extract( shortcode_atts( $wpstl->api_parameters, array() ) );				
		return stl_simile_timeline($c, $id, $scriptfile, $theme, $start, $stop, true);
	}
}
*/

function taxonomy_graph($term_id,$taxonomy)
{		
	$args = array(
		'posts_per_page'	=> -1,
		'post_type'			=> 'post',
		'post_status'		=> 'publish',
		$taxonomy			=> $term_id,
	);
	
	echo posts_graph($args);			

}

function project_graph($project_id)
{
	//echo stl_simile_timeline($project_id, 'stl-mytimeline', 'timelineproj.js.php');
	
	$post_ids = get_ids_entradas_of_proyecto( $project_id );
	
	if( count($post_ids) > 1 ) {
			
			$args = array(
				'posts_per_page'	=> -1,
				'post_type'			=> 'post',
				'post_status'		=> 'publish',
				'post__in'			=> $post_ids,
			);
			
			echo posts_graph($args);			
		}
}
//Funci�n en fase de desarrollo para sacar gr�ficos de las entradas correspondientes a los filtros de busqueda seleccionados
function post_graph_filtered($element_id, $tipo)
{
	//echo stl_simile_timeline($project_id, 'stl-mytimeline', 'timelineproj.js.php');
	//echo $tipo;echo"-";
	echo $element_id;echo"-";
// 	$s1 = get_term_by('id', $element_id, 'fuente');
	//$s = get_term_by('id', $element_id, 'scope');
// 	echo $s1->slug;

	if ($tipo == 'project')//Escenario
		$post_ids = get_ids_entradas_of_proyecto( $element_id );
	elseif ($tipo == 1)//Categoria
		
		$post_ids = get_posts(
				array(
						'posts_per_page'=>-1,
						'post_type'=>'post',
						'post_status'=>'publish',
						'category'=>$element_id,
						'fields'=> 'ids'
		));

		
	elseif ($tipo == 2)//Etiqueta
		$post_ids = get_posts(
				array(
						'posts_per_page'=>-1,
						'post_type'=>'post',
						'post_status'=>'publish',
						'tag_id'=>$element_id,
						'fields'=> 'ids'
		));
	elseif ($tipo == 3){//Fuente
		$s1 = get_term_by('id', $element_id, 'fuente');
		$post_ids = get_posts(
				array(
						'posts_per_page'=>-1,
						'post_type'=>'post',
						'post_status'=>'publish',
						'fuente'=> $s1->slug,
						'fields'=> 'ids'
				));
	
	
	}
	
	elseif ($tipo == 4){//Riesgo
		$s2 = get_term_by('id', $element_id, 'scope');
		$post_ids = get_posts(
				array(
						'posts_per_page'=>-1,
						'post_type'=>'post',
						'post_status'=>'publish',
						'scope'=> $s2->slug,
						'fields'=> 'ids'
		));
	}
	
	elseif ($tipo == 5)//Escenarios
	$post_ids = get_posts(
			array(
					'posts_per_page'=>-1,
					'post_type'=>'project',
					'post_status'=>'publish',
					'fields'=> 'ids'
			));
	echo count($post_ids);
	echo " resultados";
	if( count($post_ids) > 1 ) {
			
		$args = array(
				'posts_per_page'	=> -1,
				'post_type'			=> 'post',
				'post_status'		=> 'publish',
				'post__in'			=> $post_ids,
		);
			
		echo posts_graph($args);
	}
}

function posts_graph($args)
{
	$id = 'grafico'.mt_rand(1000, 9999);
?>
<div id="<?php echo $id;?>" style="width: 100%; height: 400px; margin: 0 auto"></div>
<script>
jQuery(document).ready(function($) {

	$('#<?php echo $id;?>').css('height','400px');
	$('#<?php echo $id;?>').css('border','1px solid #999');
	$('#<?php echo $id;?>').css('box-shadow','2px 2px 10px #999');

    var do_<?php echo $id;?> = new Highcharts.Chart({

			chart: {
				renderTo: '<?php echo $id;?>',
				type: 'bubble',
				zoomType: 'xy'
			},

			title: {
				text: '<?php _e('Evolución','ainia');?>'
			},
			
			tooltip: {
						formatter: function() {														
							return this.point.name;
						}
					},
		
			plotOptions: {
				series: {
					cursor: 'pointer',
					events: {
						click: function (event) {														
							location.href=event.toElement.point.url;
						}
					}
				}
			},
						
			xAxis: {
				type: 'datetime',
				dateTimeLabelFormats: { 										
					month: '%e %b',
					day: '%e %b %Y',
					hour: ' ',
					minute: ' ',
					second: ' ',
				},
				title: {
					text: '<?php _e('Date','ainia');?>'
				},				
			},
			
			yAxis: {
				type:'category',
				title: {
					text: 'Noticias'
				},
				labels: {
					enabled: false
				},
				min:1,
			},

			series: [{
				name: 'News',
				data: [		
					<?php 
					$fecha_anterior='';
					$contador = 1;
					$entradas = get_posts($args);					
					foreach($entradas as $entrada):
					$fecha = date(get_option('date_format'),$entrada->original_date);					
					?>
					{
						name: '<?php echo $entrada->post_title .'<br>'. $entrada->original_date;?>',						
						id: '<?php echo $entrada->ID;?>',
						y: <?php echo $contador;?>,	
						x: Date.parse("<?php echo $entrada->original_date;?>"),								
						url :  '<?php echo get_permalink($entrada->ID);?>',
					}, 
					<?php 
					if($fecha==$fecha_anterior)$contador++;
					else {$contador =1;$fecha_anterior=$fecha;}
					endforeach;?>	
				]
			}],
			
			legend: {
				enabled:false,
				},
				
			credits: {
				enabled:false,
				},
			
    });
});
</script>
<?php
}

