<?php

add_action( 'init', 'proyecto_init' );
/**
 * Register a book post type.
 *
 * @link http://codex.wordpress.org/Function_Reference/register_post_type
 */
function proyecto_init() {
	$labels = array(
		'name'               => _x( 'Proyectos', 'post type general name', 'ainia_iwatch' ),
		'singular_name'      => _x( 'Proyecto', 'post type singular name', 'ainia_iwatch' ),
		'menu_name'          => __( 'Proyectos', 'ainia_iwatch' ),
		'name_admin_bar'     => _x( 'Proyecto', 'add new on admin bar', 'ainia_iwatch' ),
		'add_new'       => __( 'Añadir Nuevo Proyecto', 'ainia_iwatch' ),
		'add_new_item'       => __( 'Añadir Nuevo Proyecto', 'ainia_iwatch' ),
		'new_item'           => __( 'Nuevo Proyecto', 'ainia_iwatch' ),
		'edit_item'          => __( 'Editar Proyecto', 'ainia_iwatch' ),
		'view_item'          => __( 'Ver Proyecto', 'ainia_iwatch' ),
		'all_items'          => __( 'Todos los Proyectos', 'ainia_iwatch' ),
		'search_items'       => __( 'Buscar Proyectos', 'ainia_iwatch' ),
		'parent_item_colon'  => __( 't Proyectos:', 'ainia_iwatch' ),
		'not_found'          => __( 'No se han encontrado Proyectos.', 'ainia_iwatch' ),
		'not_found_in_trash' => __( 'No se han encontrado Proyectos en la papelera.', 'ainia_iwatch' )
	);

	$args = array(
		'labels'             => $labels,
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'proyectos' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array( 'title', 'author', 'comments' ),
		'taxonomies'		 => array(  'post_tag'),
	);

	register_post_type( 'project', $args );
}


//------- A�ADIR COLUMNAS AL PROYECTO -------------------------

add_filter('manage_edit-project_columns', 'ainia_register_project_columns');
function ainia_register_project_columns($columns){
  $columns['riesgo']  = __('Risc','ainia_iwatch');
  $columns['entradas'] = __('Entries','ainia_iwatch');
  return $columns;
}

add_action('manage_project_posts_custom_column', 'ainia_handle_project_columns');
function ainia_handle_project_columns( $column ){
  global $post,$wpdb;
  if( $post->post_type != 'project' ) return;

  switch($column){
	case 'riesgo':  echo get_field( 'riesgo',$post->ID );
					break;
					
	case 'entradas':echo contar_entradas_de_proyecto($post->ID);
					break;
  
  }
}

function get_ids_entradas_of_proyecto($proj_id)
{
	global $wpdb;
	$sql = "SELECT * FROM $wpdb->posts JOIN $wpdb->postmeta ON ($wpdb->posts.ID = $wpdb->postmeta.post_id) WHERE 1=1 AND $wpdb->posts.post_type = 'post' AND $wpdb->posts.post_status = 'publish' AND $wpdb->postmeta.meta_key = 'proyecto' AND $wpdb->postmeta.meta_value LIKE '%$proj_id%' GROUP BY $wpdb->posts.ID ORDER BY $wpdb->posts.post_date DESC";									
	$entradas =  $wpdb->get_results($sql);	
	//echo $sql;								
	$ids_entradas = array();
	foreach($entradas as $entrada)$ids_entradas[]=$entrada->ID;
	return $ids_entradas;
}


function contar_entradas_de_proyecto($proj_id)
{	
	return count(get_ids_entradas_of_proyecto( $proj_id ));
}

function get_importancia_proyecto($proj_id)
{
	$probabilidad = intval(get_field('valor_probabilidad',$proj_id));
	$impacto1 = intval(get_field('impacto_personas',$proj_id));	
	$impacto2 = intval(get_field('impacto_ambiental',$proj_id));	
	$impacto3 = intval(get_field('impacto_economico',$proj_id));	
	$impacto = ( $impacto1 + $impacto2 + $impacto3 ) / 3;
	$importancia = $probabilidad*$impacto;
	return $importancia;
}



function get_ids_categorias_proyecto($proj_id)
{
	$cats = array();
	$posts_ids = get_ids_entradas_of_proyecto($proj_id);	
	foreach($posts_ids as $post_id)
	{
		$post_cats = wp_get_post_categories($post_id);
		foreach($post_cats as $post_cat)
		 if(!in_array($post_cat,$cats))
		  $cats[]=$post_cat;
	}
	return $cats;
}
add_action("listar_entradas_proyecto","listar_entradas_proyecto"); 
function listar_entradas_proyecto(){
	global $post;
	
	$ids = get_ids_entradas_of_proyecto( $post->ID);
	if(count($ids)){
		echo "<ul>";
		foreach($ids as $id)
		 echo sprintf('<li>%s - <a href="%s" target="_blank">%s</a></li>',
				 get_the_date(get_option('date_format'),$id),
				 get_edit_post_link($id),				 
				 get_the_title($id)
				 );
		echo "</ul>";
	}
	else _e("No hay entradas viculadas a este proyecto.",'ainia');
}


