<?php
add_action('admin_bar_menu', 'add_to_admin_bar', 99);
function add_to_admin_bar ()
{
	global $wp_admin_bar;

	$wp_admin_bar->add_menu(array(
			'parent' => 'site-name',
			'id' => 'ainia_menu_1',
			'title' => "Desarrollado por...",
			'href' => "http://www.ainia.es",
			'target' => "_blank",
	));

	$wp_admin_bar->remove_node("wp-logo");
	//$wp_admin_bar->remove_menu('about');            // Remove the about WordPress link
	//$wp_admin_bar->remove_menu('wporg');            // Remove the WordPress.org link
	//$wp_admin_bar->remove_menu('documentation');    // Remove the WordPress documentation link
	//$wp_admin_bar->remove_menu('support-forums');   // Remove the support forums link
	$wp_admin_bar->remove_menu('feedback');         // Remove the feedback link
	//$wp_admin_bar->remove_menu('site-name');        // Remove the site name menu
	//$wp_admin_bar->remove_menu('view-site');        // Remove the view site link
	//$wp_admin_bar->remove_menu('updates');          // Remove the updates link
	//$wp_admin_bar->remove_menu('comments');         // Remove the comments link
	//$wp_admin_bar->remove_menu('new-content');      // Remove the content link
	//$wp_admin_bar->remove_menu('w3tc');             // If you use w3 total cache remove the performance link
	//$wp_admin_bar->remove_menu('my-account');       // Remove the user details tab
	$wp_admin_bar->remove_node( 'new-media' );
	$wp_admin_bar->remove_node( 'new-page' );
}

/* unregister all widgets: to show the widget in apearance->Widgets comment the corresponding line */
add_action('widgets_init', 'unregister_default_widgets', 11);
function unregister_default_widgets() {
	//unregister_widget('WP_Widget_Pages');
	//unregister_widget('WP_Widget_Calendar');
	//unregister_widget('WP_Widget_Search');
	//unregister_widget('WP_Widget_Text');
	//unregister_widget('WP_Widget_Categories');
	//unregister_widget('WP_Widget_RSS');
	//unregister_widget('WP_Widget_Tag_Cloud');
	unregister_widget('WP_Widget_Archives');
	unregister_widget('WP_Widget_Links');
	unregister_widget('WP_Widget_Meta');
	unregister_widget('WP_Widget_Recent_Posts');
	unregister_widget('WP_Widget_Recent_Comments');
	unregister_widget('WP_Nav_Menu_Widget');
	unregister_widget('Twenty_Eleven_Ephemera_Widget');
}


/* This function deletes the standard wordpress text in admin footer */
add_filter( 'admin_footer_text', 'ainia_admin_footer_text'  );
function ainia_admin_footer_text( $footer_text )
{
	return "";
}


function change_footer_version() {
	return htmlspecialchars_decode ( "&copy;".date("Y")." ainia.es - todos los derechos reservados.");
}

add_filter( 'login_headerurl', 'my_login_logo_url' );
function my_login_logo_url() {
	return get_bloginfo( 'url' );
}

/* Quitar actualizaciones de los plugins de la lista "unset"*/
add_filter( 'site_transient_update_plugins', 'disable_plugin_updates' );
function disable_plugin_updates( $value ) {
   unset( $value->response['wysija-newsletters/index.php'] );
   return $value;
}


add_filter('widget_text', 'do_shortcode');
//add_filter( 'widget_text', 'shortcode_unautop' );


// Función que crea la tabla user_terms, si no existe, al activar el plugin
function db_create_user_terms_table() {
     global $wpdb;
  $nombreTabla = $wpdb->prefix . "user_terms";
  
  $created = dbDelta(  
    "CREATE TABLE $nombreTabla (
  `relationship_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL DEFAULT '0',
  `term_id` bigint(20) NOT NULL,
  PRIMARY KEY (`relationship_id`),
  KEY `user_id` (`user_id`),
  KEY `term` (`term_id`),
  KEY `relationship` (`user_id`,`term_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;"
  );
} 
register_activation_hook( __FILE__, 'db_create_user_terms_table' ); 
  