<?php 
add_shortcode('my_shortcode', 'my_shortcode'); 
function my_shortcode( $atts, $content = null  ) 
{         
        return '<h1>MY SHORTCODE</h1>'; 
} 


function wp_hide_update() {
	        global $current_user;
	        get_currentuserinfo();
	 
	        if ($current_user->ID != 1) { // solo el admin lo ve, cambia el ID de usuario si no es el 1 o añade todso los IDs de admin
	            remove_action( 'admin_notices', 'update_nag', 3 );
	        }
	    }
	    add_action('admin_menu','wp_hide_update');

function ainia_posted_on() {
	$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time>';
	if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) )
		$time_string .= ' <time class="updated screen-reader-text" datetime="%3$s">%4$s</time>';

	$time_string = sprintf( $time_string,
		esc_attr( get_the_date( 'c' ) ),
		esc_html( get_the_date() ),
		esc_attr( get_the_modified_date( 'c' ) ),
		esc_html( get_the_modified_date() )
	);

	printf( __( '<span class="posted-on">Publicado el %1$s</span><span class="byline"> por %2$s</span>', 'ainia' ),
		sprintf( '<a href="%1$s" title="%2$s" rel="bookmark">%3$s</a>',
			esc_url( get_permalink() ),
			esc_attr( get_the_time() ),
			$time_string
		),
		sprintf( '<span class="vcard author"><a class="url fn n" href="%1$s" title="%2$s" rel="author">%3$s</a></span>',
			esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
			esc_attr( sprintf( __( 'View all posts by %s', 'ainia' ), get_the_author() ) ),
			esc_html( get_the_author() )
		)
	);
}

function get_string_max_length($content,$charlength) {
	
	global $post;
	$charlength++;
	if ( strlen( $content ) > $charlength ) {
		$subex = substr( $content, 0, $charlength - 5 );
		$exwords = explode( ' ', $subex );
		$excut = - ( strlen( $exwords[ count( $exwords ) - 1 ] ) );
		$buff  = '';
		if ( $excut < 0 ) {
			$buff =  substr( $subex, 0, $excut );
		} else {
			$buff = $subex;
		}
		return $buff . "... <a href='".get_permalink($post->ID)."'>".__("Read More &raquo;","ainia")."</a>";
	} else {
		return $content;
	}
}

function ainia_post_attachments($post) 
{
	$args = array( 'post_type' 		=> 'attachment', 
				   'post_status' 	=> null, 
				   'post_parent' 	=> $post->ID, 
				   'numberposts' 	=> '999', 
				   'post_mime_type' => array( 'application/pdf','application/vnd.ms-excel','application/msword' )
				   ); 
	
	$attachments = get_posts( $args );
	
	if ( $attachments ) :
		
		$download = '<h4>'.__('Downloads','ainia').'</h4> <ul class="downloads">';
		
		foreach ( $attachments as $attachment ) :
				
				setup_postdata($attachment);
				
				// SETUP THE ATTACHMENT ICON
				$attachment_icon = get_post_mime_type( $attachment->ID );
				$attachment_icon = explode( '/',$attachment_icon );
				$attachment_icon = network_home_url( '/' ).'wp-content/plugins/ainia/images/'.$attachment_icon[1].".png";							
				$attachment_icon = '<img style="margin:0;vertical-align:middle;" src="' . $attachment_icon . '" alt="' . get_the_title($attachment->ID) . '" title="' . get_the_title($attachment->ID) . '" />';
			
				// MAKE THE ATTACHMENT LIST ITEM
				$download .= '<li><a href="' . wp_get_attachment_url($attachment->ID) . 
							 '" target="_blank">' . $attachment_icon . get_the_title($attachment->ID) . '</a></li>';
				
				wp_reset_postdata();
		endforeach;
		
		$download .= '</ul><div class="clear"></div>';
		
		
		return $download;
		
	endif;		
	
	
}

//-- PARA PLANTILLAS POST TYPES -------------------------------------------------------------------------------------------------

$ft_out;
$ft_count;

function fieldtable_start($title){
 global $ft_out,$ft_count;
 $ft_out ="";
 if($title!="")$ft_out .="<h3>".__($title,'coitcv')."</h3>";
 $ft_out .='<table class="tpdate">';
 $ft_count = 0;
}

function fieldtable_content(){
	$post_output = get_the_content();
	$post_output = apply_filters('the_wysiwyg', $post_output);
	$post_output = str_replace(']]>', ']]&gt;', $post_output);
	return apply_filters('coitcv_post', $post_output);
}

function fieldtable_add_content($titulo){
	fieldtable_add($titulo,fieldtable_content());
}

function fieldtable_add_taxonomy($campo,$taxonomias){
	$texto="";
	foreach($taxonomias as $taxonomia)
	{
		$texto.=$taxonomia->name." ";
	}
	fieldtable_add($campo,$texto);
}

function fieldtable_add($campo,$valor){
  global $ft_out,$ft_count;
	if($valor!=""){
	 $ft_count++;	
	 $ft_out .='<tr><td class="tp_date_type" ><strong>'.__($campo,'coitcv').'</strong></td>';
	 $ft_out .='<td class="tp_date_info">'.apply_filters('the_wysiwyg', $valor).'</td></tr>';
	 }
}

function fieldtable_add_download($campo,$valor,$link){
  global $ft_out,$ft_count;
	if($valor!=""){
	 $ft_count++;	
	 $ft_out .='<tr><td class="tp_date_type" ><strong>'.__($campo,'coitcv').'</strong></td>';
	 $ft_out .='<td class="tp_date_info"><div style="float:right">'.$link.'</div>'.apply_filters('the_wysiwyg', $valor).'</td>';
	 $ft_out .='</tr>';
	 }
}


function fieldtable_add_row($a,$is_header=false){
	global $ft_out,$ft_count;
	$class = $is_header ?  "tp_date_type" : "tp_date_info";
	$ft_out .='<tr>';
	foreach($a as $valor){
	 $ft_count++;		 
	 if($is_header)$valor = '<strong>'.$valor.'</strong>';
	 $ft_out .='<td class="'.$class.'">'.apply_filters('the_wysiwyg', $valor).'</td>';
	 }
	$ft_out .='</tr>';
}

function fieldtable_add_date($campo,$valor){
	if(is_string($valor) && strlen($valor)>6 )
		 $valor=date_format( date_create($valor),get_option("date_format"));
	else $valor="-";
	fieldtable_add($campo,$valor);
}

function fieldtable_add_link($campo,$valor,$url){
  $valor='<a href="'.$url.'" title="'.$campo.'">'.$valor."</a>";
	fieldtable_add($campo,$valor);
}

function fieldtable_end($separator=""){
  global $ft_out,$ft_count;
  $ft_out .='</table>'.$separator;
	if ($ft_count)echo $ft_out;
}





