<?php

/*
*  ACF Message Field Class
*
*  All the logic for this field type
*
*  @class 		acf_field_message
*  @extends		acf_field
*  @package		ACF
*  @subpackage	Fields
*/

if( ! class_exists('acf_field_obs_taxonomy') ) :

class acf_field_obs_taxonomy extends acf_field {
	
	
	/*
	*  __construct
	*
	*  This function will setup the field type data
	*
	*  @type	function
	*  @date	5/03/2014
	*  @since	5.0.0
	*
	*  @param	n/a
	*  @return	n/a
	*/
	
	function __construct() {
		
		// vars
		$this->name = 'obs_taxonomy';
		$this->label = __("Embedded WP Taxonomy Fields",'acf-frontend-forms');
		$this->category = 'layout';
		$this->defaults = array(
			'obs_taxonomy'	=> '',
		);
		
		
		// do not delete!
    	parent::__construct();
	}
	
	/*
	*  render_field()
	*
	*  Create the HTML interface for your field
	*
	*  @param	$field - an array holding all the field's data
	*
	*  @type	action
	*  @since	3.6
	*  @date	23/01/13
	*/
	
	function render_field( $field ) {	
		?>
		   
			<div id="wpobstax<?php echo $field['_name']?>"></div>
			<script>
				jQuery( document ).ready(function( $ ) {
				<?php
				    $div=".form-table:first-of-type";					
					echo  'jQuery("body").find("'.$div.'").remove().appendTo("#wpobstax'.$field['_name'].'");';					 
					echo 'jQuery("#wpobstax'.$field['_name'].'").parent().parent().find("td:first-child").remove();'; 
					echo 'jQuery("#wpobstax'.$field['_name'].'").parent().parent().find("td:first-child").attr("colspan","2");';				 
				?>
				});
			</script>
		
		<?php
	}	
}

new acf_field_obs_taxonomy();

endif;

?>