<?php

/*
*  ACF Message Field Class
*
*  All the logic for this field type
*
*  @class 		acf_field_message
*  @extends		acf_field
*  @package		ACF
*  @subpackage	Fields
*/

if( ! class_exists('acf_field_hook') ) :

class acf_field_hook extends acf_field {
	
	
	/*
	*  __construct
	*
	*  This function will setup the field type data
	*
	*  @type	function
	*  @date	5/03/2014
	*  @since	5.0.0
	*
	*  @param	n/a
	*  @return	n/a
	*/
	
	function __construct() {
		
		// vars
		$this->name = 'hook';
		$this->label = __("Hook",'acf-frontend-forms');
		$this->category = 'layout';
		$this->defaults = array(
			'hook'	=> '',
		);
		
		
		// do not delete!
    	parent::__construct();
	}
	
	
	/*
	*  render_field()
	*
	*  Create the HTML interface for your field
	*
	*  @param	$field - an array holding all the field's data
	*
	*  @type	action
	*  @since	3.6
	*  @date	23/01/13
	*/
	
	function render_field( $field ) {	
		do_action($field['action']);
	}
	
	
	/*
	*  render_field_settings()
	*
	*  Create extra options for your field. This is rendered when editing a field.
	*  The value of $field['name'] can be used (like bellow) to save extra data to the $field
	*
	*  @param	$field	- an array holding all the field's data
	*
	*  @type	action
	*  @since	3.6
	*  @date	23/01/13
	*/
	
	function render_field_settings( $field ) {
		
		// default_value
		acf_render_field_setting( $field, array(
			'label'			=> __('Action ID','acf-frontend-forms'),
			'instructions'	=> __('Please note that you have to indicate an action name, for example "my_action" and create a WordPress hook <pre>add_action("my_action","my_funcion"); function my_function(){...}</pre>','acf-frontend-forms'),
			'type'			=> 'text',
			'name'			=> 'action',
		));
		
	}
	
}

new acf_field_hook();

endif;

?>