<?php 

// http://shibashake.com/wordpress-theme/custom-post-type-permalinks-part-2 

add_action("init","iniciar_taxonomia_concepto_personalizado");
function iniciar_taxonomia_concepto_personalizado()
{
		register_taxonomy('concepto_personalizado', array('post'), array(
			  'public'      =>true,
			  'labels'      =>array(
				  'name'                        =>__('concepto_personalizado','ainia_iwatch'),					
				  'menu_name'                   =>__('Conceptos personalizado','ainia_iwatch'),
				  'singular_name'               =>__('Concepto personalizado','ainia_iwatch'),								
				  'search_items'                =>__('Buscar por Concepto personalizado','ainia_iwatch'),
				  'popular_items'               =>__('Conceptos personalizado populares','ainia_iwatch'),
				  'all_items'                   =>__('Todos los Conceptos personalizado','ainia_iwatch'),
				  'edit_item'                   =>__('Editar Concepto personalizado','ainia_iwatch'),
				  'update_item'             	=>__('Actualizar Concepto personalizado','ainia_iwatch'),
				  'add_new_item'                =>__('Añadir Concepto de Filtro personalizado','ainia_iwatch'),
				  'new_item_name'               =>__('Nuevo Concepto personalizado','ainia_iwatch'),
				  'separate_items_with_commas'	=>__('Separar Conceptos personalizado con comas','ainia_iwatch'),
				  'add_or_remove_items'     	=>__('Añadir o eliminar Conceptos personalizado','ainia_iwatch'),
				  'choose_from_most_used'       =>__('Elegir de los conceptos de personalizado más usados','ainia_iwatch'),
			  ),
			  'capabilities' => array ('read'),
			  'hierarchical' =>true,
			  'rewrite'     =>array(
				  'with_front'              	=>true,
				  'slug'                    	=>'concepto-personalizado',
			  ),
			  
		));		
}

//------------- EDITAR METABOXES DEL TIPO POST PARA AÑADIR El Concepto personalizado ---------------------------------------------------------------

add_action( 'admin_menu', 'concepto_personalizado_remove_meta_box',20); 
add_action('create_concepto_personalizado', 'save_concepto_personalizado_metadata', 10, 1);   
//add_action('created_concepto_personalizado', 'refrescar_alertas', 10, 1);    
add_action('edit_concepto_personalizado', 'save_concepto_personalizado_metadata', 10, 1); 
//add_action('edited_concepto_personalizado', 'refrescar_alertas', 10, 1);
add_action('delete_post','refrescar_alertas');
//add_action('delete_concepto_personalizado', 'refrescar_alertas', 10, 2);
//add_action('create_concepto_personalizado', 'refrescar_alertas', 10, 2);
//add_action('edited_concepto_personalizado', 'refrescar_alertas', 10, 2);
function concepto_personalizado_remove_meta_box()
{  
	
	remove_meta_box('slugdiv'          			, 'post', 'normal' );
	remove_meta_box('tagsdiv-concepto-personalizado'			, 'post', 'normal');  
	remove_meta_box('stl-timeline-event-data'	, 'post', 'advanced');  
	remove_meta_box('authordiv' 				, 'post', 'normal');
	//remove_meta_box('commentstatusdiv' 			, 'post', 'normal');
	remove_meta_box('formatdiv'   				, 'post', 'normal');
	remove_meta_box('pageparentdiv'     		, 'post', 'normal');
	remove_meta_box('postcustom'        		, 'post', 'normal');
	remove_meta_box('postexcerpt'       		, 'post', 'normal');	
	remove_meta_box('revisionsdiv'      		, 'post', 'normal');
	remove_meta_box('trackbacksdiv'     		, 'post', 'normal');
}  

add_action('do_meta_boxes','my_post_remove_meta_box_personalizado',1);  
function my_post_remove_meta_box_personalizado()
{  
	remove_meta_box('postimagediv', 'post', 'side');
	//remove_post_type_support( 'post', 'post-thumbnail' );
}

add_action( 'add_meta_boxes', 'add_post_concepto_personalizado_metabox_event' );
function add_post_concepto_personalizado_metabox_event()
{
	add_meta_box( 'post-concepto_personalizado-metabox-id', 'concepto_personalizado', 'add_post_concepto_personalizado_metabox', 'post', 'normal', 'high' );
}

function add_post_concepto_personalizado_metabox( $post )
{
	$conceptos_personalizado_posts = get_the_terms( $post->ID, 'concepto_personalizado');
	$id_concepto_personalizado = count($conceptos_personalizado_posts) ? $conceptos_personalizado_posts[0]->term_id : 0;
	
	$interes = get_post_meta( $post->ID, 'interes', true );
	$url_article = get_post_meta( $post->ID, 'url_article', true );
	$conceptos_personalizado = get_terms("concepto_personalizado", array('hide_empty'=>false));
	wp_nonce_field( 'my_post_concepto_personalizado_metabox_nonce', 'my_post_concepto_personalizado_metabox_nonce' );
	?>
	<p>
		<label for="concepto_personalizado"><?php _e('concepto_personalizado','ainia_iwatch');?></label>
		<select name="concepto_personalizado" id="concepto_personalizado">
			<option value=""> - sin concepto personalizado - </option>
		<?php foreach($conceptos_personalizado as $concepto_personalizado){?>
			<option value="<?php echo $concepto_personalizado->term_id?>" <?php selected( $concepto_personalizado->term_id, $id_concepto_personalizado ); ?>><?php echo $concepto_personalizado->name?></option>
		<?php }?>			
		</select>
	</p>	

	<?php	
}


add_action( 'save_post', 'save_post_concepto_personalizado_metabox' );
function save_post_concepto_personalizado_metabox( $post_id )
{
	// Bail if we're doing an auto save
	if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
	
	// if our nonce isn't there, or we can't verify it, bail
	if( !isset( $_POST['my_post_concepto_personalizado_metabox_nonce'] ) || !wp_verify_nonce( $_POST['my_post_concepto_personalizado_metabox_nonce'], 'my_post_concepto_personalizado_metabox_nonce' ) ) return;
		
	// if our current user can't edit this post, bail
	if( !current_user_can( 'edit_post' ) ) return;	
	
	
	if( isset( $_POST['riesgo'] ) )
		wp_set_object_terms( $post_id, intval( $_POST['concepto_personalizado'] ) , 'concepto_personalizado', false);
		
	if( isset( $_POST['url_article'] ) )
		update_post_meta( $post_id, 'url_article', esc_attr( $_POST['url_article'] ) );
		
	if( isset( $_POST['article_interest'] ) )
		update_post_meta( $post_id, 'interes', esc_attr( $_POST['article_interest'] ) );
}
 

function actualizar_match_conceptos_personalizado( $term_id, $taxonomy ) {
	//echo 'actualizar_match_conceptos_personalizado';
    ainia_update_conceptos_personalizados();
    
}

//function refrescar_alertas($term_id){
	//echo 'REFRESCAR ALERTAS';

	//wp_safe_redirect( admin_url( 'edit-tags.php?action=edit&taxonomy=' . 'concepto_personalizado' . '&tag_ID=' . $term_id . '&post_type=alert&notice=success' ) );
	//	ainia_update_conceptos_personalizados ();
	//exit;
//}


//--------------------- AÑADIR CAMPOS A LA TAXONOMIA -------------------------------------------------------------
add_action('concepto_personalizado_add_form_fields', 'concepto_personalizado_metabox_add', 10, 1);
function concepto_personalizado_metabox_add($tag) { 
?>	
    <div class="form-field" id="conc_seg_ing">
        <label for="concepto_personalizado_eng"><?php _e('Nombre en Inglés','ainia_iwatch'); ?></label>
        <input name="concepto_personalizado_eng" id="concepto_personalizado_eng" type="text" value="" size="40" aria-required="true" />
    </div>    
<?php

}   
//add_action( 'concepto_personalizado_update_errors', 'validate_field' );

function validate_field(&$errors, $update = null, &$user = null)
{
if ($_POST['concepto_personalizado_eng']=='' or $_POST['concepto_personalizado_eng']==NULL) // Change to check for empty or any regular expression. 
{
$errors->add('empty_concepto_personalizado_eng', "<strong>ERROR</strong>: Please select a valid value for exp years!");
}
}


function get_concepto_personalizado_eng($term_id)
{
	return get_option('concepto_personalizado_eng_'.$term_id);	
} 
function get_etiquetado($term_id)
{
	return get_option('etiquetado_'.$term_id);	
}  

add_action('concepto_personalizado_edit_form_fields', 'concepto_personalizado_metabox_edit', 10, 1);    
function concepto_personalizado_metabox_edit($tag) { 
	$conc_eng = get_concepto_personalizado_eng($tag->term_id);
	
?>
<a href=<?php echo get_site_url()?>/wp-admin/edit-tags.php?taxonomy=concepto_personalizado>← Volver a Lista</a>
	<table class="form-table">
        <tr class="form-field">
        <th scope="row" valign="top">
            <label for="concepto_personalizado_eng"><?php _e('Nombre en Inglés','ainia_iwatch'); ?></label>
        </th>
        <td>
            <input name="concepto_personalizado_eng" id="concepto_personalizado_eng" type="text" value="<?php echo $conc_eng;?>" size="40" aria-required="true" />
			
        </td>
        </tr>				
    </table>
<?php 


}

 


function save_concepto_personalizado_metadata($term_id)
{

	$user_id=get_current_user_id();
	if (!$term_id)return;	
	//echo 'term_ID'.$term_id;
	if ( isset( $_POST['concepto_personalizado_eng'] ) && $_POST['concepto_personalizado_eng']!=''){
		update_option( 'concepto_personalizado_eng_'.$term_id, $_POST['concepto_personalizado_eng'] );	
		update_option( 'etiquetado_'.$term_id, 'Pendiente de actualizar' );
		//update_option( 'concepto_personalizado_usuario_'.$term_id, get_current_user_id());
	
		ainia_set_user_terms(get_current_user_id(), $term_id);
	
	
	
		
	} else{
		
		exit;
	
    
     }
	

		//refrescar_alertas($term_id);
		clean_object_term_cache($term_id, $taxonomy);
}





/*
SELECT t.*,tt.* FROM wp_terms AS t INNER JOIN wp_term_taxonomy AS tt ON t.term_id = tt.term_id INNER JOIN wp_term_relationships AS tr ON tr.term_taxonomy_id = tt.term_taxonomy_id WHERE tt.taxonomy IN ('concepto_personalizado') AND tr.object_id IN (79464) and t.term_id in (SELECT t.term_id FROM wp_terms AS t INNER JOIN wp_term_taxonomy AS tt ON t.term_id = tt.term_id INNER JOIN wp_term_relationships AS tr ON tr.term_taxonomy_id = tt.term_taxonomy_id WHERE tt.taxonomy IN ('concepto_personalizado') AND tr.object_id IN (1) ) ORDER BY t.name ASC
*/
 function get_user_post_conceptos_personalizado($user_id=0,$post_id=0){
	
 		global $wpdb;
	//echo '$post_title';
	$query_str='SELECT t.*,tt.* FROM wp_terms AS t INNER JOIN wp_term_taxonomy AS tt ON t.term_id = tt.term_id INNER JOIN 
	wp_term_relationships AS tr ON tr.term_taxonomy_id = tt.term_taxonomy_id WHERE tt.taxonomy IN (\'concepto_personalizado\')
	 AND tr.object_id IN (%d) and t.term_id in 
	 (SELECT t.term_id FROM wp_terms AS t INNER JOIN wp_term_taxonomy AS tt ON t.term_id = tt.term_id INNER JOIN
	  wp_term_relationships AS tr ON tr.term_taxonomy_id = tt.term_taxonomy_id WHERE tt.taxonomy IN (\'concepto_personalizado\')
	   AND tr.object_id IN (%d) ) ORDER BY t.name ASC
	;';
	$conceptos_personalizado = $wpdb->get_results($wpdb->prepare( $query_str,$post_id,$user_id));
	//echo $wpdb->last_query.'----';
	//echo 'NUM POSTS'.sizeof($conceptos_personalizado);
	return $conceptos_personalizado;
 	
	
}

 function get_post_by_user_conceptos_personalizado($user_id=0){
	
 		global $wpdb;
	//echo '$post_title';
	$query_str='SELECT tr.object_id FROM wp_terms AS t INNER JOIN wp_term_taxonomy AS tt ON t.term_id = tt.term_id INNER JOIN 
	wp_term_relationships AS tr ON tr.term_taxonomy_id = tt.term_taxonomy_id WHERE tt.taxonomy IN (\'concepto_personalizado\')
	 and t.term_id in 
	 (SELECT t.term_id FROM wp_terms AS t INNER JOIN wp_term_taxonomy AS tt ON t.term_id = tt.term_id INNER JOIN
	  wp_user_terms AS tr ON tr.term_id = tt.term_id WHERE tt.taxonomy IN (\'concepto_personalizado\')
	   AND tr.user_id IN (%d) )
	;';
	   
	$conceptos_personalizado = $wpdb->get_results($wpdb->prepare( $query_str,$user_id));
	
	
	$conceptos = array();
	foreach($conceptos_personalizado as $concepto_personalizado)$conceptos[]=$concepto_personalizado->object_id;
	echo $wpdb->last_query.'----';
	//echo ' NUM POSTS '.sizeof($conceptos_personalizado);
	//echo '---';
	//echo implode(",",$conceptos);
	return $conceptos;
 	
	
}

 function get_post_by_user_conceptos_personalizado_after_date($user_id=0,$date){
	
 		global $wpdb;
	//echo '$post_title';
	$query_str='SELECT tr.object_id FROM wp_terms AS t INNER JOIN wp_term_taxonomy AS tt ON t.term_id = tt.term_id INNER JOIN 
	wp_term_relationships AS tr ON tr.term_taxonomy_id = tt.term_taxonomy_id WHERE tt.taxonomy IN (\'concepto_personalizado\')
	 and t.term_id in 
	 (SELECT t.term_id FROM wp_terms AS t INNER JOIN wp_term_taxonomy AS tt ON t.term_id = tt.term_id INNER JOIN
	  wp_term_relationships AS tr ON tr.term_taxonomy_id = tt.term_taxonomy_id WHERE tt.taxonomy IN (\'concepto_personalizado\')
	   AND tr.object_id IN (%d) ) and tr.object_id in (select id from wp_posts where post_date >%s and post_type=\'alert\');';
	$conceptos_personalizado = $wpdb->get_results($wpdb->prepare( $query_str,$user_id,$date));
	
	
	$conceptos = array();
	foreach($conceptos_personalizado as $concepto_personalizado)$conceptos[]=$concepto_personalizado->object_id;
	echo $wpdb->last_query.'----';
	//echo ' NUM POSTS '.sizeof($conceptos_personalizado);
	//echo '---';
	//echo implode(",",$conceptos);
	return $conceptos;
 	
	
}


/*** Para mostrar columna con conceptos en ingles **///

add_filter('manage_edit-concepto_personalizado_columns', 'ainia_register_con_perso_columns');
function ainia_register_con_perso_columns($columns){
  $columns['ingles']  = 'Nombre en Inglés';
  $columns['etiquetado']  = 'Etiquetado';
 
  return $columns;
} 
 function add_concepto_personalizado_column_content($content,$column_name,$term_id){
 //	echo $column_name;
    $content='contenido';
    switch ($column_name) {
        case 'ingles':
            //do your stuff here with $term or $term_id
            $content = get_concepto_personalizado_eng($term_id);
         // echo $content;
            break;
         case 'etiquetado':
            //do your stuff here with $term or $term_id
            $content = get_etiquetado($term_id);
         // echo $content;
        break;
        default:
            break;
    }
    echo $content;
}
add_filter('manage_concepto_personalizado_custom_column', 'add_concepto_personalizado_column_content',10,3);
/*add_filter( 'get_terms_args', 'filtrar_lista_terminos', 10, 2 );
 function filtrar_lista_terminos( $args, $taxonomies ) {
	$user_id=get_current_user_id();
 echo $user_id.'-';
    if ( is_admin() && 'concepto_personalizado'==$taxonomies[0] ){
        $ids=get_user_conceptos_personalizado2($user_id);
        echo sizeof($ids);
        $conceptos=array();
        if (sizeof($conceptos)>0){
          foreach($ids as $id){
        	$conceptos[]=$id->term_id;
        	//echo $id->term_id.'-';
        	}
        }
        else{
        	$conceptos[]=0;        
        }
        	  
    	$args['include'] = $conceptos;

    }
 
    return $args;
}*/
 function get_user_conceptos_personalizado2($user_id=0){
	
 		global $wpdb;
	//echo '$post_title';
	$query_str='SELECT * FROM wp_terms AS t INNER JOIN wp_term_taxonomy AS tt ON t.term_id = tt.term_id INNER JOIN
	  wp_user_terms AS tr ON tr.term_id = tt.term_id WHERE tt.taxonomy IN (\'concepto_personalizado\')
	   AND tr.user_id IN (%d) ORDER BY t.name ASC;';
	$conceptos_personalizado = $wpdb->get_results($wpdb->prepare( $query_str,$user_id));
	//echo $wpdb->last_query.'----';
	//echo sizeof($pageposts);
	return $conceptos_personalizado;
 	
	
}




  
  
 

