<?php 

// http://shibashake.com/wordpress-theme/custom-post-type-permalinks-part-2 

add_action("init","iniciar_taxonomia_concepto_personalizado");
function iniciar_taxonomia_concepto_personalizado()
{
		register_taxonomy('concepto_personalizado', array('post'), array(
			  'public'      =>true,
			  'labels'      =>array(
				  'name'                        =>__('concepto_personalizado','ainia_iwatch'),					
				  'menu_name'                   =>__('Conceptos personalizado','ainia_iwatch'),
				  'singular_name'               =>__('Concepto personalizado','ainia_iwatch'),								
				  'search_items'                =>__('Buscar por Concepto personalizado','ainia_iwatch'),
				  'popular_items'               =>__('Conceptos personalizado populares','ainia_iwatch'),
				  'all_items'                   =>__('Todos los Conceptos personalizado','ainia_iwatch'),
				  'edit_item'                   =>__('Editar Concepto personalizado','ainia_iwatch'),
				  'update_item'             	=>__('Actualizar Concepto personalizado','ainia_iwatch'),
				  'add_new_item'                =>__('Añadir Concepto de Filtro personalizado','ainia_iwatch'),
				  'new_item_name'               =>__('Nuevo Concepto personalizado','ainia_iwatch'),
				  'separate_items_with_commas'	=>__('Separar Conceptos personalizado con comas','ainia_iwatch'),
				  'add_or_remove_items'     	=>__('Añadir o eliminar Conceptos personalizado','ainia_iwatch'),
				  'choose_from_most_used'       =>__('Elegir de los conceptos de personalizado más usados','ainia_iwatch'),
			  ),
			  'capabilities' => array ('read'),
			  'hierarchical' =>true,
			  'rewrite'     =>array(
				  'with_front'              	=>true,
				  'slug'                    	=>'concepto-personalizado',
			  ),
			  
		));		
}
add_action('create_concepto_personalizado', 'save_concepto_personalizado_metadata', 10, 1); 
 function get_user_conceptos_personalizado2($user_id=0){
	
 		global $wpdb;
	//echo '$post_title';
	$query_str='SELECT DISTINCT t.* FROM wp_terms AS t INNER JOIN wp_term_taxonomy AS tt ON t.term_id = tt.term_id INNER JOIN
	  wp_user_terms AS tr ON tr.term_id = tt.term_id WHERE tt.taxonomy IN (\'concepto_personalizado\')
	   AND tr.user_id IN (%d) ORDER BY t.name ASC;';
	$conceptos_personalizado = $wpdb->get_results($wpdb->prepare( $query_str,$user_id));
	//echo $wpdb->last_query.'----';
	//echo sizeof($pageposts);
	return $conceptos_personalizado;
 	
	
}

function save_concepto_personalizado_metadata($term_id)
{

	$user_id=get_current_user_id();
	if (!$term_id)return;	
	//echo 'term_ID'.$term_id;
	//if ( isset( $_POST['concepto_personalizado_eng'] ) && $_POST['concepto_personalizado_eng']!=''){
		//update_option( 'concepto_personalizado_eng_'.$term_id, $_POST['concepto_personalizado_eng'] );	
		update_option( 'etiquetado_'.$term_id, 'Pendiente de actualizar' );
		//update_option( 'concepto_personalizado_usuario_'.$term_id, get_current_user_id());
	
		ainia_set_user_terms(get_current_user_id(), $term_id);

		clean_object_term_cache($term_id, 'concepto_personalizado');
		
	//	exit;
}
function borrar_metadata($term_id)
{

	$user_id=get_current_user_id();
	if (!$term_id)return;	
	//echo 'term_ID'.$term_id;
	//if ( isset( $_POST['concepto_personalizado_eng'] ) && $_POST['concepto_personalizado_eng']!=''){
		//update_option( 'concepto_personalizado_eng_'.$term_id, $_POST['concepto_personalizado_eng'] );	
		delete_option( 'etiquetado_'.$term_id);
		//update_option( 'concepto_personalizado_usuario_'.$term_id, get_current_user_id());
	
		ainia_remove_user_terms(get_current_user_id(), $term_id);
	

}

function get_post_by_user_conceptos_personalizado($user_id=0){
	
 		global $wpdb;
	//echo '$post_title';
	$query_str='SELECT tr.object_id FROM wp_terms AS t INNER JOIN wp_term_taxonomy AS tt ON t.term_id = tt.term_id INNER JOIN 
	wp_term_relationships AS tr ON tr.term_taxonomy_id = tt.term_taxonomy_id WHERE tt.taxonomy IN (\'concepto_personalizado\')
	 and t.term_id in 
	 (SELECT t.term_id FROM wp_terms AS t INNER JOIN wp_term_taxonomy AS tt ON t.term_id = tt.term_id INNER JOIN
	  wp_user_terms AS tr ON tr.term_id = tt.term_id WHERE tt.taxonomy IN (\'concepto_personalizado\')
	   AND tr.user_id IN (%d) )
	;';
	   
	$conceptos_personalizado = $wpdb->get_results($wpdb->prepare( $query_str,$user_id));
	
	
	$conceptos = array();
	foreach($conceptos_personalizado as $concepto_personalizado)$conceptos[]=$concepto_personalizado->object_id;
	echo $wpdb->last_query.'----';
	error_log(print_r('--------------------  ENVIAR: D- POSTS ------------
			'.$wpdb->last_query.'----', TRUE),3,"C:\\log\\cron_log.log");
	//echo ' NUM POSTS '.sizeof($conceptos_personalizado);
	//echo '---';
	//echo implode(",",$conceptos);
	return $conceptos;
 	
	
}

function post_has_concepto_personalizado($post_id,$concept_id){
		global $wpdb;
		/*	error_log(print_r('--------------------  post_has_concepto_personalizado------------'.$post_id.'--'.$concept_id.'-
			----', TRUE),3,"C:\\log\\cron_log.log");*/
	$query_str='SELECT * FROM wp_term_relationships where object_id=%d and term_taxonomy_id=%d;';
	   
	$results = $wpdb->get_results($wpdb->prepare( $query_str,$post_id,$concept_id));
	/*error_log(print_r('--------------------  ENVIAR: H- POSTS ---------------', TRUE),3,"C:\\log\\cron_log.log");
		error_log(print_r('--------------------  ENVIAR: H- POSTS ------------
			'.$wpdb->last_query.'----', TRUE),3,"C:\\log\\cron_log.log");
	error_log(print_r('--------------------  sizeof($results)------------
			'.sizeof($results).'----', TRUE),3,"C:\\log\\cron_log.log");
			
	error_log(print_r('--------------------  sizeof($results) - RETURN------------
			'.(sizeof($results)>0).'----', TRUE),3,"C:\\log\\cron_log.log");*/
	
	return (sizeof($results)>0);
}

 function get_post_by_user_conceptos_personalizado_after_date($user_id=0,$date){
	
 		global $wpdb;
	//echo '$post_title';
	$query_str='SELECT tr.object_id FROM wp_terms AS t INNER JOIN wp_term_taxonomy AS tt ON t.term_id = tt.term_id INNER JOIN 
	wp_term_relationships AS tr ON tr.term_taxonomy_id = tt.term_taxonomy_id WHERE tt.taxonomy IN (\'concepto_personalizado\')
	 and t.term_id in 
	 (SELECT t.term_id FROM wp_terms AS t INNER JOIN wp_term_taxonomy AS tt ON t.term_id = tt.term_id INNER JOIN
	  wp_term_relationships AS tr ON tr.term_taxonomy_id = tt.term_taxonomy_id WHERE tt.taxonomy IN (\'concepto_personalizado\')
	   AND tr.object_id IN (%d) ) and tr.object_id in (select id from wp_posts where post_date >%s and post_type=\'alert\');';
	$conceptos_personalizado = $wpdb->get_results($wpdb->prepare( $query_str,$user_id,$date));
	
	
	$conceptos = array();
	foreach($conceptos_personalizado as $concepto_personalizado)$conceptos[]=$concepto_personalizado->object_id;
	echo $wpdb->last_query.'----';
	//echo ' NUM POSTS '.sizeof($conceptos_personalizado);
	//echo '---';
	//echo implode(",",$conceptos);
	return $conceptos;
 	
	
}





  
  
 

