<?php
function current_user_id() 
{
    if(!is_user_logged_in())return 0;
	
	global $current_user;
	get_currentuserinfo();
	return $current_user->ID;
} 

function current_user_ip() {
	return ip2long( $_SERVER['REMOTE_ADDR'] );
} 

function current_url() {
	global $wp;
	$pageURL = add_query_arg( $wp->query_string, '', home_url( $wp->request ) );
	if(!$pageURL){	
		$pageURL = 'http';
		if ($_SERVER["HTTPS"] == "on") $pageURL .= "s";
		$pageURL .= "://";
		if ($_SERVER["SERVER_PORT"] != "80") 
			 $pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
		else $pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];		 
	} 
	if(!$pageURL)$pageURL = site_url();
	return $pageURL;
} 

//---AUTOMATIC HOOKS  ------------------------------------------------------------------------------------

define('TRACK_PAGES'		,false);
define('TRACK_POSTS'		,true);	
define('TRACK_404'			,false);
define('TRACK_SEARCH'		,false);
define('TRACK_AUTHOR'		,false);
define('TRACK_DATE'			,false);
define('TRACK_TAGS'			,false);
define('TRACK_CATEGORIES'	,false); 
define('TRACK_OTHER'		,false);

add_action( 'wp_head', 'register_user_view_url' );
function register_user_view_url()
{
	global $post,$wp;

	$current_url = $wp->query_string;
	
	if ( is_user_logged_in() && !is_admin() ) {
	
		$current_post_id = is_single()||is_page() ? $post->ID : 0 ;
		$current_page_type = false;
			
		if(TRACK_PAGES && is_page()){
		  $current_page_type = get_post_type_object($post->post_type)->labels->singular_name;
		  $current_page_title=$post->post_title;
		}		
		else if(TRACK_POSTS && is_single()){
		  $current_page_type = get_post_type_object($post->post_type)->labels->singular_name;
		  $current_page_title=$post->post_title;
		}		
		else if(TRACK_404 && is_404()){
		  $current_page_type='404';
		  $current_page_title='Ruta inexistente';
		}
		else if(TRACK_SEARCH && is_search()){
		  $current_page_type='Búsqueda';
		  $current_page_title=get_search_query();
		}
		else if(TRACK_AUTHOR && is_author()){
		  $current_page_type='Autor';
		  $current_page_title=get_userdata(get_query_var('author'))->display_name;
		}
		else if(TRACK_DATE && is_date()){
		  $current_page_type='Fecha';
		  $current_page_title=get_query_var('date');
		}
		else if(TRACK_TAGS && is_tag()){
		  $current_page_type='Etiqueta';
		  $current_page_title=get_term_by('id', get_query_var('tag'), 'tag')->term_name;
		}
		else if(TRACK_CATEGORIES && is_category()){
		  $current_page_type='Categoría';
		  $current_page_title=get_cat_name(get_query_var('cat'));
		}		
		else if(TRACK_OTHER){
		  $current_page_type='Otro';
		  $current_page_title=current_url();
		}
		
		if($current_page_type){		
			$existe_id = get_user_relation_id( current_user_id(),current_user_ip(),$current_post_id,"browse");		
			if(!$existe_id){
				$rel=add_user_relation(current_user_id(),current_user_ip(),$current_post_id,"browse");
				add_user_relation_meta($rel,"text",$current_page_type."::".$current_page_title);
				add_user_relation_meta($rel,"url",current_url());				
				}
			else update_user_relation($existe_id);
			return $rel;
		}
	}
	
	return false;
}


add_action( 'comment_post', 'register_user_comment' );
function register_user_comment($comment_id)
{
	if ( is_user_logged_in() ) {
		$rel=add_user_relation(current_user_id(),current_user_ip(),$comment_id,"comment");	
		return $rel;
	}
	else return false;
}


add_action( 'save_post', 'register_user_post' );
function register_user_post($post_id)
{
	if ( !wp_is_post_revision( $post_id ) ) {
		$rel=add_user_relation(current_user_id(),current_user_ip(),$post_id,"post");	
		return $rel;
	}
	return false;
}

add_action('wp_login', 'register_user_login');
function register_user_login()
{
	$rel=add_user_relation(current_user_id(),current_user_ip(),1,"login");
	add_user_relation_meta($rel,"ip",current_user_ip());
	return $rel;
}

add_action('fm_form_submission', 'register_form_submission');
function register_form_submission($input)
{
	if ( is_user_logged_in() ) {
		$form = $input ['form'];
		$data = $input ['data'];
		$usr  = current_user_id();
		$usr=2;
		
		$valores = array('Formulario'=>$form['title'],
						 'ID'=>'Wordpress Form Manager nº '.$form['ID']);
		foreach($form['items'] as $elem)		
		  $valores[$elem['label']]=$data[$elem['unique_name']];
		$text = json_encode($valores);
		$rel=add_extended_user_form($usr,$text);			
		return $rel;
	}
	else return false;
}



add_filter( 'wp_mail', 'register_php_mail' );
function register_php_mail($atts)
{
	extract(shortcode_atts(array(
		'to'	=> '',
		'subject'	=> '',
		'message'	=> '',
		'headers' => '',
		'attachments' => null,
	), $atts));
		
	$usuario = get_user_by_email( $to );
	
	if($usuario && $subject!=__('AINIA iWatch Newsletter','ainia'))
	 add_extended_user_email_to($usuario->ID,"hoy",get_option('ainia_newsletter_email'),$subject,$message)  ;

	return $atts;
}


