<?php
/**
 * The Template for displaying all single posts.
 *
 * @package Decode
 */

get_header(); ?>

<div class="grid grid-pad">
	
    <?php if ( is_active_sidebar( 'sidebar-1' ) ) : ?>
        <div class="col-8-12">
    <?php else: ?>
    	<div class="col-1-1">
    <?php endif; ?>

		<div id="primary" class="content-area">
			
			<main id="main" class="site-main" role="main">
			
			<?php $user_categories = get_user_categories(get_current_user_id()); ?>
			<?php while ( have_posts() ) : the_post(); ?>

			<?php if( is_post_in_user_categories(get_the_ID())):?>		 
					 
				
						<header class="page-header">
							<h1  class="page-title">PROYECTO: <?php the_title(); ?></h1>				
						</header>
						<div class="entry-content">
						<div id="xtabs-container">			
							<ul class="xtabs-menu">						
								<li class="current"><a href="#xtab-1"><?php _e( 'Entradas', 'ainia_iwatch' );?></li>
								<li 			   ><a href="#xtab-2"><?php _e( 'Descripci&oacute;n', 'ainia_iwatch' );?></a></li>
								<li 			   ><a href="#xtab-3"><?php _e( 'Comentarios', 'ainia_iwatch' );?></a></li>	
								<li 			   ><a href="#xtab-4"><?php _e( 'Exportar Proyecto', 'ainia_iwatch' );?></a></li>									
							</ul>
							
							<div class="xtab">
								
								
								
								<div id="xtab-1" class="xtab-content">										
								
								<?php the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'decode' ) ); ?>
								
																																
								<?php

								echo ('<br><h8><i>Si desea incorporar nuevas entradas a este proyecto, acceda a la entrada y seleccione a qué proyecto quiere asignarla.</i></h8> ');

								$entradas_proyecto =  get_ids_entradas_of_proyecto(get_the_ID());
								
								if(sizeof($entradas_proyecto)>0){
									$args = array('posts_per_page'=>-1,'post__in'=>$entradas_proyecto);	
									$the_query = new WP_Query( $args );
									$remove=remove_action('the_content','prueba_ajax');
								
									if($the_query->have_posts()):
									
										while ( $the_query->have_posts() ) : $the_query->the_post();
										 if( true||is_post_in_user_categories(get_the_ID()))
										   get_template_part( 'content', get_post_format() );										 								
									    endwhile;									
									    wp_reset_postdata(); 
									else:
										get_template_part( 'no-results', 'archive' ); 
									endif;
								} else {
									echo '<br><br><h6>No hay ninguna entrada asociada a este proyecto.</h6>';
								}
									
							     ?>

									
								</div>
								
								<div id="xtab-2" class="xtab-content">										
									<?php 
									
										fieldtable_start('Proyecto');
										fieldtable_add('Código',get_field('codigo'));
										fieldtable_add('Descripción del proyecto',get_field('descripcion'));//
										fieldtable_add('Conclusiones',get_field('conclusiones'));
																				
																		
										fieldtable_end();
										
																		
									?>
									
									<?php

										
										if( have_rows('referencias') ):
										
											fieldtable_start('Referencias');
										
											fieldtable_add('Referencias','Anexos y referencias');
									
											while ( have_rows('referencias') ) : the_row();			
												
												$fichero  = get_sub_field('fichero');
												$info     = pathinfo($fichero);												
												$ext      = $info['extension'];										
												
												     if(in_array($ext,array('doc','docx')))$foto= 'msword.png';
												else if(in_array($ext,array('xls','xlsx','csv')))$foto= 'vnd.ms-excel.png';
												else if(in_array($ext,array('ppt','pptx')))$foto= 'vnd.ms-powerpoint.png';
												else if(in_array($ext,array('pdf')))$foto= 'pdf.png';
												else $foto= 'otro.png';												
																								
												fieldtable_add(get_sub_field('titulo'),
															   sprintf( '<div style="float:right"><a href="%s"><img src="%s"></a></div>',
																	     $fichero, plugins_url().'/ainia_base/images/'.$foto).															   
															   get_sub_field('autor').'<br/><em>'.
															   get_sub_field('publicacion').'</em>');
										    endwhile;
											
											fieldtable_end();

										endif;
										
									?>
									
								</div>
								
								<div id="xtab-3" class="xtab-content">
								
									<?php _e( 'Comentarios sobre este proyecto', 'ainia_iwatch' );?>								
									 <?php if ( comments_open() || '0' != get_comments_number() )
									       comments_template();?>
								</div>
								
								<div id="xtab-4" class="xtab-content">
								<?php
									echo ('<br><h8><i>Esta exportación genera un pdf conteniendo tanto la descripción y conclusiones descritos para el proyecto,
									 como las entradas asociadas al mismo, el título de cada una de ellas, su contenido y el enlace a la notícia origional. El documento generado también incluye los
									 comentarios sobre el proyecto, si los hay.</i></h8> <br><br>');
								
																								/***********************************/
								 // Check if PDF Export Plugin exists first
if( function_exists('simple_pdf_export_process')) { ?>
 
                <?php
                    $post_type_to_export = 'project';
                    $final_pdf = SIMPLE_PDF_EXPORTER_EXPORT.$post_type_to_export.SIMPLE_PDF_EXPORTER_EXTRA_FILE_NAME.date('dMY').'.pdf';
                    //echo $final_pdf;
              ?>
                <button type="button" onclick="window.location.href='?export=pdf&post_id=<?php echo get_the_ID(); ?>&force'"><h2>Exportar </h2><?php echo'<img src="'. plugins_url().'/ainia_base/images/'.'pdf.png'.'">'; ?></button>
                
   
<?php } ?>
								
								
								
								</div>
						
							</div>
						</div><!-- xtabs -->				
										
						
						</div>		
						
			
					 
					 <?php				
				else:
					get_template_part( 'all-read', 'index' );		
				endif;					 				
				?>

			<?php endwhile; // end of the loop. ?>
			
			</main>
			
		</div><!-- #primary -->
			</div>

	<?php if ( is_active_sidebar( 'sidebar-1' ) ) : ?> 
    	<?php get_sidebar(); ?>
    <?php endif; ?>
		
		<script>
			jQuery(document).ready(function($) {
				$(".xtabs-menu a").click(function(event) {
					event.preventDefault();
					$(this).parent().addClass("current");
					$(this).parent().siblings().removeClass("current");
					var xtab = $(this).attr("href");
					$(".xtab-content").not(xtab).css("display", "none");
					$(xtab).fadeIn();
				});	
				if(window.location.hash)
				 $('a[href='+window.location.hash+']').click();						
			});
	</script>

<?php get_footer(); ?>